﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/acm-pca/ACMPCA_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ACMPCA {
namespace Model {

/**
 * <p>Defines the X.500 relative distinguished name (RDN).</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CustomAttribute">AWS
 * API Reference</a></p>
 */
class CustomAttribute {
 public:
  AWS_ACMPCA_API CustomAttribute() = default;
  AWS_ACMPCA_API CustomAttribute(Aws::Utils::Json::JsonView jsonValue);
  AWS_ACMPCA_API CustomAttribute& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ACMPCA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Specifies the object identifier (OID) of the attribute type of the relative
   * distinguished name (RDN).</p>
   */
  inline const Aws::String& GetObjectIdentifier() const { return m_objectIdentifier; }
  inline bool ObjectIdentifierHasBeenSet() const { return m_objectIdentifierHasBeenSet; }
  template <typename ObjectIdentifierT = Aws::String>
  void SetObjectIdentifier(ObjectIdentifierT&& value) {
    m_objectIdentifierHasBeenSet = true;
    m_objectIdentifier = std::forward<ObjectIdentifierT>(value);
  }
  template <typename ObjectIdentifierT = Aws::String>
  CustomAttribute& WithObjectIdentifier(ObjectIdentifierT&& value) {
    SetObjectIdentifier(std::forward<ObjectIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p/> <p>Specifies the attribute value of relative distinguished name (RDN).</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  CustomAttribute& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_objectIdentifier;

  Aws::String m_value;
  bool m_objectIdentifierHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace ACMPCA
}  // namespace Aws
