/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportStats.h"

#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSWebTransportDatagramStats.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportStats>> convertDictionary<WebTransportStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportStats result;
    JSValue bytesReceivedValue;
    if (isNullOrUndefined)
        bytesReceivedValue = jsUndefined();
    else {
        bytesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesReceived"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesReceivedValue.isUndefined()) {
        auto bytesReceivedConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReceivedValue);
        if (bytesReceivedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesReceived = bytesReceivedConversionResult.releaseReturnValue();
    }
    JSValue bytesSentValue;
    if (isNullOrUndefined)
        bytesSentValue = jsUndefined();
    else {
        bytesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesSent"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesSentValue.isUndefined()) {
        auto bytesSentConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesSentValue);
        if (bytesSentConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesSent = bytesSentConversionResult.releaseReturnValue();
    }
    JSValue datagramsValue;
    if (isNullOrUndefined)
        datagramsValue = jsUndefined();
    else {
        datagramsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "datagrams"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!datagramsValue.isUndefined()) {
        auto datagramsConversionResult = convert<IDLDictionary<WebTransportDatagramStats>>(lexicalGlobalObject, datagramsValue);
        if (datagramsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.datagrams = datagramsConversionResult.releaseReturnValue();
    }
    JSValue estimatedSendRateValue;
    if (isNullOrUndefined)
        estimatedSendRateValue = jsUndefined();
    else {
        estimatedSendRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "estimatedSendRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!estimatedSendRateValue.isUndefined()) {
        auto estimatedSendRateConversionResult = convert<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, estimatedSendRateValue);
        if (estimatedSendRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.estimatedSendRate = estimatedSendRateConversionResult.releaseReturnValue();
    }
    JSValue minRttValue;
    if (isNullOrUndefined)
        minRttValue = jsUndefined();
    else {
        minRttValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minRtt"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!minRttValue.isUndefined()) {
        auto minRttConversionResult = convert<IDLDouble>(lexicalGlobalObject, minRttValue);
        if (minRttConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.minRtt = minRttConversionResult.releaseReturnValue();
    }
    JSValue numIncomingStreamsCreatedValue;
    if (isNullOrUndefined)
        numIncomingStreamsCreatedValue = jsUndefined();
    else {
        numIncomingStreamsCreatedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numIncomingStreamsCreated"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!numIncomingStreamsCreatedValue.isUndefined()) {
        auto numIncomingStreamsCreatedConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, numIncomingStreamsCreatedValue);
        if (numIncomingStreamsCreatedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.numIncomingStreamsCreated = numIncomingStreamsCreatedConversionResult.releaseReturnValue();
    }
    JSValue numOutgoingStreamsCreatedValue;
    if (isNullOrUndefined)
        numOutgoingStreamsCreatedValue = jsUndefined();
    else {
        numOutgoingStreamsCreatedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numOutgoingStreamsCreated"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!numOutgoingStreamsCreatedValue.isUndefined()) {
        auto numOutgoingStreamsCreatedConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, numOutgoingStreamsCreatedValue);
        if (numOutgoingStreamsCreatedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.numOutgoingStreamsCreated = numOutgoingStreamsCreatedConversionResult.releaseReturnValue();
    }
    JSValue packetsLostValue;
    if (isNullOrUndefined)
        packetsLostValue = jsUndefined();
    else {
        packetsLostValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsLost"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!packetsLostValue.isUndefined()) {
        auto packetsLostConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, packetsLostValue);
        if (packetsLostConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.packetsLost = packetsLostConversionResult.releaseReturnValue();
    }
    JSValue packetsReceivedValue;
    if (isNullOrUndefined)
        packetsReceivedValue = jsUndefined();
    else {
        packetsReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsReceived"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!packetsReceivedValue.isUndefined()) {
        auto packetsReceivedConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, packetsReceivedValue);
        if (packetsReceivedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.packetsReceived = packetsReceivedConversionResult.releaseReturnValue();
    }
    JSValue packetsSentValue;
    if (isNullOrUndefined)
        packetsSentValue = jsUndefined();
    else {
        packetsSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsSent"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!packetsSentValue.isUndefined()) {
        auto packetsSentConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, packetsSentValue);
        if (packetsSentConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.packetsSent = packetsSentConversionResult.releaseReturnValue();
    }
    JSValue rttVariationValue;
    if (isNullOrUndefined)
        rttVariationValue = jsUndefined();
    else {
        rttVariationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rttVariation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!rttVariationValue.isUndefined()) {
        auto rttVariationConversionResult = convert<IDLDouble>(lexicalGlobalObject, rttVariationValue);
        if (rttVariationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.rttVariation = rttVariationConversionResult.releaseReturnValue();
    }
    JSValue smoothedRttValue;
    if (isNullOrUndefined)
        smoothedRttValue = jsUndefined();
    else {
        smoothedRttValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "smoothedRtt"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!smoothedRttValue.isUndefined()) {
        auto smoothedRttConversionResult = convert<IDLDouble>(lexicalGlobalObject, smoothedRttValue);
        if (smoothedRttConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.smoothedRtt = smoothedRttConversionResult.releaseReturnValue();
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timestampValue.isUndefined()) {
        auto timestampConversionResult = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        if (timestampConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timestamp = timestampConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

