package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateApplicationAccessPoint invokes the kms.CreateApplicationAccessPoint API synchronously
func (client *Client) CreateApplicationAccessPoint(request *CreateApplicationAccessPointRequest) (response *CreateApplicationAccessPointResponse, err error) {
	response = CreateCreateApplicationAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// CreateApplicationAccessPointWithChan invokes the kms.CreateApplicationAccessPoint API asynchronously
func (client *Client) CreateApplicationAccessPointWithChan(request *CreateApplicationAccessPointRequest) (<-chan *CreateApplicationAccessPointResponse, <-chan error) {
	responseChan := make(chan *CreateApplicationAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateApplicationAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateApplicationAccessPointWithCallback invokes the kms.CreateApplicationAccessPoint API asynchronously
func (client *Client) CreateApplicationAccessPointWithCallback(request *CreateApplicationAccessPointRequest, callback func(response *CreateApplicationAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateApplicationAccessPointResponse
		var err error
		defer close(result)
		response, err = client.CreateApplicationAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateApplicationAccessPointRequest is the request struct for api CreateApplicationAccessPoint
type CreateApplicationAccessPointRequest struct {
	*requests.RpcRequest
	Policies             string `position:"Query" name:"Policies"`
	Description          string `position:"Query" name:"Description"`
	Name                 string `position:"Query" name:"Name"`
	AuthenticationMethod string `position:"Query" name:"AuthenticationMethod"`
}

// CreateApplicationAccessPointResponse is the response struct for api CreateApplicationAccessPoint
type CreateApplicationAccessPointResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	Description          string `json:"Description" xml:"Description"`
	Policies             string `json:"Policies" xml:"Policies"`
	Name                 string `json:"Name" xml:"Name"`
	Arn                  string `json:"Arn" xml:"Arn"`
	AuthenticationMethod string `json:"AuthenticationMethod" xml:"AuthenticationMethod"`
}

// CreateCreateApplicationAccessPointRequest creates a request to invoke CreateApplicationAccessPoint API
func CreateCreateApplicationAccessPointRequest() (request *CreateApplicationAccessPointRequest) {
	request = &CreateApplicationAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "CreateApplicationAccessPoint", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateApplicationAccessPointResponse creates a response to parse from CreateApplicationAccessPoint response
func CreateCreateApplicationAccessPointResponse() (response *CreateApplicationAccessPointResponse) {
	response = &CreateApplicationAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
