/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// ServerHealthCheckApplyConfiguration represents a declarative configuration of the ServerHealthCheck type for use
// with apply.
type ServerHealthCheckApplyConfiguration struct {
	Scheme            *string             `json:"scheme,omitempty"`
	Mode              *string             `json:"mode,omitempty"`
	Path              *string             `json:"path,omitempty"`
	Method            *string             `json:"method,omitempty"`
	Status            *int                `json:"status,omitempty"`
	Port              *int                `json:"port,omitempty"`
	Interval          *intstr.IntOrString `json:"interval,omitempty"`
	UnhealthyInterval *intstr.IntOrString `json:"unhealthyInterval,omitempty"`
	Timeout           *intstr.IntOrString `json:"timeout,omitempty"`
	Hostname          *string             `json:"hostname,omitempty"`
	FollowRedirects   *bool               `json:"followRedirects,omitempty"`
	Headers           map[string]string   `json:"headers,omitempty"`
}

// ServerHealthCheckApplyConfiguration constructs a declarative configuration of the ServerHealthCheck type for use with
// apply.
func ServerHealthCheck() *ServerHealthCheckApplyConfiguration {
	return &ServerHealthCheckApplyConfiguration{}
}

// WithScheme sets the Scheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scheme field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithScheme(value string) *ServerHealthCheckApplyConfiguration {
	b.Scheme = &value
	return b
}

// WithMode sets the Mode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Mode field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithMode(value string) *ServerHealthCheckApplyConfiguration {
	b.Mode = &value
	return b
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithPath(value string) *ServerHealthCheckApplyConfiguration {
	b.Path = &value
	return b
}

// WithMethod sets the Method field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Method field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithMethod(value string) *ServerHealthCheckApplyConfiguration {
	b.Method = &value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithStatus(value int) *ServerHealthCheckApplyConfiguration {
	b.Status = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithPort(value int) *ServerHealthCheckApplyConfiguration {
	b.Port = &value
	return b
}

// WithInterval sets the Interval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Interval field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithInterval(value intstr.IntOrString) *ServerHealthCheckApplyConfiguration {
	b.Interval = &value
	return b
}

// WithUnhealthyInterval sets the UnhealthyInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UnhealthyInterval field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithUnhealthyInterval(value intstr.IntOrString) *ServerHealthCheckApplyConfiguration {
	b.UnhealthyInterval = &value
	return b
}

// WithTimeout sets the Timeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Timeout field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithTimeout(value intstr.IntOrString) *ServerHealthCheckApplyConfiguration {
	b.Timeout = &value
	return b
}

// WithHostname sets the Hostname field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hostname field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithHostname(value string) *ServerHealthCheckApplyConfiguration {
	b.Hostname = &value
	return b
}

// WithFollowRedirects sets the FollowRedirects field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FollowRedirects field is set to the value of the last call.
func (b *ServerHealthCheckApplyConfiguration) WithFollowRedirects(value bool) *ServerHealthCheckApplyConfiguration {
	b.FollowRedirects = &value
	return b
}

// WithHeaders puts the entries into the Headers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Headers field,
// overwriting an existing map entries in Headers field with the same key.
func (b *ServerHealthCheckApplyConfiguration) WithHeaders(entries map[string]string) *ServerHealthCheckApplyConfiguration {
	if b.Headers == nil && len(entries) > 0 {
		b.Headers = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Headers[k] = v
	}
	return b
}
