/* localsearch-selection-query.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-selection-query.vala, do not modify */

/*
 * Copyright (C) 2010-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <tinysparql.h>
#include <glib-object.h>
#include <gee.h>
#include "rygel-core.h"

#define RYGEL_LOCAL_SEARCH_SELECTION_QUERY_STRICT_SHARED_FILTER "(BOUND(nmm:dlnaProfile(" RYGEL_LOCAL_SEARCH_SELECTION_QUERY_ITEM_VARIABLE ")))"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _rygel_local_search_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_local_search_query_unref (var), NULL)))
typedef struct _RygelLocalSearchSelectionQueryExecuteData RygelLocalSearchSelectionQueryExecuteData;

struct _RygelLocalSearchSelectionQueryPrivate {
	gchar* uri_filter;
};

struct _RygelLocalSearchSelectionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchSelectionQuery* self;
	TrackerSparqlConnection* resources;
	gchar* str;
	gchar* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	GError* _inner_error0_;
};

static gint RygelLocalSearchSelectionQuery_private_offset;
static gpointer rygel_local_search_selection_query_parent_class = NULL;

static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GeeArrayList* rygel_local_search_selection_query_copy_str_list (GeeList* str_list);
static void rygel_local_search_selection_query_real_execute_data_free (gpointer _data);
static void rygel_local_search_selection_query_real_execute (RygelLocalSearchQuery* base,
                                                      TrackerSparqlConnection* resources,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean rygel_local_search_selection_query_real_execute_co (RygelLocalSearchSelectionQueryExecuteData* _data_);
static void rygel_local_search_selection_query_execute_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static gchar* rygel_local_search_selection_query_real_to_string (RygelLocalSearchQuery* base);
static void rygel_local_search_selection_query_finalize (RygelLocalSearchQuery * obj);
static GType rygel_local_search_selection_query_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_local_search_selection_query_get_instance_private (RygelLocalSearchSelectionQuery* self)
{
	return G_STRUCT_MEMBER_P (self, RygelLocalSearchSelectionQuery_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

RygelLocalSearchSelectionQuery*
rygel_local_search_selection_query_construct (GType object_type,
                                              GeeArrayList* variables,
                                              RygelLocalSearchQueryTriplets* triplets,
                                              GeeArrayList* filters,
                                              const gchar* graph,
                                              const gchar* order_by,
                                              gint offset,
                                              gint max_count)
{
	RygelLocalSearchSelectionQuery* self = NULL;
	GeeArrayList* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* uris = NULL;
	gchar** uri_filters = NULL;
	gchar** _tmp5_;
	gint uri_filters_length1;
	gint _uri_filters_size_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp6_;
	GFile* home_dir = NULL;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	const gchar* pictures_dir = NULL;
	const gchar* _tmp14_;
	const gchar* videos_dir = NULL;
	const gchar* _tmp15_;
	const gchar* music_dir = NULL;
	const gchar* _tmp16_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (variables != NULL, NULL);
	g_return_val_if_fail (triplets != NULL, NULL);
	g_return_val_if_fail (graph != NULL, NULL);
	self = (RygelLocalSearchSelectionQuery*) rygel_local_search_query_construct (object_type, triplets);
	if (filters != NULL) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (filters);
		_g_object_unref0 (self->filters);
		self->filters = _tmp0_;
	} else {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->filters);
		self->filters = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (variables);
	_g_object_unref0 (self->variables);
	self->variables = _tmp2_;
	_tmp3_ = g_strdup (graph);
	_g_free0 (self->graph);
	self->graph = _tmp3_;
	_tmp4_ = g_strdup (order_by);
	_g_free0 (self->order_by);
	self->order_by = _tmp4_;
	self->offset = offset;
	self->max_count = max_count;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	uri_filters = _tmp5_;
	uri_filters_length1 = 0;
	_uri_filters_size_ = uri_filters_length1;
	_tmp6_ = rygel_meta_config_get_default ();
	config = _tmp6_;
	{
		GeeArrayList* _tmp7_ = NULL;
		RygelMetaConfig* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		_tmp8_ = config;
		_tmp9_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp8_, "LocalSearch", "only-export-from", &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (uris);
		uris = _tmp10_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GeeArrayList* _tmp11_;
		g_clear_error (&_inner_error0_);
		_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (uris);
		uris = _tmp11_;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		uri_filters = (_vala_array_free (uri_filters, uri_filters_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = g_get_home_dir ();
	_tmp13_ = g_file_new_for_path (_tmp12_);
	home_dir = _tmp13_;
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	pictures_dir = _tmp14_;
	_tmp15_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	videos_dir = _tmp15_;
	_tmp16_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	music_dir = _tmp16_;
	{
		GeeArrayList* _uri_list = NULL;
		GeeArrayList* _tmp17_;
		gint _uri_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _uri_index = 0;
		_tmp17_ = uris;
		_uri_list = _tmp17_;
		_tmp18_ = _uri_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_uri_size = _tmp20_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gchar* uri = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			GFile* file = NULL;
			const gchar* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			_uri_index = _uri_index + 1;
			_tmp21_ = _uri_index;
			_tmp22_ = _uri_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _uri_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _uri_index);
			uri = (gchar*) _tmp24_;
			_tmp25_ = uri;
			_tmp26_ = g_file_new_for_commandline_arg (_tmp25_);
			file = _tmp26_;
			_tmp27_ = file;
			_tmp28_ = home_dir;
			if (!g_file_equal (_tmp27_, _tmp28_)) {
				gchar* actual_uri = NULL;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp35_;
				const gchar* _tmp39_;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				const gchar* _tmp45_;
				const gchar* _tmp48_;
				GFile* _tmp49_;
				GFile* _tmp50_;
				GFile* _tmp51_;
				GFile* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				_tmp29_ = uri;
				_tmp30_ = g_strdup (_tmp29_);
				actual_uri = _tmp30_;
				_tmp31_ = pictures_dir;
				if (_tmp31_ != NULL) {
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp32_ = actual_uri;
					_tmp33_ = pictures_dir;
					_tmp34_ = string_replace (_tmp32_, "@PICTURES@", _tmp33_);
					_g_free0 (actual_uri);
					actual_uri = _tmp34_;
				}
				_tmp35_ = videos_dir;
				if (_tmp35_ != NULL) {
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp36_ = actual_uri;
					_tmp37_ = videos_dir;
					_tmp38_ = string_replace (_tmp36_, "@VIDEOS@", _tmp37_);
					_g_free0 (actual_uri);
					actual_uri = _tmp38_;
				}
				_tmp39_ = music_dir;
				if (_tmp39_ != NULL) {
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp40_ = actual_uri;
					_tmp41_ = music_dir;
					_tmp42_ = string_replace (_tmp40_, "@MUSIC@", _tmp41_);
					_g_free0 (actual_uri);
					actual_uri = _tmp42_;
				}
				_tmp45_ = actual_uri;
				if (string_contains (_tmp45_, "@PICTURES@")) {
					_tmp44_ = TRUE;
				} else {
					const gchar* _tmp46_;
					_tmp46_ = actual_uri;
					_tmp44_ = string_contains (_tmp46_, "@VIDEOS@");
				}
				if (_tmp44_) {
					_tmp43_ = TRUE;
				} else {
					const gchar* _tmp47_;
					_tmp47_ = actual_uri;
					_tmp43_ = string_contains (_tmp47_, "@MUSIC@");
				}
				if (_tmp43_) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_tmp48_ = actual_uri;
				_tmp49_ = g_file_new_for_commandline_arg (_tmp48_);
				_g_object_unref0 (file);
				file = _tmp49_;
				_tmp50_ = file;
				_tmp51_ = home_dir;
				if (g_file_equal (_tmp50_, _tmp51_)) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_tmp52_ = file;
				_tmp53_ = g_file_get_uri (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup_printf ("STRSTARTS(nie:url(%s), \"%s\")", RYGEL_LOCAL_SEARCH_SELECTION_QUERY_STORAGE_VARIABLE, _tmp54_);
				_vala_array_add1 (&uri_filters, &uri_filters_length1, &_uri_filters_size_, _tmp55_);
				_g_free0 (_tmp54_);
				_g_free0 (actual_uri);
			}
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
	}
	_tmp56_ = uri_filters;
	_tmp56__length1 = uri_filters_length1;
	if (_tmp56__length1 != 0) {
		gchar** _tmp57_;
		gint _tmp57__length1;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp57_ = uri_filters;
		_tmp57__length1 = uri_filters_length1;
		_tmp58_ = _vala_g_strjoinv ("||", _tmp57_, (gint) _tmp57__length1);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strdup_printf ("(%s)", _tmp59_);
		_g_free0 (self->priv->uri_filter);
		self->priv->uri_filter = _tmp60_;
		_g_free0 (_tmp59_);
	} else {
		_g_free0 (self->priv->uri_filter);
		self->priv->uri_filter = NULL;
	}
	_g_object_unref0 (home_dir);
	_g_object_unref0 (config);
	uri_filters = (_vala_array_free (uri_filters, uri_filters_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (uris);
	return self;
}

RygelLocalSearchSelectionQuery*
rygel_local_search_selection_query_new (GeeArrayList* variables,
                                        RygelLocalSearchQueryTriplets* triplets,
                                        GeeArrayList* filters,
                                        const gchar* graph,
                                        const gchar* order_by,
                                        gint offset,
                                        gint max_count)
{
	return rygel_local_search_selection_query_construct (RYGEL_LOCAL_SEARCH_TYPE_SELECTION_QUERY, variables, triplets, filters, graph, order_by, offset, max_count);
}

RygelLocalSearchSelectionQuery*
rygel_local_search_selection_query_construct_clone (GType object_type,
                                                    RygelLocalSearchSelectionQuery* query)
{
	RygelLocalSearchSelectionQuery* self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	RygelLocalSearchQueryTriplets* _tmp3_;
	RygelLocalSearchQueryTriplets* _tmp4_;
	RygelLocalSearchQueryTriplets* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query->variables;
	_tmp1_ = rygel_local_search_selection_query_copy_str_list ((GeeList*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((RygelLocalSearchQuery*) query)->triplets;
	_tmp4_ = rygel_local_search_query_triplets_new_clone (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = query->filters;
	_tmp7_ = rygel_local_search_selection_query_copy_str_list ((GeeList*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = query->graph;
	_tmp10_ = query->order_by;
	self = (RygelLocalSearchSelectionQuery*) rygel_local_search_selection_query_construct (object_type, _tmp2_, _tmp5_, _tmp8_, _tmp9_, _tmp10_, query->offset, query->max_count);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	return self;
}

RygelLocalSearchSelectionQuery*
rygel_local_search_selection_query_new_clone (RygelLocalSearchSelectionQuery* query)
{
	return rygel_local_search_selection_query_construct_clone (RYGEL_LOCAL_SEARCH_TYPE_SELECTION_QUERY, query);
}

static void
rygel_local_search_selection_query_real_execute_data_free (gpointer _data)
{
	RygelLocalSearchSelectionQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_local_search_query_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchSelectionQueryExecuteData, _data_);
}

static gpointer
_rygel_local_search_query_ref0 (gpointer self)
{
	return self ? rygel_local_search_query_ref (self) : NULL;
}

static void
rygel_local_search_selection_query_real_execute (RygelLocalSearchQuery* base,
                                                 TrackerSparqlConnection* resources,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	RygelLocalSearchSelectionQuery * self;
	RygelLocalSearchSelectionQueryExecuteData* _data_;
	RygelLocalSearchSelectionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	g_return_if_fail (resources != NULL);
	self = (RygelLocalSearchSelectionQuery*) base;
	_data_ = g_slice_new0 (RygelLocalSearchSelectionQueryExecuteData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_selection_query_real_execute_data_free);
	_tmp0_ = _rygel_local_search_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (resources);
	_g_object_unref0 (_data_->resources);
	_data_->resources = _tmp1_;
	rygel_local_search_selection_query_real_execute_co (_data_);
}

static void
rygel_local_search_selection_query_execute_finish (RygelLocalSearchQuery* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	RygelLocalSearchSelectionQueryExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_local_search_selection_query_execute_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	RygelLocalSearchSelectionQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_selection_query_real_execute_co (_data_);
}

static gboolean
rygel_local_search_selection_query_real_execute_co (RygelLocalSearchSelectionQueryExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_local_search_query_to_string ((RygelLocalSearchQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	g_debug ("localsearch-selection-query.vala:145: Executing SPARQL query: %s", _data_->str);
	_data_->_state_ = 1;
	tracker_sparql_connection_query_async (_data_->resources, _data_->str, NULL, rygel_local_search_selection_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = tracker_sparql_connection_query_finish (_data_->resources, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->str);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->result);
	_data_->self->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp1_);
	_g_free0 (_data_->str);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
rygel_local_search_selection_query_real_to_string (RygelLocalSearchQuery* base)
{
	RygelLocalSearchSelectionQuery * self;
	gchar* query = NULL;
	gchar* _tmp0_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gboolean strict = FALSE;
	const gchar* _tmp31_;
	gint _tmp33_;
	gint _tmp34_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelLocalSearchSelectionQuery*) base;
	_tmp0_ = g_strdup ("SELECT ");
	query = _tmp0_;
	{
		GeeArrayList* _variable_list = NULL;
		GeeArrayList* _tmp1_;
		gint _variable_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _variable_index = 0;
		_tmp1_ = self->variables;
		_variable_list = _tmp1_;
		_tmp2_ = _variable_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_variable_size = _tmp4_;
		_variable_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* variable = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_variable_index = _variable_index + 1;
			_tmp5_ = _variable_index;
			_tmp6_ = _variable_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _variable_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _variable_index);
			variable = (gchar*) _tmp8_;
			_tmp9_ = query;
			_tmp10_ = variable;
			_tmp11_ = g_strconcat (" ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (query);
			query = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (variable);
		}
	}
	_tmp14_ = query;
	_tmp15_ = self->graph;
	_tmp16_ = g_strdup_printf (" FROM tracker:FileSystem FROM %s", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
	_g_free0 (query);
	query = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = query;
	_tmp20_ = RYGEL_LOCAL_SEARCH_QUERY_CLASS (rygel_local_search_selection_query_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LOCAL_SEARCH_TYPE_QUERY, RygelLocalSearchQuery));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (" WHERE { ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_g_free0 (query);
	query = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp25_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	filters = _tmp25_;
	_tmp26_ = self->filters;
	gee_array_list_add_all (filters, (GeeCollection*) _tmp26_);
	strict = FALSE;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp27_ = rygel_meta_config_get_default ();
		config = _tmp27_;
		_tmp28_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "general", "strict-dlna", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		if (_tmp28_) {
			strict = TRUE;
		}
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (filters);
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp29_ = rygel_meta_config_get_default ();
		config = _tmp29_;
		_tmp30_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "LocalSearch", "strict-sharing", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch1_g_error;
		}
		strict = _tmp30_;
		_g_object_unref0 (config);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (filters);
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (strict) {
		gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_LOCAL_SEARCH_SELECTION_QUERY_STRICT_SHARED_FILTER);
	}
	_tmp31_ = self->priv->uri_filter;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_;
		_tmp32_ = self->priv->uri_filter;
		gee_abstract_collection_add ((GeeAbstractCollection*) filters, _tmp32_);
	}
	_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
	_tmp34_ = _tmp33_;
	if (_tmp34_ > 0) {
		const gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		_tmp35_ = query;
		_tmp36_ = g_strconcat (_tmp35_, " FILTER (", NULL);
		_g_free0 (query);
		query = _tmp36_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp37_ = FALSE;
				_tmp37_ = TRUE;
				while (TRUE) {
					gint _tmp39_;
					gint _tmp40_;
					const gchar* _tmp41_;
					gpointer _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					if (!_tmp37_) {
						gint _tmp38_;
						_tmp38_ = i;
						i = _tmp38_ + 1;
					}
					_tmp37_ = FALSE;
					_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
					_tmp40_ = _tmp39_;
					if (!(i < _tmp40_)) {
						break;
					}
					_tmp41_ = query;
					_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) filters, i);
					_tmp43_ = (gchar*) _tmp42_;
					_tmp44_ = g_strconcat (_tmp41_, _tmp43_, NULL);
					_g_free0 (query);
					query = _tmp44_;
					_g_free0 (_tmp43_);
					_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
					_tmp46_ = _tmp45_;
					if (i < (_tmp46_ - 1)) {
						const gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp47_ = query;
						_tmp48_ = g_strconcat (_tmp47_, " && ", NULL);
						_g_free0 (query);
						query = _tmp48_;
					}
				}
			}
		}
		_tmp49_ = query;
		_tmp50_ = g_strconcat (_tmp49_, ")", NULL);
		_g_free0 (query);
		query = _tmp50_;
	}
	_tmp51_ = query;
	_tmp52_ = g_strconcat (_tmp51_, " }", NULL);
	_g_free0 (query);
	query = _tmp52_;
	_tmp53_ = self->order_by;
	if (_tmp53_ != NULL) {
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp54_ = query;
		_tmp55_ = self->order_by;
		_tmp56_ = g_strconcat (" ORDER BY ", _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp54_, _tmp57_, NULL);
		_g_free0 (query);
		query = _tmp58_;
		_g_free0 (_tmp57_);
	}
	if (self->offset > 0) {
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp59_ = query;
		_tmp60_ = g_strdup_printf ("%i", self->offset);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat (" OFFSET ", _tmp61_, NULL);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (_tmp59_, _tmp63_, NULL);
		_g_free0 (query);
		query = _tmp64_;
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
	}
	if (self->max_count > 0) {
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp65_ = query;
		_tmp66_ = g_strdup_printf ("%i", self->max_count);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strconcat (" LIMIT ", _tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strconcat (_tmp65_, _tmp69_, NULL);
		_g_free0 (query);
		query = _tmp70_;
		_g_free0 (_tmp69_);
		_g_free0 (_tmp67_);
	}
	result = query;
	_g_object_unref0 (filters);
	return result;
}

static GeeArrayList*
rygel_local_search_selection_query_copy_str_list (GeeList* str_list)
{
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (str_list != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	copy = _tmp0_;
	gee_array_list_add_all (copy, (GeeCollection*) str_list);
	result = copy;
	return result;
}

static void
rygel_local_search_selection_query_class_init (RygelLocalSearchSelectionQueryClass * klass,
                                               gpointer klass_data)
{
	rygel_local_search_selection_query_parent_class = g_type_class_peek_parent (klass);
	((RygelLocalSearchQueryClass *) klass)->finalize = rygel_local_search_selection_query_finalize;
	g_type_class_adjust_private_offset (klass, &RygelLocalSearchSelectionQuery_private_offset);
	((RygelLocalSearchQueryClass *) klass)->execute = (void (*) (RygelLocalSearchQuery*, TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) rygel_local_search_selection_query_real_execute;
	((RygelLocalSearchQueryClass *) klass)->execute_finish = (void (*) (RygelLocalSearchQuery*, GAsyncResult*, GError**)) rygel_local_search_selection_query_execute_finish;
	((RygelLocalSearchQueryClass *) klass)->to_string = (gchar* (*) (RygelLocalSearchQuery*)) rygel_local_search_selection_query_real_to_string;
}

static void
rygel_local_search_selection_query_instance_init (RygelLocalSearchSelectionQuery * self,
                                                  gpointer klass)
{
	self->priv = rygel_local_search_selection_query_get_instance_private (self);
}

static void
rygel_local_search_selection_query_finalize (RygelLocalSearchQuery * obj)
{
	RygelLocalSearchSelectionQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LOCAL_SEARCH_TYPE_SELECTION_QUERY, RygelLocalSearchSelectionQuery);
	_g_free0 (self->priv->uri_filter);
	_g_object_unref0 (self->variables);
	_g_object_unref0 (self->filters);
	_g_free0 (self->graph);
	_g_free0 (self->order_by);
	_g_object_unref0 (self->result);
	RYGEL_LOCAL_SEARCH_QUERY_CLASS (rygel_local_search_selection_query_parent_class)->finalize (obj);
}

/**
 * Represents LocalSearch SPARQL Selection query
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_selection_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchSelectionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_selection_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchSelectionQuery), 0, (GInstanceInitFunc) rygel_local_search_selection_query_instance_init, NULL };
	GType rygel_local_search_selection_query_type_id;
	rygel_local_search_selection_query_type_id = g_type_register_static (RYGEL_LOCAL_SEARCH_TYPE_QUERY, "RygelLocalSearchSelectionQuery", &g_define_type_info, 0);
	RygelLocalSearchSelectionQuery_private_offset = g_type_add_instance_private (rygel_local_search_selection_query_type_id, sizeof (RygelLocalSearchSelectionQueryPrivate));
	return rygel_local_search_selection_query_type_id;
}

GType
rygel_local_search_selection_query_get_type (void)
{
	static volatile gsize rygel_local_search_selection_query_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_selection_query_type_id__once)) {
		GType rygel_local_search_selection_query_type_id;
		rygel_local_search_selection_query_type_id = rygel_local_search_selection_query_get_type_once ();
		g_once_init_leave (&rygel_local_search_selection_query_type_id__once, rygel_local_search_selection_query_type_id);
	}
	return rygel_local_search_selection_query_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

