// third_party/blink/public/mojom/clipboard/raw_clipboard.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_RAW_CLIPBOARD_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_RAW_CLIPBOARD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-shared.h"
#include "third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class RawClipboardHostProxy;

template <typename ImplRefTraits>
class RawClipboardHostStub;

class RawClipboardHostRequestValidator;
class RawClipboardHostResponseValidator;


class BLINK_COMMON_EXPORT RawClipboardHost
    : public RawClipboardHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RawClipboardHostInterfaceBase;
  using Proxy_ = RawClipboardHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RawClipboardHostStub<ImplRefTraits>;

  using RequestValidator_ = RawClipboardHostRequestValidator;
  using ResponseValidator_ = RawClipboardHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadAvailableFormatNamesMinVersion = 0,
    kReadMinVersion = 0,
    kWriteMinVersion = 0,
    kCommitWriteMinVersion = 0,
  };
  
  static constexpr int32_t kMaxFormatSize = 1024;
  
  static constexpr int32_t kMaxDataSize = 1073741824;
  virtual ~RawClipboardHost() {}


  using ReadAvailableFormatNamesCallback = base::OnceCallback<void(const std::vector<::base::string16>&)>;
  
  virtual void ReadAvailableFormatNames(ReadAvailableFormatNamesCallback callback) = 0;


  using ReadCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;
  
  virtual void Read(const ::base::string16& format, ReadCallback callback) = 0;

  
  virtual void Write(const ::base::string16& format, ::mojo_base::BigBuffer data) = 0;

  
  virtual void CommitWrite() = 0;
};



class BLINK_COMMON_EXPORT RawClipboardHostProxy
    : public RawClipboardHost {
 public:
  using InterfaceType = RawClipboardHost;

  explicit RawClipboardHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReadAvailableFormatNames(ReadAvailableFormatNamesCallback callback) final;
  
  void Read(const ::base::string16& format, ReadCallback callback) final;
  
  void Write(const ::base::string16& format, ::mojo_base::BigBuffer data) final;
  
  void CommitWrite() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT RawClipboardHostStubDispatch {
 public:
  static bool Accept(RawClipboardHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RawClipboardHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RawClipboardHost>>
class RawClipboardHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RawClipboardHostStub() {}
  ~RawClipboardHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RawClipboardHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RawClipboardHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RawClipboardHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RawClipboardHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_RAW_CLIPBOARD_MOJOM_H_