// services/device/public/mojom/vibration_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/vibration_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/vibration_manager.mojom-params-data.h"
#include "services/device/public/mojom/vibration_manager.mojom-shared-message-ids.h"

#include "services/device/public/mojom/vibration_manager.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_VIBRATION_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_VIBRATION_MANAGER_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
const char VibrationManager::Name_[] = "device.mojom.VibrationManager";

class VibrationManager_Vibrate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VibrationManager_Vibrate_ForwardToCallback(
      VibrationManager::VibrateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VibrationManager::VibrateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VibrationManager_Vibrate_ForwardToCallback);
};

class VibrationManager_Cancel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VibrationManager_Cancel_ForwardToCallback(
      VibrationManager::CancelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VibrationManager::CancelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VibrationManager_Cancel_ForwardToCallback);
};

VibrationManagerProxy::VibrationManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VibrationManagerProxy::Vibrate(
    int64_t in_milliseconds, VibrateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::VibrationManager::Vibrate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("milliseconds", base::NumberToString(in_milliseconds));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVibrationManager_Vibrate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::VibrationManager_Vibrate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->milliseconds = in_milliseconds;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VibrationManager::Name_);
  message.set_method_name("Vibrate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VibrationManager_Vibrate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VibrationManagerProxy::Cancel(
    CancelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::VibrationManager::Cancel");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVibrationManager_Cancel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::VibrationManager_Cancel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VibrationManager::Name_);
  message.set_method_name("Cancel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VibrationManager_Cancel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VibrationManager_Vibrate_ProxyToResponder {
 public:
  static VibrationManager::VibrateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VibrationManager_Vibrate_ProxyToResponder> proxy(
        new VibrationManager_Vibrate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VibrationManager_Vibrate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VibrationManager_Vibrate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VibrationManager_Vibrate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VibrationManager::VibrateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VibrationManager_Vibrate_ProxyToResponder);
};

bool VibrationManager_Vibrate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::VibrationManager::VibrateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VibrationManager_Vibrate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VibrationManager_Vibrate_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  VibrationManager_Vibrate_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VibrationManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VibrationManager_Vibrate_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::VibrationManager::VibrateCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVibrationManager_Vibrate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::VibrationManager_Vibrate_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::VibrationManager::VibrateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VibrationManager::Name_);
  message.set_method_name("Vibrate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VibrationManager_Cancel_ProxyToResponder {
 public:
  static VibrationManager::CancelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VibrationManager_Cancel_ProxyToResponder> proxy(
        new VibrationManager_Cancel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VibrationManager_Cancel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VibrationManager_Cancel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VibrationManager_Cancel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VibrationManager::CancelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VibrationManager_Cancel_ProxyToResponder);
};

bool VibrationManager_Cancel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::VibrationManager::CancelCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::VibrationManager_Cancel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VibrationManager_Cancel_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  VibrationManager_Cancel_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VibrationManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VibrationManager_Cancel_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::VibrationManager::CancelCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVibrationManager_Cancel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::VibrationManager_Cancel_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::VibrationManager::CancelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VibrationManager::Name_);
  message.set_method_name("Cancel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VibrationManagerStubDispatch::Accept(
    VibrationManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kVibrationManager_Vibrate_Name: {
      break;
    }
    case internal::kVibrationManager_Cancel_Name: {
      break;
    }
  }
  return false;
}

// static
bool VibrationManagerStubDispatch::AcceptWithResponder(
    VibrationManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVibrationManager_Vibrate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VibrationManager::Vibrate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VibrationManager::Vibrate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VibrationManager_Vibrate_Params_Data* params =
          reinterpret_cast<
              internal::VibrationManager_Vibrate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_milliseconds{};
      VibrationManager_Vibrate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_milliseconds = input_data_view.milliseconds();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VibrationManager::Name_, 0, false);
        return false;
      }
      VibrationManager::VibrateCallback callback =
          VibrationManager_Vibrate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Vibrate(
std::move(p_milliseconds), std::move(callback));
      return true;
    }
    case internal::kVibrationManager_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VibrationManager::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VibrationManager::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VibrationManager_Cancel_Params_Data* params =
          reinterpret_cast<
              internal::VibrationManager_Cancel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VibrationManager_Cancel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VibrationManager::Name_, 1, false);
        return false;
      }
      VibrationManager::CancelCallback callback =
          VibrationManager_Cancel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVibrationManagerValidationInfo[] = {
    {internal::kVibrationManager_Vibrate_Name,
     {&internal::VibrationManager_Vibrate_Params_Data::Validate,
      &internal::VibrationManager_Vibrate_ResponseParams_Data::Validate}},
    {internal::kVibrationManager_Cancel_Name,
     {&internal::VibrationManager_Cancel_Params_Data::Validate,
      &internal::VibrationManager_Cancel_ResponseParams_Data::Validate}},
};

bool VibrationManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::VibrationManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVibrationManagerValidationInfo);
}

bool VibrationManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::VibrationManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVibrationManagerValidationInfo);

}
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif