// components/services/font/public/mojom/font_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_H_
#define COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/font/public/mojom/font_service.mojom-shared.h"
#include "components/services/font/public/mojom/font_service.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace font_service {
namespace mojom {

class FontServiceProxy;

template <typename ImplRefTraits>
class FontServiceStub;

class FontServiceRequestValidator;
class FontServiceResponseValidator;


class  FontService
    : public FontServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FontServiceInterfaceBase;
  using Proxy_ = FontServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = FontServiceStub<ImplRefTraits>;

  using RequestValidator_ = FontServiceRequestValidator;
  using ResponseValidator_ = FontServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMatchFamilyNameMinVersion = 0,
    kOpenStreamMinVersion = 0,
    kFallbackFontForCharacterMinVersion = 0,
    kFontRenderStyleForStrikeMinVersion = 0,
    kMatchFontByPostscriptNameOrFullFontNameMinVersion = 0,
    kMatchFontWithFallbackMinVersion = 0,
  };
  virtual ~FontService() {}


  using MatchFamilyNameCallback = base::OnceCallback<void(FontIdentityPtr, const std::string&, TypefaceStylePtr)>;
  
  virtual void MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameCallback callback) = 0;


  using OpenStreamCallback = base::OnceCallback<void(::base::File)>;
  
  virtual void OpenStream(uint32_t id_number, OpenStreamCallback callback) = 0;


  using FallbackFontForCharacterCallback = base::OnceCallback<void(FontIdentityPtr, const std::string&, bool, bool)>;
  
  virtual void FallbackFontForCharacter(uint32_t character, const std::string& locale, FallbackFontForCharacterCallback callback) = 0;


  using FontRenderStyleForStrikeCallback = base::OnceCallback<void(FontRenderStylePtr)>;
  
  virtual void FontRenderStyleForStrike(const std::string& family, uint32_t size, bool is_italic, bool is_bold, float device_scale_factor, FontRenderStyleForStrikeCallback callback) = 0;


  using MatchFontByPostscriptNameOrFullFontNameCallback = base::OnceCallback<void(FontIdentityPtr)>;
  
  virtual void MatchFontByPostscriptNameOrFullFontName(const std::string& postscript_name_or_full_font_name, MatchFontByPostscriptNameOrFullFontNameCallback callback) = 0;


  using MatchFontWithFallbackCallback = base::OnceCallback<void(::base::File)>;
  
  virtual void MatchFontWithFallback(const std::string& family, bool is_bold, bool is_italic, uint32_t charset, uint32_t fallback_family_type, MatchFontWithFallbackCallback callback) = 0;
};



class  FontServiceProxy
    : public FontService {
 public:
  using InterfaceType = FontService;

  explicit FontServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MatchFamilyName(const std::string& family_name, TypefaceStylePtr style, MatchFamilyNameCallback callback) final;
  
  void OpenStream(uint32_t id_number, OpenStreamCallback callback) final;
  
  void FallbackFontForCharacter(uint32_t character, const std::string& locale, FallbackFontForCharacterCallback callback) final;
  
  void FontRenderStyleForStrike(const std::string& family, uint32_t size, bool is_italic, bool is_bold, float device_scale_factor, FontRenderStyleForStrikeCallback callback) final;
  
  void MatchFontByPostscriptNameOrFullFontName(const std::string& postscript_name_or_full_font_name, MatchFontByPostscriptNameOrFullFontNameCallback callback) final;
  
  void MatchFontWithFallback(const std::string& family, bool is_bold, bool is_italic, uint32_t charset, uint32_t fallback_family_type, MatchFontWithFallbackCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FontServiceStubDispatch {
 public:
  static bool Accept(FontService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FontService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FontService>>
class FontServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FontServiceStub() {}
  ~FontServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FontServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FontServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FontServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FontServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  TypefaceStyle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TypefaceStyle, T>::value>;
  using DataView = TypefaceStyleDataView;
  using Data_ = internal::TypefaceStyle_Data;

  template <typename... Args>
  static TypefaceStylePtr New(Args&&... args) {
    return TypefaceStylePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TypefaceStylePtr From(const U& u) {
    return mojo::TypeConverter<TypefaceStylePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypefaceStyle>::Convert(*this);
  }


  TypefaceStyle();

  TypefaceStyle(
      uint16_t weight,
      uint8_t width,
      TypefaceSlant slant);

  ~TypefaceStyle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TypefaceStylePtr>
  TypefaceStylePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypefaceStyle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypefaceStyle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TypefaceStyle_UnserializedMessageContext<
            UserType, TypefaceStyle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TypefaceStyle::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return TypefaceStyle::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TypefaceStyle_UnserializedMessageContext<
            UserType, TypefaceStyle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TypefaceStyle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint16_t weight;
  
  uint8_t width;
  
  TypefaceSlant slant;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TypefaceStyle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  FontIdentity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FontIdentity, T>::value>;
  using DataView = FontIdentityDataView;
  using Data_ = internal::FontIdentity_Data;

  template <typename... Args>
  static FontIdentityPtr New(Args&&... args) {
    return FontIdentityPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FontIdentityPtr From(const U& u) {
    return mojo::TypeConverter<FontIdentityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FontIdentity>::Convert(*this);
  }


  FontIdentity();

  FontIdentity(
      uint32_t id,
      int32_t ttc_index,
      const ::base::FilePath& filepath);

  ~FontIdentity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FontIdentityPtr>
  FontIdentityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FontIdentity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FontIdentity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FontIdentity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FontIdentity_UnserializedMessageContext<
            UserType, FontIdentity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FontIdentity::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FontIdentity::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FontIdentity_UnserializedMessageContext<
            UserType, FontIdentity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FontIdentity::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t id;
  
  int32_t ttc_index;
  
  ::base::FilePath filepath;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FontIdentity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FontIdentity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FontIdentity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FontIdentity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FontRenderStyle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FontRenderStyle, T>::value>;
  using DataView = FontRenderStyleDataView;
  using Data_ = internal::FontRenderStyle_Data;

  template <typename... Args>
  static FontRenderStylePtr New(Args&&... args) {
    return FontRenderStylePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FontRenderStylePtr From(const U& u) {
    return mojo::TypeConverter<FontRenderStylePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FontRenderStyle>::Convert(*this);
  }


  FontRenderStyle();

  FontRenderStyle(
      RenderStyleSwitch use_bitmaps,
      RenderStyleSwitch use_autohint,
      RenderStyleSwitch use_hinting,
      uint8_t hint_style,
      RenderStyleSwitch use_antialias,
      RenderStyleSwitch use_subpixel_rendering,
      RenderStyleSwitch use_subpixel_positioning);

  ~FontRenderStyle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FontRenderStylePtr>
  FontRenderStylePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FontRenderStyle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FontRenderStyle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FontRenderStyle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FontRenderStyle_UnserializedMessageContext<
            UserType, FontRenderStyle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FontRenderStyle::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FontRenderStyle::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FontRenderStyle_UnserializedMessageContext<
            UserType, FontRenderStyle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FontRenderStyle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  RenderStyleSwitch use_bitmaps;
  
  RenderStyleSwitch use_autohint;
  
  RenderStyleSwitch use_hinting;
  
  uint8_t hint_style;
  
  RenderStyleSwitch use_antialias;
  
  RenderStyleSwitch use_subpixel_rendering;
  
  RenderStyleSwitch use_subpixel_positioning;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FontRenderStyle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FontRenderStyle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FontRenderStyle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FontRenderStyle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TypefaceStylePtr TypefaceStyle::Clone() const {
  return New(
      mojo::Clone(weight),
      mojo::Clone(width),
      mojo::Clone(slant)
  );
}

template <typename T, TypefaceStyle::EnableIfSame<T>*>
bool TypefaceStyle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->weight, other_struct.weight))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->slant, other_struct.slant))
    return false;
  return true;
}

template <typename T, TypefaceStyle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.weight, rhs.weight))
    return true;
  if (std::less<>{}(rhs.weight, lhs.weight))
    return false;
  if (std::less<>{}(lhs.width, rhs.width))
    return true;
  if (std::less<>{}(rhs.width, lhs.width))
    return false;
  if (std::less<>{}(lhs.slant, rhs.slant))
    return true;
  if (std::less<>{}(rhs.slant, lhs.slant))
    return false;
  return false;
}
template <typename StructPtrType>
FontIdentityPtr FontIdentity::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(ttc_index),
      mojo::Clone(filepath)
  );
}

template <typename T, FontIdentity::EnableIfSame<T>*>
bool FontIdentity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->ttc_index, other_struct.ttc_index))
    return false;
  if (!mojo::Equals(this->filepath, other_struct.filepath))
    return false;
  return true;
}

template <typename T, FontIdentity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.ttc_index, rhs.ttc_index))
    return true;
  if (std::less<>{}(rhs.ttc_index, lhs.ttc_index))
    return false;
  if (std::less<>{}(lhs.filepath, rhs.filepath))
    return true;
  if (std::less<>{}(rhs.filepath, lhs.filepath))
    return false;
  return false;
}
template <typename StructPtrType>
FontRenderStylePtr FontRenderStyle::Clone() const {
  return New(
      mojo::Clone(use_bitmaps),
      mojo::Clone(use_autohint),
      mojo::Clone(use_hinting),
      mojo::Clone(hint_style),
      mojo::Clone(use_antialias),
      mojo::Clone(use_subpixel_rendering),
      mojo::Clone(use_subpixel_positioning)
  );
}

template <typename T, FontRenderStyle::EnableIfSame<T>*>
bool FontRenderStyle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->use_bitmaps, other_struct.use_bitmaps))
    return false;
  if (!mojo::Equals(this->use_autohint, other_struct.use_autohint))
    return false;
  if (!mojo::Equals(this->use_hinting, other_struct.use_hinting))
    return false;
  if (!mojo::Equals(this->hint_style, other_struct.hint_style))
    return false;
  if (!mojo::Equals(this->use_antialias, other_struct.use_antialias))
    return false;
  if (!mojo::Equals(this->use_subpixel_rendering, other_struct.use_subpixel_rendering))
    return false;
  if (!mojo::Equals(this->use_subpixel_positioning, other_struct.use_subpixel_positioning))
    return false;
  return true;
}

template <typename T, FontRenderStyle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.use_bitmaps, rhs.use_bitmaps))
    return true;
  if (std::less<>{}(rhs.use_bitmaps, lhs.use_bitmaps))
    return false;
  if (std::less<>{}(lhs.use_autohint, rhs.use_autohint))
    return true;
  if (std::less<>{}(rhs.use_autohint, lhs.use_autohint))
    return false;
  if (std::less<>{}(lhs.use_hinting, rhs.use_hinting))
    return true;
  if (std::less<>{}(rhs.use_hinting, lhs.use_hinting))
    return false;
  if (std::less<>{}(lhs.hint_style, rhs.hint_style))
    return true;
  if (std::less<>{}(rhs.hint_style, lhs.hint_style))
    return false;
  if (std::less<>{}(lhs.use_antialias, rhs.use_antialias))
    return true;
  if (std::less<>{}(rhs.use_antialias, lhs.use_antialias))
    return false;
  if (std::less<>{}(lhs.use_subpixel_rendering, rhs.use_subpixel_rendering))
    return true;
  if (std::less<>{}(rhs.use_subpixel_rendering, lhs.use_subpixel_rendering))
    return false;
  if (std::less<>{}(lhs.use_subpixel_positioning, rhs.use_subpixel_positioning))
    return true;
  if (std::less<>{}(rhs.use_subpixel_positioning, lhs.use_subpixel_positioning))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace font_service

namespace mojo {


template <>
struct  StructTraits<::font_service::mojom::TypefaceStyle::DataView,
                                         ::font_service::mojom::TypefaceStylePtr> {
  static bool IsNull(const ::font_service::mojom::TypefaceStylePtr& input) { return !input; }
  static void SetToNull(::font_service::mojom::TypefaceStylePtr* output) { output->reset(); }

  static decltype(::font_service::mojom::TypefaceStyle::weight) weight(
      const ::font_service::mojom::TypefaceStylePtr& input) {
    return input->weight;
  }

  static decltype(::font_service::mojom::TypefaceStyle::width) width(
      const ::font_service::mojom::TypefaceStylePtr& input) {
    return input->width;
  }

  static decltype(::font_service::mojom::TypefaceStyle::slant) slant(
      const ::font_service::mojom::TypefaceStylePtr& input) {
    return input->slant;
  }

  static bool Read(::font_service::mojom::TypefaceStyle::DataView input, ::font_service::mojom::TypefaceStylePtr* output);
};


template <>
struct  StructTraits<::font_service::mojom::FontIdentity::DataView,
                                         ::font_service::mojom::FontIdentityPtr> {
  static bool IsNull(const ::font_service::mojom::FontIdentityPtr& input) { return !input; }
  static void SetToNull(::font_service::mojom::FontIdentityPtr* output) { output->reset(); }

  static decltype(::font_service::mojom::FontIdentity::id) id(
      const ::font_service::mojom::FontIdentityPtr& input) {
    return input->id;
  }

  static decltype(::font_service::mojom::FontIdentity::ttc_index) ttc_index(
      const ::font_service::mojom::FontIdentityPtr& input) {
    return input->ttc_index;
  }

  static const decltype(::font_service::mojom::FontIdentity::filepath)& filepath(
      const ::font_service::mojom::FontIdentityPtr& input) {
    return input->filepath;
  }

  static bool Read(::font_service::mojom::FontIdentity::DataView input, ::font_service::mojom::FontIdentityPtr* output);
};


template <>
struct  StructTraits<::font_service::mojom::FontRenderStyle::DataView,
                                         ::font_service::mojom::FontRenderStylePtr> {
  static bool IsNull(const ::font_service::mojom::FontRenderStylePtr& input) { return !input; }
  static void SetToNull(::font_service::mojom::FontRenderStylePtr* output) { output->reset(); }

  static decltype(::font_service::mojom::FontRenderStyle::use_bitmaps) use_bitmaps(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->use_bitmaps;
  }

  static decltype(::font_service::mojom::FontRenderStyle::use_autohint) use_autohint(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->use_autohint;
  }

  static decltype(::font_service::mojom::FontRenderStyle::use_hinting) use_hinting(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->use_hinting;
  }

  static decltype(::font_service::mojom::FontRenderStyle::hint_style) hint_style(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->hint_style;
  }

  static decltype(::font_service::mojom::FontRenderStyle::use_antialias) use_antialias(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->use_antialias;
  }

  static decltype(::font_service::mojom::FontRenderStyle::use_subpixel_rendering) use_subpixel_rendering(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->use_subpixel_rendering;
  }

  static decltype(::font_service::mojom::FontRenderStyle::use_subpixel_positioning) use_subpixel_positioning(
      const ::font_service::mojom::FontRenderStylePtr& input) {
    return input->use_subpixel_positioning;
  }

  static bool Read(::font_service::mojom::FontRenderStyle::DataView input, ::font_service::mojom::FontRenderStylePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_H_