/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "phosh-wwan-ofono-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringVariantFunc)
       (void *data1,
        const gchar *arg_unnamed_arg0,
        GVariant *arg_unnamed_arg1,
        void *data2);
  _GDbusCodegenMarshalVoid_StringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.ofono.SimManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshDBusOfonoSimManager
 * @title: PhoshDBusOfonoSimManager
 * @short_description: Generated C code for the org.ofono.SimManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link> D-Bus interface in C.
 */

enum
{
  PHOSH_DBUS__OFONO_SIM_MANAGER_PROPERTY_CHANGED,
};

static unsigned PHOSH_DBUS__OFONO_SIM_MANAGER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.ofono.SimManager ---- */

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_sim_manager_method_info_get_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_sim_manager_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_phosh_dbus_ofono_sim_manager_method_info_get_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_ofono_sim_manager_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_phosh_dbus_ofono_sim_manager_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const GDBusMethodInfo * const _phosh_dbus_ofono_sim_manager_method_info_pointers[] =
{
  &_phosh_dbus_ofono_sim_manager_method_info_get_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_sim_manager_signal_info_property_changed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_sim_manager_signal_info_property_changed_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_sim_manager_signal_info_property_changed_ARG_pointers[] =
{
  &_phosh_dbus_ofono_sim_manager_signal_info_property_changed_ARG_unnamed_arg0.parent_struct,
  &_phosh_dbus_ofono_sim_manager_signal_info_property_changed_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_ofono_sim_manager_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_phosh_dbus_ofono_sim_manager_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const GDBusSignalInfo * const _phosh_dbus_ofono_sim_manager_signal_info_pointers[] =
{
  &_phosh_dbus_ofono_sim_manager_signal_info_property_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_dbus_ofono_sim_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.ofono.SimManager",
    (GDBusMethodInfo **) &_phosh_dbus_ofono_sim_manager_method_info_pointers,
    (GDBusSignalInfo **) &_phosh_dbus_ofono_sim_manager_signal_info_pointers,
    NULL,
    NULL
  },
  "ofono-sim-manager",
};


/**
 * phosh_dbus_ofono_sim_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_dbus_ofono_sim_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_dbus_ofono_sim_manager_interface_info.parent_struct;
}

/**
 * phosh_dbus_ofono_sim_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshDBusOfonoSimManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_dbus_ofono_sim_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
phosh_dbus_ofono_sim_manager_signal_marshal_property_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_ofono_sim_manager_method_marshal_get_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshDBusOfonoSimManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link>.
 */

/**
 * PhoshDBusOfonoSimManagerIface:
 * @parent_iface: The parent interface.
 * @handle_get_properties: Handler for the #PhoshDBusOfonoSimManager::handle-get-properties signal.
 * @property_changed: Handler for the #PhoshDBusOfonoSimManager::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link>.
 */

typedef PhoshDBusOfonoSimManagerIface PhoshDBusOfonoSimManagerInterface;
G_DEFINE_INTERFACE (PhoshDBusOfonoSimManager, phosh_dbus_ofono_sim_manager, G_TYPE_OBJECT)

static void
phosh_dbus_ofono_sim_manager_default_init (PhoshDBusOfonoSimManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshDBusOfonoSimManager::handle-get-properties:
   * @object: A #PhoshDBusOfonoSimManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-SimManager.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_ofono_sim_manager_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusOfonoSimManagerIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_ofono_sim_manager_method_marshal_get_properties,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * PhoshDBusOfonoSimManager::property-changed:
   * @object: A #PhoshDBusOfonoSimManager.
   * @arg_unnamed_arg0: Argument.
   * @arg_unnamed_arg1: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-SimManager.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__OFONO_SIM_MANAGER_SIGNALS[PHOSH_DBUS__OFONO_SIM_MANAGER_PROPERTY_CHANGED] =
    g_signal_new ("property-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusOfonoSimManagerIface, property_changed),
      NULL,
      NULL,
      phosh_dbus_ofono_sim_manager_signal_marshal_property_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * phosh_dbus_ofono_sim_manager_emit_property_changed:
 * @object: A #PhoshDBusOfonoSimManager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 * @arg_unnamed_arg1: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-SimManager.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
phosh_dbus_ofono_sim_manager_emit_property_changed (
    PhoshDBusOfonoSimManager *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  g_signal_emit (object, PHOSH_DBUS__OFONO_SIM_MANAGER_SIGNALS[PHOSH_DBUS__OFONO_SIM_MANAGER_PROPERTY_CHANGED], 0, arg_unnamed_arg0, arg_unnamed_arg1);
}

/**
 * phosh_dbus_ofono_sim_manager_call_get_properties:
 * @proxy: A #PhoshDBusOfonoSimManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-SimManager.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_sim_manager_call_get_properties_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_sim_manager_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_ofono_sim_manager_call_get_properties (
    PhoshDBusOfonoSimManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_ofono_sim_manager_call_get_properties_finish:
 * @proxy: A #PhoshDBusOfonoSimManagerProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_sim_manager_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_ofono_sim_manager_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_ofono_sim_manager_call_get_properties_finish (
    PhoshDBusOfonoSimManager *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_ofono_sim_manager_call_get_properties_sync:
 * @proxy: A #PhoshDBusOfonoSimManagerProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-SimManager.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_sim_manager_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_ofono_sim_manager_call_get_properties_sync (
    PhoshDBusOfonoSimManager *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_ofono_sim_manager_complete_get_properties:
 * @object: A #PhoshDBusOfonoSimManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-SimManager.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_ofono_sim_manager_complete_get_properties (
    PhoshDBusOfonoSimManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusOfonoSimManagerProxy:
 *
 * The #PhoshDBusOfonoSimManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusOfonoSimManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusOfonoSimManagerProxy.
 */

struct _PhoshDBusOfonoSimManagerProxyPrivate
{
  GData *qdata;
};

static void phosh_dbus_ofono_sim_manager_proxy_iface_init (PhoshDBusOfonoSimManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoSimManagerProxy, phosh_dbus_ofono_sim_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshDBusOfonoSimManagerProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER, phosh_dbus_ofono_sim_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoSimManagerProxy, phosh_dbus_ofono_sim_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER, phosh_dbus_ofono_sim_manager_proxy_iface_init))

#endif
static void
phosh_dbus_ofono_sim_manager_proxy_finalize (GObject *object)
{
  PhoshDBusOfonoSimManagerProxy *proxy = PHOSH_DBUS_OFONO_SIM_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_dbus_ofono_sim_manager_proxy_parent_class)->finalize (object);
}

static void
phosh_dbus_ofono_sim_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_ofono_sim_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_ofono_sim_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_sim_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_dbus_ofono_sim_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshDBusOfonoSimManagerProxy *proxy = PHOSH_DBUS_OFONO_SIM_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_sim_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_sim_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
phosh_dbus_ofono_sim_manager_proxy_init (PhoshDBusOfonoSimManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_dbus_ofono_sim_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_PROXY, PhoshDBusOfonoSimManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_dbus_ofono_sim_manager_interface_info ());
}

static void
phosh_dbus_ofono_sim_manager_proxy_class_init (PhoshDBusOfonoSimManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_dbus_ofono_sim_manager_proxy_finalize;
  gobject_class->get_property = phosh_dbus_ofono_sim_manager_proxy_get_property;
  gobject_class->set_property = phosh_dbus_ofono_sim_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_dbus_ofono_sim_manager_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_dbus_ofono_sim_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusOfonoSimManagerProxyPrivate));
#endif
}

static void
phosh_dbus_ofono_sim_manager_proxy_iface_init (PhoshDBusOfonoSimManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_dbus_ofono_sim_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_sim_manager_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_sim_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_ofono_sim_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.SimManager", NULL);
}

/**
 * phosh_dbus_ofono_sim_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_sim_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_ofono_sim_manager_proxy_new().
 *
 * Returns: (transfer full) (type PhoshDBusOfonoSimManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoSimManager *
phosh_dbus_ofono_sim_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_SIM_MANAGER (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_ofono_sim_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_sim_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoSimManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoSimManager *
phosh_dbus_ofono_sim_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.SimManager", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_SIM_MANAGER (ret);
  else
    return NULL;
}


/**
 * phosh_dbus_ofono_sim_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_dbus_ofono_sim_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_sim_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_sim_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_ofono_sim_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.SimManager", NULL);
}

/**
 * phosh_dbus_ofono_sim_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_sim_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_ofono_sim_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshDBusOfonoSimManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoSimManager *
phosh_dbus_ofono_sim_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_SIM_MANAGER (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_ofono_sim_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_dbus_ofono_sim_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_sim_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoSimManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoSimManager *
phosh_dbus_ofono_sim_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.SimManager", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_SIM_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusOfonoSimManagerSkeleton:
 *
 * The #PhoshDBusOfonoSimManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusOfonoSimManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusOfonoSimManagerSkeleton.
 */

struct _PhoshDBusOfonoSimManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_dbus_ofono_sim_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshDBusOfonoSimManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_SIM_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_dbus_ofono_sim_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshDBusOfonoSimManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_SIM_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_sim_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_dbus_ofono_sim_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshDBusOfonoSimManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_SIM_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_sim_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_dbus_ofono_sim_manager_skeleton_vtable =
{
  _phosh_dbus_ofono_sim_manager_skeleton_handle_method_call,
  _phosh_dbus_ofono_sim_manager_skeleton_handle_get_property,
  _phosh_dbus_ofono_sim_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_dbus_ofono_sim_manager_interface_info ();
}

static GDBusInterfaceVTable *
phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_dbus_ofono_sim_manager_skeleton_vtable;
}

static GVariant *
phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusOfonoSimManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_SIM_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_dbus_ofono_sim_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_dbus_ofono_sim_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_dbus_ofono_sim_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_dbus_ofono_sim_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.SimManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_phosh_dbus_ofono_sim_manager_on_signal_property_changed (
    PhoshDBusOfonoSimManager *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  PhoshDBusOfonoSimManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_SIM_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.SimManager", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void phosh_dbus_ofono_sim_manager_skeleton_iface_init (PhoshDBusOfonoSimManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoSimManagerSkeleton, phosh_dbus_ofono_sim_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshDBusOfonoSimManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER, phosh_dbus_ofono_sim_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoSimManagerSkeleton, phosh_dbus_ofono_sim_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER, phosh_dbus_ofono_sim_manager_skeleton_iface_init))

#endif
static void
phosh_dbus_ofono_sim_manager_skeleton_finalize (GObject *object)
{
  PhoshDBusOfonoSimManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_SIM_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_dbus_ofono_sim_manager_skeleton_parent_class)->finalize (object);
}

static void
phosh_dbus_ofono_sim_manager_skeleton_init (PhoshDBusOfonoSimManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_dbus_ofono_sim_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_SKELETON, PhoshDBusOfonoSimManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
phosh_dbus_ofono_sim_manager_skeleton_class_init (PhoshDBusOfonoSimManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_dbus_ofono_sim_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_dbus_ofono_sim_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusOfonoSimManagerSkeletonPrivate));
#endif
}

static void
phosh_dbus_ofono_sim_manager_skeleton_iface_init (PhoshDBusOfonoSimManagerIface *iface)
{
  iface->property_changed = _phosh_dbus_ofono_sim_manager_on_signal_property_changed;
}

/**
 * phosh_dbus_ofono_sim_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ofono-SimManager.top_of_page">org.ofono.SimManager</link>.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoSimManagerSkeleton): The skeleton object.
 */
PhoshDBusOfonoSimManager *
phosh_dbus_ofono_sim_manager_skeleton_new (void)
{
  return PHOSH_DBUS_OFONO_SIM_MANAGER (g_object_new (PHOSH_DBUS_TYPE_OFONO_SIM_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.ofono.NetworkRegistration
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshDBusOfonoNetworkRegistration
 * @title: PhoshDBusOfonoNetworkRegistration
 * @short_description: Generated C code for the org.ofono.NetworkRegistration D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link> D-Bus interface in C.
 */

enum
{
  PHOSH_DBUS__OFONO_NETWORK_REGISTRATION_PROPERTY_CHANGED,
};

static unsigned PHOSH_DBUS__OFONO_NETWORK_REGISTRATION_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.ofono.NetworkRegistration ---- */

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_network_registration_method_info_get_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_network_registration_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_phosh_dbus_ofono_network_registration_method_info_get_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_ofono_network_registration_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_phosh_dbus_ofono_network_registration_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const GDBusMethodInfo * const _phosh_dbus_ofono_network_registration_method_info_pointers[] =
{
  &_phosh_dbus_ofono_network_registration_method_info_get_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_network_registration_signal_info_property_changed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_network_registration_signal_info_property_changed_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_network_registration_signal_info_property_changed_ARG_pointers[] =
{
  &_phosh_dbus_ofono_network_registration_signal_info_property_changed_ARG_unnamed_arg0.parent_struct,
  &_phosh_dbus_ofono_network_registration_signal_info_property_changed_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_ofono_network_registration_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_phosh_dbus_ofono_network_registration_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const GDBusSignalInfo * const _phosh_dbus_ofono_network_registration_signal_info_pointers[] =
{
  &_phosh_dbus_ofono_network_registration_signal_info_property_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_dbus_ofono_network_registration_interface_info =
{
  {
    -1,
    (gchar *) "org.ofono.NetworkRegistration",
    (GDBusMethodInfo **) &_phosh_dbus_ofono_network_registration_method_info_pointers,
    (GDBusSignalInfo **) &_phosh_dbus_ofono_network_registration_signal_info_pointers,
    NULL,
    NULL
  },
  "ofono-network-registration",
};


/**
 * phosh_dbus_ofono_network_registration_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_dbus_ofono_network_registration_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_dbus_ofono_network_registration_interface_info.parent_struct;
}

/**
 * phosh_dbus_ofono_network_registration_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshDBusOfonoNetworkRegistration interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_dbus_ofono_network_registration_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
phosh_dbus_ofono_network_registration_signal_marshal_property_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_ofono_network_registration_method_marshal_get_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshDBusOfonoNetworkRegistration:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link>.
 */

/**
 * PhoshDBusOfonoNetworkRegistrationIface:
 * @parent_iface: The parent interface.
 * @handle_get_properties: Handler for the #PhoshDBusOfonoNetworkRegistration::handle-get-properties signal.
 * @property_changed: Handler for the #PhoshDBusOfonoNetworkRegistration::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link>.
 */

typedef PhoshDBusOfonoNetworkRegistrationIface PhoshDBusOfonoNetworkRegistrationInterface;
G_DEFINE_INTERFACE (PhoshDBusOfonoNetworkRegistration, phosh_dbus_ofono_network_registration, G_TYPE_OBJECT)

static void
phosh_dbus_ofono_network_registration_default_init (PhoshDBusOfonoNetworkRegistrationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshDBusOfonoNetworkRegistration::handle-get-properties:
   * @object: A #PhoshDBusOfonoNetworkRegistration.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-NetworkRegistration.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_ofono_network_registration_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusOfonoNetworkRegistrationIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_ofono_network_registration_method_marshal_get_properties,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * PhoshDBusOfonoNetworkRegistration::property-changed:
   * @object: A #PhoshDBusOfonoNetworkRegistration.
   * @arg_unnamed_arg0: Argument.
   * @arg_unnamed_arg1: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-NetworkRegistration.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__OFONO_NETWORK_REGISTRATION_SIGNALS[PHOSH_DBUS__OFONO_NETWORK_REGISTRATION_PROPERTY_CHANGED] =
    g_signal_new ("property-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusOfonoNetworkRegistrationIface, property_changed),
      NULL,
      NULL,
      phosh_dbus_ofono_network_registration_signal_marshal_property_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * phosh_dbus_ofono_network_registration_emit_property_changed:
 * @object: A #PhoshDBusOfonoNetworkRegistration.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 * @arg_unnamed_arg1: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-NetworkRegistration.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
phosh_dbus_ofono_network_registration_emit_property_changed (
    PhoshDBusOfonoNetworkRegistration *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  g_signal_emit (object, PHOSH_DBUS__OFONO_NETWORK_REGISTRATION_SIGNALS[PHOSH_DBUS__OFONO_NETWORK_REGISTRATION_PROPERTY_CHANGED], 0, arg_unnamed_arg0, arg_unnamed_arg1);
}

/**
 * phosh_dbus_ofono_network_registration_call_get_properties:
 * @proxy: A #PhoshDBusOfonoNetworkRegistrationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-NetworkRegistration.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_network_registration_call_get_properties_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_network_registration_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_ofono_network_registration_call_get_properties (
    PhoshDBusOfonoNetworkRegistration *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_ofono_network_registration_call_get_properties_finish:
 * @proxy: A #PhoshDBusOfonoNetworkRegistrationProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_network_registration_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_ofono_network_registration_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_ofono_network_registration_call_get_properties_finish (
    PhoshDBusOfonoNetworkRegistration *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_ofono_network_registration_call_get_properties_sync:
 * @proxy: A #PhoshDBusOfonoNetworkRegistrationProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-NetworkRegistration.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_network_registration_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_ofono_network_registration_call_get_properties_sync (
    PhoshDBusOfonoNetworkRegistration *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_ofono_network_registration_complete_get_properties:
 * @object: A #PhoshDBusOfonoNetworkRegistration.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-NetworkRegistration.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_ofono_network_registration_complete_get_properties (
    PhoshDBusOfonoNetworkRegistration *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusOfonoNetworkRegistrationProxy:
 *
 * The #PhoshDBusOfonoNetworkRegistrationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusOfonoNetworkRegistrationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusOfonoNetworkRegistrationProxy.
 */

struct _PhoshDBusOfonoNetworkRegistrationProxyPrivate
{
  GData *qdata;
};

static void phosh_dbus_ofono_network_registration_proxy_iface_init (PhoshDBusOfonoNetworkRegistrationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoNetworkRegistrationProxy, phosh_dbus_ofono_network_registration_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshDBusOfonoNetworkRegistrationProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION, phosh_dbus_ofono_network_registration_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoNetworkRegistrationProxy, phosh_dbus_ofono_network_registration_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION, phosh_dbus_ofono_network_registration_proxy_iface_init))

#endif
static void
phosh_dbus_ofono_network_registration_proxy_finalize (GObject *object)
{
  PhoshDBusOfonoNetworkRegistrationProxy *proxy = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_dbus_ofono_network_registration_proxy_parent_class)->finalize (object);
}

static void
phosh_dbus_ofono_network_registration_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_ofono_network_registration_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_ofono_network_registration_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_network_registration_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_dbus_ofono_network_registration_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshDBusOfonoNetworkRegistrationProxy *proxy = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_network_registration_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_network_registration_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
phosh_dbus_ofono_network_registration_proxy_init (PhoshDBusOfonoNetworkRegistrationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_dbus_ofono_network_registration_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_PROXY, PhoshDBusOfonoNetworkRegistrationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_dbus_ofono_network_registration_interface_info ());
}

static void
phosh_dbus_ofono_network_registration_proxy_class_init (PhoshDBusOfonoNetworkRegistrationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_dbus_ofono_network_registration_proxy_finalize;
  gobject_class->get_property = phosh_dbus_ofono_network_registration_proxy_get_property;
  gobject_class->set_property = phosh_dbus_ofono_network_registration_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_dbus_ofono_network_registration_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_dbus_ofono_network_registration_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusOfonoNetworkRegistrationProxyPrivate));
#endif
}

static void
phosh_dbus_ofono_network_registration_proxy_iface_init (PhoshDBusOfonoNetworkRegistrationIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_dbus_ofono_network_registration_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_network_registration_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_network_registration_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_ofono_network_registration_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.NetworkRegistration", NULL);
}

/**
 * phosh_dbus_ofono_network_registration_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_network_registration_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_ofono_network_registration_proxy_new().
 *
 * Returns: (transfer full) (type PhoshDBusOfonoNetworkRegistrationProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoNetworkRegistration *
phosh_dbus_ofono_network_registration_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_NETWORK_REGISTRATION (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_ofono_network_registration_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_network_registration_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoNetworkRegistrationProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoNetworkRegistration *
phosh_dbus_ofono_network_registration_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.NetworkRegistration", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_NETWORK_REGISTRATION (ret);
  else
    return NULL;
}


/**
 * phosh_dbus_ofono_network_registration_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_dbus_ofono_network_registration_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_network_registration_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_network_registration_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_ofono_network_registration_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.NetworkRegistration", NULL);
}

/**
 * phosh_dbus_ofono_network_registration_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_network_registration_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_ofono_network_registration_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshDBusOfonoNetworkRegistrationProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoNetworkRegistration *
phosh_dbus_ofono_network_registration_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_NETWORK_REGISTRATION (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_ofono_network_registration_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_dbus_ofono_network_registration_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_network_registration_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoNetworkRegistrationProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoNetworkRegistration *
phosh_dbus_ofono_network_registration_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.NetworkRegistration", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_NETWORK_REGISTRATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusOfonoNetworkRegistrationSkeleton:
 *
 * The #PhoshDBusOfonoNetworkRegistrationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusOfonoNetworkRegistrationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusOfonoNetworkRegistrationSkeleton.
 */

struct _PhoshDBusOfonoNetworkRegistrationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_dbus_ofono_network_registration_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_dbus_ofono_network_registration_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_network_registration_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_dbus_ofono_network_registration_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_network_registration_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_dbus_ofono_network_registration_skeleton_vtable =
{
  _phosh_dbus_ofono_network_registration_skeleton_handle_method_call,
  _phosh_dbus_ofono_network_registration_skeleton_handle_get_property,
  _phosh_dbus_ofono_network_registration_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_dbus_ofono_network_registration_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_dbus_ofono_network_registration_interface_info ();
}

static GDBusInterfaceVTable *
phosh_dbus_ofono_network_registration_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_dbus_ofono_network_registration_skeleton_vtable;
}

static GVariant *
phosh_dbus_ofono_network_registration_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_dbus_ofono_network_registration_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_dbus_ofono_network_registration_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_dbus_ofono_network_registration_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_dbus_ofono_network_registration_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.NetworkRegistration", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
phosh_dbus_ofono_network_registration_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_phosh_dbus_ofono_network_registration_on_signal_property_changed (
    PhoshDBusOfonoNetworkRegistration *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.NetworkRegistration", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void phosh_dbus_ofono_network_registration_skeleton_iface_init (PhoshDBusOfonoNetworkRegistrationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoNetworkRegistrationSkeleton, phosh_dbus_ofono_network_registration_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshDBusOfonoNetworkRegistrationSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION, phosh_dbus_ofono_network_registration_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoNetworkRegistrationSkeleton, phosh_dbus_ofono_network_registration_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION, phosh_dbus_ofono_network_registration_skeleton_iface_init))

#endif
static void
phosh_dbus_ofono_network_registration_skeleton_finalize (GObject *object)
{
  PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton = PHOSH_DBUS_OFONO_NETWORK_REGISTRATION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_dbus_ofono_network_registration_skeleton_parent_class)->finalize (object);
}

static void
phosh_dbus_ofono_network_registration_skeleton_init (PhoshDBusOfonoNetworkRegistrationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_dbus_ofono_network_registration_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_SKELETON, PhoshDBusOfonoNetworkRegistrationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
phosh_dbus_ofono_network_registration_skeleton_class_init (PhoshDBusOfonoNetworkRegistrationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_dbus_ofono_network_registration_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_dbus_ofono_network_registration_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_dbus_ofono_network_registration_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_dbus_ofono_network_registration_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_dbus_ofono_network_registration_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusOfonoNetworkRegistrationSkeletonPrivate));
#endif
}

static void
phosh_dbus_ofono_network_registration_skeleton_iface_init (PhoshDBusOfonoNetworkRegistrationIface *iface)
{
  iface->property_changed = _phosh_dbus_ofono_network_registration_on_signal_property_changed;
}

/**
 * phosh_dbus_ofono_network_registration_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ofono-NetworkRegistration.top_of_page">org.ofono.NetworkRegistration</link>.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoNetworkRegistrationSkeleton): The skeleton object.
 */
PhoshDBusOfonoNetworkRegistration *
phosh_dbus_ofono_network_registration_skeleton_new (void)
{
  return PHOSH_DBUS_OFONO_NETWORK_REGISTRATION (g_object_new (PHOSH_DBUS_TYPE_OFONO_NETWORK_REGISTRATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.ofono.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshDBusOfonoManager
 * @title: PhoshDBusOfonoManager
 * @short_description: Generated C code for the org.ofono.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link> D-Bus interface in C.
 */

enum
{
  PHOSH_DBUS__OFONO_MANAGER_MODEM_ADDED,
  PHOSH_DBUS__OFONO_MANAGER_MODEM_REMOVED,
};

static unsigned PHOSH_DBUS__OFONO_MANAGER_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.ofono.Manager ---- */

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_manager_method_info_get_modems_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "a(oa{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_manager_method_info_get_modems_OUT_ARG_pointers[] =
{
  &_phosh_dbus_ofono_manager_method_info_get_modems_OUT_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_ofono_manager_method_info_get_modems =
{
  {
    -1,
    (gchar *) "GetModems",
    NULL,
    (GDBusArgInfo **) &_phosh_dbus_ofono_manager_method_info_get_modems_OUT_ARG_pointers,
    NULL
  },
  "handle-get-modems",
  FALSE
};

static const GDBusMethodInfo * const _phosh_dbus_ofono_manager_method_info_pointers[] =
{
  &_phosh_dbus_ofono_manager_method_info_get_modems.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_manager_signal_info_modem_added_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_manager_signal_info_modem_added_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_manager_signal_info_modem_added_ARG_pointers[] =
{
  &_phosh_dbus_ofono_manager_signal_info_modem_added_ARG_unnamed_arg0.parent_struct,
  &_phosh_dbus_ofono_manager_signal_info_modem_added_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_ofono_manager_signal_info_modem_added =
{
  {
    -1,
    (gchar *) "ModemAdded",
    (GDBusArgInfo **) &_phosh_dbus_ofono_manager_signal_info_modem_added_ARG_pointers,
    NULL
  },
  "modem-added"
};

static const _ExtendedGDBusArgInfo _phosh_dbus_ofono_manager_signal_info_modem_removed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_ofono_manager_signal_info_modem_removed_ARG_pointers[] =
{
  &_phosh_dbus_ofono_manager_signal_info_modem_removed_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_ofono_manager_signal_info_modem_removed =
{
  {
    -1,
    (gchar *) "ModemRemoved",
    (GDBusArgInfo **) &_phosh_dbus_ofono_manager_signal_info_modem_removed_ARG_pointers,
    NULL
  },
  "modem-removed"
};

static const GDBusSignalInfo * const _phosh_dbus_ofono_manager_signal_info_pointers[] =
{
  &_phosh_dbus_ofono_manager_signal_info_modem_added.parent_struct,
  &_phosh_dbus_ofono_manager_signal_info_modem_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_dbus_ofono_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.ofono.Manager",
    (GDBusMethodInfo **) &_phosh_dbus_ofono_manager_method_info_pointers,
    (GDBusSignalInfo **) &_phosh_dbus_ofono_manager_signal_info_pointers,
    NULL,
    NULL
  },
  "ofono-manager",
};


/**
 * phosh_dbus_ofono_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_dbus_ofono_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_dbus_ofono_manager_interface_info.parent_struct;
}

/**
 * phosh_dbus_ofono_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshDBusOfonoManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_dbus_ofono_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
phosh_dbus_ofono_manager_signal_marshal_modem_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_ofono_manager_signal_marshal_modem_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_ofono_manager_method_marshal_get_modems (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshDBusOfonoManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link>.
 */

/**
 * PhoshDBusOfonoManagerIface:
 * @parent_iface: The parent interface.
 * @handle_get_modems: Handler for the #PhoshDBusOfonoManager::handle-get-modems signal.
 * @modem_added: Handler for the #PhoshDBusOfonoManager::modem-added signal.
 * @modem_removed: Handler for the #PhoshDBusOfonoManager::modem-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link>.
 */

typedef PhoshDBusOfonoManagerIface PhoshDBusOfonoManagerInterface;
G_DEFINE_INTERFACE (PhoshDBusOfonoManager, phosh_dbus_ofono_manager, G_TYPE_OBJECT)

static void
phosh_dbus_ofono_manager_default_init (PhoshDBusOfonoManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshDBusOfonoManager::handle-get-modems:
   * @object: A #PhoshDBusOfonoManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-Manager.GetModems">GetModems()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_ofono_manager_complete_get_modems() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-modems",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusOfonoManagerIface, handle_get_modems),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_ofono_manager_method_marshal_get_modems,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * PhoshDBusOfonoManager::modem-added:
   * @object: A #PhoshDBusOfonoManager.
   * @arg_unnamed_arg0: Argument.
   * @arg_unnamed_arg1: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-Manager.ModemAdded">"ModemAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__OFONO_MANAGER_SIGNALS[PHOSH_DBUS__OFONO_MANAGER_MODEM_ADDED] =
    g_signal_new ("modem-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusOfonoManagerIface, modem_added),
      NULL,
      NULL,
      phosh_dbus_ofono_manager_signal_marshal_modem_added,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * PhoshDBusOfonoManager::modem-removed:
   * @object: A #PhoshDBusOfonoManager.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-Manager.ModemRemoved">"ModemRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__OFONO_MANAGER_SIGNALS[PHOSH_DBUS__OFONO_MANAGER_MODEM_REMOVED] =
    g_signal_new ("modem-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusOfonoManagerIface, modem_removed),
      NULL,
      NULL,
      phosh_dbus_ofono_manager_signal_marshal_modem_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * phosh_dbus_ofono_manager_emit_modem_added:
 * @object: A #PhoshDBusOfonoManager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 * @arg_unnamed_arg1: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-Manager.ModemAdded">"ModemAdded"</link> D-Bus signal.
 */
void
phosh_dbus_ofono_manager_emit_modem_added (
    PhoshDBusOfonoManager *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  g_signal_emit (object, PHOSH_DBUS__OFONO_MANAGER_SIGNALS[PHOSH_DBUS__OFONO_MANAGER_MODEM_ADDED], 0, arg_unnamed_arg0, arg_unnamed_arg1);
}

/**
 * phosh_dbus_ofono_manager_emit_modem_removed:
 * @object: A #PhoshDBusOfonoManager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-Manager.ModemRemoved">"ModemRemoved"</link> D-Bus signal.
 */
void
phosh_dbus_ofono_manager_emit_modem_removed (
    PhoshDBusOfonoManager *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit (object, PHOSH_DBUS__OFONO_MANAGER_SIGNALS[PHOSH_DBUS__OFONO_MANAGER_MODEM_REMOVED], 0, arg_unnamed_arg0);
}

/**
 * phosh_dbus_ofono_manager_call_get_modems:
 * @proxy: A #PhoshDBusOfonoManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-Manager.GetModems">GetModems()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_manager_call_get_modems_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_manager_call_get_modems_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_ofono_manager_call_get_modems (
    PhoshDBusOfonoManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetModems",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_ofono_manager_call_get_modems_finish:
 * @proxy: A #PhoshDBusOfonoManagerProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_manager_call_get_modems().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_ofono_manager_call_get_modems().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_ofono_manager_call_get_modems_finish (
    PhoshDBusOfonoManager *proxy,
    GVariant **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(oa{sv}))",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_ofono_manager_call_get_modems_sync:
 * @proxy: A #PhoshDBusOfonoManagerProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-Manager.GetModems">GetModems()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_manager_call_get_modems() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_ofono_manager_call_get_modems_sync (
    PhoshDBusOfonoManager *proxy,
    GVariant **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetModems",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(oa{sv}))",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_ofono_manager_complete_get_modems:
 * @object: A #PhoshDBusOfonoManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-Manager.GetModems">GetModems()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_ofono_manager_complete_get_modems (
    PhoshDBusOfonoManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(oa{sv}))",
                   unnamed_arg0));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusOfonoManagerProxy:
 *
 * The #PhoshDBusOfonoManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusOfonoManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusOfonoManagerProxy.
 */

struct _PhoshDBusOfonoManagerProxyPrivate
{
  GData *qdata;
};

static void phosh_dbus_ofono_manager_proxy_iface_init (PhoshDBusOfonoManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoManagerProxy, phosh_dbus_ofono_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshDBusOfonoManagerProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_MANAGER, phosh_dbus_ofono_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoManagerProxy, phosh_dbus_ofono_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_MANAGER, phosh_dbus_ofono_manager_proxy_iface_init))

#endif
static void
phosh_dbus_ofono_manager_proxy_finalize (GObject *object)
{
  PhoshDBusOfonoManagerProxy *proxy = PHOSH_DBUS_OFONO_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_dbus_ofono_manager_proxy_parent_class)->finalize (object);
}

static void
phosh_dbus_ofono_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_ofono_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_ofono_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_DBUS_TYPE_OFONO_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_OFONO_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_dbus_ofono_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshDBusOfonoManagerProxy *proxy = PHOSH_DBUS_OFONO_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
phosh_dbus_ofono_manager_proxy_init (PhoshDBusOfonoManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_dbus_ofono_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_DBUS_TYPE_OFONO_MANAGER_PROXY, PhoshDBusOfonoManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_dbus_ofono_manager_interface_info ());
}

static void
phosh_dbus_ofono_manager_proxy_class_init (PhoshDBusOfonoManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_dbus_ofono_manager_proxy_finalize;
  gobject_class->get_property = phosh_dbus_ofono_manager_proxy_get_property;
  gobject_class->set_property = phosh_dbus_ofono_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_dbus_ofono_manager_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_dbus_ofono_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusOfonoManagerProxyPrivate));
#endif
}

static void
phosh_dbus_ofono_manager_proxy_iface_init (PhoshDBusOfonoManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_dbus_ofono_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_manager_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_ofono_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_OFONO_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.Manager", NULL);
}

/**
 * phosh_dbus_ofono_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_ofono_manager_proxy_new().
 *
 * Returns: (transfer full) (type PhoshDBusOfonoManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoManager *
phosh_dbus_ofono_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_MANAGER (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_ofono_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoManager *
phosh_dbus_ofono_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_OFONO_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.Manager", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_MANAGER (ret);
  else
    return NULL;
}


/**
 * phosh_dbus_ofono_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_dbus_ofono_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_ofono_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_dbus_ofono_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_ofono_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_OFONO_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.Manager", NULL);
}

/**
 * phosh_dbus_ofono_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_ofono_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_ofono_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshDBusOfonoManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoManager *
phosh_dbus_ofono_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_MANAGER (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_ofono_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_dbus_ofono_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_ofono_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusOfonoManager *
phosh_dbus_ofono_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_OFONO_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.Manager", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_OFONO_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusOfonoManagerSkeleton:
 *
 * The #PhoshDBusOfonoManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusOfonoManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusOfonoManagerSkeleton.
 */

struct _PhoshDBusOfonoManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_dbus_ofono_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_DBUS_TYPE_OFONO_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_OFONO_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_dbus_ofono_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_dbus_ofono_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_ofono_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_dbus_ofono_manager_skeleton_vtable =
{
  _phosh_dbus_ofono_manager_skeleton_handle_method_call,
  _phosh_dbus_ofono_manager_skeleton_handle_get_property,
  _phosh_dbus_ofono_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_dbus_ofono_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_dbus_ofono_manager_interface_info ();
}

static GDBusInterfaceVTable *
phosh_dbus_ofono_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_dbus_ofono_manager_skeleton_vtable;
}

static GVariant *
phosh_dbus_ofono_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_dbus_ofono_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_dbus_ofono_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_dbus_ofono_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_dbus_ofono_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
phosh_dbus_ofono_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_phosh_dbus_ofono_manager_on_signal_modem_added (
    PhoshDBusOfonoManager *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.Manager", "ModemAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_ofono_manager_on_signal_modem_removed (
    PhoshDBusOfonoManager *object,
    const gchar *arg_unnamed_arg0)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.Manager", "ModemRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void phosh_dbus_ofono_manager_skeleton_iface_init (PhoshDBusOfonoManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoManagerSkeleton, phosh_dbus_ofono_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshDBusOfonoManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_MANAGER, phosh_dbus_ofono_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusOfonoManagerSkeleton, phosh_dbus_ofono_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_OFONO_MANAGER, phosh_dbus_ofono_manager_skeleton_iface_init))

#endif
static void
phosh_dbus_ofono_manager_skeleton_finalize (GObject *object)
{
  PhoshDBusOfonoManagerSkeleton *skeleton = PHOSH_DBUS_OFONO_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_dbus_ofono_manager_skeleton_parent_class)->finalize (object);
}

static void
phosh_dbus_ofono_manager_skeleton_init (PhoshDBusOfonoManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_dbus_ofono_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_DBUS_TYPE_OFONO_MANAGER_SKELETON, PhoshDBusOfonoManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
phosh_dbus_ofono_manager_skeleton_class_init (PhoshDBusOfonoManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_dbus_ofono_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_dbus_ofono_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_dbus_ofono_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_dbus_ofono_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_dbus_ofono_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusOfonoManagerSkeletonPrivate));
#endif
}

static void
phosh_dbus_ofono_manager_skeleton_iface_init (PhoshDBusOfonoManagerIface *iface)
{
  iface->modem_added = _phosh_dbus_ofono_manager_on_signal_modem_added;
  iface->modem_removed = _phosh_dbus_ofono_manager_on_signal_modem_removed;
}

/**
 * phosh_dbus_ofono_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Manager.top_of_page">org.ofono.Manager</link>.
 *
 * Returns: (transfer full) (type PhoshDBusOfonoManagerSkeleton): The skeleton object.
 */
PhoshDBusOfonoManager *
phosh_dbus_ofono_manager_skeleton_new (void)
{
  return PHOSH_DBUS_OFONO_MANAGER (g_object_new (PHOSH_DBUS_TYPE_OFONO_MANAGER_SKELETON, NULL));
}

