// python wrapper for vtkPVProxyDefinitionIterator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVProxyDefinitionIterator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVProxyDefinitionIterator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVProxyDefinitionIterator_ClassNew(); }


static PyObject *
PyvtkPVProxyDefinitionIterator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVProxyDefinitionIterator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVProxyDefinitionIterator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVProxyDefinitionIterator *tempr = vtkPVProxyDefinitionIterator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVProxyDefinitionIterator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVProxyDefinitionIterator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVProxyDefinitionIterator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVProxyDefinitionIterator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GoToFirstItem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToFirstItem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->GoToFirstItem();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_InitTraversal(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitTraversal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InitTraversal();
    }
    else
    {
      op->vtkPVProxyDefinitionIterator::InitTraversal();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GoToNextItem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToNextItem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->GoToNextItem();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GoToNextGroup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GoToNextGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->GoToNextGroup();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_IsDoneWithTraversal(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsDoneWithTraversal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    bool tempr = op->IsDoneWithTraversal();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_AddTraversalGroupName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTraversalGroupName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->AddTraversalGroupName(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GetGroupName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGroupName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetGroupName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GetProxyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetProxyName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_IsCustom(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsCustom");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsCustom() :
      op->vtkPVProxyDefinitionIterator::IsCustom());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GetProxyDefinition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxyDefinition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    vtkPVXMLElement *tempr = op->GetProxyDefinition();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProxyDefinitionIterator_GetProxyHints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxyHints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProxyDefinitionIterator *op = static_cast<vtkPVProxyDefinitionIterator *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    vtkPVXMLElement *tempr = op->GetProxyHints();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVProxyDefinitionIterator_Methods[] = {
  {"IsTypeOf", PyvtkPVProxyDefinitionIterator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVProxyDefinitionIterator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVProxyDefinitionIterator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVProxyDefinitionIterator\nC++: static vtkPVProxyDefinitionIterator *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVProxyDefinitionIterator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVProxyDefinitionIterator\nC++: vtkPVProxyDefinitionIterator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVProxyDefinitionIterator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVProxyDefinitionIterator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GoToFirstItem", PyvtkPVProxyDefinitionIterator_GoToFirstItem, METH_VARARGS,
   "GoToFirstItem(self) -> None\nC++: virtual void GoToFirstItem()\n\nMove the iterator to the beginning.\n"},
  {"InitTraversal", PyvtkPVProxyDefinitionIterator_InitTraversal, METH_VARARGS,
   "InitTraversal(self) -> None\nC++: virtual void InitTraversal()\n\nReset the iterator and move it to the head.\n"},
  {"GoToNextItem", PyvtkPVProxyDefinitionIterator_GoToNextItem, METH_VARARGS,
   "GoToNextItem(self) -> None\nC++: virtual void GoToNextItem()\n\nMove the iterator to the next item. This will also move to next\ngroup automatically if needed.\n"},
  {"GoToNextGroup", PyvtkPVProxyDefinitionIterator_GoToNextGroup, METH_VARARGS,
   "GoToNextGroup(self) -> None\nC++: virtual void GoToNextGroup()\n\nMove the iterator to the next group.\n"},
  {"IsDoneWithTraversal", PyvtkPVProxyDefinitionIterator_IsDoneWithTraversal, METH_VARARGS,
   "IsDoneWithTraversal(self) -> bool\nC++: virtual bool IsDoneWithTraversal()\n\nTest whether the iterator is currently pointing to a valid item.\n"},
  {"AddTraversalGroupName", PyvtkPVProxyDefinitionIterator_AddTraversalGroupName, METH_VARARGS,
   "AddTraversalGroupName(self, groupName:str) -> None\nC++: virtual void AddTraversalGroupName(const char *groupName)\n\n"},
  {"GetGroupName", PyvtkPVProxyDefinitionIterator_GetGroupName, METH_VARARGS,
   "GetGroupName(self) -> str\nC++: virtual const char *GetGroupName()\n\nReturn the current group name or nullptr if Next() was never\ncalled.\n"},
  {"GetProxyName", PyvtkPVProxyDefinitionIterator_GetProxyName, METH_VARARGS,
   "GetProxyName(self) -> str\nC++: virtual const char *GetProxyName()\n\nReturn the current proxy name or nullptr if Next() was never\ncalled.\n"},
  {"IsCustom", PyvtkPVProxyDefinitionIterator_IsCustom, METH_VARARGS,
   "IsCustom(self) -> bool\nC++: virtual bool IsCustom()\n\nReturn true if the current definition has been defined in the\nCustom scope\n"},
  {"GetProxyDefinition", PyvtkPVProxyDefinitionIterator_GetProxyDefinition, METH_VARARGS,
   "GetProxyDefinition(self) -> vtkPVXMLElement\nC++: virtual vtkPVXMLElement *GetProxyDefinition()\n\nReturn the current XML proxy definition\n"},
  {"GetProxyHints", PyvtkPVProxyDefinitionIterator_GetProxyHints, METH_VARARGS,
   "GetProxyHints(self) -> vtkPVXMLElement\nC++: virtual vtkPVXMLElement *GetProxyHints()\n\nReturn the current XML proxy hints\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVProxyDefinitionIterator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("group_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProxyDefinitionIterator_GetGroupName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGroupName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("proxy_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProxyDefinitionIterator_GetProxyName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProxyName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("proxy_definition"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProxyDefinitionIterator_GetProxyDefinition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProxyDefinition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("proxy_hints"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProxyDefinitionIterator_GetProxyHints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProxyHints\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVProxyDefinitionIterator_Doc =
  "vtkPVProxyDefinitionIterator - iterates over all proxy definitions\nfrom which the vtkSMProxyManager can use to create new proxy.\n\n"
  "Superclass: vtkObject\n\n"
  "It can also iterate over registered compound proxy definitions.\n\n"
  "vtkPVProxyDefinitionIterator iterates over all proxy definitions\n"
  "known to the proxy manager. The iterator allow to filter the\n"
  "iteration on a subset of group and/or on the global or custom\n"
  "proxies. Custom and Compound proxy are exactly the same thing. We\n"
  "should stick with only one name.\n"
  "@sa\n"
  "vtkSMProxyManager\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVProxyDefinitionIterator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVProxyDefinitionIterator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVProxyDefinitionIterator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkPVProxyDefinitionIterator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVProxyDefinitionIterator_Type, PyvtkPVProxyDefinitionIterator_Methods,
    "vtkPVProxyDefinitionIterator",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVProxyDefinitionIterator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVProxyDefinitionIterator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVProxyDefinitionIterator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVProxyDefinitionIterator", o) != 0)
  {
    Py_DECREF(o);
  }

}

