// python wrapper for vtkSMMultiplexerSourceProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMMultiplexerSourceProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMMultiplexerSourceProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMMultiplexerSourceProxy_ClassNew(); }

#ifndef DECLARED_PyvtkSMSourceProxy_ClassNew
extern "C" { PyObject *PyvtkSMSourceProxy_ClassNew(); }
#define DECLARED_PyvtkSMSourceProxy_ClassNew
#endif

static PyObject *
PyvtkSMMultiplexerSourceProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMMultiplexerSourceProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMultiplexerSourceProxy *op = static_cast<vtkSMMultiplexerSourceProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMMultiplexerSourceProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMMultiplexerSourceProxy *tempr = vtkSMMultiplexerSourceProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMultiplexerSourceProxy *op = static_cast<vtkSMMultiplexerSourceProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMMultiplexerSourceProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMMultiplexerSourceProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMMultiplexerSourceProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMultiplexerSourceProxy *op = static_cast<vtkSMMultiplexerSourceProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMMultiplexerSourceProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_SaveXMLState_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveXMLState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMultiplexerSourceProxy *op = static_cast<vtkSMMultiplexerSourceProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  vtkSMPropertyIterator *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      ap.GetVTKObject(temp1, "vtkSMPropertyIterator"))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->SaveXMLState(temp0, temp1) :
      op->vtkSMMultiplexerSourceProxy::SaveXMLState(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMMultiplexerSourceProxy_SaveXMLState_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveXMLState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMultiplexerSourceProxy *op = static_cast<vtkSMMultiplexerSourceProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->SaveXMLState(temp0) :
      op->vtkSMMultiplexerSourceProxy::SaveXMLState(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMMultiplexerSourceProxy_SaveXMLState(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMMultiplexerSourceProxy_SaveXMLState_s1(self, args);
    case 1:
      return PyvtkSMMultiplexerSourceProxy_SaveXMLState_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SaveXMLState");
  return nullptr;
}


static PyObject *
PyvtkSMMultiplexerSourceProxy_LoadXMLState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadXMLState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMultiplexerSourceProxy *op = static_cast<vtkSMMultiplexerSourceProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  vtkSMProxyLocator *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      ap.GetVTKObject(temp1, "vtkSMProxyLocator"))
  {
    int tempr = (ap.IsBound() ?
      op->LoadXMLState(temp0, temp1) :
      op->vtkSMMultiplexerSourceProxy::LoadXMLState(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMMultiplexerSourceProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMMultiplexerSourceProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMMultiplexerSourceProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMMultiplexerSourceProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMMultiplexerSourceProxy\nC++: static vtkSMMultiplexerSourceProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMMultiplexerSourceProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMMultiplexerSourceProxy\nC++: vtkSMMultiplexerSourceProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMMultiplexerSourceProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMMultiplexerSourceProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SaveXMLState", PyvtkSMMultiplexerSourceProxy_SaveXMLState, METH_VARARGS,
   "SaveXMLState(self, root:vtkPVXMLElement,\n    iter:vtkSMPropertyIterator) -> vtkPVXMLElement\nC++: vtkPVXMLElement *SaveXMLState(vtkPVXMLElement *root,\n    vtkSMPropertyIterator *iter) override;\nSaveXMLState(self, root:vtkPVXMLElement) -> vtkPVXMLElement\nC++: virtual vtkPVXMLElement *SaveXMLState(vtkPVXMLElement *root)\n\nThe iterator is use to filter the property available on the given\nproxy\n"},
  {"LoadXMLState", PyvtkSMMultiplexerSourceProxy_LoadXMLState, METH_VARARGS,
   "LoadXMLState(self, element:vtkPVXMLElement,\n    locator:vtkSMProxyLocator) -> int\nC++: int LoadXMLState(vtkPVXMLElement *element,\n    vtkSMProxyLocator *locator) override;\n\nLoads the proxy state from the XML element. Returns 0 on\nfailure.locator is used to locate other proxies that may be\nreferred to in the state XML (which happens in case of properties\nof type vtkSMProxyProperty or subclasses). If locator is nullptr,\nthen such properties are left unchanged.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMMultiplexerSourceProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMMultiplexerSourceProxy_Doc =
  "vtkSMMultiplexerSourceProxy - a multiplexer proxy\n\n"
  "Superclass: vtkSMSourceProxy\n\n"
  "vtkSMMultiplexerSourceProxy is a multiplexer that can pick and act as\n"
  "one of the internal proxies (called multiplexed proxies). Once a\n"
  "choice is made, for all intents and purposes the multiplexer behaves\n"
  "like the chosen proxy.\n\n"
  "For original motivation and design, refer to paraview/paraview#19936.\n\n"
  "@section DefineMultiplexer Defining a Multiplexer Proxy\n\n"
  "A multiplexer proxy can be defined in the ServerManager XML\n"
  "configuration as follows:\n\n"
  "{xml}\n"
  "<ProxyGroup name=\"filters\">\n"
  " <MultiplexerSourceProxy name=\"ExtractBlock\" label=\"Extract Block\">\n"
  "   <Documentation long_help=\"Extract blocks from composite datasets\">\n"
  "     This filter extract blocks.\n"
  "   \n\n\n"
  "   <InputProperty name=\"Input\">\n"
  "     \n"
  "       Specify the input to this filter.\n"
  "     \n"
  "     <MultiplexerInputDomain name=\"input\" />\n"
  "   \n"
  " \n\n"
  "It's similar to other proxy definitions, except a few key\n"
  "differences:\n\n"
  "* A `classname` attribute is generally not specified. The\n"
  "  implementation internally creates a `vtkPassThroughFilter`.\n"
  "* Only properties that help with the selection of the multiplexed\n"
  "  proxy are defined.\n"
  "* `InputProperty` must have `MultiplexerInputDomain` as the domain.\n"
  "  This is essential to ensure that `IsInDomain` checks take into\n"
  "  consideration input domains for all available multiplexed proxies.\n\n"
  "Defining proxies that should be included as the available multiplexed\n"
  "proxies is done by adding the `<MultiplexerSourceProxy />` hint as\n"
  "follows:\n\n"
  "{xml}\n"
  "<SourceProxy class=\"vtkExtractBlock\"\n"
  "              name=\"ExtractBlockUsingIds\">\n"
  "   <Documentation long_help=\"This filter extracts a range of blocks from a multiblock\n"
  "dataset.\"\n"
  "                  short_help=\"Extract block.\">This filter extracts a\n"
  "range\n"
  "                  of groups from a multiblock dataset\n"
  "   <InputProperty name=\"Input\" command=\"SetInputConnection\">\n"
  "     <DataTypeDomain name=\"input_type\">\n"
  "       <DataType value=\"vtkMultiBlockDataSet\" />\n"
  "     \n"
  "   \n"
  "   ...\n"
  "   \n"
  "     <MultiplexerSourceProxy proxygroup=\"filters\"\n"
  "proxyname=\"ExtractBlock\" >\n"
  "       \n"
  "         <Property name=\"Input\" with_property=\"Input\" />\n"
  "       \n"
  "     \n"
  "   \n\n"
  "The `proxygroup` and `proxyname` on the `MultiplexerSourceProxy` hint\n"
  "element refer to the group and name of the multiplexed proxy. If the\n"
  "proxy can be part of multiple multiplexers, then multiple\n"
  "`MultiplexerSourceProxy` elements can be added to the hints.\n\n"
  "When a vtkSMMultiplexerSourceProxy is instantiated, it looks for all\n"
  "available proxy definitions that have a matching\n"
  "`MultiplexerSourceProxy` hint. The optional `LinkProperties` nested\n"
  "element defines how the properties on this proxy map to properties on\n"
  "the multiplexer proxy. If not specified, they are matched by name.\n\n"
  "In `vtkSMMultiplexerSourceProxy::CreateVTKObjects`, based on the\n"
  "values set on the multiplexer's properties, one (or more) of the\n"
  "available multiplexed proxies are chosen and rest are discarded.\n"
  "Selecting a proxy implies that it will be added as subproxies, and\n"
  "its properties (those that are not linked with properties on the\n"
  "multiplexer) exposed from the multiplexer so that they are available\n"
  "for users to check and set.\n\n"
  "The check to see if one of the available multiplexed proxy can be\n"
  "chosen is as follows: for each property on the multiplexed proxy that\n"
  "is linked with a property on the multiplexer, we copy the current\n"
  "value from the multiplexer property and then check if the value is in\n"
  "domain (vtkSMProperty::IsInDomains); if it succeeds for all linked\n"
  "properties, then that multiplexed property is chosen, else it's not\n"
  "and is discarded.\n\n"
  "Current implementation is intended for at most 1 proxy to be chosen.\n"
  "If multiple proxies succeed at this test, current implementation only\n"
  "selects the first one.\n\n"
  "@section vtkSMMultiplexerSourceProxy_caveats Caveats\n\n"
  "While the implementation has some initial plumbing to support\n"
  "multiple multiplexed proxies, currently we only support exactly one.\n"
  "In future, the plan is to add a user-settable property to choose\n"
  "between multiple proxies if multiple of them match.\n\n"
  "When multiple proxies are chosen, we need to add a mechanism to share\n"
  "properties with same names between the chosen proxies since we cannot\n"
  "expose a property with same name multiple times.\n\n"
  "@section python_support Python Support\n\n"
  "vtkSMMultiplexerSourceProxy currently suffers from lack of Python\n"
  "support. ParaView's Python infrastructure is not capable of\n"
  "supporting different instances of the same proxy with different set\n"
  "of properties. Consequently, do not use this unless you don't need\n"
  "Python support. See paraview/paraview#20187.\n\n"
  "@sa vtkSIMultiplexerSourceProxy, vtkSMMultiplexerInputDomain.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMMultiplexerSourceProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMMultiplexerSourceProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMMultiplexerSourceProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMMultiplexerSourceProxy_StaticNew()
{
  return vtkSMMultiplexerSourceProxy::New();
}

PyObject *PyvtkSMMultiplexerSourceProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMMultiplexerSourceProxy_Type, PyvtkSMMultiplexerSourceProxy_Methods,
    "vtkSMMultiplexerSourceProxy",
 &PyvtkSMMultiplexerSourceProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMSourceProxy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMMultiplexerSourceProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMMultiplexerSourceProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMMultiplexerSourceProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMMultiplexerSourceProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

