static PyMethodDef methods_cv[] = {
    {"AKAZE_create", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_create, 0), "AKAZE_create([, descriptor_type[, descriptor_size[, descriptor_channels[, threshold[, nOctaves[, nOctaveLayers[, diffusivity[, max_points]]]]]]]]) -> retval\n.   @brief The AKAZE constructor\n.   \n.       @param descriptor_type Type of the extracted descriptor: DESCRIPTOR_KAZE,\n.       DESCRIPTOR_KAZE_UPRIGHT, DESCRIPTOR_MLDB or DESCRIPTOR_MLDB_UPRIGHT.\n.       @param descriptor_size Size of the descriptor in bits. 0 -\\> Full size\n.       @param descriptor_channels Number of channels in the descriptor (1, 2, 3)\n.       @param threshold Detector response threshold to accept point\n.       @param nOctaves Maximum octave evolution of the image\n.       @param nOctaveLayers Default number of sublevels per scale level\n.       @param diffusivity Diffusivity type. DIFF_PM_G1, DIFF_PM_G2, DIFF_WEICKERT or\n.       DIFF_CHARBONNIER\n.       @param max_points Maximum amount of returned points. In case if image contains\n.       more features, then the features with highest response are returned.\n.       Negative value means no limitation."},
    {"AffineFeature_create", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineFeature_create, 0), "AffineFeature_create(backend[, maxTilt[, minTilt[, tiltStep[, rotateStepBase]]]]) -> retval\n.   @param backend The detector/extractor you want to use as backend.\n.       @param maxTilt The highest power index of tilt factor. 5 is used in the paper as tilt sampling range n.\n.       @param minTilt The lowest power index of tilt factor. 0 is used in the paper.\n.       @param tiltStep Tilt sampling step \\f$\\delta_t\\f$ in Algorithm 1 in the paper.\n.       @param rotateStepBase Rotation sampling step factor b in Algorithm 1 in the paper."},
    {"AgastFeatureDetector_create", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_create, 0), "AgastFeatureDetector_create([, threshold[, nonmaxSuppression[, type]]]) -> retval\n."},
    {"BFMatcher_create", CV_PY_FN_WITH_KW_(pyopencv_cv_BFMatcher_create, 0), "BFMatcher_create([, normType[, crossCheck]]) -> retval\n.   @brief Brute-force matcher create method.\n.       @param normType One of NORM_L1, NORM_L2, NORM_HAMMING, NORM_HAMMING2. L1 and L2 norms are\n.       preferable choices for SIFT and SURF descriptors, NORM_HAMMING should be used with ORB, BRISK and\n.       BRIEF, NORM_HAMMING2 should be used with ORB when WTA_K==3 or 4 (see ORB::ORB constructor\n.       description).\n.       @param crossCheck If it is false, this is will be default BFMatcher behaviour when it finds the k\n.       nearest neighbors for each query descriptor. If crossCheck==true, then the knnMatch() method with\n.       k=1 will only return pairs (i,j) such that for i-th query descriptor the j-th descriptor in the\n.       matcher's collection is the nearest and vice versa, i.e. the BFMatcher will only return consistent\n.       pairs. Such technique usually produces best results with minimal number of outliers when there are\n.       enough matches. This is alternative to the ratio test, used by D. Lowe in SIFT paper."},
    {"BRISK_create", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_create, 0), "BRISK_create([, thresh[, octaves[, patternScale]]]) -> retval\n.   @brief The BRISK constructor\n.   \n.       @param thresh AGAST detection threshold score.\n.       @param octaves detection octaves. Use 0 to do single scale.\n.       @param patternScale apply this scale to the pattern used for sampling the neighbourhood of a\n.       keypoint.\n\n\n\nBRISK_create(radiusList, numberList[, dMax[, dMin[, indexChange]]]) -> retval\n.   @brief The BRISK constructor for a custom pattern\n.   \n.       @param radiusList defines the radii (in pixels) where the samples around a keypoint are taken (for\n.       keypoint scale 1).\n.       @param numberList defines the number of sampling points on the sampling circle. Must be the same\n.       size as radiusList..\n.       @param dMax threshold for the short pairings used for descriptor formation (in pixels for keypoint\n.       scale 1).\n.       @param dMin threshold for the long pairings used for orientation determination (in pixels for\n.       keypoint scale 1).\n.   @param indexChange index remapping of the bits.\n\n\n\nBRISK_create(thresh, octaves, radiusList, numberList[, dMax[, dMin[, indexChange]]]) -> retval\n.   @brief The BRISK constructor for a custom pattern, detection threshold and octaves\n.   \n.       @param thresh AGAST detection threshold score.\n.       @param octaves detection octaves. Use 0 to do single scale.\n.       @param radiusList defines the radii (in pixels) where the samples around a keypoint are taken (for\n.       keypoint scale 1).\n.       @param numberList defines the number of sampling points on the sampling circle. Must be the same\n.       size as radiusList..\n.       @param dMax threshold for the short pairings used for descriptor formation (in pixels for keypoint\n.       scale 1).\n.       @param dMin threshold for the long pairings used for orientation determination (in pixels for\n.       keypoint scale 1).\n.   @param indexChange index remapping of the bits."},
    {"CamShift", CV_PY_FN_WITH_KW_(pyopencv_cv_CamShift, 0), "CamShift(probImage, window, criteria) -> retval, window\n.   @brief Finds an object center, size, and orientation.\n.   \n.   @param probImage Back projection of the object histogram. See calcBackProject.\n.   @param window Initial search window.\n.   @param criteria Stop criteria for the underlying meanShift.\n.   returns\n.   (in old interfaces) Number of iterations CAMSHIFT took to converge\n.   The function implements the CAMSHIFT object tracking algorithm @cite Bradski98 . First, it finds an\n.   object center using meanShift and then adjusts the window size and finds the optimal rotation. The\n.   function returns the rotated rectangle structure that includes the object position, size, and\n.   orientation. The next position of the search window can be obtained with RotatedRect::boundingRect()\n.   \n.   See the OpenCV sample camshiftdemo.c that tracks colored objects.\n.   \n.   @note\n.   -   (Python) A sample explaining the camshift tracking algorithm can be found at\n.       opencv_source_code/samples/python/camshift.py"},
    {"Canny", CV_PY_FN_WITH_KW_(pyopencv_cv_Canny, 0), "Canny(image, threshold1, threshold2[, edges[, apertureSize[, L2gradient]]]) -> edges\n.   @brief Finds edges in an image using the Canny algorithm @cite Canny86 .\n.   \n.   The function finds edges in the input image and marks them in the output map edges using the\n.   Canny algorithm. The smallest value between threshold1 and threshold2 is used for edge linking. The\n.   largest value is used to find initial segments of strong edges. See\n.   <https://en.wikipedia.org/wiki/Canny_edge_detector>\n.   \n.   @param image 8-bit input image.\n.   @param edges output edge map; single channels 8-bit image, which has the same size as image .\n.   @param threshold1 first threshold for the hysteresis procedure.\n.   @param threshold2 second threshold for the hysteresis procedure.\n.   @param apertureSize aperture size for the Sobel operator.\n.   @param L2gradient a flag, indicating whether a more accurate \\f$L_2\\f$ norm\n.   \\f$=\\sqrt{(dI/dx)^2 + (dI/dy)^2}\\f$ should be used to calculate the image gradient magnitude (\n.   L2gradient=true ), or whether the default \\f$L_1\\f$ norm \\f$=|dI/dx|+|dI/dy|\\f$ is enough (\n.   L2gradient=false ).\n\n\n\nCanny(dx, dy, threshold1, threshold2[, edges[, L2gradient]]) -> edges\n.   \\overload\n.   \n.   Finds edges in an image using the Canny algorithm with custom image gradient.\n.   \n.   @param dx 16-bit x derivative of input image (CV_16SC1 or CV_16SC3).\n.   @param dy 16-bit y derivative of input image (same type as dx).\n.   @param edges output edge map; single channels 8-bit image, which has the same size as image .\n.   @param threshold1 first threshold for the hysteresis procedure.\n.   @param threshold2 second threshold for the hysteresis procedure.\n.   @param L2gradient a flag, indicating whether a more accurate \\f$L_2\\f$ norm\n.   \\f$=\\sqrt{(dI/dx)^2 + (dI/dy)^2}\\f$ should be used to calculate the image gradient magnitude (\n.   L2gradient=true ), or whether the default \\f$L_1\\f$ norm \\f$=|dI/dx|+|dI/dy|\\f$ is enough (\n.   L2gradient=false )."},
    {"CascadeClassifier_convert", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_convert, 0), "CascadeClassifier_convert(oldcascade, newcascade) -> retval\n."},
    {"DISOpticalFlow_create", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_create, 0), "DISOpticalFlow_create([, preset]) -> retval\n.   @brief Creates an instance of DISOpticalFlow\n.   \n.       @param preset one of PRESET_ULTRAFAST, PRESET_FAST and PRESET_MEDIUM"},
    {"DescriptorMatcher_create", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_create, 0), "DescriptorMatcher_create(descriptorMatcherType) -> retval\n.   @brief Creates a descriptor matcher of a given type with the default parameters (using default\n.       constructor).\n.   \n.       @param descriptorMatcherType Descriptor matcher type. Now the following matcher types are\n.       supported:\n.       -   `BruteForce` (it uses L2 )\n.       -   `BruteForce-L1`\n.       -   `BruteForce-Hamming`\n.       -   `BruteForce-Hamming(2)`\n.       -   `FlannBased`\n\n\n\nDescriptorMatcher_create(matcherType) -> retval\n."},
    {"EMD", CV_PY_FN_WITH_KW_(pyopencv_cv_EMD, 0), "EMD(signature1, signature2, distType[, cost[, lowerBound[, flow]]]) -> retval, lowerBound, flow\n.   @brief Computes the \"minimal work\" distance between two weighted point configurations.\n.   \n.   The function computes the earth mover distance and/or a lower boundary of the distance between the\n.   two weighted point configurations. One of the applications described in @cite RubnerSept98,\n.   @cite Rubner2000 is multi-dimensional histogram comparison for image retrieval. EMD is a transportation\n.   problem that is solved using some modification of a simplex algorithm, thus the complexity is\n.   exponential in the worst case, though, on average it is much faster. In the case of a real metric\n.   the lower boundary can be calculated even faster (using linear-time algorithm) and it can be used\n.   to determine roughly whether the two signatures are far enough so that they cannot relate to the\n.   same object.\n.   \n.   @param signature1 First signature, a \\f$\\texttt{size1}\\times \\texttt{dims}+1\\f$ floating-point matrix.\n.   Each row stores the point weight followed by the point coordinates. The matrix is allowed to have\n.   a single column (weights only) if the user-defined cost matrix is used. The weights must be\n.   non-negative and have at least one non-zero value.\n.   @param signature2 Second signature of the same format as signature1 , though the number of rows\n.   may be different. The total weights may be different. In this case an extra \"dummy\" point is added\n.   to either signature1 or signature2. The weights must be non-negative and have at least one non-zero\n.   value.\n.   @param distType Used metric. See #DistanceTypes.\n.   @param cost User-defined \\f$\\texttt{size1}\\times \\texttt{size2}\\f$ cost matrix. Also, if a cost matrix\n.   is used, lower boundary lowerBound cannot be calculated because it needs a metric function.\n.   @param lowerBound Optional input/output parameter: lower boundary of a distance between the two\n.   signatures that is a distance between mass centers. The lower boundary may not be calculated if\n.   the user-defined cost matrix is used, the total weights of point configurations are not equal, or\n.   if the signatures consist of weights only (the signature matrices have a single column). You\n.   **must** initialize \\*lowerBound . If the calculated distance between mass centers is greater or\n.   equal to \\*lowerBound (it means that the signatures are far enough), the function does not\n.   calculate EMD. In any case \\*lowerBound is set to the calculated distance between mass centers on\n.   return. Thus, if you want to calculate both distance between mass centers and EMD, \\*lowerBound\n.   should be set to 0.\n.   @param flow Resultant \\f$\\texttt{size1} \\times \\texttt{size2}\\f$ flow matrix: \\f$\\texttt{flow}_{i,j}\\f$ is\n.   a flow from \\f$i\\f$ -th point of signature1 to \\f$j\\f$ -th point of signature2 ."},
    {"FaceDetectorYN_create", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_create, 0), "FaceDetectorYN_create(model, config, input_size[, score_threshold[, nms_threshold[, top_k[, backend_id[, target_id]]]]]) -> retval\n.   @brief Creates an instance of face detector class with given parameters\n.        *\n.        *  @param model the path to the requested model\n.        *  @param config the path to the config file for compability, which is not requested for ONNX models\n.        *  @param input_size the size of the input image\n.        *  @param score_threshold the threshold to filter out bounding boxes of score smaller than the given value\n.        *  @param nms_threshold the threshold to suppress bounding boxes of IoU bigger than the given value\n.        *  @param top_k keep top K bboxes before NMS\n.        *  @param backend_id the id of backend\n.        *  @param target_id the id of target device\n\n\n\nFaceDetectorYN_create(framework, bufferModel, bufferConfig, input_size[, score_threshold[, nms_threshold[, top_k[, backend_id[, target_id]]]]]) -> retval\n.   @overload\n.        *\n.        *  @param framework Name of origin framework\n.        *  @param bufferModel A buffer with a content of binary file with weights\n.        *  @param bufferConfig A buffer with a content of text file contains network configuration\n.        *  @param input_size the size of the input image\n.        *  @param score_threshold the threshold to filter out bounding boxes of score smaller than the given value\n.        *  @param nms_threshold the threshold to suppress bounding boxes of IoU bigger than the given value\n.        *  @param top_k keep top K bboxes before NMS\n.        *  @param backend_id the id of backend\n.        *  @param target_id the id of target device"},
    {"FaceRecognizerSF_create", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceRecognizerSF_create, 0), "FaceRecognizerSF_create(model, config[, backend_id[, target_id]]) -> retval\n.   @brief Creates an instance of this class with given parameters\n.        *  @param model the path of the onnx model used for face recognition\n.        *  @param config the path to the config file for compability, which is not requested for ONNX models\n.        *  @param backend_id the id of backend\n.        *  @param target_id the id of target device\n\n\n\nFaceRecognizerSF_create(framework, bufferModel, bufferConfig[, backend_id[, target_id]]) -> retval\n.   *  @brief Creates an instance of this class from a buffer containing the model weights and configuration.\n.        *  @param framework Name of the framework (ONNX, etc.)\n.        *  @param bufferModel A buffer containing the binary model weights.\n.        *  @param bufferConfig A buffer containing the network configuration.\n.        *  @param backend_id The id of the backend.\n.        *  @param target_id The id of the target device.\n.        *\n.        *  @return A pointer to the created instance of FaceRecognizerSF."},
    {"FarnebackOpticalFlow_create", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_create, 0), "FarnebackOpticalFlow_create([, numLevels[, pyrScale[, fastPyramids[, winSize[, numIters[, polyN[, polySigma[, flags]]]]]]]]) -> retval\n."},
    {"FastFeatureDetector_create", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_create, 0), "FastFeatureDetector_create([, threshold[, nonmaxSuppression[, type]]]) -> retval\n."},
    {"FlannBasedMatcher_create", CV_PY_FN_WITH_KW_(pyopencv_cv_FlannBasedMatcher_create, 0), "FlannBasedMatcher_create() -> retval\n."},
    {"GFTTDetector_create", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_create, 0), "GFTTDetector_create([, maxCorners[, qualityLevel[, minDistance[, blockSize[, useHarrisDetector[, k]]]]]]) -> retval\n.   \n\n\n\nGFTTDetector_create(maxCorners, qualityLevel, minDistance, blockSize, gradiantSize[, useHarrisDetector[, k]]) -> retval\n."},
    {"GaussianBlur", CV_PY_FN_WITH_KW_(pyopencv_cv_GaussianBlur, 0), "GaussianBlur(src, ksize, sigmaX[, dst[, sigmaY[, borderType[, hint]]]]) -> dst\n.   @brief Blurs an image using a Gaussian filter.\n.   \n.   The function convolves the source image with the specified Gaussian kernel. In-place filtering is\n.   supported.\n.   \n.   @param src input image; the image can have any number of channels, which are processed\n.   independently, but the depth should be CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param ksize Gaussian kernel size. ksize.width and ksize.height can differ but they both must be\n.   positive and odd. Or, they can be zero's and then they are computed from sigma.\n.   @param sigmaX Gaussian kernel standard deviation in X direction.\n.   @param sigmaY Gaussian kernel standard deviation in Y direction; if sigmaY is zero, it is set to be\n.   equal to sigmaX, if both sigmas are zeros, they are computed from ksize.width and ksize.height,\n.   respectively (see #getGaussianKernel for details); to fully control the result regardless of\n.   possible future modifications of all this semantics, it is recommended to specify all of ksize,\n.   sigmaX, and sigmaY.\n.   @param borderType pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @param hint Implementation modfication flags. See #AlgorithmHint\n.   \n.   @sa  sepFilter2D, filter2D, blur, boxFilter, bilateralFilter, medianBlur"},
    {"HOGDescriptor_getDaimlerPeopleDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_getDaimlerPeopleDetector, 0), "HOGDescriptor_getDaimlerPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 48x96 windows)."},
    {"HOGDescriptor_getDefaultPeopleDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_getDefaultPeopleDetector, 0), "HOGDescriptor_getDefaultPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 64x128 windows)."},
    {"HoughCircles", CV_PY_FN_WITH_KW_(pyopencv_cv_HoughCircles, 0), "HoughCircles(image, method, dp, minDist[, circles[, param1[, param2[, minRadius[, maxRadius]]]]]) -> circles\n.   @brief Finds circles in a grayscale image using the Hough transform.\n.   \n.   The function finds circles in a grayscale image using a modification of the Hough transform.\n.   \n.   Example: :\n.   @include snippets/imgproc_HoughLinesCircles.cpp\n.   \n.   @note Usually the function detects the centers of circles well. However, it may fail to find correct\n.   radii. You can assist to the function by specifying the radius range ( minRadius and maxRadius ) if\n.   you know it. Or, in the case of #HOUGH_GRADIENT method you may set maxRadius to a negative number\n.   to return centers only without radius search, and find the correct radius using an additional procedure.\n.   \n.   It also helps to smooth image a bit unless it's already soft. For example,\n.   GaussianBlur() with 7x7 kernel and 1.5x1.5 sigma or similar blurring may help.\n.   \n.   @param image 8-bit, single-channel, grayscale input image.\n.   @param circles Output vector of found circles. Each vector is encoded as  3 or 4 element\n.   floating-point vector \\f$(x, y, radius)\\f$ or \\f$(x, y, radius, votes)\\f$ .\n.   @param method Detection method, see #HoughModes. The available methods are #HOUGH_GRADIENT and #HOUGH_GRADIENT_ALT.\n.   @param dp Inverse ratio of the accumulator resolution to the image resolution. For example, if\n.   dp=1 , the accumulator has the same resolution as the input image. If dp=2 , the accumulator has\n.   half as big width and height. For #HOUGH_GRADIENT_ALT the recommended value is dp=1.5,\n.   unless some small very circles need to be detected.\n.   @param minDist Minimum distance between the centers of the detected circles. If the parameter is\n.   too small, multiple neighbor circles may be falsely detected in addition to a true one. If it is\n.   too large, some circles may be missed.\n.   @param param1 First method-specific parameter. In case of #HOUGH_GRADIENT and #HOUGH_GRADIENT_ALT,\n.   it is the higher threshold of the two passed to the Canny edge detector (the lower one is twice smaller).\n.   Note that #HOUGH_GRADIENT_ALT uses #Scharr algorithm to compute image derivatives, so the threshold value\n.   should normally be higher, such as 300 or normally exposed and contrasty images.\n.   @param param2 Second method-specific parameter. In case of #HOUGH_GRADIENT, it is the\n.   accumulator threshold for the circle centers at the detection stage. The smaller it is, the more\n.   false circles may be detected. Circles, corresponding to the larger accumulator values, will be\n.   returned first. In the case of #HOUGH_GRADIENT_ALT algorithm, this is the circle \"perfectness\" measure.\n.   The closer it to 1, the better shaped circles algorithm selects. In most cases 0.9 should be fine.\n.   If you want get better detection of small circles, you may decrease it to 0.85, 0.8 or even less.\n.   But then also try to limit the search range [minRadius, maxRadius] to avoid many false circles.\n.   @param minRadius Minimum circle radius.\n.   @param maxRadius Maximum circle radius. If <= 0, uses the maximum image dimension. If < 0, #HOUGH_GRADIENT returns\n.   centers without finding the radius. #HOUGH_GRADIENT_ALT always computes circle radiuses.\n.   \n.   @sa fitEllipse, minEnclosingCircle"},
    {"HoughCirclesWithAccumulator", CV_PY_FN_WITH_KW_(pyopencv_cv_HoughCirclesWithAccumulator, 0), "HoughCirclesWithAccumulator(image, method, dp, minDist[, circles[, param1[, param2[, minRadius[, maxRadius]]]]]) -> circles\n.   @brief Finds circles in a grayscale image using the Hough transform and get accumulator.\n.    *\n.    * @note This function is for bindings use only. Use original function in C++ code\n.    *\n.    * @sa HoughCircles"},
    {"HoughLines", CV_PY_FN_WITH_KW_(pyopencv_cv_HoughLines, 0), "HoughLines(image, rho, theta, threshold[, lines[, srn[, stn[, min_theta[, max_theta[, use_edgeval]]]]]]) -> lines\n.   @brief Finds lines in a binary image using the standard Hough transform.\n.   \n.   The function implements the standard or standard multi-scale Hough transform algorithm for line\n.   detection. See <https://homepages.inf.ed.ac.uk/rbf/HIPR2/hough.htm> for a good explanation of Hough\n.   transform.\n.   \n.   @param image 8-bit, single-channel binary source image. The image may be modified by the function.\n.   @param lines Output vector of lines. Each line is represented by a 2 or 3 element vector\n.   \\f$(\\rho, \\theta)\\f$ or \\f$(\\rho, \\theta, \\textrm{votes})\\f$, where \\f$\\rho\\f$ is the distance from\n.   the coordinate origin \\f$(0,0)\\f$ (top-left corner of the image), \\f$\\theta\\f$ is the line rotation\n.   angle in radians ( \\f$0 \\sim \\textrm{vertical line}, \\pi/2 \\sim \\textrm{horizontal line}\\f$ ), and\n.   \\f$\\textrm{votes}\\f$ is the value of accumulator.\n.   @param rho Distance resolution of the accumulator in pixels.\n.   @param theta Angle resolution of the accumulator in radians.\n.   @param threshold %Accumulator threshold parameter. Only those lines are returned that get enough\n.   votes ( \\f$>\\texttt{threshold}\\f$ ).\n.   @param srn For the multi-scale Hough transform, it is a divisor for the distance resolution rho.\n.   The coarse accumulator distance resolution is rho and the accurate accumulator resolution is\n.   rho/srn. If both srn=0 and stn=0, the classical Hough transform is used. Otherwise, both these\n.   parameters should be positive.\n.   @param stn For the multi-scale Hough transform, it is a divisor for the distance resolution theta.\n.   @param min_theta For standard and multi-scale Hough transform, minimum angle to check for lines.\n.   Must fall between 0 and max_theta.\n.   @param max_theta For standard and multi-scale Hough transform, an upper bound for the angle.\n.   Must fall between min_theta and CV_PI. The actual maximum angle in the accumulator may be slightly\n.   less than max_theta, depending on the parameters min_theta and theta.\n.   @param use_edgeval True if you want to use weighted Hough transform."},
    {"HoughLinesP", CV_PY_FN_WITH_KW_(pyopencv_cv_HoughLinesP, 0), "HoughLinesP(image, rho, theta, threshold[, lines[, minLineLength[, maxLineGap]]]) -> lines\n.   @brief Finds line segments in a binary image using the probabilistic Hough transform.\n.   \n.   The function implements the probabilistic Hough transform algorithm for line detection, described\n.   in @cite Matas00\n.   \n.   See the line detection example below:\n.   @include snippets/imgproc_HoughLinesP.cpp\n.   This is a sample picture the function parameters have been tuned for:\n.   \n.   ![image](pics/building.jpg)\n.   \n.   And this is the output of the above program in case of the probabilistic Hough transform:\n.   \n.   ![image](pics/houghp.png)\n.   \n.   @param image 8-bit, single-channel binary source image. The image may be modified by the function.\n.   @param lines Output vector of lines. Each line is represented by a 4-element vector\n.   \\f$(x_1, y_1, x_2, y_2)\\f$ , where \\f$(x_1,y_1)\\f$ and \\f$(x_2, y_2)\\f$ are the ending points of each detected\n.   line segment.\n.   @param rho Distance resolution of the accumulator in pixels.\n.   @param theta Angle resolution of the accumulator in radians.\n.   @param threshold %Accumulator threshold parameter. Only those lines are returned that get enough\n.   votes ( \\f$>\\texttt{threshold}\\f$ ).\n.   @param minLineLength Minimum line length. Line segments shorter than that are rejected.\n.   @param maxLineGap Maximum allowed gap between points on the same line to link them.\n.   \n.   @sa LineSegmentDetector"},
    {"HoughLinesPointSet", CV_PY_FN_WITH_KW_(pyopencv_cv_HoughLinesPointSet, 0), "HoughLinesPointSet(point, lines_max, threshold, min_rho, max_rho, rho_step, min_theta, max_theta, theta_step[, lines]) -> lines\n.   @brief Finds lines in a set of points using the standard Hough transform.\n.   \n.   The function finds lines in a set of points using a modification of the Hough transform.\n.   @include snippets/imgproc_HoughLinesPointSet.cpp\n.   @param point Input vector of points. Each vector must be encoded as a Point vector \\f$(x,y)\\f$. Type must be CV_32FC2 or CV_32SC2.\n.   @param lines Output vector of found lines. Each vector is encoded as a vector<Vec3d> \\f$(votes, rho, theta)\\f$.\n.   The larger the value of 'votes', the higher the reliability of the Hough line.\n.   @param lines_max Max count of Hough lines.\n.   @param threshold %Accumulator threshold parameter. Only those lines are returned that get enough\n.   votes ( \\f$>\\texttt{threshold}\\f$ ).\n.   @param min_rho Minimum value for \\f$\\rho\\f$ for the accumulator (Note: \\f$\\rho\\f$ can be negative. The absolute value \\f$|\\rho|\\f$ is the distance of a line to the origin.).\n.   @param max_rho Maximum value for \\f$\\rho\\f$ for the accumulator.\n.   @param rho_step Distance resolution of the accumulator.\n.   @param min_theta Minimum angle value of the accumulator in radians.\n.   @param max_theta Upper bound for the angle value of the accumulator in radians. The actual maximum\n.   angle may be slightly less than max_theta, depending on the parameters min_theta and theta_step.\n.   @param theta_step Angle resolution of the accumulator in radians."},
    {"HoughLinesWithAccumulator", CV_PY_FN_WITH_KW_(pyopencv_cv_HoughLinesWithAccumulator, 0), "HoughLinesWithAccumulator(image, rho, theta, threshold[, lines[, srn[, stn[, min_theta[, max_theta[, use_edgeval]]]]]]) -> lines\n.   @brief Finds lines in a binary image using the standard Hough transform and get accumulator.\n.    *\n.    * @note This function is for bindings use only. Use original function in C++ code\n.    *\n.    * @sa HoughLines"},
    {"HuMoments", CV_PY_FN_WITH_KW_(pyopencv_cv_HuMoments, 0), "HuMoments(m[, hu]) -> hu\n.   @overload"},
    {"KAZE_create", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_create, 0), "KAZE_create([, extended[, upright[, threshold[, nOctaves[, nOctaveLayers[, diffusivity]]]]]]) -> retval\n.   @brief The KAZE constructor\n.   \n.       @param extended Set to enable extraction of extended (128-byte) descriptor.\n.       @param upright Set to enable use of upright descriptors (non rotation-invariant).\n.       @param threshold Detector response threshold to accept point\n.       @param nOctaves Maximum octave evolution of the image\n.       @param nOctaveLayers Default number of sublevels per scale level\n.       @param diffusivity Diffusivity type. DIFF_PM_G1, DIFF_PM_G2, DIFF_WEICKERT or\n.       DIFF_CHARBONNIER"},
    {"KeyPoint_convert", CV_PY_FN_WITH_KW_(pyopencv_cv_KeyPoint_convert, 0), "KeyPoint_convert(keypoints[, keypointIndexes]) -> points2f\n.   This method converts vector of keypoints to vector of points or the reverse, where each keypoint is\n.       assigned the same size and the same orientation.\n.   \n.       @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.       @param points2f Array of (x,y) coordinates of each keypoint\n.       @param keypointIndexes Array of indexes of keypoints to be converted to points. (Acts like a mask to\n.       convert only specified keypoints)\n\n\n\nKeyPoint_convert(points2f[, size[, response[, octave[, class_id]]]]) -> keypoints\n.   @overload\n.       @param points2f Array of (x,y) coordinates of each keypoint\n.       @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.       @param size keypoint diameter\n.       @param response keypoint detector response on the keypoint (that is, strength of the keypoint)\n.       @param octave pyramid octave in which the keypoint has been detected\n.       @param class_id object id"},
    {"KeyPoint_overlap", CV_PY_FN_WITH_KW_(pyopencv_cv_KeyPoint_overlap, 0), "KeyPoint_overlap(kp1, kp2) -> retval\n.   This method computes overlap for pair of keypoints. Overlap is the ratio between area of keypoint\n.       regions' intersection and area of keypoint regions' union (considering keypoint region as circle).\n.       If they don't overlap, we get zero. If they coincide at same location with same size, we get 1.\n.       @param kp1 First keypoint\n.       @param kp2 Second keypoint"},
    {"LUT", CV_PY_FN_WITH_KW_(pyopencv_cv_LUT, 0), "LUT(src, lut[, dst]) -> dst\n.   @brief Performs a look-up table transform of an array.\n.   \n.   The function LUT fills the output array with values from the look-up table. Indices of the entries\n.   are taken from the input array. That is, the function processes each element of src as follows:\n.   \\f[\\texttt{dst} (I)  \\leftarrow \\texttt{lut(src(I) + d)}\\f]\n.   where\n.   \\f[d =  \\fork{0}{if \\(\\texttt{src}\\) has depth \\(\\texttt{CV_8U}\\)}{128}{if \\(\\texttt{src}\\) has depth \\(\\texttt{CV_8S}\\)}\\f]\n.   @param src input array of 8-bit elements.\n.   @param lut look-up table of 256 elements; in case of multi-channel input array, the table should\n.   either have a single channel (in this case the same table is used for all channels) or the same\n.   number of channels as in the input array.\n.   @param dst output array of the same size and number of channels as src, and the same depth as lut.\n.   @sa  convertScaleAbs, Mat::convertTo"},
    {"Laplacian", CV_PY_FN_WITH_KW_(pyopencv_cv_Laplacian, 0), "Laplacian(src, ddepth[, dst[, ksize[, scale[, delta[, borderType]]]]]) -> dst\n.   @brief Calculates the Laplacian of an image.\n.   \n.   The function calculates the Laplacian of the source image by adding up the second x and y\n.   derivatives calculated using the Sobel operator:\n.   \n.   \\f[\\texttt{dst} =  \\Delta \\texttt{src} =  \\frac{\\partial^2 \\texttt{src}}{\\partial x^2} +  \\frac{\\partial^2 \\texttt{src}}{\\partial y^2}\\f]\n.   \n.   This is done when `ksize > 1`. When `ksize == 1`, the Laplacian is computed by filtering the image\n.   with the following \\f$3 \\times 3\\f$ aperture:\n.   \n.   \\f[\\vecthreethree {0}{1}{0}{1}{-4}{1}{0}{1}{0}\\f]\n.   \n.   @param src Source image.\n.   @param dst Destination image of the same size and the same number of channels as src .\n.   @param ddepth Desired depth of the destination image, see @ref filter_depths \"combinations\".\n.   @param ksize Aperture size used to compute the second-derivative filters. See #getDerivKernels for\n.   details. The size must be positive and odd.\n.   @param scale Optional scale factor for the computed Laplacian values. By default, no scaling is\n.   applied. See #getDerivKernels for details.\n.   @param delta Optional delta value that is added to the results prior to storing them in dst .\n.   @param borderType Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  Sobel, Scharr"},
    {"MSER_create", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_create, 0), "MSER_create([, delta[, min_area[, max_area[, max_variation[, min_diversity[, max_evolution[, area_threshold[, min_margin[, edge_blur_size]]]]]]]]]) -> retval\n.   @brief Full constructor for %MSER detector\n.   \n.       @param delta it compares \\f$(size_{i}-size_{i-delta})/size_{i-delta}\\f$\n.       @param min_area prune the area which smaller than minArea\n.       @param max_area prune the area which bigger than maxArea\n.       @param max_variation prune the area have similar size to its children\n.       @param min_diversity for color image, trace back to cut off mser with diversity less than min_diversity\n.       @param max_evolution  for color image, the evolution steps\n.       @param area_threshold for color image, the area threshold to cause re-initialize\n.       @param min_margin for color image, ignore too small margin\n.       @param edge_blur_size for color image, the aperture size for edge blur"},
    {"Mahalanobis", CV_PY_FN_WITH_KW_(pyopencv_cv_Mahalanobis, 0), "Mahalanobis(v1, v2, icovar) -> retval\n.   @brief Calculates the Mahalanobis distance between two vectors.\n.   \n.   The function cv::Mahalanobis calculates and returns the weighted distance between two vectors:\n.   \\f[d( \\texttt{vec1} , \\texttt{vec2} )= \\sqrt{\\sum_{i,j}{\\texttt{icovar(i,j)}\\cdot(\\texttt{vec1}(I)-\\texttt{vec2}(I))\\cdot(\\texttt{vec1(j)}-\\texttt{vec2(j)})} }\\f]\n.   The covariance matrix may be calculated using the #calcCovarMatrix function and then inverted using\n.   the invert function (preferably using the #DECOMP_SVD method, as the most accurate).\n.   @param v1 first 1D input vector.\n.   @param v2 second 1D input vector.\n.   @param icovar inverse covariance matrix."},
    {"ORB_create", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_create, 0), "ORB_create([, nfeatures[, scaleFactor[, nlevels[, edgeThreshold[, firstLevel[, WTA_K[, scoreType[, patchSize[, fastThreshold]]]]]]]]]) -> retval\n.   @brief The ORB constructor\n.   \n.       @param nfeatures The maximum number of features to retain.\n.       @param scaleFactor Pyramid decimation ratio, greater than 1. scaleFactor==2 means the classical\n.       pyramid, where each next level has 4x less pixels than the previous, but such a big scale factor\n.       will degrade feature matching scores dramatically. On the other hand, too close to 1 scale factor\n.       will mean that to cover certain scale range you will need more pyramid levels and so the speed\n.       will suffer.\n.       @param nlevels The number of pyramid levels. The smallest level will have linear size equal to\n.       input_image_linear_size/pow(scaleFactor, nlevels - firstLevel).\n.       @param edgeThreshold This is size of the border where the features are not detected. It should\n.       roughly match the patchSize parameter.\n.       @param firstLevel The level of pyramid to put source image to. Previous layers are filled\n.       with upscaled source image.\n.       @param WTA_K The number of points that produce each element of the oriented BRIEF descriptor. The\n.       default value 2 means the BRIEF where we take a random point pair and compare their brightnesses,\n.       so we get 0/1 response. Other possible values are 3 and 4. For example, 3 means that we take 3\n.       random points (of course, those point coordinates are random, but they are generated from the\n.       pre-defined seed, so each element of BRIEF descriptor is computed deterministically from the pixel\n.       rectangle), find point of maximum brightness and output index of the winner (0, 1 or 2). Such\n.       output will occupy 2 bits, and therefore it will need a special variant of Hamming distance,\n.       denoted as NORM_HAMMING2 (2 bits per bin). When WTA_K=4, we take 4 random points to compute each\n.       bin (that will also occupy 2 bits with possible values 0, 1, 2 or 3).\n.       @param scoreType The default HARRIS_SCORE means that Harris algorithm is used to rank features\n.       (the score is written to KeyPoint::score and is used to retain best nfeatures features);\n.       FAST_SCORE is alternative value of the parameter that produces slightly less stable keypoints,\n.       but it is a little faster to compute.\n.       @param patchSize size of the patch used by the oriented BRIEF descriptor. Of course, on smaller\n.       pyramid layers the perceived image area covered by a feature will be larger.\n.       @param fastThreshold the fast threshold"},
    {"PCABackProject", CV_PY_FN_WITH_KW_(pyopencv_cv_PCABackProject, 0), "PCABackProject(data, mean, eigenvectors[, result]) -> result\n.   wrap PCA::backProject"},
    {"PCACompute", CV_PY_FN_WITH_KW_(pyopencv_cv_PCACompute, 0), "PCACompute(data, mean[, eigenvectors[, maxComponents]]) -> mean, eigenvectors\n.   wrap PCA::operator()\n\n\n\nPCACompute(data, mean, retainedVariance[, eigenvectors]) -> mean, eigenvectors\n.   wrap PCA::operator()"},
    {"PCACompute2", CV_PY_FN_WITH_KW_(pyopencv_cv_PCACompute2, 0), "PCACompute2(data, mean[, eigenvectors[, eigenvalues[, maxComponents]]]) -> mean, eigenvectors, eigenvalues\n.   wrap PCA::operator() and add eigenvalues output parameter\n\n\n\nPCACompute2(data, mean, retainedVariance[, eigenvectors[, eigenvalues]]) -> mean, eigenvectors, eigenvalues\n.   wrap PCA::operator() and add eigenvalues output parameter"},
    {"PCAProject", CV_PY_FN_WITH_KW_(pyopencv_cv_PCAProject, 0), "PCAProject(data, mean, eigenvectors[, result]) -> result\n.   wrap PCA::project"},
    {"PSNR", CV_PY_FN_WITH_KW_(pyopencv_cv_PSNR, 0), "PSNR(src1, src2[, R]) -> retval\n.   @brief Computes the Peak Signal-to-Noise Ratio (PSNR) image quality metric.\n.   \n.   This function calculates the Peak Signal-to-Noise Ratio (PSNR) image quality metric in decibels (dB),\n.   between two input arrays src1 and src2. The arrays must have the same type.\n.   \n.   The PSNR is calculated as follows:\n.   \n.   \\f[\n.   \\texttt{PSNR} = 10 \\cdot \\log_{10}{\\left( \\frac{R^2}{MSE} \\right) }\n.   \\f]\n.   \n.   where R is the maximum integer value of depth (e.g. 255 in the case of CV_8U data)\n.   and MSE is the mean squared error between the two arrays.\n.   \n.   @param src1 first input array.\n.   @param src2 second input array of the same size as src1.\n.   @param R the maximum pixel value (255 by default)"},
    {"QRCodeEncoder_create", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeEncoder_create, 0), "QRCodeEncoder_create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters QR code encoder parameters QRCodeEncoder::Params"},
    {"RQDecomp3x3", CV_PY_FN_WITH_KW_(pyopencv_cv_RQDecomp3x3, 0), "RQDecomp3x3(src[, mtxR[, mtxQ[, Qx[, Qy[, Qz]]]]]) -> retval, mtxR, mtxQ, Qx, Qy, Qz\n.   @brief Computes an RQ decomposition of 3x3 matrices.\n.   \n.   @param src 3x3 input matrix.\n.   @param mtxR Output 3x3 upper-triangular matrix.\n.   @param mtxQ Output 3x3 orthogonal matrix.\n.   @param Qx Optional output 3x3 rotation matrix around x-axis.\n.   @param Qy Optional output 3x3 rotation matrix around y-axis.\n.   @param Qz Optional output 3x3 rotation matrix around z-axis.\n.   \n.   The function computes a RQ decomposition using the given rotations. This function is used in\n.   #decomposeProjectionMatrix to decompose the left 3x3 submatrix of a projection matrix into a camera\n.   and a rotation matrix.\n.   \n.   It optionally returns three rotation matrices, one for each axis, and the three Euler angles in\n.   degrees (as the return value) that could be used in OpenGL. Note, there is always more than one\n.   sequence of rotations about the three principal axes that results in the same orientation of an\n.   object, e.g. see @cite Slabaugh . Returned three rotation matrices and corresponding three Euler angles\n.   are only one of the possible solutions."},
    {"Rodrigues", CV_PY_FN_WITH_KW_(pyopencv_cv_Rodrigues, 0), "Rodrigues(src[, dst[, jacobian]]) -> dst, jacobian\n.   @brief Converts a rotation matrix to a rotation vector or vice versa.\n.   \n.   @param src Input rotation vector (3x1 or 1x3) or rotation matrix (3x3).\n.   @param dst Output rotation matrix (3x3) or rotation vector (3x1 or 1x3), respectively.\n.   @param jacobian Optional output Jacobian matrix, 3x9 or 9x3, which is a matrix of partial\n.   derivatives of the output array components with respect to the input array components.\n.   \n.   \\f[\\begin{array}{l} \\theta \\leftarrow norm(r) \\\\ r  \\leftarrow r/ \\theta \\\\ R =  \\cos(\\theta) I + (1- \\cos{\\theta} ) r r^T +  \\sin(\\theta) \\vecthreethree{0}{-r_z}{r_y}{r_z}{0}{-r_x}{-r_y}{r_x}{0} \\end{array}\\f]\n.   \n.   Inverse transformation can be also done easily, since\n.   \n.   \\f[\\sin ( \\theta ) \\vecthreethree{0}{-r_z}{r_y}{r_z}{0}{-r_x}{-r_y}{r_x}{0} = \\frac{R - R^T}{2}\\f]\n.   \n.   A rotation vector is a convenient and most compact representation of a rotation matrix (since any\n.   rotation matrix has just 3 degrees of freedom). The representation is used in the global 3D geometry\n.   optimization procedures like @ref calibrateCamera, @ref stereoCalibrate, or @ref solvePnP .\n.   \n.   @note More information about the computation of the derivative of a 3D rotation matrix with respect to its exponential coordinate\n.   can be found in:\n.       - A Compact Formula for the Derivative of a 3-D Rotation in Exponential Coordinates, Guillermo Gallego, Anthony J. Yezzi @cite Gallego2014ACF\n.   \n.   @note Useful information on SE(3) and Lie Groups can be found in:\n.       - A tutorial on SE(3) transformation parameterizations and on-manifold optimization, Jose-Luis Blanco @cite blanco2010tutorial\n.       - Lie Groups for 2D and 3D Transformation, Ethan Eade @cite Eade17\n.       - A micro Lie theory for state estimation in robotics, Joan Sol&#224;, J&#233;r&#233;mie Deray, Dinesh Atchuthan @cite Sol2018AML"},
    {"SIFT_create", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_create, 0), "SIFT_create([, nfeatures[, nOctaveLayers[, contrastThreshold[, edgeThreshold[, sigma[, enable_precise_upscale]]]]]]) -> retval\n.   @param nfeatures The number of best features to retain. The features are ranked by their scores\n.       (measured in SIFT algorithm as the local contrast)\n.   \n.       @param nOctaveLayers The number of layers in each octave. 3 is the value used in D. Lowe paper. The\n.       number of octaves is computed automatically from the image resolution.\n.   \n.       @param contrastThreshold The contrast threshold used to filter out weak features in semi-uniform\n.       (low-contrast) regions. The larger the threshold, the less features are produced by the detector.\n.   \n.       @note The contrast threshold will be divided by nOctaveLayers when the filtering is applied. When\n.       nOctaveLayers is set to default and if you want to use the value used in D. Lowe paper, 0.03, set\n.       this argument to 0.09.\n.   \n.       @param edgeThreshold The threshold used to filter out edge-like features. Note that the its meaning\n.       is different from the contrastThreshold, i.e. the larger the edgeThreshold, the less features are\n.       filtered out (more features are retained).\n.   \n.       @param sigma The sigma of the Gaussian applied to the input image at the octave \\#0. If your image\n.       is captured with a weak camera with soft lenses, you might want to reduce the number.\n.   \n.       @param enable_precise_upscale Whether to enable precise upscaling in the scale pyramid, which maps\n.       index \\f$\\texttt{x}\\f$ to \\f$\\texttt{2x}\\f$. This prevents localization bias. The option\n.       is disabled by default.\n\n\n\nSIFT_create(nfeatures, nOctaveLayers, contrastThreshold, edgeThreshold, sigma, descriptorType[, enable_precise_upscale]) -> retval\n.   @brief Create SIFT with specified descriptorType.\n.       @param nfeatures The number of best features to retain. The features are ranked by their scores\n.       (measured in SIFT algorithm as the local contrast)\n.   \n.       @param nOctaveLayers The number of layers in each octave. 3 is the value used in D. Lowe paper. The\n.       number of octaves is computed automatically from the image resolution.\n.   \n.       @param contrastThreshold The contrast threshold used to filter out weak features in semi-uniform\n.       (low-contrast) regions. The larger the threshold, the less features are produced by the detector.\n.   \n.       @note The contrast threshold will be divided by nOctaveLayers when the filtering is applied. When\n.       nOctaveLayers is set to default and if you want to use the value used in D. Lowe paper, 0.03, set\n.       this argument to 0.09.\n.   \n.       @param edgeThreshold The threshold used to filter out edge-like features. Note that the its meaning\n.       is different from the contrastThreshold, i.e. the larger the edgeThreshold, the less features are\n.       filtered out (more features are retained).\n.   \n.       @param sigma The sigma of the Gaussian applied to the input image at the octave \\#0. If your image\n.       is captured with a weak camera with soft lenses, you might want to reduce the number.\n.   \n.       @param descriptorType The type of descriptors. Only CV_32F and CV_8U are supported.\n.   \n.       @param enable_precise_upscale Whether to enable precise upscaling in the scale pyramid, which maps\n.       index \\f$\\texttt{x}\\f$ to \\f$\\texttt{2x}\\f$. This prevents localization bias. The option\n.       is disabled by default."},
    {"SVBackSubst", CV_PY_FN_WITH_KW_(pyopencv_cv_SVBackSubst, 0), "SVBackSubst(w, u, vt, rhs[, dst]) -> dst\n.   wrap SVD::backSubst"},
    {"SVDecomp", CV_PY_FN_WITH_KW_(pyopencv_cv_SVDecomp, 0), "SVDecomp(src[, w[, u[, vt[, flags]]]]) -> w, u, vt\n.   wrap SVD::compute"},
    {"Scharr", CV_PY_FN_WITH_KW_(pyopencv_cv_Scharr, 0), "Scharr(src, ddepth, dx, dy[, dst[, scale[, delta[, borderType]]]]) -> dst\n.   @brief Calculates the first x- or y- image derivative using Scharr operator.\n.   \n.   The function computes the first x- or y- spatial image derivative using the Scharr operator. The\n.   call\n.   \n.   \\f[\\texttt{Scharr(src, dst, ddepth, dx, dy, scale, delta, borderType)}\\f]\n.   \n.   is equivalent to\n.   \n.   \\f[\\texttt{Sobel(src, dst, ddepth, dx, dy, FILTER_SCHARR, scale, delta, borderType)} .\\f]\n.   \n.   @param src input image.\n.   @param dst output image of the same size and the same number of channels as src.\n.   @param ddepth output image depth, see @ref filter_depths \"combinations\"\n.   @param dx order of the derivative x.\n.   @param dy order of the derivative y.\n.   @param scale optional scale factor for the computed derivative values; by default, no scaling is\n.   applied (see #getDerivKernels for details).\n.   @param delta optional delta value that is added to the results prior to storing them in dst.\n.   @param borderType pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  cartToPolar"},
    {"SimpleBlobDetector_create", CV_PY_FN_WITH_KW_(pyopencv_cv_SimpleBlobDetector_create, 0), "SimpleBlobDetector_create([, parameters]) -> retval\n."},
    {"Sobel", CV_PY_FN_WITH_KW_(pyopencv_cv_Sobel, 0), "Sobel(src, ddepth, dx, dy[, dst[, ksize[, scale[, delta[, borderType]]]]]) -> dst\n.   @brief Calculates the first, second, third, or mixed image derivatives using an extended Sobel operator.\n.   \n.   In all cases except one, the \\f$\\texttt{ksize} \\times \\texttt{ksize}\\f$ separable kernel is used to\n.   calculate the derivative. When \\f$\\texttt{ksize = 1}\\f$, the \\f$3 \\times 1\\f$ or \\f$1 \\times 3\\f$\n.   kernel is used (that is, no Gaussian smoothing is done). `ksize = 1` can only be used for the first\n.   or the second x- or y- derivatives.\n.   \n.   There is also the special value `ksize = #FILTER_SCHARR (-1)` that corresponds to the \\f$3\\times3\\f$ Scharr\n.   filter that may give more accurate results than the \\f$3\\times3\\f$ Sobel. The Scharr aperture is\n.   \n.   \\f[\\vecthreethree{-3}{0}{3}{-10}{0}{10}{-3}{0}{3}\\f]\n.   \n.   for the x-derivative, or transposed for the y-derivative.\n.   \n.   The function calculates an image derivative by convolving the image with the appropriate kernel:\n.   \n.   \\f[\\texttt{dst} =  \\frac{\\partial^{xorder+yorder} \\texttt{src}}{\\partial x^{xorder} \\partial y^{yorder}}\\f]\n.   \n.   The Sobel operators combine Gaussian smoothing and differentiation, so the result is more or less\n.   resistant to the noise. Most often, the function is called with ( xorder = 1, yorder = 0, ksize = 3)\n.   or ( xorder = 0, yorder = 1, ksize = 3) to calculate the first x- or y- image derivative. The first\n.   case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{0}{1}{-2}{0}{2}{-1}{0}{1}\\f]\n.   \n.   The second case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{-2}{-1}{0}{0}{0}{1}{2}{1}\\f]\n.   \n.   @param src input image.\n.   @param dst output image of the same size and the same number of channels as src .\n.   @param ddepth output image depth, see @ref filter_depths \"combinations\"; in the case of\n.       8-bit input images it will result in truncated derivatives.\n.   @param dx order of the derivative x.\n.   @param dy order of the derivative y.\n.   @param ksize size of the extended Sobel kernel; it must be 1, 3, 5, or 7.\n.   @param scale optional scale factor for the computed derivative values; by default, no scaling is\n.   applied (see #getDerivKernels for details).\n.   @param delta optional delta value that is added to the results prior to storing them in dst.\n.   @param borderType pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  Scharr, Laplacian, sepFilter2D, filter2D, GaussianBlur, cartToPolar"},
    {"SparsePyrLKOpticalFlow_create", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_create, 0), "SparsePyrLKOpticalFlow_create([, winSize[, maxLevel[, crit[, flags[, minEigThreshold]]]]]) -> retval\n."},
    {"StereoBM_create", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_create, 0), "StereoBM_create([, numDisparities[, blockSize]]) -> retval\n.   * @brief Creates StereoBM object\n.        * @param numDisparities The disparity search range. For each pixel, the algorithm will find the best disparity from 0 (default minimum disparity) to numDisparities. The search range can be shifted by changing the minimum disparity.\n.        * @param blockSize The linear size of the blocks compared by the algorithm. The size should be odd (as the block is centered at the current pixel). Larger block size implies smoother, though less accurate disparity map. Smaller block size gives more detailed disparity map, but there is a higher chance for the algorithm to find a wrong correspondence.\n.        * @return A pointer to the created StereoBM object.\n.        * @details The function creates a StereoBM object. You can then call StereoBM::compute() to compute disparity for a specific stereo pair."},
    {"StereoSGBM_create", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_create, 0), "StereoSGBM_create([, minDisparity[, numDisparities[, blockSize[, P1[, P2[, disp12MaxDiff[, preFilterCap[, uniquenessRatio[, speckleWindowSize[, speckleRange[, mode]]]]]]]]]]]) -> retval\n.   @brief Creates StereoSGBM object\n.   \n.       @param minDisparity Minimum possible disparity value. Normally, it is zero but sometimes\n.       rectification algorithms can shift images, so this parameter needs to be adjusted accordingly.\n.       @param numDisparities Maximum disparity minus minimum disparity. The value is always greater than\n.       zero. In the current implementation, this parameter must be divisible by 16.\n.       @param blockSize Matched block size. It must be an odd number \\>=1 . Normally, it should be\n.       somewhere in the 3..11 range.\n.       @param P1 The first parameter controlling the disparity smoothness. See below.\n.       @param P2 The second parameter controlling the disparity smoothness. The larger the values are,\n.       the smoother the disparity is. P1 is the penalty on the disparity change by plus or minus 1\n.       between neighbor pixels. P2 is the penalty on the disparity change by more than 1 between neighbor\n.       pixels. The algorithm requires P2 \\> P1 . See stereo_match.cpp sample where some reasonably good\n.       P1 and P2 values are shown (like 8\\*number_of_image_channels\\*blockSize\\*blockSize and\n.       32\\*number_of_image_channels\\*blockSize\\*blockSize , respectively).\n.       @param disp12MaxDiff Maximum allowed difference (in integer pixel units) in the left-right\n.       disparity check. Set it to a non-positive value to disable the check.\n.       @param preFilterCap Truncation value for the prefiltered image pixels. The algorithm first\n.       computes x-derivative at each pixel and clips its value by [-preFilterCap, preFilterCap] interval.\n.       The result values are passed to the Birchfield-Tomasi pixel cost function.\n.       @param uniquenessRatio Margin in percentage by which the best (minimum) computed cost function\n.       value should \"win\" the second best value to consider the found match correct. Normally, a value\n.       within the 5-15 range is good enough.\n.       @param speckleWindowSize Maximum size of smooth disparity regions to consider their noise speckles\n.       and invalidate. Set it to 0 to disable speckle filtering. Otherwise, set it somewhere in the\n.       50-200 range.\n.       @param speckleRange Maximum disparity variation within each connected component. If you do speckle\n.       filtering, set the parameter to a positive value, it will be implicitly multiplied by 16.\n.       Normally, 1 or 2 is good enough.\n.       @param mode Set it to StereoSGBM::MODE_HH to run the full-scale two-pass dynamic programming\n.       algorithm. It will consume O(W\\*H\\*numDisparities) bytes, which is large for 640x480 stereo and\n.       huge for HD-size pictures. By default, it is set to false .\n.   \n.       The first constructor initializes StereoSGBM with all the default parameters. So, you only have to\n.       set StereoSGBM::numDisparities at minimum. The second constructor enables you to set each parameter\n.       to a custom value."},
    {"Stitcher_create", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_create, 0), "Stitcher_create([, mode]) -> retval\n.   @brief Creates a Stitcher configured in one of the stitching modes.\n.   \n.       @param mode Scenario for stitcher operation. This is usually determined by source of images\n.       to stitch and their transformation. Default parameters will be chosen for operation in given\n.       scenario.\n.       @return Stitcher class instance."},
    {"TrackerCSRT_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerCSRT_create, 0), "TrackerCSRT_create([, parameters]) -> retval\n.   @brief Create CSRT tracker instance\n.       @param parameters CSRT parameters TrackerCSRT::Params"},
    {"TrackerDaSiamRPN_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerDaSiamRPN_create, 0), "TrackerDaSiamRPN_create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters DaSiamRPN parameters TrackerDaSiamRPN::Params\n\n\n\nTrackerDaSiamRPN_create(siam_rpn, kernel_cls1, kernel_r1) -> retval\n.   @brief Constructor\n.        *  @param siam_rpn pre-loaded SiamRPN model\n.        *  @param kernel_cls1 pre-loaded CLS model\n.        *  @param kernel_r1 pre-loaded R1 model"},
    {"TrackerGOTURN_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerGOTURN_create, 0), "TrackerGOTURN_create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters GOTURN parameters TrackerGOTURN::Params\n\n\n\nTrackerGOTURN_create(model) -> retval\n.   @brief Constructor\n.       @param model pre-loaded GOTURN model"},
    {"TrackerKCF_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerKCF_create, 0), "TrackerKCF_create([, parameters]) -> retval\n.   @brief Create KCF tracker instance\n.       @param parameters KCF parameters TrackerKCF::Params"},
    {"TrackerMIL_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerMIL_create, 0), "TrackerMIL_create([, parameters]) -> retval\n.   @brief Create MIL tracker instance\n.        *  @param parameters MIL parameters TrackerMIL::Params"},
    {"TrackerNano_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerNano_create, 0), "TrackerNano_create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters NanoTrack parameters TrackerNano::Params\n\n\n\nTrackerNano_create(backbone, neckhead) -> retval\n.   @brief Constructor\n.        *  @param backbone pre-loaded backbone model\n.        *  @param neckhead pre-loaded neckhead model"},
    {"TrackerVit_create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerVit_create, 0), "TrackerVit_create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters vit tracker parameters TrackerVit::Params\n\n\n\nTrackerVit_create(model[, meanvalue[, stdvalue[, tracking_score_threshold]]]) -> retval\n.   @brief Constructor\n.        *  @param model pre-loaded DNN model\n.        *  @param meanvalue mean value for image preprocessing\n.        *  @param stdvalue std value for image preprocessing\n.        *  @param tracking_score_threshold threshold for tracking score"},
    {"UMat_context", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_context, 0), "UMat_context() -> retval\n."},
    {"UMat_queue", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_queue, 0), "UMat_queue() -> retval\n."},
    {"VariationalRefinement_create", CV_PY_FN_WITH_KW_(pyopencv_cv_VariationalRefinement_create, 0), "VariationalRefinement_create() -> retval\n.   @brief Creates an instance of VariationalRefinement"},
    {"VideoCapture_waitAny", CV_PY_FN_WITH_KW_(pyopencv_cv_VideoCapture_waitAny, 0), "VideoCapture_waitAny(streams[, timeoutNs]) -> retval, readyIndex\n.   @brief Wait for ready frames from VideoCapture.\n.   \n.       @param streams input video streams\n.       @param readyIndex stream indexes with grabbed frames (ready to use .retrieve() to fetch actual frame)\n.       @param timeoutNs number of nanoseconds (0 - infinite)\n.       @return `true` if streamReady is not empty\n.   \n.       @throws Exception %Exception on stream errors (check .isOpened() to filter out malformed streams) or VideoCapture type is not supported\n.   \n.       The primary use of the function is in multi-camera environments.\n.       The method fills the ready state vector, grabs video frame, if camera is ready.\n.   \n.       After this call use VideoCapture::retrieve() to decode and fetch frame data."},
    {"VideoWriter_fourcc", CV_PY_FN_WITH_KW_(pyopencv_cv_VideoWriter_fourcc, 0), "VideoWriter_fourcc(c1, c2, c3, c4) -> retval\n.   @brief Concatenates 4 chars to a fourcc code\n.   \n.       @return a fourcc code\n.   \n.       This static method constructs the fourcc code of the codec to be used in the constructor\n.       VideoWriter::VideoWriter or VideoWriter::open."},
    {"absdiff", CV_PY_FN_WITH_KW_(pyopencv_cv_absdiff, 0), "absdiff(src1, src2[, dst]) -> dst\n.   @brief Calculates the per-element absolute difference between two arrays or between an array and a scalar.\n.   \n.   The function cv::absdiff calculates:\n.   *   Absolute difference between two arrays when they have the same\n.       size and type:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1}(I) -  \\texttt{src2}(I)|)\\f]\n.   *   Absolute difference between an array and a scalar when the second\n.       array is constructed from Scalar or has as many elements as the\n.       number of channels in `src1`:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1}(I) -  \\texttt{src2} |)\\f]\n.   *   Absolute difference between a scalar and an array when the first\n.       array is constructed from Scalar or has as many elements as the\n.       number of channels in `src2`:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1} -  \\texttt{src2}(I) |)\\f]\n.       where I is a multi-dimensional index of array elements. In case of\n.       multi-channel arrays, each channel is processed independently.\n.   @note Saturation is not applied when the arrays have the depth CV_32S.\n.   You may even get a negative value in the case of overflow.\n.   @note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.\n.   `absdiff(src,X)` means `absdiff(src,(X,X,X,X))`.\n.   `absdiff(src,(X,))` means `absdiff(src,(X,0,0,0))`.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as input arrays.\n.   @sa cv::abs(const Mat&)"},
    {"accumulate", CV_PY_FN_WITH_KW_(pyopencv_cv_accumulate, 0), "accumulate(src, dst[, mask]) -> dst\n.   @brief Adds an image to the accumulator image.\n.   \n.   The function adds src or some of its elements to dst :\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow \\texttt{dst} (x,y) +  \\texttt{src} (x,y)  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   The function cv::accumulate can be used, for example, to collect statistics of a scene background\n.   viewed by a still camera and for the further foreground-background segmentation.\n.   \n.   @param src Input image of type CV_8UC(n), CV_16UC(n), CV_32FC(n) or CV_64FC(n), where n is a positive integer.\n.   @param dst %Accumulator image with the same number of channels as input image, and a depth of CV_32F or CV_64F.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulateSquare, accumulateProduct, accumulateWeighted"},
    {"accumulateProduct", CV_PY_FN_WITH_KW_(pyopencv_cv_accumulateProduct, 0), "accumulateProduct(src1, src2, dst[, mask]) -> dst\n.   @brief Adds the per-element product of two input images to the accumulator image.\n.   \n.   The function adds the product of two images or their selected regions to the accumulator dst :\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow \\texttt{dst} (x,y) +  \\texttt{src1} (x,y)  \\cdot \\texttt{src2} (x,y)  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   @param src1 First input image, 1- or 3-channel, 8-bit or 32-bit floating point.\n.   @param src2 Second input image of the same type and the same size as src1 .\n.   @param dst %Accumulator image with the same number of channels as input images, 32-bit or 64-bit\n.   floating-point.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulate, accumulateSquare, accumulateWeighted"},
    {"accumulateSquare", CV_PY_FN_WITH_KW_(pyopencv_cv_accumulateSquare, 0), "accumulateSquare(src, dst[, mask]) -> dst\n.   @brief Adds the square of a source image to the accumulator image.\n.   \n.   The function adds the input image src or its selected region, raised to a power of 2, to the\n.   accumulator dst :\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow \\texttt{dst} (x,y) +  \\texttt{src} (x,y)^2  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   @param src Input image as 1- or 3-channel, 8-bit or 32-bit floating point.\n.   @param dst %Accumulator image with the same number of channels as input image, 32-bit or 64-bit\n.   floating-point.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulateSquare, accumulateProduct, accumulateWeighted"},
    {"accumulateWeighted", CV_PY_FN_WITH_KW_(pyopencv_cv_accumulateWeighted, 0), "accumulateWeighted(src, dst, alpha[, mask]) -> dst\n.   @brief Updates a running average.\n.   \n.   The function calculates the weighted sum of the input image src and the accumulator dst so that dst\n.   becomes a running average of a frame sequence:\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow (1- \\texttt{alpha} )  \\cdot \\texttt{dst} (x,y) +  \\texttt{alpha} \\cdot \\texttt{src} (x,y)  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   That is, alpha regulates the update speed (how fast the accumulator \"forgets\" about earlier images).\n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   @param src Input image as 1- or 3-channel, 8-bit or 32-bit floating point.\n.   @param dst %Accumulator image with the same number of channels as input image, 32-bit or 64-bit\n.   floating-point.\n.   @param alpha Weight of the input image.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulate, accumulateSquare, accumulateProduct"},
    {"adaptiveThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_adaptiveThreshold, 0), "adaptiveThreshold(src, maxValue, adaptiveMethod, thresholdType, blockSize, C[, dst]) -> dst\n.   @brief Applies an adaptive threshold to an array.\n.   \n.   The function transforms a grayscale image to a binary image according to the formulae:\n.   -   **THRESH_BINARY**\n.       \\f[dst(x,y) =  \\fork{\\texttt{maxValue}}{if \\(src(x,y) > T(x,y)\\)}{0}{otherwise}\\f]\n.   -   **THRESH_BINARY_INV**\n.       \\f[dst(x,y) =  \\fork{0}{if \\(src(x,y) > T(x,y)\\)}{\\texttt{maxValue}}{otherwise}\\f]\n.   where \\f$T(x,y)\\f$ is a threshold calculated individually for each pixel (see adaptiveMethod parameter).\n.   \n.   The function can process the image in-place.\n.   \n.   @param src Source 8-bit single-channel image.\n.   @param dst Destination image of the same size and the same type as src.\n.   @param maxValue Non-zero value assigned to the pixels for which the condition is satisfied\n.   @param adaptiveMethod Adaptive thresholding algorithm to use, see #AdaptiveThresholdTypes.\n.   The #BORDER_REPLICATE | #BORDER_ISOLATED is used to process boundaries.\n.   @param thresholdType Thresholding type that must be either #THRESH_BINARY or #THRESH_BINARY_INV,\n.   see #ThresholdTypes.\n.   @param blockSize Size of a pixel neighborhood that is used to calculate a threshold value for the\n.   pixel: 3, 5, 7, and so on.\n.   @param C Constant subtracted from the mean or weighted mean (see the details below). Normally, it\n.   is positive but may be zero or negative as well.\n.   \n.   @sa  threshold, blur, GaussianBlur"},
    {"add", CV_PY_FN_WITH_KW_(pyopencv_cv_add, 0), "add(src1, src2[, dst[, mask[, dtype]]]) -> dst\n.   @brief Calculates the per-element sum of two arrays or an array and a scalar.\n.   \n.   The function add calculates:\n.   - Sum of two arrays when both input arrays have the same size and the same number of channels:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) +  \\texttt{src2}(I)) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Sum of an array and a scalar when src2 is constructed from Scalar or has the same number of\n.   elements as `src1.channels()`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) +  \\texttt{src2} ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Sum of a scalar and an array when src1 is constructed from Scalar or has the same number of\n.   elements as `src2.channels()`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1} +  \\texttt{src2}(I) ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   where `I` is a multi-dimensional index of array elements. In case of multi-channel arrays, each\n.   channel is processed independently.\n.   \n.   The first function in the list above can be replaced with matrix expressions:\n.   @code{.cpp}\n.       dst = src1 + src2;\n.       dst += src1; // equivalent to add(dst, src1, dst);\n.   @endcode\n.   The input arrays and the output array can all have the same or different depths. For example, you\n.   can add a 16-bit unsigned array to a 8-bit signed array and store the sum as a 32-bit\n.   floating-point array. Depth of the output array is determined by the dtype parameter. In the second\n.   and third cases above, as well as in the first case, when src1.depth() == src2.depth(), dtype can\n.   be set to the default -1. In this case, the output array will have the same depth as the input\n.   array, be it src1, src2 or both.\n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.\n.   `add(src,X)` means `add(src,(X,X,X,X))`.\n.   `add(src,(X,))` means `add(src,(X,0,0,0))`.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and number of channels as the input array(s); the\n.   depth is defined by dtype or src1/src2.\n.   @param mask optional operation mask - 8-bit single channel array, that specifies elements of the\n.   output array to be changed.\n.   @param dtype optional depth of the output array (see the discussion below).\n.   @sa subtract, addWeighted, scaleAdd, Mat::convertTo"},
    {"addText", CV_PY_FN_WITH_KW_(pyopencv_cv_addText, 0), "addText(img, text, org, nameFont[, pointSize[, color[, weight[, style[, spacing]]]]]) -> None\n.   @brief Draws a text on the image.\n.   \n.   @param img 8-bit 3-channel image where the text should be drawn.\n.   @param text Text to write on an image.\n.   @param org Point(x,y) where the text should start on an image.\n.   @param nameFont Name of the font. The name should match the name of a system font (such as\n.   *Times*). If the font is not found, a default one is used.\n.   @param pointSize Size of the font. If not specified, equal zero or negative, the point size of the\n.   font is set to a system-dependent default value. Generally, this is 12 points.\n.   @param color Color of the font in BGRA where A = 255 is fully transparent.\n.   @param weight Font weight. Available operation flags are : cv::QtFontWeights You can also specify a positive integer for better control.\n.   @param style Font style. Available operation flags are : cv::QtFontStyles\n.   @param spacing Spacing between characters. It can be negative or positive."},
    {"addWeighted", CV_PY_FN_WITH_KW_(pyopencv_cv_addWeighted, 0), "addWeighted(src1, alpha, src2, beta, gamma[, dst[, dtype]]) -> dst\n.   @brief Calculates the weighted sum of two arrays.\n.   \n.   The function addWeighted calculates the weighted sum of two arrays as follows:\n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} ( \\texttt{src1} (I)* \\texttt{alpha} +  \\texttt{src2} (I)* \\texttt{beta} +  \\texttt{gamma} )\\f]\n.   where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each\n.   channel is processed independently.\n.   The function can be replaced with a matrix expression:\n.   @code{.cpp}\n.       dst = src1*alpha + src2*beta + gamma;\n.   @endcode\n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @param src1 first input array.\n.   @param alpha weight of the first array elements.\n.   @param src2 second input array of the same size and channel number as src1.\n.   @param beta weight of the second array elements.\n.   @param gamma scalar added to each sum.\n.   @param dst output array that has the same size and number of channels as the input arrays.\n.   @param dtype optional depth of the output array; when both input arrays have the same depth, dtype\n.   can be set to -1, which will be equivalent to src1.depth().\n.   @sa  add, subtract, scaleAdd, Mat::convertTo"},
    {"applyColorMap", CV_PY_FN_WITH_KW_(pyopencv_cv_applyColorMap, 0), "applyColorMap(src, colormap[, dst]) -> dst\n.   @brief Applies a GNU Octave/MATLAB equivalent colormap on a given image.\n.   \n.   @param src The source image, grayscale or colored of type CV_8UC1 or CV_8UC3. If CV_8UC3, then the CV_8UC1 image is generated internally using cv::COLOR_BGR2GRAY.\n.   @param dst The result is the colormapped source image. Note: Mat::create is called on dst.\n.   @param colormap The colormap to apply, see #ColormapTypes\n\n\n\napplyColorMap(src, userColor[, dst]) -> dst\n.   @brief Applies a user colormap on a given image.\n.   \n.   @param src The source image, grayscale or colored of type CV_8UC1 or CV_8UC3. If CV_8UC3, then the CV_8UC1 image is generated internally using cv::COLOR_BGR2GRAY.\n.   @param dst The result is the colormapped source image of the same number of channels as userColor. Note: Mat::create is called on dst.\n.   @param userColor The colormap to apply of type CV_8UC1 or CV_8UC3 and size 256"},
    {"approxPolyDP", CV_PY_FN_WITH_KW_(pyopencv_cv_approxPolyDP, 0), "approxPolyDP(curve, epsilon, closed[, approxCurve]) -> approxCurve\n.   @brief Approximates a polygonal curve(s) with the specified precision.\n.   \n.   The function cv::approxPolyDP approximates a curve or a polygon with another curve/polygon with less\n.   vertices so that the distance between them is less or equal to the specified precision. It uses the\n.   Douglas-Peucker algorithm <https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm>\n.   \n.   @param curve Input vector of a 2D point stored in std::vector or Mat\n.   @param approxCurve Result of the approximation. The type should match the type of the input curve.\n.   @param epsilon Parameter specifying the approximation accuracy. This is the maximum distance\n.   between the original curve and its approximation.\n.   @param closed If true, the approximated curve is closed (its first and last vertices are\n.   connected). Otherwise, it is not closed."},
    {"approxPolyN", CV_PY_FN_WITH_KW_(pyopencv_cv_approxPolyN, 0), "approxPolyN(curve, nsides[, approxCurve[, epsilon_percentage[, ensure_convex]]]) -> approxCurve\n.   @brief Approximates a polygon with a convex hull with a specified accuracy and number of sides.\n.   \n.   The cv::approxPolyN function approximates a polygon with a convex hull\n.   so that the difference between the contour area of the original contour and the new polygon is minimal.\n.   It uses a greedy algorithm for contracting two vertices into one in such a way that the additional area is minimal.\n.   Straight lines formed by each edge of the convex contour are drawn and the areas of the resulting triangles are considered.\n.   Each vertex will lie either on the original contour or outside it.\n.   \n.   The algorithm based on the paper @cite LowIlie2003 .\n.   \n.   @param curve Input vector of a 2D points stored in std::vector or Mat, points must be float or integer.\n.   @param approxCurve Result of the approximation. The type is vector of a 2D point (Point2f or Point) in std::vector or Mat.\n.   @param nsides The parameter defines the number of sides of the result polygon.\n.   @param epsilon_percentage defines the percentage of the maximum of additional area.\n.   If it equals -1, it is not used. Otherwise algorighm stops if additional area is greater than contourArea(_curve) * percentage.\n.   If additional area exceeds the limit, algorithm returns as many vertices as there were at the moment the limit was exceeded.\n.   @param ensure_convex If it is true, algorithm creates a convex hull of input contour. Otherwise input vector should be convex."},
    {"arcLength", CV_PY_FN_WITH_KW_(pyopencv_cv_arcLength, 0), "arcLength(curve, closed) -> retval\n.   @brief Calculates a contour perimeter or a curve length.\n.   \n.   The function computes a curve length or a closed contour perimeter.\n.   \n.   @param curve Input vector of 2D points, stored in std::vector or Mat.\n.   @param closed Flag indicating whether the curve is closed or not."},
    {"arrowedLine", CV_PY_FN_WITH_KW_(pyopencv_cv_arrowedLine, 0), "arrowedLine(img, pt1, pt2, color[, thickness[, line_type[, shift[, tipLength]]]]) -> img\n.   @brief Draws an arrow segment pointing from the first point to the second one.\n.   \n.   The function cv::arrowedLine draws an arrow between pt1 and pt2 points in the image. See also #line.\n.   \n.   @param img Image.\n.   @param pt1 The point the arrow starts from.\n.   @param pt2 The point the arrow points to.\n.   @param color Line color.\n.   @param thickness Line thickness.\n.   @param line_type Type of the line. See #LineTypes\n.   @param shift Number of fractional bits in the point coordinates.\n.   @param tipLength The length of the arrow tip in relation to the arrow length"},
    {"batchDistance", CV_PY_FN_WITH_KW_(pyopencv_cv_batchDistance, 0), "batchDistance(src1, src2, dtype[, dist[, nidx[, normType[, K[, mask[, update[, crosscheck]]]]]]]) -> dist, nidx\n.   @brief naive nearest neighbor finder\n.   \n.   see http://en.wikipedia.org/wiki/Nearest_neighbor_search\n.   @todo document"},
    {"bilateralFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_bilateralFilter, 0), "bilateralFilter(src, d, sigmaColor, sigmaSpace[, dst[, borderType]]) -> dst\n.   @brief Applies the bilateral filter to an image.\n.   \n.   The function applies bilateral filtering to the input image, as described in\n.   https://homepages.inf.ed.ac.uk/rbf/CVonline/LOCAL_COPIES/MANDUCHI1/Bilateral_Filtering.html\n.   bilateralFilter can reduce unwanted noise very well while keeping edges fairly sharp. However, it is\n.   very slow compared to most filters.\n.   \n.   _Sigma values_: For simplicity, you can set the 2 sigma values to be the same. If they are small (\\<\n.   10), the filter will not have much effect, whereas if they are large (\\> 150), they will have a very\n.   strong effect, making the image look \"cartoonish\".\n.   \n.   _Filter size_: Large filters (d \\> 5) are very slow, so it is recommended to use d=5 for real-time\n.   applications, and perhaps d=9 for offline applications that need heavy noise filtering.\n.   \n.   This filter does not work inplace.\n.   @param src Source 8-bit or floating-point, 1-channel or 3-channel image.\n.   @param dst Destination image of the same size and type as src .\n.   @param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,\n.   it is computed from sigmaSpace.\n.   @param sigmaColor Filter sigma in the color space. A larger value of the parameter means that\n.   farther colors within the pixel neighborhood (see sigmaSpace) will be mixed together, resulting\n.   in larger areas of semi-equal color.\n.   @param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that\n.   farther pixels will influence each other as long as their colors are close enough (see sigmaColor\n.   ). When d\\>0, it specifies the neighborhood size regardless of sigmaSpace. Otherwise, d is\n.   proportional to sigmaSpace.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes"},
    {"bitwise_and", CV_PY_FN_WITH_KW_(pyopencv_cv_bitwise_and, 0), "bitwise_and(src1, src2[, dst[, mask]]) -> dst\n.   @brief computes bitwise conjunction of the two arrays (dst = src1 & src2)\n.   Calculates the per-element bit-wise conjunction of two arrays or an\n.   array and a scalar.\n.   \n.   The function cv::bitwise_and calculates the per-element bit-wise logical conjunction for:\n.   *   Two arrays when src1 and src2 have the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\wedge \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   An array and a scalar when src2 is constructed from Scalar or has\n.       the same number of elements as `src1.channels()`:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\wedge \\texttt{src2} \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   A scalar and an array when src1 is constructed from Scalar or has\n.       the same number of elements as `src2.channels()`:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\wedge \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   In case of floating-point arrays, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. In the second and third cases above, the scalar is first\n.   converted to the array type.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as the input\n.   arrays.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"bitwise_not", CV_PY_FN_WITH_KW_(pyopencv_cv_bitwise_not, 0), "bitwise_not(src[, dst[, mask]]) -> dst\n.   @brief  Inverts every bit of an array.\n.   \n.   The function cv::bitwise_not calculates per-element bit-wise inversion of the input\n.   array:\n.   \\f[\\texttt{dst} (I) =  \\neg \\texttt{src} (I)\\f]\n.   In case of a floating-point input array, its machine-specific bit\n.   representation (usually IEEE754-compliant) is used for the operation. In\n.   case of multi-channel arrays, each channel is processed independently.\n.   @param src input array.\n.   @param dst output array that has the same size and type as the input\n.   array.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"bitwise_or", CV_PY_FN_WITH_KW_(pyopencv_cv_bitwise_or, 0), "bitwise_or(src1, src2[, dst[, mask]]) -> dst\n.   @brief Calculates the per-element bit-wise disjunction of two arrays or an\n.   array and a scalar.\n.   \n.   The function cv::bitwise_or calculates the per-element bit-wise logical disjunction for:\n.   *   Two arrays when src1 and src2 have the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\vee \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   An array and a scalar when src2 is constructed from Scalar or has\n.       the same number of elements as `src1.channels()`:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\vee \\texttt{src2} \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   A scalar and an array when src1 is constructed from Scalar or has\n.       the same number of elements as `src2.channels()`:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\vee \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   In case of floating-point arrays, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. In the second and third cases above, the scalar is first\n.   converted to the array type.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as the input\n.   arrays.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"bitwise_xor", CV_PY_FN_WITH_KW_(pyopencv_cv_bitwise_xor, 0), "bitwise_xor(src1, src2[, dst[, mask]]) -> dst\n.   @brief Calculates the per-element bit-wise \"exclusive or\" operation on two\n.   arrays or an array and a scalar.\n.   \n.   The function cv::bitwise_xor calculates the per-element bit-wise logical \"exclusive-or\"\n.   operation for:\n.   *   Two arrays when src1 and src2 have the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\oplus \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   An array and a scalar when src2 is constructed from Scalar or has\n.       the same number of elements as `src1.channels()`:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\oplus \\texttt{src2} \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   A scalar and an array when src1 is constructed from Scalar or has\n.       the same number of elements as `src2.channels()`:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\oplus \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   In case of floating-point arrays, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. In the 2nd and 3rd cases above, the scalar is first\n.   converted to the array type.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as the input\n.   arrays.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"blendLinear", CV_PY_FN_WITH_KW_(pyopencv_cv_blendLinear, 0), "blendLinear(src1, src2, weights1, weights2[, dst]) -> dst\n.   @overload\n.   \n.   variant without `mask` parameter"},
    {"blur", CV_PY_FN_WITH_KW_(pyopencv_cv_blur, 0), "blur(src, ksize[, dst[, anchor[, borderType]]]) -> dst\n.   @brief Blurs an image using the normalized box filter.\n.   \n.   The function smooths an image using the kernel:\n.   \n.   \\f[\\texttt{K} =  \\frac{1}{\\texttt{ksize.width*ksize.height}} \\begin{bmatrix} 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\hdotsfor{6} \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\end{bmatrix}\\f]\n.   \n.   The call `blur(src, dst, ksize, anchor, borderType)` is equivalent to `boxFilter(src, dst, src.type(), ksize,\n.   anchor, true, borderType)`.\n.   \n.   @param src input image; it can have any number of channels, which are processed independently, but\n.   the depth should be CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param ksize blurring kernel size.\n.   @param anchor anchor point; default value Point(-1,-1) means that the anchor is at the kernel\n.   center.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  boxFilter, bilateralFilter, GaussianBlur, medianBlur"},
    {"borderInterpolate", CV_PY_FN_WITH_KW_(pyopencv_cv_borderInterpolate, 0), "borderInterpolate(p, len, borderType) -> retval\n.   @brief Computes the source location of an extrapolated pixel.\n.   \n.   The function computes and returns the coordinate of a donor pixel corresponding to the specified\n.   extrapolated pixel when using the specified extrapolation border mode. For example, if you use\n.   cv::BORDER_WRAP mode in the horizontal direction, cv::BORDER_REFLECT_101 in the vertical direction and\n.   want to compute value of the \"virtual\" pixel Point(-5, 100) in a floating-point image img, it\n.   looks like:\n.   @code{.cpp}\n.       float val = img.at<float>(borderInterpolate(100, img.rows, cv::BORDER_REFLECT_101),\n.                                 borderInterpolate(-5, img.cols, cv::BORDER_WRAP));\n.   @endcode\n.   Normally, the function is not called directly. It is used inside filtering functions and also in\n.   copyMakeBorder.\n.   @param p 0-based coordinate of the extrapolated pixel along one of the axes, likely \\<0 or \\>= len\n.   @param len Length of the array along the corresponding axis.\n.   @param borderType Border type, one of the #BorderTypes, except for #BORDER_TRANSPARENT and\n.   #BORDER_ISOLATED. When borderType==#BORDER_CONSTANT, the function always returns -1, regardless\n.   of p and len.\n.   \n.   @sa copyMakeBorder"},
    {"boundingRect", CV_PY_FN_WITH_KW_(pyopencv_cv_boundingRect, 0), "boundingRect(array) -> retval\n.   @brief Calculates the up-right bounding rectangle of a point set or non-zero pixels of gray-scale image.\n.   \n.   The function calculates and returns the minimal up-right bounding rectangle for the specified point set or\n.   non-zero pixels of gray-scale image.\n.   \n.   @param array Input gray-scale image or 2D point set, stored in std::vector or Mat."},
    {"boxFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_boxFilter, 0), "boxFilter(src, ddepth, ksize[, dst[, anchor[, normalize[, borderType]]]]) -> dst\n.   @brief Blurs an image using the box filter.\n.   \n.   The function smooths an image using the kernel:\n.   \n.   \\f[\\texttt{K} =  \\alpha \\begin{bmatrix} 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\hdotsfor{6} \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1 \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[\\alpha = \\begin{cases} \\frac{1}{\\texttt{ksize.width*ksize.height}} & \\texttt{when } \\texttt{normalize=true}  \\\\1 & \\texttt{otherwise}\\end{cases}\\f]\n.   \n.   Unnormalized box filter is useful for computing various integral characteristics over each pixel\n.   neighborhood, such as covariance matrices of image derivatives (used in dense optical flow\n.   algorithms, and so on). If you need to compute pixel sums over variable-size windows, use #integral.\n.   \n.   @param src input image.\n.   @param dst output image of the same size and type as src.\n.   @param ddepth the output image depth (-1 to use src.depth()).\n.   @param ksize blurring kernel size.\n.   @param anchor anchor point; default value Point(-1,-1) means that the anchor is at the kernel\n.   center.\n.   @param normalize flag, specifying whether the kernel is normalized by its area or not.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  blur, bilateralFilter, GaussianBlur, medianBlur, integral"},
    {"boxPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_boxPoints, 0), "boxPoints(box[, points]) -> points\n.   @brief Finds the four vertices of a rotated rect. Useful to draw the rotated rectangle.\n.   \n.   The function finds the four vertices of a rotated rectangle. The four vertices are returned\n.   in clockwise order starting from the point with greatest \\f$y\\f$. If two points have the\n.   same \\f$y\\f$ coordinate the rightmost is the starting point. This function is useful to draw the\n.   rectangle. In C++, instead of using this function, you can directly use RotatedRect::points method. Please\n.   visit the @ref tutorial_bounding_rotated_ellipses \"tutorial on Creating Bounding rotated boxes and ellipses for contours\" for more information.\n.   \n.   @param box The input rotated rectangle. It may be the output of @ref minAreaRect.\n.   @param points The output array of four vertices of rectangles."},
    {"broadcast", CV_PY_FN_WITH_KW_(pyopencv_cv_broadcast, 0), "broadcast(src, shape[, dst]) -> dst\n.   @brief Broadcast the given Mat to the given shape.\n.    * @param src input array\n.    * @param shape target shape. Should be a list of CV_32S numbers. Note that negative values are not supported.\n.    * @param dst output array that has the given shape"},
    {"buildOpticalFlowPyramid", CV_PY_FN_WITH_KW_(pyopencv_cv_buildOpticalFlowPyramid, 0), "buildOpticalFlowPyramid(img, winSize, maxLevel[, pyramid[, withDerivatives[, pyrBorder[, derivBorder[, tryReuseInputImage]]]]]) -> retval, pyramid\n.   @brief Constructs the image pyramid which can be passed to calcOpticalFlowPyrLK.\n.   \n.   @param img 8-bit input image.\n.   @param pyramid output pyramid.\n.   @param winSize window size of optical flow algorithm. Must be not less than winSize argument of\n.   calcOpticalFlowPyrLK. It is needed to calculate required padding for pyramid levels.\n.   @param maxLevel 0-based maximal pyramid level number.\n.   @param withDerivatives set to precompute gradients for the every pyramid level. If pyramid is\n.   constructed without the gradients then calcOpticalFlowPyrLK will calculate them internally.\n.   @param pyrBorder the border mode for pyramid layers.\n.   @param derivBorder the border mode for gradients.\n.   @param tryReuseInputImage put ROI of input image into the pyramid if possible. You can pass false\n.   to force data copying.\n.   @return number of levels in constructed pyramid. Can be less than maxLevel."},
    {"calcBackProject", CV_PY_FN_WITH_KW_(pyopencv_cv_calcBackProject, 0), "calcBackProject(images, channels, hist, ranges, scale[, dst]) -> dst\n.   @overload"},
    {"calcCovarMatrix", CV_PY_FN_WITH_KW_(pyopencv_cv_calcCovarMatrix, 0), "calcCovarMatrix(samples, mean, flags[, covar[, ctype]]) -> covar, mean\n.   @overload\n.   @note use #COVAR_ROWS or #COVAR_COLS flag\n.   @param samples samples stored as rows/columns of a single matrix.\n.   @param covar output covariance matrix of the type ctype and square size.\n.   @param mean input or output (depending on the flags) array as the average value of the input vectors.\n.   @param flags operation flags as a combination of #CovarFlags\n.   @param ctype type of the matrixl; it equals 'CV_64F' by default."},
    {"calcHist", CV_PY_FN_WITH_KW_(pyopencv_cv_calcHist, 0), "calcHist(images, channels, mask, histSize, ranges[, hist[, accumulate]]) -> hist\n.   @overload\n.   \n.   this variant supports only uniform histograms.\n.   \n.   ranges argument is either empty vector or a flattened vector of histSize.size()*2 elements\n.   (histSize.size() element pairs). The first and second elements of each pair specify the lower and\n.   upper boundaries."},
    {"calcOpticalFlowFarneback", CV_PY_FN_WITH_KW_(pyopencv_cv_calcOpticalFlowFarneback, 0), "calcOpticalFlowFarneback(prev, next, flow, pyr_scale, levels, winsize, iterations, poly_n, poly_sigma, flags) -> flow\n.   @brief Computes a dense optical flow using the Gunnar Farneback's algorithm.\n.   \n.   @param prev first 8-bit single-channel input image.\n.   @param next second input image of the same size and the same type as prev.\n.   @param flow computed flow image that has the same size as prev and type CV_32FC2.\n.   @param pyr_scale parameter, specifying the image scale (\\<1) to build pyramids for each image;\n.   pyr_scale=0.5 means a classical pyramid, where each next layer is twice smaller than the previous\n.   one.\n.   @param levels number of pyramid layers including the initial image; levels=1 means that no extra\n.   layers are created and only the original images are used.\n.   @param winsize averaging window size; larger values increase the algorithm robustness to image\n.   noise and give more chances for fast motion detection, but yield more blurred motion field.\n.   @param iterations number of iterations the algorithm does at each pyramid level.\n.   @param poly_n size of the pixel neighborhood used to find polynomial expansion in each pixel;\n.   larger values mean that the image will be approximated with smoother surfaces, yielding more\n.   robust algorithm and more blurred motion field, typically poly_n =5 or 7.\n.   @param poly_sigma standard deviation of the Gaussian that is used to smooth derivatives used as a\n.   basis for the polynomial expansion; for poly_n=5, you can set poly_sigma=1.1, for poly_n=7, a\n.   good value would be poly_sigma=1.5.\n.   @param flags operation flags that can be a combination of the following:\n.    -   **OPTFLOW_USE_INITIAL_FLOW** uses the input flow as an initial flow approximation.\n.    -   **OPTFLOW_FARNEBACK_GAUSSIAN** uses the Gaussian \\f$\\texttt{winsize}\\times\\texttt{winsize}\\f$\n.        filter instead of a box filter of the same size for optical flow estimation; usually, this\n.        option gives z more accurate flow than with a box filter, at the cost of lower speed;\n.        normally, winsize for a Gaussian window should be set to a larger value to achieve the same\n.        level of robustness.\n.   \n.   The function finds an optical flow for each prev pixel using the @cite Farneback2003 algorithm so that\n.   \n.   \\f[\\texttt{prev} (y,x)  \\sim \\texttt{next} ( y + \\texttt{flow} (y,x)[1],  x + \\texttt{flow} (y,x)[0])\\f]\n.   \n.   @note Some examples:\n.   \n.   -   An example using the optical flow algorithm described by Gunnar Farneback can be found at\n.       opencv_source_code/samples/cpp/fback.cpp\n.   -   (Python) An example using the optical flow algorithm described by Gunnar Farneback can be\n.       found at opencv_source_code/samples/python/opt_flow.py"},
    {"calcOpticalFlowPyrLK", CV_PY_FN_WITH_KW_(pyopencv_cv_calcOpticalFlowPyrLK, 0), "calcOpticalFlowPyrLK(prevImg, nextImg, prevPts, nextPts[, status[, err[, winSize[, maxLevel[, criteria[, flags[, minEigThreshold]]]]]]]) -> nextPts, status, err\n.   @brief Calculates an optical flow for a sparse feature set using the iterative Lucas-Kanade method with\n.   pyramids.\n.   \n.   @param prevImg first 8-bit input image or pyramid constructed by buildOpticalFlowPyramid.\n.   @param nextImg second input image or pyramid of the same size and the same type as prevImg.\n.   @param prevPts vector of 2D points for which the flow needs to be found; point coordinates must be\n.   single-precision floating-point numbers.\n.   @param nextPts output vector of 2D points (with single-precision floating-point coordinates)\n.   containing the calculated new positions of input features in the second image; when\n.   OPTFLOW_USE_INITIAL_FLOW flag is passed, the vector must have the same size as in the input.\n.   @param status output status vector (of unsigned chars); each element of the vector is set to 1 if\n.   the flow for the corresponding features has been found, otherwise, it is set to 0.\n.   @param err output vector of errors; each element of the vector is set to an error for the\n.   corresponding feature, type of the error measure can be set in flags parameter; if the flow wasn't\n.   found then the error is not defined (use the status parameter to find such cases).\n.   @param winSize size of the search window at each pyramid level.\n.   @param maxLevel 0-based maximal pyramid level number; if set to 0, pyramids are not used (single\n.   level), if set to 1, two levels are used, and so on; if pyramids are passed to input then\n.   algorithm will use as many levels as pyramids have but no more than maxLevel.\n.   @param criteria parameter, specifying the termination criteria of the iterative search algorithm\n.   (after the specified maximum number of iterations criteria.maxCount or when the search window\n.   moves by less than criteria.epsilon.\n.   @param flags operation flags:\n.    -   **OPTFLOW_USE_INITIAL_FLOW** uses initial estimations, stored in nextPts; if the flag is\n.        not set, then prevPts is copied to nextPts and is considered the initial estimate.\n.    -   **OPTFLOW_LK_GET_MIN_EIGENVALS** use minimum eigen values as an error measure (see\n.        minEigThreshold description); if the flag is not set, then L1 distance between patches\n.        around the original and a moved point, divided by number of pixels in a window, is used as a\n.        error measure.\n.   @param minEigThreshold the algorithm calculates the minimum eigen value of a 2x2 normal matrix of\n.   optical flow equations (this matrix is called a spatial gradient matrix in @cite Bouguet00), divided\n.   by number of pixels in a window; if this value is less than minEigThreshold, then a corresponding\n.   feature is filtered out and its flow is not processed, so it allows to remove bad points and get a\n.   performance boost.\n.   \n.   The function implements a sparse iterative version of the Lucas-Kanade optical flow in pyramids. See\n.   @cite Bouguet00 . The function is parallelized with the TBB library.\n.   \n.   @note Some examples:\n.   \n.   -   An example using the Lucas-Kanade optical flow algorithm can be found at\n.       opencv_source_code/samples/cpp/lkdemo.cpp\n.   -   (Python) An example using the Lucas-Kanade optical flow algorithm can be found at\n.       opencv_source_code/samples/python/lk_track.py\n.   -   (Python) An example using the Lucas-Kanade tracker for homography matching can be found at\n.       opencv_source_code/samples/python/lk_homography.py"},
    {"calibrateCamera", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrateCamera, 0), "calibrateCamera(objectPoints, imagePoints, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs\n.   @overload"},
    {"calibrateCameraExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrateCameraExtended, 0), "calibrateCameraExtended(objectPoints, imagePoints, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, stdDeviationsIntrinsics, stdDeviationsExtrinsics, perViewErrors\n.   @brief Finds the camera intrinsic and extrinsic parameters from several views of a calibration\n.   pattern.\n.   \n.   @param objectPoints In the new interface it is a vector of vectors of calibration pattern points in\n.   the calibration pattern coordinate space (e.g. std::vector<std::vector<cv::Vec3f>>). The outer\n.   vector contains as many elements as the number of pattern views. If the same calibration pattern\n.   is shown in each view and it is fully visible, all the vectors will be the same. Although, it is\n.   possible to use partially occluded patterns or even different patterns in different views. Then,\n.   the vectors will be different. Although the points are 3D, they all lie in the calibration pattern's\n.   XY coordinate plane (thus 0 in the Z-coordinate), if the used calibration pattern is a planar rig.\n.   In the old interface all the vectors of object points from different views are concatenated\n.   together.\n.   @param imagePoints In the new interface it is a vector of vectors of the projections of calibration\n.   pattern points (e.g. std::vector<std::vector<cv::Vec2f>>). imagePoints.size() and\n.   objectPoints.size(), and imagePoints[i].size() and objectPoints[i].size() for each i, must be equal,\n.   respectively. In the old interface all the vectors of object points from different views are\n.   concatenated together.\n.   @param imageSize Size of the image used only to initialize the camera intrinsic matrix.\n.   @param cameraMatrix Input/output 3x3 floating-point camera intrinsic matrix\n.   \\f$\\cameramatrix{A}\\f$ . If @ref CALIB_USE_INTRINSIC_GUESS\n.   and/or @ref CALIB_FIX_ASPECT_RATIO, @ref CALIB_FIX_PRINCIPAL_POINT or @ref CALIB_FIX_FOCAL_LENGTH\n.   are specified, some or all of fx, fy, cx, cy must be initialized before calling the function.\n.   @param distCoeffs Input/output vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$.\n.   @param rvecs Output vector of rotation vectors (@ref Rodrigues ) estimated for each pattern view\n.   (e.g. std::vector<cv::Mat>>). That is, each i-th rotation vector together with the corresponding\n.   i-th translation vector (see the next output parameter description) brings the calibration pattern\n.   from the object coordinate space (in which object points are specified) to the camera coordinate\n.   space. In more technical terms, the tuple of the i-th rotation and translation vector performs\n.   a change of basis from object coordinate space to camera coordinate space. Due to its duality, this\n.   tuple is equivalent to the position of the calibration pattern with respect to the camera coordinate\n.   space.\n.   @param tvecs Output vector of translation vectors estimated for each pattern view, see parameter\n.   describtion above.\n.   @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic\n.   parameters. Order of deviations values:\n.   \\f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,\n.    s_4, \\tau_x, \\tau_y)\\f$ If one of parameters is not estimated, it's deviation is equals to zero.\n.   @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic\n.   parameters. Order of deviations values: \\f$(R_0, T_0, \\dotsc , R_{M - 1}, T_{M - 1})\\f$ where M is\n.   the number of pattern views. \\f$R_i, T_i\\f$ are concatenated 1x3 vectors.\n.    @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.\n.   @param flags Different flags that may be zero or a combination of the following values:\n.   -   @ref CALIB_USE_INTRINSIC_GUESS cameraMatrix contains valid initial values of\n.   fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image\n.   center ( imageSize is used), and focal distances are computed in a least-squares fashion.\n.   Note, that if intrinsic parameters are known, there is no need to use this function just to\n.   estimate extrinsic parameters. Use @ref solvePnP instead.\n.   -   @ref CALIB_FIX_PRINCIPAL_POINT The principal point is not changed during the global\n.   optimization. It stays at the center or at a different location specified when\n.    @ref CALIB_USE_INTRINSIC_GUESS is set too.\n.   -   @ref CALIB_FIX_ASPECT_RATIO The functions consider only fy as a free parameter. The\n.   ratio fx/fy stays the same as in the input cameraMatrix . When\n.    @ref CALIB_USE_INTRINSIC_GUESS is not set, the actual input values of fx and fy are\n.   ignored, only their ratio is computed and used further.\n.   -   @ref CALIB_ZERO_TANGENT_DIST Tangential distortion coefficients \\f$(p_1, p_2)\\f$ are set\n.   to zeros and stay zero.\n.   -   @ref CALIB_FIX_FOCAL_LENGTH The focal length is not changed during the global optimization if\n.    @ref CALIB_USE_INTRINSIC_GUESS is set.\n.   -   @ref CALIB_FIX_K1,..., @ref CALIB_FIX_K6 The corresponding radial distortion\n.   coefficient is not changed during the optimization. If @ref CALIB_USE_INTRINSIC_GUESS is\n.   set, the coefficient from the supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   @ref CALIB_RATIONAL_MODEL Coefficients k4, k5, and k6 are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the rational model and return 8 coefficients or more.\n.   -   @ref CALIB_THIN_PRISM_MODEL Coefficients s1, s2, s3 and s4 are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the thin prism model and return 12 coefficients or more.\n.   -   @ref CALIB_FIX_S1_S2_S3_S4 The thin prism distortion coefficients are not changed during\n.   the optimization. If @ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   @ref CALIB_TILTED_MODEL Coefficients tauX and tauY are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the tilted sensor model and return 14 coefficients.\n.   -   @ref CALIB_FIX_TAUX_TAUY The coefficients of the tilted sensor model are not changed during\n.   the optimization. If @ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   @param criteria Termination criteria for the iterative optimization algorithm.\n.   \n.   @return the overall RMS re-projection error.\n.   \n.   The function estimates the intrinsic camera parameters and extrinsic parameters for each of the\n.   views. The algorithm is based on @cite Zhang2000 and @cite BouguetMCT . The coordinates of 3D object\n.   points and their corresponding 2D projections in each view must be specified. That may be achieved\n.   by using an object with known geometry and easily detectable feature points. Such an object is\n.   called a calibration rig or calibration pattern, and OpenCV has built-in support for a chessboard as\n.   a calibration rig (see @ref findChessboardCorners). Currently, initialization of intrinsic\n.   parameters (when @ref CALIB_USE_INTRINSIC_GUESS is not set) is only implemented for planar calibration\n.   patterns (where Z-coordinates of the object points must be all zeros). 3D calibration rigs can also\n.   be used as long as initial cameraMatrix is provided.\n.   \n.   The algorithm performs the following steps:\n.   \n.   -   Compute the initial intrinsic parameters (the option only available for planar calibration\n.       patterns) or read them from the input parameters. The distortion coefficients are all set to\n.       zeros initially unless some of CALIB_FIX_K? are specified.\n.   \n.   -   Estimate the initial camera pose as if the intrinsic parameters have been already known. This is\n.       done using @ref solvePnP .\n.   \n.   -   Run the global Levenberg-Marquardt optimization algorithm to minimize the reprojection error,\n.       that is, the total sum of squared distances between the observed feature points imagePoints and\n.       the projected (using the current estimates for camera parameters and the poses) object points\n.       objectPoints. See @ref projectPoints for details.\n.   \n.   @note\n.       If you use a non-square (i.e. non-N-by-N) grid and @ref findChessboardCorners for calibration,\n.       and @ref calibrateCamera returns bad values (zero distortion coefficients, \\f$c_x\\f$ and\n.       \\f$c_y\\f$ very far from the image center, and/or large differences between \\f$f_x\\f$ and\n.       \\f$f_y\\f$ (ratios of 10:1 or more)), then you are probably using patternSize=cvSize(rows,cols)\n.       instead of using patternSize=cvSize(cols,rows) in @ref findChessboardCorners.\n.   \n.   @note\n.       The function may throw exceptions, if unsupported combination of parameters is provided or\n.       the system is underconstrained.\n.   \n.   @sa\n.      calibrateCameraRO, findChessboardCorners, solvePnP, initCameraMatrix2D, stereoCalibrate,\n.      undistort"},
    {"calibrateCameraRO", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrateCameraRO, 0), "calibrateCameraRO(objectPoints, imagePoints, imageSize, iFixedPoint, cameraMatrix, distCoeffs[, rvecs[, tvecs[, newObjPoints[, flags[, criteria]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, newObjPoints\n.   @overload"},
    {"calibrateCameraROExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrateCameraROExtended, 0), "calibrateCameraROExtended(objectPoints, imagePoints, imageSize, iFixedPoint, cameraMatrix, distCoeffs[, rvecs[, tvecs[, newObjPoints[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, stdDeviationsObjPoints[, perViewErrors[, flags[, criteria]]]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, newObjPoints, stdDeviationsIntrinsics, stdDeviationsExtrinsics, stdDeviationsObjPoints, perViewErrors\n.   @brief Finds the camera intrinsic and extrinsic parameters from several views of a calibration pattern.\n.   \n.   This function is an extension of #calibrateCamera with the method of releasing object which was\n.   proposed in @cite strobl2011iccv. In many common cases with inaccurate, unmeasured, roughly planar\n.   targets (calibration plates), this method can dramatically improve the precision of the estimated\n.   camera parameters. Both the object-releasing method and standard method are supported by this\n.   function. Use the parameter **iFixedPoint** for method selection. In the internal implementation,\n.   #calibrateCamera is a wrapper for this function.\n.   \n.   @param objectPoints Vector of vectors of calibration pattern points in the calibration pattern\n.   coordinate space. See #calibrateCamera for details. If the method of releasing object to be used,\n.   the identical calibration board must be used in each view and it must be fully visible, and all\n.   objectPoints[i] must be the same and all points should be roughly close to a plane. **The calibration\n.   target has to be rigid, or at least static if the camera (rather than the calibration target) is\n.   shifted for grabbing images.**\n.   @param imagePoints Vector of vectors of the projections of calibration pattern points. See\n.   #calibrateCamera for details.\n.   @param imageSize Size of the image used only to initialize the intrinsic camera matrix.\n.   @param iFixedPoint The index of the 3D object point in objectPoints[0] to be fixed. It also acts as\n.   a switch for calibration method selection. If object-releasing method to be used, pass in the\n.   parameter in the range of [1, objectPoints[0].size()-2], otherwise a value out of this range will\n.   make standard calibration method selected. Usually the top-right corner point of the calibration\n.   board grid is recommended to be fixed when object-releasing method being utilized. According to\n.   \\cite strobl2011iccv, two other points are also fixed. In this implementation, objectPoints[0].front\n.   and objectPoints[0].back.z are used. With object-releasing method, accurate rvecs, tvecs and\n.   newObjPoints are only possible if coordinates of these three fixed points are accurate enough.\n.   @param cameraMatrix Output 3x3 floating-point camera matrix. See #calibrateCamera for details.\n.   @param distCoeffs Output vector of distortion coefficients. See #calibrateCamera for details.\n.   @param rvecs Output vector of rotation vectors estimated for each pattern view. See #calibrateCamera\n.   for details.\n.   @param tvecs Output vector of translation vectors estimated for each pattern view.\n.   @param newObjPoints The updated output vector of calibration pattern points. The coordinates might\n.   be scaled based on three fixed points. The returned coordinates are accurate only if the above\n.   mentioned three fixed points are accurate. If not needed, noArray() can be passed in. This parameter\n.   is ignored with standard calibration method.\n.   @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.\n.   See #calibrateCamera for details.\n.   @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.\n.   See #calibrateCamera for details.\n.   @param stdDeviationsObjPoints Output vector of standard deviations estimated for refined coordinates\n.   of calibration pattern points. It has the same size and order as objectPoints[0] vector. This\n.   parameter is ignored with standard calibration method.\n.    @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.\n.   @param flags Different flags that may be zero or a combination of some predefined values. See\n.   #calibrateCamera for details. If the method of releasing object is used, the calibration time may\n.   be much longer. CALIB_USE_QR or CALIB_USE_LU could be used for faster calibration with potentially\n.   less precise and less stable in some rare cases.\n.   @param criteria Termination criteria for the iterative optimization algorithm.\n.   \n.   @return the overall RMS re-projection error.\n.   \n.   The function estimates the intrinsic camera parameters and extrinsic parameters for each of the\n.   views. The algorithm is based on @cite Zhang2000, @cite BouguetMCT and @cite strobl2011iccv. See\n.   #calibrateCamera for other detailed explanations.\n.   @sa\n.      calibrateCamera, findChessboardCorners, solvePnP, initCameraMatrix2D, stereoCalibrate, undistort"},
    {"calibrateHandEye", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrateHandEye, 0), "calibrateHandEye(R_gripper2base, t_gripper2base, R_target2cam, t_target2cam[, R_cam2gripper[, t_cam2gripper[, method]]]) -> R_cam2gripper, t_cam2gripper\n.   @brief Computes Hand-Eye calibration: \\f$_{}^{g}\\textrm{T}_c\\f$\n.   \n.   @param[in] R_gripper2base Rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the gripper frame to the robot base frame (\\f$_{}^{b}\\textrm{T}_g\\f$).\n.   This is a vector (`vector<Mat>`) that contains the rotation, `(3x3)` rotation matrices or `(3x1)` rotation vectors,\n.   for all the transformations from gripper frame to robot base frame.\n.   @param[in] t_gripper2base Translation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the gripper frame to the robot base frame (\\f$_{}^{b}\\textrm{T}_g\\f$).\n.   This is a vector (`vector<Mat>`) that contains the `(3x1)` translation vectors for all the transformations\n.   from gripper frame to robot base frame.\n.   @param[in] R_target2cam Rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the target frame to the camera frame (\\f$_{}^{c}\\textrm{T}_t\\f$).\n.   This is a vector (`vector<Mat>`) that contains the rotation, `(3x3)` rotation matrices or `(3x1)` rotation vectors,\n.   for all the transformations from calibration target frame to camera frame.\n.   @param[in] t_target2cam Rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the target frame to the camera frame (\\f$_{}^{c}\\textrm{T}_t\\f$).\n.   This is a vector (`vector<Mat>`) that contains the `(3x1)` translation vectors for all the transformations\n.   from calibration target frame to camera frame.\n.   @param[out] R_cam2gripper Estimated `(3x3)` rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the camera frame to the gripper frame (\\f$_{}^{g}\\textrm{T}_c\\f$).\n.   @param[out] t_cam2gripper Estimated `(3x1)` translation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the camera frame to the gripper frame (\\f$_{}^{g}\\textrm{T}_c\\f$).\n.   @param[in] method One of the implemented Hand-Eye calibration method, see cv::HandEyeCalibrationMethod\n.   \n.   The function performs the Hand-Eye calibration using various methods. One approach consists in estimating the\n.   rotation then the translation (separable solutions) and the following methods are implemented:\n.     - R. Tsai, R. Lenz A New Technique for Fully Autonomous and Efficient 3D Robotics Hand/EyeCalibration \\cite Tsai89\n.     - F. Park, B. Martin Robot Sensor Calibration: Solving AX = XB on the Euclidean Group \\cite Park94\n.     - R. Horaud, F. Dornaika Hand-Eye Calibration \\cite Horaud95\n.   \n.   Another approach consists in estimating simultaneously the rotation and the translation (simultaneous solutions),\n.   with the following implemented methods:\n.     - N. Andreff, R. Horaud, B. Espiau On-line Hand-Eye Calibration \\cite Andreff99\n.     - K. Daniilidis Hand-Eye Calibration Using Dual Quaternions \\cite Daniilidis98\n.   \n.   The following picture describes the Hand-Eye calibration problem where the transformation between a camera (\"eye\")\n.   mounted on a robot gripper (\"hand\") has to be estimated. This configuration is called eye-in-hand.\n.   \n.   The eye-to-hand configuration consists in a static camera observing a calibration pattern mounted on the robot\n.   end-effector. The transformation from the camera to the robot base frame can then be estimated by inputting\n.   the suitable transformations to the function, see below.\n.   \n.   ![](pics/hand-eye_figure.png)\n.   \n.   The calibration procedure is the following:\n.     - a static calibration pattern is used to estimate the transformation between the target frame\n.     and the camera frame\n.     - the robot gripper is moved in order to acquire several poses\n.     - for each pose, the homogeneous transformation between the gripper frame and the robot base frame is recorded using for\n.     instance the robot kinematics\n.   \\f[\n.       \\begin{bmatrix}\n.       X_b\\\\\n.       Y_b\\\\\n.       Z_b\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{b}\\textrm{R}_g & _{}^{b}\\textrm{t}_g \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_g\\\\\n.       Y_g\\\\\n.       Z_g\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.     - for each pose, the homogeneous transformation between the calibration target frame and the camera frame is recorded using\n.     for instance a pose estimation method (PnP) from 2D-3D point correspondences\n.   \\f[\n.       \\begin{bmatrix}\n.       X_c\\\\\n.       Y_c\\\\\n.       Z_c\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{c}\\textrm{R}_t & _{}^{c}\\textrm{t}_t \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_t\\\\\n.       Y_t\\\\\n.       Z_t\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.   \n.   The Hand-Eye calibration procedure returns the following homogeneous transformation\n.   \\f[\n.       \\begin{bmatrix}\n.       X_g\\\\\n.       Y_g\\\\\n.       Z_g\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{g}\\textrm{R}_c & _{}^{g}\\textrm{t}_c \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_c\\\\\n.       Y_c\\\\\n.       Z_c\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.   \n.   This problem is also known as solving the \\f$\\mathbf{A}\\mathbf{X}=\\mathbf{X}\\mathbf{B}\\f$ equation:\n.     - for an eye-in-hand configuration\n.   \\f[\n.       \\begin{align*}\n.       ^{b}{\\textrm{T}_g}^{(1)} \\hspace{0.2em} ^{g}\\textrm{T}_c \\hspace{0.2em} ^{c}{\\textrm{T}_t}^{(1)} &=\n.       \\hspace{0.1em} ^{b}{\\textrm{T}_g}^{(2)} \\hspace{0.2em} ^{g}\\textrm{T}_c \\hspace{0.2em} ^{c}{\\textrm{T}_t}^{(2)} \\\\\n.   \n.       (^{b}{\\textrm{T}_g}^{(2)})^{-1} \\hspace{0.2em} ^{b}{\\textrm{T}_g}^{(1)} \\hspace{0.2em} ^{g}\\textrm{T}_c &=\n.       \\hspace{0.1em} ^{g}\\textrm{T}_c \\hspace{0.2em} ^{c}{\\textrm{T}_t}^{(2)} (^{c}{\\textrm{T}_t}^{(1)})^{-1} \\\\\n.   \n.       \\textrm{A}_i \\textrm{X} &= \\textrm{X} \\textrm{B}_i \\\\\n.       \\end{align*}\n.   \\f]\n.   \n.     - for an eye-to-hand configuration\n.   \\f[\n.       \\begin{align*}\n.       ^{g}{\\textrm{T}_b}^{(1)} \\hspace{0.2em} ^{b}\\textrm{T}_c \\hspace{0.2em} ^{c}{\\textrm{T}_t}^{(1)} &=\n.       \\hspace{0.1em} ^{g}{\\textrm{T}_b}^{(2)} \\hspace{0.2em} ^{b}\\textrm{T}_c \\hspace{0.2em} ^{c}{\\textrm{T}_t}^{(2)} \\\\\n.   \n.       (^{g}{\\textrm{T}_b}^{(2)})^{-1} \\hspace{0.2em} ^{g}{\\textrm{T}_b}^{(1)} \\hspace{0.2em} ^{b}\\textrm{T}_c &=\n.       \\hspace{0.1em} ^{b}\\textrm{T}_c \\hspace{0.2em} ^{c}{\\textrm{T}_t}^{(2)} (^{c}{\\textrm{T}_t}^{(1)})^{-1} \\\\\n.   \n.       \\textrm{A}_i \\textrm{X} &= \\textrm{X} \\textrm{B}_i \\\\\n.       \\end{align*}\n.   \\f]\n.   \n.   \\note\n.   Additional information can be found on this [website](http://campar.in.tum.de/Chair/HandEyeCalibration).\n.   \\note\n.   A minimum of 2 motions with non parallel rotation axes are necessary to determine the hand-eye transformation.\n.   So at least 3 different poses are required, but it is strongly recommended to use many more poses."},
    {"calibrateRobotWorldHandEye", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrateRobotWorldHandEye, 0), "calibrateRobotWorldHandEye(R_world2cam, t_world2cam, R_base2gripper, t_base2gripper[, R_base2world[, t_base2world[, R_gripper2cam[, t_gripper2cam[, method]]]]]) -> R_base2world, t_base2world, R_gripper2cam, t_gripper2cam\n.   @brief Computes Robot-World/Hand-Eye calibration: \\f$_{}^{w}\\textrm{T}_b\\f$ and \\f$_{}^{c}\\textrm{T}_g\\f$\n.   \n.   @param[in] R_world2cam Rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the world frame to the camera frame (\\f$_{}^{c}\\textrm{T}_w\\f$).\n.   This is a vector (`vector<Mat>`) that contains the rotation, `(3x3)` rotation matrices or `(3x1)` rotation vectors,\n.   for all the transformations from world frame to the camera frame.\n.   @param[in] t_world2cam Translation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the world frame to the camera frame (\\f$_{}^{c}\\textrm{T}_w\\f$).\n.   This is a vector (`vector<Mat>`) that contains the `(3x1)` translation vectors for all the transformations\n.   from world frame to the camera frame.\n.   @param[in] R_base2gripper Rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the robot base frame to the gripper frame (\\f$_{}^{g}\\textrm{T}_b\\f$).\n.   This is a vector (`vector<Mat>`) that contains the rotation, `(3x3)` rotation matrices or `(3x1)` rotation vectors,\n.   for all the transformations from robot base frame to the gripper frame.\n.   @param[in] t_base2gripper Rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the robot base frame to the gripper frame (\\f$_{}^{g}\\textrm{T}_b\\f$).\n.   This is a vector (`vector<Mat>`) that contains the `(3x1)` translation vectors for all the transformations\n.   from robot base frame to the gripper frame.\n.   @param[out] R_base2world Estimated `(3x3)` rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the robot base frame to the world frame (\\f$_{}^{w}\\textrm{T}_b\\f$).\n.   @param[out] t_base2world Estimated `(3x1)` translation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the robot base frame to the world frame (\\f$_{}^{w}\\textrm{T}_b\\f$).\n.   @param[out] R_gripper2cam Estimated `(3x3)` rotation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the gripper frame to the camera frame (\\f$_{}^{c}\\textrm{T}_g\\f$).\n.   @param[out] t_gripper2cam Estimated `(3x1)` translation part extracted from the homogeneous matrix that transforms a point\n.   expressed in the gripper frame to the camera frame (\\f$_{}^{c}\\textrm{T}_g\\f$).\n.   @param[in] method One of the implemented Robot-World/Hand-Eye calibration method, see cv::RobotWorldHandEyeCalibrationMethod\n.   \n.   The function performs the Robot-World/Hand-Eye calibration using various methods. One approach consists in estimating the\n.   rotation then the translation (separable solutions):\n.     - M. Shah, Solving the robot-world/hand-eye calibration problem using the kronecker product \\cite Shah2013SolvingTR\n.   \n.   Another approach consists in estimating simultaneously the rotation and the translation (simultaneous solutions),\n.   with the following implemented method:\n.     - A. Li, L. Wang, and D. Wu, Simultaneous robot-world and hand-eye calibration using dual-quaternions and kronecker product \\cite Li2010SimultaneousRA\n.   \n.   The following picture describes the Robot-World/Hand-Eye calibration problem where the transformations between a robot and a world frame\n.   and between a robot gripper (\"hand\") and a camera (\"eye\") mounted at the robot end-effector have to be estimated.\n.   \n.   ![](pics/robot-world_hand-eye_figure.png)\n.   \n.   The calibration procedure is the following:\n.     - a static calibration pattern is used to estimate the transformation between the target frame\n.     and the camera frame\n.     - the robot gripper is moved in order to acquire several poses\n.     - for each pose, the homogeneous transformation between the gripper frame and the robot base frame is recorded using for\n.     instance the robot kinematics\n.   \\f[\n.       \\begin{bmatrix}\n.       X_g\\\\\n.       Y_g\\\\\n.       Z_g\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{g}\\textrm{R}_b & _{}^{g}\\textrm{t}_b \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_b\\\\\n.       Y_b\\\\\n.       Z_b\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.     - for each pose, the homogeneous transformation between the calibration target frame (the world frame) and the camera frame is recorded using\n.     for instance a pose estimation method (PnP) from 2D-3D point correspondences\n.   \\f[\n.       \\begin{bmatrix}\n.       X_c\\\\\n.       Y_c\\\\\n.       Z_c\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{c}\\textrm{R}_w & _{}^{c}\\textrm{t}_w \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_w\\\\\n.       Y_w\\\\\n.       Z_w\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.   \n.   The Robot-World/Hand-Eye calibration procedure returns the following homogeneous transformations\n.   \\f[\n.       \\begin{bmatrix}\n.       X_w\\\\\n.       Y_w\\\\\n.       Z_w\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{w}\\textrm{R}_b & _{}^{w}\\textrm{t}_b \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_b\\\\\n.       Y_b\\\\\n.       Z_b\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.   \\f[\n.       \\begin{bmatrix}\n.       X_c\\\\\n.       Y_c\\\\\n.       Z_c\\\\\n.       1\n.       \\end{bmatrix}\n.       =\n.       \\begin{bmatrix}\n.       _{}^{c}\\textrm{R}_g & _{}^{c}\\textrm{t}_g \\\\\n.       0_{1 \\times 3} & 1\n.       \\end{bmatrix}\n.       \\begin{bmatrix}\n.       X_g\\\\\n.       Y_g\\\\\n.       Z_g\\\\\n.       1\n.       \\end{bmatrix}\n.   \\f]\n.   \n.   This problem is also known as solving the \\f$\\mathbf{A}\\mathbf{X}=\\mathbf{Z}\\mathbf{B}\\f$ equation, with:\n.     - \\f$\\mathbf{A} \\Leftrightarrow \\hspace{0.1em} _{}^{c}\\textrm{T}_w\\f$\n.     - \\f$\\mathbf{X} \\Leftrightarrow \\hspace{0.1em} _{}^{w}\\textrm{T}_b\\f$\n.     - \\f$\\mathbf{Z} \\Leftrightarrow \\hspace{0.1em} _{}^{c}\\textrm{T}_g\\f$\n.     - \\f$\\mathbf{B} \\Leftrightarrow \\hspace{0.1em} _{}^{g}\\textrm{T}_b\\f$\n.   \n.   \\note\n.   At least 3 measurements are required (input vectors size must be greater or equal to 3)."},
    {"calibrationMatrixValues", CV_PY_FN_WITH_KW_(pyopencv_cv_calibrationMatrixValues, 0), "calibrationMatrixValues(cameraMatrix, imageSize, apertureWidth, apertureHeight) -> fovx, fovy, focalLength, principalPoint, aspectRatio\n.   @brief Computes useful camera characteristics from the camera intrinsic matrix.\n.   \n.   @param cameraMatrix Input camera intrinsic matrix that can be estimated by #calibrateCamera or\n.   #stereoCalibrate .\n.   @param imageSize Input image size in pixels.\n.   @param apertureWidth Physical width in mm of the sensor.\n.   @param apertureHeight Physical height in mm of the sensor.\n.   @param fovx Output field of view in degrees along the horizontal sensor axis.\n.   @param fovy Output field of view in degrees along the vertical sensor axis.\n.   @param focalLength Focal length of the lens in mm.\n.   @param principalPoint Principal point in mm.\n.   @param aspectRatio \\f$f_y/f_x\\f$\n.   \n.   The function computes various useful camera characteristics from the previously estimated camera\n.   matrix.\n.   \n.   @note\n.      Do keep in mind that the unity measure 'mm' stands for whatever unit of measure one chooses for\n.       the chessboard pitch (it can thus be any value)."},
    {"cartToPolar", CV_PY_FN_WITH_KW_(pyopencv_cv_cartToPolar, 0), "cartToPolar(x, y[, magnitude[, angle[, angleInDegrees]]]) -> magnitude, angle\n.   @brief Calculates the magnitude and angle of 2D vectors.\n.   \n.   The function cv::cartToPolar calculates either the magnitude, angle, or both\n.   for every 2D vector (x(I),y(I)):\n.   \\f[\\begin{array}{l} \\texttt{magnitude} (I)= \\sqrt{\\texttt{x}(I)^2+\\texttt{y}(I)^2} , \\\\ \\texttt{angle} (I)= \\texttt{atan2} ( \\texttt{y} (I), \\texttt{x} (I))[ \\cdot180 / \\pi ] \\end{array}\\f]\n.   \n.   The angles are calculated with accuracy about 0.3 degrees. For the point\n.   (0,0), the angle is set to 0.\n.   @param x array of x-coordinates; this must be a single-precision or\n.   double-precision floating-point array.\n.   @param y array of y-coordinates, that must have the same size and same type as x.\n.   @param magnitude output array of magnitudes of the same size and type as x.\n.   @param angle output array of angles that has the same size and type as\n.   x; the angles are measured in radians (from 0 to 2\\*Pi) or in degrees (0 to 360 degrees).\n.   @param angleInDegrees a flag, indicating whether the angles are measured\n.   in radians (which is by default), or in degrees.\n.   @sa Sobel, Scharr"},
    {"checkChessboard", CV_PY_FN_WITH_KW_(pyopencv_cv_checkChessboard, 0), "checkChessboard(img, size) -> retval\n."},
    {"checkHardwareSupport", CV_PY_FN_WITH_KW_(pyopencv_cv_checkHardwareSupport, 0), "checkHardwareSupport(feature) -> retval\n.   @brief Returns true if the specified feature is supported by the host hardware.\n.   \n.   The function returns true if the host hardware supports the specified feature. When user calls\n.   setUseOptimized(false), the subsequent calls to checkHardwareSupport() will return false until\n.   setUseOptimized(true) is called. This way user can dynamically switch on and off the optimized code\n.   in OpenCV.\n.   @param feature The feature of interest, one of cv::CpuFeatures"},
    {"checkRange", CV_PY_FN_WITH_KW_(pyopencv_cv_checkRange, 0), "checkRange(a[, quiet[, minVal[, maxVal]]]) -> retval, pos\n.   @brief Checks every element of an input array for invalid values.\n.   \n.   The function cv::checkRange checks that every array element is neither NaN nor infinite. When minVal \\>\n.   -DBL_MAX and maxVal \\< DBL_MAX, the function also checks that each value is between minVal and\n.   maxVal. In case of multi-channel arrays, each channel is processed independently. If some values\n.   are out of range, position of the first outlier is stored in pos (when pos != NULL). Then, the\n.   function either returns false (when quiet=true) or throws an exception.\n.   @param a input array.\n.   @param quiet a flag, indicating whether the functions quietly return false when the array elements\n.   are out of range or they throw an exception.\n.   @param pos optional output parameter, when not NULL, must be a pointer to array of src.dims\n.   elements.\n.   @param minVal inclusive lower boundary of valid values range.\n.   @param maxVal exclusive upper boundary of valid values range."},
    {"circle", CV_PY_FN_WITH_KW_(pyopencv_cv_circle, 0), "circle(img, center, radius, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a circle.\n.   \n.   The function cv::circle draws a simple or filled circle with a given center and radius.\n.   @param img Image where the circle is drawn.\n.   @param center Center of the circle.\n.   @param radius Radius of the circle.\n.   @param color Circle color.\n.   @param thickness Thickness of the circle outline, if positive. Negative values, like #FILLED,\n.   mean that a filled circle is to be drawn.\n.   @param lineType Type of the circle boundary. See #LineTypes\n.   @param shift Number of fractional bits in the coordinates of the center and in the radius value."},
    {"clipLine", CV_PY_FN_WITH_KW_(pyopencv_cv_clipLine, 0), "clipLine(imgRect, pt1, pt2) -> retval, pt1, pt2\n.   @overload\n.   @param imgRect Image rectangle.\n.   @param pt1 First line point.\n.   @param pt2 Second line point."},
    {"colorChange", CV_PY_FN_WITH_KW_(pyopencv_cv_colorChange, 0), "colorChange(src, mask[, dst[, red_mul[, green_mul[, blue_mul]]]]) -> dst\n.   @brief Given an original color image, two differently colored versions of this image can be mixed\n.   seamlessly.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param red_mul R-channel multiply factor.\n.   @param green_mul G-channel multiply factor.\n.   @param blue_mul B-channel multiply factor.\n.   \n.   Multiplication factor is between .5 to 2.5."},
    {"compare", CV_PY_FN_WITH_KW_(pyopencv_cv_compare, 0), "compare(src1, src2, cmpop[, dst]) -> dst\n.   @brief Performs the per-element comparison of two arrays or an array and scalar value.\n.   \n.   The function compares:\n.   *   Elements of two arrays when src1 and src2 have the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\,\\texttt{cmpop}\\, \\texttt{src2} (I)\\f]\n.   *   Elements of src1 with a scalar src2 when src2 is constructed from\n.       Scalar or has a single element:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1}(I) \\,\\texttt{cmpop}\\,  \\texttt{src2}\\f]\n.   *   src1 with elements of src2 when src1 is constructed from Scalar or\n.       has a single element:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\,\\texttt{cmpop}\\, \\texttt{src2} (I)\\f]\n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.   @code{.cpp}\n.       Mat dst1 = src1 >= src2;\n.       Mat dst2 = src1 < 8;\n.       ...\n.   @endcode\n.   @param src1 first input array or a scalar; when it is an array, it must have a single channel.\n.   @param src2 second input array or a scalar; when it is an array, it must have a single channel.\n.   @param dst output array of type ref CV_8U that has the same size and the same number of channels as\n.       the input arrays.\n.   @param cmpop a flag, that specifies correspondence between the arrays (cv::CmpTypes)\n.   @sa checkRange, min, max, threshold"},
    {"compareHist", CV_PY_FN_WITH_KW_(pyopencv_cv_compareHist, 0), "compareHist(H1, H2, method) -> retval\n.   @brief Compares two histograms.\n.   \n.   The function cv::compareHist compares two dense or two sparse histograms using the specified method.\n.   \n.   The function returns \\f$d(H_1, H_2)\\f$ .\n.   \n.   While the function works well with 1-, 2-, 3-dimensional dense histograms, it may not be suitable\n.   for high-dimensional sparse histograms. In such histograms, because of aliasing and sampling\n.   problems, the coordinates of non-zero histogram bins can slightly shift. To compare such histograms\n.   or more general sparse configurations of weighted points, consider using the #EMD function.\n.   \n.   @param H1 First compared histogram.\n.   @param H2 Second compared histogram of the same size as H1 .\n.   @param method Comparison method, see #HistCompMethods"},
    {"completeSymm", CV_PY_FN_WITH_KW_(pyopencv_cv_completeSymm, 0), "completeSymm(m[, lowerToUpper]) -> m\n.   @brief Copies the lower or the upper half of a square matrix to its another half.\n.   \n.   The function cv::completeSymm copies the lower or the upper half of a square matrix to\n.   its another half. The matrix diagonal remains unchanged:\n.    - \\f$\\texttt{m}_{ij}=\\texttt{m}_{ji}\\f$ for \\f$i > j\\f$ if\n.       lowerToUpper=false\n.    - \\f$\\texttt{m}_{ij}=\\texttt{m}_{ji}\\f$ for \\f$i < j\\f$ if\n.       lowerToUpper=true\n.   \n.   @param m input-output floating-point square matrix.\n.   @param lowerToUpper operation flag; if true, the lower half is copied to\n.   the upper half. Otherwise, the upper half is copied to the lower half.\n.   @sa flip, transpose"},
    {"composeRT", CV_PY_FN_WITH_KW_(pyopencv_cv_composeRT, 0), "composeRT(rvec1, tvec1, rvec2, tvec2[, rvec3[, tvec3[, dr3dr1[, dr3dt1[, dr3dr2[, dr3dt2[, dt3dr1[, dt3dt1[, dt3dr2[, dt3dt2]]]]]]]]]]) -> rvec3, tvec3, dr3dr1, dr3dt1, dr3dr2, dr3dt2, dt3dr1, dt3dt1, dt3dr2, dt3dt2\n.   @brief Combines two rotation-and-shift transformations.\n.   \n.   @param rvec1 First rotation vector.\n.   @param tvec1 First translation vector.\n.   @param rvec2 Second rotation vector.\n.   @param tvec2 Second translation vector.\n.   @param rvec3 Output rotation vector of the superposition.\n.   @param tvec3 Output translation vector of the superposition.\n.   @param dr3dr1 Optional output derivative of rvec3 with regard to rvec1\n.   @param dr3dt1 Optional output derivative of rvec3 with regard to tvec1\n.   @param dr3dr2 Optional output derivative of rvec3 with regard to rvec2\n.   @param dr3dt2 Optional output derivative of rvec3 with regard to tvec2\n.   @param dt3dr1 Optional output derivative of tvec3 with regard to rvec1\n.   @param dt3dt1 Optional output derivative of tvec3 with regard to tvec1\n.   @param dt3dr2 Optional output derivative of tvec3 with regard to rvec2\n.   @param dt3dt2 Optional output derivative of tvec3 with regard to tvec2\n.   \n.   The functions compute:\n.   \n.   \\f[\\begin{array}{l} \\texttt{rvec3} =  \\mathrm{rodrigues} ^{-1} \\left ( \\mathrm{rodrigues} ( \\texttt{rvec2} )  \\cdot \\mathrm{rodrigues} ( \\texttt{rvec1} ) \\right )  \\\\ \\texttt{tvec3} =  \\mathrm{rodrigues} ( \\texttt{rvec2} )  \\cdot \\texttt{tvec1} +  \\texttt{tvec2} \\end{array} ,\\f]\n.   \n.   where \\f$\\mathrm{rodrigues}\\f$ denotes a rotation vector to a rotation matrix transformation, and\n.   \\f$\\mathrm{rodrigues}^{-1}\\f$ denotes the inverse transformation. See #Rodrigues for details.\n.   \n.   Also, the functions can compute the derivatives of the output vectors with regards to the input\n.   vectors (see #matMulDeriv ). The functions are used inside #stereoCalibrate but can also be used in\n.   your own code where Levenberg-Marquardt or another gradient-based solver is used to optimize a\n.   function that contains a matrix multiplication."},
    {"computeCorrespondEpilines", CV_PY_FN_WITH_KW_(pyopencv_cv_computeCorrespondEpilines, 0), "computeCorrespondEpilines(points, whichImage, F[, lines]) -> lines\n.   @brief For points in an image of a stereo pair, computes the corresponding epilines in the other image.\n.   \n.   @param points Input points. \\f$N \\times 1\\f$ or \\f$1 \\times N\\f$ matrix of type CV_32FC2 or\n.   vector\\<Point2f\\> .\n.   @param whichImage Index of the image (1 or 2) that contains the points .\n.   @param F Fundamental matrix that can be estimated using #findFundamentalMat or #stereoRectify .\n.   @param lines Output vector of the epipolar lines corresponding to the points in the other image.\n.   Each line \\f$ax + by + c=0\\f$ is encoded by 3 numbers \\f$(a, b, c)\\f$ .\n.   \n.   For every point in one of the two images of a stereo pair, the function finds the equation of the\n.   corresponding epipolar line in the other image.\n.   \n.   From the fundamental matrix definition (see #findFundamentalMat ), line \\f$l^{(2)}_i\\f$ in the second\n.   image for the point \\f$p^{(1)}_i\\f$ in the first image (when whichImage=1 ) is computed as:\n.   \n.   \\f[l^{(2)}_i = F p^{(1)}_i\\f]\n.   \n.   And vice versa, when whichImage=2, \\f$l^{(1)}_i\\f$ is computed from \\f$p^{(2)}_i\\f$ as:\n.   \n.   \\f[l^{(1)}_i = F^T p^{(2)}_i\\f]\n.   \n.   Line coefficients are defined up to a scale. They are normalized so that \\f$a_i^2+b_i^2=1\\f$ ."},
    {"computeECC", CV_PY_FN_WITH_KW_(pyopencv_cv_computeECC, 0), "computeECC(templateImage, inputImage[, inputMask]) -> retval\n.   @brief Computes the Enhanced Correlation Coefficient value between two images @cite EP08 .\n.   \n.   @param templateImage single-channel template image; CV_8U or CV_32F array.\n.   @param inputImage single-channel input image to be warped to provide an image similar to\n.    templateImage, same type as templateImage.\n.   @param inputMask An optional mask to indicate valid values of inputImage.\n.   \n.   @sa\n.   findTransformECC"},
    {"connectedComponents", CV_PY_FN_WITH_KW_(pyopencv_cv_connectedComponents, 0), "connectedComponents(image[, labels[, connectivity[, ltype]]]) -> retval, labels\n.   @overload\n.   \n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported."},
    {"connectedComponentsWithAlgorithm", CV_PY_FN_WITH_KW_(pyopencv_cv_connectedComponentsWithAlgorithm, 0), "connectedComponentsWithAlgorithm(image, connectivity, ltype, ccltype[, labels]) -> retval, labels\n.   @brief computes the connected components labeled image of boolean image\n.   \n.   image with 4 or 8 way connectivity - returns N, the total number of labels [0, N-1] where 0\n.   represents the background label. ltype specifies the output label image type, an important\n.   consideration based on the total number of labels or alternatively the total number of pixels in\n.   the source image. ccltype specifies the connected components labeling algorithm to use, currently\n.   Bolelli (Spaghetti) @cite Bolelli2019, Grana (BBDT) @cite Grana2010 and Wu's (SAUF) @cite Wu2009 algorithms\n.   are supported, see the #ConnectedComponentsAlgorithmsTypes for details. Note that SAUF algorithm forces\n.   a row major ordering of labels while Spaghetti and BBDT do not.\n.   This function uses parallel version of the algorithms if at least one allowed\n.   parallel framework is enabled and if the rows of the image are at least twice the number returned by #getNumberOfCPUs.\n.   \n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported.\n.   @param ccltype connected components algorithm type (see the #ConnectedComponentsAlgorithmsTypes)."},
    {"connectedComponentsWithStats", CV_PY_FN_WITH_KW_(pyopencv_cv_connectedComponentsWithStats, 0), "connectedComponentsWithStats(image[, labels[, stats[, centroids[, connectivity[, ltype]]]]]) -> retval, labels, stats, centroids\n.   @overload\n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param stats statistics output for each label, including the background label.\n.   Statistics are accessed via stats(label, COLUMN) where COLUMN is one of\n.   #ConnectedComponentsTypes, selecting the statistic. The data type is CV_32S.\n.   @param centroids centroid output for each label, including the background label. Centroids are\n.   accessed via centroids(label, 0) for x and centroids(label, 1) for y. The data type CV_64F.\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported."},
    {"connectedComponentsWithStatsWithAlgorithm", CV_PY_FN_WITH_KW_(pyopencv_cv_connectedComponentsWithStatsWithAlgorithm, 0), "connectedComponentsWithStatsWithAlgorithm(image, connectivity, ltype, ccltype[, labels[, stats[, centroids]]]) -> retval, labels, stats, centroids\n.   @brief computes the connected components labeled image of boolean image and also produces a statistics output for each label\n.   \n.   image with 4 or 8 way connectivity - returns N, the total number of labels [0, N-1] where 0\n.   represents the background label. ltype specifies the output label image type, an important\n.   consideration based on the total number of labels or alternatively the total number of pixels in\n.   the source image. ccltype specifies the connected components labeling algorithm to use, currently\n.   Bolelli (Spaghetti) @cite Bolelli2019, Grana (BBDT) @cite Grana2010 and Wu's (SAUF) @cite Wu2009 algorithms\n.   are supported, see the #ConnectedComponentsAlgorithmsTypes for details. Note that SAUF algorithm forces\n.   a row major ordering of labels while Spaghetti and BBDT do not.\n.   This function uses parallel version of the algorithms (statistics included) if at least one allowed\n.   parallel framework is enabled and if the rows of the image are at least twice the number returned by #getNumberOfCPUs.\n.   \n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param stats statistics output for each label, including the background label.\n.   Statistics are accessed via stats(label, COLUMN) where COLUMN is one of\n.   #ConnectedComponentsTypes, selecting the statistic. The data type is CV_32S.\n.   @param centroids centroid output for each label, including the background label. Centroids are\n.   accessed via centroids(label, 0) for x and centroids(label, 1) for y. The data type CV_64F.\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported.\n.   @param ccltype connected components algorithm type (see #ConnectedComponentsAlgorithmsTypes)."},
    {"contourArea", CV_PY_FN_WITH_KW_(pyopencv_cv_contourArea, 0), "contourArea(contour[, oriented]) -> retval\n.   @brief Calculates a contour area.\n.   \n.   The function computes a contour area. Similarly to moments , the area is computed using the Green\n.   formula. Thus, the returned area and the number of non-zero pixels, if you draw the contour using\n.   #drawContours or #fillPoly , can be different. Also, the function will most certainly give a wrong\n.   results for contours with self-intersections.\n.   \n.   Example:\n.   @code\n.       vector<Point> contour;\n.       contour.push_back(Point2f(0, 0));\n.       contour.push_back(Point2f(10, 0));\n.       contour.push_back(Point2f(10, 10));\n.       contour.push_back(Point2f(5, 4));\n.   \n.       double area0 = contourArea(contour);\n.       vector<Point> approx;\n.       approxPolyDP(contour, approx, 5, true);\n.       double area1 = contourArea(approx);\n.   \n.       cout << \"area0 =\" << area0 << endl <<\n.               \"area1 =\" << area1 << endl <<\n.               \"approx poly vertices\" << approx.size() << endl;\n.   @endcode\n.   @param contour Input vector of 2D points (contour vertices), stored in std::vector or Mat.\n.   @param oriented Oriented area flag. If it is true, the function returns a signed area value,\n.   depending on the contour orientation (clockwise or counter-clockwise). Using this feature you can\n.   determine orientation of a contour by taking the sign of an area. By default, the parameter is\n.   false, which means that the absolute value is returned."},
    {"convertFp16", CV_PY_FN_WITH_KW_(pyopencv_cv_convertFp16, 0), "convertFp16(src[, dst]) -> dst\n.   @brief Converts an array to half precision floating number.\n.   \n.   This function converts FP32 (single precision floating point) from/to FP16 (half precision floating point). CV_16S format is used to represent FP16 data.\n.   There are two use modes (src -> dst): CV_32F -> CV_16S and CV_16S -> CV_32F. The input array has to have type of CV_32F or\n.   CV_16S to represent the bit depth. If the input array is neither of them, the function will raise an error.\n.   The format of half precision floating point is defined in IEEE 754-2008.\n.   \n.   @param src input array.\n.   @param dst output array.\n.   \n.   @deprecated Use Mat::convertTo with CV_16F instead."},
    {"convertMaps", CV_PY_FN_WITH_KW_(pyopencv_cv_convertMaps, 0), "convertMaps(map1, map2, dstmap1type[, dstmap1[, dstmap2[, nninterpolation]]]) -> dstmap1, dstmap2\n.   @brief Converts image transformation maps from one representation to another.\n.   \n.   The function converts a pair of maps for remap from one representation to another. The following\n.   options ( (map1.type(), map2.type()) \\f$\\rightarrow\\f$ (dstmap1.type(), dstmap2.type()) ) are\n.   supported:\n.   \n.   - \\f$\\texttt{(CV_32FC1, CV_32FC1)} \\rightarrow \\texttt{(CV_16SC2, CV_16UC1)}\\f$. This is the\n.   most frequently used conversion operation, in which the original floating-point maps (see #remap)\n.   are converted to a more compact and much faster fixed-point representation. The first output array\n.   contains the rounded coordinates and the second array (created only when nninterpolation=false )\n.   contains indices in the interpolation tables.\n.   \n.   - \\f$\\texttt{(CV_32FC2)} \\rightarrow \\texttt{(CV_16SC2, CV_16UC1)}\\f$. The same as above but\n.   the original maps are stored in one 2-channel matrix.\n.   \n.   - Reverse conversion. Obviously, the reconstructed floating-point maps will not be exactly the same\n.   as the originals.\n.   \n.   @param map1 The first input map of type CV_16SC2, CV_32FC1, or CV_32FC2 .\n.   @param map2 The second input map of type CV_16UC1, CV_32FC1, or none (empty matrix),\n.   respectively.\n.   @param dstmap1 The first output map that has the type dstmap1type and the same size as src .\n.   @param dstmap2 The second output map.\n.   @param dstmap1type Type of the first output map that should be CV_16SC2, CV_32FC1, or\n.   CV_32FC2 .\n.   @param nninterpolation Flag indicating whether the fixed-point maps are used for the\n.   nearest-neighbor or for a more complex interpolation.\n.   \n.   @sa  remap, undistort, initUndistortRectifyMap"},
    {"convertPointsFromHomogeneous", CV_PY_FN_WITH_KW_(pyopencv_cv_convertPointsFromHomogeneous, 0), "convertPointsFromHomogeneous(src[, dst]) -> dst\n.   @brief Converts points from homogeneous to Euclidean space.\n.   \n.   @param src Input vector of N-dimensional points.\n.   @param dst Output vector of N-1-dimensional points.\n.   \n.   The function converts points homogeneous to Euclidean space using perspective projection. That is,\n.   each point (x1, x2, ... x(n-1), xn) is converted to (x1/xn, x2/xn, ..., x(n-1)/xn). When xn=0, the\n.   output point coordinates will be (0,0,0,...)."},
    {"convertPointsToHomogeneous", CV_PY_FN_WITH_KW_(pyopencv_cv_convertPointsToHomogeneous, 0), "convertPointsToHomogeneous(src[, dst]) -> dst\n.   @brief Converts points from Euclidean to homogeneous space.\n.   \n.   @param src Input vector of N-dimensional points.\n.   @param dst Output vector of N+1-dimensional points.\n.   \n.   The function converts points from Euclidean to homogeneous space by appending 1's to the tuple of\n.   point coordinates. That is, each point (x1, x2, ..., xn) is converted to (x1, x2, ..., xn, 1)."},
    {"convertScaleAbs", CV_PY_FN_WITH_KW_(pyopencv_cv_convertScaleAbs, 0), "convertScaleAbs(src[, dst[, alpha[, beta]]]) -> dst\n.   @brief Scales, calculates absolute values, and converts the result to 8-bit.\n.   \n.   On each element of the input array, the function convertScaleAbs\n.   performs three operations sequentially: scaling, taking an absolute\n.   value, conversion to an unsigned 8-bit type:\n.   \\f[\\texttt{dst} (I)= \\texttt{saturate\\_cast<uchar>} (| \\texttt{src} (I)* \\texttt{alpha} +  \\texttt{beta} |)\\f]\n.   In case of multi-channel arrays, the function processes each channel\n.   independently. When the output is not 8-bit, the operation can be\n.   emulated by calling the Mat::convertTo method (or by using matrix\n.   expressions) and then by calculating an absolute value of the result.\n.   For example:\n.   @code{.cpp}\n.       Mat_<float> A(30,30);\n.       randu(A, Scalar(-100), Scalar(100));\n.       Mat_<float> B = A*5 + 3;\n.       B = abs(B);\n.       // Mat_<float> B = abs(A*5+3) will also do the job,\n.       // but it will allocate a temporary matrix\n.   @endcode\n.   @param src input array.\n.   @param dst output array.\n.   @param alpha optional scale factor.\n.   @param beta optional delta added to the scaled values.\n.   @sa  Mat::convertTo, cv::abs(const Mat&)"},
    {"convexHull", CV_PY_FN_WITH_KW_(pyopencv_cv_convexHull, 0), "convexHull(points[, hull[, clockwise[, returnPoints]]]) -> hull\n.   @brief Finds the convex hull of a point set.\n.   \n.   The function cv::convexHull finds the convex hull of a 2D point set using the Sklansky's algorithm @cite Sklansky82\n.   that has *O(N logN)* complexity in the current implementation.\n.   \n.   @param points Input 2D point set, stored in std::vector or Mat.\n.   @param hull Output convex hull. It is either an integer vector of indices or vector of points. In\n.   the first case, the hull elements are 0-based indices of the convex hull points in the original\n.   array (since the set of convex hull points is a subset of the original point set). In the second\n.   case, hull elements are the convex hull points themselves.\n.   @param clockwise Orientation flag. If it is true, the output convex hull is oriented clockwise.\n.   Otherwise, it is oriented counter-clockwise. The assumed coordinate system has its X axis pointing\n.   to the right, and its Y axis pointing upwards.\n.   @param returnPoints Operation flag. In case of a matrix, when the flag is true, the function\n.   returns convex hull points. Otherwise, it returns indices of the convex hull points. When the\n.   output array is std::vector, the flag is ignored, and the output depends on the type of the\n.   vector: std::vector\\<int\\> implies returnPoints=false, std::vector\\<Point\\> implies\n.   returnPoints=true.\n.   \n.   @note `points` and `hull` should be different arrays, inplace processing isn't supported.\n.   \n.   Check @ref tutorial_hull \"the corresponding tutorial\" for more details.\n.   \n.   useful links:\n.   \n.   https://www.learnopencv.com/convex-hull-using-opencv-in-python-and-c/"},
    {"convexityDefects", CV_PY_FN_WITH_KW_(pyopencv_cv_convexityDefects, 0), "convexityDefects(contour, convexhull[, convexityDefects]) -> convexityDefects\n.   @brief Finds the convexity defects of a contour.\n.   \n.   The figure below displays convexity defects of a hand contour:\n.   \n.   ![image](pics/defects.png)\n.   \n.   @param contour Input contour.\n.   @param convexhull Convex hull obtained using convexHull that should contain indices of the contour\n.   points that make the hull.\n.   @param convexityDefects The output vector of convexity defects. In C++ and the new Python/Java\n.   interface each convexity defect is represented as 4-element integer vector (a.k.a. #Vec4i):\n.   (start_index, end_index, farthest_pt_index, fixpt_depth), where indices are 0-based indices\n.   in the original contour of the convexity defect beginning, end and the farthest point, and\n.   fixpt_depth is fixed-point approximation (with 8 fractional bits) of the distance between the\n.   farthest contour point and the hull. That is, to get the floating-point value of the depth will be\n.   fixpt_depth/256.0."},
    {"copyMakeBorder", CV_PY_FN_WITH_KW_(pyopencv_cv_copyMakeBorder, 0), "copyMakeBorder(src, top, bottom, left, right, borderType[, dst[, value]]) -> dst\n.   @brief Forms a border around an image.\n.   \n.   The function copies the source image into the middle of the destination image. The areas to the\n.   left, to the right, above and below the copied source image will be filled with extrapolated\n.   pixels. This is not what filtering functions based on it do (they extrapolate pixels on-fly), but\n.   what other more complex functions, including your own, may do to simplify image boundary handling.\n.   \n.   The function supports the mode when src is already in the middle of dst . In this case, the\n.   function does not copy src itself but simply constructs the border, for example:\n.   \n.   @code{.cpp}\n.       // let border be the same in all directions\n.       int border=2;\n.       // constructs a larger image to fit both the image and the border\n.       Mat gray_buf(rgb.rows + border*2, rgb.cols + border*2, rgb.depth());\n.       // select the middle part of it w/o copying data\n.       Mat gray(gray_canvas, Rect(border, border, rgb.cols, rgb.rows));\n.       // convert image from RGB to grayscale\n.       cvtColor(rgb, gray, COLOR_RGB2GRAY);\n.       // form a border in-place\n.       copyMakeBorder(gray, gray_buf, border, border,\n.                      border, border, BORDER_REPLICATE);\n.       // now do some custom filtering ...\n.       ...\n.   @endcode\n.   @note When the source image is a part (ROI) of a bigger image, the function will try to use the\n.   pixels outside of the ROI to form a border. To disable this feature and always do extrapolation, as\n.   if src was not a ROI, use borderType | #BORDER_ISOLATED.\n.   \n.   @param src Source image.\n.   @param dst Destination image of the same type as src and the size Size(src.cols+left+right,\n.   src.rows+top+bottom) .\n.   @param top the top pixels\n.   @param bottom the bottom pixels\n.   @param left the left pixels\n.   @param right Parameter specifying how many pixels in each direction from the source image rectangle\n.   to extrapolate. For example, top=1, bottom=1, left=1, right=1 mean that 1 pixel-wide border needs\n.   to be built.\n.   @param borderType Border type. See borderInterpolate for details.\n.   @param value Border value if borderType==BORDER_CONSTANT .\n.   \n.   @sa  borderInterpolate"},
    {"copyTo", CV_PY_FN_WITH_KW_(pyopencv_cv_copyTo, 0), "copyTo(src, mask[, dst]) -> dst\n.   @brief  This is an overloaded member function, provided for convenience (python)\n.   Copies the matrix to another one.\n.   When the operation mask is specified, if the Mat::create call shown above reallocates the matrix, the newly allocated matrix is initialized with all zeros before copying the data.\n.   @param src source matrix.\n.   @param dst Destination matrix. If it does not have a proper size or type before the operation, it is\n.   reallocated.\n.   @param mask Operation mask of the same size as \\*this. Its non-zero elements indicate which matrix\n.   elements need to be copied. The mask has to be of type CV_8U and can have 1 or multiple channels."},
    {"cornerEigenValsAndVecs", CV_PY_FN_WITH_KW_(pyopencv_cv_cornerEigenValsAndVecs, 0), "cornerEigenValsAndVecs(src, blockSize, ksize[, dst[, borderType]]) -> dst\n.   @brief Calculates eigenvalues and eigenvectors of image blocks for corner detection.\n.   \n.   For every pixel \\f$p\\f$ , the function cornerEigenValsAndVecs considers a blockSize \\f$\\times\\f$ blockSize\n.   neighborhood \\f$S(p)\\f$ . It calculates the covariation matrix of derivatives over the neighborhood as:\n.   \n.   \\f[M =  \\begin{bmatrix} \\sum _{S(p)}(dI/dx)^2 &  \\sum _{S(p)}dI/dx dI/dy  \\\\ \\sum _{S(p)}dI/dx dI/dy &  \\sum _{S(p)}(dI/dy)^2 \\end{bmatrix}\\f]\n.   \n.   where the derivatives are computed using the Sobel operator.\n.   \n.   After that, it finds eigenvectors and eigenvalues of \\f$M\\f$ and stores them in the destination image as\n.   \\f$(\\lambda_1, \\lambda_2, x_1, y_1, x_2, y_2)\\f$ where\n.   \n.   -   \\f$\\lambda_1, \\lambda_2\\f$ are the non-sorted eigenvalues of \\f$M\\f$\n.   -   \\f$x_1, y_1\\f$ are the eigenvectors corresponding to \\f$\\lambda_1\\f$\n.   -   \\f$x_2, y_2\\f$ are the eigenvectors corresponding to \\f$\\lambda_2\\f$\n.   \n.   The output of the function can be used for robust edge or corner detection.\n.   \n.   @param src Input single-channel 8-bit or floating-point image.\n.   @param dst Image to store the results. It has the same size as src and the type CV_32FC(6) .\n.   @param blockSize Neighborhood size (see details below).\n.   @param ksize Aperture parameter for the Sobel operator.\n.   @param borderType Pixel extrapolation method. See #BorderTypes. #BORDER_WRAP is not supported.\n.   \n.   @sa  cornerMinEigenVal, cornerHarris, preCornerDetect"},
    {"cornerHarris", CV_PY_FN_WITH_KW_(pyopencv_cv_cornerHarris, 0), "cornerHarris(src, blockSize, ksize, k[, dst[, borderType]]) -> dst\n.   @brief Harris corner detector.\n.   \n.   The function runs the Harris corner detector on the image. Similarly to cornerMinEigenVal and\n.   cornerEigenValsAndVecs , for each pixel \\f$(x, y)\\f$ it calculates a \\f$2\\times2\\f$ gradient covariance\n.   matrix \\f$M^{(x,y)}\\f$ over a \\f$\\texttt{blockSize} \\times \\texttt{blockSize}\\f$ neighborhood. Then, it\n.   computes the following characteristic:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\mathrm{det} M^{(x,y)} - k  \\cdot \\left ( \\mathrm{tr} M^{(x,y)} \\right )^2\\f]\n.   \n.   Corners in the image can be found as the local maxima of this response map.\n.   \n.   @param src Input single-channel 8-bit or floating-point image.\n.   @param dst Image to store the Harris detector responses. It has the type CV_32FC1 and the same\n.   size as src .\n.   @param blockSize Neighborhood size (see the details on #cornerEigenValsAndVecs ).\n.   @param ksize Aperture parameter for the Sobel operator.\n.   @param k Harris detector free parameter. See the formula above.\n.   @param borderType Pixel extrapolation method. See #BorderTypes. #BORDER_WRAP is not supported."},
    {"cornerMinEigenVal", CV_PY_FN_WITH_KW_(pyopencv_cv_cornerMinEigenVal, 0), "cornerMinEigenVal(src, blockSize[, dst[, ksize[, borderType]]]) -> dst\n.   @brief Calculates the minimal eigenvalue of gradient matrices for corner detection.\n.   \n.   The function is similar to cornerEigenValsAndVecs but it calculates and stores only the minimal\n.   eigenvalue of the covariance matrix of derivatives, that is, \\f$\\min(\\lambda_1, \\lambda_2)\\f$ in terms\n.   of the formulae in the cornerEigenValsAndVecs description.\n.   \n.   @param src Input single-channel 8-bit or floating-point image.\n.   @param dst Image to store the minimal eigenvalues. It has the type CV_32FC1 and the same size as\n.   src .\n.   @param blockSize Neighborhood size (see the details on #cornerEigenValsAndVecs ).\n.   @param ksize Aperture parameter for the Sobel operator.\n.   @param borderType Pixel extrapolation method. See #BorderTypes. #BORDER_WRAP is not supported."},
    {"cornerSubPix", CV_PY_FN_WITH_KW_(pyopencv_cv_cornerSubPix, 0), "cornerSubPix(image, corners, winSize, zeroZone, criteria) -> corners\n.   @brief Refines the corner locations.\n.   \n.   The function iterates to find the sub-pixel accurate location of corners or radial saddle\n.   points as described in @cite forstner1987fast, and as shown on the figure below.\n.   \n.   ![image](pics/cornersubpix.png)\n.   \n.   Sub-pixel accurate corner locator is based on the observation that every vector from the center \\f$q\\f$\n.   to a point \\f$p\\f$ located within a neighborhood of \\f$q\\f$ is orthogonal to the image gradient at \\f$p\\f$\n.   subject to image and measurement noise. Consider the expression:\n.   \n.   \\f[\\epsilon _i = {DI_{p_i}}^T  \\cdot (q - p_i)\\f]\n.   \n.   where \\f${DI_{p_i}}\\f$ is an image gradient at one of the points \\f$p_i\\f$ in a neighborhood of \\f$q\\f$ . The\n.   value of \\f$q\\f$ is to be found so that \\f$\\epsilon_i\\f$ is minimized. A system of equations may be set up\n.   with \\f$\\epsilon_i\\f$ set to zero:\n.   \n.   \\f[\\sum _i(DI_{p_i}  \\cdot {DI_{p_i}}^T) \\cdot q -  \\sum _i(DI_{p_i}  \\cdot {DI_{p_i}}^T  \\cdot p_i)\\f]\n.   \n.   where the gradients are summed within a neighborhood (\"search window\") of \\f$q\\f$ . Calling the first\n.   gradient term \\f$G\\f$ and the second gradient term \\f$b\\f$ gives:\n.   \n.   \\f[q = G^{-1}  \\cdot b\\f]\n.   \n.   The algorithm sets the center of the neighborhood window at this new center \\f$q\\f$ and then iterates\n.   until the center stays within a set threshold.\n.   \n.   @param image Input single-channel, 8-bit or float image.\n.   @param corners Initial coordinates of the input corners and refined coordinates provided for\n.   output.\n.   @param winSize Half of the side length of the search window. For example, if winSize=Size(5,5) ,\n.   then a \\f$(5*2+1) \\times (5*2+1) = 11 \\times 11\\f$ search window is used.\n.   @param zeroZone Half of the size of the dead region in the middle of the search zone over which\n.   the summation in the formula below is not done. It is used sometimes to avoid possible\n.   singularities of the autocorrelation matrix. The value of (-1,-1) indicates that there is no such\n.   a size.\n.   @param criteria Criteria for termination of the iterative process of corner refinement. That is,\n.   the process of corner position refinement stops either after criteria.maxCount iterations or when\n.   the corner position moves by less than criteria.epsilon on some iteration."},
    {"correctMatches", CV_PY_FN_WITH_KW_(pyopencv_cv_correctMatches, 0), "correctMatches(F, points1, points2[, newPoints1[, newPoints2]]) -> newPoints1, newPoints2\n.   @brief Refines coordinates of corresponding points.\n.   \n.   @param F 3x3 fundamental matrix.\n.   @param points1 1xN array containing the first set of points.\n.   @param points2 1xN array containing the second set of points.\n.   @param newPoints1 The optimized points1.\n.   @param newPoints2 The optimized points2.\n.   \n.   The function implements the Optimal Triangulation Method (see Multiple View Geometry @cite HartleyZ00 for details).\n.   For each given point correspondence points1[i] \\<-\\> points2[i], and a fundamental matrix F, it\n.   computes the corrected correspondences newPoints1[i] \\<-\\> newPoints2[i] that minimize the geometric\n.   error \\f$d(points1[i], newPoints1[i])^2 + d(points2[i],newPoints2[i])^2\\f$ (where \\f$d(a,b)\\f$ is the\n.   geometric distance between points \\f$a\\f$ and \\f$b\\f$ ) subject to the epipolar constraint\n.   \\f$newPoints2^T \\cdot F \\cdot newPoints1 = 0\\f$ ."},
    {"countNonZero", CV_PY_FN_WITH_KW_(pyopencv_cv_countNonZero, 0), "countNonZero(src) -> retval\n.   @brief Counts non-zero array elements.\n.   \n.   The function returns the number of non-zero elements in src :\n.   \\f[\\sum _{I: \\; \\texttt{src} (I) \\ne0 } 1\\f]\n.   \n.   The function do not work with multi-channel arrays. If you need to count non-zero array\n.   elements across all the channels, use Mat::reshape first to reinterpret the array as\n.   single-channel. Or you may extract the particular channel using either extractImageCOI, or\n.   mixChannels, or split.\n.   \n.   @note\n.   - If only whether there are non-zero elements is important, @ref hasNonZero is helpful.\n.   - If the location of non-zero array elements is important, @ref findNonZero is helpful.\n.   @param src single-channel array.\n.   @sa  mean, meanStdDev, norm, minMaxLoc, calcCovarMatrix\n.   @sa  findNonZero, hasNonZero"},
    {"createAffineTransformer", CV_PY_FN_WITH_KW_(pyopencv_cv_createAffineTransformer, 0), "createAffineTransformer(fullAffine) -> retval\n.   Complete constructor"},
    {"createAlignMTB", CV_PY_FN_WITH_KW_(pyopencv_cv_createAlignMTB, 0), "createAlignMTB([, max_bits[, exclude_range[, cut]]]) -> retval\n.   @brief Creates AlignMTB object\n.   \n.   @param max_bits logarithm to the base 2 of maximal shift in each dimension. Values of 5 and 6 are\n.   usually good enough (31 and 63 pixels shift respectively).\n.   @param exclude_range range for exclusion bitmap that is constructed to suppress noise around the\n.   median value.\n.   @param cut if true cuts images, otherwise fills the new regions with zeros."},
    {"createBackgroundSubtractorKNN", CV_PY_FN_WITH_KW_(pyopencv_cv_createBackgroundSubtractorKNN, 0), "createBackgroundSubtractorKNN([, history[, dist2Threshold[, detectShadows]]]) -> retval\n.   @brief Creates KNN Background Subtractor\n.   \n.   @param history Length of the history.\n.   @param dist2Threshold Threshold on the squared distance between the pixel and the sample to decide\n.   whether a pixel is close to that sample. This parameter does not affect the background update.\n.   @param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the\n.   speed a bit, so if you do not need this feature, set the parameter to false."},
    {"createBackgroundSubtractorMOG2", CV_PY_FN_WITH_KW_(pyopencv_cv_createBackgroundSubtractorMOG2, 0), "createBackgroundSubtractorMOG2([, history[, varThreshold[, detectShadows]]]) -> retval\n.   @brief Creates MOG2 Background Subtractor\n.   \n.   @param history Length of the history.\n.   @param varThreshold Threshold on the squared Mahalanobis distance between the pixel and the model\n.   to decide whether a pixel is well described by the background model. This parameter does not\n.   affect the background update.\n.   @param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the\n.   speed a bit, so if you do not need this feature, set the parameter to false."},
    {"createCLAHE", CV_PY_FN_WITH_KW_(pyopencv_cv_createCLAHE, 0), "createCLAHE([, clipLimit[, tileGridSize]]) -> retval\n.   @brief Creates a smart pointer to a cv::CLAHE class and initializes it.\n.   \n.   @param clipLimit Threshold for contrast limiting.\n.   @param tileGridSize Size of grid for histogram equalization. Input image will be divided into\n.   equally sized rectangular tiles. tileGridSize defines the number of tiles in row and column."},
    {"createCalibrateDebevec", CV_PY_FN_WITH_KW_(pyopencv_cv_createCalibrateDebevec, 0), "createCalibrateDebevec([, samples[, lambda_[, random]]]) -> retval\n.   @brief Creates CalibrateDebevec object\n.   \n.   @param samples number of pixel locations to use\n.   @param lambda smoothness term weight. Greater values produce smoother results, but can alter the\n.   response.\n.   @param random if true sample pixel locations are chosen at random, otherwise they form a\n.   rectangular grid."},
    {"createCalibrateRobertson", CV_PY_FN_WITH_KW_(pyopencv_cv_createCalibrateRobertson, 0), "createCalibrateRobertson([, max_iter[, threshold]]) -> retval\n.   @brief Creates CalibrateRobertson object\n.   \n.   @param max_iter maximal number of Gauss-Seidel solver iterations.\n.   @param threshold target difference between results of two successive steps of the minimization."},
    {"createChiHistogramCostExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_createChiHistogramCostExtractor, 0), "createChiHistogramCostExtractor([, nDummies[, defaultCost]]) -> retval\n."},
    {"createEMDHistogramCostExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_createEMDHistogramCostExtractor, 0), "createEMDHistogramCostExtractor([, flag[, nDummies[, defaultCost]]]) -> retval\n."},
    {"createEMDL1HistogramCostExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_createEMDL1HistogramCostExtractor, 0), "createEMDL1HistogramCostExtractor([, nDummies[, defaultCost]]) -> retval\n."},
    {"createGeneralizedHoughBallard", CV_PY_FN_WITH_KW_(pyopencv_cv_createGeneralizedHoughBallard, 0), "createGeneralizedHoughBallard() -> retval\n.   @brief Creates a smart pointer to a cv::GeneralizedHoughBallard class and initializes it."},
    {"createGeneralizedHoughGuil", CV_PY_FN_WITH_KW_(pyopencv_cv_createGeneralizedHoughGuil, 0), "createGeneralizedHoughGuil() -> retval\n.   @brief Creates a smart pointer to a cv::GeneralizedHoughGuil class and initializes it."},
    {"createHanningWindow", CV_PY_FN_WITH_KW_(pyopencv_cv_createHanningWindow, 0), "createHanningWindow(winSize, type[, dst]) -> dst\n.   @brief This function computes a Hanning window coefficients in two dimensions.\n.   \n.   See (https://en.wikipedia.org/wiki/Hann_function) and (https://en.wikipedia.org/wiki/Window_function)\n.   for more information.\n.   \n.   An example is shown below:\n.   @code\n.       // create hanning window of size 100x100 and type CV_32F\n.       Mat hann;\n.       createHanningWindow(hann, Size(100, 100), CV_32F);\n.   @endcode\n.   @param dst Destination array to place Hann coefficients in\n.   @param winSize The window size specifications (both width and height must be > 1)\n.   @param type Created array type"},
    {"createHausdorffDistanceExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_createHausdorffDistanceExtractor, 0), "createHausdorffDistanceExtractor([, distanceFlag[, rankProp]]) -> retval\n."},
    {"createLineSegmentDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_createLineSegmentDetector, 0), "createLineSegmentDetector([, refine[, scale[, sigma_scale[, quant[, ang_th[, log_eps[, density_th[, n_bins]]]]]]]]) -> retval\n.   @brief Creates a smart pointer to a LineSegmentDetector object and initializes it.\n.   \n.   The LineSegmentDetector algorithm is defined using the standard values. Only advanced users may want\n.   to edit those, as to tailor it for their own application.\n.   \n.   @param refine The way found lines will be refined, see #LineSegmentDetectorModes\n.   @param scale The scale of the image that will be used to find the lines. Range (0..1].\n.   @param sigma_scale Sigma for Gaussian filter. It is computed as sigma = sigma_scale/scale.\n.   @param quant Bound to the quantization error on the gradient norm.\n.   @param ang_th Gradient angle tolerance in degrees.\n.   @param log_eps Detection threshold: -log10(NFA) \\> log_eps. Used only when advance refinement is chosen.\n.   @param density_th Minimal density of aligned region points in the enclosing rectangle.\n.   @param n_bins Number of bins in pseudo-ordering of gradient modulus."},
    {"createMergeDebevec", CV_PY_FN_WITH_KW_(pyopencv_cv_createMergeDebevec, 0), "createMergeDebevec() -> retval\n.   @brief Creates MergeDebevec object"},
    {"createMergeMertens", CV_PY_FN_WITH_KW_(pyopencv_cv_createMergeMertens, 0), "createMergeMertens([, contrast_weight[, saturation_weight[, exposure_weight]]]) -> retval\n.   @brief Creates MergeMertens object\n.   \n.   @param contrast_weight contrast measure weight. See MergeMertens.\n.   @param saturation_weight saturation measure weight\n.   @param exposure_weight well-exposedness measure weight"},
    {"createMergeRobertson", CV_PY_FN_WITH_KW_(pyopencv_cv_createMergeRobertson, 0), "createMergeRobertson() -> retval\n.   @brief Creates MergeRobertson object"},
    {"createNormHistogramCostExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_createNormHistogramCostExtractor, 0), "createNormHistogramCostExtractor([, flag[, nDummies[, defaultCost]]]) -> retval\n."},
    {"createShapeContextDistanceExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_createShapeContextDistanceExtractor, 0), "createShapeContextDistanceExtractor([, nAngularBins[, nRadialBins[, innerRadius[, outerRadius[, iterations[, comparer[, transformer]]]]]]]) -> retval\n."},
    {"createThinPlateSplineShapeTransformer", CV_PY_FN_WITH_KW_(pyopencv_cv_createThinPlateSplineShapeTransformer, 0), "createThinPlateSplineShapeTransformer([, regularizationParameter]) -> retval\n.   Complete constructor"},
    {"createTonemap", CV_PY_FN_WITH_KW_(pyopencv_cv_createTonemap, 0), "createTonemap([, gamma]) -> retval\n.   @brief Creates simple linear mapper with gamma correction\n.   \n.   @param gamma positive value for gamma correction. Gamma value of 1.0 implies no correction, gamma\n.   equal to 2.2f is suitable for most displays.\n.   Generally gamma \\> 1 brightens the image and gamma \\< 1 darkens it."},
    {"createTonemapDrago", CV_PY_FN_WITH_KW_(pyopencv_cv_createTonemapDrago, 0), "createTonemapDrago([, gamma[, saturation[, bias]]]) -> retval\n.   @brief Creates TonemapDrago object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param saturation positive saturation enhancement value. 1.0 preserves saturation, values greater\n.   than 1 increase saturation and values less than 1 decrease it.\n.   @param bias value for bias function in [0, 1] range. Values from 0.7 to 0.9 usually give best\n.   results, default value is 0.85."},
    {"createTonemapMantiuk", CV_PY_FN_WITH_KW_(pyopencv_cv_createTonemapMantiuk, 0), "createTonemapMantiuk([, gamma[, scale[, saturation]]]) -> retval\n.   @brief Creates TonemapMantiuk object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param scale contrast scale factor. HVS response is multiplied by this parameter, thus compressing\n.   dynamic range. Values from 0.6 to 0.9 produce best results.\n.   @param saturation saturation enhancement value. See createTonemapDrago"},
    {"createTonemapReinhard", CV_PY_FN_WITH_KW_(pyopencv_cv_createTonemapReinhard, 0), "createTonemapReinhard([, gamma[, intensity[, light_adapt[, color_adapt]]]]) -> retval\n.   @brief Creates TonemapReinhard object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param intensity result intensity in [-8, 8] range. Greater intensity produces brighter results.\n.   @param light_adapt light adaptation in [0, 1] range. If 1 adaptation is based only on pixel\n.   value, if 0 it's global, otherwise it's a weighted mean of this two cases.\n.   @param color_adapt chromatic adaptation in [0, 1] range. If 1 channels are treated independently,\n.   if 0 adaptation level is the same for each channel."},
    {"cubeRoot", CV_PY_FN_WITH_KW_(pyopencv_cv_cubeRoot, 0), "cubeRoot(val) -> retval\n.   @brief Computes the cube root of an argument.\n.   \n.    The function cubeRoot computes \\f$\\sqrt[3]{\\texttt{val}}\\f$. Negative arguments are handled correctly.\n.    NaN and Inf are not handled. The accuracy approaches the maximum possible accuracy for\n.    single-precision data.\n.    @param val A function argument."},
    {"currentUIFramework", CV_PY_FN_WITH_KW_(pyopencv_cv_currentUIFramework, 0), "currentUIFramework() -> retval\n.   @brief HighGUI backend used.\n.   \n.   The function returns HighGUI backend name used: could be COCOA, GTK2/3, QT, WAYLAND or WIN32.\n.   Returns empty string if there is no available UI backend."},
    {"cvtColor", CV_PY_FN_WITH_KW_(pyopencv_cv_cvtColor, 0), "cvtColor(src, code[, dst[, dstCn[, hint]]]) -> dst\n.   @brief Converts an image from one color space to another.\n.   \n.   The function converts an input image from one color space to another. In case of a transformation\n.   to-from RGB color space, the order of the channels should be specified explicitly (RGB or BGR). Note\n.   that the default color format in OpenCV is often referred to as RGB but it is actually BGR (the\n.   bytes are reversed). So the first byte in a standard (24-bit) color image will be an 8-bit Blue\n.   component, the second byte will be Green, and the third byte will be Red. The fourth, fifth, and\n.   sixth bytes would then be the second pixel (Blue, then Green, then Red), and so on.\n.   \n.   The conventional ranges for R, G, and B channel values are:\n.   -   0 to 255 for CV_8U images\n.   -   0 to 65535 for CV_16U images\n.   -   0 to 1 for CV_32F images\n.   \n.   In case of linear transformations, the range does not matter. But in case of a non-linear\n.   transformation, an input RGB image should be normalized to the proper value range to get the correct\n.   results, for example, for RGB \\f$\\rightarrow\\f$ L\\*u\\*v\\* transformation. For example, if you have a\n.   32-bit floating-point image directly converted from an 8-bit image without any scaling, then it will\n.   have the 0..255 value range instead of 0..1 assumed by the function. So, before calling #cvtColor ,\n.   you need first to scale the image down:\n.   @code\n.       img *= 1./255;\n.       cvtColor(img, img, COLOR_BGR2Luv);\n.   @endcode\n.   If you use #cvtColor with 8-bit images, the conversion will have some information lost. For many\n.   applications, this will not be noticeable but it is recommended to use 32-bit images in applications\n.   that need the full range of colors or that convert an image before an operation and then convert\n.   back.\n.   \n.   If conversion adds the alpha channel, its value will set to the maximum of corresponding channel\n.   range: 255 for CV_8U, 65535 for CV_16U, 1 for CV_32F.\n.   \n.   @param src input image: 8-bit unsigned, 16-bit unsigned ( CV_16UC... ), or single-precision\n.   floating-point.\n.   @param dst output image of the same size and depth as src.\n.   @param code color space conversion code (see #ColorConversionCodes).\n.   @param dstCn number of channels in the destination image; if the parameter is 0, the number of the\n.   channels is derived automatically from src and code.\n.   @param hint Implementation modfication flags. See #AlgorithmHint\n.   \n.   @see @ref imgproc_color_conversions"},
    {"cvtColorTwoPlane", CV_PY_FN_WITH_KW_(pyopencv_cv_cvtColorTwoPlane, 0), "cvtColorTwoPlane(src1, src2, code[, dst[, hint]]) -> dst\n.   @brief Converts an image from one color space to another where the source image is\n.   stored in two planes.\n.   \n.   This function only supports YUV420 to RGB conversion as of now.\n.   \n.   @param src1 8-bit image (#CV_8U) of the Y plane.\n.   @param src2 image containing interleaved U/V plane.\n.   @param dst output image.\n.   @param code Specifies the type of conversion. It can take any of the following values:\n.   - #COLOR_YUV2BGR_NV12\n.   - #COLOR_YUV2RGB_NV12\n.   - #COLOR_YUV2BGRA_NV12\n.   - #COLOR_YUV2RGBA_NV12\n.   - #COLOR_YUV2BGR_NV21\n.   - #COLOR_YUV2RGB_NV21\n.   - #COLOR_YUV2BGRA_NV21\n.   - #COLOR_YUV2RGBA_NV21\n.   @param hint Implementation modfication flags. See #AlgorithmHint"},
    {"dct", CV_PY_FN_WITH_KW_(pyopencv_cv_dct, 0), "dct(src[, dst[, flags]]) -> dst\n.   @brief Performs a forward or inverse discrete Cosine transform of 1D or 2D array.\n.   \n.   The function cv::dct performs a forward or inverse discrete Cosine transform (DCT) of a 1D or 2D\n.   floating-point array:\n.   -   Forward Cosine transform of a 1D vector of N elements:\n.       \\f[Y = C^{(N)}  \\cdot X\\f]\n.       where\n.       \\f[C^{(N)}_{jk}= \\sqrt{\\alpha_j/N} \\cos \\left ( \\frac{\\pi(2k+1)j}{2N} \\right )\\f]\n.       and\n.       \\f$\\alpha_0=1\\f$, \\f$\\alpha_j=2\\f$ for *j \\> 0*.\n.   -   Inverse Cosine transform of a 1D vector of N elements:\n.       \\f[X =  \\left (C^{(N)} \\right )^{-1}  \\cdot Y =  \\left (C^{(N)} \\right )^T  \\cdot Y\\f]\n.       (since \\f$C^{(N)}\\f$ is an orthogonal matrix, \\f$C^{(N)} \\cdot \\left(C^{(N)}\\right)^T = I\\f$ )\n.   -   Forward 2D Cosine transform of M x N matrix:\n.       \\f[Y = C^{(N)}  \\cdot X  \\cdot \\left (C^{(N)} \\right )^T\\f]\n.   -   Inverse 2D Cosine transform of M x N matrix:\n.       \\f[X =  \\left (C^{(N)} \\right )^T  \\cdot X  \\cdot C^{(N)}\\f]\n.   \n.   The function chooses the mode of operation by looking at the flags and size of the input array:\n.   -   If (flags & #DCT_INVERSE) == 0, the function does a forward 1D or 2D transform. Otherwise, it\n.       is an inverse 1D or 2D transform.\n.   -   If (flags & #DCT_ROWS) != 0, the function performs a 1D transform of each row.\n.   -   If the array is a single column or a single row, the function performs a 1D transform.\n.   -   If none of the above is true, the function performs a 2D transform.\n.   \n.   @note Currently dct supports even-size arrays (2, 4, 6 ...). For data analysis and approximation, you\n.   can pad the array when necessary.\n.   Also, the function performance depends very much, and not monotonically, on the array size (see\n.   getOptimalDFTSize ). In the current implementation DCT of a vector of size N is calculated via DFT\n.   of a vector of size N/2 . Thus, the optimal DCT size N1 \\>= N can be calculated as:\n.   @code\n.       size_t getOptimalDCTSize(size_t N) { return 2*getOptimalDFTSize((N+1)/2); }\n.       N1 = getOptimalDCTSize(N);\n.   @endcode\n.   @param src input floating-point array.\n.   @param dst output array of the same size and type as src .\n.   @param flags transformation flags as a combination of cv::DftFlags (DCT_*)\n.   @sa dft, getOptimalDFTSize, idct"},
    {"decolor", CV_PY_FN_WITH_KW_(pyopencv_cv_decolor, 0), "decolor(src[, grayscale[, color_boost]]) -> grayscale, color_boost\n.   @brief Transforms a color image to a grayscale image. It is a basic tool in digital printing, stylized\n.   black-and-white photograph rendering, and in many single channel image processing applications\n.   @cite CL12 .\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param grayscale Output 8-bit 1-channel image.\n.   @param color_boost Output 8-bit 3-channel image.\n.   \n.   This function is to be applied on color images."},
    {"decomposeEssentialMat", CV_PY_FN_WITH_KW_(pyopencv_cv_decomposeEssentialMat, 0), "decomposeEssentialMat(E[, R1[, R2[, t]]]) -> R1, R2, t\n.   @brief Decompose an essential matrix to possible rotations and translation.\n.   \n.   @param E The input essential matrix.\n.   @param R1 One possible rotation matrix.\n.   @param R2 Another possible rotation matrix.\n.   @param t One possible translation.\n.   \n.   This function decomposes the essential matrix E using svd decomposition @cite HartleyZ00. In\n.   general, four possible poses exist for the decomposition of E. They are \\f$[R_1, t]\\f$,\n.   \\f$[R_1, -t]\\f$, \\f$[R_2, t]\\f$, \\f$[R_2, -t]\\f$.\n.   \n.   If E gives the epipolar constraint \\f$[p_2; 1]^T A^{-T} E A^{-1} [p_1; 1] = 0\\f$ between the image\n.   points \\f$p_1\\f$ in the first image and \\f$p_2\\f$ in second image, then any of the tuples\n.   \\f$[R_1, t]\\f$, \\f$[R_1, -t]\\f$, \\f$[R_2, t]\\f$, \\f$[R_2, -t]\\f$ is a change of basis from the first\n.   camera's coordinate system to the second camera's coordinate system. However, by decomposing E, one\n.   can only get the direction of the translation. For this reason, the translation t is returned with\n.   unit length."},
    {"decomposeHomographyMat", CV_PY_FN_WITH_KW_(pyopencv_cv_decomposeHomographyMat, 0), "decomposeHomographyMat(H, K[, rotations[, translations[, normals]]]) -> retval, rotations, translations, normals\n.   @brief Decompose a homography matrix to rotation(s), translation(s) and plane normal(s).\n.   \n.   @param H The input homography matrix between two images.\n.   @param K The input camera intrinsic matrix.\n.   @param rotations Array of rotation matrices.\n.   @param translations Array of translation matrices.\n.   @param normals Array of plane normal matrices.\n.   \n.   This function extracts relative camera motion between two views of a planar object and returns up to\n.   four mathematical solution tuples of rotation, translation, and plane normal. The decomposition of\n.   the homography matrix H is described in detail in @cite Malis2007.\n.   \n.   If the homography H, induced by the plane, gives the constraint\n.   \\f[s_i \\vecthree{x'_i}{y'_i}{1} \\sim H \\vecthree{x_i}{y_i}{1}\\f] on the source image points\n.   \\f$p_i\\f$ and the destination image points \\f$p'_i\\f$, then the tuple of rotations[k] and\n.   translations[k] is a change of basis from the source camera's coordinate system to the destination\n.   camera's coordinate system. However, by decomposing H, one can only get the translation normalized\n.   by the (typically unknown) depth of the scene, i.e. its direction but with normalized length.\n.   \n.   If point correspondences are available, at least two solutions may further be invalidated, by\n.   applying positive depth constraint, i.e. all points must be in front of the camera."},
    {"decomposeProjectionMatrix", CV_PY_FN_WITH_KW_(pyopencv_cv_decomposeProjectionMatrix, 0), "decomposeProjectionMatrix(projMatrix[, cameraMatrix[, rotMatrix[, transVect[, rotMatrixX[, rotMatrixY[, rotMatrixZ[, eulerAngles]]]]]]]) -> cameraMatrix, rotMatrix, transVect, rotMatrixX, rotMatrixY, rotMatrixZ, eulerAngles\n.   @brief Decomposes a projection matrix into a rotation matrix and a camera intrinsic matrix.\n.   \n.   @param projMatrix 3x4 input projection matrix P.\n.   @param cameraMatrix Output 3x3 camera intrinsic matrix \\f$\\cameramatrix{A}\\f$.\n.   @param rotMatrix Output 3x3 external rotation matrix R.\n.   @param transVect Output 4x1 translation vector T.\n.   @param rotMatrixX Optional 3x3 rotation matrix around x-axis.\n.   @param rotMatrixY Optional 3x3 rotation matrix around y-axis.\n.   @param rotMatrixZ Optional 3x3 rotation matrix around z-axis.\n.   @param eulerAngles Optional three-element vector containing three Euler angles of rotation in\n.   degrees.\n.   \n.   The function computes a decomposition of a projection matrix into a calibration and a rotation\n.   matrix and the position of a camera.\n.   \n.   It optionally returns three rotation matrices, one for each axis, and three Euler angles that could\n.   be used in OpenGL. Note, there is always more than one sequence of rotations about the three\n.   principal axes that results in the same orientation of an object, e.g. see @cite Slabaugh . Returned\n.   three rotation matrices and corresponding three Euler angles are only one of the possible solutions.\n.   \n.   The function is based on #RQDecomp3x3 ."},
    {"demosaicing", CV_PY_FN_WITH_KW_(pyopencv_cv_demosaicing, 0), "demosaicing(src, code[, dst[, dstCn]]) -> dst\n.   @brief main function for all demosaicing processes\n.   \n.   @param src input image: 8-bit unsigned or 16-bit unsigned.\n.   @param dst output image of the same size and depth as src.\n.   @param code Color space conversion code (see the description below).\n.   @param dstCn number of channels in the destination image; if the parameter is 0, the number of the\n.   channels is derived automatically from src and code.\n.   \n.   The function can do the following transformations:\n.   \n.   -   Demosaicing using bilinear interpolation\n.   \n.       #COLOR_BayerBG2BGR , #COLOR_BayerGB2BGR , #COLOR_BayerRG2BGR , #COLOR_BayerGR2BGR\n.   \n.       #COLOR_BayerBG2GRAY , #COLOR_BayerGB2GRAY , #COLOR_BayerRG2GRAY , #COLOR_BayerGR2GRAY\n.   \n.   -   Demosaicing using Variable Number of Gradients.\n.   \n.       #COLOR_BayerBG2BGR_VNG , #COLOR_BayerGB2BGR_VNG , #COLOR_BayerRG2BGR_VNG , #COLOR_BayerGR2BGR_VNG\n.   \n.   -   Edge-Aware Demosaicing.\n.   \n.       #COLOR_BayerBG2BGR_EA , #COLOR_BayerGB2BGR_EA , #COLOR_BayerRG2BGR_EA , #COLOR_BayerGR2BGR_EA\n.   \n.   -   Demosaicing with alpha channel\n.   \n.       #COLOR_BayerBG2BGRA , #COLOR_BayerGB2BGRA , #COLOR_BayerRG2BGRA , #COLOR_BayerGR2BGRA\n.   \n.   @sa cvtColor"},
    {"denoise_TVL1", CV_PY_FN_WITH_KW_(pyopencv_cv_denoise_TVL1, 0), "denoise_TVL1(observations, result[, lambda_[, niters]]) -> None\n.   @brief Primal-dual algorithm is an algorithm for solving special types of variational problems (that is,\n.   finding a function to minimize some functional). As the image denoising, in particular, may be seen\n.   as the variational problem, primal-dual algorithm then can be used to perform denoising and this is\n.   exactly what is implemented.\n.   \n.   It should be noted, that this implementation was taken from the July 2013 blog entry\n.   @cite MA13 , which also contained (slightly more general) ready-to-use source code on Python.\n.   Subsequently, that code was rewritten on C++ with the usage of openCV by Vadim Pisarevsky at the end\n.   of July 2013 and finally it was slightly adapted by later authors.\n.   \n.   Although the thorough discussion and justification of the algorithm involved may be found in\n.   @cite ChambolleEtAl, it might make sense to skim over it here, following @cite MA13 . To begin\n.   with, we consider the 1-byte gray-level images as the functions from the rectangular domain of\n.   pixels (it may be seen as set\n.   \\f$\\left\\{(x,y)\\in\\mathbb{N}\\times\\mathbb{N}\\mid 1\\leq x\\leq n,\\;1\\leq y\\leq m\\right\\}\\f$ for some\n.   \\f$m,\\;n\\in\\mathbb{N}\\f$) into \\f$\\{0,1,\\dots,255\\}\\f$. We shall denote the noised images as \\f$f_i\\f$ and with\n.   this view, given some image \\f$x\\f$ of the same size, we may measure how bad it is by the formula\n.   \n.   \\f[\\left\\|\\left\\|\\nabla x\\right\\|\\right\\| + \\lambda\\sum_i\\left\\|\\left\\|x-f_i\\right\\|\\right\\|\\f]\n.   \n.   \\f$\\|\\|\\cdot\\|\\|\\f$ here denotes \\f$L_2\\f$-norm and as you see, the first addend states that we want our\n.   image to be smooth (ideally, having zero gradient, thus being constant) and the second states that\n.   we want our result to be close to the observations we've got. If we treat \\f$x\\f$ as a function, this is\n.   exactly the functional what we seek to minimize and here the Primal-Dual algorithm comes into play.\n.   \n.   @param observations This array should contain one or more noised versions of the image that is to\n.   be restored.\n.   @param result Here the denoised image will be stored. There is no need to do pre-allocation of\n.   storage space, as it will be automatically allocated, if necessary.\n.   @param lambda Corresponds to \\f$\\lambda\\f$ in the formulas above. As it is enlarged, the smooth\n.   (blurred) images are treated more favorably than detailed (but maybe more noised) ones. Roughly\n.   speaking, as it becomes smaller, the result will be more blur but more sever outliers will be\n.   removed.\n.   @param niters Number of iterations that the algorithm will run. Of course, as more iterations as\n.   better, but it is hard to quantitatively refine this statement, so just use the default and\n.   increase it if the results are poor."},
    {"destroyAllWindows", CV_PY_FN_WITH_KW_(pyopencv_cv_destroyAllWindows, 0), "destroyAllWindows() -> None\n.   @brief Destroys all of the HighGUI windows.\n.   \n.   The function destroyAllWindows destroys all of the opened HighGUI windows."},
    {"destroyWindow", CV_PY_FN_WITH_KW_(pyopencv_cv_destroyWindow, 0), "destroyWindow(winname) -> None\n.   @brief Destroys the specified window.\n.   \n.   The function destroyWindow destroys the window with the given name.\n.   \n.   @param winname Name of the window to be destroyed."},
    {"detailEnhance", CV_PY_FN_WITH_KW_(pyopencv_cv_detailEnhance, 0), "detailEnhance(src[, dst[, sigma_s[, sigma_r]]]) -> dst\n.   @brief This filter enhances the details of a particular image.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param sigma_s %Range between 0 to 200.\n.   @param sigma_r %Range between 0 to 1."},
    {"determinant", CV_PY_FN_WITH_KW_(pyopencv_cv_determinant, 0), "determinant(mtx) -> retval\n.   @brief Returns the determinant of a square floating-point matrix.\n.   \n.   The function cv::determinant calculates and returns the determinant of the\n.   specified matrix. For small matrices ( mtx.cols=mtx.rows\\<=3 ), the\n.   direct method is used. For larger matrices, the function uses LU\n.   factorization with partial pivoting.\n.   \n.   For symmetric positively-determined matrices, it is also possible to use\n.   eigen decomposition to calculate the determinant.\n.   @param mtx input matrix that must have CV_32FC1 or CV_64FC1 type and\n.   square size.\n.   @sa trace, invert, solve, eigen, @ref MatrixExpressions"},
    {"dft", CV_PY_FN_WITH_KW_(pyopencv_cv_dft, 0), "dft(src[, dst[, flags[, nonzeroRows]]]) -> dst\n.   @brief Performs a forward or inverse Discrete Fourier transform of a 1D or 2D floating-point array.\n.   \n.   The function cv::dft performs one of the following:\n.   -   Forward the Fourier transform of a 1D vector of N elements:\n.       \\f[Y = F^{(N)}  \\cdot X,\\f]\n.       where \\f$F^{(N)}_{jk}=\\exp(-2\\pi i j k/N)\\f$ and \\f$i=\\sqrt{-1}\\f$\n.   -   Inverse the Fourier transform of a 1D vector of N elements:\n.       \\f[\\begin{array}{l} X'=  \\left (F^{(N)} \\right )^{-1}  \\cdot Y =  \\left (F^{(N)} \\right )^*  \\cdot y  \\\\ X = (1/N)  \\cdot X, \\end{array}\\f]\n.       where \\f$F^*=\\left(\\textrm{Re}(F^{(N)})-\\textrm{Im}(F^{(N)})\\right)^T\\f$\n.   -   Forward the 2D Fourier transform of a M x N matrix:\n.       \\f[Y = F^{(M)}  \\cdot X  \\cdot F^{(N)}\\f]\n.   -   Inverse the 2D Fourier transform of a M x N matrix:\n.       \\f[\\begin{array}{l} X'=  \\left (F^{(M)} \\right )^*  \\cdot Y  \\cdot \\left (F^{(N)} \\right )^* \\\\ X =  \\frac{1}{M \\cdot N} \\cdot X' \\end{array}\\f]\n.   \n.   In case of real (single-channel) data, the output spectrum of the forward Fourier transform or input\n.   spectrum of the inverse Fourier transform can be represented in a packed format called *CCS*\n.   (complex-conjugate-symmetrical). It was borrowed from IPL (Intel\\* Image Processing Library). Here\n.   is how 2D *CCS* spectrum looks:\n.   \\f[\\begin{bmatrix} Re Y_{0,0} & Re Y_{0,1} & Im Y_{0,1} & Re Y_{0,2} & Im Y_{0,2} &  \\cdots & Re Y_{0,N/2-1} & Im Y_{0,N/2-1} & Re Y_{0,N/2}  \\\\ Re Y_{1,0} & Re Y_{1,1} & Im Y_{1,1} & Re Y_{1,2} & Im Y_{1,2} &  \\cdots & Re Y_{1,N/2-1} & Im Y_{1,N/2-1} & Re Y_{1,N/2}  \\\\ Im Y_{1,0} & Re Y_{2,1} & Im Y_{2,1} & Re Y_{2,2} & Im Y_{2,2} &  \\cdots & Re Y_{2,N/2-1} & Im Y_{2,N/2-1} & Im Y_{1,N/2}  \\\\ \\hdotsfor{9} \\\\ Re Y_{M/2-1,0} &  Re Y_{M-3,1}  & Im Y_{M-3,1} &  \\hdotsfor{3} & Re Y_{M-3,N/2-1} & Im Y_{M-3,N/2-1}& Re Y_{M/2-1,N/2}  \\\\ Im Y_{M/2-1,0} &  Re Y_{M-2,1}  & Im Y_{M-2,1} &  \\hdotsfor{3} & Re Y_{M-2,N/2-1} & Im Y_{M-2,N/2-1}& Im Y_{M/2-1,N/2}  \\\\ Re Y_{M/2,0}  &  Re Y_{M-1,1} &  Im Y_{M-1,1} &  \\hdotsfor{3} & Re Y_{M-1,N/2-1} & Im Y_{M-1,N/2-1}& Re Y_{M/2,N/2} \\end{bmatrix}\\f]\n.   \n.   In case of 1D transform of a real vector, the output looks like the first row of the matrix above.\n.   \n.   So, the function chooses an operation mode depending on the flags and size of the input array:\n.   -   If #DFT_ROWS is set or the input array has a single row or single column, the function\n.       performs a 1D forward or inverse transform of each row of a matrix when #DFT_ROWS is set.\n.       Otherwise, it performs a 2D transform.\n.   -   If the input array is real and #DFT_INVERSE is not set, the function performs a forward 1D or\n.       2D transform:\n.       -   When #DFT_COMPLEX_OUTPUT is set, the output is a complex matrix of the same size as\n.           input.\n.       -   When #DFT_COMPLEX_OUTPUT is not set, the output is a real matrix of the same size as\n.           input. In case of 2D transform, it uses the packed format as shown above. In case of a\n.           single 1D transform, it looks like the first row of the matrix above. In case of\n.           multiple 1D transforms (when using the #DFT_ROWS flag), each row of the output matrix\n.           looks like the first row of the matrix above.\n.   -   If the input array is complex and either #DFT_INVERSE or #DFT_REAL_OUTPUT are not set, the\n.       output is a complex array of the same size as input. The function performs a forward or\n.       inverse 1D or 2D transform of the whole input array or each row of the input array\n.       independently, depending on the flags DFT_INVERSE and DFT_ROWS.\n.   -   When #DFT_INVERSE is set and the input array is real, or it is complex but #DFT_REAL_OUTPUT\n.       is set, the output is a real array of the same size as input. The function performs a 1D or 2D\n.       inverse transformation of the whole input array or each individual row, depending on the flags\n.       #DFT_INVERSE and #DFT_ROWS.\n.   \n.   If #DFT_SCALE is set, the scaling is done after the transformation.\n.   \n.   Unlike dct, the function supports arrays of arbitrary size. But only those arrays are processed\n.   efficiently, whose sizes can be factorized in a product of small prime numbers (2, 3, and 5 in the\n.   current implementation). Such an efficient DFT size can be calculated using the getOptimalDFTSize\n.   method.\n.   \n.   The sample below illustrates how to calculate a DFT-based convolution of two 2D real arrays:\n.   @code\n.       void convolveDFT(InputArray A, InputArray B, OutputArray C)\n.       {\n.           // reallocate the output array if needed\n.           C.create(abs(A.rows - B.rows)+1, abs(A.cols - B.cols)+1, A.type());\n.           Size dftSize;\n.           // calculate the size of DFT transform\n.           dftSize.width = getOptimalDFTSize(A.cols + B.cols - 1);\n.           dftSize.height = getOptimalDFTSize(A.rows + B.rows - 1);\n.   \n.           // allocate temporary buffers and initialize them with 0's\n.           Mat tempA(dftSize, A.type(), Scalar::all(0));\n.           Mat tempB(dftSize, B.type(), Scalar::all(0));\n.   \n.           // copy A and B to the top-left corners of tempA and tempB, respectively\n.           Mat roiA(tempA, Rect(0,0,A.cols,A.rows));\n.           A.copyTo(roiA);\n.           Mat roiB(tempB, Rect(0,0,B.cols,B.rows));\n.           B.copyTo(roiB);\n.   \n.           // now transform the padded A & B in-place;\n.           // use \"nonzeroRows\" hint for faster processing\n.           dft(tempA, tempA, 0, A.rows);\n.           dft(tempB, tempB, 0, B.rows);\n.   \n.           // multiply the spectrums;\n.           // the function handles packed spectrum representations well\n.           mulSpectrums(tempA, tempB, tempA);\n.   \n.           // transform the product back from the frequency domain.\n.           // Even though all the result rows will be non-zero,\n.           // you need only the first C.rows of them, and thus you\n.           // pass nonzeroRows == C.rows\n.           dft(tempA, tempA, DFT_INVERSE + DFT_SCALE, C.rows);\n.   \n.           // now copy the result back to C.\n.           tempA(Rect(0, 0, C.cols, C.rows)).copyTo(C);\n.   \n.           // all the temporary buffers will be deallocated automatically\n.       }\n.   @endcode\n.   To optimize this sample, consider the following approaches:\n.   -   Since nonzeroRows != 0 is passed to the forward transform calls and since A and B are copied to\n.       the top-left corners of tempA and tempB, respectively, it is not necessary to clear the whole\n.       tempA and tempB. It is only necessary to clear the tempA.cols - A.cols ( tempB.cols - B.cols)\n.       rightmost columns of the matrices.\n.   -   This DFT-based convolution does not have to be applied to the whole big arrays, especially if B\n.       is significantly smaller than A or vice versa. Instead, you can calculate convolution by parts.\n.       To do this, you need to split the output array C into multiple tiles. For each tile, estimate\n.       which parts of A and B are required to calculate convolution in this tile. If the tiles in C are\n.       too small, the speed will decrease a lot because of repeated work. In the ultimate case, when\n.       each tile in C is a single pixel, the algorithm becomes equivalent to the naive convolution\n.       algorithm. If the tiles are too big, the temporary arrays tempA and tempB become too big and\n.       there is also a slowdown because of bad cache locality. So, there is an optimal tile size\n.       somewhere in the middle.\n.   -   If different tiles in C can be calculated in parallel and, thus, the convolution is done by\n.       parts, the loop can be threaded.\n.   \n.   All of the above improvements have been implemented in #matchTemplate and #filter2D . Therefore, by\n.   using them, you can get the performance even better than with the above theoretically optimal\n.   implementation. Though, those two functions actually calculate cross-correlation, not convolution,\n.   so you need to \"flip\" the second convolution operand B vertically and horizontally using flip .\n.   @note\n.   -   An example using the discrete fourier transform can be found at\n.       opencv_source_code/samples/cpp/dft.cpp\n.   -   (Python) An example using the dft functionality to perform Wiener deconvolution can be found\n.       at opencv_source/samples/python/deconvolution.py\n.   -   (Python) An example rearranging the quadrants of a Fourier image can be found at\n.       opencv_source/samples/python/dft.py\n.   @param src input array that could be real or complex.\n.   @param dst output array whose size and type depends on the flags .\n.   @param flags transformation flags, representing a combination of the #DftFlags\n.   @param nonzeroRows when the parameter is not zero, the function assumes that only the first\n.   nonzeroRows rows of the input array (#DFT_INVERSE is not set) or only the first nonzeroRows of the\n.   output array (#DFT_INVERSE is set) contain non-zeros, thus, the function can handle the rest of the\n.   rows more efficiently and save some time; this technique is very useful for calculating array\n.   cross-correlation or convolution using DFT.\n.   @sa dct, getOptimalDFTSize, mulSpectrums, filter2D, matchTemplate, flip, cartToPolar,\n.   magnitude, phase"},
    {"dilate", CV_PY_FN_WITH_KW_(pyopencv_cv_dilate, 0), "dilate(src, kernel[, dst[, anchor[, iterations[, borderType[, borderValue]]]]]) -> dst\n.   @brief Dilates an image by using a specific structuring element.\n.   \n.   The function dilates the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the maximum is taken:\n.   \\f[\\texttt{dst} (x,y) =  \\max _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   The function supports the in-place mode. Dilation can be applied several ( iterations ) times. In\n.   case of multi-channel images, each channel is processed independently.\n.   \n.   @param src input image; the number of channels can be arbitrary, but the depth should be one of\n.   CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param kernel structuring element used for dilation; if element=Mat(), a 3 x 3 rectangular\n.   structuring element is used. Kernel can be created using #getStructuringElement\n.   @param anchor position of the anchor within the element; default value (-1, -1) means that the\n.   anchor is at the element center.\n.   @param iterations number of times dilation is applied.\n.   @param borderType pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not suported.\n.   @param borderValue border value in case of a constant border\n.   @sa  erode, morphologyEx, getStructuringElement"},
    {"displayOverlay", CV_PY_FN_WITH_KW_(pyopencv_cv_displayOverlay, 0), "displayOverlay(winname, text[, delayms]) -> None\n.   @brief Displays a text on a window image as an overlay for a specified duration.\n.   \n.   The function displayOverlay displays useful information/tips on top of the window for a certain\n.   amount of time *delayms*. The function does not modify the image, displayed in the window, that is,\n.   after the specified delay the original content of the window is restored.\n.   \n.   @param winname Name of the window.\n.   @param text Overlay text to write on a window image.\n.   @param delayms The period (in milliseconds), during which the overlay text is displayed. If this\n.   function is called before the previous overlay text timed out, the timer is restarted and the text\n.   is updated. If this value is zero, the text never disappears."},
    {"displayStatusBar", CV_PY_FN_WITH_KW_(pyopencv_cv_displayStatusBar, 0), "displayStatusBar(winname, text[, delayms]) -> None\n.   @brief Displays a text on the window statusbar during the specified period of time.\n.   \n.   The function displayStatusBar displays useful information/tips on top of the window for a certain\n.   amount of time *delayms* . This information is displayed on the window statusbar (the window must be\n.   created with the CV_GUI_EXPANDED flags).\n.   \n.   @param winname Name of the window.\n.   @param text Text to write on the window statusbar.\n.   @param delayms Duration (in milliseconds) to display the text. If this function is called before\n.   the previous text timed out, the timer is restarted and the text is updated. If this value is\n.   zero, the text never disappears."},
    {"distanceTransform", CV_PY_FN_WITH_KW_(pyopencv_cv_distanceTransform, 0), "distanceTransform(src, distanceType, maskSize[, dst[, dstType]]) -> dst\n.   @overload\n.   @param src 8-bit, single-channel (binary) source image.\n.   @param dst Output image with calculated distances. It is a 8-bit or 32-bit floating-point,\n.   single-channel image of the same size as src .\n.   @param distanceType Type of distance, see #DistanceTypes\n.   @param maskSize Size of the distance transform mask, see #DistanceTransformMasks. In case of the\n.   #DIST_L1 or #DIST_C distance type, the parameter is forced to 3 because a \\f$3\\times 3\\f$ mask gives\n.   the same result as \\f$5\\times 5\\f$ or any larger aperture.\n.   @param dstType Type of output image. It can be CV_8U or CV_32F. Type CV_8U can be used only for\n.   the first variant of the function and distanceType == #DIST_L1."},
    {"distanceTransformWithLabels", CV_PY_FN_WITH_KW_(pyopencv_cv_distanceTransformWithLabels, 0), "distanceTransformWithLabels(src, distanceType, maskSize[, dst[, labels[, labelType]]]) -> dst, labels\n.   @brief Calculates the distance to the closest zero pixel for each pixel of the source image.\n.   \n.   The function cv::distanceTransform calculates the approximate or precise distance from every binary\n.   image pixel to the nearest zero pixel. For zero image pixels, the distance will obviously be zero.\n.   \n.   When maskSize == #DIST_MASK_PRECISE and distanceType == #DIST_L2 , the function runs the\n.   algorithm described in @cite Felzenszwalb04 . This algorithm is parallelized with the TBB library.\n.   \n.   In other cases, the algorithm @cite Borgefors86 is used. This means that for a pixel the function\n.   finds the shortest path to the nearest zero pixel consisting of basic shifts: horizontal, vertical,\n.   diagonal, or knight's move (the latest is available for a \\f$5\\times 5\\f$ mask). The overall\n.   distance is calculated as a sum of these basic distances. Since the distance function should be\n.   symmetric, all of the horizontal and vertical shifts must have the same cost (denoted as a ), all\n.   the diagonal shifts must have the same cost (denoted as `b`), and all knight's moves must have the\n.   same cost (denoted as `c`). For the #DIST_C and #DIST_L1 types, the distance is calculated\n.   precisely, whereas for #DIST_L2 (Euclidean distance) the distance can be calculated only with a\n.   relative error (a \\f$5\\times 5\\f$ mask gives more accurate results). For `a`,`b`, and `c`, OpenCV\n.   uses the values suggested in the original paper:\n.   - DIST_L1: `a = 1, b = 2`\n.   - DIST_L2:\n.       - `3 x 3`: `a=0.955, b=1.3693`\n.       - `5 x 5`: `a=1, b=1.4, c=2.1969`\n.   - DIST_C: `a = 1, b = 1`\n.   \n.   Typically, for a fast, coarse distance estimation #DIST_L2, a \\f$3\\times 3\\f$ mask is used. For a\n.   more accurate distance estimation #DIST_L2, a \\f$5\\times 5\\f$ mask or the precise algorithm is used.\n.   Note that both the precise and the approximate algorithms are linear on the number of pixels.\n.   \n.   This variant of the function does not only compute the minimum distance for each pixel \\f$(x, y)\\f$\n.   but also identifies the nearest connected component consisting of zero pixels\n.   (labelType==#DIST_LABEL_CCOMP) or the nearest zero pixel (labelType==#DIST_LABEL_PIXEL). Index of the\n.   component/pixel is stored in `labels(x, y)`. When labelType==#DIST_LABEL_CCOMP, the function\n.   automatically finds connected components of zero pixels in the input image and marks them with\n.   distinct labels. When labelType==#DIST_LABEL_PIXEL, the function scans through the input image and\n.   marks all the zero pixels with distinct labels.\n.   \n.   In this mode, the complexity is still linear. That is, the function provides a very fast way to\n.   compute the Voronoi diagram for a binary image. Currently, the second variant can use only the\n.   approximate distance transform algorithm, i.e. maskSize=#DIST_MASK_PRECISE is not supported\n.   yet.\n.   \n.   @param src 8-bit, single-channel (binary) source image.\n.   @param dst Output image with calculated distances. It is a 8-bit or 32-bit floating-point,\n.   single-channel image of the same size as src.\n.   @param labels Output 2D array of labels (the discrete Voronoi diagram). It has the type\n.   CV_32SC1 and the same size as src.\n.   @param distanceType Type of distance, see #DistanceTypes\n.   @param maskSize Size of the distance transform mask, see #DistanceTransformMasks.\n.   #DIST_MASK_PRECISE is not supported by this variant. In case of the #DIST_L1 or #DIST_C distance type,\n.   the parameter is forced to 3 because a \\f$3\\times 3\\f$ mask gives the same result as \\f$5\\times\n.   5\\f$ or any larger aperture.\n.   @param labelType Type of the label array to build, see #DistanceTransformLabelTypes."},
    {"divSpectrums", CV_PY_FN_WITH_KW_(pyopencv_cv_divSpectrums, 0), "divSpectrums(a, b, flags[, c[, conjB]]) -> c\n.   @brief Performs the per-element division of the first Fourier spectrum by the second Fourier spectrum.\n.   \n.   The function cv::divSpectrums performs the per-element division of the first array by the second array.\n.   The arrays are CCS-packed or complex matrices that are results of a real or complex Fourier transform.\n.   \n.   @param a first input array.\n.   @param b second input array of the same size and type as src1 .\n.   @param c output array of the same size and type as src1 .\n.   @param flags operation flags; currently, the only supported flag is cv::DFT_ROWS, which indicates that\n.   each row of src1 and src2 is an independent 1D Fourier spectrum. If you do not want to use this flag, then simply add a `0` as value.\n.   @param conjB optional flag that conjugates the second input array before the multiplication (true)\n.   or not (false)."},
    {"divide", CV_PY_FN_WITH_KW_(pyopencv_cv_divide, 0), "divide(src1, src2[, dst[, scale[, dtype]]]) -> dst\n.   @brief Performs per-element division of two arrays or a scalar by an array.\n.   \n.   The function cv::divide divides one array by another:\n.   \\f[\\texttt{dst(I) = saturate(src1(I)*scale/src2(I))}\\f]\n.   or a scalar by an array when there is no src1 :\n.   \\f[\\texttt{dst(I) = saturate(scale/src2(I))}\\f]\n.   \n.   Different channels of multi-channel arrays are processed independently.\n.   \n.   For integer types when src2(I) is zero, dst(I) will also be zero.\n.   \n.   @note In case of floating point data there is no special defined behavior for zero src2(I) values.\n.   Regular floating-point division is used.\n.   Expect correct IEEE-754 behaviour for floating-point data (with NaN, Inf result values).\n.   \n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.\n.   `divide(src,X)` means `divide(src,(X,X,X,X))`.\n.   `divide(src,(X,))` means `divide(src,(X,0,0,0))`.\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and type as src1.\n.   @param scale scalar factor.\n.   @param dst output array of the same size and type as src2.\n.   @param dtype optional depth of the output array; if -1, dst will have depth src2.depth(), but in\n.   case of an array-by-array division, you can only pass -1 when src1.depth()==src2.depth().\n.   @sa  multiply, add, subtract\n\n\n\ndivide(scale, src2[, dst[, dtype]]) -> dst\n.   @overload"},
    {"drawChessboardCorners", CV_PY_FN_WITH_KW_(pyopencv_cv_drawChessboardCorners, 0), "drawChessboardCorners(image, patternSize, corners, patternWasFound) -> image\n.   @brief Renders the detected chessboard corners.\n.   \n.   @param image Destination image. It must be an 8-bit color image.\n.   @param patternSize Number of inner corners per a chessboard row and column\n.   (patternSize = cv::Size(points_per_row,points_per_column)).\n.   @param corners Array of detected corners, the output of #findChessboardCorners.\n.   @param patternWasFound Parameter indicating whether the complete board was found or not. The\n.   return value of #findChessboardCorners should be passed here.\n.   \n.   The function draws individual chessboard corners detected either as red circles if the board was not\n.   found, or as colored corners connected with lines if the board was found."},
    {"drawContours", CV_PY_FN_WITH_KW_(pyopencv_cv_drawContours, 0), "drawContours(image, contours, contourIdx, color[, thickness[, lineType[, hierarchy[, maxLevel[, offset]]]]]) -> image\n.   @brief Draws contours outlines or filled contours.\n.   \n.   The function draws contour outlines in the image if \\f$\\texttt{thickness} \\ge 0\\f$ or fills the area\n.   bounded by the contours if \\f$\\texttt{thickness}<0\\f$ . The example below shows how to retrieve\n.   connected components from the binary image and label them: :\n.   @include snippets/imgproc_drawContours.cpp\n.   \n.   @param image Destination image.\n.   @param contours All the input contours. Each contour is stored as a point vector.\n.   @param contourIdx Parameter indicating a contour to draw. If it is negative, all the contours are drawn.\n.   @param color Color of the contours.\n.   @param thickness Thickness of lines the contours are drawn with. If it is negative (for example,\n.   thickness=#FILLED ), the contour interiors are drawn.\n.   @param lineType Line connectivity. See #LineTypes\n.   @param hierarchy Optional information about hierarchy. It is only needed if you want to draw only\n.   some of the contours (see maxLevel ).\n.   @param maxLevel Maximal level for drawn contours. If it is 0, only the specified contour is drawn.\n.   If it is 1, the function draws the contour(s) and all the nested contours. If it is 2, the function\n.   draws the contours, all the nested contours, all the nested-to-nested contours, and so on. This\n.   parameter is only taken into account when there is hierarchy available.\n.   @param offset Optional contour shift parameter. Shift all the drawn contours by the specified\n.   \\f$\\texttt{offset}=(dx,dy)\\f$ .\n.   @note When thickness=#FILLED, the function is designed to handle connected components with holes correctly\n.   even when no hierarchy data is provided. This is done by analyzing all the outlines together\n.   using even-odd rule. This may give incorrect results if you have a joint collection of separately retrieved\n.   contours. In order to solve this problem, you need to call #drawContours separately for each sub-group\n.   of contours, or iterate over the collection using contourIdx parameter."},
    {"drawFrameAxes", CV_PY_FN_WITH_KW_(pyopencv_cv_drawFrameAxes, 0), "drawFrameAxes(image, cameraMatrix, distCoeffs, rvec, tvec, length[, thickness]) -> image\n.   @brief Draw axes of the world/object coordinate system from pose estimation. @sa solvePnP\n.   \n.   @param image Input/output image. It must have 1 or 3 channels. The number of channels is not altered.\n.   @param cameraMatrix Input 3x3 floating-point matrix of camera intrinsic parameters.\n.   \\f$\\cameramatrix{A}\\f$\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is empty, the zero distortion coefficients are assumed.\n.   @param rvec Rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.   the model coordinate system to the camera coordinate system.\n.   @param tvec Translation vector.\n.   @param length Length of the painted axes in the same unit than tvec (usually in meters).\n.   @param thickness Line thickness of the painted axes.\n.   \n.   This function draws the axes of the world/object coordinate system w.r.t. to the camera frame.\n.   OX is drawn in red, OY in green and OZ in blue."},
    {"drawKeypoints", CV_PY_FN_WITH_KW_(pyopencv_cv_drawKeypoints, 0), "drawKeypoints(image, keypoints, outImage[, color[, flags]]) -> outImage\n.   @brief Draws keypoints.\n.   \n.   @param image Source image.\n.   @param keypoints Keypoints from the source image.\n.   @param outImage Output image. Its content depends on the flags value defining what is drawn in the\n.   output image. See possible flags bit values below.\n.   @param color Color of keypoints.\n.   @param flags Flags setting drawing features. Possible flags bit values are defined by\n.   DrawMatchesFlags. See details above in drawMatches .\n.   \n.   @note\n.   For Python API, flags are modified as cv.DRAW_MATCHES_FLAGS_DEFAULT,\n.   cv.DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS, cv.DRAW_MATCHES_FLAGS_DRAW_OVER_OUTIMG,\n.   cv.DRAW_MATCHES_FLAGS_NOT_DRAW_SINGLE_POINTS"},
    {"drawMarker", CV_PY_FN_WITH_KW_(pyopencv_cv_drawMarker, 0), "drawMarker(img, position, color[, markerType[, markerSize[, thickness[, line_type]]]]) -> img\n.   @brief Draws a marker on a predefined position in an image.\n.   \n.   The function cv::drawMarker draws a marker on a given position in the image. For the moment several\n.   marker types are supported, see #MarkerTypes for more information.\n.   \n.   @param img Image.\n.   @param position The point where the crosshair is positioned.\n.   @param color Line color.\n.   @param markerType The specific type of marker you want to use, see #MarkerTypes\n.   @param thickness Line thickness.\n.   @param line_type Type of the line, See #LineTypes\n.   @param markerSize The length of the marker axis [default = 20 pixels]"},
    {"drawMatches", CV_PY_FN_WITH_KW_(pyopencv_cv_drawMatches, 0), "drawMatches(img1, keypoints1, img2, keypoints2, matches1to2, outImg[, matchColor[, singlePointColor[, matchesMask[, flags]]]]) -> outImg\n.   @brief Draws the found matches of keypoints from two images.\n.   \n.   @param img1 First source image.\n.   @param keypoints1 Keypoints from the first source image.\n.   @param img2 Second source image.\n.   @param keypoints2 Keypoints from the second source image.\n.   @param matches1to2 Matches from the first image to the second one, which means that keypoints1[i]\n.   has a corresponding point in keypoints2[matches[i]] .\n.   @param outImg Output image. Its content depends on the flags value defining what is drawn in the\n.   output image. See possible flags bit values below.\n.   @param matchColor Color of matches (lines and connected keypoints). If matchColor==Scalar::all(-1)\n.   , the color is generated randomly.\n.   @param singlePointColor Color of single keypoints (circles), which means that keypoints do not\n.   have the matches. If singlePointColor==Scalar::all(-1) , the color is generated randomly.\n.   @param matchesMask Mask determining which matches are drawn. If the mask is empty, all matches are\n.   drawn.\n.   @param flags Flags setting drawing features. Possible flags bit values are defined by\n.   DrawMatchesFlags.\n.   \n.   This function draws matches of keypoints from two images in the output image. Match is a line\n.   connecting two keypoints (circles). See cv::DrawMatchesFlags.\n\n\n\ndrawMatches(img1, keypoints1, img2, keypoints2, matches1to2, outImg, matchesThickness[, matchColor[, singlePointColor[, matchesMask[, flags]]]]) -> outImg\n.   @overload"},
    {"drawMatchesKnn", CV_PY_FN_WITH_KW_(pyopencv_cv_drawMatchesKnn, 0), "drawMatchesKnn(img1, keypoints1, img2, keypoints2, matches1to2, outImg[, matchColor[, singlePointColor[, matchesMask[, flags]]]]) -> outImg\n."},
    {"edgePreservingFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_edgePreservingFilter, 0), "edgePreservingFilter(src[, dst[, flags[, sigma_s[, sigma_r]]]]) -> dst\n.   @brief Filtering is the fundamental operation in image and video processing. Edge-preserving smoothing\n.   filters are used in many different applications @cite EM11 .\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output 8-bit 3-channel image.\n.   @param flags Edge preserving filters: cv::RECURS_FILTER or cv::NORMCONV_FILTER\n.   @param sigma_s %Range between 0 to 200.\n.   @param sigma_r %Range between 0 to 1."},
    {"eigen", CV_PY_FN_WITH_KW_(pyopencv_cv_eigen, 0), "eigen(src[, eigenvalues[, eigenvectors]]) -> retval, eigenvalues, eigenvectors\n.   @brief Calculates eigenvalues and eigenvectors of a symmetric matrix.\n.   \n.   The function cv::eigen calculates just eigenvalues, or eigenvalues and eigenvectors of the symmetric\n.   matrix src:\n.   @code\n.       src*eigenvectors.row(i).t() = eigenvalues.at<srcType>(i)*eigenvectors.row(i).t()\n.   @endcode\n.   \n.   @note Use cv::eigenNonSymmetric for calculation of real eigenvalues and eigenvectors of non-symmetric matrix.\n.   \n.   @param src input matrix that must have CV_32FC1 or CV_64FC1 type, square size and be symmetrical\n.   (src ^T^ == src).\n.   @param eigenvalues output vector of eigenvalues of the same type as src; the eigenvalues are stored\n.   in the descending order.\n.   @param eigenvectors output matrix of eigenvectors; it has the same size and type as src; the\n.   eigenvectors are stored as subsequent matrix rows, in the same order as the corresponding\n.   eigenvalues.\n.   @sa eigenNonSymmetric, completeSymm, PCA"},
    {"eigenNonSymmetric", CV_PY_FN_WITH_KW_(pyopencv_cv_eigenNonSymmetric, 0), "eigenNonSymmetric(src[, eigenvalues[, eigenvectors]]) -> eigenvalues, eigenvectors\n.   @brief Calculates eigenvalues and eigenvectors of a non-symmetric matrix (real eigenvalues only).\n.   \n.   @note Assumes real eigenvalues.\n.   \n.   The function calculates eigenvalues and eigenvectors (optional) of the square matrix src:\n.   @code\n.       src*eigenvectors.row(i).t() = eigenvalues.at<srcType>(i)*eigenvectors.row(i).t()\n.   @endcode\n.   \n.   @param src input matrix (CV_32FC1 or CV_64FC1 type).\n.   @param eigenvalues output vector of eigenvalues (type is the same type as src).\n.   @param eigenvectors output matrix of eigenvectors (type is the same type as src). The eigenvectors are stored as subsequent matrix rows, in the same order as the corresponding eigenvalues.\n.   @sa eigen"},
    {"ellipse", CV_PY_FN_WITH_KW_(pyopencv_cv_ellipse, 0), "ellipse(img, center, axes, angle, startAngle, endAngle, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a simple or thick elliptic arc or fills an ellipse sector.\n.   \n.   The function cv::ellipse with more parameters draws an ellipse outline, a filled ellipse, an elliptic\n.   arc, or a filled ellipse sector. The drawing code uses general parametric form.\n.   A piecewise-linear curve is used to approximate the elliptic arc\n.   boundary. If you need more control of the ellipse rendering, you can retrieve the curve using\n.   #ellipse2Poly and then render it with #polylines or fill it with #fillPoly. If you use the first\n.   variant of the function and want to draw the whole ellipse, not an arc, pass `startAngle=0` and\n.   `endAngle=360`. If `startAngle` is greater than `endAngle`, they are swapped. The figure below explains\n.   the meaning of the parameters to draw the blue arc.\n.   \n.   ![Parameters of Elliptic Arc](pics/ellipse.svg)\n.   \n.   @param img Image.\n.   @param center Center of the ellipse.\n.   @param axes Half of the size of the ellipse main axes.\n.   @param angle Ellipse rotation angle in degrees.\n.   @param startAngle Starting angle of the elliptic arc in degrees.\n.   @param endAngle Ending angle of the elliptic arc in degrees.\n.   @param color Ellipse color.\n.   @param thickness Thickness of the ellipse arc outline, if positive. Otherwise, this indicates that\n.   a filled ellipse sector is to be drawn.\n.   @param lineType Type of the ellipse boundary. See #LineTypes\n.   @param shift Number of fractional bits in the coordinates of the center and values of axes.\n\n\n\nellipse(img, box, color[, thickness[, lineType]]) -> img\n.   @overload\n.   @param img Image.\n.   @param box Alternative ellipse representation via RotatedRect. This means that the function draws\n.   an ellipse inscribed in the rotated rectangle.\n.   @param color Ellipse color.\n.   @param thickness Thickness of the ellipse arc outline, if positive. Otherwise, this indicates that\n.   a filled ellipse sector is to be drawn.\n.   @param lineType Type of the ellipse boundary. See #LineTypes"},
    {"ellipse2Poly", CV_PY_FN_WITH_KW_(pyopencv_cv_ellipse2Poly, 0), "ellipse2Poly(center, axes, angle, arcStart, arcEnd, delta) -> pts\n.   @brief Approximates an elliptic arc with a polyline.\n.   \n.   The function ellipse2Poly computes the vertices of a polyline that approximates the specified\n.   elliptic arc. It is used by #ellipse. If `arcStart` is greater than `arcEnd`, they are swapped.\n.   \n.   @param center Center of the arc.\n.   @param axes Half of the size of the ellipse main axes. See #ellipse for details.\n.   @param angle Rotation angle of the ellipse in degrees. See #ellipse for details.\n.   @param arcStart Starting angle of the elliptic arc in degrees.\n.   @param arcEnd Ending angle of the elliptic arc in degrees.\n.   @param delta Angle between the subsequent polyline vertices. It defines the approximation\n.   accuracy.\n.   @param pts Output vector of polyline vertices."},
    {"empty_array_desc", CV_PY_FN_WITH_KW_(pyopencv_cv_empty_array_desc, 0), "empty_array_desc() -> retval\n."},
    {"empty_gopaque_desc", CV_PY_FN_WITH_KW_(pyopencv_cv_empty_gopaque_desc, 0), "empty_gopaque_desc() -> retval\n."},
    {"empty_scalar_desc", CV_PY_FN_WITH_KW_(pyopencv_cv_empty_scalar_desc, 0), "empty_scalar_desc() -> retval\n."},
    {"equalizeHist", CV_PY_FN_WITH_KW_(pyopencv_cv_equalizeHist, 0), "equalizeHist(src[, dst]) -> dst\n.   @brief Equalizes the histogram of a grayscale image.\n.   \n.   The function equalizes the histogram of the input image using the following algorithm:\n.   \n.   - Calculate the histogram \\f$H\\f$ for src .\n.   - Normalize the histogram so that the sum of histogram bins is 255.\n.   - Compute the integral of the histogram:\n.   \\f[H'_i =  \\sum _{0  \\le j < i} H(j)\\f]\n.   - Transform the image using \\f$H'\\f$ as a look-up table: \\f$\\texttt{dst}(x,y) = H'(\\texttt{src}(x,y))\\f$\n.   \n.   The algorithm normalizes the brightness and increases the contrast of the image.\n.   \n.   @param src Source 8-bit single channel image.\n.   @param dst Destination image of the same size and type as src ."},
    {"erode", CV_PY_FN_WITH_KW_(pyopencv_cv_erode, 0), "erode(src, kernel[, dst[, anchor[, iterations[, borderType[, borderValue]]]]]) -> dst\n.   @brief Erodes an image by using a specific structuring element.\n.   \n.   The function erodes the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the minimum is taken:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\min _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   The function supports the in-place mode. Erosion can be applied several ( iterations ) times. In\n.   case of multi-channel images, each channel is processed independently.\n.   \n.   @param src input image; the number of channels can be arbitrary, but the depth should be one of\n.   CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param kernel structuring element used for erosion; if `element=Mat()`, a `3 x 3` rectangular\n.   structuring element is used. Kernel can be created using #getStructuringElement.\n.   @param anchor position of the anchor within the element; default value (-1, -1) means that the\n.   anchor is at the element center.\n.   @param iterations number of times erosion is applied.\n.   @param borderType pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @param borderValue border value in case of a constant border\n.   @sa  dilate, morphologyEx, getStructuringElement"},
    {"estimateAffine2D", CV_PY_FN_WITH_KW_(pyopencv_cv_estimateAffine2D, 0), "estimateAffine2D(from_, to[, inliers[, method[, ransacReprojThreshold[, maxIters[, confidence[, refineIters]]]]]]) -> retval, inliers\n.   @brief Computes an optimal affine transformation between two 2D point sets.\n.   \n.   It computes\n.   \\f[\n.   \\begin{bmatrix}\n.   x\\\\\n.   y\\\\\n.   \\end{bmatrix}\n.   =\n.   \\begin{bmatrix}\n.   a_{11} & a_{12}\\\\\n.   a_{21} & a_{22}\\\\\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   X\\\\\n.   Y\\\\\n.   \\end{bmatrix}\n.   +\n.   \\begin{bmatrix}\n.   b_1\\\\\n.   b_2\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   \n.   @param from First input 2D point set containing \\f$(X,Y)\\f$.\n.   @param to Second input 2D point set containing \\f$(x,y)\\f$.\n.   @param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).\n.   @param method Robust method used to compute transformation. The following methods are possible:\n.   -   @ref RANSAC - RANSAC-based robust method\n.   -   @ref LMEDS - Least-Median robust method\n.   RANSAC is the default method.\n.   @param ransacReprojThreshold Maximum reprojection error in the RANSAC algorithm to consider\n.   a point as an inlier. Applies only to RANSAC.\n.   @param maxIters The maximum number of robust method iterations.\n.   @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.   between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.   significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.   @param refineIters Maximum number of iterations of refining algorithm (Levenberg-Marquardt).\n.   Passing 0 will disable refining, so the output matrix will be output of robust method.\n.   \n.   @return Output 2D affine transformation matrix \\f$2 \\times 3\\f$ or empty matrix if transformation\n.   could not be estimated. The returned matrix has the following form:\n.   \\f[\n.   \\begin{bmatrix}\n.   a_{11} & a_{12} & b_1\\\\\n.   a_{21} & a_{22} & b_2\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   \n.   The function estimates an optimal 2D affine transformation between two 2D point sets using the\n.   selected robust algorithm.\n.   \n.   The computed transformation is then refined further (using only inliers) with the\n.   Levenberg-Marquardt method to reduce the re-projection error even more.\n.   \n.   @note\n.   The RANSAC method can handle practically any ratio of outliers but needs a threshold to\n.   distinguish inliers from outliers. The method LMeDS does not need any threshold but it works\n.   correctly only when there are more than 50% of inliers.\n.   \n.   @sa estimateAffinePartial2D, getAffineTransform\n\n\n\nestimateAffine2D(pts1, pts2, params[, inliers]) -> retval, inliers\n."},
    {"estimateAffine3D", CV_PY_FN_WITH_KW_(pyopencv_cv_estimateAffine3D, 0), "estimateAffine3D(src, dst[, out[, inliers[, ransacThreshold[, confidence]]]]) -> retval, out, inliers\n.   @brief Computes an optimal affine transformation between two 3D point sets.\n.   \n.   It computes\n.   \\f[\n.   \\begin{bmatrix}\n.   x\\\\\n.   y\\\\\n.   z\\\\\n.   \\end{bmatrix}\n.   =\n.   \\begin{bmatrix}\n.   a_{11} & a_{12} & a_{13}\\\\\n.   a_{21} & a_{22} & a_{23}\\\\\n.   a_{31} & a_{32} & a_{33}\\\\\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   X\\\\\n.   Y\\\\\n.   Z\\\\\n.   \\end{bmatrix}\n.   +\n.   \\begin{bmatrix}\n.   b_1\\\\\n.   b_2\\\\\n.   b_3\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   \n.   @param src First input 3D point set containing \\f$(X,Y,Z)\\f$.\n.   @param dst Second input 3D point set containing \\f$(x,y,z)\\f$.\n.   @param out Output 3D affine transformation matrix \\f$3 \\times 4\\f$ of the form\n.   \\f[\n.   \\begin{bmatrix}\n.   a_{11} & a_{12} & a_{13} & b_1\\\\\n.   a_{21} & a_{22} & a_{23} & b_2\\\\\n.   a_{31} & a_{32} & a_{33} & b_3\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   @param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).\n.   @param ransacThreshold Maximum reprojection error in the RANSAC algorithm to consider a point as\n.   an inlier.\n.   @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.   between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.   significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.   \n.   The function estimates an optimal 3D affine transformation between two 3D point sets using the\n.   RANSAC algorithm.\n\n\n\nestimateAffine3D(src, dst[, force_rotation]) -> retval, scale\n.   @brief Computes an optimal affine transformation between two 3D point sets.\n.   \n.   It computes \\f$R,s,t\\f$ minimizing \\f$\\sum{i} dst_i - c \\cdot R \\cdot src_i \\f$\n.   where \\f$R\\f$ is a 3x3 rotation matrix, \\f$t\\f$ is a 3x1 translation vector and \\f$s\\f$ is a\n.   scalar size value. This is an implementation of the algorithm by Umeyama \\cite umeyama1991least .\n.   The estimated affine transform has a homogeneous scale which is a subclass of affine\n.   transformations with 7 degrees of freedom. The paired point sets need to comprise at least 3\n.   points each.\n.   \n.   @param src First input 3D point set.\n.   @param dst Second input 3D point set.\n.   @param scale If null is passed, the scale parameter c will be assumed to be 1.0.\n.   Else the pointed-to variable will be set to the optimal scale.\n.   @param force_rotation If true, the returned rotation will never be a reflection.\n.   This might be unwanted, e.g. when optimizing a transform between a right- and a\n.   left-handed coordinate system.\n.   @return 3D affine transformation matrix \\f$3 \\times 4\\f$ of the form\n.   \\f[T =\n.   \\begin{bmatrix}\n.   R & t\\\\\n.   \\end{bmatrix}\n.   \\f]"},
    {"estimateAffinePartial2D", CV_PY_FN_WITH_KW_(pyopencv_cv_estimateAffinePartial2D, 0), "estimateAffinePartial2D(from_, to[, inliers[, method[, ransacReprojThreshold[, maxIters[, confidence[, refineIters]]]]]]) -> retval, inliers\n.   @brief Computes an optimal limited affine transformation with 4 degrees of freedom between\n.   two 2D point sets.\n.   \n.   @param from First input 2D point set.\n.   @param to Second input 2D point set.\n.   @param inliers Output vector indicating which points are inliers.\n.   @param method Robust method used to compute transformation. The following methods are possible:\n.   -   @ref RANSAC - RANSAC-based robust method\n.   -   @ref LMEDS - Least-Median robust method\n.   RANSAC is the default method.\n.   @param ransacReprojThreshold Maximum reprojection error in the RANSAC algorithm to consider\n.   a point as an inlier. Applies only to RANSAC.\n.   @param maxIters The maximum number of robust method iterations.\n.   @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.   between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.   significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.   @param refineIters Maximum number of iterations of refining algorithm (Levenberg-Marquardt).\n.   Passing 0 will disable refining, so the output matrix will be output of robust method.\n.   \n.   @return Output 2D affine transformation (4 degrees of freedom) matrix \\f$2 \\times 3\\f$ or\n.   empty matrix if transformation could not be estimated.\n.   \n.   The function estimates an optimal 2D affine transformation with 4 degrees of freedom limited to\n.   combinations of translation, rotation, and uniform scaling. Uses the selected algorithm for robust\n.   estimation.\n.   \n.   The computed transformation is then refined further (using only inliers) with the\n.   Levenberg-Marquardt method to reduce the re-projection error even more.\n.   \n.   Estimated transformation matrix is:\n.   \\f[ \\begin{bmatrix} \\cos(\\theta) \\cdot s & -\\sin(\\theta) \\cdot s & t_x \\\\\n.                   \\sin(\\theta) \\cdot s & \\cos(\\theta) \\cdot s & t_y\n.   \\end{bmatrix} \\f]\n.   Where \\f$ \\theta \\f$ is the rotation angle, \\f$ s \\f$ the scaling factor and \\f$ t_x, t_y \\f$ are\n.   translations in \\f$ x, y \\f$ axes respectively.\n.   \n.   @note\n.   The RANSAC method can handle practically any ratio of outliers but need a threshold to\n.   distinguish inliers from outliers. The method LMeDS does not need any threshold but it works\n.   correctly only when there are more than 50% of inliers.\n.   \n.   @sa estimateAffine2D, getAffineTransform"},
    {"estimateChessboardSharpness", CV_PY_FN_WITH_KW_(pyopencv_cv_estimateChessboardSharpness, 0), "estimateChessboardSharpness(image, patternSize, corners[, rise_distance[, vertical[, sharpness]]]) -> retval, sharpness\n.   @brief Estimates the sharpness of a detected chessboard.\n.   \n.   Image sharpness, as well as brightness, are a critical parameter for accuracte\n.   camera calibration. For accessing these parameters for filtering out\n.   problematic calibraiton images, this method calculates edge profiles by traveling from\n.   black to white chessboard cell centers. Based on this, the number of pixels is\n.   calculated required to transit from black to white. This width of the\n.   transition area is a good indication of how sharp the chessboard is imaged\n.   and should be below ~3.0 pixels.\n.   \n.   @param image Gray image used to find chessboard corners\n.   @param patternSize Size of a found chessboard pattern\n.   @param corners Corners found by #findChessboardCornersSB\n.   @param rise_distance Rise distance 0.8 means 10% ... 90% of the final signal strength\n.   @param vertical By default edge responses for horizontal lines are calculated\n.   @param sharpness Optional output array with a sharpness value for calculated edge responses (see description)\n.   \n.   The optional sharpness array is of type CV_32FC1 and has for each calculated\n.   profile one row with the following five entries:\n.   * 0 = x coordinate of the underlying edge in the image\n.   * 1 = y coordinate of the underlying edge in the image\n.   * 2 = width of the transition area (sharpness)\n.   * 3 = signal strength in the black cell (min brightness)\n.   * 4 = signal strength in the white cell (max brightness)\n.   \n.   @return Scalar(average sharpness, average min brightness, average max brightness,0)"},
    {"estimateTranslation3D", CV_PY_FN_WITH_KW_(pyopencv_cv_estimateTranslation3D, 0), "estimateTranslation3D(src, dst[, out[, inliers[, ransacThreshold[, confidence]]]]) -> retval, out, inliers\n.   @brief Computes an optimal translation between two 3D point sets.\n.    *\n.    * It computes\n.    * \\f[\n.    * \\begin{bmatrix}\n.    * x\\\\\n.    * y\\\\\n.    * z\\\\\n.    * \\end{bmatrix}\n.    * =\n.    * \\begin{bmatrix}\n.    * X\\\\\n.    * Y\\\\\n.    * Z\\\\\n.    * \\end{bmatrix}\n.    * +\n.    * \\begin{bmatrix}\n.    * b_1\\\\\n.    * b_2\\\\\n.    * b_3\\\\\n.    * \\end{bmatrix}\n.    * \\f]\n.    *\n.    * @param src First input 3D point set containing \\f$(X,Y,Z)\\f$.\n.    * @param dst Second input 3D point set containing \\f$(x,y,z)\\f$.\n.    * @param out Output 3D translation vector \\f$3 \\times 1\\f$ of the form\n.    * \\f[\n.    * \\begin{bmatrix}\n.    * b_1 \\\\\n.    * b_2 \\\\\n.    * b_3 \\\\\n.    * \\end{bmatrix}\n.    * \\f]\n.    * @param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).\n.    * @param ransacThreshold Maximum reprojection error in the RANSAC algorithm to consider a point as\n.    * an inlier.\n.    * @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.    * between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.    * significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.    *\n.    * The function estimates an optimal 3D translation between two 3D point sets using the\n.    * RANSAC algorithm.\n.   *"},
    {"exp", CV_PY_FN_WITH_KW_(pyopencv_cv_exp, 0), "exp(src[, dst]) -> dst\n.   @brief Calculates the exponent of every array element.\n.   \n.   The function cv::exp calculates the exponent of every element of the input\n.   array:\n.   \\f[\\texttt{dst} [I] = e^{ src(I) }\\f]\n.   \n.   The maximum relative error is about 7e-6 for single-precision input and\n.   less than 1e-10 for double-precision input. Currently, the function\n.   converts denormalized values to zeros on output. Special values (NaN,\n.   Inf) are not handled.\n.   @param src input array.\n.   @param dst output array of the same size and type as src.\n.   @sa log, cartToPolar, polarToCart, phase, pow, sqrt, magnitude"},
    {"extractChannel", CV_PY_FN_WITH_KW_(pyopencv_cv_extractChannel, 0), "extractChannel(src, coi[, dst]) -> dst\n.   @brief Extracts a single channel from src (coi is 0-based index)\n.   @param src input array\n.   @param dst output array\n.   @param coi index of channel to extract\n.   @sa mixChannels, split"},
    {"fastAtan2", CV_PY_FN_WITH_KW_(pyopencv_cv_fastAtan2, 0), "fastAtan2(y, x) -> retval\n.   @brief Calculates the angle of a 2D vector in degrees.\n.   \n.    The function fastAtan2 calculates the full-range angle of an input 2D vector. The angle is measured\n.    in degrees and varies from 0 to 360 degrees. The accuracy is about 0.3 degrees.\n.    @param x x-coordinate of the vector.\n.    @param y y-coordinate of the vector."},
    {"fastNlMeansDenoising", CV_PY_FN_WITH_KW_(pyopencv_cv_fastNlMeansDenoising, 0), "fastNlMeansDenoising(src[, dst[, h[, templateWindowSize[, searchWindowSize]]]]) -> dst\n.   @brief Perform image denoising using Non-local Means Denoising algorithm\n.   <http://www.ipol.im/pub/algo/bcm_non_local_means_denoising/> with several computational\n.   optimizations. Noise expected to be a gaussian white noise\n.   \n.   @param src Input 8-bit 1-channel, 2-channel, 3-channel or 4-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength. Big h value perfectly removes noise but also\n.   removes image details, smaller h value preserves details but also preserves some noise\n.   \n.   This function expected to be applied to grayscale images. For colored images look at\n.   fastNlMeansDenoisingColored. Advanced usage of this functions can be manual denoising of colored\n.   image in different colorspaces. Such approach is used in fastNlMeansDenoisingColored by converting\n.   image to CIELAB colorspace and then separately denoise L and AB components with different h\n.   parameter.\n\n\n\nfastNlMeansDenoising(src, h[, dst[, templateWindowSize[, searchWindowSize[, normType]]]]) -> dst\n.   @brief Perform image denoising using Non-local Means Denoising algorithm\n.   <http://www.ipol.im/pub/algo/bcm_non_local_means_denoising/> with several computational\n.   optimizations. Noise expected to be a gaussian white noise\n.   \n.   @param src Input 8-bit or 16-bit (only with NORM_L1) 1-channel,\n.   2-channel, 3-channel or 4-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Array of parameters regulating filter strength, either one\n.   parameter applied to all channels or one per channel in dst. Big h value\n.   perfectly removes noise but also removes image details, smaller h\n.   value preserves details but also preserves some noise\n.   @param normType Type of norm used for weight calculation. Can be either NORM_L2 or NORM_L1\n.   \n.   This function expected to be applied to grayscale images. For colored images look at\n.   fastNlMeansDenoisingColored. Advanced usage of this functions can be manual denoising of colored\n.   image in different colorspaces. Such approach is used in fastNlMeansDenoisingColored by converting\n.   image to CIELAB colorspace and then separately denoise L and AB components with different h\n.   parameter."},
    {"fastNlMeansDenoisingColored", CV_PY_FN_WITH_KW_(pyopencv_cv_fastNlMeansDenoisingColored, 0), "fastNlMeansDenoisingColored(src[, dst[, h[, hColor[, templateWindowSize[, searchWindowSize]]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for colored images\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength for luminance component. Bigger h value perfectly\n.   removes noise but also removes image details, smaller h value preserves details but also preserves\n.   some noise\n.   @param hColor The same as h but for color components. For most images value equals 10\n.   will be enough to remove colored noise and do not distort colors\n.   \n.   The function converts image to CIELAB colorspace and then separately denoise L and AB components\n.   with given h parameters using fastNlMeansDenoising function."},
    {"fastNlMeansDenoisingColoredMulti", CV_PY_FN_WITH_KW_(pyopencv_cv_fastNlMeansDenoisingColoredMulti, 0), "fastNlMeansDenoisingColoredMulti(srcImgs, imgToDenoiseIndex, temporalWindowSize[, dst[, h[, hColor[, templateWindowSize[, searchWindowSize]]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoisingMulti function for colored images sequences\n.   \n.   @param srcImgs Input 8-bit 3-channel images sequence. All images should have the same type and\n.   size.\n.   @param imgToDenoiseIndex Target image to denoise index in srcImgs sequence\n.   @param temporalWindowSize Number of surrounding images to use for target image denoising. Should\n.   be odd. Images from imgToDenoiseIndex - temporalWindowSize / 2 to\n.   imgToDenoiseIndex + temporalWindowSize / 2 from srcImgs will be used to denoise\n.   srcImgs[imgToDenoiseIndex] image.\n.   @param dst Output image with the same size and type as srcImgs images.\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength for luminance component. Bigger h value perfectly\n.   removes noise but also removes image details, smaller h value preserves details but also preserves\n.   some noise.\n.   @param hColor The same as h but for color components.\n.   \n.   The function converts images to CIELAB colorspace and then separately denoise L and AB components\n.   with given h parameters using fastNlMeansDenoisingMulti function."},
    {"fastNlMeansDenoisingMulti", CV_PY_FN_WITH_KW_(pyopencv_cv_fastNlMeansDenoisingMulti, 0), "fastNlMeansDenoisingMulti(srcImgs, imgToDenoiseIndex, temporalWindowSize[, dst[, h[, templateWindowSize[, searchWindowSize]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for images sequence where consecutive images have been\n.   captured in small period of time. For example video. This version of the function is for grayscale\n.   images or for manual manipulation with colorspaces. See @cite Buades2005DenoisingIS for more details\n.   (open access [here](https://static.aminer.org/pdf/PDF/000/317/196/spatio_temporal_wiener_filtering_of_image_sequences_using_a_parametric.pdf)).\n.   \n.   @param srcImgs Input 8-bit 1-channel, 2-channel, 3-channel or\n.   4-channel images sequence. All images should have the same type and\n.   size.\n.   @param imgToDenoiseIndex Target image to denoise index in srcImgs sequence\n.   @param temporalWindowSize Number of surrounding images to use for target image denoising. Should\n.   be odd. Images from imgToDenoiseIndex - temporalWindowSize / 2 to\n.   imgToDenoiseIndex + temporalWindowSize / 2 from srcImgs will be used to denoise\n.   srcImgs[imgToDenoiseIndex] image.\n.   @param dst Output image with the same size and type as srcImgs images.\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength. Bigger h value\n.   perfectly removes noise but also removes image details, smaller h\n.   value preserves details but also preserves some noise\n\n\n\nfastNlMeansDenoisingMulti(srcImgs, imgToDenoiseIndex, temporalWindowSize, h[, dst[, templateWindowSize[, searchWindowSize[, normType]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for images sequence where consecutive images have been\n.   captured in small period of time. For example video. This version of the function is for grayscale\n.   images or for manual manipulation with colorspaces. See @cite Buades2005DenoisingIS for more details\n.   (open access [here](https://static.aminer.org/pdf/PDF/000/317/196/spatio_temporal_wiener_filtering_of_image_sequences_using_a_parametric.pdf)).\n.   \n.   @param srcImgs Input 8-bit or 16-bit (only with NORM_L1) 1-channel,\n.   2-channel, 3-channel or 4-channel images sequence. All images should\n.   have the same type and size.\n.   @param imgToDenoiseIndex Target image to denoise index in srcImgs sequence\n.   @param temporalWindowSize Number of surrounding images to use for target image denoising. Should\n.   be odd. Images from imgToDenoiseIndex - temporalWindowSize / 2 to\n.   imgToDenoiseIndex + temporalWindowSize / 2 from srcImgs will be used to denoise\n.   srcImgs[imgToDenoiseIndex] image.\n.   @param dst Output image with the same size and type as srcImgs images.\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Array of parameters regulating filter strength, either one\n.   parameter applied to all channels or one per channel in dst. Big h value\n.   perfectly removes noise but also removes image details, smaller h\n.   value preserves details but also preserves some noise\n.   @param normType Type of norm used for weight calculation. Can be either NORM_L2 or NORM_L1"},
    {"fillConvexPoly", CV_PY_FN_WITH_KW_(pyopencv_cv_fillConvexPoly, 0), "fillConvexPoly(img, points, color[, lineType[, shift]]) -> img\n.   @brief Fills a convex polygon.\n.   \n.   The function cv::fillConvexPoly draws a filled convex polygon. This function is much faster than the\n.   function #fillPoly . It can fill not only convex polygons but any monotonic polygon without\n.   self-intersections, that is, a polygon whose contour intersects every horizontal line (scan line)\n.   twice at the most (though, its top-most and/or the bottom edge could be horizontal).\n.   \n.   @param img Image.\n.   @param points Polygon vertices.\n.   @param color Polygon color.\n.   @param lineType Type of the polygon boundaries. See #LineTypes\n.   @param shift Number of fractional bits in the vertex coordinates."},
    {"fillPoly", CV_PY_FN_WITH_KW_(pyopencv_cv_fillPoly, 0), "fillPoly(img, pts, color[, lineType[, shift[, offset]]]) -> img\n.   @brief Fills the area bounded by one or more polygons.\n.   \n.   The function cv::fillPoly fills an area bounded by several polygonal contours. The function can fill\n.   complex areas, for example, areas with holes, contours with self-intersections (some of their\n.   parts), and so forth.\n.   \n.   @param img Image.\n.   @param pts Array of polygons where each polygon is represented as an array of points.\n.   @param color Polygon color.\n.   @param lineType Type of the polygon boundaries. See #LineTypes\n.   @param shift Number of fractional bits in the vertex coordinates.\n.   @param offset Optional offset of all points of the contours."},
    {"filter2D", CV_PY_FN_WITH_KW_(pyopencv_cv_filter2D, 0), "filter2D(src, ddepth, kernel[, dst[, anchor[, delta[, borderType]]]]) -> dst\n.   @brief Convolves an image with the kernel.\n.   \n.   The function applies an arbitrary linear filter to an image. In-place operation is supported. When\n.   the aperture is partially outside the image, the function interpolates outlier pixel values\n.   according to the specified border mode.\n.   \n.   The function does actually compute correlation, not the convolution:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\sum _{ \\substack{0\\leq x' < \\texttt{kernel.cols}\\\\{0\\leq y' < \\texttt{kernel.rows}}}}  \\texttt{kernel} (x',y')* \\texttt{src} (x+x'- \\texttt{anchor.x} ,y+y'- \\texttt{anchor.y} )\\f]\n.   \n.   That is, the kernel is not mirrored around the anchor point. If you need a real convolution, flip\n.   the kernel using #flip and set the new anchor to `(kernel.cols - anchor.x - 1, kernel.rows -\n.   anchor.y - 1)`.\n.   \n.   The function uses the DFT-based algorithm in case of sufficiently large kernels (~`11 x 11` or\n.   larger) and the direct algorithm for small kernels.\n.   \n.   @param src input image.\n.   @param dst output image of the same size and the same number of channels as src.\n.   @param ddepth desired depth of the destination image, see @ref filter_depths \"combinations\"\n.   @param kernel convolution kernel (or rather a correlation kernel), a single-channel floating point\n.   matrix; if you want to apply different kernels to different channels, split the image into\n.   separate color planes using split and process them individually.\n.   @param anchor anchor of the kernel that indicates the relative position of a filtered point within\n.   the kernel; the anchor should lie within the kernel; default value (-1,-1) means that the anchor\n.   is at the kernel center.\n.   @param delta optional value added to the filtered pixels before storing them in dst.\n.   @param borderType pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  sepFilter2D, dft, matchTemplate"},
    {"filterHomographyDecompByVisibleRefpoints", CV_PY_FN_WITH_KW_(pyopencv_cv_filterHomographyDecompByVisibleRefpoints, 0), "filterHomographyDecompByVisibleRefpoints(rotations, normals, beforePoints, afterPoints[, possibleSolutions[, pointsMask]]) -> possibleSolutions\n.   @brief Filters homography decompositions based on additional information.\n.   \n.   @param rotations Vector of rotation matrices.\n.   @param normals Vector of plane normal matrices.\n.   @param beforePoints Vector of (rectified) visible reference points before the homography is applied\n.   @param afterPoints Vector of (rectified) visible reference points after the homography is applied\n.   @param possibleSolutions Vector of int indices representing the viable solution set after filtering\n.   @param pointsMask optional Mat/Vector of 8u type representing the mask for the inliers as given by the #findHomography function\n.   \n.   This function is intended to filter the output of the #decomposeHomographyMat based on additional\n.   information as described in @cite Malis2007 . The summary of the method: the #decomposeHomographyMat function\n.   returns 2 unique solutions and their \"opposites\" for a total of 4 solutions. If we have access to the\n.   sets of points visible in the camera frame before and after the homography transformation is applied,\n.   we can determine which are the true potential solutions and which are the opposites by verifying which\n.   homographies are consistent with all visible reference points being in front of the camera. The inputs\n.   are left unchanged; the filtered solution set is returned as indices into the existing one."},
    {"filterSpeckles", CV_PY_FN_WITH_KW_(pyopencv_cv_filterSpeckles, 0), "filterSpeckles(img, newVal, maxSpeckleSize, maxDiff[, buf]) -> img, buf\n.   @brief Filters off small noise blobs (speckles) in the disparity map\n.   \n.   @param img The input 16-bit signed disparity image\n.   @param newVal The disparity value used to paint-off the speckles\n.   @param maxSpeckleSize The maximum speckle size to consider it a speckle. Larger blobs are not\n.   affected by the algorithm\n.   @param maxDiff Maximum difference between neighbor disparity pixels to put them into the same\n.   blob. Note that since StereoBM, StereoSGBM and may be other algorithms return a fixed-point\n.   disparity map, where disparity values are multiplied by 16, this scale factor should be taken into\n.   account when specifying this parameter value.\n.   @param buf The optional temporary buffer to avoid memory allocation within the function."},
    {"find4QuadCornerSubpix", CV_PY_FN_WITH_KW_(pyopencv_cv_find4QuadCornerSubpix, 0), "find4QuadCornerSubpix(img, corners, region_size) -> retval, corners\n."},
    {"findChessboardCorners", CV_PY_FN_WITH_KW_(pyopencv_cv_findChessboardCorners, 0), "findChessboardCorners(image, patternSize[, corners[, flags]]) -> retval, corners\n.   @brief Finds the positions of internal corners of the chessboard.\n.   \n.   @param image Source chessboard view. It must be an 8-bit grayscale or color image.\n.   @param patternSize Number of inner corners per a chessboard row and column\n.   ( patternSize = cv::Size(points_per_row,points_per_colum) = cv::Size(columns,rows) ).\n.   @param corners Output array of detected corners.\n.   @param flags Various operation flags that can be zero or a combination of the following values:\n.   -   @ref CALIB_CB_ADAPTIVE_THRESH Use adaptive thresholding to convert the image to black\n.   and white, rather than a fixed threshold level (computed from the average image brightness).\n.   -   @ref CALIB_CB_NORMALIZE_IMAGE Normalize the image gamma with #equalizeHist before\n.   applying fixed or adaptive thresholding.\n.   -   @ref CALIB_CB_FILTER_QUADS Use additional criteria (like contour area, perimeter,\n.   square-like shape) to filter out false quads extracted at the contour retrieval stage.\n.   -   @ref CALIB_CB_FAST_CHECK Run a fast check on the image that looks for chessboard corners,\n.   and shortcut the call if none is found. This can drastically speed up the call in the\n.   degenerate condition when no chessboard is observed.\n.   -   @ref CALIB_CB_PLAIN All other flags are ignored. The input image is taken as is.\n.   No image processing is done to improve to find the checkerboard. This has the effect of speeding up the\n.   execution of the function but could lead to not recognizing the checkerboard if the image\n.   is not previously binarized in the appropriate manner.\n.   \n.   The function attempts to determine whether the input image is a view of the chessboard pattern and\n.   locate the internal chessboard corners. The function returns a non-zero value if all of the corners\n.   are found and they are placed in a certain order (row by row, left to right in every row).\n.   Otherwise, if the function fails to find all the corners or reorder them, it returns 0. For example,\n.   a regular chessboard has 8 x 8 squares and 7 x 7 internal corners, that is, points where the black\n.   squares touch each other. The detected coordinates are approximate, and to determine their positions\n.   more accurately, the function calls #cornerSubPix. You also may use the function #cornerSubPix with\n.   different parameters if returned coordinates are not accurate enough.\n.   \n.   Sample usage of detecting and drawing chessboard corners: :\n.   @code\n.       Size patternsize(8,6); //interior number of corners\n.       Mat gray = ....; //source image\n.       vector<Point2f> corners; //this will be filled by the detected corners\n.   \n.       //CALIB_CB_FAST_CHECK saves a lot of time on images\n.       //that do not contain any chessboard corners\n.       bool patternfound = findChessboardCorners(gray, patternsize, corners,\n.               CALIB_CB_ADAPTIVE_THRESH + CALIB_CB_NORMALIZE_IMAGE\n.               + CALIB_CB_FAST_CHECK);\n.   \n.       if(patternfound)\n.         cornerSubPix(gray, corners, Size(11, 11), Size(-1, -1),\n.           TermCriteria(CV_TERMCRIT_EPS + CV_TERMCRIT_ITER, 30, 0.1));\n.   \n.       drawChessboardCorners(img, patternsize, Mat(corners), patternfound);\n.   @endcode\n.   @note The function requires white space (like a square-thick border, the wider the better) around\n.   the board to make the detection more robust in various environments. Otherwise, if there is no\n.   border and the background is dark, the outer black squares cannot be segmented properly and so the\n.   square grouping and ordering algorithm fails.\n.   \n.   Use the `gen_pattern.py` Python script (@ref tutorial_camera_calibration_pattern)\n.   to create the desired checkerboard pattern."},
    {"findChessboardCornersSB", CV_PY_FN_WITH_KW_(pyopencv_cv_findChessboardCornersSB, 0), "findChessboardCornersSB(image, patternSize[, corners[, flags]]) -> retval, corners\n.   @overload"},
    {"findChessboardCornersSBWithMeta", CV_PY_FN_WITH_KW_(pyopencv_cv_findChessboardCornersSBWithMeta, 0), "findChessboardCornersSBWithMeta(image, patternSize, flags[, corners[, meta]]) -> retval, corners, meta\n.   @brief Finds the positions of internal corners of the chessboard using a sector based approach.\n.   \n.   @param image Source chessboard view. It must be an 8-bit grayscale or color image.\n.   @param patternSize Number of inner corners per a chessboard row and column\n.   ( patternSize = cv::Size(points_per_row,points_per_colum) = cv::Size(columns,rows) ).\n.   @param corners Output array of detected corners.\n.   @param flags Various operation flags that can be zero or a combination of the following values:\n.   -   @ref CALIB_CB_NORMALIZE_IMAGE Normalize the image gamma with equalizeHist before detection.\n.   -   @ref CALIB_CB_EXHAUSTIVE Run an exhaustive search to improve detection rate.\n.   -   @ref CALIB_CB_ACCURACY Up sample input image to improve sub-pixel accuracy due to aliasing effects.\n.   -   @ref CALIB_CB_LARGER The detected pattern is allowed to be larger than patternSize (see description).\n.   -   @ref CALIB_CB_MARKER The detected pattern must have a marker (see description).\n.   This should be used if an accurate camera calibration is required.\n.   @param meta Optional output arrray of detected corners (CV_8UC1 and size = cv::Size(columns,rows)).\n.   Each entry stands for one corner of the pattern and can have one of the following values:\n.   -   0 = no meta data attached\n.   -   1 = left-top corner of a black cell\n.   -   2 = left-top corner of a white cell\n.   -   3 = left-top corner of a black cell with a white marker dot\n.   -   4 = left-top corner of a white cell with a black marker dot (pattern origin in case of markers otherwise first corner)\n.   \n.   The function is analog to #findChessboardCorners but uses a localized radon\n.   transformation approximated by box filters being more robust to all sort of\n.   noise, faster on larger images and is able to directly return the sub-pixel\n.   position of the internal chessboard corners. The Method is based on the paper\n.   @cite duda2018 \"Accurate Detection and Localization of Checkerboard Corners for\n.   Calibration\" demonstrating that the returned sub-pixel positions are more\n.   accurate than the one returned by cornerSubPix allowing a precise camera\n.   calibration for demanding applications.\n.   \n.   In the case, the flags @ref CALIB_CB_LARGER or @ref CALIB_CB_MARKER are given,\n.   the result can be recovered from the optional meta array. Both flags are\n.   helpful to use calibration patterns exceeding the field of view of the camera.\n.   These oversized patterns allow more accurate calibrations as corners can be\n.   utilized, which are as close as possible to the image borders.  For a\n.   consistent coordinate system across all images, the optional marker (see image\n.   below) can be used to move the origin of the board to the location where the\n.   black circle is located.\n.   \n.   @note The function requires a white boarder with roughly the same width as one\n.   of the checkerboard fields around the whole board to improve the detection in\n.   various environments. In addition, because of the localized radon\n.   transformation it is beneficial to use round corners for the field corners\n.   which are located on the outside of the board. The following figure illustrates\n.   a sample checkerboard optimized for the detection. However, any other checkerboard\n.   can be used as well.\n.   \n.   Use the `gen_pattern.py` Python script (@ref tutorial_camera_calibration_pattern)\n.   to create the corresponding checkerboard pattern:\n.   \\image html pics/checkerboard_radon.png width=60%"},
    {"findCirclesGrid", CV_PY_FN_WITH_KW_(pyopencv_cv_findCirclesGrid, 0), "findCirclesGrid(image, patternSize, flags, blobDetector, parameters[, centers]) -> retval, centers\n.   @brief Finds centers in the grid of circles.\n.   \n.   @param image grid view of input circles; it must be an 8-bit grayscale or color image.\n.   @param patternSize number of circles per row and column\n.   ( patternSize = Size(points_per_row, points_per_colum) ).\n.   @param centers output array of detected centers.\n.   @param flags various operation flags that can be one of the following values:\n.   -   @ref CALIB_CB_SYMMETRIC_GRID uses symmetric pattern of circles.\n.   -   @ref CALIB_CB_ASYMMETRIC_GRID uses asymmetric pattern of circles.\n.   -   @ref CALIB_CB_CLUSTERING uses a special algorithm for grid detection. It is more robust to\n.   perspective distortions but much more sensitive to background clutter.\n.   @param blobDetector feature detector that finds blobs like dark circles on light background.\n.                       If `blobDetector` is NULL then `image` represents Point2f array of candidates.\n.   @param parameters struct for finding circles in a grid pattern.\n.   \n.   The function attempts to determine whether the input image contains a grid of circles. If it is, the\n.   function locates centers of the circles. The function returns a non-zero value if all of the centers\n.   have been found and they have been placed in a certain order (row by row, left to right in every\n.   row). Otherwise, if the function fails to find all the corners or reorder them, it returns 0.\n.   \n.   Sample usage of detecting and drawing the centers of circles: :\n.   @code\n.       Size patternsize(7,7); //number of centers\n.       Mat gray = ...; //source image\n.       vector<Point2f> centers; //this will be filled by the detected centers\n.   \n.       bool patternfound = findCirclesGrid(gray, patternsize, centers);\n.   \n.       drawChessboardCorners(img, patternsize, Mat(centers), patternfound);\n.   @endcode\n.   @note The function requires white space (like a square-thick border, the wider the better) around\n.   the board to make the detection more robust in various environments.\n\n\n\nfindCirclesGrid(image, patternSize[, centers[, flags[, blobDetector]]]) -> retval, centers\n.   @overload"},
    {"findContours", CV_PY_FN_WITH_KW_(pyopencv_cv_findContours, 0), "findContours(image, mode, method[, contours[, hierarchy[, offset]]]) -> contours, hierarchy\n.   @brief Finds contours in a binary image.\n.   \n.   The function retrieves contours from the binary image using the algorithm @cite Suzuki85 . The contours\n.   are a useful tool for shape analysis and object detection and recognition. See squares.cpp in the\n.   OpenCV sample directory.\n.   @note Since opencv 3.2 source image is not modified by this function.\n.   \n.   @param image Source, an 8-bit single-channel image. Non-zero pixels are treated as 1's. Zero\n.   pixels remain 0's, so the image is treated as binary . You can use #compare, #inRange, #threshold ,\n.   #adaptiveThreshold, #Canny, and others to create a binary image out of a grayscale or color one.\n.   If mode equals to #RETR_CCOMP or #RETR_FLOODFILL, the input can also be a 32-bit integer image of labels (CV_32SC1).\n.   @param contours Detected contours. Each contour is stored as a vector of points (e.g.\n.   std::vector<std::vector<cv::Point> >).\n.   @param hierarchy Optional output vector (e.g. std::vector<cv::Vec4i>), containing information about the image topology. It has\n.   as many elements as the number of contours. For each i-th contour contours[i], the elements\n.   hierarchy[i][0] , hierarchy[i][1] , hierarchy[i][2] , and hierarchy[i][3] are set to 0-based indices\n.   in contours of the next and previous contours at the same hierarchical level, the first child\n.   contour and the parent contour, respectively. If for the contour i there are no next, previous,\n.   parent, or nested contours, the corresponding elements of hierarchy[i] will be negative.\n.   @note In Python, hierarchy is nested inside a top level array. Use hierarchy[0][i] to access hierarchical elements of i-th contour.\n.   @param mode Contour retrieval mode, see #RetrievalModes\n.   @param method Contour approximation method, see #ContourApproximationModes\n.   @param offset Optional offset by which every contour point is shifted. This is useful if the\n.   contours are extracted from the image ROI and then they should be analyzed in the whole image\n.   context."},
    {"findContoursLinkRuns", CV_PY_FN_WITH_KW_(pyopencv_cv_findContoursLinkRuns, 0), "findContoursLinkRuns(image[, contours[, hierarchy]]) -> contours, hierarchy\n.   @overload\n\n\n\nfindContoursLinkRuns(image[, contours]) -> contours\n."},
    {"findEssentialMat", CV_PY_FN_WITH_KW_(pyopencv_cv_findEssentialMat, 0), "findEssentialMat(points1, points2, cameraMatrix[, method[, prob[, threshold[, maxIters[, mask]]]]]) -> retval, mask\n.   @brief Calculates an essential matrix from the corresponding points in two images.\n.   \n.   @param points1 Array of N (N \\>= 5) 2D points from the first image. The point coordinates should\n.   be floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1.\n.   @param cameraMatrix Camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   Note that this function assumes that points1 and points2 are feature points from cameras with the\n.   same camera intrinsic matrix. If this assumption does not hold for your use case, use another\n.   function overload or #undistortPoints with `P = cv::NoArray()` for both cameras to transform image\n.   points to normalized image coordinates, which are valid for the identity camera intrinsic matrix.\n.   When passing these coordinates, pass the identity matrix for this parameter.\n.   @param method Method for computing an essential matrix.\n.   -   @ref RANSAC for the RANSAC algorithm.\n.   -   @ref LMEDS for the LMedS algorithm.\n.   @param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of\n.   confidence (probability) that the estimated matrix is correct.\n.   @param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param mask Output array of N elements, every element of which is set to 0 for outliers and to 1\n.   for the other points. The array is computed only in the RANSAC and LMedS methods.\n.   @param maxIters The maximum number of robust method iterations.\n.   \n.   This function estimates essential matrix based on the five-point algorithm solver in @cite Nister03 .\n.   @cite SteweniusCFS is also a related. The epipolar geometry is described by the following equation:\n.   \n.   \\f[[p_2; 1]^T K^{-T} E K^{-1} [p_1; 1] = 0\\f]\n.   \n.   where \\f$E\\f$ is an essential matrix, \\f$p_1\\f$ and \\f$p_2\\f$ are corresponding points in the first and the\n.   second images, respectively. The result of this function may be passed further to\n.   #decomposeEssentialMat or #recoverPose to recover the relative pose between cameras.\n\n\n\nfindEssentialMat(points1, points2[, focal[, pp[, method[, prob[, threshold[, maxIters[, mask]]]]]]]) -> retval, mask\n.   @overload\n.   @param points1 Array of N (N \\>= 5) 2D points from the first image. The point coordinates should\n.   be floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param focal focal length of the camera. Note that this function assumes that points1 and points2\n.   are feature points from cameras with same focal length and principal point.\n.   @param pp principal point of the camera.\n.   @param method Method for computing a fundamental matrix.\n.   -   @ref RANSAC for the RANSAC algorithm.\n.   -   @ref LMEDS for the LMedS algorithm.\n.   @param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of\n.   confidence (probability) that the estimated matrix is correct.\n.   @param mask Output array of N elements, every element of which is set to 0 for outliers and to 1\n.   for the other points. The array is computed only in the RANSAC and LMedS methods.\n.   @param maxIters The maximum number of robust method iterations.\n.   \n.   This function differs from the one above that it computes camera intrinsic matrix from focal length and\n.   principal point:\n.   \n.   \\f[A =\n.   \\begin{bmatrix}\n.   f & 0 & x_{pp}  \\\\\n.   0 & f & y_{pp}  \\\\\n.   0 & 0 & 1\n.   \\end{bmatrix}\\f]\n\n\n\nfindEssentialMat(points1, points2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2[, method[, prob[, threshold[, mask]]]]) -> retval, mask\n.   @brief Calculates an essential matrix from the corresponding points in two images from potentially two different cameras.\n.   \n.   @param points1 Array of N (N \\>= 5) 2D points from the first image. The point coordinates should\n.   be floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1.\n.   @param cameraMatrix1 Camera matrix for the first camera \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param cameraMatrix2 Camera matrix for the second camera \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs1 Input vector of distortion coefficients for the first camera\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param distCoeffs2 Input vector of distortion coefficients for the second camera\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param method Method for computing an essential matrix.\n.   -   @ref RANSAC for the RANSAC algorithm.\n.   -   @ref LMEDS for the LMedS algorithm.\n.   @param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of\n.   confidence (probability) that the estimated matrix is correct.\n.   @param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param mask Output array of N elements, every element of which is set to 0 for outliers and to 1\n.   for the other points. The array is computed only in the RANSAC and LMedS methods.\n.   \n.   This function estimates essential matrix based on the five-point algorithm solver in @cite Nister03 .\n.   @cite SteweniusCFS is also a related. The epipolar geometry is described by the following equation:\n.   \n.   \\f[[p_2; 1]^T K^{-T} E K^{-1} [p_1; 1] = 0\\f]\n.   \n.   where \\f$E\\f$ is an essential matrix, \\f$p_1\\f$ and \\f$p_2\\f$ are corresponding points in the first and the\n.   second images, respectively. The result of this function may be passed further to\n.   #decomposeEssentialMat or  #recoverPose to recover the relative pose between cameras.\n\n\n\nfindEssentialMat(points1, points2, cameraMatrix1, cameraMatrix2, dist_coeff1, dist_coeff2, params[, mask]) -> retval, mask\n."},
    {"findFundamentalMat", CV_PY_FN_WITH_KW_(pyopencv_cv_findFundamentalMat, 0), "findFundamentalMat(points1, points2, method, ransacReprojThreshold, confidence, maxIters[, mask]) -> retval, mask\n.   @brief Calculates a fundamental matrix from the corresponding points in two images.\n.   \n.   @param points1 Array of N points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param method Method for computing a fundamental matrix.\n.   -   @ref FM_7POINT for a 7-point algorithm. \\f$N = 7\\f$\n.   -   @ref FM_8POINT for an 8-point algorithm. \\f$N \\ge 8\\f$\n.   -   @ref FM_RANSAC for the RANSAC algorithm. \\f$N \\ge 8\\f$\n.   -   @ref FM_LMEDS for the LMedS algorithm. \\f$N \\ge 8\\f$\n.   @param ransacReprojThreshold Parameter used only for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param confidence Parameter used for the RANSAC and LMedS methods only. It specifies a desirable level\n.   of confidence (probability) that the estimated matrix is correct.\n.   @param[out] mask optional output mask\n.   @param maxIters The maximum number of robust method iterations.\n.   \n.   The epipolar geometry is described by the following equation:\n.   \n.   \\f[[p_2; 1]^T F [p_1; 1] = 0\\f]\n.   \n.   where \\f$F\\f$ is a fundamental matrix, \\f$p_1\\f$ and \\f$p_2\\f$ are corresponding points in the first and the\n.   second images, respectively.\n.   \n.   The function calculates the fundamental matrix using one of four methods listed above and returns\n.   the found fundamental matrix. Normally just one matrix is found. But in case of the 7-point\n.   algorithm, the function may return up to 3 solutions ( \\f$9 \\times 3\\f$ matrix that stores all 3\n.   matrices sequentially).\n.   \n.   The calculated fundamental matrix may be passed further to #computeCorrespondEpilines that finds the\n.   epipolar lines corresponding to the specified points. It can also be passed to\n.   #stereoRectifyUncalibrated to compute the rectification transformation. :\n.   @code\n.       // Example. Estimation of fundamental matrix using the RANSAC algorithm\n.       int point_count = 100;\n.       vector<Point2f> points1(point_count);\n.       vector<Point2f> points2(point_count);\n.   \n.       // initialize the points here ...\n.       for( int i = 0; i < point_count; i++ )\n.       {\n.           points1[i] = ...;\n.           points2[i] = ...;\n.       }\n.   \n.       Mat fundamental_matrix =\n.        findFundamentalMat(points1, points2, FM_RANSAC, 3, 0.99);\n.   @endcode\n\n\n\nfindFundamentalMat(points1, points2[, method[, ransacReprojThreshold[, confidence[, mask]]]]) -> retval, mask\n.   @overload\n\n\n\nfindFundamentalMat(points1, points2, params[, mask]) -> retval, mask\n.   @overload"},
    {"findHomography", CV_PY_FN_WITH_KW_(pyopencv_cv_findHomography, 0), "findHomography(srcPoints, dstPoints[, method[, ransacReprojThreshold[, mask[, maxIters[, confidence]]]]]) -> retval, mask\n.   @brief Finds a perspective transformation between two planes.\n.   \n.   @param srcPoints Coordinates of the points in the original plane, a matrix of the type CV_32FC2\n.   or vector\\<Point2f\\> .\n.   @param dstPoints Coordinates of the points in the target plane, a matrix of the type CV_32FC2 or\n.   a vector\\<Point2f\\> .\n.   @param method Method used to compute a homography matrix. The following methods are possible:\n.   -   **0** - a regular method using all the points, i.e., the least squares method\n.   -   @ref RANSAC - RANSAC-based robust method\n.   -   @ref LMEDS - Least-Median robust method\n.   -   @ref RHO - PROSAC-based robust method\n.   @param ransacReprojThreshold Maximum allowed reprojection error to treat a point pair as an inlier\n.   (used in the RANSAC and RHO methods only). That is, if\n.   \\f[\\| \\texttt{dstPoints} _i -  \\texttt{convertPointsHomogeneous} ( \\texttt{H} \\cdot \\texttt{srcPoints} _i) \\|_2  >  \\texttt{ransacReprojThreshold}\\f]\n.   then the point \\f$i\\f$ is considered as an outlier. If srcPoints and dstPoints are measured in pixels,\n.   it usually makes sense to set this parameter somewhere in the range of 1 to 10.\n.   @param mask Optional output mask set by a robust method ( RANSAC or LMeDS ). Note that the input\n.   mask values are ignored.\n.   @param maxIters The maximum number of RANSAC iterations.\n.   @param confidence Confidence level, between 0 and 1.\n.   \n.   The function finds and returns the perspective transformation \\f$H\\f$ between the source and the\n.   destination planes:\n.   \n.   \\f[s_i  \\vecthree{x'_i}{y'_i}{1} \\sim H  \\vecthree{x_i}{y_i}{1}\\f]\n.   \n.   so that the back-projection error\n.   \n.   \\f[\\sum _i \\left ( x'_i- \\frac{h_{11} x_i + h_{12} y_i + h_{13}}{h_{31} x_i + h_{32} y_i + h_{33}} \\right )^2+ \\left ( y'_i- \\frac{h_{21} x_i + h_{22} y_i + h_{23}}{h_{31} x_i + h_{32} y_i + h_{33}} \\right )^2\\f]\n.   \n.   is minimized. If the parameter method is set to the default value 0, the function uses all the point\n.   pairs to compute an initial homography estimate with a simple least-squares scheme.\n.   \n.   However, if not all of the point pairs ( \\f$srcPoints_i\\f$, \\f$dstPoints_i\\f$ ) fit the rigid perspective\n.   transformation (that is, there are some outliers), this initial estimate will be poor. In this case,\n.   you can use one of the three robust methods. The methods RANSAC, LMeDS and RHO try many different\n.   random subsets of the corresponding point pairs (of four pairs each, collinear pairs are discarded), estimate the homography matrix\n.   using this subset and a simple least-squares algorithm, and then compute the quality/goodness of the\n.   computed homography (which is the number of inliers for RANSAC or the least median re-projection error for\n.   LMeDS). The best subset is then used to produce the initial estimate of the homography matrix and\n.   the mask of inliers/outliers.\n.   \n.   Regardless of the method, robust or not, the computed homography matrix is refined further (using\n.   inliers only in case of a robust method) with the Levenberg-Marquardt method to reduce the\n.   re-projection error even more.\n.   \n.   The methods RANSAC and RHO can handle practically any ratio of outliers but need a threshold to\n.   distinguish inliers from outliers. The method LMeDS does not need any threshold but it works\n.   correctly only when there are more than 50% of inliers. Finally, if there are no outliers and the\n.   noise is rather small, use the default method (method=0).\n.   \n.   The function is used to find initial intrinsic and extrinsic matrices. Homography matrix is\n.   determined up to a scale. If \\f$h_{33}\\f$ is non-zero, the matrix is normalized so that \\f$h_{33}=1\\f$.\n.   @note Whenever an \\f$H\\f$ matrix cannot be estimated, an empty one will be returned.\n.   \n.   @sa\n.   getAffineTransform, estimateAffine2D, estimateAffinePartial2D, getPerspectiveTransform, warpPerspective,\n.   perspectiveTransform\n\n\n\nfindHomography(srcPoints, dstPoints, params[, mask]) -> retval, mask\n.   @overload"},
    {"findNonZero", CV_PY_FN_WITH_KW_(pyopencv_cv_findNonZero, 0), "findNonZero(src[, idx]) -> idx\n.   @brief Returns the list of locations of non-zero pixels\n.   \n.   Given a binary matrix (likely returned from an operation such\n.   as threshold(), compare(), >, ==, etc, return all of\n.   the non-zero indices as a cv::Mat or std::vector<cv::Point> (x,y)\n.   For example:\n.   @code{.cpp}\n.       cv::Mat binaryImage; // input, binary image\n.       cv::Mat locations;   // output, locations of non-zero pixels\n.       cv::findNonZero(binaryImage, locations);\n.   \n.       // access pixel coordinates\n.       Point pnt = locations.at<Point>(i);\n.   @endcode\n.   or\n.   @code{.cpp}\n.       cv::Mat binaryImage; // input, binary image\n.       vector<Point> locations;   // output, locations of non-zero pixels\n.       cv::findNonZero(binaryImage, locations);\n.   \n.       // access pixel coordinates\n.       Point pnt = locations[i];\n.   @endcode\n.   \n.   The function do not work with multi-channel arrays. If you need to find non-zero\n.   elements across all the channels, use Mat::reshape first to reinterpret the array as\n.   single-channel. Or you may extract the particular channel using either extractImageCOI, or\n.   mixChannels, or split.\n.   \n.   @note\n.   - If only count of non-zero array elements is important, @ref countNonZero is helpful.\n.   - If only whether there are non-zero elements is important, @ref hasNonZero is helpful.\n.   @param src single-channel array\n.   @param idx the output array, type of cv::Mat or std::vector<Point>, corresponding to non-zero indices in the input\n.   @sa  countNonZero, hasNonZero"},
    {"findTransformECC", CV_PY_FN_WITH_KW_(pyopencv_cv_findTransformECC, 0), "findTransformECC(templateImage, inputImage, warpMatrix, motionType, criteria, inputMask, gaussFiltSize) -> retval, warpMatrix\n.   @brief Finds the geometric transform (warp) between two images in terms of the ECC criterion @cite EP08 .\n.   \n.   @param templateImage single-channel template image; CV_8U or CV_32F array.\n.   @param inputImage single-channel input image which should be warped with the final warpMatrix in\n.   order to provide an image similar to templateImage, same type as templateImage.\n.   @param warpMatrix floating-point \\f$2\\times 3\\f$ or \\f$3\\times 3\\f$ mapping matrix (warp).\n.   @param motionType parameter, specifying the type of motion:\n.    -   **MOTION_TRANSLATION** sets a translational motion model; warpMatrix is \\f$2\\times 3\\f$ with\n.        the first \\f$2\\times 2\\f$ part being the unity matrix and the rest two parameters being\n.        estimated.\n.    -   **MOTION_EUCLIDEAN** sets a Euclidean (rigid) transformation as motion model; three\n.        parameters are estimated; warpMatrix is \\f$2\\times 3\\f$.\n.    -   **MOTION_AFFINE** sets an affine motion model (DEFAULT); six parameters are estimated;\n.        warpMatrix is \\f$2\\times 3\\f$.\n.    -   **MOTION_HOMOGRAPHY** sets a homography as a motion model; eight parameters are\n.        estimated;\\`warpMatrix\\` is \\f$3\\times 3\\f$.\n.   @param criteria parameter, specifying the termination criteria of the ECC algorithm;\n.   criteria.epsilon defines the threshold of the increment in the correlation coefficient between two\n.   iterations (a negative criteria.epsilon makes criteria.maxcount the only termination criterion).\n.   Default values are shown in the declaration above.\n.   @param inputMask An optional mask to indicate valid values of inputImage.\n.   @param gaussFiltSize An optional value indicating size of gaussian blur filter; (DEFAULT: 5)\n.   \n.   The function estimates the optimum transformation (warpMatrix) with respect to ECC criterion\n.   (@cite EP08), that is\n.   \n.   \\f[\\texttt{warpMatrix} = \\arg\\max_{W} \\texttt{ECC}(\\texttt{templateImage}(x,y),\\texttt{inputImage}(x',y'))\\f]\n.   \n.   where\n.   \n.   \\f[\\begin{bmatrix} x' \\\\ y' \\end{bmatrix} = W \\cdot \\begin{bmatrix} x \\\\ y \\\\ 1 \\end{bmatrix}\\f]\n.   \n.   (the equation holds with homogeneous coordinates for homography). It returns the final enhanced\n.   correlation coefficient, that is the correlation coefficient between the template image and the\n.   final warped input image. When a \\f$3\\times 3\\f$ matrix is given with motionType =0, 1 or 2, the third\n.   row is ignored.\n.   \n.   Unlike findHomography and estimateRigidTransform, the function findTransformECC implements an\n.   area-based alignment that builds on intensity similarities. In essence, the function updates the\n.   initial transformation that roughly aligns the images. If this information is missing, the identity\n.   warp (unity matrix) is used as an initialization. Note that if images undergo strong\n.   displacements/rotations, an initial transformation that roughly aligns the images is necessary\n.   (e.g., a simple euclidean/similarity transform that allows for the images showing the same image\n.   content approximately). Use inverse warping in the second image to take an image close to the first\n.   one, i.e. use the flag WARP_INVERSE_MAP with warpAffine or warpPerspective. See also the OpenCV\n.   sample image_alignment.cpp that demonstrates the use of the function. Note that the function throws\n.   an exception if algorithm does not converges.\n.   \n.   @sa\n.   computeECC, estimateAffine2D, estimateAffinePartial2D, findHomography\n\n\n\nfindTransformECC(templateImage, inputImage, warpMatrix[, motionType[, criteria[, inputMask]]]) -> retval, warpMatrix\n.   @overload"},
    {"fitEllipse", CV_PY_FN_WITH_KW_(pyopencv_cv_fitEllipse, 0), "fitEllipse(points) -> retval\n.   @brief Fits an ellipse around a set of 2D points.\n.   \n.   The function calculates the ellipse that fits (in a least-squares sense) a set of 2D points best of\n.   all. It returns the rotated rectangle in which the ellipse is inscribed. The first algorithm described by @cite Fitzgibbon95\n.   is used. Developer should keep in mind that it is possible that the returned\n.   ellipse/rotatedRect data contains negative indices, due to the data points being close to the\n.   border of the containing Mat element.\n.   \n.   @param points Input 2D point set, stored in std::vector\\<\\> or Mat\n.   \n.   @note Input point types are @ref Point2i or @ref Point2f and at least 5 points are required.\n.   @note @ref getClosestEllipsePoints function can be used to compute the ellipse fitting error."},
    {"fitEllipseAMS", CV_PY_FN_WITH_KW_(pyopencv_cv_fitEllipseAMS, 0), "fitEllipseAMS(points) -> retval\n.   @brief Fits an ellipse around a set of 2D points.\n.   \n.    The function calculates the ellipse that fits a set of 2D points.\n.    It returns the rotated rectangle in which the ellipse is inscribed.\n.    The Approximate Mean Square (AMS) proposed by @cite Taubin1991 is used.\n.   \n.    For an ellipse, this basis set is \\f$ \\chi= \\left(x^2, x y, y^2, x, y, 1\\right) \\f$,\n.    which is a set of six free coefficients \\f$ A^T=\\left\\{A_{\\text{xx}},A_{\\text{xy}},A_{\\text{yy}},A_x,A_y,A_0\\right\\} \\f$.\n.    However, to specify an ellipse, all that is needed is five numbers; the major and minor axes lengths \\f$ (a,b) \\f$,\n.    the position \\f$ (x_0,y_0) \\f$, and the orientation \\f$ \\theta \\f$. This is because the basis set includes lines,\n.    quadratics, parabolic and hyperbolic functions as well as elliptical functions as possible fits.\n.    If the fit is found to be a parabolic or hyperbolic function then the standard #fitEllipse method is used.\n.    The AMS method restricts the fit to parabolic, hyperbolic and elliptical curves\n.    by imposing the condition that \\f$ A^T ( D_x^T D_x  +   D_y^T D_y) A = 1 \\f$ where\n.    the matrices \\f$ Dx \\f$ and \\f$ Dy \\f$ are the partial derivatives of the design matrix \\f$ D \\f$ with\n.    respect to x and y. The matrices are formed row by row applying the following to\n.    each of the points in the set:\n.    \\f{align*}{\n.    D(i,:)&=\\left\\{x_i^2, x_i y_i, y_i^2, x_i, y_i, 1\\right\\} &\n.    D_x(i,:)&=\\left\\{2 x_i,y_i,0,1,0,0\\right\\} &\n.    D_y(i,:)&=\\left\\{0,x_i,2 y_i,0,1,0\\right\\}\n.    \\f}\n.    The AMS method minimizes the cost function\n.    \\f{equation*}{\n.    \\epsilon ^2=\\frac{ A^T D^T D A }{ A^T (D_x^T D_x +  D_y^T D_y) A^T }\n.    \\f}\n.   \n.    The minimum cost is found by solving the generalized eigenvalue problem.\n.   \n.    \\f{equation*}{\n.    D^T D A = \\lambda  \\left( D_x^T D_x +  D_y^T D_y\\right) A\n.    \\f}\n.   \n.    @param points Input 2D point set, stored in std::vector\\<\\> or Mat\n.   \n.    @note Input point types are @ref Point2i or @ref Point2f and at least 5 points are required.\n.    @note @ref getClosestEllipsePoints function can be used to compute the ellipse fitting error."},
    {"fitEllipseDirect", CV_PY_FN_WITH_KW_(pyopencv_cv_fitEllipseDirect, 0), "fitEllipseDirect(points) -> retval\n.   @brief Fits an ellipse around a set of 2D points.\n.   \n.    The function calculates the ellipse that fits a set of 2D points.\n.    It returns the rotated rectangle in which the ellipse is inscribed.\n.    The Direct least square (Direct) method by @cite oy1998NumericallySD is used.\n.   \n.    For an ellipse, this basis set is \\f$ \\chi= \\left(x^2, x y, y^2, x, y, 1\\right) \\f$,\n.    which is a set of six free coefficients \\f$ A^T=\\left\\{A_{\\text{xx}},A_{\\text{xy}},A_{\\text{yy}},A_x,A_y,A_0\\right\\} \\f$.\n.    However, to specify an ellipse, all that is needed is five numbers; the major and minor axes lengths \\f$ (a,b) \\f$,\n.    the position \\f$ (x_0,y_0) \\f$, and the orientation \\f$ \\theta \\f$. This is because the basis set includes lines,\n.    quadratics, parabolic and hyperbolic functions as well as elliptical functions as possible fits.\n.    The Direct method confines the fit to ellipses by ensuring that \\f$ 4 A_{xx} A_{yy}- A_{xy}^2 > 0 \\f$.\n.    The condition imposed is that \\f$ 4 A_{xx} A_{yy}- A_{xy}^2=1 \\f$ which satisfies the inequality\n.    and as the coefficients can be arbitrarily scaled is not overly restrictive.\n.   \n.    \\f{equation*}{\n.    \\epsilon ^2= A^T D^T D A \\quad \\text{with} \\quad A^T C A =1 \\quad \\text{and} \\quad C=\\left(\\begin{matrix}\n.    0 & 0  & 2  & 0  & 0  &  0  \\\\\n.    0 & -1  & 0  & 0  & 0  &  0 \\\\\n.    2 & 0  & 0  & 0  & 0  &  0 \\\\\n.    0 & 0  & 0  & 0  & 0  &  0 \\\\\n.    0 & 0  & 0  & 0  & 0  &  0 \\\\\n.    0 & 0  & 0  & 0  & 0  &  0\n.    \\end{matrix} \\right)\n.    \\f}\n.   \n.    The minimum cost is found by solving the generalized eigenvalue problem.\n.   \n.    \\f{equation*}{\n.    D^T D A = \\lambda  \\left( C\\right) A\n.    \\f}\n.   \n.    The system produces only one positive eigenvalue \\f$ \\lambda\\f$ which is chosen as the solution\n.    with its eigenvector \\f$\\mathbf{u}\\f$. These are used to find the coefficients\n.   \n.    \\f{equation*}{\n.    A = \\sqrt{\\frac{1}{\\mathbf{u}^T C \\mathbf{u}}}  \\mathbf{u}\n.    \\f}\n.    The scaling factor guarantees that  \\f$A^T C A =1\\f$.\n.   \n.    @param points Input 2D point set, stored in std::vector\\<\\> or Mat\n.   \n.    @note Input point types are @ref Point2i or @ref Point2f and at least 5 points are required.\n.    @note @ref getClosestEllipsePoints function can be used to compute the ellipse fitting error."},
    {"fitLine", CV_PY_FN_WITH_KW_(pyopencv_cv_fitLine, 0), "fitLine(points, distType, param, reps, aeps[, line]) -> line\n.   @brief Fits a line to a 2D or 3D point set.\n.   \n.   The function fitLine fits a line to a 2D or 3D point set by minimizing \\f$\\sum_i \\rho(r_i)\\f$ where\n.   \\f$r_i\\f$ is a distance between the \\f$i^{th}\\f$ point, the line and \\f$\\rho(r)\\f$ is a distance function, one\n.   of the following:\n.   -  DIST_L2\n.   \\f[\\rho (r) = r^2/2  \\quad \\text{(the simplest and the fastest least-squares method)}\\f]\n.   - DIST_L1\n.   \\f[\\rho (r) = r\\f]\n.   - DIST_L12\n.   \\f[\\rho (r) = 2  \\cdot ( \\sqrt{1 + \\frac{r^2}{2}} - 1)\\f]\n.   - DIST_FAIR\n.   \\f[\\rho \\left (r \\right ) = C^2  \\cdot \\left (  \\frac{r}{C} -  \\log{\\left(1 + \\frac{r}{C}\\right)} \\right )  \\quad \\text{where} \\quad C=1.3998\\f]\n.   - DIST_WELSCH\n.   \\f[\\rho \\left (r \\right ) =  \\frac{C^2}{2} \\cdot \\left ( 1 -  \\exp{\\left(-\\left(\\frac{r}{C}\\right)^2\\right)} \\right )  \\quad \\text{where} \\quad C=2.9846\\f]\n.   - DIST_HUBER\n.   \\f[\\rho (r) =  \\fork{r^2/2}{if \\(r < C\\)}{C \\cdot (r-C/2)}{otherwise} \\quad \\text{where} \\quad C=1.345\\f]\n.   \n.   The algorithm is based on the M-estimator ( <https://en.wikipedia.org/wiki/M-estimator> ) technique\n.   that iteratively fits the line using the weighted least-squares algorithm. After each iteration the\n.   weights \\f$w_i\\f$ are adjusted to be inversely proportional to \\f$\\rho(r_i)\\f$ .\n.   \n.   @param points Input vector of 2D or 3D points, stored in std::vector\\<\\> or Mat.\n.   @param line Output line parameters. In case of 2D fitting, it should be a vector of 4 elements\n.   (like Vec4f) - (vx, vy, x0, y0), where (vx, vy) is a normalized vector collinear to the line and\n.   (x0, y0) is a point on the line. In case of 3D fitting, it should be a vector of 6 elements (like\n.   Vec6f) - (vx, vy, vz, x0, y0, z0), where (vx, vy, vz) is a normalized vector collinear to the line\n.   and (x0, y0, z0) is a point on the line.\n.   @param distType Distance used by the M-estimator, see #DistanceTypes\n.   @param param Numerical parameter ( C ) for some types of distances. If it is 0, an optimal value\n.   is chosen.\n.   @param reps Sufficient accuracy for the radius (distance between the coordinate origin and the line).\n.   @param aeps Sufficient accuracy for the angle. 0.01 would be a good default value for reps and aeps."},
    {"flip", CV_PY_FN_WITH_KW_(pyopencv_cv_flip, 0), "flip(src, flipCode[, dst]) -> dst\n.   @brief Flips a 2D array around vertical, horizontal, or both axes.\n.   \n.   The function cv::flip flips the array in one of three different ways (row\n.   and column indices are 0-based):\n.   \\f[\\texttt{dst} _{ij} =\n.   \\left\\{\n.   \\begin{array}{l l}\n.   \\texttt{src} _{\\texttt{src.rows}-i-1,j} & if\\;  \\texttt{flipCode} = 0 \\\\\n.   \\texttt{src} _{i, \\texttt{src.cols} -j-1} & if\\;  \\texttt{flipCode} > 0 \\\\\n.   \\texttt{src} _{ \\texttt{src.rows} -i-1, \\texttt{src.cols} -j-1} & if\\; \\texttt{flipCode} < 0 \\\\\n.   \\end{array}\n.   \\right.\\f]\n.   The example scenarios of using the function are the following:\n.   *   Vertical flipping of the image (flipCode == 0) to switch between\n.       top-left and bottom-left image origin. This is a typical operation\n.       in video processing on Microsoft Windows\\* OS.\n.   *   Horizontal flipping of the image with the subsequent horizontal\n.       shift and absolute difference calculation to check for a\n.       vertical-axis symmetry (flipCode \\> 0).\n.   *   Simultaneous horizontal and vertical flipping of the image with\n.       the subsequent shift and absolute difference calculation to check\n.       for a central symmetry (flipCode \\< 0).\n.   *   Reversing the order of point arrays (flipCode \\> 0 or\n.       flipCode == 0).\n.   @param src input array.\n.   @param dst output array of the same size and type as src.\n.   @param flipCode a flag to specify how to flip the array; 0 means\n.   flipping around the x-axis and positive value (for example, 1) means\n.   flipping around y-axis. Negative value (for example, -1) means flipping\n.   around both axes.\n.   @sa transpose, repeat, completeSymm"},
    {"flipND", CV_PY_FN_WITH_KW_(pyopencv_cv_flipND, 0), "flipND(src, axis[, dst]) -> dst\n.   @brief Flips a n-dimensional at given axis\n.    *  @param src input array\n.    *  @param dst output array that has the same shape of src\n.    *  @param axis axis that performs a flip on. 0 <= axis < src.dims."},
    {"floodFill", CV_PY_FN_WITH_KW_(pyopencv_cv_floodFill, 0), "floodFill(image, mask, seedPoint, newVal[, loDiff[, upDiff[, flags]]]) -> retval, image, mask, rect\n.   @brief Fills a connected component with the given color.\n.   \n.   The function cv::floodFill fills a connected component starting from the seed point with the specified\n.   color. The connectivity is determined by the color/brightness closeness of the neighbor pixels. The\n.   pixel at \\f$(x,y)\\f$ is considered to belong to the repainted domain if:\n.   \n.   - in case of a grayscale image and floating range\n.   \\f[\\texttt{src} (x',y')- \\texttt{loDiff} \\leq \\texttt{src} (x,y)  \\leq \\texttt{src} (x',y')+ \\texttt{upDiff}\\f]\n.   \n.   \n.   - in case of a grayscale image and fixed range\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)- \\texttt{loDiff} \\leq \\texttt{src} (x,y)  \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)+ \\texttt{upDiff}\\f]\n.   \n.   \n.   - in case of a color image and floating range\n.   \\f[\\texttt{src} (x',y')_r- \\texttt{loDiff} _r \\leq \\texttt{src} (x,y)_r \\leq \\texttt{src} (x',y')_r+ \\texttt{upDiff} _r,\\f]\n.   \\f[\\texttt{src} (x',y')_g- \\texttt{loDiff} _g \\leq \\texttt{src} (x,y)_g \\leq \\texttt{src} (x',y')_g+ \\texttt{upDiff} _g\\f]\n.   and\n.   \\f[\\texttt{src} (x',y')_b- \\texttt{loDiff} _b \\leq \\texttt{src} (x,y)_b \\leq \\texttt{src} (x',y')_b+ \\texttt{upDiff} _b\\f]\n.   \n.   \n.   - in case of a color image and fixed range\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_r- \\texttt{loDiff} _r \\leq \\texttt{src} (x,y)_r \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_r+ \\texttt{upDiff} _r,\\f]\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_g- \\texttt{loDiff} _g \\leq \\texttt{src} (x,y)_g \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_g+ \\texttt{upDiff} _g\\f]\n.   and\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_b- \\texttt{loDiff} _b \\leq \\texttt{src} (x,y)_b \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_b+ \\texttt{upDiff} _b\\f]\n.   \n.   \n.   where \\f$src(x',y')\\f$ is the value of one of pixel neighbors that is already known to belong to the\n.   component. That is, to be added to the connected component, a color/brightness of the pixel should\n.   be close enough to:\n.   - Color/brightness of one of its neighbors that already belong to the connected component in case\n.   of a floating range.\n.   - Color/brightness of the seed point in case of a fixed range.\n.   \n.   Use these functions to either mark a connected component with the specified color in-place, or build\n.   a mask and then extract the contour, or copy the region to another image, and so on.\n.   \n.   @param image Input/output 1- or 3-channel, 8-bit, or floating-point image. It is modified by the\n.   function unless the #FLOODFILL_MASK_ONLY flag is set in the second variant of the function. See\n.   the details below.\n.   @param mask Operation mask that should be a single-channel 8-bit image, 2 pixels wider and 2 pixels\n.   taller than image. If an empty Mat is passed it will be created automatically. Since this is both an\n.   input and output parameter, you must take responsibility of initializing it.\n.   Flood-filling cannot go across non-zero pixels in the input mask. For example,\n.   an edge detector output can be used as a mask to stop filling at edges. On output, pixels in the\n.   mask corresponding to filled pixels in the image are set to 1 or to the specified value in flags\n.   as described below. Additionally, the function fills the border of the mask with ones to simplify\n.   internal processing. It is therefore possible to use the same mask in multiple calls to the function\n.   to make sure the filled areas do not overlap.\n.   @param seedPoint Starting point.\n.   @param newVal New value of the repainted domain pixels.\n.   @param loDiff Maximal lower brightness/color difference between the currently observed pixel and\n.   one of its neighbors belonging to the component, or a seed pixel being added to the component.\n.   @param upDiff Maximal upper brightness/color difference between the currently observed pixel and\n.   one of its neighbors belonging to the component, or a seed pixel being added to the component.\n.   @param rect Optional output parameter set by the function to the minimum bounding rectangle of the\n.   repainted domain.\n.   @param flags Operation flags. The first 8 bits contain a connectivity value. The default value of\n.   4 means that only the four nearest neighbor pixels (those that share an edge) are considered. A\n.   connectivity value of 8 means that the eight nearest neighbor pixels (those that share a corner)\n.   will be considered. The next 8 bits (8-16) contain a value between 1 and 255 with which to fill\n.   the mask (the default value is 1). For example, 4 | ( 255 \\<\\< 8 ) will consider 4 nearest\n.   neighbours and fill the mask with a value of 255. The following additional options occupy higher\n.   bits and therefore may be further combined with the connectivity and mask fill values using\n.   bit-wise or (|), see #FloodFillFlags.\n.   \n.   @note Since the mask is larger than the filled image, a pixel \\f$(x, y)\\f$ in image corresponds to the\n.   pixel \\f$(x+1, y+1)\\f$ in the mask .\n.   \n.   @sa findContours"},
    {"gemm", CV_PY_FN_WITH_KW_(pyopencv_cv_gemm, 0), "gemm(src1, src2, alpha, src3, beta[, dst[, flags]]) -> dst\n.   @brief Performs generalized matrix multiplication.\n.   \n.   The function cv::gemm performs generalized matrix multiplication similar to the\n.   gemm functions in BLAS level 3. For example,\n.   `gemm(src1, src2, alpha, src3, beta, dst, GEMM_1_T + GEMM_3_T)`\n.   corresponds to\n.   \\f[\\texttt{dst} =  \\texttt{alpha} \\cdot \\texttt{src1} ^T  \\cdot \\texttt{src2} +  \\texttt{beta} \\cdot \\texttt{src3} ^T\\f]\n.   \n.   In case of complex (two-channel) data, performed a complex matrix\n.   multiplication.\n.   \n.   The function can be replaced with a matrix expression. For example, the\n.   above call can be replaced with:\n.   @code{.cpp}\n.       dst = alpha*src1.t()*src2 + beta*src3.t();\n.   @endcode\n.   @param src1 first multiplied input matrix that could be real(CV_32FC1,\n.   CV_64FC1) or complex(CV_32FC2, CV_64FC2).\n.   @param src2 second multiplied input matrix of the same type as src1.\n.   @param alpha weight of the matrix product.\n.   @param src3 third optional delta matrix added to the matrix product; it\n.   should have the same type as src1 and src2.\n.   @param beta weight of src3.\n.   @param dst output matrix; it has the proper size and the same type as\n.   input matrices.\n.   @param flags operation flags (cv::GemmFlags)\n.   @sa mulTransposed, transform"},
    {"getAffineTransform", CV_PY_FN_WITH_KW_(pyopencv_cv_getAffineTransform, 0), "getAffineTransform(src, dst) -> retval\n.   @overload"},
    {"getBuildInformation", CV_PY_FN_WITH_KW_(pyopencv_cv_getBuildInformation, 0), "getBuildInformation() -> retval\n.   @brief Returns full configuration time cmake output.\n.   \n.   Returned value is raw cmake output including version control system revision, compiler version,\n.   compiler flags, enabled modules and third party libraries, etc. Output format depends on target\n.   architecture."},
    {"getCPUFeaturesLine", CV_PY_FN_WITH_KW_(pyopencv_cv_getCPUFeaturesLine, 0), "getCPUFeaturesLine() -> retval\n.   @brief Returns list of CPU features enabled during compilation.\n.   \n.   Returned value is a string containing space separated list of CPU features with following markers:\n.   \n.   - no markers - baseline features\n.   - prefix `*` - features enabled in dispatcher\n.   - suffix `?` - features enabled but not available in HW\n.   \n.   Example: `SSE SSE2 SSE3 *SSE4.1 *SSE4.2 *FP16 *AVX *AVX2 *AVX512-SKX?`"},
    {"getCPUTickCount", CV_PY_FN_WITH_KW_(pyopencv_cv_getCPUTickCount, 0), "getCPUTickCount() -> retval\n.   @brief Returns the number of CPU ticks.\n.   \n.   The function returns the current number of CPU ticks on some architectures (such as x86, x64,\n.   PowerPC). On other platforms the function is equivalent to getTickCount. It can also be used for\n.   very accurate time measurements, as well as for RNG initialization. Note that in case of multi-CPU\n.   systems a thread, from which getCPUTickCount is called, can be suspended and resumed at another CPU\n.   with its own counter. So, theoretically (and practically) the subsequent calls to the function do\n.   not necessary return the monotonously increasing values. Also, since a modern CPU varies the CPU\n.   frequency depending on the load, the number of CPU clocks spent in some code cannot be directly\n.   converted to time units. Therefore, getTickCount is generally a preferable solution for measuring\n.   execution time."},
    {"getClosestEllipsePoints", CV_PY_FN_WITH_KW_(pyopencv_cv_getClosestEllipsePoints, 0), "getClosestEllipsePoints(ellipse_params, points[, closest_pts]) -> closest_pts\n.   @brief Compute for each 2d point the nearest 2d point located on a given ellipse.\n.   \n.    The function computes the nearest 2d location on a given ellipse for a vector of 2d points and is based on @cite Chatfield2017 code.\n.    This function can be used to compute for instance the ellipse fitting error.\n.   \n.    @param ellipse_params Ellipse parameters\n.    @param points Input 2d points\n.    @param closest_pts For each 2d point, their corresponding closest 2d point located on a given ellipse\n.   \n.    @note Input point types are @ref Point2i or @ref Point2f\n.    @see fitEllipse, fitEllipseAMS, fitEllipseDirect"},
    {"getDefaultAlgorithmHint", CV_PY_FN_WITH_KW_(pyopencv_cv_getDefaultAlgorithmHint, 0), "getDefaultAlgorithmHint() -> retval\n."},
    {"getDefaultNewCameraMatrix", CV_PY_FN_WITH_KW_(pyopencv_cv_getDefaultNewCameraMatrix, 0), "getDefaultNewCameraMatrix(cameraMatrix[, imgsize[, centerPrincipalPoint]]) -> retval\n.   @brief Returns the default new camera matrix.\n.   \n.   The function returns the camera matrix that is either an exact copy of the input cameraMatrix (when\n.   centerPrinicipalPoint=false ), or the modified one (when centerPrincipalPoint=true).\n.   \n.   In the latter case, the new camera matrix will be:\n.   \n.   \\f[\\begin{bmatrix} f_x && 0 && ( \\texttt{imgSize.width} -1)*0.5  \\\\ 0 && f_y && ( \\texttt{imgSize.height} -1)*0.5  \\\\ 0 && 0 && 1 \\end{bmatrix} ,\\f]\n.   \n.   where \\f$f_x\\f$ and \\f$f_y\\f$ are \\f$(0,0)\\f$ and \\f$(1,1)\\f$ elements of cameraMatrix, respectively.\n.   \n.   By default, the undistortion functions in OpenCV (see #initUndistortRectifyMap, #undistort) do not\n.   move the principal point. However, when you work with stereo, it is important to move the principal\n.   points in both views to the same y-coordinate (which is required by most of stereo correspondence\n.   algorithms), and may be to the same x-coordinate too. So, you can form the new camera matrix for\n.   each view where the principal points are located at the center.\n.   \n.   @param cameraMatrix Input camera matrix.\n.   @param imgsize Camera view image size in pixels.\n.   @param centerPrincipalPoint Location of the principal point in the new camera matrix. The\n.   parameter indicates whether this location should be at the image center or not."},
    {"getDerivKernels", CV_PY_FN_WITH_KW_(pyopencv_cv_getDerivKernels, 0), "getDerivKernels(dx, dy, ksize[, kx[, ky[, normalize[, ktype]]]]) -> kx, ky\n.   @brief Returns filter coefficients for computing spatial image derivatives.\n.   \n.   The function computes and returns the filter coefficients for spatial image derivatives. When\n.   `ksize=FILTER_SCHARR`, the Scharr \\f$3 \\times 3\\f$ kernels are generated (see #Scharr). Otherwise, Sobel\n.   kernels are generated (see #Sobel). The filters are normally passed to #sepFilter2D or to\n.   \n.   @param kx Output matrix of row filter coefficients. It has the type ktype .\n.   @param ky Output matrix of column filter coefficients. It has the type ktype .\n.   @param dx Derivative order in respect of x.\n.   @param dy Derivative order in respect of y.\n.   @param ksize Aperture size. It can be FILTER_SCHARR, 1, 3, 5, or 7.\n.   @param normalize Flag indicating whether to normalize (scale down) the filter coefficients or not.\n.   Theoretically, the coefficients should have the denominator \\f$=2^{ksize*2-dx-dy-2}\\f$. If you are\n.   going to filter floating-point images, you are likely to use the normalized kernels. But if you\n.   compute derivatives of an 8-bit image, store the results in a 16-bit image, and wish to preserve\n.   all the fractional bits, you may want to set normalize=false .\n.   @param ktype Type of filter coefficients. It can be CV_32f or CV_64F ."},
    {"getFontScaleFromHeight", CV_PY_FN_WITH_KW_(pyopencv_cv_getFontScaleFromHeight, 0), "getFontScaleFromHeight(fontFace, pixelHeight[, thickness]) -> retval\n.   @brief Calculates the font-specific size to use to achieve a given height in pixels.\n.   \n.   @param fontFace Font to use, see cv::HersheyFonts.\n.   @param pixelHeight Pixel height to compute the fontScale for\n.   @param thickness Thickness of lines used to render the text.See putText for details.\n.   @return The fontSize to use for cv::putText\n.   \n.   @see cv::putText"},
    {"getGaborKernel", CV_PY_FN_WITH_KW_(pyopencv_cv_getGaborKernel, 0), "getGaborKernel(ksize, sigma, theta, lambd, gamma[, psi[, ktype]]) -> retval\n.   @brief Returns Gabor filter coefficients.\n.   \n.   For more details about gabor filter equations and parameters, see: [Gabor\n.   Filter](https://en.wikipedia.org/wiki/Gabor_filter).\n.   \n.   @param ksize Size of the filter returned.\n.   @param sigma Standard deviation of the gaussian envelope.\n.   @param theta Orientation of the normal to the parallel stripes of a Gabor function.\n.   @param lambd Wavelength of the sinusoidal factor.\n.   @param gamma Spatial aspect ratio.\n.   @param psi Phase offset.\n.   @param ktype Type of filter coefficients. It can be CV_32F or CV_64F ."},
    {"getGaussianKernel", CV_PY_FN_WITH_KW_(pyopencv_cv_getGaussianKernel, 0), "getGaussianKernel(ksize, sigma[, ktype]) -> retval\n.   @brief Returns Gaussian filter coefficients.\n.   \n.   The function computes and returns the \\f$\\texttt{ksize} \\times 1\\f$ matrix of Gaussian filter\n.   coefficients:\n.   \n.   \\f[G_i= \\alpha *e^{-(i-( \\texttt{ksize} -1)/2)^2/(2* \\texttt{sigma}^2)},\\f]\n.   \n.   where \\f$i=0..\\texttt{ksize}-1\\f$ and \\f$\\alpha\\f$ is the scale factor chosen so that \\f$\\sum_i G_i=1\\f$.\n.   \n.   Two of such generated kernels can be passed to sepFilter2D. Those functions automatically recognize\n.   smoothing kernels (a symmetrical kernel with sum of weights equal to 1) and handle them accordingly.\n.   You may also use the higher-level GaussianBlur.\n.   @param ksize Aperture size. It should be odd ( \\f$\\texttt{ksize} \\mod 2 = 1\\f$ ) and positive.\n.   @param sigma Gaussian standard deviation. If it is non-positive, it is computed from ksize as\n.   `sigma = 0.3*((ksize-1)*0.5 - 1) + 0.8`.\n.   @param ktype Type of filter coefficients. It can be CV_32F or CV_64F .\n.   @sa  sepFilter2D, getDerivKernels, getStructuringElement, GaussianBlur"},
    {"getHardwareFeatureName", CV_PY_FN_WITH_KW_(pyopencv_cv_getHardwareFeatureName, 0), "getHardwareFeatureName(feature) -> retval\n.   @brief Returns feature name by ID\n.   \n.   Returns empty string if feature is not defined"},
    {"getLogLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_getLogLevel, 0), "getLogLevel() -> retval\n."},
    {"getNumThreads", CV_PY_FN_WITH_KW_(pyopencv_cv_getNumThreads, 0), "getNumThreads() -> retval\n.   @brief Returns the number of threads used by OpenCV for parallel regions.\n.   \n.   Always returns 1 if OpenCV is built without threading support.\n.   \n.   The exact meaning of return value depends on the threading framework used by OpenCV library:\n.   - `TBB` - The number of threads, that OpenCV will try to use for parallel regions. If there is\n.     any tbb::thread_scheduler_init in user code conflicting with OpenCV, then function returns\n.     default number of threads used by TBB library.\n.   - `OpenMP` - An upper bound on the number of threads that could be used to form a new team.\n.   - `Concurrency` - The number of threads, that OpenCV will try to use for parallel regions.\n.   - `GCD` - Unsupported; returns the GCD thread pool limit (512) for compatibility.\n.   - `C=` - The number of threads, that OpenCV will try to use for parallel regions, if before\n.     called setNumThreads with threads \\> 0, otherwise returns the number of logical CPUs,\n.     available for the process.\n.   @sa setNumThreads, getThreadNum"},
    {"getNumberOfCPUs", CV_PY_FN_WITH_KW_(pyopencv_cv_getNumberOfCPUs, 0), "getNumberOfCPUs() -> retval\n.   @brief Returns the number of logical CPUs available for the process."},
    {"getOptimalDFTSize", CV_PY_FN_WITH_KW_(pyopencv_cv_getOptimalDFTSize, 0), "getOptimalDFTSize(vecsize) -> retval\n.   @brief Returns the optimal DFT size for a given vector size.\n.   \n.   DFT performance is not a monotonic function of a vector size. Therefore, when you calculate\n.   convolution of two arrays or perform the spectral analysis of an array, it usually makes sense to\n.   pad the input data with zeros to get a bit larger array that can be transformed much faster than the\n.   original one. Arrays whose size is a power-of-two (2, 4, 8, 16, 32, ...) are the fastest to process.\n.   Though, the arrays whose size is a product of 2's, 3's, and 5's (for example, 300 = 5\\*5\\*3\\*2\\*2)\n.   are also processed quite efficiently.\n.   \n.   The function cv::getOptimalDFTSize returns the minimum number N that is greater than or equal to vecsize\n.   so that the DFT of a vector of size N can be processed efficiently. In the current implementation N\n.   = 2 ^p^ \\* 3 ^q^ \\* 5 ^r^ for some integer p, q, r.\n.   \n.   The function returns a negative number if vecsize is too large (very close to INT_MAX ).\n.   \n.   While the function cannot be used directly to estimate the optimal vector size for DCT transform\n.   (since the current DCT implementation supports only even-size vectors), it can be easily processed\n.   as getOptimalDFTSize((vecsize+1)/2)\\*2.\n.   @param vecsize vector size.\n.   @sa dft, dct, idft, idct, mulSpectrums"},
    {"getOptimalNewCameraMatrix", CV_PY_FN_WITH_KW_(pyopencv_cv_getOptimalNewCameraMatrix, 0), "getOptimalNewCameraMatrix(cameraMatrix, distCoeffs, imageSize, alpha[, newImgSize[, centerPrincipalPoint]]) -> retval, validPixROI\n.   @brief Returns the new camera intrinsic matrix based on the free scaling parameter.\n.   \n.   @param cameraMatrix Input camera intrinsic matrix.\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param imageSize Original image size.\n.   @param alpha Free scaling parameter between 0 (when all the pixels in the undistorted image are\n.   valid) and 1 (when all the source image pixels are retained in the undistorted image). See\n.   #stereoRectify for details.\n.   @param newImgSize Image size after rectification. By default, it is set to imageSize .\n.   @param validPixROI Optional output rectangle that outlines all-good-pixels region in the\n.   undistorted image. See roi1, roi2 description in #stereoRectify .\n.   @param centerPrincipalPoint Optional flag that indicates whether in the new camera intrinsic matrix the\n.   principal point should be at the image center or not. By default, the principal point is chosen to\n.   best fit a subset of the source image (determined by alpha) to the corrected image.\n.   @return new_camera_matrix Output new camera intrinsic matrix.\n.   \n.   The function computes and returns the optimal new camera intrinsic matrix based on the free scaling parameter.\n.   By varying this parameter, you may retrieve only sensible pixels alpha=0 , keep all the original\n.   image pixels if there is valuable information in the corners alpha=1 , or get something in between.\n.   When alpha\\>0 , the undistorted result is likely to have some black pixels corresponding to\n.   \"virtual\" pixels outside of the captured distorted image. The original camera intrinsic matrix, distortion\n.   coefficients, the computed new camera intrinsic matrix, and newImageSize should be passed to\n.   #initUndistortRectifyMap to produce the maps for #remap ."},
    {"getPerspectiveTransform", CV_PY_FN_WITH_KW_(pyopencv_cv_getPerspectiveTransform, 0), "getPerspectiveTransform(src, dst[, solveMethod]) -> retval\n.   @brief Calculates a perspective transform from four pairs of the corresponding points.\n.   \n.   The function calculates the \\f$3 \\times 3\\f$ matrix of a perspective transform so that:\n.   \n.   \\f[\\begin{bmatrix} t_i x'_i \\\\ t_i y'_i \\\\ t_i \\end{bmatrix} = \\texttt{map_matrix} \\cdot \\begin{bmatrix} x_i \\\\ y_i \\\\ 1 \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[dst(i)=(x'_i,y'_i), src(i)=(x_i, y_i), i=0,1,2,3\\f]\n.   \n.   @param src Coordinates of quadrangle vertices in the source image.\n.   @param dst Coordinates of the corresponding quadrangle vertices in the destination image.\n.   @param solveMethod method passed to cv::solve (#DecompTypes)\n.   \n.   @sa  findHomography, warpPerspective, perspectiveTransform"},
    {"getRectSubPix", CV_PY_FN_WITH_KW_(pyopencv_cv_getRectSubPix, 0), "getRectSubPix(image, patchSize, center[, patch[, patchType]]) -> patch\n.   @brief Retrieves a pixel rectangle from an image with sub-pixel accuracy.\n.   \n.   The function getRectSubPix extracts pixels from src:\n.   \n.   \\f[patch(x, y) = src(x +  \\texttt{center.x} - ( \\texttt{dst.cols} -1)*0.5, y +  \\texttt{center.y} - ( \\texttt{dst.rows} -1)*0.5)\\f]\n.   \n.   where the values of the pixels at non-integer coordinates are retrieved using bilinear\n.   interpolation. Every channel of multi-channel images is processed independently. Also\n.   the image should be a single channel or three channel image. While the center of the\n.   rectangle must be inside the image, parts of the rectangle may be outside.\n.   \n.   @param image Source image.\n.   @param patchSize Size of the extracted patch.\n.   @param center Floating point coordinates of the center of the extracted rectangle within the\n.   source image. The center must be inside the image.\n.   @param patch Extracted patch that has the size patchSize and the same number of channels as src .\n.   @param patchType Depth of the extracted pixels. By default, they have the same depth as src .\n.   \n.   @sa  warpAffine, warpPerspective"},
    {"getRotationMatrix2D", CV_PY_FN_WITH_KW_(pyopencv_cv_getRotationMatrix2D, 0), "getRotationMatrix2D(center, angle, scale) -> retval\n.   @brief Calculates an affine matrix of 2D rotation.\n.   \n.   The function calculates the following matrix:\n.   \n.   \\f[\\begin{bmatrix} \\alpha &  \\beta & (1- \\alpha )  \\cdot \\texttt{center.x} -  \\beta \\cdot \\texttt{center.y} \\\\ - \\beta &  \\alpha &  \\beta \\cdot \\texttt{center.x} + (1- \\alpha )  \\cdot \\texttt{center.y} \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[\\begin{array}{l} \\alpha =  \\texttt{scale} \\cdot \\cos \\texttt{angle} , \\\\ \\beta =  \\texttt{scale} \\cdot \\sin \\texttt{angle} \\end{array}\\f]\n.   \n.   The transformation maps the rotation center to itself. If this is not the target, adjust the shift.\n.   \n.   @param center Center of the rotation in the source image.\n.   @param angle Rotation angle in degrees. Positive values mean counter-clockwise rotation (the\n.   coordinate origin is assumed to be the top-left corner).\n.   @param scale Isotropic scale factor.\n.   \n.   @sa  getAffineTransform, warpAffine, transform"},
    {"getStructuringElement", CV_PY_FN_WITH_KW_(pyopencv_cv_getStructuringElement, 0), "getStructuringElement(shape, ksize[, anchor]) -> retval\n.   @brief Returns a structuring element of the specified size and shape for morphological operations.\n.   \n.   The function constructs and returns the structuring element that can be further passed to #erode,\n.   #dilate or #morphologyEx. But you can also construct an arbitrary binary mask yourself and use it as\n.   the structuring element.\n.   \n.   @param shape Element shape that could be one of #MorphShapes\n.   @param ksize Size of the structuring element.\n.   @param anchor Anchor position within the element. The default value \\f$(-1, -1)\\f$ means that the\n.   anchor is at the center. Note that only the shape of a cross-shaped element depends on the anchor\n.   position. In other cases the anchor just regulates how much the result of the morphological\n.   operation is shifted."},
    {"getTextSize", CV_PY_FN_WITH_KW_(pyopencv_cv_getTextSize, 0), "getTextSize(text, fontFace, fontScale, thickness) -> retval, baseLine\n.   @brief Calculates the width and height of a text string.\n.   \n.   The function cv::getTextSize calculates and returns the size of a box that contains the specified text.\n.   That is, the following code renders some text, the tight box surrounding it, and the baseline: :\n.   @code\n.       String text = \"Funny text inside the box\";\n.       int fontFace = FONT_HERSHEY_SCRIPT_SIMPLEX;\n.       double fontScale = 2;\n.       int thickness = 3;\n.   \n.       Mat img(600, 800, CV_8UC3, Scalar::all(0));\n.   \n.       int baseline=0;\n.       Size textSize = getTextSize(text, fontFace,\n.                                   fontScale, thickness, &baseline);\n.       baseline += thickness;\n.   \n.       // center the text\n.       Point textOrg((img.cols - textSize.width)/2,\n.                     (img.rows + textSize.height)/2);\n.   \n.       // draw the box\n.       rectangle(img, textOrg + Point(0, baseline),\n.                 textOrg + Point(textSize.width, -textSize.height),\n.                 Scalar(0,0,255));\n.       // ... and the baseline first\n.       line(img, textOrg + Point(0, thickness),\n.            textOrg + Point(textSize.width, thickness),\n.            Scalar(0, 0, 255));\n.   \n.       // then put the text itself\n.       putText(img, text, textOrg, fontFace, fontScale,\n.               Scalar::all(255), thickness, 8);\n.   @endcode\n.   \n.   @param text Input text string.\n.   @param fontFace Font to use, see #HersheyFonts.\n.   @param fontScale Font scale factor that is multiplied by the font-specific base size.\n.   @param thickness Thickness of lines used to render the text. See #putText for details.\n.   @param[out] baseLine y-coordinate of the baseline relative to the bottom-most text\n.   point.\n.   @return The size of a box that contains the specified text.\n.   \n.   @see putText"},
    {"getThreadNum", CV_PY_FN_WITH_KW_(pyopencv_cv_getThreadNum, 0), "getThreadNum() -> retval\n.   @brief Returns the index of the currently executed thread within the current parallel region. Always\n.   returns 0 if called outside of parallel region.\n.   \n.   @deprecated Current implementation doesn't corresponding to this documentation.\n.   \n.   The exact meaning of the return value depends on the threading framework used by OpenCV library:\n.   - `TBB` - Unsupported with current 4.1 TBB release. Maybe will be supported in future.\n.   - `OpenMP` - The thread number, within the current team, of the calling thread.\n.   - `Concurrency` - An ID for the virtual processor that the current context is executing on (0\n.     for master thread and unique number for others, but not necessary 1,2,3,...).\n.   - `GCD` - System calling thread's ID. Never returns 0 inside parallel region.\n.   - `C=` - The index of the current parallel task.\n.   @sa setNumThreads, getNumThreads"},
    {"getTickCount", CV_PY_FN_WITH_KW_(pyopencv_cv_getTickCount, 0), "getTickCount() -> retval\n.   @brief Returns the number of ticks.\n.   \n.   The function returns the number of ticks after the certain event (for example, when the machine was\n.   turned on). It can be used to initialize RNG or to measure a function execution time by reading the\n.   tick count before and after the function call.\n.   @sa getTickFrequency, TickMeter"},
    {"getTickFrequency", CV_PY_FN_WITH_KW_(pyopencv_cv_getTickFrequency, 0), "getTickFrequency() -> retval\n.   @brief Returns the number of ticks per second.\n.   \n.   The function returns the number of ticks per second. That is, the following code computes the\n.   execution time in seconds:\n.   @code\n.       double t = (double)getTickCount();\n.       // do something ...\n.       t = ((double)getTickCount() - t)/getTickFrequency();\n.   @endcode\n.   @sa getTickCount, TickMeter"},
    {"getTrackbarPos", CV_PY_FN_WITH_KW_(pyopencv_cv_getTrackbarPos, 0), "getTrackbarPos(trackbarname, winname) -> retval\n.   @brief Returns the trackbar position.\n.   \n.   The function returns the current position of the specified trackbar.\n.   \n.   @note [__Qt Backend Only__] winname can be empty if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of the trackbar."},
    {"getValidDisparityROI", CV_PY_FN_WITH_KW_(pyopencv_cv_getValidDisparityROI, 0), "getValidDisparityROI(roi1, roi2, minDisparity, numberOfDisparities, blockSize) -> retval\n."},
    {"getVersionMajor", CV_PY_FN_WITH_KW_(pyopencv_cv_getVersionMajor, 0), "getVersionMajor() -> retval\n.   @brief Returns major library version"},
    {"getVersionMinor", CV_PY_FN_WITH_KW_(pyopencv_cv_getVersionMinor, 0), "getVersionMinor() -> retval\n.   @brief Returns minor library version"},
    {"getVersionRevision", CV_PY_FN_WITH_KW_(pyopencv_cv_getVersionRevision, 0), "getVersionRevision() -> retval\n.   @brief Returns revision field of the library version"},
    {"getVersionString", CV_PY_FN_WITH_KW_(pyopencv_cv_getVersionString, 0), "getVersionString() -> retval\n.   @brief Returns library version string\n.   \n.   For example \"3.4.1-dev\".\n.   \n.   @sa getMajorVersion, getMinorVersion, getRevisionVersion"},
    {"getWindowImageRect", CV_PY_FN_WITH_KW_(pyopencv_cv_getWindowImageRect, 0), "getWindowImageRect(winname) -> retval\n.   @brief Provides rectangle of image in the window.\n.   \n.   The function getWindowImageRect returns the client screen coordinates, width and height of the image rendering area.\n.   \n.   @param winname Name of the window.\n.   \n.   @sa resizeWindow moveWindow\n.   \n.   @note [__Wayland Backend Only__] This function is not supported by the Wayland protocol limitation."},
    {"getWindowProperty", CV_PY_FN_WITH_KW_(pyopencv_cv_getWindowProperty, 0), "getWindowProperty(winname, prop_id) -> retval\n.   @brief Provides parameters of a window.\n.   \n.   The function getWindowProperty returns properties of a window.\n.   \n.   @param winname Name of the window.\n.   @param prop_id Window property to retrieve. The following operation flags are available: (cv::WindowPropertyFlags)\n.   \n.   @sa setWindowProperty\n.   \n.   @note [__Wayland Backend Only__] This function is not supported."},
    {"goodFeaturesToTrack", CV_PY_FN_WITH_KW_(pyopencv_cv_goodFeaturesToTrack, 0), "goodFeaturesToTrack(image, maxCorners, qualityLevel, minDistance[, corners[, mask[, blockSize[, useHarrisDetector[, k]]]]]) -> corners\n.   @brief Determines strong corners on an image.\n.   \n.   The function finds the most prominent corners in the image or in the specified image region, as\n.   described in @cite Shi94\n.   \n.   -   Function calculates the corner quality measure at every source image pixel using the\n.       #cornerMinEigenVal or #cornerHarris .\n.   -   Function performs a non-maximum suppression (the local maximums in *3 x 3* neighborhood are\n.       retained).\n.   -   The corners with the minimal eigenvalue less than\n.       \\f$\\texttt{qualityLevel} \\cdot \\max_{x,y} qualityMeasureMap(x,y)\\f$ are rejected.\n.   -   The remaining corners are sorted by the quality measure in the descending order.\n.   -   Function throws away each corner for which there is a stronger corner at a distance less than\n.       maxDistance.\n.   \n.   The function can be used to initialize a point-based tracker of an object.\n.   \n.   @note If the function is called with different values A and B of the parameter qualityLevel , and\n.   A \\> B, the vector of returned corners with qualityLevel=A will be the prefix of the output vector\n.   with qualityLevel=B .\n.   \n.   @param image Input 8-bit or floating-point 32-bit, single-channel image.\n.   @param corners Output vector of detected corners.\n.   @param maxCorners Maximum number of corners to return. If there are more corners than are found,\n.   the strongest of them is returned. `maxCorners <= 0` implies that no limit on the maximum is set\n.   and all detected corners are returned.\n.   @param qualityLevel Parameter characterizing the minimal accepted quality of image corners. The\n.   parameter value is multiplied by the best corner quality measure, which is the minimal eigenvalue\n.   (see #cornerMinEigenVal ) or the Harris function response (see #cornerHarris ). The corners with the\n.   quality measure less than the product are rejected. For example, if the best corner has the\n.   quality measure = 1500, and the qualityLevel=0.01 , then all the corners with the quality measure\n.   less than 15 are rejected.\n.   @param minDistance Minimum possible Euclidean distance between the returned corners.\n.   @param mask Optional region of interest. If the image is not empty (it needs to have the type\n.   CV_8UC1 and the same size as image ), it specifies the region in which the corners are detected.\n.   @param blockSize Size of an average block for computing a derivative covariation matrix over each\n.   pixel neighborhood. See cornerEigenValsAndVecs .\n.   @param useHarrisDetector Parameter indicating whether to use a Harris detector (see #cornerHarris)\n.   or #cornerMinEigenVal.\n.   @param k Free parameter of the Harris detector.\n.   \n.   @sa  cornerMinEigenVal, cornerHarris, calcOpticalFlowPyrLK, estimateRigidTransform,\n\n\n\ngoodFeaturesToTrack(image, maxCorners, qualityLevel, minDistance, mask, blockSize, gradientSize[, corners[, useHarrisDetector[, k]]]) -> corners\n."},
    {"goodFeaturesToTrackWithQuality", CV_PY_FN_WITH_KW_(pyopencv_cv_goodFeaturesToTrackWithQuality, 0), "goodFeaturesToTrackWithQuality(image, maxCorners, qualityLevel, minDistance, mask[, corners[, cornersQuality[, blockSize[, gradientSize[, useHarrisDetector[, k]]]]]]) -> corners, cornersQuality\n.   @brief Same as above, but returns also quality measure of the detected corners.\n.   \n.   @param image Input 8-bit or floating-point 32-bit, single-channel image.\n.   @param corners Output vector of detected corners.\n.   @param maxCorners Maximum number of corners to return. If there are more corners than are found,\n.   the strongest of them is returned. `maxCorners <= 0` implies that no limit on the maximum is set\n.   and all detected corners are returned.\n.   @param qualityLevel Parameter characterizing the minimal accepted quality of image corners. The\n.   parameter value is multiplied by the best corner quality measure, which is the minimal eigenvalue\n.   (see #cornerMinEigenVal ) or the Harris function response (see #cornerHarris ). The corners with the\n.   quality measure less than the product are rejected. For example, if the best corner has the\n.   quality measure = 1500, and the qualityLevel=0.01 , then all the corners with the quality measure\n.   less than 15 are rejected.\n.   @param minDistance Minimum possible Euclidean distance between the returned corners.\n.   @param mask Region of interest. If the image is not empty (it needs to have the type\n.   CV_8UC1 and the same size as image ), it specifies the region in which the corners are detected.\n.   @param cornersQuality Output vector of quality measure of the detected corners.\n.   @param blockSize Size of an average block for computing a derivative covariation matrix over each\n.   pixel neighborhood. See cornerEigenValsAndVecs .\n.   @param gradientSize Aperture parameter for the Sobel operator used for derivatives computation.\n.   See cornerEigenValsAndVecs .\n.   @param useHarrisDetector Parameter indicating whether to use a Harris detector (see #cornerHarris)\n.   or #cornerMinEigenVal.\n.   @param k Free parameter of the Harris detector."},
    {"grabCut", CV_PY_FN_WITH_KW_(pyopencv_cv_grabCut, 0), "grabCut(img, mask, rect, bgdModel, fgdModel, iterCount[, mode]) -> mask, bgdModel, fgdModel\n.   @brief Runs the GrabCut algorithm.\n.   \n.   The function implements the [GrabCut image segmentation algorithm](https://en.wikipedia.org/wiki/GrabCut).\n.   \n.   @param img Input 8-bit 3-channel image.\n.   @param mask Input/output 8-bit single-channel mask. The mask is initialized by the function when\n.   mode is set to #GC_INIT_WITH_RECT. Its elements may have one of the #GrabCutClasses.\n.   @param rect ROI containing a segmented object. The pixels outside of the ROI are marked as\n.   \"obvious background\". The parameter is only used when mode==#GC_INIT_WITH_RECT .\n.   @param bgdModel Temporary array for the background model. Do not modify it while you are\n.   processing the same image.\n.   @param fgdModel Temporary arrays for the foreground model. Do not modify it while you are\n.   processing the same image.\n.   @param iterCount Number of iterations the algorithm should make before returning the result. Note\n.   that the result can be refined with further calls with mode==#GC_INIT_WITH_MASK or\n.   mode==GC_EVAL .\n.   @param mode Operation mode that could be one of the #GrabCutModes"},
    {"groupRectangles", CV_PY_FN_WITH_KW_(pyopencv_cv_groupRectangles, 0), "groupRectangles(rectList, groupThreshold[, eps]) -> rectList, weights\n.   @overload"},
    {"hasNonZero", CV_PY_FN_WITH_KW_(pyopencv_cv_hasNonZero, 0), "hasNonZero(src) -> retval\n.   @brief Checks for the presence of at least one non-zero array element.\n.   \n.   The function returns whether there are non-zero elements in src\n.   \n.   The function do not work with multi-channel arrays. If you need to check non-zero array\n.   elements across all the channels, use Mat::reshape first to reinterpret the array as\n.   single-channel. Or you may extract the particular channel using either extractImageCOI, or\n.   mixChannels, or split.\n.   \n.   @note\n.   - If the location of non-zero array elements is important, @ref findNonZero is helpful.\n.   - If the count of non-zero array elements is important, @ref countNonZero is helpful.\n.   @param src single-channel array.\n.   @sa  mean, meanStdDev, norm, minMaxLoc, calcCovarMatrix\n.   @sa  findNonZero, countNonZero"},
    {"haveImageReader", CV_PY_FN_WITH_KW_(pyopencv_cv_haveImageReader, 0), "haveImageReader(filename) -> retval\n.   @brief Checks if the specified image file can be decoded by OpenCV.\n.   \n.   The function haveImageReader checks if OpenCV is capable of reading the specified file.\n.   This can be useful for verifying support for a given image format before attempting to load an image.\n.   \n.   @param filename The name of the file to be checked.\n.   @return true if an image reader for the specified file is available and the file can be opened, false otherwise.\n.   \n.   @note The function checks the availability of image codecs that are either built into OpenCV or dynamically loaded.\n.   It does not load the image codec implementation and decode data, but uses signature check.\n.   If the file cannot be opened or the format is unsupported, the function will return false.\n.   \n.   @sa cv::haveImageWriter, cv::imread, cv::imdecode"},
    {"haveImageWriter", CV_PY_FN_WITH_KW_(pyopencv_cv_haveImageWriter, 0), "haveImageWriter(filename) -> retval\n.   @brief Checks if the specified image file or specified file extension can be encoded by OpenCV.\n.   \n.   The function haveImageWriter checks if OpenCV is capable of writing images with the specified file extension.\n.   This can be useful for verifying support for a given image format before attempting to save an image.\n.   \n.   @param filename The name of the file or the file extension (e.g., \".jpg\", \".png\").\n.   It is recommended to provide the file extension rather than the full file name.\n.   @return true if an image writer for the specified extension is available, false otherwise.\n.   \n.   @note The function checks the availability of image codecs that are either built into OpenCV or dynamically loaded.\n.   It does not check for the actual existence of the file but rather the ability to write files of the given type.\n.   \n.   @sa cv::haveImageReader, cv::imwrite, cv::imencode"},
    {"haveOpenVX", CV_PY_FN_WITH_KW_(pyopencv_cv_haveOpenVX, 0), "haveOpenVX() -> retval\n."},
    {"hconcat", CV_PY_FN_WITH_KW_(pyopencv_cv_hconcat, 0), "hconcat(src[, dst]) -> dst\n.   @overload\n.    @code{.cpp}\n.       std::vector<cv::Mat> matrices = { cv::Mat(4, 1, CV_8UC1, cv::Scalar(1)),\n.                                         cv::Mat(4, 1, CV_8UC1, cv::Scalar(2)),\n.                                         cv::Mat(4, 1, CV_8UC1, cv::Scalar(3)),};\n.   \n.       cv::Mat out;\n.       cv::hconcat( matrices, out );\n.       //out:\n.       //[1, 2, 3;\n.       // 1, 2, 3;\n.       // 1, 2, 3;\n.       // 1, 2, 3]\n.    @endcode\n.    @param src input array or vector of matrices. all of the matrices must have the same number of rows and the same depth.\n.    @param dst output array. It has the same number of rows and depth as the src, and the sum of cols of the src.\n.   same depth."},
    {"idct", CV_PY_FN_WITH_KW_(pyopencv_cv_idct, 0), "idct(src[, dst[, flags]]) -> dst\n.   @brief Calculates the inverse Discrete Cosine Transform of a 1D or 2D array.\n.   \n.   idct(src, dst, flags) is equivalent to dct(src, dst, flags | DCT_INVERSE).\n.   @param src input floating-point single-channel array.\n.   @param dst output array of the same size and type as src.\n.   @param flags operation flags.\n.   @sa  dct, dft, idft, getOptimalDFTSize"},
    {"idft", CV_PY_FN_WITH_KW_(pyopencv_cv_idft, 0), "idft(src[, dst[, flags[, nonzeroRows]]]) -> dst\n.   @brief Calculates the inverse Discrete Fourier Transform of a 1D or 2D array.\n.   \n.   idft(src, dst, flags) is equivalent to dft(src, dst, flags | #DFT_INVERSE) .\n.   @note None of dft and idft scales the result by default. So, you should pass #DFT_SCALE to one of\n.   dft or idft explicitly to make these transforms mutually inverse.\n.   @sa dft, dct, idct, mulSpectrums, getOptimalDFTSize\n.   @param src input floating-point real or complex array.\n.   @param dst output array whose size and type depend on the flags.\n.   @param flags operation flags (see dft and #DftFlags).\n.   @param nonzeroRows number of dst rows to process; the rest of the rows have undefined content (see\n.   the convolution sample in dft description."},
    {"illuminationChange", CV_PY_FN_WITH_KW_(pyopencv_cv_illuminationChange, 0), "illuminationChange(src, mask[, dst[, alpha[, beta]]]) -> dst\n.   @brief Applying an appropriate non-linear transformation to the gradient field inside the selection and\n.   then integrating back with a Poisson solver, modifies locally the apparent illumination of an image.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param alpha Value ranges between 0-2.\n.   @param beta Value ranges between 0-2.\n.   \n.   This is useful to highlight under-exposed foreground objects or to reduce specular reflections."},
    {"imcount", CV_PY_FN_WITH_KW_(pyopencv_cv_imcount, 0), "imcount(filename[, flags]) -> retval\n.   @brief Returns the number of images inside the given file\n.   \n.   The function imcount returns the number of pages in a multi-page image (e.g. TIFF), the number of frames in an animation (e.g. AVIF), and 1 otherwise.\n.   If the image cannot be decoded, 0 is returned.\n.   @param filename Name of file to be loaded.\n.   @param flags Flag that can take values of cv::ImreadModes, default with cv::IMREAD_ANYCOLOR.\n.   @todo when cv::IMREAD_LOAD_GDAL flag used the return value will be 0 or 1 because OpenCV's GDAL decoder doesn't support multi-page reading yet."},
    {"imdecode", CV_PY_FN_WITH_KW_(pyopencv_cv_imdecode, 0), "imdecode(buf, flags) -> retval\n.   @brief Reads an image from a buffer in memory.\n.   \n.   The function imdecode reads an image from the specified buffer in the memory. If the buffer is too short or\n.   contains invalid data, the function returns an empty matrix ( Mat::data==NULL ).\n.   \n.   See cv::imread for the list of supported formats and flags description.\n.   \n.   @note In the case of color images, the decoded images will have the channels stored in **B G R** order.\n.   @param buf Input array or vector of bytes.\n.   @param flags The same flags as in cv::imread, see cv::ImreadModes."},
    {"imdecodeWithMetadata", CV_PY_FN_WITH_KW_(pyopencv_cv_imdecodeWithMetadata, 0), "imdecodeWithMetadata(buf[, metadata[, flags]]) -> retval, metadataTypes, metadata\n.   @brief Reads an image from a buffer in memory together with associated metadata.\n.   \n.   The function imdecode reads an image from the specified buffer in the memory. If the buffer is too short or\n.   contains invalid data, the function returns an empty matrix ( Mat::data==NULL ).\n.   \n.   See cv::imread for the list of supported formats and flags description.\n.   \n.   @note In the case of color images, the decoded images will have the channels stored in **B G R** order.\n.   @param buf Input array or vector of bytes.\n.   @param metadataTypes Output vector with types of metadata chucks returned in metadata, see ImageMetadataType.\n.   @param metadata Output vector of vectors or vector of matrices to store the retrieved metadata\n.   @param flags The same flags as in cv::imread, see cv::ImreadModes."},
    {"imdecodeanimation", CV_PY_FN_WITH_KW_(pyopencv_cv_imdecodeanimation, 0), "imdecodeanimation(buf[, start[, count]]) -> retval, animation\n.   @brief Loads frames from an animated image buffer into an Animation structure.\n.   \n.   The function imdecodeanimation loads frames from an animated image buffer (e.g., GIF, AVIF, APNG, WEBP) into the provided Animation struct.\n.   \n.   @param buf A reference to an InputArray containing the image buffer.\n.   @param animation A reference to an Animation structure where the loaded frames will be stored. It should be initialized before the function is called.\n.   @param start The index of the first frame to load. This is optional and defaults to 0.\n.   @param count The number of frames to load. This is optional and defaults to 32767.\n.   \n.   @return Returns true if the buffer was successfully loaded and frames were extracted; returns false otherwise."},
    {"imdecodemulti", CV_PY_FN_WITH_KW_(pyopencv_cv_imdecodemulti, 0), "imdecodemulti(buf, flags[, mats[, range]]) -> retval, mats\n.   @brief Reads a multi-page image from a buffer in memory.\n.   \n.   The function imdecodemulti reads a multi-page image from the specified buffer in the memory. If the buffer is too short or\n.   contains invalid data, the function returns false.\n.   \n.   See cv::imreadmulti for the list of supported formats and flags description.\n.   \n.   @note In the case of color images, the decoded images will have the channels stored in **B G R** order.\n.   @param buf Input array or vector of bytes.\n.   @param flags The same flags as in cv::imread, see cv::ImreadModes.\n.   @param mats A vector of Mat objects holding each page, if more than one.\n.   @param range A continuous selection of pages."},
    {"imencode", CV_PY_FN_WITH_KW_(pyopencv_cv_imencode, 0), "imencode(ext, img[, params]) -> retval, buf\n.   @brief Encodes an image into a memory buffer.\n.   \n.   The function imencode compresses the image and stores it in the memory buffer that is resized to fit the\n.   result. See cv::imwrite for the list of supported formats and flags description.\n.   \n.   @param ext File extension that defines the output format. Must include a leading period.\n.   @param img Image to be compressed.\n.   @param buf Output buffer resized to fit the compressed image.\n.   @param params Format-specific parameters. See cv::imwrite and cv::ImwriteFlags."},
    {"imencodeWithMetadata", CV_PY_FN_WITH_KW_(pyopencv_cv_imencodeWithMetadata, 0), "imencodeWithMetadata(ext, img, metadataTypes, metadata[, params]) -> retval, buf\n.   @brief Encodes an image into a memory buffer.\n.   \n.   The function imencode compresses the image and stores it in the memory buffer that is resized to fit the\n.   result. See cv::imwrite for the list of supported formats and flags description.\n.   \n.   @param ext File extension that defines the output format. Must include a leading period.\n.   @param img Image to be compressed.\n.   @param metadataTypes Vector with types of metadata chucks stored in metadata to write, see ImageMetadataType.\n.   @param metadata Vector of vectors or vector of matrices with chunks of metadata to store into the file\n.   @param buf Output buffer resized to fit the compressed image.\n.   @param params Format-specific parameters. See cv::imwrite and cv::ImwriteFlags."},
    {"imencodeanimation", CV_PY_FN_WITH_KW_(pyopencv_cv_imencodeanimation, 0), "imencodeanimation(ext, animation[, params]) -> retval, buf\n.   @brief Encodes an Animation to a memory buffer.\n.   \n.   The function imencodeanimation encodes the provided Animation data into a memory\n.   buffer in an animated format. Supported formats depend on the implementation and\n.   may include formats like GIF, AVIF, APNG, or WEBP.\n.   \n.   @param ext The file extension that determines the format of the encoded data.\n.   @param animation A constant reference to an Animation struct containing the\n.   frames and metadata to be encoded.\n.   @param buf A reference to a vector of unsigned chars where the encoded data will\n.   be stored.\n.   @param params Optional format-specific parameters encoded as pairs (paramId_1,\n.   paramValue_1, paramId_2, paramValue_2, ...). These parameters are used to\n.   specify additional options for the encoding process. Refer to `cv::ImwriteFlags`\n.   for details on possible parameters.\n.   \n.   @return Returns true if the animation was successfully encoded; returns false otherwise."},
    {"imencodemulti", CV_PY_FN_WITH_KW_(pyopencv_cv_imencodemulti, 0), "imencodemulti(ext, imgs[, params]) -> retval, buf\n.   @brief Encodes array of images into a memory buffer.\n.   \n.   The function is analog to cv::imencode for in-memory multi-page image compression.\n.   See cv::imwrite for the list of supported formats and flags description.\n.   \n.   @param ext File extension that defines the output format. Must include a leading period.\n.   @param imgs Vector of images to be written.\n.   @param buf Output buffer resized to fit the compressed data.\n.   @param params Format-specific parameters. See cv::imwrite and cv::ImwriteFlags."},
    {"imread", CV_PY_FN_WITH_KW_(pyopencv_cv_imread, 0), "imread(filename[, flags]) -> retval\n.   @brief Loads an image from a file.\n.   \n.   @anchor imread\n.   \n.   The `imread` function loads an image from the specified file and returns OpenCV matrix. If the image cannot be\n.   read (because of a missing file, improper permissions, or unsupported/invalid format), the function\n.   returns an empty matrix.\n.   \n.   Currently, the following file formats are supported:\n.   \n.   -   Windows bitmaps - \\*.bmp, \\*.dib (always supported)\n.   -   GIF files - \\*.gif (always supported)\n.   -   JPEG files - \\*.jpeg, \\*.jpg, \\*.jpe (see the *Note* section)\n.   -   JPEG 2000 files - \\*.jp2 (see the *Note* section)\n.   -   Portable Network Graphics - \\*.png (see the *Note* section)\n.   -   WebP - \\*.webp (see the *Note* section)\n.   -   AVIF - \\*.avif (see the *Note* section)\n.   -   Portable image format - \\*.pbm, \\*.pgm, \\*.ppm, \\*.pxm, \\*.pnm (always supported)\n.   -   PFM files - \\*.pfm (see the *Note* section)\n.   -   Sun rasters - \\*.sr, \\*.ras (always supported)\n.   -   TIFF files - \\*.tiff, \\*.tif (see the *Note* section)\n.   -   OpenEXR Image files - \\*.exr (see the *Note* section)\n.   -   Radiance HDR - \\*.hdr, \\*.pic (always supported)\n.   -   Raster and Vector geospatial data supported by GDAL (see the *Note* section)\n.   \n.   @note\n.   -   The function determines the type of an image by its content, not by the file extension.\n.   -   In the case of color images, the decoded images will have the channels stored in **B G R** order.\n.   -   When using IMREAD_GRAYSCALE, the codec's internal grayscale conversion will be used, if available.\n.       Results may differ from the output of cvtColor().\n.   -   On Microsoft Windows\\* and Mac OS\\*, the codecs shipped with OpenCV (libjpeg, libpng, libtiff,\n.       and libjasper) are used by default. So, OpenCV can always read JPEGs, PNGs, and TIFFs. On Mac OS,\n.       there is also an option to use native Mac OS image readers. However, beware that currently these\n.       native image loaders give images with different pixel values because of the color management embedded\n.       into Mac OS.\n.   -   On Linux\\*, BSD flavors, and other Unix-like open-source operating systems, OpenCV looks for\n.       codecs supplied with the OS. Ensure the relevant packages are installed (including development\n.       files, such as \"libjpeg-dev\" in Debian\\* and Ubuntu\\*) to get codec support, or turn\n.       on the OPENCV_BUILD_3RDPARTY_LIBS flag in CMake.\n.   -   If the *WITH_GDAL* flag is set to true in CMake and @ref IMREAD_LOAD_GDAL is used to load the image,\n.       the [GDAL](http://www.gdal.org) driver will be used to decode the image, supporting\n.       [Raster](http://www.gdal.org/formats_list.html) and [Vector](http://www.gdal.org/ogr_formats.html) formats.\n.   -   If EXIF information is embedded in the image file, the EXIF orientation will be taken into account,\n.       and thus the image will be rotated accordingly unless the flags @ref IMREAD_IGNORE_ORIENTATION\n.       or @ref IMREAD_UNCHANGED are passed.\n.   -   Use the IMREAD_UNCHANGED flag to preserve the floating-point values from PFM images.\n.   -   By default, the number of pixels must be less than 2^30. This limit can be changed by setting\n.       the environment variable `OPENCV_IO_MAX_IMAGE_PIXELS`. See @ref tutorial_env_reference.\n.   \n.   @param filename Name of the file to be loaded.\n.   @param flags Flag that can take values of `cv::ImreadModes`.\n\n\n\nimread(filename[, dst[, flags]]) -> dst\n.   @brief Loads an image from a file.\n.   \n.   This is an overloaded member function, provided for convenience. It differs from the above function only in what argument(s) it accepts and the return value.\n.   @param filename Name of file to be loaded.\n.   @param dst object in which the image will be loaded.\n.   @param flags Flag that can take values of cv::ImreadModes\n.   @note\n.   The image passing through the img parameter can be pre-allocated. The memory is reused if the shape and the type match with the load image."},
    {"imreadWithMetadata", CV_PY_FN_WITH_KW_(pyopencv_cv_imreadWithMetadata, 0), "imreadWithMetadata(filename[, metadata[, flags]]) -> retval, metadataTypes, metadata\n.   @brief Reads an image from a file together with associated metadata.\n.   \n.   The function imreadWithMetadata reads image from the specified file. It does the same thing as imread, but additionally reads metadata if the corresponding file contains any.\n.   @param filename Name of the file to be loaded.\n.   @param metadataTypes Output vector with types of metadata chucks returned in metadata, see ImageMetadataType.\n.   @param metadata Output vector of vectors or vector of matrices to store the retrieved metadata\n.   @param flags Flag that can take values of cv::ImreadModes"},
    {"imreadanimation", CV_PY_FN_WITH_KW_(pyopencv_cv_imreadanimation, 0), "imreadanimation(filename[, start[, count]]) -> retval, animation\n.   @brief Loads frames from an animated image file into an Animation structure.\n.   \n.   The function imreadanimation loads frames from an animated image file (e.g., GIF, AVIF, APNG, WEBP) into the provided Animation struct.\n.   \n.   @param filename A string containing the path to the file.\n.   @param animation A reference to an Animation structure where the loaded frames will be stored. It should be initialized before the function is called.\n.   @param start The index of the first frame to load. This is optional and defaults to 0.\n.   @param count The number of frames to load. This is optional and defaults to 32767.\n.   \n.   @return Returns true if the file was successfully loaded and frames were extracted; returns false otherwise."},
    {"imreadmulti", CV_PY_FN_WITH_KW_(pyopencv_cv_imreadmulti, 0), "imreadmulti(filename[, mats[, flags]]) -> retval, mats\n.   @brief Loads a multi-page image from a file.\n.   \n.   The function imreadmulti loads a multi-page image from the specified file into a vector of Mat objects.\n.   @param filename Name of file to be loaded.\n.   @param mats A vector of Mat objects holding each page.\n.   @param flags Flag that can take values of cv::ImreadModes, default with cv::IMREAD_ANYCOLOR.\n.   @sa cv::imread\n\n\n\nimreadmulti(filename, start, count[, mats[, flags]]) -> retval, mats\n.   @brief Loads images of a multi-page image from a file.\n.   \n.   The function imreadmulti loads a specified range from a multi-page image from the specified file into a vector of Mat objects.\n.   @param filename Name of file to be loaded.\n.   @param mats A vector of Mat objects holding each page.\n.   @param start Start index of the image to load\n.   @param count Count number of images to load\n.   @param flags Flag that can take values of cv::ImreadModes, default with cv::IMREAD_ANYCOLOR.\n.   @sa cv::imread"},
    {"imshow", CV_PY_FN_WITH_KW_(pyopencv_cv_imshow, 0), "imshow(winname, mat) -> None\n.   @brief Displays an image in the specified window.\n.   \n.   The function imshow displays an image in the specified window. If the window was created with the\n.   cv::WINDOW_AUTOSIZE flag, the image is shown with its original size, however it is still limited by the screen resolution.\n.   Otherwise, the image is scaled to fit the window. The function may scale the image, depending on its depth:\n.   \n.   -   If the image is 8-bit unsigned, it is displayed as is.\n.   -   If the image is 16-bit unsigned, the pixels are divided by 256. That is, the\n.       value range [0,255\\*256] is mapped to [0,255].\n.   -   If the image is 32-bit or 64-bit floating-point, the pixel values are multiplied by 255. That is, the\n.       value range [0,1] is mapped to [0,255].\n.   -   32-bit integer images are not processed anymore due to ambiguouty of required transform.\n.       Convert to 8-bit unsigned matrix using a custom preprocessing specific to image's context.\n.   \n.   If window was created with OpenGL support, cv::imshow also support ogl::Buffer , ogl::Texture2D and\n.   cuda::GpuMat as input.\n.   \n.   If the window was not created before this function, it is assumed creating a window with cv::WINDOW_AUTOSIZE.\n.   \n.   If you need to show an image that is bigger than the screen resolution, you will need to call namedWindow(\"\", WINDOW_NORMAL) before the imshow.\n.   \n.   @note This function should be followed by a call to cv::waitKey or cv::pollKey to perform GUI\n.   housekeeping tasks that are necessary to actually show the given image and make the window respond\n.   to mouse and keyboard events. Otherwise, it won't display the image and the window might lock up.\n.   For example, **waitKey(0)** will display the window infinitely until any keypress (it is suitable\n.   for image display). **waitKey(25)** will display a frame and wait approximately 25 ms for a key\n.   press (suitable for displaying a video frame-by-frame). To remove the window, use cv::destroyWindow.\n.   \n.   @note [__Windows Backend Only__] Pressing Ctrl+C will copy the image to the clipboard. Pressing Ctrl+S will show a dialog to save the image.\n.   @note [__Wayland Backend Only__] Supoorting format is extended.\n.   -   If the image is 8-bit signed, the pixels are biased by 128. That is, the\n.       value range [-128,127] is mapped to [0,255].\n.   -   If the image is 16-bit signed, the pixels are divided by 256 and biased by 128. That is, the\n.       value range [-32768,32767] is mapped to [0,255].\n.   \n.   @param winname Name of the window.\n.   @param mat Image to be shown."},
    {"imwrite", CV_PY_FN_WITH_KW_(pyopencv_cv_imwrite, 0), "imwrite(filename, img[, params]) -> retval\n.   @brief Saves an image to a specified file.\n.   \n.   The function imwrite saves the image to the specified file. The image format is chosen based on the\n.   filename extension (see cv::imread for the list of extensions). In general, only 8-bit unsigned (CV_8U)\n.   single-channel or 3-channel (with 'BGR' channel order) images\n.   can be saved using this function, with these exceptions:\n.   \n.   - With OpenEXR encoder, only 32-bit float (CV_32F) images can be saved.\n.     - 8-bit unsigned (CV_8U) images are not supported.\n.   - With Radiance HDR encoder, non 64-bit float (CV_64F) images can be saved.\n.     - All images will be converted to 32-bit float (CV_32F).\n.   - With JPEG 2000 encoder, 8-bit unsigned (CV_8U) and 16-bit unsigned (CV_16U) images can be saved.\n.   - With JPEG XL encoder, 8-bit unsigned (CV_8U), 16-bit unsigned (CV_16U) and 32-bit float(CV_32F) images can be saved.\n.     - JPEG XL images with an alpha channel can be saved using this function.\n.       To achieve this, create an 8-bit 4-channel (CV_8UC4) / 16-bit 4-channel (CV_16UC4) / 32-bit float 4-channel (CV_32FC4) BGRA image, ensuring the alpha channel is the last component.\n.       Fully transparent pixels should have an alpha value of 0, while fully opaque pixels should have an alpha value of 255/65535/1.0.\n.   - With PAM encoder, 8-bit unsigned (CV_8U) and 16-bit unsigned (CV_16U) images can be saved.\n.   - With PNG encoder, 8-bit unsigned (CV_8U) and 16-bit unsigned (CV_16U) images can be saved.\n.     - PNG images with an alpha channel can be saved using this function.\n.       To achieve this, create an 8-bit 4-channel (CV_8UC4) / 16-bit 4-channel (CV_16UC4) BGRA image, ensuring the alpha channel is the last component.\n.       Fully transparent pixels should have an alpha value of 0, while fully opaque pixels should have an alpha value of 255/65535(see the code sample below).\n.   - With PGM/PPM encoder, 8-bit unsigned (CV_8U) and 16-bit unsigned (CV_16U) images can be saved.\n.   - With TIFF encoder, 8-bit unsigned (CV_8U), 8-bit signed (CV_8S),\n.                        16-bit unsigned (CV_16U), 16-bit signed (CV_16S),\n.                        32-bit signed (CV_32S),\n.                        32-bit float (CV_32F) and 64-bit float (CV_64F) images can be saved.\n.     - Multiple images (vector of Mat) can be saved in TIFF format (see the code sample below).\n.     - 32-bit float 3-channel (CV_32FC3) TIFF images will be saved\n.       using the LogLuv high dynamic range encoding (4 bytes per pixel)\n.   - With GIF encoder, 8-bit unsigned (CV_8U) images can be saved.\n.     - GIF images with an alpha channel can be saved using this function.\n.       To achieve this, create an 8-bit 4-channel (CV_8UC4) BGRA image, ensuring the alpha channel is the last component.\n.       Fully transparent pixels should have an alpha value of 0, while fully opaque pixels should have an alpha value of 255.\n.     - 8-bit single-channel images (CV_8UC1) are not supported due to GIF's limitation to indexed color formats.\n.   \n.   If the image format is not supported, the image will be converted to 8-bit unsigned (CV_8U) and saved that way.\n.   \n.   If the format, depth or channel order is different, use\n.   Mat::convertTo and cv::cvtColor to convert it before saving. Or, use the universal FileStorage I/O\n.   functions to save the image to XML or YAML format.\n.   \n.   The sample below shows how to create a BGRA image, how to set custom compression parameters and save it to a PNG file.\n.   It also demonstrates how to save multiple images in a TIFF file:\n.   @include snippets/imgcodecs_imwrite.cpp\n.   @param filename Name of the file.\n.   @param img (Mat or vector of Mat) Image or Images to be saved.\n.   @param params Format-specific parameters encoded as pairs (paramId_1, paramValue_1, paramId_2, paramValue_2, ... .) see cv::ImwriteFlags"},
    {"imwriteWithMetadata", CV_PY_FN_WITH_KW_(pyopencv_cv_imwriteWithMetadata, 0), "imwriteWithMetadata(filename, img, metadataTypes, metadata[, params]) -> retval\n.   @brief Saves an image to a specified file with metadata\n.   \n.   The function imwriteWithMetadata saves the image to the specified file. It does the same thing as imwrite, but additionally writes metadata if the corresponding format supports it.\n.   @param filename Name of the file. As with imwrite, image format is determined by the file extension.\n.   @param img (Mat or vector of Mat) Image or Images to be saved.\n.   @param metadataTypes Vector with types of metadata chucks stored in metadata to write, see ImageMetadataType.\n.   @param metadata Vector of vectors or vector of matrices with chunks of metadata to store into the file\n.   @param params Format-specific parameters encoded as pairs (paramId_1, paramValue_1, paramId_2, paramValue_2, ... .) see cv::ImwriteFlags"},
    {"imwriteanimation", CV_PY_FN_WITH_KW_(pyopencv_cv_imwriteanimation, 0), "imwriteanimation(filename, animation[, params]) -> retval\n.   @brief Saves an Animation to a specified file.\n.   \n.   The function imwriteanimation saves the provided Animation data to the specified file in an animated format.\n.   Supported formats depend on the implementation and may include formats like GIF, AVIF, APNG, or WEBP.\n.   \n.   @param filename The name of the file where the animation will be saved. The file extension determines the format.\n.   @param animation A constant reference to an Animation struct containing the frames and metadata to be saved.\n.   @param params Optional format-specific parameters encoded as pairs (paramId_1, paramValue_1, paramId_2, paramValue_2, ...).\n.   These parameters are used to specify additional options for the encoding process. Refer to `cv::ImwriteFlags` for details on possible parameters.\n.   \n.   @return Returns true if the animation was successfully saved; returns false otherwise."},
    {"imwritemulti", CV_PY_FN_WITH_KW_(pyopencv_cv_imwritemulti, 0), "imwritemulti(filename, img[, params]) -> retval\n."},
    {"inRange", CV_PY_FN_WITH_KW_(pyopencv_cv_inRange, 0), "inRange(src, lowerb, upperb[, dst]) -> dst\n.   @brief  Checks if array elements lie between the elements of two other arrays.\n.   \n.   The function checks the range as follows:\n.   -   For every element of a single-channel input array:\n.       \\f[\\texttt{dst} (I)= \\texttt{lowerb} (I)_0  \\leq \\texttt{src} (I)_0 \\leq  \\texttt{upperb} (I)_0\\f]\n.   -   For two-channel arrays:\n.       \\f[\\texttt{dst} (I)= \\texttt{lowerb} (I)_0  \\leq \\texttt{src} (I)_0 \\leq  \\texttt{upperb} (I)_0  \\land \\texttt{lowerb} (I)_1  \\leq \\texttt{src} (I)_1 \\leq  \\texttt{upperb} (I)_1\\f]\n.   -   and so forth.\n.   \n.   That is, dst (I) is set to 255 (all 1 -bits) if src (I) is within the\n.   specified 1D, 2D, 3D, ... box and 0 otherwise.\n.   \n.   When the lower and/or upper boundary parameters are scalars, the indexes\n.   (I) at lowerb and upperb in the above formulas should be omitted.\n.   @param src first input array.\n.   @param lowerb inclusive lower boundary array or a scalar.\n.   @param upperb inclusive upper boundary array or a scalar.\n.   @param dst output array of the same size as src and CV_8U type."},
    {"initCameraMatrix2D", CV_PY_FN_WITH_KW_(pyopencv_cv_initCameraMatrix2D, 0), "initCameraMatrix2D(objectPoints, imagePoints, imageSize[, aspectRatio]) -> retval\n.   @brief Finds an initial camera intrinsic matrix from 3D-2D point correspondences.\n.   \n.   @param objectPoints Vector of vectors of the calibration pattern points in the calibration pattern\n.   coordinate space. In the old interface all the per-view vectors are concatenated. See\n.   #calibrateCamera for details.\n.   @param imagePoints Vector of vectors of the projections of the calibration pattern points. In the\n.   old interface all the per-view vectors are concatenated.\n.   @param imageSize Image size in pixels used to initialize the principal point.\n.   @param aspectRatio If it is zero or negative, both \\f$f_x\\f$ and \\f$f_y\\f$ are estimated independently.\n.   Otherwise, \\f$f_x = f_y \\cdot \\texttt{aspectRatio}\\f$ .\n.   \n.   The function estimates and returns an initial camera intrinsic matrix for the camera calibration process.\n.   Currently, the function only supports planar calibration patterns, which are patterns where each\n.   object point has z-coordinate =0."},
    {"initInverseRectificationMap", CV_PY_FN_WITH_KW_(pyopencv_cv_initInverseRectificationMap, 0), "initInverseRectificationMap(cameraMatrix, distCoeffs, R, newCameraMatrix, size, m1type[, map1[, map2]]) -> map1, map2\n.   @brief Computes the projection and inverse-rectification transformation map. In essense, this is the inverse of\n.   #initUndistortRectifyMap to accomodate stereo-rectification of projectors ('inverse-cameras') in projector-camera pairs.\n.   \n.   The function computes the joint projection and inverse rectification transformation and represents the\n.   result in the form of maps for #remap. The projected image looks like a distorted version of the original which,\n.   once projected by a projector, should visually match the original. In case of a monocular camera, newCameraMatrix\n.   is usually equal to cameraMatrix, or it can be computed by\n.   #getOptimalNewCameraMatrix for a better control over scaling. In case of a projector-camera pair,\n.   newCameraMatrix is normally set to P1 or P2 computed by #stereoRectify .\n.   \n.   The projector is oriented differently in the coordinate space, according to R. In case of projector-camera pairs,\n.   this helps align the projector (in the same manner as #initUndistortRectifyMap for the camera) to create a stereo-rectified pair. This\n.   allows epipolar lines on both images to become horizontal and have the same y-coordinate (in case of a horizontally aligned projector-camera pair).\n.   \n.   The function builds the maps for the inverse mapping algorithm that is used by #remap. That\n.   is, for each pixel \\f$(u, v)\\f$ in the destination (projected and inverse-rectified) image, the function\n.   computes the corresponding coordinates in the source image (that is, in the original digital image). The following process is applied:\n.   \n.   \\f[\n.   \\begin{array}{l}\n.   \\text{newCameraMatrix}\\\\\n.   x  \\leftarrow (u - {c'}_x)/{f'}_x  \\\\\n.   y  \\leftarrow (v - {c'}_y)/{f'}_y  \\\\\n.   \n.   \\\\\\text{Undistortion}\n.   \\\\\\scriptsize{\\textit{though equation shown is for radial undistortion, function implements cv::undistortPoints()}}\\\\\n.   r^2  \\leftarrow x^2 + y^2 \\\\\n.   \\theta \\leftarrow \\frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}\\\\\n.   x' \\leftarrow \\frac{x}{\\theta} \\\\\n.   y'  \\leftarrow \\frac{y}{\\theta} \\\\\n.   \n.   \\\\\\text{Rectification}\\\\\n.   {[X\\,Y\\,W]} ^T  \\leftarrow R*[x' \\, y' \\, 1]^T  \\\\\n.   x''  \\leftarrow X/W  \\\\\n.   y''  \\leftarrow Y/W  \\\\\n.   \n.   \\\\\\text{cameraMatrix}\\\\\n.   map_x(u,v)  \\leftarrow x'' f_x + c_x  \\\\\n.   map_y(u,v)  \\leftarrow y'' f_y + c_y\n.   \\end{array}\n.   \\f]\n.   where \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   are the distortion coefficients vector distCoeffs.\n.   \n.   In case of a stereo-rectified projector-camera pair, this function is called for the projector while #initUndistortRectifyMap is called for the camera head.\n.   This is done after #stereoRectify, which in turn is called after #stereoCalibrate. If the projector-camera pair\n.   is not calibrated, it is still possible to compute the rectification transformations directly from\n.   the fundamental matrix using #stereoRectifyUncalibrated. For the projector and camera, the function computes\n.   homography H as the rectification transformation in a pixel domain, not a rotation matrix R in 3D\n.   space. R can be computed from H as\n.   \\f[\\texttt{R} = \\texttt{cameraMatrix} ^{-1} \\cdot \\texttt{H} \\cdot \\texttt{cameraMatrix}\\f]\n.   where cameraMatrix can be chosen arbitrarily.\n.   \n.   @param cameraMatrix Input camera matrix \\f$A=\\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param R Optional rectification transformation in the object space (3x3 matrix). R1 or R2,\n.   computed by #stereoRectify can be passed here. If the matrix is empty, the identity transformation\n.   is assumed.\n.   @param newCameraMatrix New camera matrix \\f$A'=\\vecthreethree{f_x'}{0}{c_x'}{0}{f_y'}{c_y'}{0}{0}{1}\\f$.\n.   @param size Distorted image size.\n.   @param m1type Type of the first output map. Can be CV_32FC1, CV_32FC2 or CV_16SC2, see #convertMaps\n.   @param map1 The first output map for #remap.\n.   @param map2 The second output map for #remap."},
    {"initUndistortRectifyMap", CV_PY_FN_WITH_KW_(pyopencv_cv_initUndistortRectifyMap, 0), "initUndistortRectifyMap(cameraMatrix, distCoeffs, R, newCameraMatrix, size, m1type[, map1[, map2]]) -> map1, map2\n.   @brief Computes the undistortion and rectification transformation map.\n.   \n.   The function computes the joint undistortion and rectification transformation and represents the\n.   result in the form of maps for #remap. The undistorted image looks like original, as if it is\n.   captured with a camera using the camera matrix =newCameraMatrix and zero distortion. In case of a\n.   monocular camera, newCameraMatrix is usually equal to cameraMatrix, or it can be computed by\n.   #getOptimalNewCameraMatrix for a better control over scaling. In case of a stereo camera,\n.   newCameraMatrix is normally set to P1 or P2 computed by #stereoRectify .\n.   \n.   Also, this new camera is oriented differently in the coordinate space, according to R. That, for\n.   example, helps to align two heads of a stereo camera so that the epipolar lines on both images\n.   become horizontal and have the same y- coordinate (in case of a horizontally aligned stereo camera).\n.   \n.   The function actually builds the maps for the inverse mapping algorithm that is used by #remap. That\n.   is, for each pixel \\f$(u, v)\\f$ in the destination (corrected and rectified) image, the function\n.   computes the corresponding coordinates in the source image (that is, in the original image from\n.   camera). The following process is applied:\n.   \\f[\n.   \\begin{array}{l}\n.   x  \\leftarrow (u - {c'}_x)/{f'}_x  \\\\\n.   y  \\leftarrow (v - {c'}_y)/{f'}_y  \\\\\n.   {[X\\,Y\\,W]} ^T  \\leftarrow R^{-1}*[x \\, y \\, 1]^T  \\\\\n.   x'  \\leftarrow X/W  \\\\\n.   y'  \\leftarrow Y/W  \\\\\n.   r^2  \\leftarrow x'^2 + y'^2 \\\\\n.   x''  \\leftarrow x' \\frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}\n.   + 2p_1 x' y' + p_2(r^2 + 2 x'^2)  + s_1 r^2 + s_2 r^4\\\\\n.   y''  \\leftarrow y' \\frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}\n.   + p_1 (r^2 + 2 y'^2) + 2 p_2 x' y' + s_3 r^2 + s_4 r^4 \\\\\n.   s\\vecthree{x'''}{y'''}{1} =\n.   \\vecthreethree{R_{33}(\\tau_x, \\tau_y)}{0}{-R_{13}((\\tau_x, \\tau_y)}\n.   {0}{R_{33}(\\tau_x, \\tau_y)}{-R_{23}(\\tau_x, \\tau_y)}\n.   {0}{0}{1} R(\\tau_x, \\tau_y) \\vecthree{x''}{y''}{1}\\\\\n.   map_x(u,v)  \\leftarrow x''' f_x + c_x  \\\\\n.   map_y(u,v)  \\leftarrow y''' f_y + c_y\n.   \\end{array}\n.   \\f]\n.   where \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   are the distortion coefficients.\n.   \n.   In case of a stereo camera, this function is called twice: once for each camera head, after\n.   #stereoRectify, which in its turn is called after #stereoCalibrate. But if the stereo camera\n.   was not calibrated, it is still possible to compute the rectification transformations directly from\n.   the fundamental matrix using #stereoRectifyUncalibrated. For each camera, the function computes\n.   homography H as the rectification transformation in a pixel domain, not a rotation matrix R in 3D\n.   space. R can be computed from H as\n.   \\f[\\texttt{R} = \\texttt{cameraMatrix} ^{-1} \\cdot \\texttt{H} \\cdot \\texttt{cameraMatrix}\\f]\n.   where cameraMatrix can be chosen arbitrarily.\n.   \n.   @param cameraMatrix Input camera matrix \\f$A=\\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param R Optional rectification transformation in the object space (3x3 matrix). R1 or R2 ,\n.   computed by #stereoRectify can be passed here. If the matrix is empty, the identity transformation\n.   is assumed. In #initUndistortRectifyMap R assumed to be an identity matrix.\n.   @param newCameraMatrix New camera matrix \\f$A'=\\vecthreethree{f_x'}{0}{c_x'}{0}{f_y'}{c_y'}{0}{0}{1}\\f$.\n.   @param size Undistorted image size.\n.   @param m1type Type of the first output map that can be CV_32FC1, CV_32FC2 or CV_16SC2, see #convertMaps\n.   @param map1 The first output map.\n.   @param map2 The second output map."},
    {"inpaint", CV_PY_FN_WITH_KW_(pyopencv_cv_inpaint, 0), "inpaint(src, inpaintMask, inpaintRadius, flags[, dst]) -> dst\n.   @brief Restores the selected region in an image using the region neighborhood.\n.   \n.   @param src Input 8-bit, 16-bit unsigned or 32-bit float 1-channel or 8-bit 3-channel image.\n.   @param inpaintMask Inpainting mask, 8-bit 1-channel image. Non-zero pixels indicate the area that\n.   needs to be inpainted.\n.   @param dst Output image with the same size and type as src .\n.   @param inpaintRadius Radius of a circular neighborhood of each point inpainted that is considered\n.   by the algorithm.\n.   @param flags Inpainting method that could be cv::INPAINT_NS or cv::INPAINT_TELEA\n.   \n.   The function reconstructs the selected image area from the pixel near the area boundary. The\n.   function may be used to remove dust and scratches from a scanned photo, or to remove undesirable\n.   objects from still images or video. See <http://en.wikipedia.org/wiki/Inpainting> for more details.\n.   \n.   @note\n.      -   An example using the inpainting technique can be found at\n.           opencv_source_code/samples/cpp/inpaint.cpp\n.      -   (Python) An example using the inpainting technique can be found at\n.           opencv_source_code/samples/python/inpaint.py"},
    {"insertChannel", CV_PY_FN_WITH_KW_(pyopencv_cv_insertChannel, 0), "insertChannel(src, dst, coi) -> dst\n.   @brief Inserts a single channel to dst (coi is 0-based index)\n.   @param src input array\n.   @param dst output array\n.   @param coi index of channel for insertion\n.   @sa mixChannels, merge"},
    {"integral", CV_PY_FN_WITH_KW_(pyopencv_cv_integral, 0), "integral(src[, sum[, sdepth]]) -> sum\n.   @overload"},
    {"integral2", CV_PY_FN_WITH_KW_(pyopencv_cv_integral2, 0), "integral2(src[, sum[, sqsum[, sdepth[, sqdepth]]]]) -> sum, sqsum\n.   @overload"},
    {"integral3", CV_PY_FN_WITH_KW_(pyopencv_cv_integral3, 0), "integral3(src[, sum[, sqsum[, tilted[, sdepth[, sqdepth]]]]]) -> sum, sqsum, tilted\n.   @brief Calculates the integral of an image.\n.   \n.   The function calculates one or more integral images for the source image as follows:\n.   \n.   \\f[\\texttt{sum} (X,Y) =  \\sum _{x<X,y<Y}  \\texttt{image} (x,y)\\f]\n.   \n.   \\f[\\texttt{sqsum} (X,Y) =  \\sum _{x<X,y<Y}  \\texttt{image} (x,y)^2\\f]\n.   \n.   \\f[\\texttt{tilted} (X,Y) =  \\sum _{y<Y,abs(x-X+1) \\leq Y-y-1}  \\texttt{image} (x,y)\\f]\n.   \n.   Using these integral images, you can calculate sum, mean, and standard deviation over a specific\n.   up-right or rotated rectangular region of the image in a constant time, for example:\n.   \n.   \\f[\\sum _{x_1 \\leq x < x_2,  \\, y_1  \\leq y < y_2}  \\texttt{image} (x,y) =  \\texttt{sum} (x_2,y_2)- \\texttt{sum} (x_1,y_2)- \\texttt{sum} (x_2,y_1)+ \\texttt{sum} (x_1,y_1)\\f]\n.   \n.   It makes possible to do a fast blurring or fast block correlation with a variable window size, for\n.   example. In case of multi-channel images, sums for each channel are accumulated independently.\n.   \n.   As a practical example, the next figure shows the calculation of the integral of a straight\n.   rectangle Rect(4,4,3,2) and of a tilted rectangle Rect(5,1,2,3) . The selected pixels in the\n.   original image are shown, as well as the relative pixels in the integral images sum and tilted .\n.   \n.   ![integral calculation example](pics/integral.png)\n.   \n.   @param src input image as \\f$W \\times H\\f$, 8-bit or floating-point (32f or 64f).\n.   @param sum integral image as \\f$(W+1)\\times (H+1)\\f$ , 32-bit integer or floating-point (32f or 64f).\n.   @param sqsum integral image for squared pixel values; it is \\f$(W+1)\\times (H+1)\\f$, double-precision\n.   floating-point (64f) array.\n.   @param tilted integral for the image rotated by 45 degrees; it is \\f$(W+1)\\times (H+1)\\f$ array with\n.   the same data type as sum.\n.   @param sdepth desired depth of the integral and the tilted integral images, CV_32S, CV_32F, or\n.   CV_64F.\n.   @param sqdepth desired depth of the integral image of squared pixel values, CV_32F or CV_64F."},
    {"intersectConvexConvex", CV_PY_FN_WITH_KW_(pyopencv_cv_intersectConvexConvex, 0), "intersectConvexConvex(p1, p2[, p12[, handleNested]]) -> retval, p12\n.   @brief Finds intersection of two convex polygons\n.   \n.   @param p1 First polygon\n.   @param p2 Second polygon\n.   @param p12 Output polygon describing the intersecting area\n.   @param handleNested When true, an intersection is found if one of the polygons is fully enclosed in the other.\n.   When false, no intersection is found. If the polygons share a side or the vertex of one polygon lies on an edge\n.   of the other, they are not considered nested and an intersection will be found regardless of the value of handleNested.\n.   \n.   @returns Area of intersecting polygon. May be negative, if algorithm has not converged, e.g. non-convex input.\n.   \n.   @note intersectConvexConvex doesn't confirm that both polygons are convex and will return invalid results if they aren't."},
    {"invert", CV_PY_FN_WITH_KW_(pyopencv_cv_invert, 0), "invert(src[, dst[, flags]]) -> retval, dst\n.   @brief Finds the inverse or pseudo-inverse of a matrix.\n.   \n.   The function cv::invert inverts the matrix src and stores the result in dst\n.   . When the matrix src is singular or non-square, the function calculates\n.   the pseudo-inverse matrix (the dst matrix) so that norm(src\\*dst - I) is\n.   minimal, where I is an identity matrix.\n.   \n.   In case of the #DECOMP_LU method, the function returns non-zero value if\n.   the inverse has been successfully calculated and 0 if src is singular.\n.   \n.   In case of the #DECOMP_SVD method, the function returns the inverse\n.   condition number of src (the ratio of the smallest singular value to the\n.   largest singular value) and 0 if src is singular. The SVD method\n.   calculates a pseudo-inverse matrix if src is singular.\n.   \n.   Similarly to #DECOMP_LU, the method #DECOMP_CHOLESKY works only with\n.   non-singular square matrices that should also be symmetrical and\n.   positively defined. In this case, the function stores the inverted\n.   matrix in dst and returns non-zero. Otherwise, it returns 0.\n.   \n.   @param src input floating-point M x N matrix.\n.   @param dst output matrix of N x M size and the same type as src.\n.   @param flags inversion method (cv::DecompTypes)\n.   @sa solve, SVD"},
    {"invertAffineTransform", CV_PY_FN_WITH_KW_(pyopencv_cv_invertAffineTransform, 0), "invertAffineTransform(M[, iM]) -> iM\n.   @brief Inverts an affine transformation.\n.   \n.   The function computes an inverse affine transformation represented by \\f$2 \\times 3\\f$ matrix M:\n.   \n.   \\f[\\begin{bmatrix} a_{11} & a_{12} & b_1  \\\\ a_{21} & a_{22} & b_2 \\end{bmatrix}\\f]\n.   \n.   The result is also a \\f$2 \\times 3\\f$ matrix of the same type as M.\n.   \n.   @param M Original affine transformation.\n.   @param iM Output reverse affine transformation."},
    {"isContourConvex", CV_PY_FN_WITH_KW_(pyopencv_cv_isContourConvex, 0), "isContourConvex(contour) -> retval\n.   @brief Tests a contour convexity.\n.   \n.   The function tests whether the input contour is convex or not. The contour must be simple, that is,\n.   without self-intersections. Otherwise, the function output is undefined.\n.   \n.   @param contour Input vector of 2D points, stored in std::vector\\<\\> or Mat"},
    {"kmeans", CV_PY_FN_WITH_KW_(pyopencv_cv_kmeans, 0), "kmeans(data, K, bestLabels, criteria, attempts, flags[, centers]) -> retval, bestLabels, centers\n.   @brief Finds centers of clusters and groups input samples around the clusters.\n.   \n.   The function kmeans implements a k-means algorithm that finds the centers of cluster_count clusters\n.   and groups the input samples around the clusters. As an output, \\f$\\texttt{bestLabels}_i\\f$ contains a\n.   0-based cluster index for the sample stored in the \\f$i^{th}\\f$ row of the samples matrix.\n.   \n.   @note\n.   -   (Python) An example on k-means clustering can be found at\n.       opencv_source_code/samples/python/kmeans.py\n.   @param data Data for clustering. An array of N-Dimensional points with float coordinates is needed.\n.   Examples of this array can be:\n.   -   Mat points(count, 2, CV_32F);\n.   -   Mat points(count, 1, CV_32FC2);\n.   -   Mat points(1, count, CV_32FC2);\n.   -   std::vector\\<cv::Point2f\\> points(sampleCount);\n.   @param K Number of clusters to split the set by.\n.   @param bestLabels Input/output integer array that stores the cluster indices for every sample.\n.   @param criteria The algorithm termination criteria, that is, the maximum number of iterations and/or\n.   the desired accuracy. The accuracy is specified as criteria.epsilon. As soon as each of the cluster\n.   centers moves by less than criteria.epsilon on some iteration, the algorithm stops.\n.   @param attempts Flag to specify the number of times the algorithm is executed using different\n.   initial labellings. The algorithm returns the labels that yield the best compactness (see the last\n.   function parameter).\n.   @param flags Flag that can take values of cv::KmeansFlags\n.   @param centers Output matrix of the cluster centers, one row per each cluster center.\n.   @return The function returns the compactness measure that is computed as\n.   \\f[\\sum _i  \\| \\texttt{samples} _i -  \\texttt{centers} _{ \\texttt{labels} _i} \\| ^2\\f]\n.   after every attempt. The best (minimum) value is chosen and the corresponding labels and the\n.   compactness value are returned by the function. Basically, you can use only the core of the\n.   function, set the number of attempts to 1, initialize labels each time using a custom algorithm,\n.   pass them with the ( flags = #KMEANS_USE_INITIAL_LABELS ) flag, and then choose the best\n.   (most-compact) clustering."},
    {"line", CV_PY_FN_WITH_KW_(pyopencv_cv_line, 0), "line(img, pt1, pt2, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a line segment connecting two points.\n.   \n.   The function line draws the line segment between pt1 and pt2 points in the image. The line is\n.   clipped by the image boundaries. For non-antialiased lines with integer coordinates, the 8-connected\n.   or 4-connected Bresenham algorithm is used. Thick lines are drawn with rounding endings. Antialiased\n.   lines are drawn using Gaussian filtering.\n.   \n.   @param img Image.\n.   @param pt1 First point of the line segment.\n.   @param pt2 Second point of the line segment.\n.   @param color Line color.\n.   @param thickness Line thickness.\n.   @param lineType Type of the line. See #LineTypes.\n.   @param shift Number of fractional bits in the point coordinates."},
    {"linearPolar", CV_PY_FN_WITH_KW_(pyopencv_cv_linearPolar, 0), "linearPolar(src, center, maxRadius, flags[, dst]) -> dst\n.   @brief Remaps an image to polar coordinates space.\n.   \n.   @deprecated This function produces same result as cv::warpPolar(src, dst, src.size(), center, maxRadius, flags)\n.   \n.   @internal\n.   Transform the source image using the following transformation (See @ref polar_remaps_reference_image \"Polar remaps reference image c)\"):\n.   \\f[\\begin{array}{l}\n.     dst( \\rho , \\phi ) = src(x,y) \\\\\n.     dst.size() \\leftarrow src.size()\n.   \\end{array}\\f]\n.   \n.   where\n.   \\f[\\begin{array}{l}\n.     I = (dx,dy) = (x - center.x,y - center.y) \\\\\n.     \\rho = Kmag \\cdot \\texttt{magnitude} (I) ,\\\\\n.     \\phi = angle \\cdot \\texttt{angle} (I)\n.   \\end{array}\\f]\n.   \n.   and\n.   \\f[\\begin{array}{l}\n.     Kx = src.cols / maxRadius \\\\\n.     Ky = src.rows / 2\\Pi\n.   \\end{array}\\f]\n.   \n.   \n.   @param src Source image\n.   @param dst Destination image. It will have same size and type as src.\n.   @param center The transformation center;\n.   @param maxRadius The radius of the bounding circle to transform. It determines the inverse magnitude scale parameter too.\n.   @param flags A combination of interpolation methods, see #InterpolationFlags\n.   \n.   @note\n.   -   The function can not operate in-place.\n.   -   To calculate magnitude and angle in degrees #cartToPolar is used internally thus angles are measured from 0 to 360 with accuracy about 0.3 degrees.\n.   \n.   @sa cv::logPolar\n.   @endinternal"},
    {"log", CV_PY_FN_WITH_KW_(pyopencv_cv_log, 0), "log(src[, dst]) -> dst\n.   @brief Calculates the natural logarithm of every array element.\n.   \n.   The function cv::log calculates the natural logarithm of every element of the input array:\n.   \\f[\\texttt{dst} (I) =  \\log (\\texttt{src}(I)) \\f]\n.   \n.   Output on zero, negative and special (NaN, Inf) values is undefined.\n.   \n.   @param src input array.\n.   @param dst output array of the same size and type as src .\n.   @sa exp, cartToPolar, polarToCart, phase, pow, sqrt, magnitude"},
    {"logPolar", CV_PY_FN_WITH_KW_(pyopencv_cv_logPolar, 0), "logPolar(src, center, M, flags[, dst]) -> dst\n.   @brief Remaps an image to semilog-polar coordinates space.\n.   \n.   @deprecated This function produces same result as cv::warpPolar(src, dst, src.size(), center, maxRadius, flags+WARP_POLAR_LOG);\n.   \n.   @internal\n.   Transform the source image using the following transformation (See @ref polar_remaps_reference_image \"Polar remaps reference image d)\"):\n.   \\f[\\begin{array}{l}\n.     dst( \\rho , \\phi ) = src(x,y) \\\\\n.     dst.size() \\leftarrow src.size()\n.   \\end{array}\\f]\n.   \n.   where\n.   \\f[\\begin{array}{l}\n.     I = (dx,dy) = (x - center.x,y - center.y) \\\\\n.     \\rho = M \\cdot log_e(\\texttt{magnitude} (I)) ,\\\\\n.     \\phi = Kangle \\cdot \\texttt{angle} (I) \\\\\n.   \\end{array}\\f]\n.   \n.   and\n.   \\f[\\begin{array}{l}\n.     M = src.cols / log_e(maxRadius) \\\\\n.     Kangle = src.rows / 2\\Pi \\\\\n.   \\end{array}\\f]\n.   \n.   The function emulates the human \"foveal\" vision and can be used for fast scale and\n.   rotation-invariant template matching, for object tracking and so forth.\n.   @param src Source image\n.   @param dst Destination image. It will have same size and type as src.\n.   @param center The transformation center; where the output precision is maximal\n.   @param M Magnitude scale parameter. It determines the radius of the bounding circle to transform too.\n.   @param flags A combination of interpolation methods, see #InterpolationFlags\n.   \n.   @note\n.   -   The function can not operate in-place.\n.   -   To calculate magnitude and angle in degrees #cartToPolar is used internally thus angles are measured from 0 to 360 with accuracy about 0.3 degrees.\n.   \n.   @sa cv::linearPolar\n.   @endinternal"},
    {"magnitude", CV_PY_FN_WITH_KW_(pyopencv_cv_magnitude, 0), "magnitude(x, y[, magnitude]) -> magnitude\n.   @brief Calculates the magnitude of 2D vectors.\n.   \n.   The function cv::magnitude calculates the magnitude of 2D vectors formed\n.   from the corresponding elements of x and y arrays:\n.   \\f[\\texttt{dst} (I) =  \\sqrt{\\texttt{x}(I)^2 + \\texttt{y}(I)^2}\\f]\n.   @param x floating-point array of x-coordinates of the vectors.\n.   @param y floating-point array of y-coordinates of the vectors; it must\n.   have the same size as x.\n.   @param magnitude output array of the same size and type as x.\n.   @sa cartToPolar, polarToCart, phase, sqrt"},
    {"matMulDeriv", CV_PY_FN_WITH_KW_(pyopencv_cv_matMulDeriv, 0), "matMulDeriv(A, B[, dABdA[, dABdB]]) -> dABdA, dABdB\n.   @brief Computes partial derivatives of the matrix product for each multiplied matrix.\n.   \n.   @param A First multiplied matrix.\n.   @param B Second multiplied matrix.\n.   @param dABdA First output derivative matrix d(A\\*B)/dA of size\n.   \\f$\\texttt{A.rows*B.cols} \\times {A.rows*A.cols}\\f$ .\n.   @param dABdB Second output derivative matrix d(A\\*B)/dB of size\n.   \\f$\\texttt{A.rows*B.cols} \\times {B.rows*B.cols}\\f$ .\n.   \n.   The function computes partial derivatives of the elements of the matrix product \\f$A*B\\f$ with regard to\n.   the elements of each of the two input matrices. The function is used to compute the Jacobian\n.   matrices in #stereoCalibrate but can also be used in any other similar optimization function."},
    {"matchShapes", CV_PY_FN_WITH_KW_(pyopencv_cv_matchShapes, 0), "matchShapes(contour1, contour2, method, parameter) -> retval\n.   @brief Compares two shapes.\n.   \n.   The function compares two shapes. All three implemented methods use the Hu invariants (see #HuMoments)\n.   \n.   @param contour1 First contour or grayscale image.\n.   @param contour2 Second contour or grayscale image.\n.   @param method Comparison method, see #ShapeMatchModes\n.   @param parameter Method-specific parameter (not supported now)."},
    {"matchTemplate", CV_PY_FN_WITH_KW_(pyopencv_cv_matchTemplate, 0), "matchTemplate(image, templ, method[, result[, mask]]) -> result\n.   @brief Compares a template against overlapped image regions.\n.   \n.   The function slides through image , compares the overlapped patches of size \\f$w \\times h\\f$ against\n.   templ using the specified method and stores the comparison results in result . #TemplateMatchModes\n.   describes the formulae for the available comparison methods ( \\f$I\\f$ denotes image, \\f$T\\f$\n.   template, \\f$R\\f$ result, \\f$M\\f$ the optional mask ). The summation is done over template and/or\n.   the image patch: \\f$x' = 0...w-1, y' = 0...h-1\\f$\n.   \n.   After the function finishes the comparison, the best matches can be found as global minimums (when\n.   #TM_SQDIFF was used) or maximums (when #TM_CCORR or #TM_CCOEFF was used) using the\n.   #minMaxLoc function. In case of a color image, template summation in the numerator and each sum in\n.   the denominator is done over all of the channels and separate mean values are used for each channel.\n.   That is, the function can take a color template and a color image. The result will still be a\n.   single-channel image, which is easier to analyze.\n.   \n.   @param image Image where the search is running. It must be 8-bit or 32-bit floating-point.\n.   @param templ Searched template. It must be not greater than the source image and have the same\n.   data type.\n.   @param result Map of comparison results. It must be single-channel 32-bit floating-point. If image\n.   is \\f$W \\times H\\f$ and templ is \\f$w \\times h\\f$ , then result is \\f$(W-w+1) \\times (H-h+1)\\f$ .\n.   @param method Parameter specifying the comparison method, see #TemplateMatchModes\n.   @param mask Optional mask. It must have the same size as templ. It must either have the same number\n.               of channels as template or only one channel, which is then used for all template and\n.               image channels. If the data type is #CV_8U, the mask is interpreted as a binary mask,\n.               meaning only elements where mask is nonzero are used and are kept unchanged independent\n.               of the actual mask value (weight equals 1). For data type #CV_32F, the mask values are\n.               used as weights. The exact formulas are documented in #TemplateMatchModes."},
    {"max", CV_PY_FN_WITH_KW_(pyopencv_cv_max, 0), "max(src1, src2[, dst]) -> dst\n.   @brief Calculates per-element maximum of two arrays or an array and a scalar.\n.   \n.   The function cv::max calculates the per-element maximum of two arrays:\n.   \\f[\\texttt{dst} (I)= \\max ( \\texttt{src1} (I), \\texttt{src2} (I))\\f]\n.   or array and a scalar:\n.   \\f[\\texttt{dst} (I)= \\max ( \\texttt{src1} (I), \\texttt{value} )\\f]\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and type as src1 .\n.   @param dst output array of the same size and type as src1.\n.   @sa  min, compare, inRange, minMaxLoc, @ref MatrixExpressions"},
    {"mean", CV_PY_FN_WITH_KW_(pyopencv_cv_mean, 0), "mean(src[, mask]) -> retval\n.   @brief Calculates an average (mean) of array elements.\n.   \n.   The function cv::mean calculates the mean value M of array elements,\n.   independently for each channel, and return it:\n.   \\f[\\begin{array}{l} N =  \\sum _{I: \\; \\texttt{mask} (I) \\ne 0} 1 \\\\ M_c =  \\left ( \\sum _{I: \\; \\texttt{mask} (I) \\ne 0}{ \\texttt{mtx} (I)_c} \\right )/N \\end{array}\\f]\n.   When all the mask elements are 0's, the function returns Scalar::all(0)\n.   @param src input array that should have from 1 to 4 channels so that the result can be stored in\n.   Scalar_ .\n.   @param mask optional operation mask.\n.   @sa  countNonZero, meanStdDev, norm, minMaxLoc"},
    {"meanShift", CV_PY_FN_WITH_KW_(pyopencv_cv_meanShift, 0), "meanShift(probImage, window, criteria) -> retval, window\n.   @brief Finds an object on a back projection image.\n.   \n.   @param probImage Back projection of the object histogram. See calcBackProject for details.\n.   @param window Initial search window.\n.   @param criteria Stop criteria for the iterative search algorithm.\n.   returns\n.   :   Number of iterations CAMSHIFT took to converge.\n.   The function implements the iterative object search algorithm. It takes the input back projection of\n.   an object and the initial position. The mass center in window of the back projection image is\n.   computed and the search window center shifts to the mass center. The procedure is repeated until the\n.   specified number of iterations criteria.maxCount is done or until the window center shifts by less\n.   than criteria.epsilon. The algorithm is used inside CamShift and, unlike CamShift , the search\n.   window size or orientation do not change during the search. You can simply pass the output of\n.   calcBackProject to this function. But better results can be obtained if you pre-filter the back\n.   projection and remove the noise. For example, you can do this by retrieving connected components\n.   with findContours , throwing away contours with small area ( contourArea ), and rendering the\n.   remaining contours with drawContours."},
    {"meanStdDev", CV_PY_FN_WITH_KW_(pyopencv_cv_meanStdDev, 0), "meanStdDev(src[, mean[, stddev[, mask]]]) -> mean, stddev\n.   Calculates a mean and standard deviation of array elements.\n.   \n.   The function cv::meanStdDev calculates the mean and the standard deviation M\n.   of array elements independently for each channel and returns it via the\n.   output parameters:\n.   \\f[\\begin{array}{l} N =  \\sum _{I, \\texttt{mask} (I)  \\ne 0} 1 \\\\ \\texttt{mean} _c =  \\frac{\\sum_{ I: \\; \\texttt{mask}(I) \\ne 0} \\texttt{src} (I)_c}{N} \\\\ \\texttt{stddev} _c =  \\sqrt{\\frac{\\sum_{ I: \\; \\texttt{mask}(I) \\ne 0} \\left ( \\texttt{src} (I)_c -  \\texttt{mean} _c \\right )^2}{N}} \\end{array}\\f]\n.   When all the mask elements are 0's, the function returns\n.   mean=stddev=Scalar::all(0).\n.   @note The calculated standard deviation is only the diagonal of the\n.   complete normalized covariance matrix. If the full matrix is needed, you\n.   can reshape the multi-channel array M x N to the single-channel array\n.   M\\*N x mtx.channels() (only possible when the matrix is continuous) and\n.   then pass the matrix to calcCovarMatrix .\n.   @param src input array that should have from 1 to 4 channels so that the results can be stored in\n.   Scalar_ 's.\n.   @param mean output parameter: calculated mean value.\n.   @param stddev output parameter: calculated standard deviation.\n.   @param mask optional operation mask.\n.   @sa  countNonZero, mean, norm, minMaxLoc, calcCovarMatrix"},
    {"medianBlur", CV_PY_FN_WITH_KW_(pyopencv_cv_medianBlur, 0), "medianBlur(src, ksize[, dst]) -> dst\n.   @brief Blurs an image using the median filter.\n.   \n.   The function smoothes an image using the median filter with the \\f$\\texttt{ksize} \\times\n.   \\texttt{ksize}\\f$ aperture. Each channel of a multi-channel image is processed independently.\n.   In-place operation is supported.\n.   \n.   @note The median filter uses #BORDER_REPLICATE internally to cope with border pixels, see #BorderTypes\n.   \n.   @param src input 1-, 3-, or 4-channel image; when ksize is 3 or 5, the image depth should be\n.   CV_8U, CV_16U, or CV_32F, for larger aperture sizes, it can only be CV_8U.\n.   @param dst destination array of the same size and type as src.\n.   @param ksize aperture linear size; it must be odd and greater than 1, for example: 3, 5, 7 ...\n.   @sa  bilateralFilter, blur, boxFilter, GaussianBlur"},
    {"merge", CV_PY_FN_WITH_KW_(pyopencv_cv_merge, 0), "merge(mv[, dst]) -> dst\n.   @overload\n.   @param mv input vector of matrices to be merged; all the matrices in mv must have the same\n.   size and the same depth.\n.   @param dst output array of the same size and the same depth as mv[0]; The number of channels will\n.   be the total number of channels in the matrix array."},
    {"min", CV_PY_FN_WITH_KW_(pyopencv_cv_min, 0), "min(src1, src2[, dst]) -> dst\n.   @brief Calculates per-element minimum of two arrays or an array and a scalar.\n.   \n.   The function cv::min calculates the per-element minimum of two arrays:\n.   \\f[\\texttt{dst} (I)= \\min ( \\texttt{src1} (I), \\texttt{src2} (I))\\f]\n.   or array and a scalar:\n.   \\f[\\texttt{dst} (I)= \\min ( \\texttt{src1} (I), \\texttt{value} )\\f]\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and type as src1.\n.   @param dst output array of the same size and type as src1.\n.   @sa max, compare, inRange, minMaxLoc"},
    {"minAreaRect", CV_PY_FN_WITH_KW_(pyopencv_cv_minAreaRect, 0), "minAreaRect(points) -> retval\n.   @brief Finds a rotated rectangle of the minimum area enclosing the input 2D point set.\n.   \n.   The function calculates and returns the minimum-area bounding rectangle (possibly rotated) for a\n.   specified point set. The angle of rotation represents the angle between the line connecting the starting\n.   and ending points (based on the clockwise order with greatest index for the corner with greatest \\f$y\\f$)\n.   and the horizontal axis. This angle always falls between \\f$[-90, 0)\\f$ because, if the object\n.   rotates more than a rect angle, the next edge is used to measure the angle. The starting and ending points change\n.   as the object rotates.Developer should keep in mind that the returned RotatedRect can contain negative\n.   indices when data is close to the containing Mat element boundary.\n.   \n.   @param points Input vector of 2D points, stored in std::vector\\<\\> or Mat"},
    {"minEnclosingCircle", CV_PY_FN_WITH_KW_(pyopencv_cv_minEnclosingCircle, 0), "minEnclosingCircle(points) -> center, radius\n.   @brief Finds a circle of the minimum area enclosing a 2D point set.\n.   \n.   The function finds the minimal enclosing circle of a 2D point set using an iterative algorithm.\n.   \n.   @param points Input vector of 2D points, stored in std::vector\\<\\> or Mat\n.   @param center Output center of the circle.\n.   @param radius Output radius of the circle."},
    {"minEnclosingTriangle", CV_PY_FN_WITH_KW_(pyopencv_cv_minEnclosingTriangle, 0), "minEnclosingTriangle(points[, triangle]) -> retval, triangle\n.   @brief Finds a triangle of minimum area enclosing a 2D point set and returns its area.\n.   \n.   The function finds a triangle of minimum area enclosing the given set of 2D points and returns its\n.   area. The output for a given 2D point set is shown in the image below. 2D points are depicted in\n.   *red* and the enclosing triangle in *yellow*.\n.   \n.   ![Sample output of the minimum enclosing triangle function](pics/minenclosingtriangle.png)\n.   \n.   The implementation of the algorithm is based on O'Rourke's @cite ORourke86 and Klee and Laskowski's\n.   @cite KleeLaskowski85 papers. O'Rourke provides a \\f$\\theta(n)\\f$ algorithm for finding the minimal\n.   enclosing triangle of a 2D convex polygon with n vertices. Since the #minEnclosingTriangle function\n.   takes a 2D point set as input an additional preprocessing step of computing the convex hull of the\n.   2D point set is required. The complexity of the #convexHull function is \\f$O(n log(n))\\f$ which is higher\n.   than \\f$\\theta(n)\\f$. Thus the overall complexity of the function is \\f$O(n log(n))\\f$.\n.   \n.   @param points Input vector of 2D points with depth CV_32S or CV_32F, stored in std::vector\\<\\> or Mat\n.   @param triangle Output vector of three 2D points defining the vertices of the triangle. The depth\n.   of the OutputArray must be CV_32F."},
    {"minMaxLoc", CV_PY_FN_WITH_KW_(pyopencv_cv_minMaxLoc, 0), "minMaxLoc(src[, mask]) -> minVal, maxVal, minLoc, maxLoc\n.   @brief Finds the global minimum and maximum in an array.\n.   \n.   The function cv::minMaxLoc finds the minimum and maximum element values and their positions. The\n.   extrema are searched across the whole array or, if mask is not an empty array, in the specified\n.   array region.\n.   \n.   In C++, if the input is multi-channel, you should omit the minLoc, maxLoc, and mask arguments\n.   (i.e. leave them as NULL, NULL, and noArray() respectively). These arguments are not\n.   supported for multi-channel input arrays. If working with multi-channel input and you\n.   need the minLoc, maxLoc, or mask arguments, then use Mat::reshape first to reinterpret\n.   the array as single-channel. Alternatively, you can extract the particular channel using either\n.   extractImageCOI, mixChannels, or split.\n.   \n.   In Python, multi-channel input is not supported at all due to a limitation in the\n.   binding generation process (there is no way to set minLoc and maxLoc to NULL). A\n.   workaround is to operate on each channel individually or to use NumPy to achieve the same\n.   functionality.\n.   \n.   @param src input single-channel array.\n.   @param minVal pointer to the returned minimum value; NULL is used if not required.\n.   @param maxVal pointer to the returned maximum value; NULL is used if not required.\n.   @param minLoc pointer to the returned minimum location (in 2D case); NULL is used if not required.\n.   @param maxLoc pointer to the returned maximum location (in 2D case); NULL is used if not required.\n.   @param mask optional mask used to select a sub-array.\n.   @sa max, min, reduceArgMin, reduceArgMax, compare, inRange, extractImageCOI, mixChannels, split, Mat::reshape"},
    {"mixChannels", CV_PY_FN_WITH_KW_(pyopencv_cv_mixChannels, 0), "mixChannels(src, dst, fromTo) -> dst\n.   @overload\n.   @param src input array or vector of matrices; all of the matrices must have the same size and the\n.   same depth.\n.   @param dst output array or vector of matrices; all the matrices **must be allocated**; their size and\n.   depth must be the same as in src[0].\n.   @param fromTo array of index pairs specifying which channels are copied and where; fromTo[k\\*2] is\n.   a 0-based index of the input channel in src, fromTo[k\\*2+1] is an index of the output channel in\n.   dst; the continuous channel numbering is used: the first input image channels are indexed from 0 to\n.   src[0].channels()-1, the second input image channels are indexed from src[0].channels() to\n.   src[0].channels() + src[1].channels()-1, and so on, the same scheme is used for the output image\n.   channels; as a special case, when fromTo[k\\*2] is negative, the corresponding output channel is\n.   filled with zero ."},
    {"moments", CV_PY_FN_WITH_KW_(pyopencv_cv_moments, 0), "moments(array[, binaryImage]) -> retval\n.   @brief Calculates all of the moments up to the third order of a polygon or rasterized shape.\n.   \n.   The function computes moments, up to the 3rd order, of a vector shape or a rasterized shape. The\n.   results are returned in the structure cv::Moments.\n.   \n.   @param array Single chanel raster image (CV_8U, CV_16U, CV_16S, CV_32F, CV_64F) or an array (\n.   \\f$1 \\times N\\f$ or \\f$N \\times 1\\f$ ) of 2D points (Point or Point2f).\n.   @param binaryImage If it is true, all non-zero image pixels are treated as 1's. The parameter is\n.   used for images only.\n.   @returns moments.\n.   \n.   @note Only applicable to contour moments calculations from Python bindings: Note that the numpy\n.   type for the input array should be either np.int32 or np.float32.\n.   \n.   @sa  contourArea, arcLength"},
    {"morphologyEx", CV_PY_FN_WITH_KW_(pyopencv_cv_morphologyEx, 0), "morphologyEx(src, op, kernel[, dst[, anchor[, iterations[, borderType[, borderValue]]]]]) -> dst\n.   @brief Performs advanced morphological transformations.\n.   \n.   The function cv::morphologyEx can perform advanced morphological transformations using an erosion and dilation as\n.   basic operations.\n.   \n.   Any of the operations can be done in-place. In case of multi-channel images, each channel is\n.   processed independently.\n.   \n.   @param src Source image. The number of channels can be arbitrary. The depth should be one of\n.   CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst Destination image of the same size and type as source image.\n.   @param op Type of a morphological operation, see #MorphTypes\n.   @param kernel Structuring element. It can be created using #getStructuringElement.\n.   @param anchor Anchor position with the kernel. Negative values mean that the anchor is at the\n.   kernel center.\n.   @param iterations Number of times erosion and dilation are applied.\n.   @param borderType Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @param borderValue Border value in case of a constant border. The default value has a special\n.   meaning.\n.   @sa  dilate, erode, getStructuringElement\n.   @note The number of iterations is the number of times erosion or dilatation operation will be applied.\n.   For instance, an opening operation (#MORPH_OPEN) with two iterations is equivalent to apply\n.   successively: erode -> erode -> dilate -> dilate (and not erode -> dilate -> erode -> dilate)."},
    {"moveWindow", CV_PY_FN_WITH_KW_(pyopencv_cv_moveWindow, 0), "moveWindow(winname, x, y) -> None\n.   @brief Moves the window to the specified position\n.   \n.   @param winname Name of the window.\n.   @param x The new x-coordinate of the window.\n.   @param y The new y-coordinate of the window.\n.   \n.   @note [__Wayland Backend Only__] This function is not supported by the Wayland protocol limitation."},
    {"mulSpectrums", CV_PY_FN_WITH_KW_(pyopencv_cv_mulSpectrums, 0), "mulSpectrums(a, b, flags[, c[, conjB]]) -> c\n.   @brief Performs the per-element multiplication of two Fourier spectrums.\n.   \n.   The function cv::mulSpectrums performs the per-element multiplication of the two CCS-packed or complex\n.   matrices that are results of a real or complex Fourier transform.\n.   \n.   The function, together with dft and idft, may be used to calculate convolution (pass conjB=false )\n.   or correlation (pass conjB=true ) of two arrays rapidly. When the arrays are complex, they are\n.   simply multiplied (per element) with an optional conjugation of the second-array elements. When the\n.   arrays are real, they are assumed to be CCS-packed (see dft for details).\n.   @param a first input array.\n.   @param b second input array of the same size and type as src1 .\n.   @param c output array of the same size and type as src1 .\n.   @param flags operation flags; currently, the only supported flag is cv::DFT_ROWS, which indicates that\n.   each row of src1 and src2 is an independent 1D Fourier spectrum. If you do not want to use this flag, then simply add a `0` as value.\n.   @param conjB optional flag that conjugates the second input array before the multiplication (true)\n.   or not (false)."},
    {"mulTransposed", CV_PY_FN_WITH_KW_(pyopencv_cv_mulTransposed, 0), "mulTransposed(src, aTa[, dst[, delta[, scale[, dtype]]]]) -> dst\n.   @brief Calculates the product of a matrix and its transposition.\n.   \n.   The function cv::mulTransposed calculates the product of src and its\n.   transposition:\n.   \\f[\\texttt{dst} = \\texttt{scale} ( \\texttt{src} - \\texttt{delta} )^T ( \\texttt{src} - \\texttt{delta} )\\f]\n.   if aTa=true, and\n.   \\f[\\texttt{dst} = \\texttt{scale} ( \\texttt{src} - \\texttt{delta} ) ( \\texttt{src} - \\texttt{delta} )^T\\f]\n.   otherwise. The function is used to calculate the covariance matrix. With\n.   zero delta, it can be used as a faster substitute for general matrix\n.   product A\\*B when B=A'\n.   @param src input single-channel matrix. Note that unlike gemm, the\n.   function can multiply not only floating-point matrices.\n.   @param dst output square matrix.\n.   @param aTa Flag specifying the multiplication ordering. See the\n.   description below.\n.   @param delta Optional delta matrix subtracted from src before the\n.   multiplication. When the matrix is empty ( delta=noArray() ), it is\n.   assumed to be zero, that is, nothing is subtracted. If it has the same\n.   size as src, it is simply subtracted. Otherwise, it is \"repeated\" (see\n.   repeat ) to cover the full src and then subtracted. Type of the delta\n.   matrix, when it is not empty, must be the same as the type of created\n.   output matrix. See the dtype parameter description below.\n.   @param scale Optional scale factor for the matrix product.\n.   @param dtype Optional type of the output matrix. When it is negative,\n.   the output matrix will have the same type as src . Otherwise, it will be\n.   type=CV_MAT_DEPTH(dtype) that should be either CV_32F or CV_64F .\n.   @sa calcCovarMatrix, gemm, repeat, reduce"},
    {"multiply", CV_PY_FN_WITH_KW_(pyopencv_cv_multiply, 0), "multiply(src1, src2[, dst[, scale[, dtype]]]) -> dst\n.   @brief Calculates the per-element scaled product of two arrays.\n.   \n.   The function multiply calculates the per-element product of two arrays:\n.   \n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} ( \\texttt{scale} \\cdot \\texttt{src1} (I)  \\cdot \\texttt{src2} (I))\\f]\n.   \n.   There is also a @ref MatrixExpressions -friendly variant of the first function. See Mat::mul .\n.   \n.   For a not-per-element matrix product, see gemm .\n.   \n.   @note Saturation is not applied when the output array has the depth\n.   CV_32S. You may even get result of an incorrect sign in the case of\n.   overflow.\n.   @note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.\n.   `multiply(src,X)` means `multiply(src,(X,X,X,X))`.\n.   `multiply(src,(X,))` means `multiply(src,(X,0,0,0))`.\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and the same type as src1.\n.   @param dst output array of the same size and type as src1.\n.   @param scale optional scale factor.\n.   @param dtype optional depth of the output array\n.   @sa add, subtract, divide, scaleAdd, addWeighted, accumulate, accumulateProduct, accumulateSquare,\n.   Mat::convertTo"},
    {"namedWindow", CV_PY_FN_WITH_KW_(pyopencv_cv_namedWindow, 0), "namedWindow(winname[, flags]) -> None\n.   @brief Creates a window.\n.   \n.   The function namedWindow creates a window that can be used as a placeholder for images and\n.   trackbars. Created windows are referred to by their names.\n.   \n.   If a window with the same name already exists, the function does nothing.\n.   \n.   You can call cv::destroyWindow or cv::destroyAllWindows to close the window and de-allocate any associated\n.   memory usage. For a simple program, you do not really have to call these functions because all the\n.   resources and windows of the application are closed automatically by the operating system upon exit.\n.   \n.   @note Qt backend supports additional flags:\n.    -   **WINDOW_NORMAL or WINDOW_AUTOSIZE:** WINDOW_NORMAL enables you to resize the\n.        window, whereas WINDOW_AUTOSIZE adjusts automatically the window size to fit the\n.        displayed image (see imshow ), and you cannot change the window size manually.\n.    -   **WINDOW_FREERATIO or WINDOW_KEEPRATIO:** WINDOW_FREERATIO adjusts the image\n.        with no respect to its ratio, whereas WINDOW_KEEPRATIO keeps the image ratio.\n.    -   **WINDOW_GUI_NORMAL or WINDOW_GUI_EXPANDED:** WINDOW_GUI_NORMAL is the old way to draw the window\n.        without statusbar and toolbar, whereas WINDOW_GUI_EXPANDED is a new enhanced GUI.\n.   By default, flags == WINDOW_AUTOSIZE | WINDOW_KEEPRATIO | WINDOW_GUI_EXPANDED\n.   \n.   @param winname Name of the window in the window caption that may be used as a window identifier.\n.   @param flags Flags of the window. The supported flags are: (cv::WindowFlags)"},
    {"norm", CV_PY_FN_WITH_KW_(pyopencv_cv_norm, 0), "norm(src1[, normType[, mask]]) -> retval\n.   @brief Calculates the  absolute norm of an array.\n.   \n.   This version of #norm calculates the absolute norm of src1. The type of norm to calculate is specified using #NormTypes.\n.   \n.   As example for one array consider the function \\f$r(x)= \\begin{pmatrix} x \\\\ 1-x \\end{pmatrix}, x \\in [-1;1]\\f$.\n.   The \\f$ L_{1}, L_{2} \\f$ and \\f$ L_{\\infty} \\f$ norm for the sample value \\f$r(-1) = \\begin{pmatrix} -1 \\\\ 2 \\end{pmatrix}\\f$\n.   is calculated as follows\n.   \\f{align*}\n.       \\| r(-1) \\|_{L_1} &= |-1| + |2| = 3 \\\\\n.       \\| r(-1) \\|_{L_2} &= \\sqrt{(-1)^{2} + (2)^{2}} = \\sqrt{5} \\\\\n.       \\| r(-1) \\|_{L_\\infty} &= \\max(|-1|,|2|) = 2\n.   \\f}\n.   and for \\f$r(0.5) = \\begin{pmatrix} 0.5 \\\\ 0.5 \\end{pmatrix}\\f$ the calculation is\n.   \\f{align*}\n.       \\| r(0.5) \\|_{L_1} &= |0.5| + |0.5| = 1 \\\\\n.       \\| r(0.5) \\|_{L_2} &= \\sqrt{(0.5)^{2} + (0.5)^{2}} = \\sqrt{0.5} \\\\\n.       \\| r(0.5) \\|_{L_\\infty} &= \\max(|0.5|,|0.5|) = 0.5.\n.   \\f}\n.   The following graphic shows all values for the three norm functions \\f$\\| r(x) \\|_{L_1}, \\| r(x) \\|_{L_2}\\f$ and \\f$\\| r(x) \\|_{L_\\infty}\\f$.\n.   It is notable that the \\f$ L_{1} \\f$ norm forms the upper and the \\f$ L_{\\infty} \\f$ norm forms the lower border for the example function \\f$ r(x) \\f$.\n.   ![Graphs for the different norm functions from the above example](pics/NormTypes_OneArray_1-2-INF.png)\n.   \n.   When the mask parameter is specified and it is not empty, the norm is\n.   \n.   If normType is not specified, #NORM_L2 is used.\n.   calculated only over the region specified by the mask.\n.   \n.   Multi-channel input arrays are treated as single-channel arrays, that is,\n.   the results for all channels are combined.\n.   \n.   Hamming norms can only be calculated with CV_8U depth arrays.\n.   \n.   @param src1 first input array.\n.   @param normType type of the norm (see #NormTypes).\n.   @param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.\n\n\n\nnorm(src1, src2[, normType[, mask]]) -> retval\n.   @brief Calculates an absolute difference norm or a relative difference norm.\n.   \n.   This version of cv::norm calculates the absolute difference norm\n.   or the relative difference norm of arrays src1 and src2.\n.   The type of norm to calculate is specified using #NormTypes.\n.   \n.   @param src1 first input array.\n.   @param src2 second input array of the same size and the same type as src1.\n.   @param normType type of the norm (see #NormTypes).\n.   @param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type."},
    {"normalize", CV_PY_FN_WITH_KW_(pyopencv_cv_normalize, 0), "normalize(src, dst[, alpha[, beta[, norm_type[, dtype[, mask]]]]]) -> dst\n.   @brief Normalizes the norm or value range of an array.\n.   \n.   The function cv::normalize normalizes scale and shift the input array elements so that\n.   \\f[\\| \\texttt{dst} \\| _{L_p}= \\texttt{alpha}\\f]\n.   (where p=Inf, 1 or 2) when normType=NORM_INF, NORM_L1, or NORM_L2, respectively; or so that\n.   \\f[\\min _I  \\texttt{dst} (I)= \\texttt{alpha} , \\, \\, \\max _I  \\texttt{dst} (I)= \\texttt{beta}\\f]\n.   \n.   when normType=NORM_MINMAX (for dense arrays only). The optional mask specifies a sub-array to be\n.   normalized. This means that the norm or min-n-max are calculated over the sub-array, and then this\n.   sub-array is modified to be normalized. If you want to only use the mask to calculate the norm or\n.   min-max but modify the whole array, you can use norm and Mat::convertTo.\n.   \n.   In case of sparse matrices, only the non-zero values are analyzed and transformed. Because of this,\n.   the range transformation for sparse matrices is not allowed since it can shift the zero level.\n.   \n.   Possible usage with some positive example data:\n.   @code{.cpp}\n.       vector<double> positiveData = { 2.0, 8.0, 10.0 };\n.       vector<double> normalizedData_l1, normalizedData_l2, normalizedData_inf, normalizedData_minmax;\n.   \n.       // Norm to probability (total count)\n.       // sum(numbers) = 20.0\n.       // 2.0      0.1     (2.0/20.0)\n.       // 8.0      0.4     (8.0/20.0)\n.       // 10.0     0.5     (10.0/20.0)\n.       normalize(positiveData, normalizedData_l1, 1.0, 0.0, NORM_L1);\n.   \n.       // Norm to unit vector: ||positiveData|| = 1.0\n.       // 2.0      0.15\n.       // 8.0      0.62\n.       // 10.0     0.77\n.       normalize(positiveData, normalizedData_l2, 1.0, 0.0, NORM_L2);\n.   \n.       // Norm to max element\n.       // 2.0      0.2     (2.0/10.0)\n.       // 8.0      0.8     (8.0/10.0)\n.       // 10.0     1.0     (10.0/10.0)\n.       normalize(positiveData, normalizedData_inf, 1.0, 0.0, NORM_INF);\n.   \n.       // Norm to range [0.0;1.0]\n.       // 2.0      0.0     (shift to left border)\n.       // 8.0      0.75    (6.0/8.0)\n.       // 10.0     1.0     (shift to right border)\n.       normalize(positiveData, normalizedData_minmax, 1.0, 0.0, NORM_MINMAX);\n.   @endcode\n.   \n.   @note Due to rounding issues, min-max normalization can result in values outside provided boundaries.\n.   If exact range conformity is needed, following workarounds can be used:\n.   - use double floating point precision (dtype = CV_64F)\n.   - manually clip values (`cv::max(res, left_bound, res)`, `cv::min(res, right_bound, res)` or `np.clip`)\n.   \n.   @param src input array.\n.   @param dst output array of the same size as src .\n.   @param alpha norm value to normalize to or the lower range boundary in case of the range\n.   normalization.\n.   @param beta upper range boundary in case of the range normalization; it is not used for the norm\n.   normalization.\n.   @param norm_type normalization type (see cv::NormTypes).\n.   @param dtype when negative, the output array has the same type as src; otherwise, it has the same\n.   number of channels as src and the depth =CV_MAT_DEPTH(dtype).\n.   @param mask optional operation mask.\n.   @sa norm, Mat::convertTo, SparseMat::convertTo"},
    {"patchNaNs", CV_PY_FN_WITH_KW_(pyopencv_cv_patchNaNs, 0), "patchNaNs(a[, val]) -> a\n.   @brief Replaces NaNs by given number\n.   @param a input/output matrix (CV_32F type).\n.   @param val value to convert the NaNs"},
    {"pencilSketch", CV_PY_FN_WITH_KW_(pyopencv_cv_pencilSketch, 0), "pencilSketch(src[, dst1[, dst2[, sigma_s[, sigma_r[, shade_factor]]]]]) -> dst1, dst2\n.   @brief Pencil-like non-photorealistic line drawing\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst1 Output 8-bit 1-channel image.\n.   @param dst2 Output image with the same size and type as src.\n.   @param sigma_s %Range between 0 to 200.\n.   @param sigma_r %Range between 0 to 1.\n.   @param shade_factor %Range between 0 to 0.1."},
    {"perspectiveTransform", CV_PY_FN_WITH_KW_(pyopencv_cv_perspectiveTransform, 0), "perspectiveTransform(src, m[, dst]) -> dst\n.   @brief Performs the perspective matrix transformation of vectors.\n.   \n.   The function cv::perspectiveTransform transforms every element of src by\n.   treating it as a 2D or 3D vector, in the following way:\n.   \\f[(x, y, z)  \\rightarrow (x'/w, y'/w, z'/w)\\f]\n.   where\n.   \\f[(x', y', z', w') =  \\texttt{mat} \\cdot \\begin{bmatrix} x & y & z & 1  \\end{bmatrix}\\f]\n.   and\n.   \\f[w =  \\fork{w'}{if \\(w' \\ne 0\\)}{\\infty}{otherwise}\\f]\n.   \n.   Here a 3D vector transformation is shown. In case of a 2D vector\n.   transformation, the z component is omitted.\n.   \n.   @note The function transforms a sparse set of 2D or 3D vectors. If you\n.   want to transform an image using perspective transformation, use\n.   warpPerspective . If you have an inverse problem, that is, you want to\n.   compute the most probable perspective transformation out of several\n.   pairs of corresponding points, you can use getPerspectiveTransform or\n.   findHomography .\n.   @param src input two-channel or three-channel floating-point array; each\n.   element is a 2D/3D vector to be transformed.\n.   @param dst output array of the same size and type as src.\n.   @param m 3x3 or 4x4 floating-point transformation matrix.\n.   @sa  transform, warpPerspective, getPerspectiveTransform, findHomography"},
    {"phase", CV_PY_FN_WITH_KW_(pyopencv_cv_phase, 0), "phase(x, y[, angle[, angleInDegrees]]) -> angle\n.   @brief Calculates the rotation angle of 2D vectors.\n.   \n.   The function cv::phase calculates the rotation angle of each 2D vector that\n.   is formed from the corresponding elements of x and y :\n.   \\f[\\texttt{angle} (I) =  \\texttt{atan2} ( \\texttt{y} (I), \\texttt{x} (I))\\f]\n.   \n.   The angle estimation accuracy is about 0.3 degrees. When x(I)=y(I)=0 ,\n.   the corresponding angle(I) is set to 0.\n.   @param x input floating-point array of x-coordinates of 2D vectors.\n.   @param y input array of y-coordinates of 2D vectors; it must have the\n.   same size and the same type as x.\n.   @param angle output array of vector angles; it has the same size and\n.   same type as x .\n.   @param angleInDegrees when true, the function calculates the angle in\n.   degrees, otherwise, they are measured in radians."},
    {"phaseCorrelate", CV_PY_FN_WITH_KW_(pyopencv_cv_phaseCorrelate, 0), "phaseCorrelate(src1, src2[, window]) -> retval, response\n.   @brief The function is used to detect translational shifts that occur between two images.\n.   \n.   The operation takes advantage of the Fourier shift theorem for detecting the translational shift in\n.   the frequency domain. It can be used for fast image registration as well as motion estimation. For\n.   more information please see <https://en.wikipedia.org/wiki/Phase_correlation>\n.   \n.   Calculates the cross-power spectrum of two supplied source arrays. The arrays are padded if needed\n.   with getOptimalDFTSize.\n.   \n.   The function performs the following equations:\n.   - First it applies a Hanning window to each image to remove possible edge effects, if it's provided\n.   by user. See @ref createHanningWindow and <https://en.wikipedia.org/wiki/Hann_function>. This window may\n.   be cached until the array size changes to speed up processing time.\n.   - Next it computes the forward DFTs of each source array:\n.   \\f[\\mathbf{G}_a = \\mathcal{F}\\{src_1\\}, \\; \\mathbf{G}_b = \\mathcal{F}\\{src_2\\}\\f]\n.   where \\f$\\mathcal{F}\\f$ is the forward DFT.\n.   - It then computes the cross-power spectrum of each frequency domain array:\n.   \\f[R = \\frac{ \\mathbf{G}_a \\mathbf{G}_b^*}{|\\mathbf{G}_a \\mathbf{G}_b^*|}\\f]\n.   - Next the cross-correlation is converted back into the time domain via the inverse DFT:\n.   \\f[r = \\mathcal{F}^{-1}\\{R\\}\\f]\n.   - Finally, it computes the peak location and computes a 5x5 weighted centroid around the peak to\n.   achieve sub-pixel accuracy.\n.   \\f[(\\Delta x, \\Delta y) = \\texttt{weightedCentroid} \\{\\arg \\max_{(x, y)}\\{r\\}\\}\\f]\n.   - If non-zero, the response parameter is computed as the sum of the elements of r within the 5x5\n.   centroid around the peak location. It is normalized to a maximum of 1 (meaning there is a single\n.   peak) and will be smaller when there are multiple peaks.\n.   \n.   @param src1 Source floating point array (CV_32FC1 or CV_64FC1)\n.   @param src2 Source floating point array (CV_32FC1 or CV_64FC1)\n.   @param window Floating point array with windowing coefficients to reduce edge effects (optional).\n.   @param response Signal power within the 5x5 centroid around the peak, between 0 and 1 (optional).\n.   @returns detected phase shift (sub-pixel) between the two arrays.\n.   \n.   @sa dft, getOptimalDFTSize, idft, mulSpectrums createHanningWindow"},
    {"pointPolygonTest", CV_PY_FN_WITH_KW_(pyopencv_cv_pointPolygonTest, 0), "pointPolygonTest(contour, pt, measureDist) -> retval\n.   @brief Performs a point-in-contour test.\n.   \n.   The function determines whether the point is inside a contour, outside, or lies on an edge (or\n.   coincides with a vertex). It returns positive (inside), negative (outside), or zero (on an edge)\n.   value, correspondingly. When measureDist=false , the return value is +1, -1, and 0, respectively.\n.   Otherwise, the return value is a signed distance between the point and the nearest contour edge.\n.   \n.   See below a sample output of the function where each image pixel is tested against the contour:\n.   \n.   ![sample output](pics/pointpolygon.png)\n.   \n.   @param contour Input contour.\n.   @param pt Point tested against the contour.\n.   @param measureDist If true, the function estimates the signed distance from the point to the\n.   nearest contour edge. Otherwise, the function only checks if the point is inside a contour or not."},
    {"polarToCart", CV_PY_FN_WITH_KW_(pyopencv_cv_polarToCart, 0), "polarToCart(magnitude, angle[, x[, y[, angleInDegrees]]]) -> x, y\n.   @brief Calculates x and y coordinates of 2D vectors from their magnitude and angle.\n.   \n.   The function cv::polarToCart calculates the Cartesian coordinates of each 2D\n.   vector represented by the corresponding elements of magnitude and angle:\n.   \\f[\\begin{array}{l} \\texttt{x} (I) =  \\texttt{magnitude} (I) \\cos ( \\texttt{angle} (I)) \\\\ \\texttt{y} (I) =  \\texttt{magnitude} (I) \\sin ( \\texttt{angle} (I)) \\\\ \\end{array}\\f]\n.   \n.   The relative accuracy of the estimated coordinates is about 1e-6.\n.   @param magnitude input floating-point array of magnitudes of 2D vectors;\n.   it can be an empty matrix (=Mat()), in this case, the function assumes\n.   that all the magnitudes are =1; if it is not empty, it must have the\n.   same size and type as angle.\n.   @param angle input floating-point array of angles of 2D vectors.\n.   @param x output array of x-coordinates of 2D vectors; it has the same\n.   size and type as angle.\n.   @param y output array of y-coordinates of 2D vectors; it has the same\n.   size and type as angle.\n.   @param angleInDegrees when true, the input angles are measured in\n.   degrees, otherwise, they are measured in radians.\n.   @sa cartToPolar, magnitude, phase, exp, log, pow, sqrt"},
    {"pollKey", CV_PY_FN_WITH_KW_(pyopencv_cv_pollKey, 0), "pollKey() -> retval\n.   @brief Polls for a pressed key.\n.   \n.   The function pollKey polls for a key event without waiting. It returns the code of the pressed key\n.   or -1 if no key was pressed since the last invocation. To wait until a key was pressed, use #waitKey.\n.   \n.   @note The functions #waitKey and #pollKey are the only methods in HighGUI that can fetch and handle\n.   GUI events, so one of them needs to be called periodically for normal event processing unless\n.   HighGUI is used within an environment that takes care of event processing.\n.   \n.   @note The function only works if there is at least one HighGUI window created and the window is\n.   active. If there are several HighGUI windows, any of them can be active."},
    {"polylines", CV_PY_FN_WITH_KW_(pyopencv_cv_polylines, 0), "polylines(img, pts, isClosed, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws several polygonal curves.\n.   \n.   @param img Image.\n.   @param pts Array of polygonal curves.\n.   @param isClosed Flag indicating whether the drawn polylines are closed or not. If they are closed,\n.   the function draws a line from the last vertex of each curve to its first vertex.\n.   @param color Polyline color.\n.   @param thickness Thickness of the polyline edges.\n.   @param lineType Type of the line segments. See #LineTypes\n.   @param shift Number of fractional bits in the vertex coordinates.\n.   \n.   The function cv::polylines draws one or more polygonal curves."},
    {"pow", CV_PY_FN_WITH_KW_(pyopencv_cv_pow, 0), "pow(src, power[, dst]) -> dst\n.   @brief Raises every array element to a power.\n.   \n.   The function cv::pow raises every element of the input array to power :\n.   \\f[\\texttt{dst} (I) =  \\fork{\\texttt{src}(I)^{power}}{if \\(\\texttt{power}\\) is integer}{|\\texttt{src}(I)|^{power}}{otherwise}\\f]\n.   \n.   So, for a non-integer power exponent, the absolute values of input array\n.   elements are used. However, it is possible to get true values for\n.   negative values using some extra operations. In the example below,\n.   computing the 5th root of array src shows:\n.   @code{.cpp}\n.       Mat mask = src < 0;\n.       pow(src, 1./5, dst);\n.       subtract(Scalar::all(0), dst, dst, mask);\n.   @endcode\n.   For some values of power, such as integer values, 0.5 and -0.5,\n.   specialized faster algorithms are used.\n.   \n.   Special values (NaN, Inf) are not handled.\n.   @param src input array.\n.   @param power exponent of power.\n.   @param dst output array of the same size and type as src.\n.   @sa sqrt, exp, log, cartToPolar, polarToCart"},
    {"preCornerDetect", CV_PY_FN_WITH_KW_(pyopencv_cv_preCornerDetect, 0), "preCornerDetect(src, ksize[, dst[, borderType]]) -> dst\n.   @brief Calculates a feature map for corner detection.\n.   \n.   The function calculates the complex spatial derivative-based function of the source image\n.   \n.   \\f[\\texttt{dst} = (D_x  \\texttt{src} )^2  \\cdot D_{yy}  \\texttt{src} + (D_y  \\texttt{src} )^2  \\cdot D_{xx}  \\texttt{src} - 2 D_x  \\texttt{src} \\cdot D_y  \\texttt{src} \\cdot D_{xy}  \\texttt{src}\\f]\n.   \n.   where \\f$D_x\\f$,\\f$D_y\\f$ are the first image derivatives, \\f$D_{xx}\\f$,\\f$D_{yy}\\f$ are the second image\n.   derivatives, and \\f$D_{xy}\\f$ is the mixed derivative.\n.   \n.   The corners can be found as local maximums of the functions, as shown below:\n.   @code\n.       Mat corners, dilated_corners;\n.       preCornerDetect(image, corners, 3);\n.       // dilation with 3x3 rectangular structuring element\n.       dilate(corners, dilated_corners, Mat(), 1);\n.       Mat corner_mask = corners == dilated_corners;\n.   @endcode\n.   \n.   @param src Source single-channel 8-bit of floating-point image.\n.   @param dst Output image that has the type CV_32F and the same size as src .\n.   @param ksize %Aperture size of the Sobel .\n.   @param borderType Pixel extrapolation method. See #BorderTypes. #BORDER_WRAP is not supported."},
    {"projectPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_projectPoints, 0), "projectPoints(objectPoints, rvec, tvec, cameraMatrix, distCoeffs[, imagePoints[, jacobian[, aspectRatio]]]) -> imagePoints, jacobian\n.   @brief Projects 3D points to an image plane.\n.   \n.   @param objectPoints Array of object points expressed wrt. the world coordinate frame. A 3xN/Nx3\n.   1-channel or 1xN/Nx1 3-channel (or vector\\<Point3f\\> ), where N is the number of points in the view.\n.   @param rvec The rotation vector (@ref Rodrigues) that, together with tvec, performs a change of\n.   basis from world to camera coordinate system, see @ref calibrateCamera for details.\n.   @param tvec The translation vector, see parameter description above.\n.   @param cameraMatrix Camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$ . If the vector is empty, the zero distortion coefficients are assumed.\n.   @param imagePoints Output array of image points, 1xN/Nx1 2-channel, or\n.   vector\\<Point2f\\> .\n.   @param jacobian Optional output 2Nx(10+\\<numDistCoeffs\\>) jacobian matrix of derivatives of image\n.   points with respect to components of the rotation vector, translation vector, focal lengths,\n.   coordinates of the principal point and the distortion coefficients. In the old interface different\n.   components of the jacobian are returned via different output parameters.\n.   @param aspectRatio Optional \"fixed aspect ratio\" parameter. If the parameter is not 0, the\n.   function assumes that the aspect ratio (\\f$f_x / f_y\\f$) is fixed and correspondingly adjusts the\n.   jacobian matrix.\n.   \n.   The function computes the 2D projections of 3D points to the image plane, given intrinsic and\n.   extrinsic camera parameters. Optionally, the function computes Jacobians -matrices of partial\n.   derivatives of image points coordinates (as functions of all the input parameters) with respect to\n.   the particular parameters, intrinsic and/or extrinsic. The Jacobians are used during the global\n.   optimization in @ref calibrateCamera, @ref solvePnP, and @ref stereoCalibrate. The function itself\n.   can also be used to compute a re-projection error, given the current intrinsic and extrinsic\n.   parameters.\n.   \n.   @note By setting rvec = tvec = \\f$[0, 0, 0]\\f$, or by setting cameraMatrix to a 3x3 identity matrix,\n.   or by passing zero distortion coefficients, one can get various useful partial cases of the\n.   function. This means, one can compute the distorted coordinates for a sparse set of points or apply\n.   a perspective transformation (and also compute the derivatives) in the ideal zero-distortion setup."},
    {"putText", CV_PY_FN_WITH_KW_(pyopencv_cv_putText, 0), "putText(img, text, org, fontFace, fontScale, color[, thickness[, lineType[, bottomLeftOrigin]]]) -> img\n.   @brief Draws a text string.\n.   \n.   The function cv::putText renders the specified text string in the image. Symbols that cannot be rendered\n.   using the specified font are replaced by question marks. See #getTextSize for a text rendering code\n.   example.\n.   \n.   The `fontScale` parameter is a scale factor that is multiplied by the base font size:\n.   - When scale > 1, the text is magnified.\n.   - When 0 < scale < 1, the text is minimized.\n.   - When scale < 0, the text is mirrored or reversed.\n.   \n.   @param img Image.\n.   @param text Text string to be drawn.\n.   @param org Bottom-left corner of the text string in the image.\n.   @param fontFace Font type, see #HersheyFonts.\n.   @param fontScale Font scale factor that is multiplied by the font-specific base size.\n.   @param color Text color.\n.   @param thickness Thickness of the lines used to draw a text.\n.   @param lineType Line type. See #LineTypes\n.   @param bottomLeftOrigin When true, the image data origin is at the bottom-left corner. Otherwise,\n.   it is at the top-left corner."},
    {"pyrDown", CV_PY_FN_WITH_KW_(pyopencv_cv_pyrDown, 0), "pyrDown(src[, dst[, dstsize[, borderType]]]) -> dst\n.   @brief Blurs an image and downsamples it.\n.   \n.   By default, size of the output image is computed as `Size((src.cols+1)/2, (src.rows+1)/2)`, but in\n.   any case, the following conditions should be satisfied:\n.   \n.   \\f[\\begin{array}{l} | \\texttt{dstsize.width} *2-src.cols| \\leq 2 \\\\ | \\texttt{dstsize.height} *2-src.rows| \\leq 2 \\end{array}\\f]\n.   \n.   The function performs the downsampling step of the Gaussian pyramid construction. First, it\n.   convolves the source image with the kernel:\n.   \n.   \\f[\\frac{1}{256} \\begin{bmatrix} 1 & 4 & 6 & 4 & 1  \\\\ 4 & 16 & 24 & 16 & 4  \\\\ 6 & 24 & 36 & 24 & 6  \\\\ 4 & 16 & 24 & 16 & 4  \\\\ 1 & 4 & 6 & 4 & 1 \\end{bmatrix}\\f]\n.   \n.   Then, it downsamples the image by rejecting even rows and columns.\n.   \n.   @param src input image.\n.   @param dst output image; it has the specified size and the same type as src.\n.   @param dstsize size of the output image.\n.   @param borderType Pixel extrapolation method, see #BorderTypes (#BORDER_CONSTANT isn't supported)"},
    {"pyrMeanShiftFiltering", CV_PY_FN_WITH_KW_(pyopencv_cv_pyrMeanShiftFiltering, 0), "pyrMeanShiftFiltering(src, sp, sr[, dst[, maxLevel[, termcrit]]]) -> dst\n.   @brief Performs initial step of meanshift segmentation of an image.\n.   \n.   The function implements the filtering stage of meanshift segmentation, that is, the output of the\n.   function is the filtered \"posterized\" image with color gradients and fine-grain texture flattened.\n.   At every pixel (X,Y) of the input image (or down-sized input image, see below) the function executes\n.   meanshift iterations, that is, the pixel (X,Y) neighborhood in the joint space-color hyperspace is\n.   considered:\n.   \n.   \\f[(x,y): X- \\texttt{sp} \\le x  \\le X+ \\texttt{sp} , Y- \\texttt{sp} \\le y  \\le Y+ \\texttt{sp} , ||(R,G,B)-(r,g,b)||   \\le \\texttt{sr}\\f]\n.   \n.   where (R,G,B) and (r,g,b) are the vectors of color components at (X,Y) and (x,y), respectively\n.   (though, the algorithm does not depend on the color space used, so any 3-component color space can\n.   be used instead). Over the neighborhood the average spatial value (X',Y') and average color vector\n.   (R',G',B') are found and they act as the neighborhood center on the next iteration:\n.   \n.   \\f[(X,Y)~(X',Y'), (R,G,B)~(R',G',B').\\f]\n.   \n.   After the iterations over, the color components of the initial pixel (that is, the pixel from where\n.   the iterations started) are set to the final value (average color at the last iteration):\n.   \n.   \\f[I(X,Y) <- (R*,G*,B*)\\f]\n.   \n.   When maxLevel \\> 0, the gaussian pyramid of maxLevel+1 levels is built, and the above procedure is\n.   run on the smallest layer first. After that, the results are propagated to the larger layer and the\n.   iterations are run again only on those pixels where the layer colors differ by more than sr from the\n.   lower-resolution layer of the pyramid. That makes boundaries of color regions sharper. Note that the\n.   results will be actually different from the ones obtained by running the meanshift procedure on the\n.   whole original image (i.e. when maxLevel==0).\n.   \n.   @param src The source 8-bit, 3-channel image.\n.   @param dst The destination image of the same format and the same size as the source.\n.   @param sp The spatial window radius.\n.   @param sr The color window radius.\n.   @param maxLevel Maximum level of the pyramid for the segmentation.\n.   @param termcrit Termination criteria: when to stop meanshift iterations."},
    {"pyrUp", CV_PY_FN_WITH_KW_(pyopencv_cv_pyrUp, 0), "pyrUp(src[, dst[, dstsize[, borderType]]]) -> dst\n.   @brief Upsamples an image and then blurs it.\n.   \n.   By default, size of the output image is computed as `Size(src.cols\\*2, (src.rows\\*2)`, but in any\n.   case, the following conditions should be satisfied:\n.   \n.   \\f[\\begin{array}{l} | \\texttt{dstsize.width} -src.cols*2| \\leq  ( \\texttt{dstsize.width}   \\mod  2)  \\\\ | \\texttt{dstsize.height} -src.rows*2| \\leq  ( \\texttt{dstsize.height}   \\mod  2) \\end{array}\\f]\n.   \n.   The function performs the upsampling step of the Gaussian pyramid construction, though it can\n.   actually be used to construct the Laplacian pyramid. First, it upsamples the source image by\n.   injecting even zero rows and columns and then convolves the result with the same kernel as in\n.   pyrDown multiplied by 4.\n.   \n.   @param src input image.\n.   @param dst output image. It has the specified size and the same type as src .\n.   @param dstsize size of the output image.\n.   @param borderType Pixel extrapolation method, see #BorderTypes (only #BORDER_DEFAULT is supported)"},
    {"randShuffle", CV_PY_FN_WITH_KW_(pyopencv_cv_randShuffle, 0), "randShuffle(dst[, iterFactor]) -> dst\n.   @brief Shuffles the array elements randomly.\n.   \n.   The function cv::randShuffle shuffles the specified 1D array by randomly choosing pairs of elements and\n.   swapping them. The number of such swap operations will be dst.rows\\*dst.cols\\*iterFactor .\n.   @param dst input/output numerical 1D array.\n.   @param iterFactor scale factor that determines the number of random swap operations (see the details\n.   below).\n.   @param rng optional random number generator used for shuffling; if it is zero, theRNG () is used\n.   instead.\n.   @sa RNG, sort"},
    {"randn", CV_PY_FN_WITH_KW_(pyopencv_cv_randn, 0), "randn(dst, mean, stddev) -> dst\n.   @brief Fills the array with normally distributed random numbers.\n.   \n.   The function cv::randn fills the matrix dst with normally distributed random numbers with the specified\n.   mean vector and the standard deviation matrix. The generated random numbers are clipped to fit the\n.   value range of the output array data type.\n.   @param dst output array of random numbers; the array must be pre-allocated and have 1 to 4 channels.\n.   @param mean mean value (expectation) of the generated random numbers.\n.   @param stddev standard deviation of the generated random numbers; it can be either a vector (in\n.   which case a diagonal standard deviation matrix is assumed) or a square matrix.\n.   @sa RNG, randu"},
    {"randu", CV_PY_FN_WITH_KW_(pyopencv_cv_randu, 0), "randu(dst, low, high) -> dst\n.   @brief Generates a single uniformly-distributed random number or an array of random numbers.\n.   \n.   Non-template variant of the function fills the matrix dst with uniformly-distributed\n.   random numbers from the specified range:\n.   \\f[\\texttt{low} _c  \\leq \\texttt{dst} (I)_c <  \\texttt{high} _c\\f]\n.   @param dst output array of random numbers; the array must be pre-allocated.\n.   @param low inclusive lower boundary of the generated random numbers.\n.   @param high exclusive upper boundary of the generated random numbers.\n.   @sa RNG, randn, theRNG"},
    {"readOpticalFlow", CV_PY_FN_WITH_KW_(pyopencv_cv_readOpticalFlow, 0), "readOpticalFlow(path) -> retval\n.   @brief Read a .flo file\n.   \n.    @param path Path to the file to be loaded\n.   \n.    The function readOpticalFlow loads a flow field from a file and returns it as a single matrix.\n.    Resulting Mat has a type CV_32FC2 - floating-point, 2-channel. First channel corresponds to the\n.    flow in the horizontal direction (u), second - vertical (v)."},
    {"recoverPose", CV_PY_FN_WITH_KW_(pyopencv_cv_recoverPose, 0), "recoverPose(points1, points2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2[, E[, R[, t[, method[, prob[, threshold[, mask]]]]]]]) -> retval, E, R, t, mask\n.   @brief Recovers the relative camera rotation and the translation from corresponding points in two images from two different cameras, using cheirality check. Returns the number of\n.   inliers that pass the check.\n.   \n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param cameraMatrix1 Input/output camera matrix for the first camera, the same as in\n.   @ref calibrateCamera. Furthermore, for the stereo case, additional flags may be used, see below.\n.   @param distCoeffs1 Input/output vector of distortion coefficients, the same as in\n.   @ref calibrateCamera.\n.   @param cameraMatrix2 Input/output camera matrix for the first camera, the same as in\n.   @ref calibrateCamera. Furthermore, for the stereo case, additional flags may be used, see below.\n.   @param distCoeffs2 Input/output vector of distortion coefficients, the same as in\n.   @ref calibrateCamera.\n.   @param E The output essential matrix.\n.   @param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple\n.   that performs a change of basis from the first camera's coordinate system to the second camera's\n.   coordinate system. Note that, in general, t can not be used for this tuple, see the parameter\n.   described below.\n.   @param t Output translation vector. This vector is obtained by @ref decomposeEssentialMat and\n.   therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit\n.   length.\n.   @param method Method for computing an essential matrix.\n.   -   @ref RANSAC for the RANSAC algorithm.\n.   -   @ref LMEDS for the LMedS algorithm.\n.   @param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of\n.   confidence (probability) that the estimated matrix is correct.\n.   @param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks\n.   inliers in points1 and points2 for then given essential matrix E. Only these inliers will be used to\n.   recover pose. In the output mask only inliers which pass the cheirality check.\n.   \n.   This function decomposes an essential matrix using @ref decomposeEssentialMat and then verifies\n.   possible pose hypotheses by doing cheirality check. The cheirality check means that the\n.   triangulated 3D points should have positive depth. Some details can be found in @cite Nister03.\n.   \n.   This function can be used to process the output E and mask from @ref findEssentialMat. In this\n.   scenario, points1 and points2 are the same input for findEssentialMat.:\n.   @code\n.       // Example. Estimation of fundamental matrix using the RANSAC algorithm\n.       int point_count = 100;\n.       vector<Point2f> points1(point_count);\n.       vector<Point2f> points2(point_count);\n.   \n.       // initialize the points here ...\n.       for( int i = 0; i < point_count; i++ )\n.       {\n.           points1[i] = ...;\n.           points2[i] = ...;\n.       }\n.   \n.       // Input: camera calibration of both cameras, for example using intrinsic chessboard calibration.\n.       Mat cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2;\n.   \n.       // Output: Essential matrix, relative rotation and relative translation.\n.       Mat E, R, t, mask;\n.   \n.       recoverPose(points1, points2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, E, R, t, mask);\n.   @endcode\n\n\n\nrecoverPose(E, points1, points2, cameraMatrix[, R[, t[, mask]]]) -> retval, R, t, mask\n.   @brief Recovers the relative camera rotation and the translation from an estimated essential\n.   matrix and the corresponding points in two images, using chirality check. Returns the number of\n.   inliers that pass the check.\n.   \n.   @param E The input essential matrix.\n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param cameraMatrix Camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   Note that this function assumes that points1 and points2 are feature points from cameras with the\n.   same camera intrinsic matrix.\n.   @param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple\n.   that performs a change of basis from the first camera's coordinate system to the second camera's\n.   coordinate system. Note that, in general, t can not be used for this tuple, see the parameter\n.   described below.\n.   @param t Output translation vector. This vector is obtained by @ref decomposeEssentialMat and\n.   therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit\n.   length.\n.   @param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks\n.   inliers in points1 and points2 for the given essential matrix E. Only these inliers will be used to\n.   recover pose. In the output mask only inliers which pass the chirality check.\n.   \n.   This function decomposes an essential matrix using @ref decomposeEssentialMat and then verifies\n.   possible pose hypotheses by doing chirality check. The chirality check means that the\n.   triangulated 3D points should have positive depth. Some details can be found in @cite Nister03.\n.   \n.   This function can be used to process the output E and mask from @ref findEssentialMat. In this\n.   scenario, points1 and points2 are the same input for #findEssentialMat :\n.   @code\n.       // Example. Estimation of fundamental matrix using the RANSAC algorithm\n.       int point_count = 100;\n.       vector<Point2f> points1(point_count);\n.       vector<Point2f> points2(point_count);\n.   \n.       // initialize the points here ...\n.       for( int i = 0; i < point_count; i++ )\n.       {\n.           points1[i] = ...;\n.           points2[i] = ...;\n.       }\n.   \n.       // cametra matrix with both focal lengths = 1, and principal point = (0, 0)\n.       Mat cameraMatrix = Mat::eye(3, 3, CV_64F);\n.   \n.       Mat E, R, t, mask;\n.   \n.       E = findEssentialMat(points1, points2, cameraMatrix, RANSAC, 0.999, 1.0, mask);\n.       recoverPose(E, points1, points2, cameraMatrix, R, t, mask);\n.   @endcode\n\n\n\nrecoverPose(E, points1, points2[, R[, t[, focal[, pp[, mask]]]]]) -> retval, R, t, mask\n.   @overload\n.   @param E The input essential matrix.\n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple\n.   that performs a change of basis from the first camera's coordinate system to the second camera's\n.   coordinate system. Note that, in general, t can not be used for this tuple, see the parameter\n.   description below.\n.   @param t Output translation vector. This vector is obtained by @ref decomposeEssentialMat and\n.   therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit\n.   length.\n.   @param focal Focal length of the camera. Note that this function assumes that points1 and points2\n.   are feature points from cameras with same focal length and principal point.\n.   @param pp principal point of the camera.\n.   @param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks\n.   inliers in points1 and points2 for the given essential matrix E. Only these inliers will be used to\n.   recover pose. In the output mask only inliers which pass the chirality check.\n.   \n.   This function differs from the one above that it computes camera intrinsic matrix from focal length and\n.   principal point:\n.   \n.   \\f[A =\n.   \\begin{bmatrix}\n.   f & 0 & x_{pp}  \\\\\n.   0 & f & y_{pp}  \\\\\n.   0 & 0 & 1\n.   \\end{bmatrix}\\f]\n\n\n\nrecoverPose(E, points1, points2, cameraMatrix, distanceThresh[, R[, t[, mask[, triangulatedPoints]]]]) -> retval, R, t, mask, triangulatedPoints\n.   @overload\n.   @param E The input essential matrix.\n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1.\n.   @param cameraMatrix Camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   Note that this function assumes that points1 and points2 are feature points from cameras with the\n.   same camera intrinsic matrix.\n.   @param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple\n.   that performs a change of basis from the first camera's coordinate system to the second camera's\n.   coordinate system. Note that, in general, t can not be used for this tuple, see the parameter\n.   description below.\n.   @param t Output translation vector. This vector is obtained by @ref decomposeEssentialMat and\n.   therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit\n.   length.\n.   @param distanceThresh threshold distance which is used to filter out far away points (i.e. infinite\n.   points).\n.   @param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks\n.   inliers in points1 and points2 for the given essential matrix E. Only these inliers will be used to\n.   recover pose. In the output mask only inliers which pass the chirality check.\n.   @param triangulatedPoints 3D points which were reconstructed by triangulation.\n.   \n.   This function differs from the one above that it outputs the triangulated 3D point that are used for\n.   the chirality check."},
    {"rectangle", CV_PY_FN_WITH_KW_(pyopencv_cv_rectangle, 0), "rectangle(img, pt1, pt2, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a simple, thick, or filled up-right rectangle.\n.   \n.   The function cv::rectangle draws a rectangle outline or a filled rectangle whose two opposite corners\n.   are pt1 and pt2.\n.   \n.   @param img Image.\n.   @param pt1 Vertex of the rectangle.\n.   @param pt2 Vertex of the rectangle opposite to pt1 .\n.   @param color Rectangle color or brightness (grayscale image).\n.   @param thickness Thickness of lines that make up the rectangle. Negative values, like #FILLED,\n.   mean that the function has to draw a filled rectangle.\n.   @param lineType Type of the line. See #LineTypes\n.   @param shift Number of fractional bits in the point coordinates.\n\n\n\nrectangle(img, rec, color[, thickness[, lineType[, shift]]]) -> img\n.   @overload\n.   \n.   use `rec` parameter as alternative specification of the drawn rectangle: `r.tl() and\n.   r.br()-Point(1,1)` are opposite corners"},
    {"rectangleIntersectionArea", CV_PY_FN_WITH_KW_(pyopencv_cv_rectangleIntersectionArea, 0), "rectangleIntersectionArea(a, b) -> retval\n.   @brief Finds out if there is any intersection between two rectangles\n.    *\n.    * mainly useful for language bindings\n.    * @param a First rectangle\n.    * @param b Second rectangle\n.    * @return the area of the intersection"},
    {"rectify3Collinear", CV_PY_FN_WITH_KW_(pyopencv_cv_rectify3Collinear, 0), "rectify3Collinear(cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, cameraMatrix3, distCoeffs3, imgpt1, imgpt3, imageSize, R12, T12, R13, T13, alpha, newImgSize, flags[, R1[, R2[, R3[, P1[, P2[, P3[, Q]]]]]]]) -> retval, R1, R2, R3, P1, P2, P3, Q, roi1, roi2\n."},
    {"reduce", CV_PY_FN_WITH_KW_(pyopencv_cv_reduce, 0), "reduce(src, dim, rtype[, dst[, dtype]]) -> dst\n.   @brief Reduces a matrix to a vector.\n.   \n.   The function #reduce reduces the matrix to a vector by treating the matrix rows/columns as a set of\n.   1D vectors and performing the specified operation on the vectors until a single row/column is\n.   obtained. For example, the function can be used to compute horizontal and vertical projections of a\n.   raster image. In case of #REDUCE_MAX and #REDUCE_MIN, the output image should have the same type as the source one.\n.   In case of #REDUCE_SUM, #REDUCE_SUM2 and #REDUCE_AVG, the output may have a larger element bit-depth to preserve accuracy.\n.   And multi-channel arrays are also supported in these two reduction modes.\n.   \n.   The following code demonstrates its usage for a single channel matrix.\n.   @snippet snippets/core_reduce.cpp example\n.   \n.   And the following code demonstrates its usage for a two-channel matrix.\n.   @snippet snippets/core_reduce.cpp example2\n.   \n.   @param src input 2D matrix.\n.   @param dst output vector. Its size and type is defined by dim and dtype parameters.\n.   @param dim dimension index along which the matrix is reduced. 0 means that the matrix is reduced to\n.   a single row. 1 means that the matrix is reduced to a single column.\n.   @param rtype reduction operation that could be one of #ReduceTypes\n.   @param dtype when negative, the output vector will have the same type as the input matrix,\n.   otherwise, its type will be CV_MAKE_TYPE(CV_MAT_DEPTH(dtype), src.channels()).\n.   @sa repeat, reduceArgMin, reduceArgMax"},
    {"reduceArgMax", CV_PY_FN_WITH_KW_(pyopencv_cv_reduceArgMax, 0), "reduceArgMax(src, axis[, dst[, lastIndex]]) -> dst\n.   * @brief Finds indices of max elements along provided axis\n.    *\n.    * @note\n.    *      - If input or output array is not continuous, this function will create an internal copy.\n.    *      - NaN handling is left unspecified, see patchNaNs().\n.    *      - The returned index is always in bounds of input matrix.\n.    *\n.    * @param src input single-channel array.\n.    * @param dst output array of type CV_32SC1 with the same dimensionality as src,\n.    * except for axis being reduced - it should be set to 1.\n.    * @param lastIndex whether to get the index of first or last occurrence of max.\n.    * @param axis axis to reduce along.\n.    * @sa reduceArgMin, minMaxLoc, min, max, compare, reduce"},
    {"reduceArgMin", CV_PY_FN_WITH_KW_(pyopencv_cv_reduceArgMin, 0), "reduceArgMin(src, axis[, dst[, lastIndex]]) -> dst\n.   * @brief Finds indices of min elements along provided axis\n.    *\n.    * @note\n.    *      - If input or output array is not continuous, this function will create an internal copy.\n.    *      - NaN handling is left unspecified, see patchNaNs().\n.    *      - The returned index is always in bounds of input matrix.\n.    *\n.    * @param src input single-channel array.\n.    * @param dst output array of type CV_32SC1 with the same dimensionality as src,\n.    * except for axis being reduced - it should be set to 1.\n.    * @param lastIndex whether to get the index of first or last occurrence of min.\n.    * @param axis axis to reduce along.\n.    * @sa reduceArgMax, minMaxLoc, min, max, compare, reduce"},
    {"remap", CV_PY_FN_WITH_KW_(pyopencv_cv_remap, 0), "remap(src, map1, map2, interpolation[, dst[, borderMode[, borderValue]]]) -> dst\n.   @brief Applies a generic geometrical transformation to an image.\n.   \n.   The function remap transforms the source image using the specified map:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} (map_x(x,y),map_y(x,y))\\f]\n.   \n.   with the WARP_RELATIVE_MAP flag :\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} (x+map_x(x,y),y+map_y(x,y))\\f]\n.   \n.   where values of pixels with non-integer coordinates are computed using one of available\n.   interpolation methods. \\f$map_x\\f$ and \\f$map_y\\f$ can be encoded as separate floating-point maps\n.   in \\f$map_1\\f$ and \\f$map_2\\f$ respectively, or interleaved floating-point maps of \\f$(x,y)\\f$ in\n.   \\f$map_1\\f$, or fixed-point maps created by using #convertMaps. The reason you might want to\n.   convert from floating to fixed-point representations of a map is that they can yield much faster\n.   (\\~2x) remapping operations. In the converted case, \\f$map_1\\f$ contains pairs (cvFloor(x),\n.   cvFloor(y)) and \\f$map_2\\f$ contains indices in a table of interpolation coefficients.\n.   \n.   This function cannot operate in-place.\n.   \n.   @param src Source image.\n.   @param dst Destination image. It has the same size as map1 and the same type as src .\n.   @param map1 The first map of either (x,y) points or just x values having the type CV_16SC2 ,\n.   CV_32FC1, or CV_32FC2. See #convertMaps for details on converting a floating point\n.   representation to fixed-point for speed.\n.   @param map2 The second map of y values having the type CV_16UC1, CV_32FC1, or none (empty map\n.   if map1 is (x,y) points), respectively.\n.   @param interpolation Interpolation method (see #InterpolationFlags). The methods #INTER_AREA\n.   #INTER_LINEAR_EXACT and #INTER_NEAREST_EXACT are not supported by this function.\n.   The extra flag WARP_RELATIVE_MAP can be ORed to the interpolation method\n.   (e.g. INTER_LINEAR | WARP_RELATIVE_MAP)\n.   @param borderMode Pixel extrapolation method (see #BorderTypes). When\n.   borderMode=#BORDER_TRANSPARENT, it means that the pixels in the destination image that\n.   corresponds to the \"outliers\" in the source image are not modified by the function.\n.   @param borderValue Value used in case of a constant border. By default, it is 0.\n.   @note\n.   Due to current implementation limitations the size of an input and output images should be less than 32767x32767."},
    {"repeat", CV_PY_FN_WITH_KW_(pyopencv_cv_repeat, 0), "repeat(src, ny, nx[, dst]) -> dst\n.   @brief Fills the output array with repeated copies of the input array.\n.   \n.   The function cv::repeat duplicates the input array one or more times along each of the two axes:\n.   \\f[\\texttt{dst} _{ij}= \\texttt{src} _{i\\mod src.rows, \\; j\\mod src.cols }\\f]\n.   The second variant of the function is more convenient to use with @ref MatrixExpressions.\n.   @param src input array to replicate.\n.   @param ny Flag to specify how many times the `src` is repeated along the\n.   vertical axis.\n.   @param nx Flag to specify how many times the `src` is repeated along the\n.   horizontal axis.\n.   @param dst output array of the same type as `src`.\n.   @sa cv::reduce"},
    {"reprojectImageTo3D", CV_PY_FN_WITH_KW_(pyopencv_cv_reprojectImageTo3D, 0), "reprojectImageTo3D(disparity, Q[, _3dImage[, handleMissingValues[, ddepth]]]) -> _3dImage\n.   @brief Reprojects a disparity image to 3D space.\n.   \n.   @param disparity Input single-channel 8-bit unsigned, 16-bit signed, 32-bit signed or 32-bit\n.   floating-point disparity image. The values of 8-bit / 16-bit signed formats are assumed to have no\n.   fractional bits. If the disparity is 16-bit signed format, as computed by @ref StereoBM or\n.   @ref StereoSGBM and maybe other algorithms, it should be divided by 16 (and scaled to float) before\n.   being used here.\n.   @param _3dImage Output 3-channel floating-point image of the same size as disparity. Each element of\n.   _3dImage(x,y) contains 3D coordinates of the point (x,y) computed from the disparity map. If one\n.   uses Q obtained by @ref stereoRectify, then the returned points are represented in the first\n.   camera's rectified coordinate system.\n.   @param Q \\f$4 \\times 4\\f$ perspective transformation matrix that can be obtained with\n.   @ref stereoRectify.\n.   @param handleMissingValues Indicates, whether the function should handle missing values (i.e.\n.   points where the disparity was not computed). If handleMissingValues=true, then pixels with the\n.   minimal disparity that corresponds to the outliers (see StereoMatcher::compute ) are transformed\n.   to 3D points with a very large Z value (currently set to 10000).\n.   @param ddepth The optional output array depth. If it is -1, the output image will have CV_32F\n.   depth. ddepth can also be set to CV_16S, CV_32S or CV_32F.\n.   \n.   The function transforms a single-channel disparity map to a 3-channel image representing a 3D\n.   surface. That is, for each pixel (x,y) and the corresponding disparity d=disparity(x,y) , it\n.   computes:\n.   \n.   \\f[\\begin{bmatrix}\n.   X \\\\\n.   Y \\\\\n.   Z \\\\\n.   W\n.   \\end{bmatrix} = Q \\begin{bmatrix}\n.   x \\\\\n.   y \\\\\n.   \\texttt{disparity} (x,y) \\\\\n.   1\n.   \\end{bmatrix}.\\f]\n.   \n.   @sa\n.      To reproject a sparse set of points {(x,y,d),...} to 3D space, use perspectiveTransform."},
    {"resize", CV_PY_FN_WITH_KW_(pyopencv_cv_resize, 0), "resize(src, dsize[, dst[, fx[, fy[, interpolation]]]]) -> dst\n.   @brief Resizes an image.\n.   \n.   The function resize resizes the image src down to or up to the specified size. Note that the\n.   initial dst type or size are not taken into account. Instead, the size and type are derived from\n.   the `src`,`dsize`,`fx`, and `fy`. If you want to resize src so that it fits the pre-created dst,\n.   you may call the function as follows:\n.   @code\n.       // explicitly specify dsize=dst.size(); fx and fy will be computed from that.\n.       resize(src, dst, dst.size(), 0, 0, interpolation);\n.   @endcode\n.   If you want to decimate the image by factor of 2 in each direction, you can call the function this\n.   way:\n.   @code\n.       // specify fx and fy and let the function compute the destination image size.\n.       resize(src, dst, Size(), 0.5, 0.5, interpolation);\n.   @endcode\n.   To shrink an image, it will generally look best with #INTER_AREA interpolation, whereas to\n.   enlarge an image, it will generally look best with #INTER_CUBIC (slow) or #INTER_LINEAR\n.   (faster but still looks OK).\n.   \n.   @param src input image.\n.   @param dst output image; it has the size dsize (when it is non-zero) or the size computed from\n.   src.size(), fx, and fy; the type of dst is the same as of src.\n.   @param dsize output image size; if it equals zero (`None` in Python), it is computed as:\n.    \\f[\\texttt{dsize = Size(round(fx*src.cols), round(fy*src.rows))}\\f]\n.    Either dsize or both fx and fy must be non-zero.\n.   @param fx scale factor along the horizontal axis; when it equals 0, it is computed as\n.   \\f[\\texttt{(double)dsize.width/src.cols}\\f]\n.   @param fy scale factor along the vertical axis; when it equals 0, it is computed as\n.   \\f[\\texttt{(double)dsize.height/src.rows}\\f]\n.   @param interpolation interpolation method, see #InterpolationFlags\n.   \n.   @sa  warpAffine, warpPerspective, remap"},
    {"resizeWindow", CV_PY_FN_WITH_KW_(pyopencv_cv_resizeWindow, 0), "resizeWindow(winname, width, height) -> None\n.   @brief Resizes the window to the specified size\n.   \n.   @note The specified window size is for the image area. Toolbars are not counted.\n.   Only windows created without cv::WINDOW_AUTOSIZE flag can be resized.\n.   \n.   @param winname Window name.\n.   @param width The new window width.\n.   @param height The new window height.\n\n\n\nresizeWindow(winname, size) -> None\n.   @overload\n.   @param winname Window name.\n.   @param size The new window size."},
    {"rotate", CV_PY_FN_WITH_KW_(pyopencv_cv_rotate, 0), "rotate(src, rotateCode[, dst]) -> dst\n.   @brief Rotates a 2D array in multiples of 90 degrees.\n.   The function cv::rotate rotates the array in one of three different ways:\n.   *   Rotate by 90 degrees clockwise (rotateCode = ROTATE_90_CLOCKWISE).\n.   *   Rotate by 180 degrees clockwise (rotateCode = ROTATE_180).\n.   *   Rotate by 270 degrees clockwise (rotateCode = ROTATE_90_COUNTERCLOCKWISE).\n.   @param src input array.\n.   @param dst output array of the same type as src.  The size is the same with ROTATE_180,\n.   and the rows and cols are switched for ROTATE_90_CLOCKWISE and ROTATE_90_COUNTERCLOCKWISE.\n.   @param rotateCode an enum to specify how to rotate the array; see the enum #RotateFlags\n.   @sa transpose, repeat, completeSymm, flip, RotateFlags"},
    {"rotatedRectangleIntersection", CV_PY_FN_WITH_KW_(pyopencv_cv_rotatedRectangleIntersection, 0), "rotatedRectangleIntersection(rect1, rect2[, intersectingRegion]) -> retval, intersectingRegion\n.   @brief Finds out if there is any intersection between two rotated rectangles.\n.   \n.   If there is then the vertices of the intersecting region are returned as well.\n.   \n.   Below are some examples of intersection configurations. The hatched pattern indicates the\n.   intersecting region and the red vertices are returned by the function.\n.   \n.   ![intersection examples](pics/intersection.png)\n.   \n.   @param rect1 First rectangle\n.   @param rect2 Second rectangle\n.   @param intersectingRegion The output array of the vertices of the intersecting region. It returns\n.   at most 8 vertices. Stored as std::vector\\<cv::Point2f\\> or cv::Mat as Mx1 of type CV_32FC2.\n.   @returns One of #RectanglesIntersectTypes"},
    {"sampsonDistance", CV_PY_FN_WITH_KW_(pyopencv_cv_sampsonDistance, 0), "sampsonDistance(pt1, pt2, F) -> retval\n.   @brief Calculates the Sampson Distance between two points.\n.   \n.   The function cv::sampsonDistance calculates and returns the first order approximation of the geometric error as:\n.   \\f[\n.   sd( \\texttt{pt1} , \\texttt{pt2} )=\n.   \\frac{(\\texttt{pt2}^t \\cdot \\texttt{F} \\cdot \\texttt{pt1})^2}\n.   {((\\texttt{F} \\cdot \\texttt{pt1})(0))^2 +\n.   ((\\texttt{F} \\cdot \\texttt{pt1})(1))^2 +\n.   ((\\texttt{F}^t \\cdot \\texttt{pt2})(0))^2 +\n.   ((\\texttt{F}^t \\cdot \\texttt{pt2})(1))^2}\n.   \\f]\n.   The fundamental matrix may be calculated using the #findFundamentalMat function. See @cite HartleyZ00 11.4.3 for details.\n.   @param pt1 first homogeneous 2d point\n.   @param pt2 second homogeneous 2d point\n.   @param F fundamental matrix\n.   @return The computed Sampson distance."},
    {"scaleAdd", CV_PY_FN_WITH_KW_(pyopencv_cv_scaleAdd, 0), "scaleAdd(src1, alpha, src2[, dst]) -> dst\n.   @brief Calculates the sum of a scaled array and another array.\n.   \n.   The function scaleAdd is one of the classical primitive linear algebra operations, known as DAXPY\n.   or SAXPY in [BLAS](http://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms). It calculates\n.   the sum of a scaled array and another array:\n.   \\f[\\texttt{dst} (I)= \\texttt{scale} \\cdot \\texttt{src1} (I) +  \\texttt{src2} (I)\\f]\n.   The function can also be emulated with a matrix expression, for example:\n.   @code{.cpp}\n.       Mat A(3, 3, CV_64F);\n.       ...\n.       A.row(0) = A.row(1)*2 + A.row(2);\n.   @endcode\n.   @param src1 first input array.\n.   @param alpha scale factor for the first array.\n.   @param src2 second input array of the same size and type as src1.\n.   @param dst output array of the same size and type as src1.\n.   @sa add, addWeighted, subtract, Mat::dot, Mat::convertTo"},
    {"seamlessClone", CV_PY_FN_WITH_KW_(pyopencv_cv_seamlessClone, 0), "seamlessClone(src, dst, mask, p, flags[, blend]) -> blend\n.   @brief Performs seamless cloning to blend a region from a source image into a destination image.\n.   This function is designed for local image editing, allowing changes restricted to a region\n.   (manually selected as the ROI) to be applied effortlessly and seamlessly. These changes can\n.   range from slight distortions to complete replacement by novel content @cite PM03.\n.   \n.   @param src The source image (8-bit 3-channel), from which a region will be blended into the destination.\n.   @param dst The destination image (8-bit 3-channel), where the src image will be blended.\n.   @param mask A binary mask (8-bit, 1, 3, or 4-channel) specifying the region in the source image to blend.\n.   Non-zero pixels indicate the region to be blended. If an empty Mat is provided, a mask with\n.   all non-zero pixels is created internally.\n.   @param p The point where the center of the src image is placed in the dst image.\n.   @param blend The output image that stores the result of the seamless cloning. It has the same size and type as `dst`.\n.   @param flags Flags that control the type of cloning method, can take values of `cv::SeamlessCloneFlags`."},
    {"selectROI", CV_PY_FN_WITH_KW_(pyopencv_cv_selectROI, 0), "selectROI(windowName, img[, showCrosshair[, fromCenter[, printNotice]]]) -> retval\n.   @brief Allows users to select a ROI on the given image.\n.   \n.   The function creates a window and allows users to select a ROI using the mouse.\n.   Controls: use `space` or `enter` to finish selection, use key `c` to cancel selection (function will return the zero cv::Rect).\n.   \n.   @param windowName name of the window where selection process will be shown.\n.   @param img image to select a ROI.\n.   @param showCrosshair if true crosshair of selection rectangle will be shown.\n.   @param fromCenter if true center of selection will match initial mouse position. In opposite case a corner of\n.   selection rectangle will correspont to the initial mouse position.\n.   @param printNotice if true a notice to select ROI or cancel selection will be printed in console.\n.   @return selected ROI or empty rect if selection canceled.\n.   \n.   @note The function sets it's own mouse callback for specified window using cv::setMouseCallback(windowName, ...).\n.   After finish of work an empty callback will be set for the used window.\n\n\n\nselectROI(img[, showCrosshair[, fromCenter[, printNotice]]]) -> retval\n.   @overload"},
    {"selectROIs", CV_PY_FN_WITH_KW_(pyopencv_cv_selectROIs, 0), "selectROIs(windowName, img[, showCrosshair[, fromCenter[, printNotice]]]) -> boundingBoxes\n.   @brief Allows users to select multiple ROIs on the given image.\n.   \n.   The function creates a window and allows users to select multiple ROIs using the mouse.\n.   Controls: use `space` or `enter` to finish current selection and start a new one,\n.   use `esc` to terminate multiple ROI selection process.\n.   \n.   @param windowName name of the window where selection process will be shown.\n.   @param img image to select a ROI.\n.   @param boundingBoxes selected ROIs.\n.   @param showCrosshair if true crosshair of selection rectangle will be shown.\n.   @param fromCenter if true center of selection will match initial mouse position. In opposite case a corner of\n.   selection rectangle will correspont to the initial mouse position.\n.   @param printNotice if true a notice to select ROI or cancel selection will be printed in console.\n.   \n.   @note The function sets it's own mouse callback for specified window using cv::setMouseCallback(windowName, ...).\n.   After finish of work an empty callback will be set for the used window."},
    {"sepFilter2D", CV_PY_FN_WITH_KW_(pyopencv_cv_sepFilter2D, 0), "sepFilter2D(src, ddepth, kernelX, kernelY[, dst[, anchor[, delta[, borderType]]]]) -> dst\n.   @brief Applies a separable linear filter to an image.\n.   \n.   The function applies a separable linear filter to the image. That is, first, every row of src is\n.   filtered with the 1D kernel kernelX. Then, every column of the result is filtered with the 1D\n.   kernel kernelY. The final result shifted by delta is stored in dst .\n.   \n.   @param src Source image.\n.   @param dst Destination image of the same size and the same number of channels as src .\n.   @param ddepth Destination image depth, see @ref filter_depths \"combinations\"\n.   @param kernelX Coefficients for filtering each row.\n.   @param kernelY Coefficients for filtering each column.\n.   @param anchor Anchor position within the kernel. The default value \\f$(-1,-1)\\f$ means that the anchor\n.   is at the kernel center.\n.   @param delta Value added to the filtered results before storing them.\n.   @param borderType Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa  filter2D, Sobel, GaussianBlur, boxFilter, blur"},
    {"setIdentity", CV_PY_FN_WITH_KW_(pyopencv_cv_setIdentity, 0), "setIdentity(mtx[, s]) -> mtx\n.   @brief Initializes a scaled identity matrix.\n.   \n.   The function cv::setIdentity initializes a scaled identity matrix:\n.   \\f[\\texttt{mtx} (i,j)= \\fork{\\texttt{value}}{ if \\(i=j\\)}{0}{otherwise}\\f]\n.   \n.   The function can also be emulated using the matrix initializers and the\n.   matrix expressions:\n.   @code\n.       Mat A = Mat::eye(4, 3, CV_32F)*5;\n.       // A will be set to [[5, 0, 0], [0, 5, 0], [0, 0, 5], [0, 0, 0]]\n.   @endcode\n.   @param mtx matrix to initialize (not necessarily square).\n.   @param s value to assign to diagonal elements.\n.   @sa Mat::zeros, Mat::ones, Mat::setTo, Mat::operator="},
    {"setLogLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_setLogLevel, 0), "setLogLevel(level) -> retval\n."},
    {"setNumThreads", CV_PY_FN_WITH_KW_(pyopencv_cv_setNumThreads, 0), "setNumThreads(nthreads) -> None\n.   @brief OpenCV will try to set the number of threads for subsequent parallel regions.\n.   \n.   If threads == 1, OpenCV will disable threading optimizations and run all it's functions\n.   sequentially. Passing threads \\< 0 will reset threads number to system default.\n.   The function is not thread-safe. It must not be called in parallel region or concurrent threads.\n.   \n.   OpenCV will try to run its functions with specified threads number, but some behaviour differs from\n.   framework:\n.   -   `TBB` - User-defined parallel constructions will run with the same threads number, if\n.       another is not specified. If later on user creates his own scheduler, OpenCV will use it.\n.   -   `OpenMP` - No special defined behaviour.\n.   -   `Concurrency` - If threads == 1, OpenCV will disable threading optimizations and run its\n.       functions sequentially.\n.   -   `GCD` - Supports only values \\<= 0.\n.   -   `C=` - No special defined behaviour.\n.   @param nthreads Number of threads used by OpenCV.\n.   @sa getNumThreads, getThreadNum"},
    {"setRNGSeed", CV_PY_FN_WITH_KW_(pyopencv_cv_setRNGSeed, 0), "setRNGSeed(seed) -> None\n.   @brief Sets state of default random number generator.\n.   \n.   The function cv::setRNGSeed sets state of default random number generator to custom value.\n.   @param seed new state for default random number generator\n.   @sa RNG, randu, randn"},
    {"setTrackbarMax", CV_PY_FN_WITH_KW_(pyopencv_cv_setTrackbarMax, 0), "setTrackbarMax(trackbarname, winname, maxval) -> None\n.   @brief Sets the trackbar maximum position.\n.   \n.   The function sets the maximum position of the specified trackbar in the specified window.\n.   \n.   @note [__Qt Backend Only__] winname can be empty if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of trackbar.\n.   @param maxval New maximum position."},
    {"setTrackbarMin", CV_PY_FN_WITH_KW_(pyopencv_cv_setTrackbarMin, 0), "setTrackbarMin(trackbarname, winname, minval) -> None\n.   @brief Sets the trackbar minimum position.\n.   \n.   The function sets the minimum position of the specified trackbar in the specified window.\n.   \n.   @note [__Qt Backend Only__] winname can be empty if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of trackbar.\n.   @param minval New minimum position."},
    {"setTrackbarPos", CV_PY_FN_WITH_KW_(pyopencv_cv_setTrackbarPos, 0), "setTrackbarPos(trackbarname, winname, pos) -> None\n.   @brief Sets the trackbar position.\n.   \n.   The function sets the position of the specified trackbar in the specified window.\n.   \n.   @note [__Qt Backend Only__] winname can be empty if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of trackbar.\n.   @param pos New position."},
    {"setUseOpenVX", CV_PY_FN_WITH_KW_(pyopencv_cv_setUseOpenVX, 0), "setUseOpenVX(flag) -> None\n."},
    {"setUseOptimized", CV_PY_FN_WITH_KW_(pyopencv_cv_setUseOptimized, 0), "setUseOptimized(onoff) -> None\n.   @brief Enables or disables the optimized code.\n.   \n.   The function can be used to dynamically turn on and off optimized dispatched code (code that uses SSE4.2, AVX/AVX2,\n.   and other instructions on the platforms that support it). It sets a global flag that is further\n.   checked by OpenCV functions. Since the flag is not checked in the inner OpenCV loops, it is only\n.   safe to call the function on the very top level in your application where you can be sure that no\n.   other OpenCV function is currently executed.\n.   \n.   By default, the optimized code is enabled unless you disable it in CMake. The current status can be\n.   retrieved using useOptimized.\n.   @param onoff The boolean flag specifying whether the optimized code should be used (onoff=true)\n.   or not (onoff=false)."},
    {"setWindowProperty", CV_PY_FN_WITH_KW_(pyopencv_cv_setWindowProperty, 0), "setWindowProperty(winname, prop_id, prop_value) -> None\n.   @brief Changes parameters of a window dynamically.\n.   \n.   The function setWindowProperty enables changing properties of a window.\n.   \n.   @param winname Name of the window.\n.   @param prop_id Window property to edit. The supported operation flags are: (cv::WindowPropertyFlags)\n.   @param prop_value New value of the window property. The supported flags are: (cv::WindowFlags)\n.   \n.   @note [__Wayland Backend Only__] This function is not supported."},
    {"setWindowTitle", CV_PY_FN_WITH_KW_(pyopencv_cv_setWindowTitle, 0), "setWindowTitle(winname, title) -> None\n.   @brief Updates window title\n.   @param winname Name of the window.\n.   @param title New title."},
    {"solve", CV_PY_FN_WITH_KW_(pyopencv_cv_solve, 0), "solve(src1, src2[, dst[, flags]]) -> retval, dst\n.   @brief Solves one or more linear systems or least-squares problems.\n.   \n.   The function cv::solve solves a linear system or least-squares problem (the\n.   latter is possible with SVD or QR methods, or by specifying the flag\n.   #DECOMP_NORMAL ):\n.   \\f[\\texttt{dst} =  \\arg \\min _X \\| \\texttt{src1} \\cdot \\texttt{X} -  \\texttt{src2} \\|\\f]\n.   \n.   If #DECOMP_LU or #DECOMP_CHOLESKY method is used, the function returns 1\n.   if src1 (or \\f$\\texttt{src1}^T\\texttt{src1}\\f$ ) is non-singular. Otherwise,\n.   it returns 0. In the latter case, dst is not valid. Other methods find a\n.   pseudo-solution in case of a singular left-hand side part.\n.   \n.   @note If you want to find a unity-norm solution of an under-defined\n.   singular system \\f$\\texttt{src1}\\cdot\\texttt{dst}=0\\f$ , the function solve\n.   will not do the work. Use SVD::solveZ instead.\n.   \n.   @param src1 input matrix on the left-hand side of the system.\n.   @param src2 input matrix on the right-hand side of the system.\n.   @param dst output solution.\n.   @param flags solution (matrix inversion) method (#DecompTypes)\n.   @sa invert, SVD, eigen"},
    {"solveCubic", CV_PY_FN_WITH_KW_(pyopencv_cv_solveCubic, 0), "solveCubic(coeffs[, roots]) -> retval, roots\n.   @brief Finds the real roots of a cubic equation.\n.   \n.   The function solveCubic finds the real roots of a cubic equation:\n.   -   if coeffs is a 4-element vector:\n.   \\f[\\texttt{coeffs} [0] x^3 +  \\texttt{coeffs} [1] x^2 +  \\texttt{coeffs} [2] x +  \\texttt{coeffs} [3] = 0\\f]\n.   -   if coeffs is a 3-element vector:\n.   \\f[x^3 +  \\texttt{coeffs} [0] x^2 +  \\texttt{coeffs} [1] x +  \\texttt{coeffs} [2] = 0\\f]\n.   \n.   The roots are stored in the roots array.\n.   @param coeffs equation coefficients, an array of 3 or 4 elements.\n.   @param roots output array of real roots that has 0, 1, 2 or 3 elements.\n.   @return number of real roots. It can be -1 (all real numbers), 0, 1, 2 or 3."},
    {"solveLP", CV_PY_FN_WITH_KW_(pyopencv_cv_solveLP, 0), "solveLP(Func, Constr, constr_eps[, z]) -> retval, z\n.   @brief Solve given (non-integer) linear programming problem using the Simplex Algorithm (Simplex Method).\n.   \n.   What we mean here by \"linear programming problem\" (or LP problem, for short) can be formulated as:\n.   \n.   \\f[\\mbox{Maximize } c\\cdot x\\\\\n.    \\mbox{Subject to:}\\\\\n.    Ax\\leq b\\\\\n.    x\\geq 0\\f]\n.   \n.   Where \\f$c\\f$ is fixed `1`-by-`n` row-vector, \\f$A\\f$ is fixed `m`-by-`n` matrix, \\f$b\\f$ is fixed `m`-by-`1`\n.   column vector and \\f$x\\f$ is an arbitrary `n`-by-`1` column vector, which satisfies the constraints.\n.   \n.   Simplex algorithm is one of many algorithms that are designed to handle this sort of problems\n.   efficiently. Although it is not optimal in theoretical sense (there exist algorithms that can solve\n.   any problem written as above in polynomial time, while simplex method degenerates to exponential\n.   time for some special cases), it is well-studied, easy to implement and is shown to work well for\n.   real-life purposes.\n.   \n.   The particular implementation is taken almost verbatim from **Introduction to Algorithms, third\n.   edition** by T. H. Cormen, C. E. Leiserson, R. L. Rivest and Clifford Stein. In particular, the\n.   Bland's rule <http://en.wikipedia.org/wiki/Bland%27s_rule> is used to prevent cycling.\n.   \n.   @param Func This row-vector corresponds to \\f$c\\f$ in the LP problem formulation (see above). It should\n.   contain 32- or 64-bit floating point numbers. As a convenience, column-vector may be also submitted,\n.   in the latter case it is understood to correspond to \\f$c^T\\f$.\n.   @param Constr `m`-by-`n+1` matrix, whose rightmost column corresponds to \\f$b\\f$ in formulation above\n.   and the remaining to \\f$A\\f$. It should contain 32- or 64-bit floating point numbers.\n.   @param z The solution will be returned here as a column-vector - it corresponds to \\f$c\\f$ in the\n.   formulation above. It will contain 64-bit floating point numbers.\n.   @param constr_eps allowed numeric disparity for constraints\n.   @return One of cv::SolveLPResult\n\n\n\nsolveLP(Func, Constr[, z]) -> retval, z\n.   @overload"},
    {"solveP3P", CV_PY_FN_WITH_KW_(pyopencv_cv_solveP3P, 0), "solveP3P(objectPoints, imagePoints, cameraMatrix, distCoeffs, flags[, rvecs[, tvecs]]) -> retval, rvecs, tvecs\n.   @brief Finds an object pose \\f$ {}^{c}\\mathbf{T}_o \\f$ from **3** 3D-2D point correspondences.\n.   \n.   ![Perspective projection, from object to camera frame](pics/pinhole_homogeneous_transformation.png){ width=50% }\n.   \n.   @see @ref calib3d_solvePnP\n.   \n.   @param objectPoints Array of object points in the object coordinate space, 3x3 1-channel or\n.   1x3/3x1 3-channel. vector\\<Point3f\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, 3x2 1-channel or 1x3/3x1 2-channel.\n.    vector\\<Point2f\\> can be also passed here.\n.   @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvecs Output rotation vectors (see @ref Rodrigues ) that, together with tvecs, brings points from\n.   the model coordinate system to the camera coordinate system. A P3P problem has up to 4 solutions.\n.   @param tvecs Output translation vectors.\n.   @param flags Method for solving a P3P problem:\n.   -   @ref SOLVEPNP_P3P Method is based on the paper of X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang\n.   \"Complete Solution Classification for the Perspective-Three-Point Problem\" (@cite gao2003complete).\n.   -   @ref SOLVEPNP_AP3P Method is based on the paper of T. Ke and S. Roumeliotis.\n.   \"An Efficient Algebraic Solution to the Perspective-Three-Point Problem\" (@cite Ke17).\n.   \n.   The function estimates the object pose given 3 object points, their corresponding image\n.   projections, as well as the camera intrinsic matrix and the distortion coefficients.\n.   \n.   @note\n.   The solutions are sorted by reprojection errors (lowest to highest)."},
    {"solvePnP", CV_PY_FN_WITH_KW_(pyopencv_cv_solvePnP, 0), "solvePnP(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess[, flags]]]]) -> retval, rvec, tvec\n.   @brief Finds an object pose \\f$ {}^{c}\\mathbf{T}_o \\f$ from 3D-2D point correspondences:\n.   \n.   ![Perspective projection, from object to camera frame](pics/pinhole_homogeneous_transformation.png){ width=50% }\n.   \n.   @see @ref calib3d_solvePnP\n.   \n.   This function returns the rotation and the translation vectors that transform a 3D point expressed in the object\n.   coordinate frame to the camera coordinate frame, using different methods:\n.   - P3P methods (@ref SOLVEPNP_P3P, @ref SOLVEPNP_AP3P): need 4 input points to return a unique solution.\n.   - @ref SOLVEPNP_IPPE Input points must be >= 4 and object points must be coplanar.\n.   - @ref SOLVEPNP_IPPE_SQUARE Special case suitable for marker pose estimation.\n.   Number of input points must be 4. Object points must be defined in the following order:\n.     - point 0: [-squareLength / 2,  squareLength / 2, 0]\n.     - point 1: [ squareLength / 2,  squareLength / 2, 0]\n.     - point 2: [ squareLength / 2, -squareLength / 2, 0]\n.     - point 3: [-squareLength / 2, -squareLength / 2, 0]\n.   - for all the other flags, number of input points must be >= 4 and object points can be in any configuration.\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.   1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3d\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2d\\> can be also passed here.\n.   @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvec Output rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.   the model coordinate system to the camera coordinate system.\n.   @param tvec Output translation vector.\n.   @param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses\n.   the provided rvec and tvec values as initial approximations of the rotation and translation\n.   vectors, respectively, and further optimizes them.\n.   @param flags Method for solving a PnP problem: see @ref calib3d_solvePnP_flags\n.   \n.   More information about Perspective-n-Points is described in @ref calib3d_solvePnP\n.   \n.   @note\n.      -   An example of how to use solvePnP for planar augmented reality can be found at\n.           opencv_source_code/samples/python/plane_ar.py\n.      -   If you are using Python:\n.           - Numpy array slices won't work as input because solvePnP requires contiguous\n.           arrays (enforced by the assertion using cv::Mat::checkVector() around line 55 of\n.           modules/calib3d/src/solvepnp.cpp version 2.4.9)\n.           - The P3P algorithm requires image points to be in an array of shape (N,1,2) due\n.           to its calling of #undistortPoints (around line 75 of modules/calib3d/src/solvepnp.cpp version 2.4.9)\n.           which requires 2-channel information.\n.           - Thus, given some data D = np.array(...) where D.shape = (N,M), in order to use a subset of\n.           it as, e.g., imagePoints, one must effectively copy it into a new array: imagePoints =\n.           np.ascontiguousarray(D[:,:2]).reshape((N,1,2))\n.      -   The methods @ref SOLVEPNP_DLS and @ref SOLVEPNP_UPNP cannot be used as the current implementations are\n.          unstable and sometimes give completely wrong results. If you pass one of these two\n.          flags, @ref SOLVEPNP_EPNP method will be used instead.\n.      -   The minimum number of points is 4 in the general case. In the case of @ref SOLVEPNP_P3P and @ref SOLVEPNP_AP3P\n.          methods, it is required to use exactly 4 points (the first 3 points are used to estimate all the solutions\n.          of the P3P problem, the last one is used to retain the best solution that minimizes the reprojection error).\n.      -   With @ref SOLVEPNP_ITERATIVE method and `useExtrinsicGuess=true`, the minimum number of points is 3 (3 points\n.          are sufficient to compute a pose but there are up to 4 solutions). The initial solution should be close to the\n.          global solution to converge.\n.      -   With @ref SOLVEPNP_IPPE input points must be >= 4 and object points must be coplanar.\n.      -   With @ref SOLVEPNP_IPPE_SQUARE this is a special case suitable for marker pose estimation.\n.          Number of input points must be 4. Object points must be defined in the following order:\n.            - point 0: [-squareLength / 2,  squareLength / 2, 0]\n.            - point 1: [ squareLength / 2,  squareLength / 2, 0]\n.            - point 2: [ squareLength / 2, -squareLength / 2, 0]\n.            - point 3: [-squareLength / 2, -squareLength / 2, 0]\n.      -   With @ref SOLVEPNP_SQPNP input points must be >= 3"},
    {"solvePnPGeneric", CV_PY_FN_WITH_KW_(pyopencv_cv_solvePnPGeneric, 0), "solvePnPGeneric(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvecs[, tvecs[, useExtrinsicGuess[, flags[, rvec[, tvec[, reprojectionError]]]]]]]) -> retval, rvecs, tvecs, reprojectionError\n.   @brief Finds an object pose \\f$ {}^{c}\\mathbf{T}_o \\f$ from 3D-2D point correspondences.\n.   \n.   ![Perspective projection, from object to camera frame](pics/pinhole_homogeneous_transformation.png){ width=50% }\n.   \n.   @see @ref calib3d_solvePnP\n.   \n.   This function returns a list of all the possible solutions (a solution is a <rotation vector, translation vector>\n.   couple), depending on the number of input points and the chosen method:\n.   - P3P methods (@ref SOLVEPNP_P3P, @ref SOLVEPNP_AP3P): 3 or 4 input points. Number of returned solutions can be between 0 and 4 with 3 input points.\n.   - @ref SOLVEPNP_IPPE Input points must be >= 4 and object points must be coplanar. Returns 2 solutions.\n.   - @ref SOLVEPNP_IPPE_SQUARE Special case suitable for marker pose estimation.\n.   Number of input points must be 4 and 2 solutions are returned. Object points must be defined in the following order:\n.     - point 0: [-squareLength / 2,  squareLength / 2, 0]\n.     - point 1: [ squareLength / 2,  squareLength / 2, 0]\n.     - point 2: [ squareLength / 2, -squareLength / 2, 0]\n.     - point 3: [-squareLength / 2, -squareLength / 2, 0]\n.   - for all the other flags, number of input points must be >= 4 and object points can be in any configuration.\n.   Only 1 solution is returned.\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.   1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3d\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2d\\> can be also passed here.\n.   @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvecs Vector of output rotation vectors (see @ref Rodrigues ) that, together with tvecs, brings points from\n.   the model coordinate system to the camera coordinate system.\n.   @param tvecs Vector of output translation vectors.\n.   @param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses\n.   the provided rvec and tvec values as initial approximations of the rotation and translation\n.   vectors, respectively, and further optimizes them.\n.   @param flags Method for solving a PnP problem: see @ref calib3d_solvePnP_flags\n.   @param rvec Rotation vector used to initialize an iterative PnP refinement algorithm, when flag is @ref SOLVEPNP_ITERATIVE\n.   and useExtrinsicGuess is set to true.\n.   @param tvec Translation vector used to initialize an iterative PnP refinement algorithm, when flag is @ref SOLVEPNP_ITERATIVE\n.   and useExtrinsicGuess is set to true.\n.   @param reprojectionError Optional vector of reprojection error, that is the RMS error\n.   (\\f$ \\text{RMSE} = \\sqrt{\\frac{\\sum_{i}^{N} \\left ( \\hat{y_i} - y_i \\right )^2}{N}} \\f$) between the input image points\n.   and the 3D object points projected with the estimated pose.\n.   \n.   More information is described in @ref calib3d_solvePnP\n.   \n.   @note\n.      -   An example of how to use solvePnP for planar augmented reality can be found at\n.           opencv_source_code/samples/python/plane_ar.py\n.      -   If you are using Python:\n.           - Numpy array slices won't work as input because solvePnP requires contiguous\n.           arrays (enforced by the assertion using cv::Mat::checkVector() around line 55 of\n.           modules/calib3d/src/solvepnp.cpp version 2.4.9)\n.           - The P3P algorithm requires image points to be in an array of shape (N,1,2) due\n.           to its calling of #undistortPoints (around line 75 of modules/calib3d/src/solvepnp.cpp version 2.4.9)\n.           which requires 2-channel information.\n.           - Thus, given some data D = np.array(...) where D.shape = (N,M), in order to use a subset of\n.           it as, e.g., imagePoints, one must effectively copy it into a new array: imagePoints =\n.           np.ascontiguousarray(D[:,:2]).reshape((N,1,2))\n.      -   The methods @ref SOLVEPNP_DLS and @ref SOLVEPNP_UPNP cannot be used as the current implementations are\n.          unstable and sometimes give completely wrong results. If you pass one of these two\n.          flags, @ref SOLVEPNP_EPNP method will be used instead.\n.      -   The minimum number of points is 4 in the general case. In the case of @ref SOLVEPNP_P3P and @ref SOLVEPNP_AP3P\n.          methods, it is required to use exactly 4 points (the first 3 points are used to estimate all the solutions\n.          of the P3P problem, the last one is used to retain the best solution that minimizes the reprojection error).\n.      -   With @ref SOLVEPNP_ITERATIVE method and `useExtrinsicGuess=true`, the minimum number of points is 3 (3 points\n.          are sufficient to compute a pose but there are up to 4 solutions). The initial solution should be close to the\n.          global solution to converge.\n.      -   With @ref SOLVEPNP_IPPE input points must be >= 4 and object points must be coplanar.\n.      -   With @ref SOLVEPNP_IPPE_SQUARE this is a special case suitable for marker pose estimation.\n.          Number of input points must be 4. Object points must be defined in the following order:\n.            - point 0: [-squareLength / 2,  squareLength / 2, 0]\n.            - point 1: [ squareLength / 2,  squareLength / 2, 0]\n.            - point 2: [ squareLength / 2, -squareLength / 2, 0]\n.            - point 3: [-squareLength / 2, -squareLength / 2, 0]\n.      -   With @ref SOLVEPNP_SQPNP input points must be >= 3"},
    {"solvePnPRansac", CV_PY_FN_WITH_KW_(pyopencv_cv_solvePnPRansac, 0), "solvePnPRansac(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess[, iterationsCount[, reprojectionError[, confidence[, inliers[, flags]]]]]]]]) -> retval, rvec, tvec, inliers\n.   @brief Finds an object pose \\f$ {}^{c}\\mathbf{T}_o \\f$ from 3D-2D point correspondences using the RANSAC scheme to deal with bad matches.\n.   \n.   ![Perspective projection, from object to camera frame](pics/pinhole_homogeneous_transformation.png){ width=50% }\n.   \n.   @see @ref calib3d_solvePnP\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.   1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3d\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2d\\> can be also passed here.\n.   @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvec Output rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.   the model coordinate system to the camera coordinate system.\n.   @param tvec Output translation vector.\n.   @param useExtrinsicGuess Parameter used for @ref SOLVEPNP_ITERATIVE. If true (1), the function uses\n.   the provided rvec and tvec values as initial approximations of the rotation and translation\n.   vectors, respectively, and further optimizes them.\n.   @param iterationsCount Number of iterations.\n.   @param reprojectionError Inlier threshold value used by the RANSAC procedure. The parameter value\n.   is the maximum allowed distance between the observed and computed point projections to consider it\n.   an inlier.\n.   @param confidence The probability that the algorithm produces a useful result.\n.   @param inliers Output vector that contains indices of inliers in objectPoints and imagePoints .\n.   @param flags Method for solving a PnP problem (see @ref solvePnP ).\n.   \n.   The function estimates an object pose given a set of object points, their corresponding image\n.   projections, as well as the camera intrinsic matrix and the distortion coefficients. This function finds such\n.   a pose that minimizes reprojection error, that is, the sum of squared distances between the observed\n.   projections imagePoints and the projected (using @ref projectPoints ) objectPoints. The use of RANSAC\n.   makes the function resistant to outliers.\n.   \n.   @note\n.      -   An example of how to use solvePnPRansac for object detection can be found at\n.           @ref tutorial_real_time_pose\n.      -   The default method used to estimate the camera pose for the Minimal Sample Sets step\n.          is #SOLVEPNP_EPNP. Exceptions are:\n.            - if you choose #SOLVEPNP_P3P or #SOLVEPNP_AP3P, these methods will be used.\n.            - if the number of input points is equal to 4, #SOLVEPNP_P3P is used.\n.      -   The method used to estimate the camera pose using all the inliers is defined by the\n.          flags parameters unless it is equal to #SOLVEPNP_P3P or #SOLVEPNP_AP3P. In this case,\n.          the method #SOLVEPNP_EPNP will be used instead.\n\n\n\nsolvePnPRansac(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, inliers[, params]]]]) -> retval, cameraMatrix, rvec, tvec, inliers\n."},
    {"solvePnPRefineLM", CV_PY_FN_WITH_KW_(pyopencv_cv_solvePnPRefineLM, 0), "solvePnPRefineLM(objectPoints, imagePoints, cameraMatrix, distCoeffs, rvec, tvec[, criteria]) -> rvec, tvec\n.   @brief Refine a pose (the translation and the rotation that transform a 3D point expressed in the object coordinate frame\n.   to the camera coordinate frame) from a 3D-2D point correspondences and starting from an initial solution.\n.   \n.   @see @ref calib3d_solvePnP\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or 1xN/Nx1 3-channel,\n.   where N is the number of points. vector\\<Point3d\\> can also be passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2d\\> can also be passed here.\n.   @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvec Input/Output rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.   the model coordinate system to the camera coordinate system. Input values are used as an initial solution.\n.   @param tvec Input/Output translation vector. Input values are used as an initial solution.\n.   @param criteria Criteria when to stop the Levenberg-Marquard iterative algorithm.\n.   \n.   The function refines the object pose given at least 3 object points, their corresponding image\n.   projections, an initial solution for the rotation and translation vector,\n.   as well as the camera intrinsic matrix and the distortion coefficients.\n.   The function minimizes the projection error with respect to the rotation and the translation vectors, according\n.   to a Levenberg-Marquardt iterative minimization @cite Madsen04 @cite Eade13 process."},
    {"solvePnPRefineVVS", CV_PY_FN_WITH_KW_(pyopencv_cv_solvePnPRefineVVS, 0), "solvePnPRefineVVS(objectPoints, imagePoints, cameraMatrix, distCoeffs, rvec, tvec[, criteria[, VVSlambda]]) -> rvec, tvec\n.   @brief Refine a pose (the translation and the rotation that transform a 3D point expressed in the object coordinate frame\n.   to the camera coordinate frame) from a 3D-2D point correspondences and starting from an initial solution.\n.   \n.   @see @ref calib3d_solvePnP\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or 1xN/Nx1 3-channel,\n.   where N is the number of points. vector\\<Point3d\\> can also be passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2d\\> can also be passed here.\n.   @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$\\distcoeffs\\f$. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvec Input/Output rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.   the model coordinate system to the camera coordinate system. Input values are used as an initial solution.\n.   @param tvec Input/Output translation vector. Input values are used as an initial solution.\n.   @param criteria Criteria when to stop the Levenberg-Marquard iterative algorithm.\n.   @param VVSlambda Gain for the virtual visual servoing control law, equivalent to the \\f$\\alpha\\f$\n.   gain in the Damped Gauss-Newton formulation.\n.   \n.   The function refines the object pose given at least 3 object points, their corresponding image\n.   projections, an initial solution for the rotation and translation vector,\n.   as well as the camera intrinsic matrix and the distortion coefficients.\n.   The function minimizes the projection error with respect to the rotation and the translation vectors, using a\n.   virtual visual servoing (VVS) @cite Chaumette06 @cite Marchand16 scheme."},
    {"solvePoly", CV_PY_FN_WITH_KW_(pyopencv_cv_solvePoly, 0), "solvePoly(coeffs[, roots[, maxIters]]) -> retval, roots\n.   @brief Finds the real or complex roots of a polynomial equation.\n.   \n.   The function cv::solvePoly finds real and complex roots of a polynomial equation:\n.   \\f[\\texttt{coeffs} [n] x^{n} +  \\texttt{coeffs} [n-1] x^{n-1} + ... +  \\texttt{coeffs} [1] x +  \\texttt{coeffs} [0] = 0\\f]\n.   @param coeffs array of polynomial coefficients.\n.   @param roots output (complex) array of roots.\n.   @param maxIters maximum number of iterations the algorithm does."},
    {"sort", CV_PY_FN_WITH_KW_(pyopencv_cv_sort, 0), "sort(src, flags[, dst]) -> dst\n.   @brief Sorts each row or each column of a matrix.\n.   \n.   The function cv::sort sorts each matrix row or each matrix column in\n.   ascending or descending order. So you should pass two operation flags to\n.   get desired behaviour. If you want to sort matrix rows or columns\n.   lexicographically, you can use STL std::sort generic function with the\n.   proper comparison predicate.\n.   \n.   @param src input single-channel array.\n.   @param dst output array of the same size and type as src.\n.   @param flags operation flags, a combination of #SortFlags\n.   @sa sortIdx, randShuffle"},
    {"sortIdx", CV_PY_FN_WITH_KW_(pyopencv_cv_sortIdx, 0), "sortIdx(src, flags[, dst]) -> dst\n.   @brief Sorts each row or each column of a matrix.\n.   \n.   The function cv::sortIdx sorts each matrix row or each matrix column in the\n.   ascending or descending order. So you should pass two operation flags to\n.   get desired behaviour. Instead of reordering the elements themselves, it\n.   stores the indices of sorted elements in the output array. For example:\n.   @code\n.       Mat A = Mat::eye(3,3,CV_32F), B;\n.       sortIdx(A, B, SORT_EVERY_ROW + SORT_ASCENDING);\n.       // B will probably contain\n.       // (because of equal elements in A some permutations are possible):\n.       // [[1, 2, 0], [0, 2, 1], [0, 1, 2]]\n.   @endcode\n.   @param src input single-channel array.\n.   @param dst output integer array of the same size as src.\n.   @param flags operation flags that could be a combination of cv::SortFlags\n.   @sa sort, randShuffle"},
    {"spatialGradient", CV_PY_FN_WITH_KW_(pyopencv_cv_spatialGradient, 0), "spatialGradient(src[, dx[, dy[, ksize[, borderType]]]]) -> dx, dy\n.   @brief Calculates the first order image derivative in both x and y using a Sobel operator\n.   \n.   Equivalent to calling:\n.   \n.   @code\n.   Sobel( src, dx, CV_16SC1, 1, 0, 3 );\n.   Sobel( src, dy, CV_16SC1, 0, 1, 3 );\n.   @endcode\n.   \n.   @param src input image.\n.   @param dx output image with first-order derivative in x.\n.   @param dy output image with first-order derivative in y.\n.   @param ksize size of Sobel kernel. It must be 3.\n.   @param borderType pixel extrapolation method, see #BorderTypes.\n.                     Only #BORDER_DEFAULT=#BORDER_REFLECT_101 and #BORDER_REPLICATE are supported.\n.   \n.   @sa Sobel"},
    {"split", CV_PY_FN_WITH_KW_(pyopencv_cv_split, 0), "split(m[, mv]) -> mv\n.   @overload\n.   @param m input multi-channel array.\n.   @param mv output vector of arrays; the arrays themselves are reallocated, if needed."},
    {"sqrBoxFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_sqrBoxFilter, 0), "sqrBoxFilter(src, ddepth, ksize[, dst[, anchor[, normalize[, borderType]]]]) -> dst\n.   @brief Calculates the normalized sum of squares of the pixel values overlapping the filter.\n.   \n.   For every pixel \\f$ (x, y) \\f$ in the source image, the function calculates the sum of squares of those neighboring\n.   pixel values which overlap the filter placed over the pixel \\f$ (x, y) \\f$.\n.   \n.   The unnormalized square box filter can be useful in computing local image statistics such as the local\n.   variance and standard deviation around the neighborhood of a pixel.\n.   \n.   @param src input image\n.   @param dst output image of the same size and type as src\n.   @param ddepth the output image depth (-1 to use src.depth())\n.   @param ksize kernel size\n.   @param anchor kernel anchor point. The default value of Point(-1, -1) denotes that the anchor is at the kernel\n.   center.\n.   @param normalize flag, specifying whether the kernel is to be normalized by it's area or not.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @sa boxFilter"},
    {"sqrt", CV_PY_FN_WITH_KW_(pyopencv_cv_sqrt, 0), "sqrt(src[, dst]) -> dst\n.   @brief Calculates a square root of array elements.\n.   \n.   The function cv::sqrt calculates a square root of each input array element.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. The accuracy is approximately the same as of the built-in\n.   std::sqrt .\n.   @param src input floating-point array.\n.   @param dst output array of the same size and type as src."},
    {"stackBlur", CV_PY_FN_WITH_KW_(pyopencv_cv_stackBlur, 0), "stackBlur(src, ksize[, dst]) -> dst\n.   @brief Blurs an image using the stackBlur.\n.   \n.   The function applies and stackBlur to an image.\n.   stackBlur can generate similar results as Gaussian blur, and the time consumption does not increase with the increase of kernel size.\n.   It creates a kind of moving stack of colors whilst scanning through the image. Thereby it just has to add one new block of color to the right side\n.   of the stack and remove the leftmost color. The remaining colors on the topmost layer of the stack are either added on or reduced by one,\n.   depending on if they are on the right or on the left side of the stack. The only supported borderType is BORDER_REPLICATE.\n.   Original paper was proposed by Mario Klingemann, which can be found https://underdestruction.com/2004/02/25/stackblur-2004.\n.   \n.   @param src input image. The number of channels can be arbitrary, but the depth should be one of\n.   CV_8U, CV_16U, CV_16S or CV_32F.\n.   @param dst output image of the same size and type as src.\n.   @param ksize stack-blurring kernel size. The ksize.width and ksize.height can differ but they both must be\n.   positive and odd."},
    {"startWindowThread", CV_PY_FN_WITH_KW_(pyopencv_cv_startWindowThread, 0), "startWindowThread() -> retval\n."},
    {"stereoCalibrate", CV_PY_FN_WITH_KW_(pyopencv_cv_stereoCalibrate, 0), "stereoCalibrate(objectPoints, imagePoints1, imagePoints2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize[, R[, T[, E[, F[, flags[, criteria]]]]]]) -> retval, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, R, T, E, F\n.   \n\n\n\nstereoCalibrate(objectPoints, imagePoints1, imagePoints2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize, R, T[, E[, F[, perViewErrors[, flags[, criteria]]]]]) -> retval, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, R, T, E, F, perViewErrors\n."},
    {"stereoCalibrateExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_stereoCalibrateExtended, 0), "stereoCalibrateExtended(objectPoints, imagePoints1, imagePoints2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize, R, T[, E[, F[, rvecs[, tvecs[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, R, T, E, F, rvecs, tvecs, perViewErrors\n.   @brief Calibrates a stereo camera set up. This function finds the intrinsic parameters\n.   for each of the two cameras and the extrinsic parameters between the two cameras.\n.   \n.   @param objectPoints Vector of vectors of the calibration pattern points. The same structure as\n.   in @ref calibrateCamera. For each pattern view, both cameras need to see the same object\n.   points. Therefore, objectPoints.size(), imagePoints1.size(), and imagePoints2.size() need to be\n.   equal as well as objectPoints[i].size(), imagePoints1[i].size(), and imagePoints2[i].size() need to\n.   be equal for each i.\n.   @param imagePoints1 Vector of vectors of the projections of the calibration pattern points,\n.   observed by the first camera. The same structure as in @ref calibrateCamera.\n.   @param imagePoints2 Vector of vectors of the projections of the calibration pattern points,\n.   observed by the second camera. The same structure as in @ref calibrateCamera.\n.   @param cameraMatrix1 Input/output camera intrinsic matrix for the first camera, the same as in\n.   @ref calibrateCamera. Furthermore, for the stereo case, additional flags may be used, see below.\n.   @param distCoeffs1 Input/output vector of distortion coefficients, the same as in\n.   @ref calibrateCamera.\n.   @param cameraMatrix2 Input/output second camera intrinsic matrix for the second camera. See description for\n.   cameraMatrix1.\n.   @param distCoeffs2 Input/output lens distortion coefficients for the second camera. See\n.   description for distCoeffs1.\n.   @param imageSize Size of the image used only to initialize the camera intrinsic matrices.\n.   @param R Output rotation matrix. Together with the translation vector T, this matrix brings\n.   points given in the first camera's coordinate system to points in the second camera's\n.   coordinate system. In more technical terms, the tuple of R and T performs a change of basis\n.   from the first camera's coordinate system to the second camera's coordinate system. Due to its\n.   duality, this tuple is equivalent to the position of the first camera with respect to the\n.   second camera coordinate system.\n.   @param T Output translation vector, see description above.\n.   @param E Output essential matrix.\n.   @param F Output fundamental matrix.\n.   @param rvecs Output vector of rotation vectors ( @ref Rodrigues ) estimated for each pattern view in the\n.   coordinate system of the first camera of the stereo pair (e.g. std::vector<cv::Mat>). More in detail, each\n.   i-th rotation vector together with the corresponding i-th translation vector (see the next output parameter\n.   description) brings the calibration pattern from the object coordinate space (in which object points are\n.   specified) to the camera coordinate space of the first camera of the stereo pair. In more technical terms,\n.   the tuple of the i-th rotation and translation vector performs a change of basis from object coordinate space\n.   to camera coordinate space of the first camera of the stereo pair.\n.   @param tvecs Output vector of translation vectors estimated for each pattern view, see parameter description\n.   of previous output parameter ( rvecs ).\n.   @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.\n.   @param flags Different flags that may be zero or a combination of the following values:\n.   -   @ref CALIB_FIX_INTRINSIC Fix cameraMatrix? and distCoeffs? so that only R, T, E, and F\n.   matrices are estimated.\n.   -   @ref CALIB_USE_INTRINSIC_GUESS Optimize some or all of the intrinsic parameters\n.   according to the specified flags. Initial values are provided by the user.\n.   -   @ref CALIB_USE_EXTRINSIC_GUESS R and T contain valid initial values that are optimized further.\n.   Otherwise R and T are initialized to the median value of the pattern views (each dimension separately).\n.   -   @ref CALIB_FIX_PRINCIPAL_POINT Fix the principal points during the optimization.\n.   -   @ref CALIB_FIX_FOCAL_LENGTH Fix \\f$f^{(j)}_x\\f$ and \\f$f^{(j)}_y\\f$ .\n.   -   @ref CALIB_FIX_ASPECT_RATIO Optimize \\f$f^{(j)}_y\\f$ . Fix the ratio \\f$f^{(j)}_x/f^{(j)}_y\\f$\n.   .\n.   -   @ref CALIB_SAME_FOCAL_LENGTH Enforce \\f$f^{(0)}_x=f^{(1)}_x\\f$ and \\f$f^{(0)}_y=f^{(1)}_y\\f$ .\n.   -   @ref CALIB_ZERO_TANGENT_DIST Set tangential distortion coefficients for each camera to\n.   zeros and fix there.\n.   -   @ref CALIB_FIX_K1,..., @ref CALIB_FIX_K6 Do not change the corresponding radial\n.   distortion coefficient during the optimization. If @ref CALIB_USE_INTRINSIC_GUESS is set,\n.   the coefficient from the supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   @ref CALIB_RATIONAL_MODEL Enable coefficients k4, k5, and k6. To provide the backward\n.   compatibility, this extra flag should be explicitly specified to make the calibration\n.   function use the rational model and return 8 coefficients. If the flag is not set, the\n.   function computes and returns only 5 distortion coefficients.\n.   -   @ref CALIB_THIN_PRISM_MODEL Coefficients s1, s2, s3 and s4 are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the thin prism model and return 12 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   @ref CALIB_FIX_S1_S2_S3_S4 The thin prism distortion coefficients are not changed during\n.   the optimization. If @ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   @ref CALIB_TILTED_MODEL Coefficients tauX and tauY are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the tilted sensor model and return 14 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   @ref CALIB_FIX_TAUX_TAUY The coefficients of the tilted sensor model are not changed during\n.   the optimization. If @ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   @param criteria Termination criteria for the iterative optimization algorithm.\n.   \n.   The function estimates the transformation between two cameras making a stereo pair. If one computes\n.   the poses of an object relative to the first camera and to the second camera,\n.   ( \\f$R_1\\f$,\\f$T_1\\f$ ) and (\\f$R_2\\f$,\\f$T_2\\f$), respectively, for a stereo camera where the\n.   relative position and orientation between the two cameras are fixed, then those poses definitely\n.   relate to each other. This means, if the relative position and orientation (\\f$R\\f$,\\f$T\\f$) of the\n.   two cameras is known, it is possible to compute (\\f$R_2\\f$,\\f$T_2\\f$) when (\\f$R_1\\f$,\\f$T_1\\f$) is\n.   given. This is what the described function does. It computes (\\f$R\\f$,\\f$T\\f$) such that:\n.   \n.   \\f[R_2=R R_1\\f]\n.   \\f[T_2=R T_1 + T.\\f]\n.   \n.   Therefore, one can compute the coordinate representation of a 3D point for the second camera's\n.   coordinate system when given the point's coordinate representation in the first camera's coordinate\n.   system:\n.   \n.   \\f[\\begin{bmatrix}\n.   X_2 \\\\\n.   Y_2 \\\\\n.   Z_2 \\\\\n.   1\n.   \\end{bmatrix} = \\begin{bmatrix}\n.   R & T \\\\\n.   0 & 1\n.   \\end{bmatrix} \\begin{bmatrix}\n.   X_1 \\\\\n.   Y_1 \\\\\n.   Z_1 \\\\\n.   1\n.   \\end{bmatrix}.\\f]\n.   \n.   \n.   Optionally, it computes the essential matrix E:\n.   \n.   \\f[E= \\vecthreethree{0}{-T_2}{T_1}{T_2}{0}{-T_0}{-T_1}{T_0}{0} R\\f]\n.   \n.   where \\f$T_i\\f$ are components of the translation vector \\f$T\\f$ : \\f$T=[T_0, T_1, T_2]^T\\f$ .\n.   And the function can also compute the fundamental matrix F:\n.   \n.   \\f[F = cameraMatrix2^{-T}\\cdot E \\cdot cameraMatrix1^{-1}\\f]\n.   \n.   Besides the stereo-related information, the function can also perform a full calibration of each of\n.   the two cameras. However, due to the high dimensionality of the parameter space and noise in the\n.   input data, the function can diverge from the correct solution. If the intrinsic parameters can be\n.   estimated with high accuracy for each of the cameras individually (for example, using\n.   #calibrateCamera ), you are recommended to do so and then pass @ref CALIB_FIX_INTRINSIC flag to the\n.   function along with the computed intrinsic parameters. Otherwise, if all the parameters are\n.   estimated at once, it makes sense to restrict some parameters, for example, pass\n.    @ref CALIB_SAME_FOCAL_LENGTH and @ref CALIB_ZERO_TANGENT_DIST flags, which is usually a\n.   reasonable assumption.\n.   \n.   Similarly to #calibrateCamera, the function minimizes the total re-projection error for all the\n.   points in all the available views from both cameras. The function returns the final value of the\n.   re-projection error."},
    {"stereoRectify", CV_PY_FN_WITH_KW_(pyopencv_cv_stereoRectify, 0), "stereoRectify(cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize, R, T[, R1[, R2[, P1[, P2[, Q[, flags[, alpha[, newImageSize]]]]]]]]) -> R1, R2, P1, P2, Q, validPixROI1, validPixROI2\n.   @brief Computes rectification transforms for each head of a calibrated stereo camera.\n.   \n.   @param cameraMatrix1 First camera intrinsic matrix.\n.   @param distCoeffs1 First camera distortion parameters.\n.   @param cameraMatrix2 Second camera intrinsic matrix.\n.   @param distCoeffs2 Second camera distortion parameters.\n.   @param imageSize Size of the image used for stereo calibration.\n.   @param R Rotation matrix from the coordinate system of the first camera to the second camera,\n.   see @ref stereoCalibrate.\n.   @param T Translation vector from the coordinate system of the first camera to the second camera,\n.   see @ref stereoCalibrate.\n.   @param R1 Output 3x3 rectification transform (rotation matrix) for the first camera. This matrix\n.   brings points given in the unrectified first camera's coordinate system to points in the rectified\n.   first camera's coordinate system. In more technical terms, it performs a change of basis from the\n.   unrectified first camera's coordinate system to the rectified first camera's coordinate system.\n.   @param R2 Output 3x3 rectification transform (rotation matrix) for the second camera. This matrix\n.   brings points given in the unrectified second camera's coordinate system to points in the rectified\n.   second camera's coordinate system. In more technical terms, it performs a change of basis from the\n.   unrectified second camera's coordinate system to the rectified second camera's coordinate system.\n.   @param P1 Output 3x4 projection matrix in the new (rectified) coordinate systems for the first\n.   camera, i.e. it projects points given in the rectified first camera coordinate system into the\n.   rectified first camera's image.\n.   @param P2 Output 3x4 projection matrix in the new (rectified) coordinate systems for the second\n.   camera, i.e. it projects points given in the rectified first camera coordinate system into the\n.   rectified second camera's image.\n.   @param Q Output \\f$4 \\times 4\\f$ disparity-to-depth mapping matrix (see @ref reprojectImageTo3D).\n.   @param flags Operation flags that may be zero or @ref CALIB_ZERO_DISPARITY . If the flag is set,\n.   the function makes the principal points of each camera have the same pixel coordinates in the\n.   rectified views. And if the flag is not set, the function may still shift the images in the\n.   horizontal or vertical direction (depending on the orientation of epipolar lines) to maximize the\n.   useful image area.\n.   @param alpha Free scaling parameter. If it is -1 or absent, the function performs the default\n.   scaling. Otherwise, the parameter should be between 0 and 1. alpha=0 means that the rectified\n.   images are zoomed and shifted so that only valid pixels are visible (no black areas after\n.   rectification). alpha=1 means that the rectified image is decimated and shifted so that all the\n.   pixels from the original images from the cameras are retained in the rectified images (no source\n.   image pixels are lost). Any intermediate value yields an intermediate result between\n.   those two extreme cases.\n.   @param newImageSize New image resolution after rectification. The same size should be passed to\n.   #initUndistortRectifyMap (see the stereo_calib.cpp sample in OpenCV samples directory). When (0,0)\n.   is passed (default), it is set to the original imageSize . Setting it to a larger value can help you\n.   preserve details in the original image, especially when there is a big radial distortion.\n.   @param validPixROI1 Optional output rectangles inside the rectified images where all the pixels\n.   are valid. If alpha=0 , the ROIs cover the whole images. Otherwise, they are likely to be smaller\n.   (see the picture below).\n.   @param validPixROI2 Optional output rectangles inside the rectified images where all the pixels\n.   are valid. If alpha=0 , the ROIs cover the whole images. Otherwise, they are likely to be smaller\n.   (see the picture below).\n.   \n.   The function computes the rotation matrices for each camera that (virtually) make both camera image\n.   planes the same plane. Consequently, this makes all the epipolar lines parallel and thus simplifies\n.   the dense stereo correspondence problem. The function takes the matrices computed by #stereoCalibrate\n.   as input. As output, it provides two rotation matrices and also two projection matrices in the new\n.   coordinates. The function distinguishes the following two cases:\n.   \n.   -   **Horizontal stereo**: the first and the second camera views are shifted relative to each other\n.       mainly along the x-axis (with possible small vertical shift). In the rectified images, the\n.       corresponding epipolar lines in the left and right cameras are horizontal and have the same\n.       y-coordinate. P1 and P2 look like:\n.   \n.       \\f[\\texttt{P1} = \\begin{bmatrix}\n.                           f & 0 & cx_1 & 0 \\\\\n.                           0 & f & cy & 0 \\\\\n.                           0 & 0 & 1 & 0\n.                        \\end{bmatrix}\\f]\n.   \n.       \\f[\\texttt{P2} = \\begin{bmatrix}\n.                           f & 0 & cx_2 & T_x \\cdot f \\\\\n.                           0 & f & cy & 0 \\\\\n.                           0 & 0 & 1 & 0\n.                        \\end{bmatrix} ,\\f]\n.   \n.       \\f[\\texttt{Q} = \\begin{bmatrix}\n.                           1 & 0 & 0 & -cx_1 \\\\\n.                           0 & 1 & 0 & -cy \\\\\n.                           0 & 0 & 0 & f \\\\\n.                           0 & 0 & -\\frac{1}{T_x} & \\frac{cx_1 - cx_2}{T_x}\n.                       \\end{bmatrix} \\f]\n.   \n.       where \\f$T_x\\f$ is a horizontal shift between the cameras and \\f$cx_1=cx_2\\f$ if\n.       @ref CALIB_ZERO_DISPARITY is set.\n.   \n.   -   **Vertical stereo**: the first and the second camera views are shifted relative to each other\n.       mainly in the vertical direction (and probably a bit in the horizontal direction too). The epipolar\n.       lines in the rectified images are vertical and have the same x-coordinate. P1 and P2 look like:\n.   \n.       \\f[\\texttt{P1} = \\begin{bmatrix}\n.                           f & 0 & cx & 0 \\\\\n.                           0 & f & cy_1 & 0 \\\\\n.                           0 & 0 & 1 & 0\n.                        \\end{bmatrix}\\f]\n.   \n.       \\f[\\texttt{P2} = \\begin{bmatrix}\n.                           f & 0 & cx & 0 \\\\\n.                           0 & f & cy_2 & T_y \\cdot f \\\\\n.                           0 & 0 & 1 & 0\n.                        \\end{bmatrix},\\f]\n.   \n.       \\f[\\texttt{Q} = \\begin{bmatrix}\n.                           1 & 0 & 0 & -cx \\\\\n.                           0 & 1 & 0 & -cy_1 \\\\\n.                           0 & 0 & 0 & f \\\\\n.                           0 & 0 & -\\frac{1}{T_y} & \\frac{cy_1 - cy_2}{T_y}\n.                       \\end{bmatrix} \\f]\n.   \n.       where \\f$T_y\\f$ is a vertical shift between the cameras and \\f$cy_1=cy_2\\f$ if\n.       @ref CALIB_ZERO_DISPARITY is set.\n.   \n.   As you can see, the first three columns of P1 and P2 will effectively be the new \"rectified\" camera\n.   matrices. The matrices, together with R1 and R2 , can then be passed to #initUndistortRectifyMap to\n.   initialize the rectification map for each camera.\n.   \n.   See below the screenshot from the stereo_calib.cpp sample. Some red horizontal lines pass through\n.   the corresponding image regions. This means that the images are well rectified, which is what most\n.   stereo correspondence algorithms rely on. The green rectangles are roi1 and roi2 . You see that\n.   their interiors are all valid pixels.\n.   \n.   ![image](pics/stereo_undistort.jpg)"},
    {"stereoRectifyUncalibrated", CV_PY_FN_WITH_KW_(pyopencv_cv_stereoRectifyUncalibrated, 0), "stereoRectifyUncalibrated(points1, points2, F, imgSize[, H1[, H2[, threshold]]]) -> retval, H1, H2\n.   @brief Computes a rectification transform for an uncalibrated stereo camera.\n.   \n.   @param points1 Array of feature points in the first image.\n.   @param points2 The corresponding points in the second image. The same formats as in\n.   #findFundamentalMat are supported.\n.   @param F Input fundamental matrix. It can be computed from the same set of point pairs using\n.   #findFundamentalMat .\n.   @param imgSize Size of the image.\n.   @param H1 Output rectification homography matrix for the first image.\n.   @param H2 Output rectification homography matrix for the second image.\n.   @param threshold Optional threshold used to filter out the outliers. If the parameter is greater\n.   than zero, all the point pairs that do not comply with the epipolar geometry (that is, the points\n.   for which \\f$|\\texttt{points2[i]}^T \\cdot \\texttt{F} \\cdot \\texttt{points1[i]}|>\\texttt{threshold}\\f$ )\n.   are rejected prior to computing the homographies. Otherwise, all the points are considered inliers.\n.   \n.   The function computes the rectification transformations without knowing intrinsic parameters of the\n.   cameras and their relative position in the space, which explains the suffix \"uncalibrated\". Another\n.   related difference from #stereoRectify is that the function outputs not the rectification\n.   transformations in the object (3D) space, but the planar perspective transformations encoded by the\n.   homography matrices H1 and H2 . The function implements the algorithm @cite Hartley99 .\n.   \n.   @note\n.      While the algorithm does not need to know the intrinsic parameters of the cameras, it heavily\n.       depends on the epipolar geometry. Therefore, if the camera lenses have a significant distortion,\n.       it would be better to correct it before computing the fundamental matrix and calling this\n.       function. For example, distortion coefficients can be estimated for each head of stereo camera\n.       separately by using #calibrateCamera . Then, the images can be corrected using #undistort , or\n.       just the point coordinates can be corrected with #undistortPoints ."},
    {"stylization", CV_PY_FN_WITH_KW_(pyopencv_cv_stylization, 0), "stylization(src[, dst[, sigma_s[, sigma_r]]]) -> dst\n.   @brief Stylization aims to produce digital imagery with a wide variety of effects not focused on\n.   photorealism. Edge-aware filters are ideal for stylization, as they can abstract regions of low\n.   contrast while preserving, or enhancing, high-contrast features.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param sigma_s %Range between 0 to 200.\n.   @param sigma_r %Range between 0 to 1."},
    {"subtract", CV_PY_FN_WITH_KW_(pyopencv_cv_subtract, 0), "subtract(src1, src2[, dst[, mask[, dtype]]]) -> dst\n.   @brief Calculates the per-element difference between two arrays or array and a scalar.\n.   \n.   The function subtract calculates:\n.   - Difference between two arrays, when both input arrays have the same size and the same number of\n.   channels:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) -  \\texttt{src2}(I)) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Difference between an array and a scalar, when src2 is constructed from Scalar or has the same\n.   number of elements as `src1.channels()`:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) -  \\texttt{src2} ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Difference between a scalar and an array, when src1 is constructed from Scalar or has the same\n.   number of elements as `src2.channels()`:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1} -  \\texttt{src2}(I) ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - The reverse difference between a scalar and an array in the case of `SubRS`:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src2} -  \\texttt{src1}(I) ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each\n.   channel is processed independently.\n.   \n.   The first function in the list above can be replaced with matrix expressions:\n.   @code{.cpp}\n.       dst = src1 - src2;\n.       dst -= src1; // equivalent to subtract(dst, src1, dst);\n.   @endcode\n.   The input arrays and the output array can all have the same or different depths. For example, you\n.   can subtract to 8-bit unsigned arrays and store the difference in a 16-bit signed array. Depth of\n.   the output array is determined by dtype parameter. In the second and third cases above, as well as\n.   in the first case, when src1.depth() == src2.depth(), dtype can be set to the default -1. In this\n.   case the output array will have the same depth as the input array, be it src1, src2 or both.\n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.\n.   `subtract(src,X)` means `subtract(src,(X,X,X,X))`.\n.   `subtract(src,(X,))` means `subtract(src,(X,0,0,0))`.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array of the same size and the same number of channels as the input array.\n.   @param mask optional operation mask; this is an 8-bit single channel array that specifies elements\n.   of the output array to be changed.\n.   @param dtype optional depth of the output array\n.   @sa  add, addWeighted, scaleAdd, Mat::convertTo"},
    {"sumElems", CV_PY_FN_WITH_KW_(pyopencv_cv_sumElems, 0), "sumElems(src) -> retval\n.   @brief Calculates the sum of array elements.\n.   \n.   The function cv::sum calculates and returns the sum of array elements,\n.   independently for each channel.\n.   @param src input array that must have from 1 to 4 channels.\n.   @sa  countNonZero, mean, meanStdDev, norm, minMaxLoc, reduce"},
    {"textureFlattening", CV_PY_FN_WITH_KW_(pyopencv_cv_textureFlattening, 0), "textureFlattening(src, mask[, dst[, low_threshold[, high_threshold[, kernel_size]]]]) -> dst\n.   @brief By retaining only the gradients at edge locations, before integrating with the Poisson solver, one\n.   washes out the texture of the selected region, giving its contents a flat aspect. Here Canny Edge %Detector is used.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param low_threshold %Range from 0 to 100.\n.   @param high_threshold Value \\> 100.\n.   @param kernel_size The size of the Sobel kernel to be used.\n.   \n.   @note\n.   The algorithm assumes that the color of the source image is close to that of the destination. This\n.   assumption means that when the colors don't match, the source image color gets tinted toward the\n.   color of the destination image."},
    {"threshold", CV_PY_FN_WITH_KW_(pyopencv_cv_threshold, 0), "threshold(src, thresh, maxval, type[, dst]) -> retval, dst\n.   @brief Applies a fixed-level threshold to each array element.\n.   \n.   The function applies fixed-level thresholding to a multiple-channel array. The function is typically\n.   used to get a bi-level (binary) image out of a grayscale image ( #compare could be also used for\n.   this purpose) or for removing a noise, that is, filtering out pixels with too small or too large\n.   values. There are several types of thresholding supported by the function. They are determined by\n.   type parameter.\n.   \n.   Also, the special values #THRESH_OTSU or #THRESH_TRIANGLE may be combined with one of the\n.   above values. In these cases, the function determines the optimal threshold value using the Otsu's\n.   or Triangle algorithm and uses it instead of the specified thresh.\n.   \n.   @note Currently, the Otsu's method is implemented only for CV_8UC1 and CV_16UC1 images,\n.   and the Triangle's method is implemented only for CV_8UC1 images.\n.   \n.   @param src input array (multiple-channel, CV_8U, CV_16S, CV_16U, CV_32F or CV_64F).\n.   @param dst output array of the same size  and type and the same number of channels as src.\n.   @param thresh threshold value.\n.   @param maxval maximum value to use with the #THRESH_BINARY and #THRESH_BINARY_INV thresholding\n.   types.\n.   @param type thresholding type (see #ThresholdTypes).\n.   @return the computed threshold value if Otsu's or Triangle methods used.\n.   \n.   @sa  thresholdWithMask, adaptiveThreshold, findContours, compare, min, max"},
    {"thresholdWithMask", CV_PY_FN_WITH_KW_(pyopencv_cv_thresholdWithMask, 0), "thresholdWithMask(src, dst, mask, thresh, maxval, type) -> retval, dst\n.   @brief Same as #threshold, but with an optional mask\n.   \n.   @note If the mask is empty, #thresholdWithMask is equivalent to #threshold.\n.   If the mask is not empty, dst *must* be of the same size and type as src, so that\n.   outliers pixels are left as-is\n.   \n.   @param src input array (multiple-channel, 8-bit or 32-bit floating point).\n.   @param dst output array of the same size  and type and the same number of channels as src.\n.   @param mask optional mask (same size as src, 8-bit).\n.   @param thresh threshold value.\n.   @param maxval maximum value to use with the #THRESH_BINARY and #THRESH_BINARY_INV thresholding\n.   types.\n.   @param type thresholding type (see #ThresholdTypes).\n.   @return the computed threshold value if Otsu's or Triangle methods used.\n.   \n.   @sa  threshold, adaptiveThreshold, findContours, compare, min, max"},
    {"trace", CV_PY_FN_WITH_KW_(pyopencv_cv_trace, 0), "trace(mtx) -> retval\n.   @brief Returns the trace of a matrix.\n.   \n.   The function cv::trace returns the sum of the diagonal elements of the\n.   matrix mtx .\n.   \\f[\\mathrm{tr} ( \\texttt{mtx} ) =  \\sum _i  \\texttt{mtx} (i,i)\\f]\n.   @param mtx input matrix."},
    {"transform", CV_PY_FN_WITH_KW_(pyopencv_cv_transform, 0), "transform(src, m[, dst]) -> dst\n.   @brief Performs the matrix transformation of every array element.\n.   \n.   The function cv::transform performs the matrix transformation of every\n.   element of the array src and stores the results in dst :\n.   \\f[\\texttt{dst} (I) =  \\texttt{m} \\cdot \\texttt{src} (I)\\f]\n.   (when m.cols=src.channels() ), or\n.   \\f[\\texttt{dst} (I) =  \\texttt{m} \\cdot [ \\texttt{src} (I); 1]\\f]\n.   (when m.cols=src.channels()+1 )\n.   \n.   Every element of the N -channel array src is interpreted as N -element\n.   vector that is transformed using the M x N or M x (N+1) matrix m to\n.   M-element vector - the corresponding element of the output array dst .\n.   \n.   The function may be used for geometrical transformation of\n.   N -dimensional points, arbitrary linear color space transformation (such\n.   as various kinds of RGB to YUV transforms), shuffling the image\n.   channels, and so forth.\n.   @param src input array that must have as many channels (1 to 4) as\n.   m.cols or m.cols-1.\n.   @param dst output array of the same size and depth as src; it has as\n.   many channels as m.rows.\n.   @param m transformation 2x2 or 2x3 floating-point matrix.\n.   @sa perspectiveTransform, getAffineTransform, estimateAffine2D, warpAffine, warpPerspective"},
    {"transpose", CV_PY_FN_WITH_KW_(pyopencv_cv_transpose, 0), "transpose(src[, dst]) -> dst\n.   @brief Transposes a matrix.\n.   \n.   The function cv::transpose transposes the matrix src :\n.   \\f[\\texttt{dst} (i,j) =  \\texttt{src} (j,i)\\f]\n.   @note No complex conjugation is done in case of a complex matrix. It\n.   should be done separately if needed.\n.   @param src input array.\n.   @param dst output array of the same type as src."},
    {"transposeND", CV_PY_FN_WITH_KW_(pyopencv_cv_transposeND, 0), "transposeND(src, order[, dst]) -> dst\n.   @brief Transpose for n-dimensional matrices.\n.    *\n.    * @note Input should be continuous single-channel matrix.\n.    * @param src input array.\n.    * @param order a permutation of [0,1,..,N-1] where N is the number of axes of src.\n.    * The i'th axis of dst will correspond to the axis numbered order[i] of the input.\n.    * @param dst output array of the same type as src."},
    {"triangulatePoints", CV_PY_FN_WITH_KW_(pyopencv_cv_triangulatePoints, 0), "triangulatePoints(projMatr1, projMatr2, projPoints1, projPoints2[, points4D]) -> points4D\n.   @brief This function reconstructs 3-dimensional points (in homogeneous coordinates) by using\n.   their observations with a stereo camera.\n.   \n.   @param projMatr1 3x4 projection matrix of the first camera, i.e. this matrix projects 3D points\n.   given in the world's coordinate system into the first image.\n.   @param projMatr2 3x4 projection matrix of the second camera, i.e. this matrix projects 3D points\n.   given in the world's coordinate system into the second image.\n.   @param projPoints1 2xN array of feature points in the first image. In the case of the c++ version,\n.   it can be also a vector of feature points or two-channel matrix of size 1xN or Nx1.\n.   @param projPoints2 2xN array of corresponding points in the second image. In the case of the c++\n.   version, it can be also a vector of feature points or two-channel matrix of size 1xN or Nx1.\n.   @param points4D 4xN array of reconstructed points in homogeneous coordinates. These points are\n.   returned in the world's coordinate system.\n.   \n.   @note\n.      Keep in mind that all input data should be of float type in order for this function to work.\n.   \n.   @note\n.      If the projection matrices from @ref stereoRectify are used, then the returned points are\n.      represented in the first camera's rectified coordinate system.\n.   \n.   @sa\n.      reprojectImageTo3D"},
    {"undistort", CV_PY_FN_WITH_KW_(pyopencv_cv_undistort, 0), "undistort(src, cameraMatrix, distCoeffs[, dst[, newCameraMatrix]]) -> dst\n.   @brief Transforms an image to compensate for lens distortion.\n.   \n.   The function transforms an image to compensate radial and tangential lens distortion.\n.   \n.   The function is simply a combination of #initUndistortRectifyMap (with unity R ) and #remap\n.   (with bilinear interpolation). See the former function for details of the transformation being\n.   performed.\n.   \n.   Those pixels in the destination image, for which there is no correspondent pixels in the source\n.   image, are filled with zeros (black color).\n.   \n.   A particular subset of the source image that will be visible in the corrected image can be regulated\n.   by newCameraMatrix. You can use #getOptimalNewCameraMatrix to compute the appropriate\n.   newCameraMatrix depending on your requirements.\n.   \n.   The camera matrix and the distortion parameters can be determined using #calibrateCamera. If\n.   the resolution of images is different from the resolution used at the calibration stage, \\f$f_x,\n.   f_y, c_x\\f$ and \\f$c_y\\f$ need to be scaled accordingly, while the distortion coefficients remain\n.   the same.\n.   \n.   @param src Input (distorted) image.\n.   @param dst Output (corrected) image that has the same size and type as src .\n.   @param cameraMatrix Input camera matrix \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param newCameraMatrix Camera matrix of the distorted image. By default, it is the same as\n.   cameraMatrix but you may additionally scale and shift the result by using a different matrix."},
    {"undistortImagePoints", CV_PY_FN_WITH_KW_(pyopencv_cv_undistortImagePoints, 0), "undistortImagePoints(src, cameraMatrix, distCoeffs[, dst[, arg1]]) -> dst\n.   * @brief Compute undistorted image points position\n.    *\n.    * @param src Observed points position, 2xN/Nx2 1-channel or 1xN/Nx1 2-channel (CV_32FC2 or\n.   CV_64FC2) (or vector\\<Point2f\\> ).\n.    * @param dst Output undistorted points position (1xN/Nx1 2-channel or vector\\<Point2f\\> ).\n.    * @param cameraMatrix Camera matrix \\f$\\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.    * @param distCoeffs Distortion coefficients"},
    {"undistortPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_undistortPoints, 0), "undistortPoints(src, cameraMatrix, distCoeffs[, dst[, R[, P]]]) -> dst\n.   @brief Computes the ideal point coordinates from the observed point coordinates.\n.   \n.   The function is similar to #undistort and #initUndistortRectifyMap but it operates on a\n.   sparse set of points instead of a raster image. Also the function performs a reverse transformation\n.   to  #projectPoints. In case of a 3D object, it does not reconstruct its 3D coordinates, but for a\n.   planar object, it does, up to a translation vector, if the proper R is specified.\n.   \n.   For each observed point coordinate \\f$(u, v)\\f$ the function computes:\n.   \\f[\n.   \\begin{array}{l}\n.   x^{\"}  \\leftarrow (u - c_x)/f_x  \\\\\n.   y^{\"}  \\leftarrow (v - c_y)/f_y  \\\\\n.   (x',y') = undistort(x^{\"},y^{\"}, \\texttt{distCoeffs}) \\\\\n.   {[X\\,Y\\,W]} ^T  \\leftarrow R*[x' \\, y' \\, 1]^T  \\\\\n.   x  \\leftarrow X/W  \\\\\n.   y  \\leftarrow Y/W  \\\\\n.   \\text{only performed if P is specified:} \\\\\n.   u'  \\leftarrow x {f'}_x + {c'}_x  \\\\\n.   v'  \\leftarrow y {f'}_y + {c'}_y\n.   \\end{array}\n.   \\f]\n.   \n.   where *undistort* is an approximate iterative algorithm that estimates the normalized original\n.   point coordinates out of the normalized distorted point coordinates (\"normalized\" means that the\n.   coordinates do not depend on the camera matrix).\n.   \n.   The function can be used for both a stereo camera head or a monocular camera (when R is empty).\n.   @param src Observed point coordinates, 2xN/Nx2 1-channel or 1xN/Nx1 2-channel (CV_32FC2 or CV_64FC2) (or\n.   vector\\<Point2f\\> ).\n.   @param dst Output ideal point coordinates (1xN/Nx1 2-channel or vector\\<Point2f\\> ) after undistortion and reverse perspective\n.   transformation. If matrix P is identity or omitted, dst will contain normalized point coordinates.\n.   @param cameraMatrix Camera matrix \\f$\\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param R Rectification transformation in the object space (3x3 matrix). R1 or R2 computed by\n.   #stereoRectify can be passed here. If the matrix is empty, the identity transformation is used.\n.   @param P New camera matrix (3x3) or new projection matrix (3x4) \\f$\\begin{bmatrix} {f'}_x & 0 & {c'}_x & t_x \\\\ 0 & {f'}_y & {c'}_y & t_y \\\\ 0 & 0 & 1 & t_z \\end{bmatrix}\\f$. P1 or P2 computed by\n.   #stereoRectify can be passed here. If the matrix is empty, the identity new camera matrix is used."},
    {"undistortPointsIter", CV_PY_FN_WITH_KW_(pyopencv_cv_undistortPointsIter, 0), "undistortPointsIter(src, cameraMatrix, distCoeffs, R, P, criteria[, dst]) -> dst\n.   @overload\n.       @note Default version of #undistortPoints does 5 iterations to compute undistorted points."},
    {"useOpenVX", CV_PY_FN_WITH_KW_(pyopencv_cv_useOpenVX, 0), "useOpenVX() -> retval\n."},
    {"useOptimized", CV_PY_FN_WITH_KW_(pyopencv_cv_useOptimized, 0), "useOptimized() -> retval\n.   @brief Returns the status of optimized code usage.\n.   \n.   The function returns true if the optimized code is enabled. Otherwise, it returns false."},
    {"validateDisparity", CV_PY_FN_WITH_KW_(pyopencv_cv_validateDisparity, 0), "validateDisparity(disparity, cost, minDisparity, numberOfDisparities[, disp12MaxDisp]) -> disparity\n."},
    {"vconcat", CV_PY_FN_WITH_KW_(pyopencv_cv_vconcat, 0), "vconcat(src[, dst]) -> dst\n.   @overload\n.    @code{.cpp}\n.       std::vector<cv::Mat> matrices = { cv::Mat(1, 4, CV_8UC1, cv::Scalar(1)),\n.                                         cv::Mat(1, 4, CV_8UC1, cv::Scalar(2)),\n.                                         cv::Mat(1, 4, CV_8UC1, cv::Scalar(3)),};\n.   \n.       cv::Mat out;\n.       cv::vconcat( matrices, out );\n.       //out:\n.       //[1,   1,   1,   1;\n.       // 2,   2,   2,   2;\n.       // 3,   3,   3,   3]\n.    @endcode\n.    @param src input array or vector of matrices. all of the matrices must have the same number of cols and the same depth\n.    @param dst output array. It has the same number of cols and depth as the src, and the sum of rows of the src.\n.   same depth."},
    {"waitKey", CV_PY_FN_WITH_KW_(pyopencv_cv_waitKey, 0), "waitKey([, delay]) -> retval\n.   @brief Waits for a pressed key.\n.   \n.   The function waitKey waits for a key event infinitely (when \\f$\\texttt{delay}\\leq 0\\f$ ) or for delay\n.   milliseconds, when it is positive. Since the OS has a minimum time between switching threads, the\n.   function will not wait exactly delay ms, it will wait at least delay ms, depending on what else is\n.   running on your computer at that time. It returns the code of the pressed key or -1 if no key was\n.   pressed before the specified time had elapsed. To check for a key press but not wait for it, use\n.   #pollKey.\n.   \n.   @note The functions #waitKey and #pollKey are the only methods in HighGUI that can fetch and handle\n.   GUI events, so one of them needs to be called periodically for normal event processing unless\n.   HighGUI is used within an environment that takes care of event processing.\n.   \n.   @note The function only works if there is at least one HighGUI window created and the window is\n.   active. If there are several HighGUI windows, any of them can be active.\n.   \n.   @param delay Delay in milliseconds. 0 is the special value that means \"forever\"."},
    {"waitKeyEx", CV_PY_FN_WITH_KW_(pyopencv_cv_waitKeyEx, 0), "waitKeyEx([, delay]) -> retval\n.   @brief Similar to #waitKey, but returns full key code.\n.   \n.   @note Key code is implementation specific and depends on used backend: QT/GTK/Win32/etc"},
    {"warpAffine", CV_PY_FN_WITH_KW_(pyopencv_cv_warpAffine, 0), "warpAffine(src, M, dsize[, dst[, flags[, borderMode[, borderValue]]]]) -> dst\n.   @brief Applies an affine transformation to an image.\n.   \n.   The function warpAffine transforms the source image using the specified matrix:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} ( \\texttt{M} _{11} x +  \\texttt{M} _{12} y +  \\texttt{M} _{13}, \\texttt{M} _{21} x +  \\texttt{M} _{22} y +  \\texttt{M} _{23})\\f]\n.   \n.   when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted\n.   with #invertAffineTransform and then put in the formula above instead of M. The function cannot\n.   operate in-place.\n.   \n.   @param src input image.\n.   @param dst output image that has the size dsize and the same type as src .\n.   @param M \\f$2\\times 3\\f$ transformation matrix.\n.   @param dsize size of the output image.\n.   @param flags combination of interpolation methods (see #InterpolationFlags) and the optional\n.   flag #WARP_INVERSE_MAP that means that M is the inverse transformation (\n.   \\f$\\texttt{dst}\\rightarrow\\texttt{src}\\f$ ).\n.   @param borderMode pixel extrapolation method (see #BorderTypes); when\n.   borderMode=#BORDER_TRANSPARENT, it means that the pixels in the destination image corresponding to\n.   the \"outliers\" in the source image are not modified by the function.\n.   @param borderValue value used in case of a constant border; by default, it is 0.\n.   \n.   @sa  warpPerspective, resize, remap, getRectSubPix, transform"},
    {"warpPerspective", CV_PY_FN_WITH_KW_(pyopencv_cv_warpPerspective, 0), "warpPerspective(src, M, dsize[, dst[, flags[, borderMode[, borderValue]]]]) -> dst\n.   @brief Applies a perspective transformation to an image.\n.   \n.   The function warpPerspective transforms the source image using the specified matrix:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} \\left ( \\frac{M_{11} x + M_{12} y + M_{13}}{M_{31} x + M_{32} y + M_{33}} ,\n.        \\frac{M_{21} x + M_{22} y + M_{23}}{M_{31} x + M_{32} y + M_{33}} \\right )\\f]\n.   \n.   when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted with invert\n.   and then put in the formula above instead of M. The function cannot operate in-place.\n.   \n.   @param src input image.\n.   @param dst output image that has the size dsize and the same type as src .\n.   @param M \\f$3\\times 3\\f$ transformation matrix.\n.   @param dsize size of the output image.\n.   @param flags combination of interpolation methods (#INTER_LINEAR or #INTER_NEAREST) and the\n.   optional flag #WARP_INVERSE_MAP, that sets M as the inverse transformation (\n.   \\f$\\texttt{dst}\\rightarrow\\texttt{src}\\f$ ).\n.   @param borderMode pixel extrapolation method (#BORDER_CONSTANT or #BORDER_REPLICATE).\n.   @param borderValue value used in case of a constant border; by default, it equals 0.\n.   \n.   @sa  warpAffine, resize, remap, getRectSubPix, perspectiveTransform"},
    {"warpPolar", CV_PY_FN_WITH_KW_(pyopencv_cv_warpPolar, 0), "warpPolar(src, dsize, center, maxRadius, flags[, dst]) -> dst\n.   \\brief Remaps an image to polar or semilog-polar coordinates space\n.   \n.   @anchor polar_remaps_reference_image\n.   ![Polar remaps reference](pics/polar_remap_doc.png)\n.   \n.   Transform the source image using the following transformation:\n.   \\f[\n.   dst(\\rho , \\phi ) = src(x,y)\n.   \\f]\n.   \n.   where\n.   \\f[\n.   \\begin{array}{l}\n.   \\vec{I} = (x - center.x, \\;y - center.y) \\\\\n.   \\phi = Kangle \\cdot \\texttt{angle} (\\vec{I}) \\\\\n.   \\rho = \\left\\{\\begin{matrix}\n.   Klin \\cdot \\texttt{magnitude} (\\vec{I}) & default \\\\\n.   Klog \\cdot log_e(\\texttt{magnitude} (\\vec{I})) & if \\; semilog \\\\\n.   \\end{matrix}\\right.\n.   \\end{array}\n.   \\f]\n.   \n.   and\n.   \\f[\n.   \\begin{array}{l}\n.   Kangle = dsize.height / 2\\Pi \\\\\n.   Klin = dsize.width / maxRadius \\\\\n.   Klog = dsize.width / log_e(maxRadius) \\\\\n.   \\end{array}\n.   \\f]\n.   \n.   \n.   \\par Linear vs semilog mapping\n.   \n.   Polar mapping can be linear or semi-log. Add one of #WarpPolarMode to `flags` to specify the polar mapping mode.\n.   \n.   Linear is the default mode.\n.   \n.   The semilog mapping emulates the human \"foveal\" vision that permit very high acuity on the line of sight (central vision)\n.   in contrast to peripheral vision where acuity is minor.\n.   \n.   \\par Option on `dsize`:\n.   \n.   - if both values in `dsize <=0 ` (default),\n.   the destination image will have (almost) same area of source bounding circle:\n.   \\f[\\begin{array}{l}\n.   dsize.area  \\leftarrow (maxRadius^2 \\cdot \\Pi) \\\\\n.   dsize.width = \\texttt{cvRound}(maxRadius) \\\\\n.   dsize.height = \\texttt{cvRound}(maxRadius \\cdot \\Pi) \\\\\n.   \\end{array}\\f]\n.   \n.   \n.   - if only `dsize.height <= 0`,\n.   the destination image area will be proportional to the bounding circle area but scaled by `Kx * Kx`:\n.   \\f[\\begin{array}{l}\n.   dsize.height = \\texttt{cvRound}(dsize.width \\cdot \\Pi) \\\\\n.   \\end{array}\n.   \\f]\n.   \n.   - if both values in `dsize > 0 `,\n.   the destination image will have the given size therefore the area of the bounding circle will be scaled to `dsize`.\n.   \n.   \n.   \\par Reverse mapping\n.   \n.   You can get reverse mapping adding #WARP_INVERSE_MAP to `flags`\n.   \\snippet polar_transforms.cpp InverseMap\n.   \n.   In addiction, to calculate the original coordinate from a polar mapped coordinate \\f$(rho, phi)->(x, y)\\f$:\n.   \\snippet polar_transforms.cpp InverseCoordinate\n.   \n.   @param src Source image.\n.   @param dst Destination image. It will have same type as src.\n.   @param dsize The destination image size (see description for valid options).\n.   @param center The transformation center.\n.   @param maxRadius The radius of the bounding circle to transform. It determines the inverse magnitude scale parameter too.\n.   @param flags A combination of interpolation methods, #InterpolationFlags + #WarpPolarMode.\n.               - Add #WARP_POLAR_LINEAR to select linear polar mapping (default)\n.               - Add #WARP_POLAR_LOG to select semilog polar mapping\n.               - Add #WARP_INVERSE_MAP for reverse mapping.\n.   @note\n.   -  The function can not operate in-place.\n.   -  To calculate magnitude and angle in degrees #cartToPolar is used internally thus angles are measured from 0 to 360 with accuracy about 0.3 degrees.\n.   -  This function uses #remap. Due to current implementation limitations the size of an input and output images should be less than 32767x32767.\n.   \n.   @sa cv::remap"},
    {"watershed", CV_PY_FN_WITH_KW_(pyopencv_cv_watershed, 0), "watershed(image, markers) -> markers\n.   @brief Performs a marker-based image segmentation using the watershed algorithm.\n.   \n.   The function implements one of the variants of watershed, non-parametric marker-based segmentation\n.   algorithm, described in @cite Meyer92 .\n.   \n.   Before passing the image to the function, you have to roughly outline the desired regions in the\n.   image markers with positive (\\>0) indices. So, every region is represented as one or more connected\n.   components with the pixel values 1, 2, 3, and so on. Such markers can be retrieved from a binary\n.   mask using #findContours and #drawContours (see the watershed.cpp demo). The markers are \"seeds\" of\n.   the future image regions. All the other pixels in markers , whose relation to the outlined regions\n.   is not known and should be defined by the algorithm, should be set to 0's. In the function output,\n.   each pixel in markers is set to a value of the \"seed\" components or to -1 at boundaries between the\n.   regions.\n.   \n.   @note Any two neighbor connected components are not necessarily separated by a watershed boundary\n.   (-1's pixels); for example, they can touch each other in the initial marker image passed to the\n.   function.\n.   \n.   @param image Input 8-bit 3-channel image.\n.   @param markers Input/output 32-bit single-channel image (map) of markers. It should have the same\n.   size as image .\n.   \n.   @sa findContours"},
    {"writeOpticalFlow", CV_PY_FN_WITH_KW_(pyopencv_cv_writeOpticalFlow, 0), "writeOpticalFlow(path, flow) -> retval\n.   @brief Write a .flo to disk\n.   \n.    @param path Path to the file to be written\n.    @param flow Flow field to be stored\n.   \n.    The function stores a flow field in a file, returns true on success, false otherwise.\n.    The flow field must be a 2-channel, floating-point matrix (CV_32FC2). First channel corresponds\n.    to the flow in the horizontal direction (u), second - vertical (v)."},
#ifdef PYOPENCV_EXTRA_METHODS_CV
    PYOPENCV_EXTRA_METHODS_CV
#endif
    {NULL, NULL}
};

static ConstDef consts_cv[] = {
    {"ACCESS_FAST", static_cast<long>(cv::ACCESS_FAST)},
    {"ACCESS_MASK", static_cast<long>(cv::ACCESS_MASK)},
    {"ACCESS_READ", static_cast<long>(cv::ACCESS_READ)},
    {"ACCESS_RW", static_cast<long>(cv::ACCESS_RW)},
    {"ACCESS_WRITE", static_cast<long>(cv::ACCESS_WRITE)},
    {"ADAPTIVE_THRESH_GAUSSIAN_C", static_cast<long>(cv::ADAPTIVE_THRESH_GAUSSIAN_C)},
    {"ADAPTIVE_THRESH_MEAN_C", static_cast<long>(cv::ADAPTIVE_THRESH_MEAN_C)},
    {"AKAZE_DESCRIPTOR_KAZE", static_cast<long>(cv::AKAZE::DESCRIPTOR_KAZE)},
    {"AKAZE_DESCRIPTOR_KAZE_UPRIGHT", static_cast<long>(cv::AKAZE::DESCRIPTOR_KAZE_UPRIGHT)},
    {"AKAZE_DESCRIPTOR_MLDB", static_cast<long>(cv::AKAZE::DESCRIPTOR_MLDB)},
    {"AKAZE_DESCRIPTOR_MLDB_UPRIGHT", static_cast<long>(cv::AKAZE::DESCRIPTOR_MLDB_UPRIGHT)},
    {"ALGO_HINT_ACCURATE", static_cast<long>(cv::ALGO_HINT_ACCURATE)},
    {"ALGO_HINT_APPROX", static_cast<long>(cv::ALGO_HINT_APPROX)},
    {"ALGO_HINT_DEFAULT", static_cast<long>(cv::ALGO_HINT_DEFAULT)},
    {"AgastFeatureDetector_AGAST_5_8", static_cast<long>(cv::AgastFeatureDetector::AGAST_5_8)},
    {"AGAST_FEATURE_DETECTOR_AGAST_5_8", static_cast<long>(cv::AgastFeatureDetector::AGAST_5_8)},
    {"AgastFeatureDetector_AGAST_7_12d", static_cast<long>(cv::AgastFeatureDetector::AGAST_7_12d)},
    {"AGAST_FEATURE_DETECTOR_AGAST_7_12D", static_cast<long>(cv::AgastFeatureDetector::AGAST_7_12d)},
    {"AgastFeatureDetector_AGAST_7_12s", static_cast<long>(cv::AgastFeatureDetector::AGAST_7_12s)},
    {"AGAST_FEATURE_DETECTOR_AGAST_7_12S", static_cast<long>(cv::AgastFeatureDetector::AGAST_7_12s)},
    {"AgastFeatureDetector_NONMAX_SUPPRESSION", static_cast<long>(cv::AgastFeatureDetector::NONMAX_SUPPRESSION)},
    {"AGAST_FEATURE_DETECTOR_NONMAX_SUPPRESSION", static_cast<long>(cv::AgastFeatureDetector::NONMAX_SUPPRESSION)},
    {"AgastFeatureDetector_OAST_9_16", static_cast<long>(cv::AgastFeatureDetector::OAST_9_16)},
    {"AGAST_FEATURE_DETECTOR_OAST_9_16", static_cast<long>(cv::AgastFeatureDetector::OAST_9_16)},
    {"AgastFeatureDetector_THRESHOLD", static_cast<long>(cv::AgastFeatureDetector::THRESHOLD)},
    {"AGAST_FEATURE_DETECTOR_THRESHOLD", static_cast<long>(cv::AgastFeatureDetector::THRESHOLD)},
    {"BORDER_CONSTANT", static_cast<long>(cv::BORDER_CONSTANT)},
    {"BORDER_DEFAULT", static_cast<long>(cv::BORDER_DEFAULT)},
    {"BORDER_ISOLATED", static_cast<long>(cv::BORDER_ISOLATED)},
    {"BORDER_REFLECT", static_cast<long>(cv::BORDER_REFLECT)},
    {"BORDER_REFLECT101", static_cast<long>(cv::BORDER_REFLECT101)},
    {"BORDER_REFLECT_101", static_cast<long>(cv::BORDER_REFLECT_101)},
    {"BORDER_REPLICATE", static_cast<long>(cv::BORDER_REPLICATE)},
    {"BORDER_TRANSPARENT", static_cast<long>(cv::BORDER_TRANSPARENT)},
    {"BORDER_WRAP", static_cast<long>(cv::BORDER_WRAP)},
    {"CALIB_CB_ACCURACY", static_cast<long>(cv::CALIB_CB_ACCURACY)},
    {"CALIB_CB_ADAPTIVE_THRESH", static_cast<long>(cv::CALIB_CB_ADAPTIVE_THRESH)},
    {"CALIB_CB_ASYMMETRIC_GRID", static_cast<long>(cv::CALIB_CB_ASYMMETRIC_GRID)},
    {"CALIB_CB_CLUSTERING", static_cast<long>(cv::CALIB_CB_CLUSTERING)},
    {"CALIB_CB_EXHAUSTIVE", static_cast<long>(cv::CALIB_CB_EXHAUSTIVE)},
    {"CALIB_CB_FAST_CHECK", static_cast<long>(cv::CALIB_CB_FAST_CHECK)},
    {"CALIB_CB_FILTER_QUADS", static_cast<long>(cv::CALIB_CB_FILTER_QUADS)},
    {"CALIB_CB_LARGER", static_cast<long>(cv::CALIB_CB_LARGER)},
    {"CALIB_CB_MARKER", static_cast<long>(cv::CALIB_CB_MARKER)},
    {"CALIB_CB_NORMALIZE_IMAGE", static_cast<long>(cv::CALIB_CB_NORMALIZE_IMAGE)},
    {"CALIB_CB_PLAIN", static_cast<long>(cv::CALIB_CB_PLAIN)},
    {"CALIB_CB_SYMMETRIC_GRID", static_cast<long>(cv::CALIB_CB_SYMMETRIC_GRID)},
    {"CALIB_FIX_ASPECT_RATIO", static_cast<long>(cv::CALIB_FIX_ASPECT_RATIO)},
    {"CALIB_FIX_FOCAL_LENGTH", static_cast<long>(cv::CALIB_FIX_FOCAL_LENGTH)},
    {"CALIB_FIX_INTRINSIC", static_cast<long>(cv::CALIB_FIX_INTRINSIC)},
    {"CALIB_FIX_K1", static_cast<long>(cv::CALIB_FIX_K1)},
    {"CALIB_FIX_K2", static_cast<long>(cv::CALIB_FIX_K2)},
    {"CALIB_FIX_K3", static_cast<long>(cv::CALIB_FIX_K3)},
    {"CALIB_FIX_K4", static_cast<long>(cv::CALIB_FIX_K4)},
    {"CALIB_FIX_K5", static_cast<long>(cv::CALIB_FIX_K5)},
    {"CALIB_FIX_K6", static_cast<long>(cv::CALIB_FIX_K6)},
    {"CALIB_FIX_PRINCIPAL_POINT", static_cast<long>(cv::CALIB_FIX_PRINCIPAL_POINT)},
    {"CALIB_FIX_S1_S2_S3_S4", static_cast<long>(cv::CALIB_FIX_S1_S2_S3_S4)},
    {"CALIB_FIX_TANGENT_DIST", static_cast<long>(cv::CALIB_FIX_TANGENT_DIST)},
    {"CALIB_FIX_TAUX_TAUY", static_cast<long>(cv::CALIB_FIX_TAUX_TAUY)},
    {"CALIB_HAND_EYE_ANDREFF", static_cast<long>(cv::CALIB_HAND_EYE_ANDREFF)},
    {"CALIB_HAND_EYE_DANIILIDIS", static_cast<long>(cv::CALIB_HAND_EYE_DANIILIDIS)},
    {"CALIB_HAND_EYE_HORAUD", static_cast<long>(cv::CALIB_HAND_EYE_HORAUD)},
    {"CALIB_HAND_EYE_PARK", static_cast<long>(cv::CALIB_HAND_EYE_PARK)},
    {"CALIB_HAND_EYE_TSAI", static_cast<long>(cv::CALIB_HAND_EYE_TSAI)},
    {"CALIB_NINTRINSIC", static_cast<long>(cv::CALIB_NINTRINSIC)},
    {"CALIB_RATIONAL_MODEL", static_cast<long>(cv::CALIB_RATIONAL_MODEL)},
    {"CALIB_ROBOT_WORLD_HAND_EYE_LI", static_cast<long>(cv::CALIB_ROBOT_WORLD_HAND_EYE_LI)},
    {"CALIB_ROBOT_WORLD_HAND_EYE_SHAH", static_cast<long>(cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH)},
    {"CALIB_SAME_FOCAL_LENGTH", static_cast<long>(cv::CALIB_SAME_FOCAL_LENGTH)},
    {"CALIB_THIN_PRISM_MODEL", static_cast<long>(cv::CALIB_THIN_PRISM_MODEL)},
    {"CALIB_TILTED_MODEL", static_cast<long>(cv::CALIB_TILTED_MODEL)},
    {"CALIB_USE_EXTRINSIC_GUESS", static_cast<long>(cv::CALIB_USE_EXTRINSIC_GUESS)},
    {"CALIB_USE_INTRINSIC_GUESS", static_cast<long>(cv::CALIB_USE_INTRINSIC_GUESS)},
    {"CALIB_USE_LU", static_cast<long>(cv::CALIB_USE_LU)},
    {"CALIB_USE_QR", static_cast<long>(cv::CALIB_USE_QR)},
    {"CALIB_ZERO_DISPARITY", static_cast<long>(cv::CALIB_ZERO_DISPARITY)},
    {"CALIB_ZERO_TANGENT_DIST", static_cast<long>(cv::CALIB_ZERO_TANGENT_DIST)},
    {"CAP_ANDROID", static_cast<long>(cv::CAP_ANDROID)},
    {"CAP_ANY", static_cast<long>(cv::CAP_ANY)},
    {"CAP_ARAVIS", static_cast<long>(cv::CAP_ARAVIS)},
    {"CAP_AVFOUNDATION", static_cast<long>(cv::CAP_AVFOUNDATION)},
    {"CAP_CMU1394", static_cast<long>(cv::CAP_CMU1394)},
    {"CAP_DC1394", static_cast<long>(cv::CAP_DC1394)},
    {"CAP_DSHOW", static_cast<long>(cv::CAP_DSHOW)},
    {"CAP_FFMPEG", static_cast<long>(cv::CAP_FFMPEG)},
    {"CAP_FIREWARE", static_cast<long>(cv::CAP_FIREWARE)},
    {"CAP_FIREWIRE", static_cast<long>(cv::CAP_FIREWIRE)},
    {"CAP_GIGANETIX", static_cast<long>(cv::CAP_GIGANETIX)},
    {"CAP_GPHOTO2", static_cast<long>(cv::CAP_GPHOTO2)},
    {"CAP_GSTREAMER", static_cast<long>(cv::CAP_GSTREAMER)},
    {"CAP_IEEE1394", static_cast<long>(cv::CAP_IEEE1394)},
    {"CAP_IMAGES", static_cast<long>(cv::CAP_IMAGES)},
    {"CAP_INTELPERC", static_cast<long>(cv::CAP_INTELPERC)},
    {"CAP_INTELPERC_DEPTH_GENERATOR", static_cast<long>(cv::CAP_INTELPERC_DEPTH_GENERATOR)},
    {"CAP_INTELPERC_DEPTH_MAP", static_cast<long>(cv::CAP_INTELPERC_DEPTH_MAP)},
    {"CAP_INTELPERC_GENERATORS_MASK", static_cast<long>(cv::CAP_INTELPERC_GENERATORS_MASK)},
    {"CAP_INTELPERC_IMAGE", static_cast<long>(cv::CAP_INTELPERC_IMAGE)},
    {"CAP_INTELPERC_IMAGE_GENERATOR", static_cast<long>(cv::CAP_INTELPERC_IMAGE_GENERATOR)},
    {"CAP_INTELPERC_IR_GENERATOR", static_cast<long>(cv::CAP_INTELPERC_IR_GENERATOR)},
    {"CAP_INTELPERC_IR_MAP", static_cast<long>(cv::CAP_INTELPERC_IR_MAP)},
    {"CAP_INTELPERC_UVDEPTH_MAP", static_cast<long>(cv::CAP_INTELPERC_UVDEPTH_MAP)},
    {"CAP_INTEL_MFX", static_cast<long>(cv::CAP_INTEL_MFX)},
    {"CAP_MSMF", static_cast<long>(cv::CAP_MSMF)},
    {"CAP_OBSENSOR", static_cast<long>(cv::CAP_OBSENSOR)},
    {"CAP_OBSENSOR_BGR_IMAGE", static_cast<long>(cv::CAP_OBSENSOR_BGR_IMAGE)},
    {"CAP_OBSENSOR_DEPTH_GENERATOR", static_cast<long>(cv::CAP_OBSENSOR_DEPTH_GENERATOR)},
    {"CAP_OBSENSOR_DEPTH_MAP", static_cast<long>(cv::CAP_OBSENSOR_DEPTH_MAP)},
    {"CAP_OBSENSOR_GENERATORS_MASK", static_cast<long>(cv::CAP_OBSENSOR_GENERATORS_MASK)},
    {"CAP_OBSENSOR_IMAGE_GENERATOR", static_cast<long>(cv::CAP_OBSENSOR_IMAGE_GENERATOR)},
    {"CAP_OBSENSOR_IR_GENERATOR", static_cast<long>(cv::CAP_OBSENSOR_IR_GENERATOR)},
    {"CAP_OBSENSOR_IR_IMAGE", static_cast<long>(cv::CAP_OBSENSOR_IR_IMAGE)},
    {"CAP_OPENCV_MJPEG", static_cast<long>(cv::CAP_OPENCV_MJPEG)},
    {"CAP_OPENNI", static_cast<long>(cv::CAP_OPENNI)},
    {"CAP_OPENNI2", static_cast<long>(cv::CAP_OPENNI2)},
    {"CAP_OPENNI2_ASTRA", static_cast<long>(cv::CAP_OPENNI2_ASTRA)},
    {"CAP_OPENNI2_ASUS", static_cast<long>(cv::CAP_OPENNI2_ASUS)},
    {"CAP_OPENNI_ASUS", static_cast<long>(cv::CAP_OPENNI_ASUS)},
    {"CAP_OPENNI_BGR_IMAGE", static_cast<long>(cv::CAP_OPENNI_BGR_IMAGE)},
    {"CAP_OPENNI_DEPTH_GENERATOR", static_cast<long>(cv::CAP_OPENNI_DEPTH_GENERATOR)},
    {"CAP_OPENNI_DEPTH_GENERATOR_BASELINE", static_cast<long>(cv::CAP_OPENNI_DEPTH_GENERATOR_BASELINE)},
    {"CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH", static_cast<long>(cv::CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH)},
    {"CAP_OPENNI_DEPTH_GENERATOR_PRESENT", static_cast<long>(cv::CAP_OPENNI_DEPTH_GENERATOR_PRESENT)},
    {"CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION", static_cast<long>(cv::CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION)},
    {"CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON", static_cast<long>(cv::CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON)},
    {"CAP_OPENNI_DEPTH_MAP", static_cast<long>(cv::CAP_OPENNI_DEPTH_MAP)},
    {"CAP_OPENNI_DISPARITY_MAP", static_cast<long>(cv::CAP_OPENNI_DISPARITY_MAP)},
    {"CAP_OPENNI_DISPARITY_MAP_32F", static_cast<long>(cv::CAP_OPENNI_DISPARITY_MAP_32F)},
    {"CAP_OPENNI_GENERATORS_MASK", static_cast<long>(cv::CAP_OPENNI_GENERATORS_MASK)},
    {"CAP_OPENNI_GRAY_IMAGE", static_cast<long>(cv::CAP_OPENNI_GRAY_IMAGE)},
    {"CAP_OPENNI_IMAGE_GENERATOR", static_cast<long>(cv::CAP_OPENNI_IMAGE_GENERATOR)},
    {"CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE", static_cast<long>(cv::CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE)},
    {"CAP_OPENNI_IMAGE_GENERATOR_PRESENT", static_cast<long>(cv::CAP_OPENNI_IMAGE_GENERATOR_PRESENT)},
    {"CAP_OPENNI_IR_GENERATOR", static_cast<long>(cv::CAP_OPENNI_IR_GENERATOR)},
    {"CAP_OPENNI_IR_GENERATOR_PRESENT", static_cast<long>(cv::CAP_OPENNI_IR_GENERATOR_PRESENT)},
    {"CAP_OPENNI_IR_IMAGE", static_cast<long>(cv::CAP_OPENNI_IR_IMAGE)},
    {"CAP_OPENNI_POINT_CLOUD_MAP", static_cast<long>(cv::CAP_OPENNI_POINT_CLOUD_MAP)},
    {"CAP_OPENNI_QVGA_30HZ", static_cast<long>(cv::CAP_OPENNI_QVGA_30HZ)},
    {"CAP_OPENNI_QVGA_60HZ", static_cast<long>(cv::CAP_OPENNI_QVGA_60HZ)},
    {"CAP_OPENNI_SXGA_15HZ", static_cast<long>(cv::CAP_OPENNI_SXGA_15HZ)},
    {"CAP_OPENNI_SXGA_30HZ", static_cast<long>(cv::CAP_OPENNI_SXGA_30HZ)},
    {"CAP_OPENNI_VALID_DEPTH_MASK", static_cast<long>(cv::CAP_OPENNI_VALID_DEPTH_MASK)},
    {"CAP_OPENNI_VGA_30HZ", static_cast<long>(cv::CAP_OPENNI_VGA_30HZ)},
    {"CAP_PROP_ANDROID_DEVICE_TORCH", static_cast<long>(cv::CAP_PROP_ANDROID_DEVICE_TORCH)},
    {"CAP_PROP_APERTURE", static_cast<long>(cv::CAP_PROP_APERTURE)},
    {"CAP_PROP_ARAVIS_AUTOTRIGGER", static_cast<long>(cv::CAP_PROP_ARAVIS_AUTOTRIGGER)},
    {"CAP_PROP_AUDIO_BASE_INDEX", static_cast<long>(cv::CAP_PROP_AUDIO_BASE_INDEX)},
    {"CAP_PROP_AUDIO_DATA_DEPTH", static_cast<long>(cv::CAP_PROP_AUDIO_DATA_DEPTH)},
    {"CAP_PROP_AUDIO_POS", static_cast<long>(cv::CAP_PROP_AUDIO_POS)},
    {"CAP_PROP_AUDIO_SAMPLES_PER_SECOND", static_cast<long>(cv::CAP_PROP_AUDIO_SAMPLES_PER_SECOND)},
    {"CAP_PROP_AUDIO_SHIFT_NSEC", static_cast<long>(cv::CAP_PROP_AUDIO_SHIFT_NSEC)},
    {"CAP_PROP_AUDIO_STREAM", static_cast<long>(cv::CAP_PROP_AUDIO_STREAM)},
    {"CAP_PROP_AUDIO_SYNCHRONIZE", static_cast<long>(cv::CAP_PROP_AUDIO_SYNCHRONIZE)},
    {"CAP_PROP_AUDIO_TOTAL_CHANNELS", static_cast<long>(cv::CAP_PROP_AUDIO_TOTAL_CHANNELS)},
    {"CAP_PROP_AUDIO_TOTAL_STREAMS", static_cast<long>(cv::CAP_PROP_AUDIO_TOTAL_STREAMS)},
    {"CAP_PROP_AUTOFOCUS", static_cast<long>(cv::CAP_PROP_AUTOFOCUS)},
    {"CAP_PROP_AUTO_EXPOSURE", static_cast<long>(cv::CAP_PROP_AUTO_EXPOSURE)},
    {"CAP_PROP_AUTO_WB", static_cast<long>(cv::CAP_PROP_AUTO_WB)},
    {"CAP_PROP_BACKEND", static_cast<long>(cv::CAP_PROP_BACKEND)},
    {"CAP_PROP_BACKLIGHT", static_cast<long>(cv::CAP_PROP_BACKLIGHT)},
    {"CAP_PROP_BITRATE", static_cast<long>(cv::CAP_PROP_BITRATE)},
    {"CAP_PROP_BRIGHTNESS", static_cast<long>(cv::CAP_PROP_BRIGHTNESS)},
    {"CAP_PROP_BUFFERSIZE", static_cast<long>(cv::CAP_PROP_BUFFERSIZE)},
    {"CAP_PROP_CHANNEL", static_cast<long>(cv::CAP_PROP_CHANNEL)},
    {"CAP_PROP_CODEC_EXTRADATA_INDEX", static_cast<long>(cv::CAP_PROP_CODEC_EXTRADATA_INDEX)},
    {"CAP_PROP_CODEC_PIXEL_FORMAT", static_cast<long>(cv::CAP_PROP_CODEC_PIXEL_FORMAT)},
    {"CAP_PROP_CONTRAST", static_cast<long>(cv::CAP_PROP_CONTRAST)},
    {"CAP_PROP_CONVERT_RGB", static_cast<long>(cv::CAP_PROP_CONVERT_RGB)},
    {"CAP_PROP_DC1394_MAX", static_cast<long>(cv::CAP_PROP_DC1394_MAX)},
    {"CAP_PROP_DC1394_MODE_AUTO", static_cast<long>(cv::CAP_PROP_DC1394_MODE_AUTO)},
    {"CAP_PROP_DC1394_MODE_MANUAL", static_cast<long>(cv::CAP_PROP_DC1394_MODE_MANUAL)},
    {"CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO", static_cast<long>(cv::CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO)},
    {"CAP_PROP_DC1394_OFF", static_cast<long>(cv::CAP_PROP_DC1394_OFF)},
    {"CAP_PROP_DTS_DELAY", static_cast<long>(cv::CAP_PROP_DTS_DELAY)},
    {"CAP_PROP_EXPOSURE", static_cast<long>(cv::CAP_PROP_EXPOSURE)},
    {"CAP_PROP_EXPOSUREPROGRAM", static_cast<long>(cv::CAP_PROP_EXPOSUREPROGRAM)},
    {"CAP_PROP_FOCUS", static_cast<long>(cv::CAP_PROP_FOCUS)},
    {"CAP_PROP_FORMAT", static_cast<long>(cv::CAP_PROP_FORMAT)},
    {"CAP_PROP_FOURCC", static_cast<long>(cv::CAP_PROP_FOURCC)},
    {"CAP_PROP_FPS", static_cast<long>(cv::CAP_PROP_FPS)},
    {"CAP_PROP_FRAME_COUNT", static_cast<long>(cv::CAP_PROP_FRAME_COUNT)},
    {"CAP_PROP_FRAME_HEIGHT", static_cast<long>(cv::CAP_PROP_FRAME_HEIGHT)},
    {"CAP_PROP_FRAME_TYPE", static_cast<long>(cv::CAP_PROP_FRAME_TYPE)},
    {"CAP_PROP_FRAME_WIDTH", static_cast<long>(cv::CAP_PROP_FRAME_WIDTH)},
    {"CAP_PROP_GAIN", static_cast<long>(cv::CAP_PROP_GAIN)},
    {"CAP_PROP_GAMMA", static_cast<long>(cv::CAP_PROP_GAMMA)},
    {"CAP_PROP_GIGA_FRAME_HEIGH_MAX", static_cast<long>(cv::CAP_PROP_GIGA_FRAME_HEIGH_MAX)},
    {"CAP_PROP_GIGA_FRAME_OFFSET_X", static_cast<long>(cv::CAP_PROP_GIGA_FRAME_OFFSET_X)},
    {"CAP_PROP_GIGA_FRAME_OFFSET_Y", static_cast<long>(cv::CAP_PROP_GIGA_FRAME_OFFSET_Y)},
    {"CAP_PROP_GIGA_FRAME_SENS_HEIGH", static_cast<long>(cv::CAP_PROP_GIGA_FRAME_SENS_HEIGH)},
    {"CAP_PROP_GIGA_FRAME_SENS_WIDTH", static_cast<long>(cv::CAP_PROP_GIGA_FRAME_SENS_WIDTH)},
    {"CAP_PROP_GIGA_FRAME_WIDTH_MAX", static_cast<long>(cv::CAP_PROP_GIGA_FRAME_WIDTH_MAX)},
    {"CAP_PROP_GPHOTO2_COLLECT_MSGS", static_cast<long>(cv::CAP_PROP_GPHOTO2_COLLECT_MSGS)},
    {"CAP_PROP_GPHOTO2_FLUSH_MSGS", static_cast<long>(cv::CAP_PROP_GPHOTO2_FLUSH_MSGS)},
    {"CAP_PROP_GPHOTO2_PREVIEW", static_cast<long>(cv::CAP_PROP_GPHOTO2_PREVIEW)},
    {"CAP_PROP_GPHOTO2_RELOAD_CONFIG", static_cast<long>(cv::CAP_PROP_GPHOTO2_RELOAD_CONFIG)},
    {"CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE", static_cast<long>(cv::CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE)},
    {"CAP_PROP_GPHOTO2_WIDGET_ENUMERATE", static_cast<long>(cv::CAP_PROP_GPHOTO2_WIDGET_ENUMERATE)},
    {"CAP_PROP_GSTREAMER_QUEUE_LENGTH", static_cast<long>(cv::CAP_PROP_GSTREAMER_QUEUE_LENGTH)},
    {"CAP_PROP_GUID", static_cast<long>(cv::CAP_PROP_GUID)},
    {"CAP_PROP_HUE", static_cast<long>(cv::CAP_PROP_HUE)},
    {"CAP_PROP_HW_ACCELERATION", static_cast<long>(cv::CAP_PROP_HW_ACCELERATION)},
    {"CAP_PROP_HW_ACCELERATION_USE_OPENCL", static_cast<long>(cv::CAP_PROP_HW_ACCELERATION_USE_OPENCL)},
    {"CAP_PROP_HW_DEVICE", static_cast<long>(cv::CAP_PROP_HW_DEVICE)},
    {"CAP_PROP_IMAGES_BASE", static_cast<long>(cv::CAP_PROP_IMAGES_BASE)},
    {"CAP_PROP_IMAGES_LAST", static_cast<long>(cv::CAP_PROP_IMAGES_LAST)},
    {"CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD", static_cast<long>(cv::CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD)},
    {"CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ", static_cast<long>(cv::CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ)},
    {"CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT", static_cast<long>(cv::CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT)},
    {"CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE", static_cast<long>(cv::CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE)},
    {"CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE", static_cast<long>(cv::CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE)},
    {"CAP_PROP_INTELPERC_PROFILE_COUNT", static_cast<long>(cv::CAP_PROP_INTELPERC_PROFILE_COUNT)},
    {"CAP_PROP_INTELPERC_PROFILE_IDX", static_cast<long>(cv::CAP_PROP_INTELPERC_PROFILE_IDX)},
    {"CAP_PROP_IOS_DEVICE_EXPOSURE", static_cast<long>(cv::CAP_PROP_IOS_DEVICE_EXPOSURE)},
    {"CAP_PROP_IOS_DEVICE_FLASH", static_cast<long>(cv::CAP_PROP_IOS_DEVICE_FLASH)},
    {"CAP_PROP_IOS_DEVICE_FOCUS", static_cast<long>(cv::CAP_PROP_IOS_DEVICE_FOCUS)},
    {"CAP_PROP_IOS_DEVICE_TORCH", static_cast<long>(cv::CAP_PROP_IOS_DEVICE_TORCH)},
    {"CAP_PROP_IOS_DEVICE_WHITEBALANCE", static_cast<long>(cv::CAP_PROP_IOS_DEVICE_WHITEBALANCE)},
    {"CAP_PROP_IRIS", static_cast<long>(cv::CAP_PROP_IRIS)},
    {"CAP_PROP_ISO_SPEED", static_cast<long>(cv::CAP_PROP_ISO_SPEED)},
    {"CAP_PROP_LRF_HAS_KEY_FRAME", static_cast<long>(cv::CAP_PROP_LRF_HAS_KEY_FRAME)},
    {"CAP_PROP_MODE", static_cast<long>(cv::CAP_PROP_MODE)},
    {"CAP_PROP_MONOCHROME", static_cast<long>(cv::CAP_PROP_MONOCHROME)},
    {"CAP_PROP_N_THREADS", static_cast<long>(cv::CAP_PROP_N_THREADS)},
    {"CAP_PROP_OBSENSOR_INTRINSIC_CX", static_cast<long>(cv::CAP_PROP_OBSENSOR_INTRINSIC_CX)},
    {"CAP_PROP_OBSENSOR_INTRINSIC_CY", static_cast<long>(cv::CAP_PROP_OBSENSOR_INTRINSIC_CY)},
    {"CAP_PROP_OBSENSOR_INTRINSIC_FX", static_cast<long>(cv::CAP_PROP_OBSENSOR_INTRINSIC_FX)},
    {"CAP_PROP_OBSENSOR_INTRINSIC_FY", static_cast<long>(cv::CAP_PROP_OBSENSOR_INTRINSIC_FY)},
    {"CAP_PROP_OPENNI2_MIRROR", static_cast<long>(cv::CAP_PROP_OPENNI2_MIRROR)},
    {"CAP_PROP_OPENNI2_SYNC", static_cast<long>(cv::CAP_PROP_OPENNI2_SYNC)},
    {"CAP_PROP_OPENNI_APPROX_FRAME_SYNC", static_cast<long>(cv::CAP_PROP_OPENNI_APPROX_FRAME_SYNC)},
    {"CAP_PROP_OPENNI_BASELINE", static_cast<long>(cv::CAP_PROP_OPENNI_BASELINE)},
    {"CAP_PROP_OPENNI_CIRCLE_BUFFER", static_cast<long>(cv::CAP_PROP_OPENNI_CIRCLE_BUFFER)},
    {"CAP_PROP_OPENNI_FOCAL_LENGTH", static_cast<long>(cv::CAP_PROP_OPENNI_FOCAL_LENGTH)},
    {"CAP_PROP_OPENNI_FRAME_MAX_DEPTH", static_cast<long>(cv::CAP_PROP_OPENNI_FRAME_MAX_DEPTH)},
    {"CAP_PROP_OPENNI_GENERATOR_PRESENT", static_cast<long>(cv::CAP_PROP_OPENNI_GENERATOR_PRESENT)},
    {"CAP_PROP_OPENNI_MAX_BUFFER_SIZE", static_cast<long>(cv::CAP_PROP_OPENNI_MAX_BUFFER_SIZE)},
    {"CAP_PROP_OPENNI_MAX_TIME_DURATION", static_cast<long>(cv::CAP_PROP_OPENNI_MAX_TIME_DURATION)},
    {"CAP_PROP_OPENNI_OUTPUT_MODE", static_cast<long>(cv::CAP_PROP_OPENNI_OUTPUT_MODE)},
    {"CAP_PROP_OPENNI_REGISTRATION", static_cast<long>(cv::CAP_PROP_OPENNI_REGISTRATION)},
    {"CAP_PROP_OPENNI_REGISTRATION_ON", static_cast<long>(cv::CAP_PROP_OPENNI_REGISTRATION_ON)},
    {"CAP_PROP_OPEN_TIMEOUT_MSEC", static_cast<long>(cv::CAP_PROP_OPEN_TIMEOUT_MSEC)},
    {"CAP_PROP_ORIENTATION_AUTO", static_cast<long>(cv::CAP_PROP_ORIENTATION_AUTO)},
    {"CAP_PROP_ORIENTATION_META", static_cast<long>(cv::CAP_PROP_ORIENTATION_META)},
    {"CAP_PROP_PAN", static_cast<long>(cv::CAP_PROP_PAN)},
    {"CAP_PROP_POS_AVI_RATIO", static_cast<long>(cv::CAP_PROP_POS_AVI_RATIO)},
    {"CAP_PROP_POS_FRAMES", static_cast<long>(cv::CAP_PROP_POS_FRAMES)},
    {"CAP_PROP_POS_MSEC", static_cast<long>(cv::CAP_PROP_POS_MSEC)},
    {"CAP_PROP_PTS", static_cast<long>(cv::CAP_PROP_PTS)},
    {"CAP_PROP_PVAPI_BINNINGX", static_cast<long>(cv::CAP_PROP_PVAPI_BINNINGX)},
    {"CAP_PROP_PVAPI_BINNINGY", static_cast<long>(cv::CAP_PROP_PVAPI_BINNINGY)},
    {"CAP_PROP_PVAPI_DECIMATIONHORIZONTAL", static_cast<long>(cv::CAP_PROP_PVAPI_DECIMATIONHORIZONTAL)},
    {"CAP_PROP_PVAPI_DECIMATIONVERTICAL", static_cast<long>(cv::CAP_PROP_PVAPI_DECIMATIONVERTICAL)},
    {"CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE", static_cast<long>(cv::CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE)},
    {"CAP_PROP_PVAPI_MULTICASTIP", static_cast<long>(cv::CAP_PROP_PVAPI_MULTICASTIP)},
    {"CAP_PROP_PVAPI_PIXELFORMAT", static_cast<long>(cv::CAP_PROP_PVAPI_PIXELFORMAT)},
    {"CAP_PROP_READ_TIMEOUT_MSEC", static_cast<long>(cv::CAP_PROP_READ_TIMEOUT_MSEC)},
    {"CAP_PROP_RECTIFICATION", static_cast<long>(cv::CAP_PROP_RECTIFICATION)},
    {"CAP_PROP_ROLL", static_cast<long>(cv::CAP_PROP_ROLL)},
    {"CAP_PROP_SAR_DEN", static_cast<long>(cv::CAP_PROP_SAR_DEN)},
    {"CAP_PROP_SAR_NUM", static_cast<long>(cv::CAP_PROP_SAR_NUM)},
    {"CAP_PROP_SATURATION", static_cast<long>(cv::CAP_PROP_SATURATION)},
    {"CAP_PROP_SETTINGS", static_cast<long>(cv::CAP_PROP_SETTINGS)},
    {"CAP_PROP_SHARPNESS", static_cast<long>(cv::CAP_PROP_SHARPNESS)},
    {"CAP_PROP_SPEED", static_cast<long>(cv::CAP_PROP_SPEED)},
    {"CAP_PROP_STREAM_OPEN_TIME_USEC", static_cast<long>(cv::CAP_PROP_STREAM_OPEN_TIME_USEC)},
    {"CAP_PROP_TEMPERATURE", static_cast<long>(cv::CAP_PROP_TEMPERATURE)},
    {"CAP_PROP_TILT", static_cast<long>(cv::CAP_PROP_TILT)},
    {"CAP_PROP_TRIGGER", static_cast<long>(cv::CAP_PROP_TRIGGER)},
    {"CAP_PROP_TRIGGER_DELAY", static_cast<long>(cv::CAP_PROP_TRIGGER_DELAY)},
    {"CAP_PROP_VIDEO_STREAM", static_cast<long>(cv::CAP_PROP_VIDEO_STREAM)},
    {"CAP_PROP_VIDEO_TOTAL_CHANNELS", static_cast<long>(cv::CAP_PROP_VIDEO_TOTAL_CHANNELS)},
    {"CAP_PROP_VIEWFINDER", static_cast<long>(cv::CAP_PROP_VIEWFINDER)},
    {"CAP_PROP_WB_TEMPERATURE", static_cast<long>(cv::CAP_PROP_WB_TEMPERATURE)},
    {"CAP_PROP_WHITE_BALANCE_BLUE_U", static_cast<long>(cv::CAP_PROP_WHITE_BALANCE_BLUE_U)},
    {"CAP_PROP_WHITE_BALANCE_RED_V", static_cast<long>(cv::CAP_PROP_WHITE_BALANCE_RED_V)},
    {"CAP_PROP_XI_ACQ_BUFFER_SIZE", static_cast<long>(cv::CAP_PROP_XI_ACQ_BUFFER_SIZE)},
    {"CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT", static_cast<long>(cv::CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT)},
    {"CAP_PROP_XI_ACQ_FRAME_BURST_COUNT", static_cast<long>(cv::CAP_PROP_XI_ACQ_FRAME_BURST_COUNT)},
    {"CAP_PROP_XI_ACQ_TIMING_MODE", static_cast<long>(cv::CAP_PROP_XI_ACQ_TIMING_MODE)},
    {"CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT", static_cast<long>(cv::CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT)},
    {"CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE", static_cast<long>(cv::CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE)},
    {"CAP_PROP_XI_AEAG", static_cast<long>(cv::CAP_PROP_XI_AEAG)},
    {"CAP_PROP_XI_AEAG_LEVEL", static_cast<long>(cv::CAP_PROP_XI_AEAG_LEVEL)},
    {"CAP_PROP_XI_AEAG_ROI_HEIGHT", static_cast<long>(cv::CAP_PROP_XI_AEAG_ROI_HEIGHT)},
    {"CAP_PROP_XI_AEAG_ROI_OFFSET_X", static_cast<long>(cv::CAP_PROP_XI_AEAG_ROI_OFFSET_X)},
    {"CAP_PROP_XI_AEAG_ROI_OFFSET_Y", static_cast<long>(cv::CAP_PROP_XI_AEAG_ROI_OFFSET_Y)},
    {"CAP_PROP_XI_AEAG_ROI_WIDTH", static_cast<long>(cv::CAP_PROP_XI_AEAG_ROI_WIDTH)},
    {"CAP_PROP_XI_AE_MAX_LIMIT", static_cast<long>(cv::CAP_PROP_XI_AE_MAX_LIMIT)},
    {"CAP_PROP_XI_AG_MAX_LIMIT", static_cast<long>(cv::CAP_PROP_XI_AG_MAX_LIMIT)},
    {"CAP_PROP_XI_APPLY_CMS", static_cast<long>(cv::CAP_PROP_XI_APPLY_CMS)},
    {"CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION", static_cast<long>(cv::CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION)},
    {"CAP_PROP_XI_AUTO_WB", static_cast<long>(cv::CAP_PROP_XI_AUTO_WB)},
    {"CAP_PROP_XI_AVAILABLE_BANDWIDTH", static_cast<long>(cv::CAP_PROP_XI_AVAILABLE_BANDWIDTH)},
    {"CAP_PROP_XI_BINNING_HORIZONTAL", static_cast<long>(cv::CAP_PROP_XI_BINNING_HORIZONTAL)},
    {"CAP_PROP_XI_BINNING_PATTERN", static_cast<long>(cv::CAP_PROP_XI_BINNING_PATTERN)},
    {"CAP_PROP_XI_BINNING_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_BINNING_SELECTOR)},
    {"CAP_PROP_XI_BINNING_VERTICAL", static_cast<long>(cv::CAP_PROP_XI_BINNING_VERTICAL)},
    {"CAP_PROP_XI_BPC", static_cast<long>(cv::CAP_PROP_XI_BPC)},
    {"CAP_PROP_XI_BUFFERS_QUEUE_SIZE", static_cast<long>(cv::CAP_PROP_XI_BUFFERS_QUEUE_SIZE)},
    {"CAP_PROP_XI_BUFFER_POLICY", static_cast<long>(cv::CAP_PROP_XI_BUFFER_POLICY)},
    {"CAP_PROP_XI_CC_MATRIX_00", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_00)},
    {"CAP_PROP_XI_CC_MATRIX_01", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_01)},
    {"CAP_PROP_XI_CC_MATRIX_02", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_02)},
    {"CAP_PROP_XI_CC_MATRIX_03", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_03)},
    {"CAP_PROP_XI_CC_MATRIX_10", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_10)},
    {"CAP_PROP_XI_CC_MATRIX_11", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_11)},
    {"CAP_PROP_XI_CC_MATRIX_12", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_12)},
    {"CAP_PROP_XI_CC_MATRIX_13", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_13)},
    {"CAP_PROP_XI_CC_MATRIX_20", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_20)},
    {"CAP_PROP_XI_CC_MATRIX_21", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_21)},
    {"CAP_PROP_XI_CC_MATRIX_22", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_22)},
    {"CAP_PROP_XI_CC_MATRIX_23", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_23)},
    {"CAP_PROP_XI_CC_MATRIX_30", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_30)},
    {"CAP_PROP_XI_CC_MATRIX_31", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_31)},
    {"CAP_PROP_XI_CC_MATRIX_32", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_32)},
    {"CAP_PROP_XI_CC_MATRIX_33", static_cast<long>(cv::CAP_PROP_XI_CC_MATRIX_33)},
    {"CAP_PROP_XI_CHIP_TEMP", static_cast<long>(cv::CAP_PROP_XI_CHIP_TEMP)},
    {"CAP_PROP_XI_CMS", static_cast<long>(cv::CAP_PROP_XI_CMS)},
    {"CAP_PROP_XI_COLOR_FILTER_ARRAY", static_cast<long>(cv::CAP_PROP_XI_COLOR_FILTER_ARRAY)},
    {"CAP_PROP_XI_COLUMN_FPN_CORRECTION", static_cast<long>(cv::CAP_PROP_XI_COLUMN_FPN_CORRECTION)},
    {"CAP_PROP_XI_COOLING", static_cast<long>(cv::CAP_PROP_XI_COOLING)},
    {"CAP_PROP_XI_COUNTER_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_COUNTER_SELECTOR)},
    {"CAP_PROP_XI_COUNTER_VALUE", static_cast<long>(cv::CAP_PROP_XI_COUNTER_VALUE)},
    {"CAP_PROP_XI_DATA_FORMAT", static_cast<long>(cv::CAP_PROP_XI_DATA_FORMAT)},
    {"CAP_PROP_XI_DEBOUNCE_EN", static_cast<long>(cv::CAP_PROP_XI_DEBOUNCE_EN)},
    {"CAP_PROP_XI_DEBOUNCE_POL", static_cast<long>(cv::CAP_PROP_XI_DEBOUNCE_POL)},
    {"CAP_PROP_XI_DEBOUNCE_T0", static_cast<long>(cv::CAP_PROP_XI_DEBOUNCE_T0)},
    {"CAP_PROP_XI_DEBOUNCE_T1", static_cast<long>(cv::CAP_PROP_XI_DEBOUNCE_T1)},
    {"CAP_PROP_XI_DEBUG_LEVEL", static_cast<long>(cv::CAP_PROP_XI_DEBUG_LEVEL)},
    {"CAP_PROP_XI_DECIMATION_HORIZONTAL", static_cast<long>(cv::CAP_PROP_XI_DECIMATION_HORIZONTAL)},
    {"CAP_PROP_XI_DECIMATION_PATTERN", static_cast<long>(cv::CAP_PROP_XI_DECIMATION_PATTERN)},
    {"CAP_PROP_XI_DECIMATION_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_DECIMATION_SELECTOR)},
    {"CAP_PROP_XI_DECIMATION_VERTICAL", static_cast<long>(cv::CAP_PROP_XI_DECIMATION_VERTICAL)},
    {"CAP_PROP_XI_DEFAULT_CC_MATRIX", static_cast<long>(cv::CAP_PROP_XI_DEFAULT_CC_MATRIX)},
    {"CAP_PROP_XI_DEVICE_MODEL_ID", static_cast<long>(cv::CAP_PROP_XI_DEVICE_MODEL_ID)},
    {"CAP_PROP_XI_DEVICE_RESET", static_cast<long>(cv::CAP_PROP_XI_DEVICE_RESET)},
    {"CAP_PROP_XI_DEVICE_SN", static_cast<long>(cv::CAP_PROP_XI_DEVICE_SN)},
    {"CAP_PROP_XI_DOWNSAMPLING", static_cast<long>(cv::CAP_PROP_XI_DOWNSAMPLING)},
    {"CAP_PROP_XI_DOWNSAMPLING_TYPE", static_cast<long>(cv::CAP_PROP_XI_DOWNSAMPLING_TYPE)},
    {"CAP_PROP_XI_EXPOSURE", static_cast<long>(cv::CAP_PROP_XI_EXPOSURE)},
    {"CAP_PROP_XI_EXPOSURE_BURST_COUNT", static_cast<long>(cv::CAP_PROP_XI_EXPOSURE_BURST_COUNT)},
    {"CAP_PROP_XI_EXP_PRIORITY", static_cast<long>(cv::CAP_PROP_XI_EXP_PRIORITY)},
    {"CAP_PROP_XI_FFS_ACCESS_KEY", static_cast<long>(cv::CAP_PROP_XI_FFS_ACCESS_KEY)},
    {"CAP_PROP_XI_FFS_FILE_ID", static_cast<long>(cv::CAP_PROP_XI_FFS_FILE_ID)},
    {"CAP_PROP_XI_FFS_FILE_SIZE", static_cast<long>(cv::CAP_PROP_XI_FFS_FILE_SIZE)},
    {"CAP_PROP_XI_FRAMERATE", static_cast<long>(cv::CAP_PROP_XI_FRAMERATE)},
    {"CAP_PROP_XI_FREE_FFS_SIZE", static_cast<long>(cv::CAP_PROP_XI_FREE_FFS_SIZE)},
    {"CAP_PROP_XI_GAIN", static_cast<long>(cv::CAP_PROP_XI_GAIN)},
    {"CAP_PROP_XI_GAIN_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_GAIN_SELECTOR)},
    {"CAP_PROP_XI_GAMMAC", static_cast<long>(cv::CAP_PROP_XI_GAMMAC)},
    {"CAP_PROP_XI_GAMMAY", static_cast<long>(cv::CAP_PROP_XI_GAMMAY)},
    {"CAP_PROP_XI_GPI_LEVEL", static_cast<long>(cv::CAP_PROP_XI_GPI_LEVEL)},
    {"CAP_PROP_XI_GPI_MODE", static_cast<long>(cv::CAP_PROP_XI_GPI_MODE)},
    {"CAP_PROP_XI_GPI_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_GPI_SELECTOR)},
    {"CAP_PROP_XI_GPO_MODE", static_cast<long>(cv::CAP_PROP_XI_GPO_MODE)},
    {"CAP_PROP_XI_GPO_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_GPO_SELECTOR)},
    {"CAP_PROP_XI_HDR", static_cast<long>(cv::CAP_PROP_XI_HDR)},
    {"CAP_PROP_XI_HDR_KNEEPOINT_COUNT", static_cast<long>(cv::CAP_PROP_XI_HDR_KNEEPOINT_COUNT)},
    {"CAP_PROP_XI_HDR_T1", static_cast<long>(cv::CAP_PROP_XI_HDR_T1)},
    {"CAP_PROP_XI_HDR_T2", static_cast<long>(cv::CAP_PROP_XI_HDR_T2)},
    {"CAP_PROP_XI_HEIGHT", static_cast<long>(cv::CAP_PROP_XI_HEIGHT)},
    {"CAP_PROP_XI_HOUS_BACK_SIDE_TEMP", static_cast<long>(cv::CAP_PROP_XI_HOUS_BACK_SIDE_TEMP)},
    {"CAP_PROP_XI_HOUS_TEMP", static_cast<long>(cv::CAP_PROP_XI_HOUS_TEMP)},
    {"CAP_PROP_XI_HW_REVISION", static_cast<long>(cv::CAP_PROP_XI_HW_REVISION)},
    {"CAP_PROP_XI_IMAGE_BLACK_LEVEL", static_cast<long>(cv::CAP_PROP_XI_IMAGE_BLACK_LEVEL)},
    {"CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH", static_cast<long>(cv::CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH)},
    {"CAP_PROP_XI_IMAGE_DATA_FORMAT", static_cast<long>(cv::CAP_PROP_XI_IMAGE_DATA_FORMAT)},
    {"CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA", static_cast<long>(cv::CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA)},
    {"CAP_PROP_XI_IMAGE_IS_COLOR", static_cast<long>(cv::CAP_PROP_XI_IMAGE_IS_COLOR)},
    {"CAP_PROP_XI_IMAGE_PAYLOAD_SIZE", static_cast<long>(cv::CAP_PROP_XI_IMAGE_PAYLOAD_SIZE)},
    {"CAP_PROP_XI_IS_COOLED", static_cast<long>(cv::CAP_PROP_XI_IS_COOLED)},
    {"CAP_PROP_XI_IS_DEVICE_EXIST", static_cast<long>(cv::CAP_PROP_XI_IS_DEVICE_EXIST)},
    {"CAP_PROP_XI_KNEEPOINT1", static_cast<long>(cv::CAP_PROP_XI_KNEEPOINT1)},
    {"CAP_PROP_XI_KNEEPOINT2", static_cast<long>(cv::CAP_PROP_XI_KNEEPOINT2)},
    {"CAP_PROP_XI_LED_MODE", static_cast<long>(cv::CAP_PROP_XI_LED_MODE)},
    {"CAP_PROP_XI_LED_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_LED_SELECTOR)},
    {"CAP_PROP_XI_LENS_APERTURE_VALUE", static_cast<long>(cv::CAP_PROP_XI_LENS_APERTURE_VALUE)},
    {"CAP_PROP_XI_LENS_FEATURE", static_cast<long>(cv::CAP_PROP_XI_LENS_FEATURE)},
    {"CAP_PROP_XI_LENS_FEATURE_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_LENS_FEATURE_SELECTOR)},
    {"CAP_PROP_XI_LENS_FOCAL_LENGTH", static_cast<long>(cv::CAP_PROP_XI_LENS_FOCAL_LENGTH)},
    {"CAP_PROP_XI_LENS_FOCUS_DISTANCE", static_cast<long>(cv::CAP_PROP_XI_LENS_FOCUS_DISTANCE)},
    {"CAP_PROP_XI_LENS_FOCUS_MOVE", static_cast<long>(cv::CAP_PROP_XI_LENS_FOCUS_MOVE)},
    {"CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE", static_cast<long>(cv::CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE)},
    {"CAP_PROP_XI_LENS_MODE", static_cast<long>(cv::CAP_PROP_XI_LENS_MODE)},
    {"CAP_PROP_XI_LIMIT_BANDWIDTH", static_cast<long>(cv::CAP_PROP_XI_LIMIT_BANDWIDTH)},
    {"CAP_PROP_XI_LUT_EN", static_cast<long>(cv::CAP_PROP_XI_LUT_EN)},
    {"CAP_PROP_XI_LUT_INDEX", static_cast<long>(cv::CAP_PROP_XI_LUT_INDEX)},
    {"CAP_PROP_XI_LUT_VALUE", static_cast<long>(cv::CAP_PROP_XI_LUT_VALUE)},
    {"CAP_PROP_XI_MANUAL_WB", static_cast<long>(cv::CAP_PROP_XI_MANUAL_WB)},
    {"CAP_PROP_XI_OFFSET_X", static_cast<long>(cv::CAP_PROP_XI_OFFSET_X)},
    {"CAP_PROP_XI_OFFSET_Y", static_cast<long>(cv::CAP_PROP_XI_OFFSET_Y)},
    {"CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH", static_cast<long>(cv::CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH)},
    {"CAP_PROP_XI_OUTPUT_DATA_PACKING", static_cast<long>(cv::CAP_PROP_XI_OUTPUT_DATA_PACKING)},
    {"CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE", static_cast<long>(cv::CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE)},
    {"CAP_PROP_XI_RECENT_FRAME", static_cast<long>(cv::CAP_PROP_XI_RECENT_FRAME)},
    {"CAP_PROP_XI_REGION_MODE", static_cast<long>(cv::CAP_PROP_XI_REGION_MODE)},
    {"CAP_PROP_XI_REGION_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_REGION_SELECTOR)},
    {"CAP_PROP_XI_ROW_FPN_CORRECTION", static_cast<long>(cv::CAP_PROP_XI_ROW_FPN_CORRECTION)},
    {"CAP_PROP_XI_SENSOR_BOARD_TEMP", static_cast<long>(cv::CAP_PROP_XI_SENSOR_BOARD_TEMP)},
    {"CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ", static_cast<long>(cv::CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ)},
    {"CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX", static_cast<long>(cv::CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX)},
    {"CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH", static_cast<long>(cv::CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH)},
    {"CAP_PROP_XI_SENSOR_FEATURE_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_SENSOR_FEATURE_SELECTOR)},
    {"CAP_PROP_XI_SENSOR_FEATURE_VALUE", static_cast<long>(cv::CAP_PROP_XI_SENSOR_FEATURE_VALUE)},
    {"CAP_PROP_XI_SENSOR_MODE", static_cast<long>(cv::CAP_PROP_XI_SENSOR_MODE)},
    {"CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT", static_cast<long>(cv::CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT)},
    {"CAP_PROP_XI_SENSOR_TAPS", static_cast<long>(cv::CAP_PROP_XI_SENSOR_TAPS)},
    {"CAP_PROP_XI_SHARPNESS", static_cast<long>(cv::CAP_PROP_XI_SHARPNESS)},
    {"CAP_PROP_XI_SHUTTER_TYPE", static_cast<long>(cv::CAP_PROP_XI_SHUTTER_TYPE)},
    {"CAP_PROP_XI_TARGET_TEMP", static_cast<long>(cv::CAP_PROP_XI_TARGET_TEMP)},
    {"CAP_PROP_XI_TEST_PATTERN", static_cast<long>(cv::CAP_PROP_XI_TEST_PATTERN)},
    {"CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR)},
    {"CAP_PROP_XI_TIMEOUT", static_cast<long>(cv::CAP_PROP_XI_TIMEOUT)},
    {"CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT", static_cast<long>(cv::CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT)},
    {"CAP_PROP_XI_TRG_DELAY", static_cast<long>(cv::CAP_PROP_XI_TRG_DELAY)},
    {"CAP_PROP_XI_TRG_SELECTOR", static_cast<long>(cv::CAP_PROP_XI_TRG_SELECTOR)},
    {"CAP_PROP_XI_TRG_SOFTWARE", static_cast<long>(cv::CAP_PROP_XI_TRG_SOFTWARE)},
    {"CAP_PROP_XI_TRG_SOURCE", static_cast<long>(cv::CAP_PROP_XI_TRG_SOURCE)},
    {"CAP_PROP_XI_TS_RST_MODE", static_cast<long>(cv::CAP_PROP_XI_TS_RST_MODE)},
    {"CAP_PROP_XI_TS_RST_SOURCE", static_cast<long>(cv::CAP_PROP_XI_TS_RST_SOURCE)},
    {"CAP_PROP_XI_USED_FFS_SIZE", static_cast<long>(cv::CAP_PROP_XI_USED_FFS_SIZE)},
    {"CAP_PROP_XI_WB_KB", static_cast<long>(cv::CAP_PROP_XI_WB_KB)},
    {"CAP_PROP_XI_WB_KG", static_cast<long>(cv::CAP_PROP_XI_WB_KG)},
    {"CAP_PROP_XI_WB_KR", static_cast<long>(cv::CAP_PROP_XI_WB_KR)},
    {"CAP_PROP_XI_WIDTH", static_cast<long>(cv::CAP_PROP_XI_WIDTH)},
    {"CAP_PROP_ZOOM", static_cast<long>(cv::CAP_PROP_ZOOM)},
    {"CAP_PVAPI", static_cast<long>(cv::CAP_PVAPI)},
    {"CAP_PVAPI_DECIMATION_2OUTOF16", static_cast<long>(cv::CAP_PVAPI_DECIMATION_2OUTOF16)},
    {"CAP_PVAPI_DECIMATION_2OUTOF4", static_cast<long>(cv::CAP_PVAPI_DECIMATION_2OUTOF4)},
    {"CAP_PVAPI_DECIMATION_2OUTOF8", static_cast<long>(cv::CAP_PVAPI_DECIMATION_2OUTOF8)},
    {"CAP_PVAPI_DECIMATION_OFF", static_cast<long>(cv::CAP_PVAPI_DECIMATION_OFF)},
    {"CAP_PVAPI_FSTRIGMODE_FIXEDRATE", static_cast<long>(cv::CAP_PVAPI_FSTRIGMODE_FIXEDRATE)},
    {"CAP_PVAPI_FSTRIGMODE_FREERUN", static_cast<long>(cv::CAP_PVAPI_FSTRIGMODE_FREERUN)},
    {"CAP_PVAPI_FSTRIGMODE_SOFTWARE", static_cast<long>(cv::CAP_PVAPI_FSTRIGMODE_SOFTWARE)},
    {"CAP_PVAPI_FSTRIGMODE_SYNCIN1", static_cast<long>(cv::CAP_PVAPI_FSTRIGMODE_SYNCIN1)},
    {"CAP_PVAPI_FSTRIGMODE_SYNCIN2", static_cast<long>(cv::CAP_PVAPI_FSTRIGMODE_SYNCIN2)},
    {"CAP_PVAPI_PIXELFORMAT_BAYER16", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_BAYER16)},
    {"CAP_PVAPI_PIXELFORMAT_BAYER8", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_BAYER8)},
    {"CAP_PVAPI_PIXELFORMAT_BGR24", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_BGR24)},
    {"CAP_PVAPI_PIXELFORMAT_BGRA32", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_BGRA32)},
    {"CAP_PVAPI_PIXELFORMAT_MONO16", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_MONO16)},
    {"CAP_PVAPI_PIXELFORMAT_MONO8", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_MONO8)},
    {"CAP_PVAPI_PIXELFORMAT_RGB24", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_RGB24)},
    {"CAP_PVAPI_PIXELFORMAT_RGBA32", static_cast<long>(cv::CAP_PVAPI_PIXELFORMAT_RGBA32)},
    {"CAP_QT", static_cast<long>(cv::CAP_QT)},
    {"CAP_REALSENSE", static_cast<long>(cv::CAP_REALSENSE)},
    {"CAP_UEYE", static_cast<long>(cv::CAP_UEYE)},
    {"CAP_UNICAP", static_cast<long>(cv::CAP_UNICAP)},
    {"CAP_V4L", static_cast<long>(cv::CAP_V4L)},
    {"CAP_V4L2", static_cast<long>(cv::CAP_V4L2)},
    {"CAP_VFW", static_cast<long>(cv::CAP_VFW)},
    {"CAP_WINRT", static_cast<long>(cv::CAP_WINRT)},
    {"CAP_XIAPI", static_cast<long>(cv::CAP_XIAPI)},
    {"CAP_XINE", static_cast<long>(cv::CAP_XINE)},
    {"CASCADE_DO_CANNY_PRUNING", static_cast<long>(cv::CASCADE_DO_CANNY_PRUNING)},
    {"CASCADE_DO_ROUGH_SEARCH", static_cast<long>(cv::CASCADE_DO_ROUGH_SEARCH)},
    {"CASCADE_FIND_BIGGEST_OBJECT", static_cast<long>(cv::CASCADE_FIND_BIGGEST_OBJECT)},
    {"CASCADE_SCALE_IMAGE", static_cast<long>(cv::CASCADE_SCALE_IMAGE)},
    {"CCL_BBDT", static_cast<long>(cv::CCL_BBDT)},
    {"CCL_BOLELLI", static_cast<long>(cv::CCL_BOLELLI)},
    {"CCL_DEFAULT", static_cast<long>(cv::CCL_DEFAULT)},
    {"CCL_GRANA", static_cast<long>(cv::CCL_GRANA)},
    {"CCL_SAUF", static_cast<long>(cv::CCL_SAUF)},
    {"CCL_SPAGHETTI", static_cast<long>(cv::CCL_SPAGHETTI)},
    {"CCL_WU", static_cast<long>(cv::CCL_WU)},
    {"CC_STAT_AREA", static_cast<long>(cv::CC_STAT_AREA)},
    {"CC_STAT_HEIGHT", static_cast<long>(cv::CC_STAT_HEIGHT)},
    {"CC_STAT_LEFT", static_cast<long>(cv::CC_STAT_LEFT)},
    {"CC_STAT_MAX", static_cast<long>(cv::CC_STAT_MAX)},
    {"CC_STAT_TOP", static_cast<long>(cv::CC_STAT_TOP)},
    {"CC_STAT_WIDTH", static_cast<long>(cv::CC_STAT_WIDTH)},
    {"CHAIN_APPROX_NONE", static_cast<long>(cv::CHAIN_APPROX_NONE)},
    {"CHAIN_APPROX_SIMPLE", static_cast<long>(cv::CHAIN_APPROX_SIMPLE)},
    {"CHAIN_APPROX_TC89_KCOS", static_cast<long>(cv::CHAIN_APPROX_TC89_KCOS)},
    {"CHAIN_APPROX_TC89_L1", static_cast<long>(cv::CHAIN_APPROX_TC89_L1)},
    {"CMP_EQ", static_cast<long>(cv::CMP_EQ)},
    {"CMP_GE", static_cast<long>(cv::CMP_GE)},
    {"CMP_GT", static_cast<long>(cv::CMP_GT)},
    {"CMP_LE", static_cast<long>(cv::CMP_LE)},
    {"CMP_LT", static_cast<long>(cv::CMP_LT)},
    {"CMP_NE", static_cast<long>(cv::CMP_NE)},
    {"COLORMAP_AUTUMN", static_cast<long>(cv::COLORMAP_AUTUMN)},
    {"COLORMAP_BONE", static_cast<long>(cv::COLORMAP_BONE)},
    {"COLORMAP_CIVIDIS", static_cast<long>(cv::COLORMAP_CIVIDIS)},
    {"COLORMAP_COOL", static_cast<long>(cv::COLORMAP_COOL)},
    {"COLORMAP_DEEPGREEN", static_cast<long>(cv::COLORMAP_DEEPGREEN)},
    {"COLORMAP_HOT", static_cast<long>(cv::COLORMAP_HOT)},
    {"COLORMAP_HSV", static_cast<long>(cv::COLORMAP_HSV)},
    {"COLORMAP_INFERNO", static_cast<long>(cv::COLORMAP_INFERNO)},
    {"COLORMAP_JET", static_cast<long>(cv::COLORMAP_JET)},
    {"COLORMAP_MAGMA", static_cast<long>(cv::COLORMAP_MAGMA)},
    {"COLORMAP_OCEAN", static_cast<long>(cv::COLORMAP_OCEAN)},
    {"COLORMAP_PARULA", static_cast<long>(cv::COLORMAP_PARULA)},
    {"COLORMAP_PINK", static_cast<long>(cv::COLORMAP_PINK)},
    {"COLORMAP_PLASMA", static_cast<long>(cv::COLORMAP_PLASMA)},
    {"COLORMAP_RAINBOW", static_cast<long>(cv::COLORMAP_RAINBOW)},
    {"COLORMAP_SPRING", static_cast<long>(cv::COLORMAP_SPRING)},
    {"COLORMAP_SUMMER", static_cast<long>(cv::COLORMAP_SUMMER)},
    {"COLORMAP_TURBO", static_cast<long>(cv::COLORMAP_TURBO)},
    {"COLORMAP_TWILIGHT", static_cast<long>(cv::COLORMAP_TWILIGHT)},
    {"COLORMAP_TWILIGHT_SHIFTED", static_cast<long>(cv::COLORMAP_TWILIGHT_SHIFTED)},
    {"COLORMAP_VIRIDIS", static_cast<long>(cv::COLORMAP_VIRIDIS)},
    {"COLORMAP_WINTER", static_cast<long>(cv::COLORMAP_WINTER)},
    {"COLOR_BGR2BGR555", static_cast<long>(cv::COLOR_BGR2BGR555)},
    {"COLOR_BGR2BGR565", static_cast<long>(cv::COLOR_BGR2BGR565)},
    {"COLOR_BGR2BGRA", static_cast<long>(cv::COLOR_BGR2BGRA)},
    {"COLOR_BGR2GRAY", static_cast<long>(cv::COLOR_BGR2GRAY)},
    {"COLOR_BGR2HLS", static_cast<long>(cv::COLOR_BGR2HLS)},
    {"COLOR_BGR2HLS_FULL", static_cast<long>(cv::COLOR_BGR2HLS_FULL)},
    {"COLOR_BGR2HSV", static_cast<long>(cv::COLOR_BGR2HSV)},
    {"COLOR_BGR2HSV_FULL", static_cast<long>(cv::COLOR_BGR2HSV_FULL)},
    {"COLOR_BGR2Lab", static_cast<long>(cv::COLOR_BGR2Lab)},
    {"COLOR_BGR2LAB", static_cast<long>(cv::COLOR_BGR2Lab)},
    {"COLOR_BGR2Luv", static_cast<long>(cv::COLOR_BGR2Luv)},
    {"COLOR_BGR2LUV", static_cast<long>(cv::COLOR_BGR2Luv)},
    {"COLOR_BGR2RGB", static_cast<long>(cv::COLOR_BGR2RGB)},
    {"COLOR_BGR2RGBA", static_cast<long>(cv::COLOR_BGR2RGBA)},
    {"COLOR_BGR2XYZ", static_cast<long>(cv::COLOR_BGR2XYZ)},
    {"COLOR_BGR2YCrCb", static_cast<long>(cv::COLOR_BGR2YCrCb)},
    {"COLOR_BGR2YCR_CB", static_cast<long>(cv::COLOR_BGR2YCrCb)},
    {"COLOR_BGR2YUV", static_cast<long>(cv::COLOR_BGR2YUV)},
    {"COLOR_BGR2YUV_I420", static_cast<long>(cv::COLOR_BGR2YUV_I420)},
    {"COLOR_BGR2YUV_IYUV", static_cast<long>(cv::COLOR_BGR2YUV_IYUV)},
    {"COLOR_BGR2YUV_UYNV", static_cast<long>(cv::COLOR_BGR2YUV_UYNV)},
    {"COLOR_BGR2YUV_UYVY", static_cast<long>(cv::COLOR_BGR2YUV_UYVY)},
    {"COLOR_BGR2YUV_Y422", static_cast<long>(cv::COLOR_BGR2YUV_Y422)},
    {"COLOR_BGR2YUV_YUNV", static_cast<long>(cv::COLOR_BGR2YUV_YUNV)},
    {"COLOR_BGR2YUV_YUY2", static_cast<long>(cv::COLOR_BGR2YUV_YUY2)},
    {"COLOR_BGR2YUV_YUYV", static_cast<long>(cv::COLOR_BGR2YUV_YUYV)},
    {"COLOR_BGR2YUV_YV12", static_cast<long>(cv::COLOR_BGR2YUV_YV12)},
    {"COLOR_BGR2YUV_YVYU", static_cast<long>(cv::COLOR_BGR2YUV_YVYU)},
    {"COLOR_BGR5552BGR", static_cast<long>(cv::COLOR_BGR5552BGR)},
    {"COLOR_BGR5552BGRA", static_cast<long>(cv::COLOR_BGR5552BGRA)},
    {"COLOR_BGR5552GRAY", static_cast<long>(cv::COLOR_BGR5552GRAY)},
    {"COLOR_BGR5552RGB", static_cast<long>(cv::COLOR_BGR5552RGB)},
    {"COLOR_BGR5552RGBA", static_cast<long>(cv::COLOR_BGR5552RGBA)},
    {"COLOR_BGR5652BGR", static_cast<long>(cv::COLOR_BGR5652BGR)},
    {"COLOR_BGR5652BGRA", static_cast<long>(cv::COLOR_BGR5652BGRA)},
    {"COLOR_BGR5652GRAY", static_cast<long>(cv::COLOR_BGR5652GRAY)},
    {"COLOR_BGR5652RGB", static_cast<long>(cv::COLOR_BGR5652RGB)},
    {"COLOR_BGR5652RGBA", static_cast<long>(cv::COLOR_BGR5652RGBA)},
    {"COLOR_BGRA2BGR", static_cast<long>(cv::COLOR_BGRA2BGR)},
    {"COLOR_BGRA2BGR555", static_cast<long>(cv::COLOR_BGRA2BGR555)},
    {"COLOR_BGRA2BGR565", static_cast<long>(cv::COLOR_BGRA2BGR565)},
    {"COLOR_BGRA2GRAY", static_cast<long>(cv::COLOR_BGRA2GRAY)},
    {"COLOR_BGRA2RGB", static_cast<long>(cv::COLOR_BGRA2RGB)},
    {"COLOR_BGRA2RGBA", static_cast<long>(cv::COLOR_BGRA2RGBA)},
    {"COLOR_BGRA2YUV_I420", static_cast<long>(cv::COLOR_BGRA2YUV_I420)},
    {"COLOR_BGRA2YUV_IYUV", static_cast<long>(cv::COLOR_BGRA2YUV_IYUV)},
    {"COLOR_BGRA2YUV_UYNV", static_cast<long>(cv::COLOR_BGRA2YUV_UYNV)},
    {"COLOR_BGRA2YUV_UYVY", static_cast<long>(cv::COLOR_BGRA2YUV_UYVY)},
    {"COLOR_BGRA2YUV_Y422", static_cast<long>(cv::COLOR_BGRA2YUV_Y422)},
    {"COLOR_BGRA2YUV_YUNV", static_cast<long>(cv::COLOR_BGRA2YUV_YUNV)},
    {"COLOR_BGRA2YUV_YUY2", static_cast<long>(cv::COLOR_BGRA2YUV_YUY2)},
    {"COLOR_BGRA2YUV_YUYV", static_cast<long>(cv::COLOR_BGRA2YUV_YUYV)},
    {"COLOR_BGRA2YUV_YV12", static_cast<long>(cv::COLOR_BGRA2YUV_YV12)},
    {"COLOR_BGRA2YUV_YVYU", static_cast<long>(cv::COLOR_BGRA2YUV_YVYU)},
    {"COLOR_BayerBG2BGR", static_cast<long>(cv::COLOR_BayerBG2BGR)},
    {"COLOR_BAYER_BG2BGR", static_cast<long>(cv::COLOR_BayerBG2BGR)},
    {"COLOR_BayerBG2BGRA", static_cast<long>(cv::COLOR_BayerBG2BGRA)},
    {"COLOR_BAYER_BG2BGRA", static_cast<long>(cv::COLOR_BayerBG2BGRA)},
    {"COLOR_BayerBG2BGR_EA", static_cast<long>(cv::COLOR_BayerBG2BGR_EA)},
    {"COLOR_BAYER_BG2BGR_EA", static_cast<long>(cv::COLOR_BayerBG2BGR_EA)},
    {"COLOR_BayerBG2BGR_VNG", static_cast<long>(cv::COLOR_BayerBG2BGR_VNG)},
    {"COLOR_BAYER_BG2BGR_VNG", static_cast<long>(cv::COLOR_BayerBG2BGR_VNG)},
    {"COLOR_BayerBG2GRAY", static_cast<long>(cv::COLOR_BayerBG2GRAY)},
    {"COLOR_BAYER_BG2GRAY", static_cast<long>(cv::COLOR_BayerBG2GRAY)},
    {"COLOR_BayerBG2RGB", static_cast<long>(cv::COLOR_BayerBG2RGB)},
    {"COLOR_BAYER_BG2RGB", static_cast<long>(cv::COLOR_BayerBG2RGB)},
    {"COLOR_BayerBG2RGBA", static_cast<long>(cv::COLOR_BayerBG2RGBA)},
    {"COLOR_BAYER_BG2RGBA", static_cast<long>(cv::COLOR_BayerBG2RGBA)},
    {"COLOR_BayerBG2RGB_EA", static_cast<long>(cv::COLOR_BayerBG2RGB_EA)},
    {"COLOR_BAYER_BG2RGB_EA", static_cast<long>(cv::COLOR_BayerBG2RGB_EA)},
    {"COLOR_BayerBG2RGB_VNG", static_cast<long>(cv::COLOR_BayerBG2RGB_VNG)},
    {"COLOR_BAYER_BG2RGB_VNG", static_cast<long>(cv::COLOR_BayerBG2RGB_VNG)},
    {"COLOR_BayerBGGR2BGR", static_cast<long>(cv::COLOR_BayerBGGR2BGR)},
    {"COLOR_BAYER_BGGR2BGR", static_cast<long>(cv::COLOR_BayerBGGR2BGR)},
    {"COLOR_BayerBGGR2BGRA", static_cast<long>(cv::COLOR_BayerBGGR2BGRA)},
    {"COLOR_BAYER_BGGR2BGRA", static_cast<long>(cv::COLOR_BayerBGGR2BGRA)},
    {"COLOR_BayerBGGR2BGR_EA", static_cast<long>(cv::COLOR_BayerBGGR2BGR_EA)},
    {"COLOR_BAYER_BGGR2BGR_EA", static_cast<long>(cv::COLOR_BayerBGGR2BGR_EA)},
    {"COLOR_BayerBGGR2BGR_VNG", static_cast<long>(cv::COLOR_BayerBGGR2BGR_VNG)},
    {"COLOR_BAYER_BGGR2BGR_VNG", static_cast<long>(cv::COLOR_BayerBGGR2BGR_VNG)},
    {"COLOR_BayerBGGR2GRAY", static_cast<long>(cv::COLOR_BayerBGGR2GRAY)},
    {"COLOR_BAYER_BGGR2GRAY", static_cast<long>(cv::COLOR_BayerBGGR2GRAY)},
    {"COLOR_BayerBGGR2RGB", static_cast<long>(cv::COLOR_BayerBGGR2RGB)},
    {"COLOR_BAYER_BGGR2RGB", static_cast<long>(cv::COLOR_BayerBGGR2RGB)},
    {"COLOR_BayerBGGR2RGBA", static_cast<long>(cv::COLOR_BayerBGGR2RGBA)},
    {"COLOR_BAYER_BGGR2RGBA", static_cast<long>(cv::COLOR_BayerBGGR2RGBA)},
    {"COLOR_BayerBGGR2RGB_EA", static_cast<long>(cv::COLOR_BayerBGGR2RGB_EA)},
    {"COLOR_BAYER_BGGR2RGB_EA", static_cast<long>(cv::COLOR_BayerBGGR2RGB_EA)},
    {"COLOR_BayerBGGR2RGB_VNG", static_cast<long>(cv::COLOR_BayerBGGR2RGB_VNG)},
    {"COLOR_BAYER_BGGR2RGB_VNG", static_cast<long>(cv::COLOR_BayerBGGR2RGB_VNG)},
    {"COLOR_BayerGB2BGR", static_cast<long>(cv::COLOR_BayerGB2BGR)},
    {"COLOR_BAYER_GB2BGR", static_cast<long>(cv::COLOR_BayerGB2BGR)},
    {"COLOR_BayerGB2BGRA", static_cast<long>(cv::COLOR_BayerGB2BGRA)},
    {"COLOR_BAYER_GB2BGRA", static_cast<long>(cv::COLOR_BayerGB2BGRA)},
    {"COLOR_BayerGB2BGR_EA", static_cast<long>(cv::COLOR_BayerGB2BGR_EA)},
    {"COLOR_BAYER_GB2BGR_EA", static_cast<long>(cv::COLOR_BayerGB2BGR_EA)},
    {"COLOR_BayerGB2BGR_VNG", static_cast<long>(cv::COLOR_BayerGB2BGR_VNG)},
    {"COLOR_BAYER_GB2BGR_VNG", static_cast<long>(cv::COLOR_BayerGB2BGR_VNG)},
    {"COLOR_BayerGB2GRAY", static_cast<long>(cv::COLOR_BayerGB2GRAY)},
    {"COLOR_BAYER_GB2GRAY", static_cast<long>(cv::COLOR_BayerGB2GRAY)},
    {"COLOR_BayerGB2RGB", static_cast<long>(cv::COLOR_BayerGB2RGB)},
    {"COLOR_BAYER_GB2RGB", static_cast<long>(cv::COLOR_BayerGB2RGB)},
    {"COLOR_BayerGB2RGBA", static_cast<long>(cv::COLOR_BayerGB2RGBA)},
    {"COLOR_BAYER_GB2RGBA", static_cast<long>(cv::COLOR_BayerGB2RGBA)},
    {"COLOR_BayerGB2RGB_EA", static_cast<long>(cv::COLOR_BayerGB2RGB_EA)},
    {"COLOR_BAYER_GB2RGB_EA", static_cast<long>(cv::COLOR_BayerGB2RGB_EA)},
    {"COLOR_BayerGB2RGB_VNG", static_cast<long>(cv::COLOR_BayerGB2RGB_VNG)},
    {"COLOR_BAYER_GB2RGB_VNG", static_cast<long>(cv::COLOR_BayerGB2RGB_VNG)},
    {"COLOR_BayerGBRG2BGR", static_cast<long>(cv::COLOR_BayerGBRG2BGR)},
    {"COLOR_BAYER_GBRG2BGR", static_cast<long>(cv::COLOR_BayerGBRG2BGR)},
    {"COLOR_BayerGBRG2BGRA", static_cast<long>(cv::COLOR_BayerGBRG2BGRA)},
    {"COLOR_BAYER_GBRG2BGRA", static_cast<long>(cv::COLOR_BayerGBRG2BGRA)},
    {"COLOR_BayerGBRG2BGR_EA", static_cast<long>(cv::COLOR_BayerGBRG2BGR_EA)},
    {"COLOR_BAYER_GBRG2BGR_EA", static_cast<long>(cv::COLOR_BayerGBRG2BGR_EA)},
    {"COLOR_BayerGBRG2BGR_VNG", static_cast<long>(cv::COLOR_BayerGBRG2BGR_VNG)},
    {"COLOR_BAYER_GBRG2BGR_VNG", static_cast<long>(cv::COLOR_BayerGBRG2BGR_VNG)},
    {"COLOR_BayerGBRG2GRAY", static_cast<long>(cv::COLOR_BayerGBRG2GRAY)},
    {"COLOR_BAYER_GBRG2GRAY", static_cast<long>(cv::COLOR_BayerGBRG2GRAY)},
    {"COLOR_BayerGBRG2RGB", static_cast<long>(cv::COLOR_BayerGBRG2RGB)},
    {"COLOR_BAYER_GBRG2RGB", static_cast<long>(cv::COLOR_BayerGBRG2RGB)},
    {"COLOR_BayerGBRG2RGBA", static_cast<long>(cv::COLOR_BayerGBRG2RGBA)},
    {"COLOR_BAYER_GBRG2RGBA", static_cast<long>(cv::COLOR_BayerGBRG2RGBA)},
    {"COLOR_BayerGBRG2RGB_EA", static_cast<long>(cv::COLOR_BayerGBRG2RGB_EA)},
    {"COLOR_BAYER_GBRG2RGB_EA", static_cast<long>(cv::COLOR_BayerGBRG2RGB_EA)},
    {"COLOR_BayerGBRG2RGB_VNG", static_cast<long>(cv::COLOR_BayerGBRG2RGB_VNG)},
    {"COLOR_BAYER_GBRG2RGB_VNG", static_cast<long>(cv::COLOR_BayerGBRG2RGB_VNG)},
    {"COLOR_BayerGR2BGR", static_cast<long>(cv::COLOR_BayerGR2BGR)},
    {"COLOR_BAYER_GR2BGR", static_cast<long>(cv::COLOR_BayerGR2BGR)},
    {"COLOR_BayerGR2BGRA", static_cast<long>(cv::COLOR_BayerGR2BGRA)},
    {"COLOR_BAYER_GR2BGRA", static_cast<long>(cv::COLOR_BayerGR2BGRA)},
    {"COLOR_BayerGR2BGR_EA", static_cast<long>(cv::COLOR_BayerGR2BGR_EA)},
    {"COLOR_BAYER_GR2BGR_EA", static_cast<long>(cv::COLOR_BayerGR2BGR_EA)},
    {"COLOR_BayerGR2BGR_VNG", static_cast<long>(cv::COLOR_BayerGR2BGR_VNG)},
    {"COLOR_BAYER_GR2BGR_VNG", static_cast<long>(cv::COLOR_BayerGR2BGR_VNG)},
    {"COLOR_BayerGR2GRAY", static_cast<long>(cv::COLOR_BayerGR2GRAY)},
    {"COLOR_BAYER_GR2GRAY", static_cast<long>(cv::COLOR_BayerGR2GRAY)},
    {"COLOR_BayerGR2RGB", static_cast<long>(cv::COLOR_BayerGR2RGB)},
    {"COLOR_BAYER_GR2RGB", static_cast<long>(cv::COLOR_BayerGR2RGB)},
    {"COLOR_BayerGR2RGBA", static_cast<long>(cv::COLOR_BayerGR2RGBA)},
    {"COLOR_BAYER_GR2RGBA", static_cast<long>(cv::COLOR_BayerGR2RGBA)},
    {"COLOR_BayerGR2RGB_EA", static_cast<long>(cv::COLOR_BayerGR2RGB_EA)},
    {"COLOR_BAYER_GR2RGB_EA", static_cast<long>(cv::COLOR_BayerGR2RGB_EA)},
    {"COLOR_BayerGR2RGB_VNG", static_cast<long>(cv::COLOR_BayerGR2RGB_VNG)},
    {"COLOR_BAYER_GR2RGB_VNG", static_cast<long>(cv::COLOR_BayerGR2RGB_VNG)},
    {"COLOR_BayerGRBG2BGR", static_cast<long>(cv::COLOR_BayerGRBG2BGR)},
    {"COLOR_BAYER_GRBG2BGR", static_cast<long>(cv::COLOR_BayerGRBG2BGR)},
    {"COLOR_BayerGRBG2BGRA", static_cast<long>(cv::COLOR_BayerGRBG2BGRA)},
    {"COLOR_BAYER_GRBG2BGRA", static_cast<long>(cv::COLOR_BayerGRBG2BGRA)},
    {"COLOR_BayerGRBG2BGR_EA", static_cast<long>(cv::COLOR_BayerGRBG2BGR_EA)},
    {"COLOR_BAYER_GRBG2BGR_EA", static_cast<long>(cv::COLOR_BayerGRBG2BGR_EA)},
    {"COLOR_BayerGRBG2BGR_VNG", static_cast<long>(cv::COLOR_BayerGRBG2BGR_VNG)},
    {"COLOR_BAYER_GRBG2BGR_VNG", static_cast<long>(cv::COLOR_BayerGRBG2BGR_VNG)},
    {"COLOR_BayerGRBG2GRAY", static_cast<long>(cv::COLOR_BayerGRBG2GRAY)},
    {"COLOR_BAYER_GRBG2GRAY", static_cast<long>(cv::COLOR_BayerGRBG2GRAY)},
    {"COLOR_BayerGRBG2RGB", static_cast<long>(cv::COLOR_BayerGRBG2RGB)},
    {"COLOR_BAYER_GRBG2RGB", static_cast<long>(cv::COLOR_BayerGRBG2RGB)},
    {"COLOR_BayerGRBG2RGBA", static_cast<long>(cv::COLOR_BayerGRBG2RGBA)},
    {"COLOR_BAYER_GRBG2RGBA", static_cast<long>(cv::COLOR_BayerGRBG2RGBA)},
    {"COLOR_BayerGRBG2RGB_EA", static_cast<long>(cv::COLOR_BayerGRBG2RGB_EA)},
    {"COLOR_BAYER_GRBG2RGB_EA", static_cast<long>(cv::COLOR_BayerGRBG2RGB_EA)},
    {"COLOR_BayerGRBG2RGB_VNG", static_cast<long>(cv::COLOR_BayerGRBG2RGB_VNG)},
    {"COLOR_BAYER_GRBG2RGB_VNG", static_cast<long>(cv::COLOR_BayerGRBG2RGB_VNG)},
    {"COLOR_BayerRG2BGR", static_cast<long>(cv::COLOR_BayerRG2BGR)},
    {"COLOR_BAYER_RG2BGR", static_cast<long>(cv::COLOR_BayerRG2BGR)},
    {"COLOR_BayerRG2BGRA", static_cast<long>(cv::COLOR_BayerRG2BGRA)},
    {"COLOR_BAYER_RG2BGRA", static_cast<long>(cv::COLOR_BayerRG2BGRA)},
    {"COLOR_BayerRG2BGR_EA", static_cast<long>(cv::COLOR_BayerRG2BGR_EA)},
    {"COLOR_BAYER_RG2BGR_EA", static_cast<long>(cv::COLOR_BayerRG2BGR_EA)},
    {"COLOR_BayerRG2BGR_VNG", static_cast<long>(cv::COLOR_BayerRG2BGR_VNG)},
    {"COLOR_BAYER_RG2BGR_VNG", static_cast<long>(cv::COLOR_BayerRG2BGR_VNG)},
    {"COLOR_BayerRG2GRAY", static_cast<long>(cv::COLOR_BayerRG2GRAY)},
    {"COLOR_BAYER_RG2GRAY", static_cast<long>(cv::COLOR_BayerRG2GRAY)},
    {"COLOR_BayerRG2RGB", static_cast<long>(cv::COLOR_BayerRG2RGB)},
    {"COLOR_BAYER_RG2RGB", static_cast<long>(cv::COLOR_BayerRG2RGB)},
    {"COLOR_BayerRG2RGBA", static_cast<long>(cv::COLOR_BayerRG2RGBA)},
    {"COLOR_BAYER_RG2RGBA", static_cast<long>(cv::COLOR_BayerRG2RGBA)},
    {"COLOR_BayerRG2RGB_EA", static_cast<long>(cv::COLOR_BayerRG2RGB_EA)},
    {"COLOR_BAYER_RG2RGB_EA", static_cast<long>(cv::COLOR_BayerRG2RGB_EA)},
    {"COLOR_BayerRG2RGB_VNG", static_cast<long>(cv::COLOR_BayerRG2RGB_VNG)},
    {"COLOR_BAYER_RG2RGB_VNG", static_cast<long>(cv::COLOR_BayerRG2RGB_VNG)},
    {"COLOR_BayerRGGB2BGR", static_cast<long>(cv::COLOR_BayerRGGB2BGR)},
    {"COLOR_BAYER_RGGB2BGR", static_cast<long>(cv::COLOR_BayerRGGB2BGR)},
    {"COLOR_BayerRGGB2BGRA", static_cast<long>(cv::COLOR_BayerRGGB2BGRA)},
    {"COLOR_BAYER_RGGB2BGRA", static_cast<long>(cv::COLOR_BayerRGGB2BGRA)},
    {"COLOR_BayerRGGB2BGR_EA", static_cast<long>(cv::COLOR_BayerRGGB2BGR_EA)},
    {"COLOR_BAYER_RGGB2BGR_EA", static_cast<long>(cv::COLOR_BayerRGGB2BGR_EA)},
    {"COLOR_BayerRGGB2BGR_VNG", static_cast<long>(cv::COLOR_BayerRGGB2BGR_VNG)},
    {"COLOR_BAYER_RGGB2BGR_VNG", static_cast<long>(cv::COLOR_BayerRGGB2BGR_VNG)},
    {"COLOR_BayerRGGB2GRAY", static_cast<long>(cv::COLOR_BayerRGGB2GRAY)},
    {"COLOR_BAYER_RGGB2GRAY", static_cast<long>(cv::COLOR_BayerRGGB2GRAY)},
    {"COLOR_BayerRGGB2RGB", static_cast<long>(cv::COLOR_BayerRGGB2RGB)},
    {"COLOR_BAYER_RGGB2RGB", static_cast<long>(cv::COLOR_BayerRGGB2RGB)},
    {"COLOR_BayerRGGB2RGBA", static_cast<long>(cv::COLOR_BayerRGGB2RGBA)},
    {"COLOR_BAYER_RGGB2RGBA", static_cast<long>(cv::COLOR_BayerRGGB2RGBA)},
    {"COLOR_BayerRGGB2RGB_EA", static_cast<long>(cv::COLOR_BayerRGGB2RGB_EA)},
    {"COLOR_BAYER_RGGB2RGB_EA", static_cast<long>(cv::COLOR_BayerRGGB2RGB_EA)},
    {"COLOR_BayerRGGB2RGB_VNG", static_cast<long>(cv::COLOR_BayerRGGB2RGB_VNG)},
    {"COLOR_BAYER_RGGB2RGB_VNG", static_cast<long>(cv::COLOR_BayerRGGB2RGB_VNG)},
    {"COLOR_COLORCVT_MAX", static_cast<long>(cv::COLOR_COLORCVT_MAX)},
    {"COLOR_GRAY2BGR", static_cast<long>(cv::COLOR_GRAY2BGR)},
    {"COLOR_GRAY2BGR555", static_cast<long>(cv::COLOR_GRAY2BGR555)},
    {"COLOR_GRAY2BGR565", static_cast<long>(cv::COLOR_GRAY2BGR565)},
    {"COLOR_GRAY2BGRA", static_cast<long>(cv::COLOR_GRAY2BGRA)},
    {"COLOR_GRAY2RGB", static_cast<long>(cv::COLOR_GRAY2RGB)},
    {"COLOR_GRAY2RGBA", static_cast<long>(cv::COLOR_GRAY2RGBA)},
    {"COLOR_HLS2BGR", static_cast<long>(cv::COLOR_HLS2BGR)},
    {"COLOR_HLS2BGR_FULL", static_cast<long>(cv::COLOR_HLS2BGR_FULL)},
    {"COLOR_HLS2RGB", static_cast<long>(cv::COLOR_HLS2RGB)},
    {"COLOR_HLS2RGB_FULL", static_cast<long>(cv::COLOR_HLS2RGB_FULL)},
    {"COLOR_HSV2BGR", static_cast<long>(cv::COLOR_HSV2BGR)},
    {"COLOR_HSV2BGR_FULL", static_cast<long>(cv::COLOR_HSV2BGR_FULL)},
    {"COLOR_HSV2RGB", static_cast<long>(cv::COLOR_HSV2RGB)},
    {"COLOR_HSV2RGB_FULL", static_cast<long>(cv::COLOR_HSV2RGB_FULL)},
    {"COLOR_LBGR2Lab", static_cast<long>(cv::COLOR_LBGR2Lab)},
    {"COLOR_LBGR2LAB", static_cast<long>(cv::COLOR_LBGR2Lab)},
    {"COLOR_LBGR2Luv", static_cast<long>(cv::COLOR_LBGR2Luv)},
    {"COLOR_LBGR2LUV", static_cast<long>(cv::COLOR_LBGR2Luv)},
    {"COLOR_LRGB2Lab", static_cast<long>(cv::COLOR_LRGB2Lab)},
    {"COLOR_LRGB2LAB", static_cast<long>(cv::COLOR_LRGB2Lab)},
    {"COLOR_LRGB2Luv", static_cast<long>(cv::COLOR_LRGB2Luv)},
    {"COLOR_LRGB2LUV", static_cast<long>(cv::COLOR_LRGB2Luv)},
    {"COLOR_Lab2BGR", static_cast<long>(cv::COLOR_Lab2BGR)},
    {"COLOR_LAB2BGR", static_cast<long>(cv::COLOR_Lab2BGR)},
    {"COLOR_Lab2LBGR", static_cast<long>(cv::COLOR_Lab2LBGR)},
    {"COLOR_LAB2LBGR", static_cast<long>(cv::COLOR_Lab2LBGR)},
    {"COLOR_Lab2LRGB", static_cast<long>(cv::COLOR_Lab2LRGB)},
    {"COLOR_LAB2LRGB", static_cast<long>(cv::COLOR_Lab2LRGB)},
    {"COLOR_Lab2RGB", static_cast<long>(cv::COLOR_Lab2RGB)},
    {"COLOR_LAB2RGB", static_cast<long>(cv::COLOR_Lab2RGB)},
    {"COLOR_Luv2BGR", static_cast<long>(cv::COLOR_Luv2BGR)},
    {"COLOR_LUV2BGR", static_cast<long>(cv::COLOR_Luv2BGR)},
    {"COLOR_Luv2LBGR", static_cast<long>(cv::COLOR_Luv2LBGR)},
    {"COLOR_LUV2LBGR", static_cast<long>(cv::COLOR_Luv2LBGR)},
    {"COLOR_Luv2LRGB", static_cast<long>(cv::COLOR_Luv2LRGB)},
    {"COLOR_LUV2LRGB", static_cast<long>(cv::COLOR_Luv2LRGB)},
    {"COLOR_Luv2RGB", static_cast<long>(cv::COLOR_Luv2RGB)},
    {"COLOR_LUV2RGB", static_cast<long>(cv::COLOR_Luv2RGB)},
    {"COLOR_RGB2BGR", static_cast<long>(cv::COLOR_RGB2BGR)},
    {"COLOR_RGB2BGR555", static_cast<long>(cv::COLOR_RGB2BGR555)},
    {"COLOR_RGB2BGR565", static_cast<long>(cv::COLOR_RGB2BGR565)},
    {"COLOR_RGB2BGRA", static_cast<long>(cv::COLOR_RGB2BGRA)},
    {"COLOR_RGB2GRAY", static_cast<long>(cv::COLOR_RGB2GRAY)},
    {"COLOR_RGB2HLS", static_cast<long>(cv::COLOR_RGB2HLS)},
    {"COLOR_RGB2HLS_FULL", static_cast<long>(cv::COLOR_RGB2HLS_FULL)},
    {"COLOR_RGB2HSV", static_cast<long>(cv::COLOR_RGB2HSV)},
    {"COLOR_RGB2HSV_FULL", static_cast<long>(cv::COLOR_RGB2HSV_FULL)},
    {"COLOR_RGB2Lab", static_cast<long>(cv::COLOR_RGB2Lab)},
    {"COLOR_RGB2LAB", static_cast<long>(cv::COLOR_RGB2Lab)},
    {"COLOR_RGB2Luv", static_cast<long>(cv::COLOR_RGB2Luv)},
    {"COLOR_RGB2LUV", static_cast<long>(cv::COLOR_RGB2Luv)},
    {"COLOR_RGB2RGBA", static_cast<long>(cv::COLOR_RGB2RGBA)},
    {"COLOR_RGB2XYZ", static_cast<long>(cv::COLOR_RGB2XYZ)},
    {"COLOR_RGB2YCrCb", static_cast<long>(cv::COLOR_RGB2YCrCb)},
    {"COLOR_RGB2YCR_CB", static_cast<long>(cv::COLOR_RGB2YCrCb)},
    {"COLOR_RGB2YUV", static_cast<long>(cv::COLOR_RGB2YUV)},
    {"COLOR_RGB2YUV_I420", static_cast<long>(cv::COLOR_RGB2YUV_I420)},
    {"COLOR_RGB2YUV_IYUV", static_cast<long>(cv::COLOR_RGB2YUV_IYUV)},
    {"COLOR_RGB2YUV_UYNV", static_cast<long>(cv::COLOR_RGB2YUV_UYNV)},
    {"COLOR_RGB2YUV_UYVY", static_cast<long>(cv::COLOR_RGB2YUV_UYVY)},
    {"COLOR_RGB2YUV_Y422", static_cast<long>(cv::COLOR_RGB2YUV_Y422)},
    {"COLOR_RGB2YUV_YUNV", static_cast<long>(cv::COLOR_RGB2YUV_YUNV)},
    {"COLOR_RGB2YUV_YUY2", static_cast<long>(cv::COLOR_RGB2YUV_YUY2)},
    {"COLOR_RGB2YUV_YUYV", static_cast<long>(cv::COLOR_RGB2YUV_YUYV)},
    {"COLOR_RGB2YUV_YV12", static_cast<long>(cv::COLOR_RGB2YUV_YV12)},
    {"COLOR_RGB2YUV_YVYU", static_cast<long>(cv::COLOR_RGB2YUV_YVYU)},
    {"COLOR_RGBA2BGR", static_cast<long>(cv::COLOR_RGBA2BGR)},
    {"COLOR_RGBA2BGR555", static_cast<long>(cv::COLOR_RGBA2BGR555)},
    {"COLOR_RGBA2BGR565", static_cast<long>(cv::COLOR_RGBA2BGR565)},
    {"COLOR_RGBA2BGRA", static_cast<long>(cv::COLOR_RGBA2BGRA)},
    {"COLOR_RGBA2GRAY", static_cast<long>(cv::COLOR_RGBA2GRAY)},
    {"COLOR_RGBA2RGB", static_cast<long>(cv::COLOR_RGBA2RGB)},
    {"COLOR_RGBA2YUV_I420", static_cast<long>(cv::COLOR_RGBA2YUV_I420)},
    {"COLOR_RGBA2YUV_IYUV", static_cast<long>(cv::COLOR_RGBA2YUV_IYUV)},
    {"COLOR_RGBA2YUV_UYNV", static_cast<long>(cv::COLOR_RGBA2YUV_UYNV)},
    {"COLOR_RGBA2YUV_UYVY", static_cast<long>(cv::COLOR_RGBA2YUV_UYVY)},
    {"COLOR_RGBA2YUV_Y422", static_cast<long>(cv::COLOR_RGBA2YUV_Y422)},
    {"COLOR_RGBA2YUV_YUNV", static_cast<long>(cv::COLOR_RGBA2YUV_YUNV)},
    {"COLOR_RGBA2YUV_YUY2", static_cast<long>(cv::COLOR_RGBA2YUV_YUY2)},
    {"COLOR_RGBA2YUV_YUYV", static_cast<long>(cv::COLOR_RGBA2YUV_YUYV)},
    {"COLOR_RGBA2YUV_YV12", static_cast<long>(cv::COLOR_RGBA2YUV_YV12)},
    {"COLOR_RGBA2YUV_YVYU", static_cast<long>(cv::COLOR_RGBA2YUV_YVYU)},
    {"COLOR_RGBA2mRGBA", static_cast<long>(cv::COLOR_RGBA2mRGBA)},
    {"COLOR_RGBA2M_RGBA", static_cast<long>(cv::COLOR_RGBA2mRGBA)},
    {"COLOR_XYZ2BGR", static_cast<long>(cv::COLOR_XYZ2BGR)},
    {"COLOR_XYZ2RGB", static_cast<long>(cv::COLOR_XYZ2RGB)},
    {"COLOR_YCrCb2BGR", static_cast<long>(cv::COLOR_YCrCb2BGR)},
    {"COLOR_YCR_CB2BGR", static_cast<long>(cv::COLOR_YCrCb2BGR)},
    {"COLOR_YCrCb2RGB", static_cast<long>(cv::COLOR_YCrCb2RGB)},
    {"COLOR_YCR_CB2RGB", static_cast<long>(cv::COLOR_YCrCb2RGB)},
    {"COLOR_YUV2BGR", static_cast<long>(cv::COLOR_YUV2BGR)},
    {"COLOR_YUV2BGRA_I420", static_cast<long>(cv::COLOR_YUV2BGRA_I420)},
    {"COLOR_YUV2BGRA_IYUV", static_cast<long>(cv::COLOR_YUV2BGRA_IYUV)},
    {"COLOR_YUV2BGRA_NV12", static_cast<long>(cv::COLOR_YUV2BGRA_NV12)},
    {"COLOR_YUV2BGRA_NV21", static_cast<long>(cv::COLOR_YUV2BGRA_NV21)},
    {"COLOR_YUV2BGRA_UYNV", static_cast<long>(cv::COLOR_YUV2BGRA_UYNV)},
    {"COLOR_YUV2BGRA_UYVY", static_cast<long>(cv::COLOR_YUV2BGRA_UYVY)},
    {"COLOR_YUV2BGRA_Y422", static_cast<long>(cv::COLOR_YUV2BGRA_Y422)},
    {"COLOR_YUV2BGRA_YUNV", static_cast<long>(cv::COLOR_YUV2BGRA_YUNV)},
    {"COLOR_YUV2BGRA_YUY2", static_cast<long>(cv::COLOR_YUV2BGRA_YUY2)},
    {"COLOR_YUV2BGRA_YUYV", static_cast<long>(cv::COLOR_YUV2BGRA_YUYV)},
    {"COLOR_YUV2BGRA_YV12", static_cast<long>(cv::COLOR_YUV2BGRA_YV12)},
    {"COLOR_YUV2BGRA_YVYU", static_cast<long>(cv::COLOR_YUV2BGRA_YVYU)},
    {"COLOR_YUV2BGR_I420", static_cast<long>(cv::COLOR_YUV2BGR_I420)},
    {"COLOR_YUV2BGR_IYUV", static_cast<long>(cv::COLOR_YUV2BGR_IYUV)},
    {"COLOR_YUV2BGR_NV12", static_cast<long>(cv::COLOR_YUV2BGR_NV12)},
    {"COLOR_YUV2BGR_NV21", static_cast<long>(cv::COLOR_YUV2BGR_NV21)},
    {"COLOR_YUV2BGR_UYNV", static_cast<long>(cv::COLOR_YUV2BGR_UYNV)},
    {"COLOR_YUV2BGR_UYVY", static_cast<long>(cv::COLOR_YUV2BGR_UYVY)},
    {"COLOR_YUV2BGR_Y422", static_cast<long>(cv::COLOR_YUV2BGR_Y422)},
    {"COLOR_YUV2BGR_YUNV", static_cast<long>(cv::COLOR_YUV2BGR_YUNV)},
    {"COLOR_YUV2BGR_YUY2", static_cast<long>(cv::COLOR_YUV2BGR_YUY2)},
    {"COLOR_YUV2BGR_YUYV", static_cast<long>(cv::COLOR_YUV2BGR_YUYV)},
    {"COLOR_YUV2BGR_YV12", static_cast<long>(cv::COLOR_YUV2BGR_YV12)},
    {"COLOR_YUV2BGR_YVYU", static_cast<long>(cv::COLOR_YUV2BGR_YVYU)},
    {"COLOR_YUV2GRAY_420", static_cast<long>(cv::COLOR_YUV2GRAY_420)},
    {"COLOR_YUV2GRAY_I420", static_cast<long>(cv::COLOR_YUV2GRAY_I420)},
    {"COLOR_YUV2GRAY_IYUV", static_cast<long>(cv::COLOR_YUV2GRAY_IYUV)},
    {"COLOR_YUV2GRAY_NV12", static_cast<long>(cv::COLOR_YUV2GRAY_NV12)},
    {"COLOR_YUV2GRAY_NV21", static_cast<long>(cv::COLOR_YUV2GRAY_NV21)},
    {"COLOR_YUV2GRAY_UYNV", static_cast<long>(cv::COLOR_YUV2GRAY_UYNV)},
    {"COLOR_YUV2GRAY_UYVY", static_cast<long>(cv::COLOR_YUV2GRAY_UYVY)},
    {"COLOR_YUV2GRAY_Y422", static_cast<long>(cv::COLOR_YUV2GRAY_Y422)},
    {"COLOR_YUV2GRAY_YUNV", static_cast<long>(cv::COLOR_YUV2GRAY_YUNV)},
    {"COLOR_YUV2GRAY_YUY2", static_cast<long>(cv::COLOR_YUV2GRAY_YUY2)},
    {"COLOR_YUV2GRAY_YUYV", static_cast<long>(cv::COLOR_YUV2GRAY_YUYV)},
    {"COLOR_YUV2GRAY_YV12", static_cast<long>(cv::COLOR_YUV2GRAY_YV12)},
    {"COLOR_YUV2GRAY_YVYU", static_cast<long>(cv::COLOR_YUV2GRAY_YVYU)},
    {"COLOR_YUV2RGB", static_cast<long>(cv::COLOR_YUV2RGB)},
    {"COLOR_YUV2RGBA_I420", static_cast<long>(cv::COLOR_YUV2RGBA_I420)},
    {"COLOR_YUV2RGBA_IYUV", static_cast<long>(cv::COLOR_YUV2RGBA_IYUV)},
    {"COLOR_YUV2RGBA_NV12", static_cast<long>(cv::COLOR_YUV2RGBA_NV12)},
    {"COLOR_YUV2RGBA_NV21", static_cast<long>(cv::COLOR_YUV2RGBA_NV21)},
    {"COLOR_YUV2RGBA_UYNV", static_cast<long>(cv::COLOR_YUV2RGBA_UYNV)},
    {"COLOR_YUV2RGBA_UYVY", static_cast<long>(cv::COLOR_YUV2RGBA_UYVY)},
    {"COLOR_YUV2RGBA_Y422", static_cast<long>(cv::COLOR_YUV2RGBA_Y422)},
    {"COLOR_YUV2RGBA_YUNV", static_cast<long>(cv::COLOR_YUV2RGBA_YUNV)},
    {"COLOR_YUV2RGBA_YUY2", static_cast<long>(cv::COLOR_YUV2RGBA_YUY2)},
    {"COLOR_YUV2RGBA_YUYV", static_cast<long>(cv::COLOR_YUV2RGBA_YUYV)},
    {"COLOR_YUV2RGBA_YV12", static_cast<long>(cv::COLOR_YUV2RGBA_YV12)},
    {"COLOR_YUV2RGBA_YVYU", static_cast<long>(cv::COLOR_YUV2RGBA_YVYU)},
    {"COLOR_YUV2RGB_I420", static_cast<long>(cv::COLOR_YUV2RGB_I420)},
    {"COLOR_YUV2RGB_IYUV", static_cast<long>(cv::COLOR_YUV2RGB_IYUV)},
    {"COLOR_YUV2RGB_NV12", static_cast<long>(cv::COLOR_YUV2RGB_NV12)},
    {"COLOR_YUV2RGB_NV21", static_cast<long>(cv::COLOR_YUV2RGB_NV21)},
    {"COLOR_YUV2RGB_UYNV", static_cast<long>(cv::COLOR_YUV2RGB_UYNV)},
    {"COLOR_YUV2RGB_UYVY", static_cast<long>(cv::COLOR_YUV2RGB_UYVY)},
    {"COLOR_YUV2RGB_Y422", static_cast<long>(cv::COLOR_YUV2RGB_Y422)},
    {"COLOR_YUV2RGB_YUNV", static_cast<long>(cv::COLOR_YUV2RGB_YUNV)},
    {"COLOR_YUV2RGB_YUY2", static_cast<long>(cv::COLOR_YUV2RGB_YUY2)},
    {"COLOR_YUV2RGB_YUYV", static_cast<long>(cv::COLOR_YUV2RGB_YUYV)},
    {"COLOR_YUV2RGB_YV12", static_cast<long>(cv::COLOR_YUV2RGB_YV12)},
    {"COLOR_YUV2RGB_YVYU", static_cast<long>(cv::COLOR_YUV2RGB_YVYU)},
    {"COLOR_YUV420p2BGR", static_cast<long>(cv::COLOR_YUV420p2BGR)},
    {"COLOR_YUV420P2BGR", static_cast<long>(cv::COLOR_YUV420p2BGR)},
    {"COLOR_YUV420p2BGRA", static_cast<long>(cv::COLOR_YUV420p2BGRA)},
    {"COLOR_YUV420P2BGRA", static_cast<long>(cv::COLOR_YUV420p2BGRA)},
    {"COLOR_YUV420p2GRAY", static_cast<long>(cv::COLOR_YUV420p2GRAY)},
    {"COLOR_YUV420P2GRAY", static_cast<long>(cv::COLOR_YUV420p2GRAY)},
    {"COLOR_YUV420p2RGB", static_cast<long>(cv::COLOR_YUV420p2RGB)},
    {"COLOR_YUV420P2RGB", static_cast<long>(cv::COLOR_YUV420p2RGB)},
    {"COLOR_YUV420p2RGBA", static_cast<long>(cv::COLOR_YUV420p2RGBA)},
    {"COLOR_YUV420P2RGBA", static_cast<long>(cv::COLOR_YUV420p2RGBA)},
    {"COLOR_YUV420sp2BGR", static_cast<long>(cv::COLOR_YUV420sp2BGR)},
    {"COLOR_YUV420SP2BGR", static_cast<long>(cv::COLOR_YUV420sp2BGR)},
    {"COLOR_YUV420sp2BGRA", static_cast<long>(cv::COLOR_YUV420sp2BGRA)},
    {"COLOR_YUV420SP2BGRA", static_cast<long>(cv::COLOR_YUV420sp2BGRA)},
    {"COLOR_YUV420sp2GRAY", static_cast<long>(cv::COLOR_YUV420sp2GRAY)},
    {"COLOR_YUV420SP2GRAY", static_cast<long>(cv::COLOR_YUV420sp2GRAY)},
    {"COLOR_YUV420sp2RGB", static_cast<long>(cv::COLOR_YUV420sp2RGB)},
    {"COLOR_YUV420SP2RGB", static_cast<long>(cv::COLOR_YUV420sp2RGB)},
    {"COLOR_YUV420sp2RGBA", static_cast<long>(cv::COLOR_YUV420sp2RGBA)},
    {"COLOR_YUV420SP2RGBA", static_cast<long>(cv::COLOR_YUV420sp2RGBA)},
    {"COLOR_mRGBA2RGBA", static_cast<long>(cv::COLOR_mRGBA2RGBA)},
    {"COLOR_M_RGBA2RGBA", static_cast<long>(cv::COLOR_mRGBA2RGBA)},
    {"CONTOURS_MATCH_I1", static_cast<long>(cv::CONTOURS_MATCH_I1)},
    {"CONTOURS_MATCH_I2", static_cast<long>(cv::CONTOURS_MATCH_I2)},
    {"CONTOURS_MATCH_I3", static_cast<long>(cv::CONTOURS_MATCH_I3)},
    {"COVAR_COLS", static_cast<long>(cv::COVAR_COLS)},
    {"COVAR_NORMAL", static_cast<long>(cv::COVAR_NORMAL)},
    {"COVAR_ROWS", static_cast<long>(cv::COVAR_ROWS)},
    {"COVAR_SCALE", static_cast<long>(cv::COVAR_SCALE)},
    {"COVAR_SCRAMBLED", static_cast<long>(cv::COVAR_SCRAMBLED)},
    {"COVAR_USE_AVG", static_cast<long>(cv::COVAR_USE_AVG)},
    {"COV_POLISHER", static_cast<long>(cv::COV_POLISHER)},
    {"CirclesGridFinderParameters_ASYMMETRIC_GRID", static_cast<long>(cv::CirclesGridFinderParameters::ASYMMETRIC_GRID)},
    {"CIRCLES_GRID_FINDER_PARAMETERS_ASYMMETRIC_GRID", static_cast<long>(cv::CirclesGridFinderParameters::ASYMMETRIC_GRID)},
    {"CirclesGridFinderParameters_SYMMETRIC_GRID", static_cast<long>(cv::CirclesGridFinderParameters::SYMMETRIC_GRID)},
    {"CIRCLES_GRID_FINDER_PARAMETERS_SYMMETRIC_GRID", static_cast<long>(cv::CirclesGridFinderParameters::SYMMETRIC_GRID)},
    {"DCT_INVERSE", static_cast<long>(cv::DCT_INVERSE)},
    {"DCT_ROWS", static_cast<long>(cv::DCT_ROWS)},
    {"DECOMP_CHOLESKY", static_cast<long>(cv::DECOMP_CHOLESKY)},
    {"DECOMP_EIG", static_cast<long>(cv::DECOMP_EIG)},
    {"DECOMP_LU", static_cast<long>(cv::DECOMP_LU)},
    {"DECOMP_NORMAL", static_cast<long>(cv::DECOMP_NORMAL)},
    {"DECOMP_QR", static_cast<long>(cv::DECOMP_QR)},
    {"DECOMP_SVD", static_cast<long>(cv::DECOMP_SVD)},
    {"DFT_COMPLEX_INPUT", static_cast<long>(cv::DFT_COMPLEX_INPUT)},
    {"DFT_COMPLEX_OUTPUT", static_cast<long>(cv::DFT_COMPLEX_OUTPUT)},
    {"DFT_INVERSE", static_cast<long>(cv::DFT_INVERSE)},
    {"DFT_REAL_OUTPUT", static_cast<long>(cv::DFT_REAL_OUTPUT)},
    {"DFT_ROWS", static_cast<long>(cv::DFT_ROWS)},
    {"DFT_SCALE", static_cast<long>(cv::DFT_SCALE)},
    {"DISOpticalFlow_PRESET_FAST", static_cast<long>(cv::DISOpticalFlow::PRESET_FAST)},
    {"DISOPTICAL_FLOW_PRESET_FAST", static_cast<long>(cv::DISOpticalFlow::PRESET_FAST)},
    {"DISOpticalFlow_PRESET_MEDIUM", static_cast<long>(cv::DISOpticalFlow::PRESET_MEDIUM)},
    {"DISOPTICAL_FLOW_PRESET_MEDIUM", static_cast<long>(cv::DISOpticalFlow::PRESET_MEDIUM)},
    {"DISOpticalFlow_PRESET_ULTRAFAST", static_cast<long>(cv::DISOpticalFlow::PRESET_ULTRAFAST)},
    {"DISOPTICAL_FLOW_PRESET_ULTRAFAST", static_cast<long>(cv::DISOpticalFlow::PRESET_ULTRAFAST)},
    {"DIST_C", static_cast<long>(cv::DIST_C)},
    {"DIST_FAIR", static_cast<long>(cv::DIST_FAIR)},
    {"DIST_HUBER", static_cast<long>(cv::DIST_HUBER)},
    {"DIST_L1", static_cast<long>(cv::DIST_L1)},
    {"DIST_L12", static_cast<long>(cv::DIST_L12)},
    {"DIST_L2", static_cast<long>(cv::DIST_L2)},
    {"DIST_LABEL_CCOMP", static_cast<long>(cv::DIST_LABEL_CCOMP)},
    {"DIST_LABEL_PIXEL", static_cast<long>(cv::DIST_LABEL_PIXEL)},
    {"DIST_MASK_3", static_cast<long>(cv::DIST_MASK_3)},
    {"DIST_MASK_5", static_cast<long>(cv::DIST_MASK_5)},
    {"DIST_MASK_PRECISE", static_cast<long>(cv::DIST_MASK_PRECISE)},
    {"DIST_USER", static_cast<long>(cv::DIST_USER)},
    {"DIST_WELSCH", static_cast<long>(cv::DIST_WELSCH)},
    {"DescriptorMatcher_BRUTEFORCE", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE)},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE)},
    {"DescriptorMatcher_BRUTEFORCE_HAMMING", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_HAMMING)},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_HAMMING", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_HAMMING)},
    {"DescriptorMatcher_BRUTEFORCE_HAMMINGLUT", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_HAMMINGLUT)},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_HAMMINGLUT", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_HAMMINGLUT)},
    {"DescriptorMatcher_BRUTEFORCE_L1", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_L1)},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_L1", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_L1)},
    {"DescriptorMatcher_BRUTEFORCE_SL2", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_SL2)},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_SL2", static_cast<long>(cv::DescriptorMatcher::BRUTEFORCE_SL2)},
    {"DescriptorMatcher_FLANNBASED", static_cast<long>(cv::DescriptorMatcher::FLANNBASED)},
    {"DESCRIPTOR_MATCHER_FLANNBASED", static_cast<long>(cv::DescriptorMatcher::FLANNBASED)},
    {"DrawMatchesFlags_DEFAULT", static_cast<long>(cv::DrawMatchesFlags::DEFAULT)},
    {"DRAW_MATCHES_FLAGS_DEFAULT", static_cast<long>(cv::DrawMatchesFlags::DEFAULT)},
    {"DrawMatchesFlags_DRAW_OVER_OUTIMG", static_cast<long>(cv::DrawMatchesFlags::DRAW_OVER_OUTIMG)},
    {"DRAW_MATCHES_FLAGS_DRAW_OVER_OUTIMG", static_cast<long>(cv::DrawMatchesFlags::DRAW_OVER_OUTIMG)},
    {"DrawMatchesFlags_DRAW_RICH_KEYPOINTS", static_cast<long>(cv::DrawMatchesFlags::DRAW_RICH_KEYPOINTS)},
    {"DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS", static_cast<long>(cv::DrawMatchesFlags::DRAW_RICH_KEYPOINTS)},
    {"DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS", static_cast<long>(cv::DrawMatchesFlags::NOT_DRAW_SINGLE_POINTS)},
    {"DRAW_MATCHES_FLAGS_NOT_DRAW_SINGLE_POINTS", static_cast<long>(cv::DrawMatchesFlags::NOT_DRAW_SINGLE_POINTS)},
    {"EVENT_FLAG_ALTKEY", static_cast<long>(cv::EVENT_FLAG_ALTKEY)},
    {"EVENT_FLAG_CTRLKEY", static_cast<long>(cv::EVENT_FLAG_CTRLKEY)},
    {"EVENT_FLAG_LBUTTON", static_cast<long>(cv::EVENT_FLAG_LBUTTON)},
    {"EVENT_FLAG_MBUTTON", static_cast<long>(cv::EVENT_FLAG_MBUTTON)},
    {"EVENT_FLAG_RBUTTON", static_cast<long>(cv::EVENT_FLAG_RBUTTON)},
    {"EVENT_FLAG_SHIFTKEY", static_cast<long>(cv::EVENT_FLAG_SHIFTKEY)},
    {"EVENT_LBUTTONDBLCLK", static_cast<long>(cv::EVENT_LBUTTONDBLCLK)},
    {"EVENT_LBUTTONDOWN", static_cast<long>(cv::EVENT_LBUTTONDOWN)},
    {"EVENT_LBUTTONUP", static_cast<long>(cv::EVENT_LBUTTONUP)},
    {"EVENT_MBUTTONDBLCLK", static_cast<long>(cv::EVENT_MBUTTONDBLCLK)},
    {"EVENT_MBUTTONDOWN", static_cast<long>(cv::EVENT_MBUTTONDOWN)},
    {"EVENT_MBUTTONUP", static_cast<long>(cv::EVENT_MBUTTONUP)},
    {"EVENT_MOUSEHWHEEL", static_cast<long>(cv::EVENT_MOUSEHWHEEL)},
    {"EVENT_MOUSEMOVE", static_cast<long>(cv::EVENT_MOUSEMOVE)},
    {"EVENT_MOUSEWHEEL", static_cast<long>(cv::EVENT_MOUSEWHEEL)},
    {"EVENT_RBUTTONDBLCLK", static_cast<long>(cv::EVENT_RBUTTONDBLCLK)},
    {"EVENT_RBUTTONDOWN", static_cast<long>(cv::EVENT_RBUTTONDOWN)},
    {"EVENT_RBUTTONUP", static_cast<long>(cv::EVENT_RBUTTONUP)},
    {"FILLED", static_cast<long>(cv::FILLED)},
    {"FILTER_SCHARR", static_cast<long>(cv::FILTER_SCHARR)},
    {"FLOODFILL_FIXED_RANGE", static_cast<long>(cv::FLOODFILL_FIXED_RANGE)},
    {"FLOODFILL_MASK_ONLY", static_cast<long>(cv::FLOODFILL_MASK_ONLY)},
    {"FM_7POINT", static_cast<long>(cv::FM_7POINT)},
    {"FM_8POINT", static_cast<long>(cv::FM_8POINT)},
    {"FM_LMEDS", static_cast<long>(cv::FM_LMEDS)},
    {"FM_RANSAC", static_cast<long>(cv::FM_RANSAC)},
    {"FONT_HERSHEY_COMPLEX", static_cast<long>(cv::FONT_HERSHEY_COMPLEX)},
    {"FONT_HERSHEY_COMPLEX_SMALL", static_cast<long>(cv::FONT_HERSHEY_COMPLEX_SMALL)},
    {"FONT_HERSHEY_DUPLEX", static_cast<long>(cv::FONT_HERSHEY_DUPLEX)},
    {"FONT_HERSHEY_PLAIN", static_cast<long>(cv::FONT_HERSHEY_PLAIN)},
    {"FONT_HERSHEY_SCRIPT_COMPLEX", static_cast<long>(cv::FONT_HERSHEY_SCRIPT_COMPLEX)},
    {"FONT_HERSHEY_SCRIPT_SIMPLEX", static_cast<long>(cv::FONT_HERSHEY_SCRIPT_SIMPLEX)},
    {"FONT_HERSHEY_SIMPLEX", static_cast<long>(cv::FONT_HERSHEY_SIMPLEX)},
    {"FONT_HERSHEY_TRIPLEX", static_cast<long>(cv::FONT_HERSHEY_TRIPLEX)},
    {"FONT_ITALIC", static_cast<long>(cv::FONT_ITALIC)},
    {"FaceRecognizerSF_FR_COSINE", static_cast<long>(cv::FaceRecognizerSF::FR_COSINE)},
    {"FACE_RECOGNIZER_SF_FR_COSINE", static_cast<long>(cv::FaceRecognizerSF::FR_COSINE)},
    {"FaceRecognizerSF_FR_NORM_L2", static_cast<long>(cv::FaceRecognizerSF::FR_NORM_L2)},
    {"FACE_RECOGNIZER_SF_FR_NORM_L2", static_cast<long>(cv::FaceRecognizerSF::FR_NORM_L2)},
    {"FastFeatureDetector_FAST_N", static_cast<long>(cv::FastFeatureDetector::FAST_N)},
    {"FAST_FEATURE_DETECTOR_FAST_N", static_cast<long>(cv::FastFeatureDetector::FAST_N)},
    {"FastFeatureDetector_NONMAX_SUPPRESSION", static_cast<long>(cv::FastFeatureDetector::NONMAX_SUPPRESSION)},
    {"FAST_FEATURE_DETECTOR_NONMAX_SUPPRESSION", static_cast<long>(cv::FastFeatureDetector::NONMAX_SUPPRESSION)},
    {"FastFeatureDetector_THRESHOLD", static_cast<long>(cv::FastFeatureDetector::THRESHOLD)},
    {"FAST_FEATURE_DETECTOR_THRESHOLD", static_cast<long>(cv::FastFeatureDetector::THRESHOLD)},
    {"FastFeatureDetector_TYPE_5_8", static_cast<long>(cv::FastFeatureDetector::TYPE_5_8)},
    {"FAST_FEATURE_DETECTOR_TYPE_5_8", static_cast<long>(cv::FastFeatureDetector::TYPE_5_8)},
    {"FastFeatureDetector_TYPE_7_12", static_cast<long>(cv::FastFeatureDetector::TYPE_7_12)},
    {"FAST_FEATURE_DETECTOR_TYPE_7_12", static_cast<long>(cv::FastFeatureDetector::TYPE_7_12)},
    {"FastFeatureDetector_TYPE_9_16", static_cast<long>(cv::FastFeatureDetector::TYPE_9_16)},
    {"FAST_FEATURE_DETECTOR_TYPE_9_16", static_cast<long>(cv::FastFeatureDetector::TYPE_9_16)},
    {"FileNode_EMPTY", static_cast<long>(cv::FileNode::EMPTY)},
    {"FILE_NODE_EMPTY", static_cast<long>(cv::FileNode::EMPTY)},
    {"FileNode_FLOAT", static_cast<long>(cv::FileNode::FLOAT)},
    {"FILE_NODE_FLOAT", static_cast<long>(cv::FileNode::FLOAT)},
    {"FileNode_FLOW", static_cast<long>(cv::FileNode::FLOW)},
    {"FILE_NODE_FLOW", static_cast<long>(cv::FileNode::FLOW)},
    {"FileNode_INT", static_cast<long>(cv::FileNode::INT)},
    {"FILE_NODE_INT", static_cast<long>(cv::FileNode::INT)},
    {"FileNode_MAP", static_cast<long>(cv::FileNode::MAP)},
    {"FILE_NODE_MAP", static_cast<long>(cv::FileNode::MAP)},
    {"FileNode_NAMED", static_cast<long>(cv::FileNode::NAMED)},
    {"FILE_NODE_NAMED", static_cast<long>(cv::FileNode::NAMED)},
    {"FileNode_NONE", static_cast<long>(cv::FileNode::NONE)},
    {"FILE_NODE_NONE", static_cast<long>(cv::FileNode::NONE)},
    {"FileNode_REAL", static_cast<long>(cv::FileNode::REAL)},
    {"FILE_NODE_REAL", static_cast<long>(cv::FileNode::REAL)},
    {"FileNode_SEQ", static_cast<long>(cv::FileNode::SEQ)},
    {"FILE_NODE_SEQ", static_cast<long>(cv::FileNode::SEQ)},
    {"FileNode_STR", static_cast<long>(cv::FileNode::STR)},
    {"FILE_NODE_STR", static_cast<long>(cv::FileNode::STR)},
    {"FileNode_STRING", static_cast<long>(cv::FileNode::STRING)},
    {"FILE_NODE_STRING", static_cast<long>(cv::FileNode::STRING)},
    {"FileNode_TYPE_MASK", static_cast<long>(cv::FileNode::TYPE_MASK)},
    {"FILE_NODE_TYPE_MASK", static_cast<long>(cv::FileNode::TYPE_MASK)},
    {"FileNode_UNIFORM", static_cast<long>(cv::FileNode::UNIFORM)},
    {"FILE_NODE_UNIFORM", static_cast<long>(cv::FileNode::UNIFORM)},
    {"FileStorage_APPEND", static_cast<long>(cv::FileStorage::APPEND)},
    {"FILE_STORAGE_APPEND", static_cast<long>(cv::FileStorage::APPEND)},
    {"FileStorage_BASE64", static_cast<long>(cv::FileStorage::BASE64)},
    {"FILE_STORAGE_BASE64", static_cast<long>(cv::FileStorage::BASE64)},
    {"FileStorage_FORMAT_AUTO", static_cast<long>(cv::FileStorage::FORMAT_AUTO)},
    {"FILE_STORAGE_FORMAT_AUTO", static_cast<long>(cv::FileStorage::FORMAT_AUTO)},
    {"FileStorage_FORMAT_JSON", static_cast<long>(cv::FileStorage::FORMAT_JSON)},
    {"FILE_STORAGE_FORMAT_JSON", static_cast<long>(cv::FileStorage::FORMAT_JSON)},
    {"FileStorage_FORMAT_MASK", static_cast<long>(cv::FileStorage::FORMAT_MASK)},
    {"FILE_STORAGE_FORMAT_MASK", static_cast<long>(cv::FileStorage::FORMAT_MASK)},
    {"FileStorage_FORMAT_XML", static_cast<long>(cv::FileStorage::FORMAT_XML)},
    {"FILE_STORAGE_FORMAT_XML", static_cast<long>(cv::FileStorage::FORMAT_XML)},
    {"FileStorage_FORMAT_YAML", static_cast<long>(cv::FileStorage::FORMAT_YAML)},
    {"FILE_STORAGE_FORMAT_YAML", static_cast<long>(cv::FileStorage::FORMAT_YAML)},
    {"FileStorage_INSIDE_MAP", static_cast<long>(cv::FileStorage::INSIDE_MAP)},
    {"FILE_STORAGE_INSIDE_MAP", static_cast<long>(cv::FileStorage::INSIDE_MAP)},
    {"FileStorage_MEMORY", static_cast<long>(cv::FileStorage::MEMORY)},
    {"FILE_STORAGE_MEMORY", static_cast<long>(cv::FileStorage::MEMORY)},
    {"FileStorage_NAME_EXPECTED", static_cast<long>(cv::FileStorage::NAME_EXPECTED)},
    {"FILE_STORAGE_NAME_EXPECTED", static_cast<long>(cv::FileStorage::NAME_EXPECTED)},
    {"FileStorage_READ", static_cast<long>(cv::FileStorage::READ)},
    {"FILE_STORAGE_READ", static_cast<long>(cv::FileStorage::READ)},
    {"FileStorage_UNDEFINED", static_cast<long>(cv::FileStorage::UNDEFINED)},
    {"FILE_STORAGE_UNDEFINED", static_cast<long>(cv::FileStorage::UNDEFINED)},
    {"FileStorage_VALUE_EXPECTED", static_cast<long>(cv::FileStorage::VALUE_EXPECTED)},
    {"FILE_STORAGE_VALUE_EXPECTED", static_cast<long>(cv::FileStorage::VALUE_EXPECTED)},
    {"FileStorage_WRITE", static_cast<long>(cv::FileStorage::WRITE)},
    {"FILE_STORAGE_WRITE", static_cast<long>(cv::FileStorage::WRITE)},
    {"FileStorage_WRITE_BASE64", static_cast<long>(cv::FileStorage::WRITE_BASE64)},
    {"FILE_STORAGE_WRITE_BASE64", static_cast<long>(cv::FileStorage::WRITE_BASE64)},
    {"Formatter_FMT_C", static_cast<long>(cv::Formatter::FMT_C)},
    {"FORMATTER_FMT_C", static_cast<long>(cv::Formatter::FMT_C)},
    {"Formatter_FMT_CSV", static_cast<long>(cv::Formatter::FMT_CSV)},
    {"FORMATTER_FMT_CSV", static_cast<long>(cv::Formatter::FMT_CSV)},
    {"Formatter_FMT_DEFAULT", static_cast<long>(cv::Formatter::FMT_DEFAULT)},
    {"FORMATTER_FMT_DEFAULT", static_cast<long>(cv::Formatter::FMT_DEFAULT)},
    {"Formatter_FMT_MATLAB", static_cast<long>(cv::Formatter::FMT_MATLAB)},
    {"FORMATTER_FMT_MATLAB", static_cast<long>(cv::Formatter::FMT_MATLAB)},
    {"Formatter_FMT_NUMPY", static_cast<long>(cv::Formatter::FMT_NUMPY)},
    {"FORMATTER_FMT_NUMPY", static_cast<long>(cv::Formatter::FMT_NUMPY)},
    {"Formatter_FMT_PYTHON", static_cast<long>(cv::Formatter::FMT_PYTHON)},
    {"FORMATTER_FMT_PYTHON", static_cast<long>(cv::Formatter::FMT_PYTHON)},
    {"GC_BGD", static_cast<long>(cv::GC_BGD)},
    {"GC_EVAL", static_cast<long>(cv::GC_EVAL)},
    {"GC_EVAL_FREEZE_MODEL", static_cast<long>(cv::GC_EVAL_FREEZE_MODEL)},
    {"GC_FGD", static_cast<long>(cv::GC_FGD)},
    {"GC_INIT_WITH_MASK", static_cast<long>(cv::GC_INIT_WITH_MASK)},
    {"GC_INIT_WITH_RECT", static_cast<long>(cv::GC_INIT_WITH_RECT)},
    {"GC_PR_BGD", static_cast<long>(cv::GC_PR_BGD)},
    {"GC_PR_FGD", static_cast<long>(cv::GC_PR_FGD)},
    {"GEMM_1_T", static_cast<long>(cv::GEMM_1_T)},
    {"GEMM_2_T", static_cast<long>(cv::GEMM_2_T)},
    {"GEMM_3_T", static_cast<long>(cv::GEMM_3_T)},
    {"GFluidKernel_Kind_Filter", static_cast<long>(cv::GFluidKernel::Kind::Filter)},
    {"GFLUID_KERNEL_KIND_FILTER", static_cast<long>(cv::GFluidKernel::Kind::Filter)},
    {"GFluidKernel_Kind_Resize", static_cast<long>(cv::GFluidKernel::Kind::Resize)},
    {"GFLUID_KERNEL_KIND_RESIZE", static_cast<long>(cv::GFluidKernel::Kind::Resize)},
    {"GFluidKernel_Kind_YUV420toRGB", static_cast<long>(cv::GFluidKernel::Kind::YUV420toRGB)},
    {"GFLUID_KERNEL_KIND_YUV420TO_RGB", static_cast<long>(cv::GFluidKernel::Kind::YUV420toRGB)},
    {"GShape_GARRAY", static_cast<long>(cv::GShape::GARRAY)},
    {"GSHAPE_GARRAY", static_cast<long>(cv::GShape::GARRAY)},
    {"GShape_GFRAME", static_cast<long>(cv::GShape::GFRAME)},
    {"GSHAPE_GFRAME", static_cast<long>(cv::GShape::GFRAME)},
    {"GShape_GMAT", static_cast<long>(cv::GShape::GMAT)},
    {"GSHAPE_GMAT", static_cast<long>(cv::GShape::GMAT)},
    {"GShape_GOPAQUE", static_cast<long>(cv::GShape::GOPAQUE)},
    {"GSHAPE_GOPAQUE", static_cast<long>(cv::GShape::GOPAQUE)},
    {"GShape_GSCALAR", static_cast<long>(cv::GShape::GSCALAR)},
    {"GSHAPE_GSCALAR", static_cast<long>(cv::GShape::GSCALAR)},
    {"HISTCMP_BHATTACHARYYA", static_cast<long>(cv::HISTCMP_BHATTACHARYYA)},
    {"HISTCMP_CHISQR", static_cast<long>(cv::HISTCMP_CHISQR)},
    {"HISTCMP_CHISQR_ALT", static_cast<long>(cv::HISTCMP_CHISQR_ALT)},
    {"HISTCMP_CORREL", static_cast<long>(cv::HISTCMP_CORREL)},
    {"HISTCMP_HELLINGER", static_cast<long>(cv::HISTCMP_HELLINGER)},
    {"HISTCMP_INTERSECT", static_cast<long>(cv::HISTCMP_INTERSECT)},
    {"HISTCMP_KL_DIV", static_cast<long>(cv::HISTCMP_KL_DIV)},
    {"HOGDescriptor_DEFAULT_NLEVELS", static_cast<long>(cv::HOGDescriptor::DEFAULT_NLEVELS)},
    {"HOGDESCRIPTOR_DEFAULT_NLEVELS", static_cast<long>(cv::HOGDescriptor::DEFAULT_NLEVELS)},
    {"HOGDescriptor_DESCR_FORMAT_COL_BY_COL", static_cast<long>(cv::HOGDescriptor::DESCR_FORMAT_COL_BY_COL)},
    {"HOGDESCRIPTOR_DESCR_FORMAT_COL_BY_COL", static_cast<long>(cv::HOGDescriptor::DESCR_FORMAT_COL_BY_COL)},
    {"HOGDescriptor_DESCR_FORMAT_ROW_BY_ROW", static_cast<long>(cv::HOGDescriptor::DESCR_FORMAT_ROW_BY_ROW)},
    {"HOGDESCRIPTOR_DESCR_FORMAT_ROW_BY_ROW", static_cast<long>(cv::HOGDescriptor::DESCR_FORMAT_ROW_BY_ROW)},
    {"HOGDescriptor_L2Hys", static_cast<long>(cv::HOGDescriptor::L2Hys)},
    {"HOGDESCRIPTOR_L2HYS", static_cast<long>(cv::HOGDescriptor::L2Hys)},
    {"HOUGH_GRADIENT", static_cast<long>(cv::HOUGH_GRADIENT)},
    {"HOUGH_GRADIENT_ALT", static_cast<long>(cv::HOUGH_GRADIENT_ALT)},
    {"HOUGH_MULTI_SCALE", static_cast<long>(cv::HOUGH_MULTI_SCALE)},
    {"HOUGH_PROBABILISTIC", static_cast<long>(cv::HOUGH_PROBABILISTIC)},
    {"HOUGH_STANDARD", static_cast<long>(cv::HOUGH_STANDARD)},
    {"IMAGE_METADATA_EXIF", static_cast<long>(cv::IMAGE_METADATA_EXIF)},
    {"IMAGE_METADATA_ICCP", static_cast<long>(cv::IMAGE_METADATA_ICCP)},
    {"IMAGE_METADATA_MAX", static_cast<long>(cv::IMAGE_METADATA_MAX)},
    {"IMAGE_METADATA_UNKNOWN", static_cast<long>(cv::IMAGE_METADATA_UNKNOWN)},
    {"IMAGE_METADATA_XMP", static_cast<long>(cv::IMAGE_METADATA_XMP)},
    {"IMREAD_ANYCOLOR", static_cast<long>(cv::IMREAD_ANYCOLOR)},
    {"IMREAD_ANYDEPTH", static_cast<long>(cv::IMREAD_ANYDEPTH)},
    {"IMREAD_COLOR", static_cast<long>(cv::IMREAD_COLOR)},
    {"IMREAD_COLOR_BGR", static_cast<long>(cv::IMREAD_COLOR_BGR)},
    {"IMREAD_COLOR_RGB", static_cast<long>(cv::IMREAD_COLOR_RGB)},
    {"IMREAD_GRAYSCALE", static_cast<long>(cv::IMREAD_GRAYSCALE)},
    {"IMREAD_IGNORE_ORIENTATION", static_cast<long>(cv::IMREAD_IGNORE_ORIENTATION)},
    {"IMREAD_LOAD_GDAL", static_cast<long>(cv::IMREAD_LOAD_GDAL)},
    {"IMREAD_REDUCED_COLOR_2", static_cast<long>(cv::IMREAD_REDUCED_COLOR_2)},
    {"IMREAD_REDUCED_COLOR_4", static_cast<long>(cv::IMREAD_REDUCED_COLOR_4)},
    {"IMREAD_REDUCED_COLOR_8", static_cast<long>(cv::IMREAD_REDUCED_COLOR_8)},
    {"IMREAD_REDUCED_GRAYSCALE_2", static_cast<long>(cv::IMREAD_REDUCED_GRAYSCALE_2)},
    {"IMREAD_REDUCED_GRAYSCALE_4", static_cast<long>(cv::IMREAD_REDUCED_GRAYSCALE_4)},
    {"IMREAD_REDUCED_GRAYSCALE_8", static_cast<long>(cv::IMREAD_REDUCED_GRAYSCALE_8)},
    {"IMREAD_UNCHANGED", static_cast<long>(cv::IMREAD_UNCHANGED)},
    {"IMWRITE_AVIF_DEPTH", static_cast<long>(cv::IMWRITE_AVIF_DEPTH)},
    {"IMWRITE_AVIF_QUALITY", static_cast<long>(cv::IMWRITE_AVIF_QUALITY)},
    {"IMWRITE_AVIF_SPEED", static_cast<long>(cv::IMWRITE_AVIF_SPEED)},
    {"IMWRITE_EXR_COMPRESSION", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION)},
    {"IMWRITE_EXR_COMPRESSION_B44", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_B44)},
    {"IMWRITE_EXR_COMPRESSION_B44A", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_B44A)},
    {"IMWRITE_EXR_COMPRESSION_DWAA", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_DWAA)},
    {"IMWRITE_EXR_COMPRESSION_DWAB", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_DWAB)},
    {"IMWRITE_EXR_COMPRESSION_NO", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_NO)},
    {"IMWRITE_EXR_COMPRESSION_PIZ", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_PIZ)},
    {"IMWRITE_EXR_COMPRESSION_PXR24", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_PXR24)},
    {"IMWRITE_EXR_COMPRESSION_RLE", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_RLE)},
    {"IMWRITE_EXR_COMPRESSION_ZIP", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_ZIP)},
    {"IMWRITE_EXR_COMPRESSION_ZIPS", static_cast<long>(cv::IMWRITE_EXR_COMPRESSION_ZIPS)},
    {"IMWRITE_EXR_DWA_COMPRESSION_LEVEL", static_cast<long>(cv::IMWRITE_EXR_DWA_COMPRESSION_LEVEL)},
    {"IMWRITE_EXR_TYPE", static_cast<long>(cv::IMWRITE_EXR_TYPE)},
    {"IMWRITE_EXR_TYPE_FLOAT", static_cast<long>(cv::IMWRITE_EXR_TYPE_FLOAT)},
    {"IMWRITE_EXR_TYPE_HALF", static_cast<long>(cv::IMWRITE_EXR_TYPE_HALF)},
    {"IMWRITE_GIF_COLORTABLE", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE)},
    {"IMWRITE_GIF_COLORTABLE_SIZE_128", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE_SIZE_128)},
    {"IMWRITE_GIF_COLORTABLE_SIZE_16", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE_SIZE_16)},
    {"IMWRITE_GIF_COLORTABLE_SIZE_256", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE_SIZE_256)},
    {"IMWRITE_GIF_COLORTABLE_SIZE_32", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE_SIZE_32)},
    {"IMWRITE_GIF_COLORTABLE_SIZE_64", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE_SIZE_64)},
    {"IMWRITE_GIF_COLORTABLE_SIZE_8", static_cast<long>(cv::IMWRITE_GIF_COLORTABLE_SIZE_8)},
    {"IMWRITE_GIF_DITHER", static_cast<long>(cv::IMWRITE_GIF_DITHER)},
    {"IMWRITE_GIF_FAST_FLOYD_DITHER", static_cast<long>(cv::IMWRITE_GIF_FAST_FLOYD_DITHER)},
    {"IMWRITE_GIF_FAST_NO_DITHER", static_cast<long>(cv::IMWRITE_GIF_FAST_NO_DITHER)},
    {"IMWRITE_GIF_LOOP", static_cast<long>(cv::IMWRITE_GIF_LOOP)},
    {"IMWRITE_GIF_QUALITY", static_cast<long>(cv::IMWRITE_GIF_QUALITY)},
    {"IMWRITE_GIF_SPEED", static_cast<long>(cv::IMWRITE_GIF_SPEED)},
    {"IMWRITE_GIF_TRANSPARENCY", static_cast<long>(cv::IMWRITE_GIF_TRANSPARENCY)},
    {"IMWRITE_HDR_COMPRESSION", static_cast<long>(cv::IMWRITE_HDR_COMPRESSION)},
    {"IMWRITE_HDR_COMPRESSION_NONE", static_cast<long>(cv::IMWRITE_HDR_COMPRESSION_NONE)},
    {"IMWRITE_HDR_COMPRESSION_RLE", static_cast<long>(cv::IMWRITE_HDR_COMPRESSION_RLE)},
    {"IMWRITE_JPEG2000_COMPRESSION_X1000", static_cast<long>(cv::IMWRITE_JPEG2000_COMPRESSION_X1000)},
    {"IMWRITE_JPEGXL_DECODING_SPEED", static_cast<long>(cv::IMWRITE_JPEGXL_DECODING_SPEED)},
    {"IMWRITE_JPEGXL_DISTANCE", static_cast<long>(cv::IMWRITE_JPEGXL_DISTANCE)},
    {"IMWRITE_JPEGXL_EFFORT", static_cast<long>(cv::IMWRITE_JPEGXL_EFFORT)},
    {"IMWRITE_JPEGXL_QUALITY", static_cast<long>(cv::IMWRITE_JPEGXL_QUALITY)},
    {"IMWRITE_JPEG_CHROMA_QUALITY", static_cast<long>(cv::IMWRITE_JPEG_CHROMA_QUALITY)},
    {"IMWRITE_JPEG_LUMA_QUALITY", static_cast<long>(cv::IMWRITE_JPEG_LUMA_QUALITY)},
    {"IMWRITE_JPEG_OPTIMIZE", static_cast<long>(cv::IMWRITE_JPEG_OPTIMIZE)},
    {"IMWRITE_JPEG_PROGRESSIVE", static_cast<long>(cv::IMWRITE_JPEG_PROGRESSIVE)},
    {"IMWRITE_JPEG_QUALITY", static_cast<long>(cv::IMWRITE_JPEG_QUALITY)},
    {"IMWRITE_JPEG_RST_INTERVAL", static_cast<long>(cv::IMWRITE_JPEG_RST_INTERVAL)},
    {"IMWRITE_JPEG_SAMPLING_FACTOR", static_cast<long>(cv::IMWRITE_JPEG_SAMPLING_FACTOR)},
    {"IMWRITE_JPEG_SAMPLING_FACTOR_411", static_cast<long>(cv::IMWRITE_JPEG_SAMPLING_FACTOR_411)},
    {"IMWRITE_JPEG_SAMPLING_FACTOR_420", static_cast<long>(cv::IMWRITE_JPEG_SAMPLING_FACTOR_420)},
    {"IMWRITE_JPEG_SAMPLING_FACTOR_422", static_cast<long>(cv::IMWRITE_JPEG_SAMPLING_FACTOR_422)},
    {"IMWRITE_JPEG_SAMPLING_FACTOR_440", static_cast<long>(cv::IMWRITE_JPEG_SAMPLING_FACTOR_440)},
    {"IMWRITE_JPEG_SAMPLING_FACTOR_444", static_cast<long>(cv::IMWRITE_JPEG_SAMPLING_FACTOR_444)},
    {"IMWRITE_PAM_FORMAT_BLACKANDWHITE", static_cast<long>(cv::IMWRITE_PAM_FORMAT_BLACKANDWHITE)},
    {"IMWRITE_PAM_FORMAT_GRAYSCALE", static_cast<long>(cv::IMWRITE_PAM_FORMAT_GRAYSCALE)},
    {"IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA", static_cast<long>(cv::IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA)},
    {"IMWRITE_PAM_FORMAT_NULL", static_cast<long>(cv::IMWRITE_PAM_FORMAT_NULL)},
    {"IMWRITE_PAM_FORMAT_RGB", static_cast<long>(cv::IMWRITE_PAM_FORMAT_RGB)},
    {"IMWRITE_PAM_FORMAT_RGB_ALPHA", static_cast<long>(cv::IMWRITE_PAM_FORMAT_RGB_ALPHA)},
    {"IMWRITE_PAM_TUPLETYPE", static_cast<long>(cv::IMWRITE_PAM_TUPLETYPE)},
    {"IMWRITE_PNG_ALL_FILTERS", static_cast<long>(cv::IMWRITE_PNG_ALL_FILTERS)},
    {"IMWRITE_PNG_BILEVEL", static_cast<long>(cv::IMWRITE_PNG_BILEVEL)},
    {"IMWRITE_PNG_COMPRESSION", static_cast<long>(cv::IMWRITE_PNG_COMPRESSION)},
    {"IMWRITE_PNG_FAST_FILTERS", static_cast<long>(cv::IMWRITE_PNG_FAST_FILTERS)},
    {"IMWRITE_PNG_FILTER", static_cast<long>(cv::IMWRITE_PNG_FILTER)},
    {"IMWRITE_PNG_FILTER_AVG", static_cast<long>(cv::IMWRITE_PNG_FILTER_AVG)},
    {"IMWRITE_PNG_FILTER_NONE", static_cast<long>(cv::IMWRITE_PNG_FILTER_NONE)},
    {"IMWRITE_PNG_FILTER_PAETH", static_cast<long>(cv::IMWRITE_PNG_FILTER_PAETH)},
    {"IMWRITE_PNG_FILTER_SUB", static_cast<long>(cv::IMWRITE_PNG_FILTER_SUB)},
    {"IMWRITE_PNG_FILTER_UP", static_cast<long>(cv::IMWRITE_PNG_FILTER_UP)},
    {"IMWRITE_PNG_STRATEGY", static_cast<long>(cv::IMWRITE_PNG_STRATEGY)},
    {"IMWRITE_PNG_STRATEGY_DEFAULT", static_cast<long>(cv::IMWRITE_PNG_STRATEGY_DEFAULT)},
    {"IMWRITE_PNG_STRATEGY_FILTERED", static_cast<long>(cv::IMWRITE_PNG_STRATEGY_FILTERED)},
    {"IMWRITE_PNG_STRATEGY_FIXED", static_cast<long>(cv::IMWRITE_PNG_STRATEGY_FIXED)},
    {"IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY", static_cast<long>(cv::IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY)},
    {"IMWRITE_PNG_STRATEGY_RLE", static_cast<long>(cv::IMWRITE_PNG_STRATEGY_RLE)},
    {"IMWRITE_PXM_BINARY", static_cast<long>(cv::IMWRITE_PXM_BINARY)},
    {"IMWRITE_TIFF_COMPRESSION", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION)},
    {"IMWRITE_TIFF_COMPRESSION_ADOBE_DEFLATE", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_ADOBE_DEFLATE)},
    {"IMWRITE_TIFF_COMPRESSION_CCITTFAX3", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_CCITTFAX3)},
    {"IMWRITE_TIFF_COMPRESSION_CCITTFAX4", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_CCITTFAX4)},
    {"IMWRITE_TIFF_COMPRESSION_CCITTRLE", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_CCITTRLE)},
    {"IMWRITE_TIFF_COMPRESSION_CCITTRLEW", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_CCITTRLEW)},
    {"IMWRITE_TIFF_COMPRESSION_CCITT_T4", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_CCITT_T4)},
    {"IMWRITE_TIFF_COMPRESSION_CCITT_T6", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_CCITT_T6)},
    {"IMWRITE_TIFF_COMPRESSION_DCS", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_DCS)},
    {"IMWRITE_TIFF_COMPRESSION_DEFLATE", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_DEFLATE)},
    {"IMWRITE_TIFF_COMPRESSION_IT8BL", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_IT8BL)},
    {"IMWRITE_TIFF_COMPRESSION_IT8CTPAD", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_IT8CTPAD)},
    {"IMWRITE_TIFF_COMPRESSION_IT8LW", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_IT8LW)},
    {"IMWRITE_TIFF_COMPRESSION_IT8MP", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_IT8MP)},
    {"IMWRITE_TIFF_COMPRESSION_JBIG", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_JBIG)},
    {"IMWRITE_TIFF_COMPRESSION_JP2000", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_JP2000)},
    {"IMWRITE_TIFF_COMPRESSION_JPEG", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_JPEG)},
    {"IMWRITE_TIFF_COMPRESSION_JXL", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_JXL)},
    {"IMWRITE_TIFF_COMPRESSION_LERC", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_LERC)},
    {"IMWRITE_TIFF_COMPRESSION_LZMA", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_LZMA)},
    {"IMWRITE_TIFF_COMPRESSION_LZW", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_LZW)},
    {"IMWRITE_TIFF_COMPRESSION_NEXT", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_NEXT)},
    {"IMWRITE_TIFF_COMPRESSION_NONE", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_NONE)},
    {"IMWRITE_TIFF_COMPRESSION_OJPEG", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_OJPEG)},
    {"IMWRITE_TIFF_COMPRESSION_PACKBITS", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_PACKBITS)},
    {"IMWRITE_TIFF_COMPRESSION_PIXARFILM", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_PIXARFILM)},
    {"IMWRITE_TIFF_COMPRESSION_PIXARLOG", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_PIXARLOG)},
    {"IMWRITE_TIFF_COMPRESSION_SGILOG", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_SGILOG)},
    {"IMWRITE_TIFF_COMPRESSION_SGILOG24", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_SGILOG24)},
    {"IMWRITE_TIFF_COMPRESSION_T43", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_T43)},
    {"IMWRITE_TIFF_COMPRESSION_T85", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_T85)},
    {"IMWRITE_TIFF_COMPRESSION_THUNDERSCAN", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_THUNDERSCAN)},
    {"IMWRITE_TIFF_COMPRESSION_WEBP", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_WEBP)},
    {"IMWRITE_TIFF_COMPRESSION_ZSTD", static_cast<long>(cv::IMWRITE_TIFF_COMPRESSION_ZSTD)},
    {"IMWRITE_TIFF_PREDICTOR", static_cast<long>(cv::IMWRITE_TIFF_PREDICTOR)},
    {"IMWRITE_TIFF_PREDICTOR_FLOATINGPOINT", static_cast<long>(cv::IMWRITE_TIFF_PREDICTOR_FLOATINGPOINT)},
    {"IMWRITE_TIFF_PREDICTOR_HORIZONTAL", static_cast<long>(cv::IMWRITE_TIFF_PREDICTOR_HORIZONTAL)},
    {"IMWRITE_TIFF_PREDICTOR_NONE", static_cast<long>(cv::IMWRITE_TIFF_PREDICTOR_NONE)},
    {"IMWRITE_TIFF_RESUNIT", static_cast<long>(cv::IMWRITE_TIFF_RESUNIT)},
    {"IMWRITE_TIFF_ROWSPERSTRIP", static_cast<long>(cv::IMWRITE_TIFF_ROWSPERSTRIP)},
    {"IMWRITE_TIFF_XDPI", static_cast<long>(cv::IMWRITE_TIFF_XDPI)},
    {"IMWRITE_TIFF_YDPI", static_cast<long>(cv::IMWRITE_TIFF_YDPI)},
    {"IMWRITE_WEBP_QUALITY", static_cast<long>(cv::IMWRITE_WEBP_QUALITY)},
    {"INPAINT_NS", static_cast<long>(cv::INPAINT_NS)},
    {"INPAINT_TELEA", static_cast<long>(cv::INPAINT_TELEA)},
    {"INTERSECT_FULL", static_cast<long>(cv::INTERSECT_FULL)},
    {"INTERSECT_NONE", static_cast<long>(cv::INTERSECT_NONE)},
    {"INTERSECT_PARTIAL", static_cast<long>(cv::INTERSECT_PARTIAL)},
    {"INTER_AREA", static_cast<long>(cv::INTER_AREA)},
    {"INTER_BITS", static_cast<long>(cv::INTER_BITS)},
    {"INTER_BITS2", static_cast<long>(cv::INTER_BITS2)},
    {"INTER_CUBIC", static_cast<long>(cv::INTER_CUBIC)},
    {"INTER_LANCZOS4", static_cast<long>(cv::INTER_LANCZOS4)},
    {"INTER_LINEAR", static_cast<long>(cv::INTER_LINEAR)},
    {"INTER_LINEAR_EXACT", static_cast<long>(cv::INTER_LINEAR_EXACT)},
    {"INTER_MAX", static_cast<long>(cv::INTER_MAX)},
    {"INTER_NEAREST", static_cast<long>(cv::INTER_NEAREST)},
    {"INTER_NEAREST_EXACT", static_cast<long>(cv::INTER_NEAREST_EXACT)},
    {"INTER_TAB_SIZE", static_cast<long>(cv::INTER_TAB_SIZE)},
    {"INTER_TAB_SIZE2", static_cast<long>(cv::INTER_TAB_SIZE2)},
    {"KAZE_DIFF_CHARBONNIER", static_cast<long>(cv::KAZE::DIFF_CHARBONNIER)},
    {"KAZE_DIFF_PM_G1", static_cast<long>(cv::KAZE::DIFF_PM_G1)},
    {"KAZE_DIFF_PM_G2", static_cast<long>(cv::KAZE::DIFF_PM_G2)},
    {"KAZE_DIFF_WEICKERT", static_cast<long>(cv::KAZE::DIFF_WEICKERT)},
    {"KMEANS_PP_CENTERS", static_cast<long>(cv::KMEANS_PP_CENTERS)},
    {"KMEANS_RANDOM_CENTERS", static_cast<long>(cv::KMEANS_RANDOM_CENTERS)},
    {"KMEANS_USE_INITIAL_LABELS", static_cast<long>(cv::KMEANS_USE_INITIAL_LABELS)},
    {"LDR_SIZE", static_cast<long>(cv::LDR_SIZE)},
    {"LINE_4", static_cast<long>(cv::LINE_4)},
    {"LINE_8", static_cast<long>(cv::LINE_8)},
    {"LINE_AA", static_cast<long>(cv::LINE_AA)},
    {"LMEDS", static_cast<long>(cv::LMEDS)},
    {"LOCAL_OPTIM_GC", static_cast<long>(cv::LOCAL_OPTIM_GC)},
    {"LOCAL_OPTIM_INNER_AND_ITER_LO", static_cast<long>(cv::LOCAL_OPTIM_INNER_AND_ITER_LO)},
    {"LOCAL_OPTIM_INNER_LO", static_cast<long>(cv::LOCAL_OPTIM_INNER_LO)},
    {"LOCAL_OPTIM_NULL", static_cast<long>(cv::LOCAL_OPTIM_NULL)},
    {"LOCAL_OPTIM_SIGMA", static_cast<long>(cv::LOCAL_OPTIM_SIGMA)},
    {"LSD_REFINE_ADV", static_cast<long>(cv::LSD_REFINE_ADV)},
    {"LSD_REFINE_NONE", static_cast<long>(cv::LSD_REFINE_NONE)},
    {"LSD_REFINE_STD", static_cast<long>(cv::LSD_REFINE_STD)},
    {"LSQ_POLISHER", static_cast<long>(cv::LSQ_POLISHER)},
    {"MAGSAC", static_cast<long>(cv::MAGSAC)},
    {"MARKER_CROSS", static_cast<long>(cv::MARKER_CROSS)},
    {"MARKER_DIAMOND", static_cast<long>(cv::MARKER_DIAMOND)},
    {"MARKER_SQUARE", static_cast<long>(cv::MARKER_SQUARE)},
    {"MARKER_STAR", static_cast<long>(cv::MARKER_STAR)},
    {"MARKER_TILTED_CROSS", static_cast<long>(cv::MARKER_TILTED_CROSS)},
    {"MARKER_TRIANGLE_DOWN", static_cast<long>(cv::MARKER_TRIANGLE_DOWN)},
    {"MARKER_TRIANGLE_UP", static_cast<long>(cv::MARKER_TRIANGLE_UP)},
    {"MIXED_CLONE", static_cast<long>(cv::MIXED_CLONE)},
    {"MIXED_CLONE_WIDE", static_cast<long>(cv::MIXED_CLONE_WIDE)},
    {"MONOCHROME_TRANSFER", static_cast<long>(cv::MONOCHROME_TRANSFER)},
    {"MONOCHROME_TRANSFER_WIDE", static_cast<long>(cv::MONOCHROME_TRANSFER_WIDE)},
    {"MORPH_BLACKHAT", static_cast<long>(cv::MORPH_BLACKHAT)},
    {"MORPH_CLOSE", static_cast<long>(cv::MORPH_CLOSE)},
    {"MORPH_CROSS", static_cast<long>(cv::MORPH_CROSS)},
    {"MORPH_DIAMOND", static_cast<long>(cv::MORPH_DIAMOND)},
    {"MORPH_DILATE", static_cast<long>(cv::MORPH_DILATE)},
    {"MORPH_ELLIPSE", static_cast<long>(cv::MORPH_ELLIPSE)},
    {"MORPH_ERODE", static_cast<long>(cv::MORPH_ERODE)},
    {"MORPH_GRADIENT", static_cast<long>(cv::MORPH_GRADIENT)},
    {"MORPH_HITMISS", static_cast<long>(cv::MORPH_HITMISS)},
    {"MORPH_OPEN", static_cast<long>(cv::MORPH_OPEN)},
    {"MORPH_RECT", static_cast<long>(cv::MORPH_RECT)},
    {"MORPH_TOPHAT", static_cast<long>(cv::MORPH_TOPHAT)},
    {"MOTION_AFFINE", static_cast<long>(cv::MOTION_AFFINE)},
    {"MOTION_EUCLIDEAN", static_cast<long>(cv::MOTION_EUCLIDEAN)},
    {"MOTION_HOMOGRAPHY", static_cast<long>(cv::MOTION_HOMOGRAPHY)},
    {"MOTION_TRANSLATION", static_cast<long>(cv::MOTION_TRANSLATION)},
    {"Mat_AUTO_STEP", static_cast<long>(cv::Mat::AUTO_STEP)},
    {"MAT_AUTO_STEP", static_cast<long>(cv::Mat::AUTO_STEP)},
    {"Mat_CONTINUOUS_FLAG", static_cast<long>(cv::Mat::CONTINUOUS_FLAG)},
    {"MAT_CONTINUOUS_FLAG", static_cast<long>(cv::Mat::CONTINUOUS_FLAG)},
    {"Mat_DEPTH_MASK", static_cast<long>(cv::Mat::DEPTH_MASK)},
    {"MAT_DEPTH_MASK", static_cast<long>(cv::Mat::DEPTH_MASK)},
    {"Mat_MAGIC_MASK", static_cast<long>(cv::Mat::MAGIC_MASK)},
    {"MAT_MAGIC_MASK", static_cast<long>(cv::Mat::MAGIC_MASK)},
    {"Mat_MAGIC_VAL", static_cast<long>(cv::Mat::MAGIC_VAL)},
    {"MAT_MAGIC_VAL", static_cast<long>(cv::Mat::MAGIC_VAL)},
    {"Mat_SUBMATRIX_FLAG", static_cast<long>(cv::Mat::SUBMATRIX_FLAG)},
    {"MAT_SUBMATRIX_FLAG", static_cast<long>(cv::Mat::SUBMATRIX_FLAG)},
    {"Mat_TYPE_MASK", static_cast<long>(cv::Mat::TYPE_MASK)},
    {"MAT_TYPE_MASK", static_cast<long>(cv::Mat::TYPE_MASK)},
    {"MediaFormat_BGR", static_cast<long>(cv::MediaFormat::BGR)},
    {"MEDIA_FORMAT_BGR", static_cast<long>(cv::MediaFormat::BGR)},
    {"MediaFormat_GRAY", static_cast<long>(cv::MediaFormat::GRAY)},
    {"MEDIA_FORMAT_GRAY", static_cast<long>(cv::MediaFormat::GRAY)},
    {"MediaFormat_NV12", static_cast<long>(cv::MediaFormat::NV12)},
    {"MEDIA_FORMAT_NV12", static_cast<long>(cv::MediaFormat::NV12)},
    {"MediaFrame_Access_R", static_cast<long>(cv::MediaFrame::Access::R)},
    {"MEDIA_FRAME_ACCESS_R", static_cast<long>(cv::MediaFrame::Access::R)},
    {"MediaFrame_Access_W", static_cast<long>(cv::MediaFrame::Access::W)},
    {"MEDIA_FRAME_ACCESS_W", static_cast<long>(cv::MediaFrame::Access::W)},
    {"NEIGH_FLANN_KNN", static_cast<long>(cv::NEIGH_FLANN_KNN)},
    {"NEIGH_FLANN_RADIUS", static_cast<long>(cv::NEIGH_FLANN_RADIUS)},
    {"NEIGH_GRID", static_cast<long>(cv::NEIGH_GRID)},
    {"NONE_POLISHER", static_cast<long>(cv::NONE_POLISHER)},
    {"NORMAL_CLONE", static_cast<long>(cv::NORMAL_CLONE)},
    {"NORMAL_CLONE_WIDE", static_cast<long>(cv::NORMAL_CLONE_WIDE)},
    {"NORMCONV_FILTER", static_cast<long>(cv::NORMCONV_FILTER)},
    {"NORM_HAMMING", static_cast<long>(cv::NORM_HAMMING)},
    {"NORM_HAMMING2", static_cast<long>(cv::NORM_HAMMING2)},
    {"NORM_INF", static_cast<long>(cv::NORM_INF)},
    {"NORM_L1", static_cast<long>(cv::NORM_L1)},
    {"NORM_L2", static_cast<long>(cv::NORM_L2)},
    {"NORM_L2SQR", static_cast<long>(cv::NORM_L2SQR)},
    {"NORM_MINMAX", static_cast<long>(cv::NORM_MINMAX)},
    {"NORM_RELATIVE", static_cast<long>(cv::NORM_RELATIVE)},
    {"NORM_TYPE_MASK", static_cast<long>(cv::NORM_TYPE_MASK)},
    {"OPTFLOW_FARNEBACK_GAUSSIAN", static_cast<long>(cv::OPTFLOW_FARNEBACK_GAUSSIAN)},
    {"OPTFLOW_LK_GET_MIN_EIGENVALS", static_cast<long>(cv::OPTFLOW_LK_GET_MIN_EIGENVALS)},
    {"OPTFLOW_USE_INITIAL_FLOW", static_cast<long>(cv::OPTFLOW_USE_INITIAL_FLOW)},
    {"ORB_FAST_SCORE", static_cast<long>(cv::ORB::FAST_SCORE)},
    {"ORB_HARRIS_SCORE", static_cast<long>(cv::ORB::HARRIS_SCORE)},
    {"PCA_DATA_AS_COL", static_cast<long>(cv::PCA::DATA_AS_COL)},
    {"PCA_DATA_AS_ROW", static_cast<long>(cv::PCA::DATA_AS_ROW)},
    {"PCA_USE_AVG", static_cast<long>(cv::PCA::USE_AVG)},
    {"PROJ_SPHERICAL_EQRECT", static_cast<long>(cv::PROJ_SPHERICAL_EQRECT)},
    {"PROJ_SPHERICAL_ORTHO", static_cast<long>(cv::PROJ_SPHERICAL_ORTHO)},
    {"Param_ALGORITHM", static_cast<long>(cv::Param::ALGORITHM)},
    {"PARAM_ALGORITHM", static_cast<long>(cv::Param::ALGORITHM)},
    {"Param_BOOLEAN", static_cast<long>(cv::Param::BOOLEAN)},
    {"PARAM_BOOLEAN", static_cast<long>(cv::Param::BOOLEAN)},
    {"Param_FLOAT", static_cast<long>(cv::Param::FLOAT)},
    {"PARAM_FLOAT", static_cast<long>(cv::Param::FLOAT)},
    {"Param_INT", static_cast<long>(cv::Param::INT)},
    {"PARAM_INT", static_cast<long>(cv::Param::INT)},
    {"Param_MAT", static_cast<long>(cv::Param::MAT)},
    {"PARAM_MAT", static_cast<long>(cv::Param::MAT)},
    {"Param_MAT_VECTOR", static_cast<long>(cv::Param::MAT_VECTOR)},
    {"PARAM_MAT_VECTOR", static_cast<long>(cv::Param::MAT_VECTOR)},
    {"Param_REAL", static_cast<long>(cv::Param::REAL)},
    {"PARAM_REAL", static_cast<long>(cv::Param::REAL)},
    {"Param_SCALAR", static_cast<long>(cv::Param::SCALAR)},
    {"PARAM_SCALAR", static_cast<long>(cv::Param::SCALAR)},
    {"Param_STRING", static_cast<long>(cv::Param::STRING)},
    {"PARAM_STRING", static_cast<long>(cv::Param::STRING)},
    {"Param_UCHAR", static_cast<long>(cv::Param::UCHAR)},
    {"PARAM_UCHAR", static_cast<long>(cv::Param::UCHAR)},
    {"Param_UINT64", static_cast<long>(cv::Param::UINT64)},
    {"PARAM_UINT64", static_cast<long>(cv::Param::UINT64)},
    {"Param_UNSIGNED_INT", static_cast<long>(cv::Param::UNSIGNED_INT)},
    {"PARAM_UNSIGNED_INT", static_cast<long>(cv::Param::UNSIGNED_INT)},
    {"QRCodeEncoder_CORRECT_LEVEL_H", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_H)},
    {"QRCODE_ENCODER_CORRECT_LEVEL_H", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_H)},
    {"QRCodeEncoder_CORRECT_LEVEL_L", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_L)},
    {"QRCODE_ENCODER_CORRECT_LEVEL_L", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_L)},
    {"QRCodeEncoder_CORRECT_LEVEL_M", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_M)},
    {"QRCODE_ENCODER_CORRECT_LEVEL_M", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_M)},
    {"QRCodeEncoder_CORRECT_LEVEL_Q", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_Q)},
    {"QRCODE_ENCODER_CORRECT_LEVEL_Q", static_cast<long>(cv::QRCodeEncoder::CORRECT_LEVEL_Q)},
    {"QRCodeEncoder_ECI_SHIFT_JIS", static_cast<long>(cv::QRCodeEncoder::ECI_SHIFT_JIS)},
    {"QRCODE_ENCODER_ECI_SHIFT_JIS", static_cast<long>(cv::QRCodeEncoder::ECI_SHIFT_JIS)},
    {"QRCodeEncoder_ECI_UTF8", static_cast<long>(cv::QRCodeEncoder::ECI_UTF8)},
    {"QRCODE_ENCODER_ECI_UTF8", static_cast<long>(cv::QRCodeEncoder::ECI_UTF8)},
    {"QRCodeEncoder_MODE_ALPHANUMERIC", static_cast<long>(cv::QRCodeEncoder::MODE_ALPHANUMERIC)},
    {"QRCODE_ENCODER_MODE_ALPHANUMERIC", static_cast<long>(cv::QRCodeEncoder::MODE_ALPHANUMERIC)},
    {"QRCodeEncoder_MODE_AUTO", static_cast<long>(cv::QRCodeEncoder::MODE_AUTO)},
    {"QRCODE_ENCODER_MODE_AUTO", static_cast<long>(cv::QRCodeEncoder::MODE_AUTO)},
    {"QRCodeEncoder_MODE_BYTE", static_cast<long>(cv::QRCodeEncoder::MODE_BYTE)},
    {"QRCODE_ENCODER_MODE_BYTE", static_cast<long>(cv::QRCodeEncoder::MODE_BYTE)},
    {"QRCodeEncoder_MODE_ECI", static_cast<long>(cv::QRCodeEncoder::MODE_ECI)},
    {"QRCODE_ENCODER_MODE_ECI", static_cast<long>(cv::QRCodeEncoder::MODE_ECI)},
    {"QRCodeEncoder_MODE_KANJI", static_cast<long>(cv::QRCodeEncoder::MODE_KANJI)},
    {"QRCODE_ENCODER_MODE_KANJI", static_cast<long>(cv::QRCodeEncoder::MODE_KANJI)},
    {"QRCodeEncoder_MODE_NUMERIC", static_cast<long>(cv::QRCodeEncoder::MODE_NUMERIC)},
    {"QRCODE_ENCODER_MODE_NUMERIC", static_cast<long>(cv::QRCodeEncoder::MODE_NUMERIC)},
    {"QRCodeEncoder_MODE_STRUCTURED_APPEND", static_cast<long>(cv::QRCodeEncoder::MODE_STRUCTURED_APPEND)},
    {"QRCODE_ENCODER_MODE_STRUCTURED_APPEND", static_cast<long>(cv::QRCodeEncoder::MODE_STRUCTURED_APPEND)},
    {"QT_CHECKBOX", static_cast<long>(cv::QT_CHECKBOX)},
    {"QT_FONT_BLACK", static_cast<long>(cv::QT_FONT_BLACK)},
    {"QT_FONT_BOLD", static_cast<long>(cv::QT_FONT_BOLD)},
    {"QT_FONT_DEMIBOLD", static_cast<long>(cv::QT_FONT_DEMIBOLD)},
    {"QT_FONT_LIGHT", static_cast<long>(cv::QT_FONT_LIGHT)},
    {"QT_FONT_NORMAL", static_cast<long>(cv::QT_FONT_NORMAL)},
    {"QT_NEW_BUTTONBAR", static_cast<long>(cv::QT_NEW_BUTTONBAR)},
    {"QT_PUSH_BUTTON", static_cast<long>(cv::QT_PUSH_BUTTON)},
    {"QT_RADIOBOX", static_cast<long>(cv::QT_RADIOBOX)},
    {"QT_STYLE_ITALIC", static_cast<long>(cv::QT_STYLE_ITALIC)},
    {"QT_STYLE_NORMAL", static_cast<long>(cv::QT_STYLE_NORMAL)},
    {"QT_STYLE_OBLIQUE", static_cast<long>(cv::QT_STYLE_OBLIQUE)},
    {"QUAT_ASSUME_NOT_UNIT", static_cast<long>(cv::QUAT_ASSUME_NOT_UNIT)},
    {"QUAT_ASSUME_UNIT", static_cast<long>(cv::QUAT_ASSUME_UNIT)},
    {"QuatEnum_EULER_ANGLES_MAX_VALUE", static_cast<long>(cv::QuatEnum::EULER_ANGLES_MAX_VALUE)},
    {"QUAT_ENUM_EULER_ANGLES_MAX_VALUE", static_cast<long>(cv::QuatEnum::EULER_ANGLES_MAX_VALUE)},
    {"QuatEnum_EXT_XYX", static_cast<long>(cv::QuatEnum::EXT_XYX)},
    {"QUAT_ENUM_EXT_XYX", static_cast<long>(cv::QuatEnum::EXT_XYX)},
    {"QuatEnum_EXT_XYZ", static_cast<long>(cv::QuatEnum::EXT_XYZ)},
    {"QUAT_ENUM_EXT_XYZ", static_cast<long>(cv::QuatEnum::EXT_XYZ)},
    {"QuatEnum_EXT_XZX", static_cast<long>(cv::QuatEnum::EXT_XZX)},
    {"QUAT_ENUM_EXT_XZX", static_cast<long>(cv::QuatEnum::EXT_XZX)},
    {"QuatEnum_EXT_XZY", static_cast<long>(cv::QuatEnum::EXT_XZY)},
    {"QUAT_ENUM_EXT_XZY", static_cast<long>(cv::QuatEnum::EXT_XZY)},
    {"QuatEnum_EXT_YXY", static_cast<long>(cv::QuatEnum::EXT_YXY)},
    {"QUAT_ENUM_EXT_YXY", static_cast<long>(cv::QuatEnum::EXT_YXY)},
    {"QuatEnum_EXT_YXZ", static_cast<long>(cv::QuatEnum::EXT_YXZ)},
    {"QUAT_ENUM_EXT_YXZ", static_cast<long>(cv::QuatEnum::EXT_YXZ)},
    {"QuatEnum_EXT_YZX", static_cast<long>(cv::QuatEnum::EXT_YZX)},
    {"QUAT_ENUM_EXT_YZX", static_cast<long>(cv::QuatEnum::EXT_YZX)},
    {"QuatEnum_EXT_YZY", static_cast<long>(cv::QuatEnum::EXT_YZY)},
    {"QUAT_ENUM_EXT_YZY", static_cast<long>(cv::QuatEnum::EXT_YZY)},
    {"QuatEnum_EXT_ZXY", static_cast<long>(cv::QuatEnum::EXT_ZXY)},
    {"QUAT_ENUM_EXT_ZXY", static_cast<long>(cv::QuatEnum::EXT_ZXY)},
    {"QuatEnum_EXT_ZXZ", static_cast<long>(cv::QuatEnum::EXT_ZXZ)},
    {"QUAT_ENUM_EXT_ZXZ", static_cast<long>(cv::QuatEnum::EXT_ZXZ)},
    {"QuatEnum_EXT_ZYX", static_cast<long>(cv::QuatEnum::EXT_ZYX)},
    {"QUAT_ENUM_EXT_ZYX", static_cast<long>(cv::QuatEnum::EXT_ZYX)},
    {"QuatEnum_EXT_ZYZ", static_cast<long>(cv::QuatEnum::EXT_ZYZ)},
    {"QUAT_ENUM_EXT_ZYZ", static_cast<long>(cv::QuatEnum::EXT_ZYZ)},
    {"QuatEnum_INT_XYX", static_cast<long>(cv::QuatEnum::INT_XYX)},
    {"QUAT_ENUM_INT_XYX", static_cast<long>(cv::QuatEnum::INT_XYX)},
    {"QuatEnum_INT_XYZ", static_cast<long>(cv::QuatEnum::INT_XYZ)},
    {"QUAT_ENUM_INT_XYZ", static_cast<long>(cv::QuatEnum::INT_XYZ)},
    {"QuatEnum_INT_XZX", static_cast<long>(cv::QuatEnum::INT_XZX)},
    {"QUAT_ENUM_INT_XZX", static_cast<long>(cv::QuatEnum::INT_XZX)},
    {"QuatEnum_INT_XZY", static_cast<long>(cv::QuatEnum::INT_XZY)},
    {"QUAT_ENUM_INT_XZY", static_cast<long>(cv::QuatEnum::INT_XZY)},
    {"QuatEnum_INT_YXY", static_cast<long>(cv::QuatEnum::INT_YXY)},
    {"QUAT_ENUM_INT_YXY", static_cast<long>(cv::QuatEnum::INT_YXY)},
    {"QuatEnum_INT_YXZ", static_cast<long>(cv::QuatEnum::INT_YXZ)},
    {"QUAT_ENUM_INT_YXZ", static_cast<long>(cv::QuatEnum::INT_YXZ)},
    {"QuatEnum_INT_YZX", static_cast<long>(cv::QuatEnum::INT_YZX)},
    {"QUAT_ENUM_INT_YZX", static_cast<long>(cv::QuatEnum::INT_YZX)},
    {"QuatEnum_INT_YZY", static_cast<long>(cv::QuatEnum::INT_YZY)},
    {"QUAT_ENUM_INT_YZY", static_cast<long>(cv::QuatEnum::INT_YZY)},
    {"QuatEnum_INT_ZXY", static_cast<long>(cv::QuatEnum::INT_ZXY)},
    {"QUAT_ENUM_INT_ZXY", static_cast<long>(cv::QuatEnum::INT_ZXY)},
    {"QuatEnum_INT_ZXZ", static_cast<long>(cv::QuatEnum::INT_ZXZ)},
    {"QUAT_ENUM_INT_ZXZ", static_cast<long>(cv::QuatEnum::INT_ZXZ)},
    {"QuatEnum_INT_ZYX", static_cast<long>(cv::QuatEnum::INT_ZYX)},
    {"QUAT_ENUM_INT_ZYX", static_cast<long>(cv::QuatEnum::INT_ZYX)},
    {"QuatEnum_INT_ZYZ", static_cast<long>(cv::QuatEnum::INT_ZYZ)},
    {"QUAT_ENUM_INT_ZYZ", static_cast<long>(cv::QuatEnum::INT_ZYZ)},
    {"RANSAC", static_cast<long>(cv::RANSAC)},
    {"RECURS_FILTER", static_cast<long>(cv::RECURS_FILTER)},
    {"REDUCE_AVG", static_cast<long>(cv::REDUCE_AVG)},
    {"REDUCE_MAX", static_cast<long>(cv::REDUCE_MAX)},
    {"REDUCE_MIN", static_cast<long>(cv::REDUCE_MIN)},
    {"REDUCE_SUM", static_cast<long>(cv::REDUCE_SUM)},
    {"REDUCE_SUM2", static_cast<long>(cv::REDUCE_SUM2)},
    {"RETR_CCOMP", static_cast<long>(cv::RETR_CCOMP)},
    {"RETR_EXTERNAL", static_cast<long>(cv::RETR_EXTERNAL)},
    {"RETR_FLOODFILL", static_cast<long>(cv::RETR_FLOODFILL)},
    {"RETR_LIST", static_cast<long>(cv::RETR_LIST)},
    {"RETR_TREE", static_cast<long>(cv::RETR_TREE)},
    {"RHO", static_cast<long>(cv::RHO)},
    {"RMat_Access_R", static_cast<long>(cv::RMat::Access::R)},
    {"RMAT_ACCESS_R", static_cast<long>(cv::RMat::Access::R)},
    {"RMat_Access_W", static_cast<long>(cv::RMat::Access::W)},
    {"RMAT_ACCESS_W", static_cast<long>(cv::RMat::Access::W)},
    {"RNG_NORMAL", static_cast<long>(cv::RNG::NORMAL)},
    {"RNG_UNIFORM", static_cast<long>(cv::RNG::UNIFORM)},
    {"ROTATE_180", static_cast<long>(cv::ROTATE_180)},
    {"ROTATE_90_CLOCKWISE", static_cast<long>(cv::ROTATE_90_CLOCKWISE)},
    {"ROTATE_90_COUNTERCLOCKWISE", static_cast<long>(cv::ROTATE_90_COUNTERCLOCKWISE)},
    {"SAMPLING_NAPSAC", static_cast<long>(cv::SAMPLING_NAPSAC)},
    {"SAMPLING_PROGRESSIVE_NAPSAC", static_cast<long>(cv::SAMPLING_PROGRESSIVE_NAPSAC)},
    {"SAMPLING_PROSAC", static_cast<long>(cv::SAMPLING_PROSAC)},
    {"SAMPLING_UNIFORM", static_cast<long>(cv::SAMPLING_UNIFORM)},
    {"SCORE_METHOD_LMEDS", static_cast<long>(cv::SCORE_METHOD_LMEDS)},
    {"SCORE_METHOD_MAGSAC", static_cast<long>(cv::SCORE_METHOD_MAGSAC)},
    {"SCORE_METHOD_MSAC", static_cast<long>(cv::SCORE_METHOD_MSAC)},
    {"SCORE_METHOD_RANSAC", static_cast<long>(cv::SCORE_METHOD_RANSAC)},
    {"SOLVELP_LOST", static_cast<long>(cv::SOLVELP_LOST)},
    {"SOLVELP_MULTI", static_cast<long>(cv::SOLVELP_MULTI)},
    {"SOLVELP_SINGLE", static_cast<long>(cv::SOLVELP_SINGLE)},
    {"SOLVELP_UNBOUNDED", static_cast<long>(cv::SOLVELP_UNBOUNDED)},
    {"SOLVELP_UNFEASIBLE", static_cast<long>(cv::SOLVELP_UNFEASIBLE)},
    {"SOLVEPNP_AP3P", static_cast<long>(cv::SOLVEPNP_AP3P)},
    {"SOLVEPNP_DLS", static_cast<long>(cv::SOLVEPNP_DLS)},
    {"SOLVEPNP_EPNP", static_cast<long>(cv::SOLVEPNP_EPNP)},
    {"SOLVEPNP_IPPE", static_cast<long>(cv::SOLVEPNP_IPPE)},
    {"SOLVEPNP_IPPE_SQUARE", static_cast<long>(cv::SOLVEPNP_IPPE_SQUARE)},
    {"SOLVEPNP_ITERATIVE", static_cast<long>(cv::SOLVEPNP_ITERATIVE)},
    {"SOLVEPNP_MAX_COUNT", static_cast<long>(cv::SOLVEPNP_MAX_COUNT)},
    {"SOLVEPNP_P3P", static_cast<long>(cv::SOLVEPNP_P3P)},
    {"SOLVEPNP_SQPNP", static_cast<long>(cv::SOLVEPNP_SQPNP)},
    {"SOLVEPNP_UPNP", static_cast<long>(cv::SOLVEPNP_UPNP)},
    {"SORT_ASCENDING", static_cast<long>(cv::SORT_ASCENDING)},
    {"SORT_DESCENDING", static_cast<long>(cv::SORT_DESCENDING)},
    {"SORT_EVERY_COLUMN", static_cast<long>(cv::SORT_EVERY_COLUMN)},
    {"SORT_EVERY_ROW", static_cast<long>(cv::SORT_EVERY_ROW)},
    {"SVD_FULL_UV", static_cast<long>(cv::SVD::FULL_UV)},
    {"SVD_MODIFY_A", static_cast<long>(cv::SVD::MODIFY_A)},
    {"SVD_NO_UV", static_cast<long>(cv::SVD::NO_UV)},
    {"SparseMat_HASH_BIT", static_cast<long>(cv::SparseMat::HASH_BIT)},
    {"SPARSE_MAT_HASH_BIT", static_cast<long>(cv::SparseMat::HASH_BIT)},
    {"SparseMat_HASH_SCALE", static_cast<long>(cv::SparseMat::HASH_SCALE)},
    {"SPARSE_MAT_HASH_SCALE", static_cast<long>(cv::SparseMat::HASH_SCALE)},
    {"SparseMat_MAGIC_VAL", static_cast<long>(cv::SparseMat::MAGIC_VAL)},
    {"SPARSE_MAT_MAGIC_VAL", static_cast<long>(cv::SparseMat::MAGIC_VAL)},
    {"SparseMat_MAX_DIM", static_cast<long>(cv::SparseMat::MAX_DIM)},
    {"SPARSE_MAT_MAX_DIM", static_cast<long>(cv::SparseMat::MAX_DIM)},
    {"StereoBM_PREFILTER_NORMALIZED_RESPONSE", static_cast<long>(cv::StereoBM::PREFILTER_NORMALIZED_RESPONSE)},
    {"STEREO_BM_PREFILTER_NORMALIZED_RESPONSE", static_cast<long>(cv::StereoBM::PREFILTER_NORMALIZED_RESPONSE)},
    {"StereoBM_PREFILTER_XSOBEL", static_cast<long>(cv::StereoBM::PREFILTER_XSOBEL)},
    {"STEREO_BM_PREFILTER_XSOBEL", static_cast<long>(cv::StereoBM::PREFILTER_XSOBEL)},
    {"StereoMatcher_DISP_SCALE", static_cast<long>(cv::StereoMatcher::DISP_SCALE)},
    {"STEREO_MATCHER_DISP_SCALE", static_cast<long>(cv::StereoMatcher::DISP_SCALE)},
    {"StereoMatcher_DISP_SHIFT", static_cast<long>(cv::StereoMatcher::DISP_SHIFT)},
    {"STEREO_MATCHER_DISP_SHIFT", static_cast<long>(cv::StereoMatcher::DISP_SHIFT)},
    {"StereoSGBM_MODE_HH", static_cast<long>(cv::StereoSGBM::MODE_HH)},
    {"STEREO_SGBM_MODE_HH", static_cast<long>(cv::StereoSGBM::MODE_HH)},
    {"StereoSGBM_MODE_HH4", static_cast<long>(cv::StereoSGBM::MODE_HH4)},
    {"STEREO_SGBM_MODE_HH4", static_cast<long>(cv::StereoSGBM::MODE_HH4)},
    {"StereoSGBM_MODE_SGBM", static_cast<long>(cv::StereoSGBM::MODE_SGBM)},
    {"STEREO_SGBM_MODE_SGBM", static_cast<long>(cv::StereoSGBM::MODE_SGBM)},
    {"StereoSGBM_MODE_SGBM_3WAY", static_cast<long>(cv::StereoSGBM::MODE_SGBM_3WAY)},
    {"STEREO_SGBM_MODE_SGBM_3WAY", static_cast<long>(cv::StereoSGBM::MODE_SGBM_3WAY)},
    {"Stitcher_ERR_CAMERA_PARAMS_ADJUST_FAIL", static_cast<long>(cv::Stitcher::ERR_CAMERA_PARAMS_ADJUST_FAIL)},
    {"STITCHER_ERR_CAMERA_PARAMS_ADJUST_FAIL", static_cast<long>(cv::Stitcher::ERR_CAMERA_PARAMS_ADJUST_FAIL)},
    {"Stitcher_ERR_HOMOGRAPHY_EST_FAIL", static_cast<long>(cv::Stitcher::ERR_HOMOGRAPHY_EST_FAIL)},
    {"STITCHER_ERR_HOMOGRAPHY_EST_FAIL", static_cast<long>(cv::Stitcher::ERR_HOMOGRAPHY_EST_FAIL)},
    {"Stitcher_ERR_NEED_MORE_IMGS", static_cast<long>(cv::Stitcher::ERR_NEED_MORE_IMGS)},
    {"STITCHER_ERR_NEED_MORE_IMGS", static_cast<long>(cv::Stitcher::ERR_NEED_MORE_IMGS)},
    {"Stitcher_OK", static_cast<long>(cv::Stitcher::OK)},
    {"STITCHER_OK", static_cast<long>(cv::Stitcher::OK)},
    {"Stitcher_PANORAMA", static_cast<long>(cv::Stitcher::PANORAMA)},
    {"STITCHER_PANORAMA", static_cast<long>(cv::Stitcher::PANORAMA)},
    {"Stitcher_SCANS", static_cast<long>(cv::Stitcher::SCANS)},
    {"STITCHER_SCANS", static_cast<long>(cv::Stitcher::SCANS)},
    {"Subdiv2D_NEXT_AROUND_DST", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_DST)},
    {"SUBDIV2D_NEXT_AROUND_DST", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_DST)},
    {"Subdiv2D_NEXT_AROUND_LEFT", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_LEFT)},
    {"SUBDIV2D_NEXT_AROUND_LEFT", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_LEFT)},
    {"Subdiv2D_NEXT_AROUND_ORG", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_ORG)},
    {"SUBDIV2D_NEXT_AROUND_ORG", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_ORG)},
    {"Subdiv2D_NEXT_AROUND_RIGHT", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_RIGHT)},
    {"SUBDIV2D_NEXT_AROUND_RIGHT", static_cast<long>(cv::Subdiv2D::NEXT_AROUND_RIGHT)},
    {"Subdiv2D_PREV_AROUND_DST", static_cast<long>(cv::Subdiv2D::PREV_AROUND_DST)},
    {"SUBDIV2D_PREV_AROUND_DST", static_cast<long>(cv::Subdiv2D::PREV_AROUND_DST)},
    {"Subdiv2D_PREV_AROUND_LEFT", static_cast<long>(cv::Subdiv2D::PREV_AROUND_LEFT)},
    {"SUBDIV2D_PREV_AROUND_LEFT", static_cast<long>(cv::Subdiv2D::PREV_AROUND_LEFT)},
    {"Subdiv2D_PREV_AROUND_ORG", static_cast<long>(cv::Subdiv2D::PREV_AROUND_ORG)},
    {"SUBDIV2D_PREV_AROUND_ORG", static_cast<long>(cv::Subdiv2D::PREV_AROUND_ORG)},
    {"Subdiv2D_PREV_AROUND_RIGHT", static_cast<long>(cv::Subdiv2D::PREV_AROUND_RIGHT)},
    {"SUBDIV2D_PREV_AROUND_RIGHT", static_cast<long>(cv::Subdiv2D::PREV_AROUND_RIGHT)},
    {"Subdiv2D_PTLOC_ERROR", static_cast<long>(cv::Subdiv2D::PTLOC_ERROR)},
    {"SUBDIV2D_PTLOC_ERROR", static_cast<long>(cv::Subdiv2D::PTLOC_ERROR)},
    {"Subdiv2D_PTLOC_INSIDE", static_cast<long>(cv::Subdiv2D::PTLOC_INSIDE)},
    {"SUBDIV2D_PTLOC_INSIDE", static_cast<long>(cv::Subdiv2D::PTLOC_INSIDE)},
    {"Subdiv2D_PTLOC_ON_EDGE", static_cast<long>(cv::Subdiv2D::PTLOC_ON_EDGE)},
    {"SUBDIV2D_PTLOC_ON_EDGE", static_cast<long>(cv::Subdiv2D::PTLOC_ON_EDGE)},
    {"Subdiv2D_PTLOC_OUTSIDE_RECT", static_cast<long>(cv::Subdiv2D::PTLOC_OUTSIDE_RECT)},
    {"SUBDIV2D_PTLOC_OUTSIDE_RECT", static_cast<long>(cv::Subdiv2D::PTLOC_OUTSIDE_RECT)},
    {"Subdiv2D_PTLOC_VERTEX", static_cast<long>(cv::Subdiv2D::PTLOC_VERTEX)},
    {"SUBDIV2D_PTLOC_VERTEX", static_cast<long>(cv::Subdiv2D::PTLOC_VERTEX)},
    {"THRESH_BINARY", static_cast<long>(cv::THRESH_BINARY)},
    {"THRESH_BINARY_INV", static_cast<long>(cv::THRESH_BINARY_INV)},
    {"THRESH_DRYRUN", static_cast<long>(cv::THRESH_DRYRUN)},
    {"THRESH_MASK", static_cast<long>(cv::THRESH_MASK)},
    {"THRESH_OTSU", static_cast<long>(cv::THRESH_OTSU)},
    {"THRESH_TOZERO", static_cast<long>(cv::THRESH_TOZERO)},
    {"THRESH_TOZERO_INV", static_cast<long>(cv::THRESH_TOZERO_INV)},
    {"THRESH_TRIANGLE", static_cast<long>(cv::THRESH_TRIANGLE)},
    {"THRESH_TRUNC", static_cast<long>(cv::THRESH_TRUNC)},
    {"TM_CCOEFF", static_cast<long>(cv::TM_CCOEFF)},
    {"TM_CCOEFF_NORMED", static_cast<long>(cv::TM_CCOEFF_NORMED)},
    {"TM_CCORR", static_cast<long>(cv::TM_CCORR)},
    {"TM_CCORR_NORMED", static_cast<long>(cv::TM_CCORR_NORMED)},
    {"TM_SQDIFF", static_cast<long>(cv::TM_SQDIFF)},
    {"TM_SQDIFF_NORMED", static_cast<long>(cv::TM_SQDIFF_NORMED)},
    {"TermCriteria_COUNT", static_cast<long>(cv::TermCriteria::COUNT)},
    {"TERM_CRITERIA_COUNT", static_cast<long>(cv::TermCriteria::COUNT)},
    {"TermCriteria_EPS", static_cast<long>(cv::TermCriteria::EPS)},
    {"TERM_CRITERIA_EPS", static_cast<long>(cv::TermCriteria::EPS)},
    {"TermCriteria_MAX_ITER", static_cast<long>(cv::TermCriteria::MAX_ITER)},
    {"TERM_CRITERIA_MAX_ITER", static_cast<long>(cv::TermCriteria::MAX_ITER)},
    {"TrackerKCF_CN", static_cast<long>(cv::TrackerKCF::CN)},
    {"TRACKER_KCF_CN", static_cast<long>(cv::TrackerKCF::CN)},
    {"TrackerKCF_CUSTOM", static_cast<long>(cv::TrackerKCF::CUSTOM)},
    {"TRACKER_KCF_CUSTOM", static_cast<long>(cv::TrackerKCF::CUSTOM)},
    {"TrackerKCF_GRAY", static_cast<long>(cv::TrackerKCF::GRAY)},
    {"TRACKER_KCF_GRAY", static_cast<long>(cv::TrackerKCF::GRAY)},
    {"UMatData_ASYNC_CLEANUP", static_cast<long>(cv::UMatData::ASYNC_CLEANUP)},
    {"UMAT_DATA_ASYNC_CLEANUP", static_cast<long>(cv::UMatData::ASYNC_CLEANUP)},
    {"UMatData_COPY_ON_MAP", static_cast<long>(cv::UMatData::COPY_ON_MAP)},
    {"UMAT_DATA_COPY_ON_MAP", static_cast<long>(cv::UMatData::COPY_ON_MAP)},
    {"UMatData_DEVICE_COPY_OBSOLETE", static_cast<long>(cv::UMatData::DEVICE_COPY_OBSOLETE)},
    {"UMAT_DATA_DEVICE_COPY_OBSOLETE", static_cast<long>(cv::UMatData::DEVICE_COPY_OBSOLETE)},
    {"UMatData_DEVICE_MEM_MAPPED", static_cast<long>(cv::UMatData::DEVICE_MEM_MAPPED)},
    {"UMAT_DATA_DEVICE_MEM_MAPPED", static_cast<long>(cv::UMatData::DEVICE_MEM_MAPPED)},
    {"UMatData_HOST_COPY_OBSOLETE", static_cast<long>(cv::UMatData::HOST_COPY_OBSOLETE)},
    {"UMAT_DATA_HOST_COPY_OBSOLETE", static_cast<long>(cv::UMatData::HOST_COPY_OBSOLETE)},
    {"UMatData_TEMP_COPIED_UMAT", static_cast<long>(cv::UMatData::TEMP_COPIED_UMAT)},
    {"UMAT_DATA_TEMP_COPIED_UMAT", static_cast<long>(cv::UMatData::TEMP_COPIED_UMAT)},
    {"UMatData_TEMP_UMAT", static_cast<long>(cv::UMatData::TEMP_UMAT)},
    {"UMAT_DATA_TEMP_UMAT", static_cast<long>(cv::UMatData::TEMP_UMAT)},
    {"UMatData_USER_ALLOCATED", static_cast<long>(cv::UMatData::USER_ALLOCATED)},
    {"UMAT_DATA_USER_ALLOCATED", static_cast<long>(cv::UMatData::USER_ALLOCATED)},
    {"UMat_AUTO_STEP", static_cast<long>(cv::UMat::AUTO_STEP)},
    {"UMAT_AUTO_STEP", static_cast<long>(cv::UMat::AUTO_STEP)},
    {"UMat_CONTINUOUS_FLAG", static_cast<long>(cv::UMat::CONTINUOUS_FLAG)},
    {"UMAT_CONTINUOUS_FLAG", static_cast<long>(cv::UMat::CONTINUOUS_FLAG)},
    {"UMat_DEPTH_MASK", static_cast<long>(cv::UMat::DEPTH_MASK)},
    {"UMAT_DEPTH_MASK", static_cast<long>(cv::UMat::DEPTH_MASK)},
    {"UMat_MAGIC_MASK", static_cast<long>(cv::UMat::MAGIC_MASK)},
    {"UMAT_MAGIC_MASK", static_cast<long>(cv::UMat::MAGIC_MASK)},
    {"UMat_MAGIC_VAL", static_cast<long>(cv::UMat::MAGIC_VAL)},
    {"UMAT_MAGIC_VAL", static_cast<long>(cv::UMat::MAGIC_VAL)},
    {"UMat_SUBMATRIX_FLAG", static_cast<long>(cv::UMat::SUBMATRIX_FLAG)},
    {"UMAT_SUBMATRIX_FLAG", static_cast<long>(cv::UMat::SUBMATRIX_FLAG)},
    {"UMat_TYPE_MASK", static_cast<long>(cv::UMat::TYPE_MASK)},
    {"UMAT_TYPE_MASK", static_cast<long>(cv::UMat::TYPE_MASK)},
    {"USAC_ACCURATE", static_cast<long>(cv::USAC_ACCURATE)},
    {"USAC_DEFAULT", static_cast<long>(cv::USAC_DEFAULT)},
    {"USAC_FAST", static_cast<long>(cv::USAC_FAST)},
    {"USAC_FM_8PTS", static_cast<long>(cv::USAC_FM_8PTS)},
    {"USAC_MAGSAC", static_cast<long>(cv::USAC_MAGSAC)},
    {"USAC_PARALLEL", static_cast<long>(cv::USAC_PARALLEL)},
    {"USAC_PROSAC", static_cast<long>(cv::USAC_PROSAC)},
    {"USAGE_ALLOCATE_DEVICE_MEMORY", static_cast<long>(cv::USAGE_ALLOCATE_DEVICE_MEMORY)},
    {"USAGE_ALLOCATE_HOST_MEMORY", static_cast<long>(cv::USAGE_ALLOCATE_HOST_MEMORY)},
    {"USAGE_ALLOCATE_SHARED_MEMORY", static_cast<long>(cv::USAGE_ALLOCATE_SHARED_MEMORY)},
    {"USAGE_DEFAULT", static_cast<long>(cv::USAGE_DEFAULT)},
    {"VIDEOWRITER_PROP_DEPTH", static_cast<long>(cv::VIDEOWRITER_PROP_DEPTH)},
    {"VIDEOWRITER_PROP_DTS_DELAY", static_cast<long>(cv::VIDEOWRITER_PROP_DTS_DELAY)},
    {"VIDEOWRITER_PROP_FRAMEBYTES", static_cast<long>(cv::VIDEOWRITER_PROP_FRAMEBYTES)},
    {"VIDEOWRITER_PROP_HW_ACCELERATION", static_cast<long>(cv::VIDEOWRITER_PROP_HW_ACCELERATION)},
    {"VIDEOWRITER_PROP_HW_ACCELERATION_USE_OPENCL", static_cast<long>(cv::VIDEOWRITER_PROP_HW_ACCELERATION_USE_OPENCL)},
    {"VIDEOWRITER_PROP_HW_DEVICE", static_cast<long>(cv::VIDEOWRITER_PROP_HW_DEVICE)},
    {"VIDEOWRITER_PROP_IS_COLOR", static_cast<long>(cv::VIDEOWRITER_PROP_IS_COLOR)},
    {"VIDEOWRITER_PROP_KEY_FLAG", static_cast<long>(cv::VIDEOWRITER_PROP_KEY_FLAG)},
    {"VIDEOWRITER_PROP_KEY_INTERVAL", static_cast<long>(cv::VIDEOWRITER_PROP_KEY_INTERVAL)},
    {"VIDEOWRITER_PROP_NSTRIPES", static_cast<long>(cv::VIDEOWRITER_PROP_NSTRIPES)},
    {"VIDEOWRITER_PROP_PTS", static_cast<long>(cv::VIDEOWRITER_PROP_PTS)},
    {"VIDEOWRITER_PROP_QUALITY", static_cast<long>(cv::VIDEOWRITER_PROP_QUALITY)},
    {"VIDEOWRITER_PROP_RAW_VIDEO", static_cast<long>(cv::VIDEOWRITER_PROP_RAW_VIDEO)},
    {"VIDEO_ACCELERATION_ANY", static_cast<long>(cv::VIDEO_ACCELERATION_ANY)},
    {"VIDEO_ACCELERATION_D3D11", static_cast<long>(cv::VIDEO_ACCELERATION_D3D11)},
    {"VIDEO_ACCELERATION_MFX", static_cast<long>(cv::VIDEO_ACCELERATION_MFX)},
    {"VIDEO_ACCELERATION_NONE", static_cast<long>(cv::VIDEO_ACCELERATION_NONE)},
    {"VIDEO_ACCELERATION_VAAPI", static_cast<long>(cv::VIDEO_ACCELERATION_VAAPI)},
    {"WARP_FILL_OUTLIERS", static_cast<long>(cv::WARP_FILL_OUTLIERS)},
    {"WARP_INVERSE_MAP", static_cast<long>(cv::WARP_INVERSE_MAP)},
    {"WARP_POLAR_LINEAR", static_cast<long>(cv::WARP_POLAR_LINEAR)},
    {"WARP_POLAR_LOG", static_cast<long>(cv::WARP_POLAR_LOG)},
    {"WARP_RELATIVE_MAP", static_cast<long>(cv::WARP_RELATIVE_MAP)},
    {"WINDOW_AUTOSIZE", static_cast<long>(cv::WINDOW_AUTOSIZE)},
    {"WINDOW_FREERATIO", static_cast<long>(cv::WINDOW_FREERATIO)},
    {"WINDOW_FULLSCREEN", static_cast<long>(cv::WINDOW_FULLSCREEN)},
    {"WINDOW_GUI_EXPANDED", static_cast<long>(cv::WINDOW_GUI_EXPANDED)},
    {"WINDOW_GUI_NORMAL", static_cast<long>(cv::WINDOW_GUI_NORMAL)},
    {"WINDOW_KEEPRATIO", static_cast<long>(cv::WINDOW_KEEPRATIO)},
    {"WINDOW_NORMAL", static_cast<long>(cv::WINDOW_NORMAL)},
    {"WINDOW_OPENGL", static_cast<long>(cv::WINDOW_OPENGL)},
    {"WND_PROP_ASPECT_RATIO", static_cast<long>(cv::WND_PROP_ASPECT_RATIO)},
    {"WND_PROP_AUTOSIZE", static_cast<long>(cv::WND_PROP_AUTOSIZE)},
    {"WND_PROP_FULLSCREEN", static_cast<long>(cv::WND_PROP_FULLSCREEN)},
    {"WND_PROP_OPENGL", static_cast<long>(cv::WND_PROP_OPENGL)},
    {"WND_PROP_TOPMOST", static_cast<long>(cv::WND_PROP_TOPMOST)},
    {"WND_PROP_VISIBLE", static_cast<long>(cv::WND_PROP_VISIBLE)},
    {"WND_PROP_VSYNC", static_cast<long>(cv::WND_PROP_VSYNC)},
    {"_InputArray_CUDA_GPU_MAT", static_cast<long>(cv::_InputArray::CUDA_GPU_MAT)},
    {"_INPUT_ARRAY_CUDA_GPU_MAT", static_cast<long>(cv::_InputArray::CUDA_GPU_MAT)},
    {"_InputArray_CUDA_HOST_MEM", static_cast<long>(cv::_InputArray::CUDA_HOST_MEM)},
    {"_INPUT_ARRAY_CUDA_HOST_MEM", static_cast<long>(cv::_InputArray::CUDA_HOST_MEM)},
    {"_InputArray_EXPR", static_cast<long>(cv::_InputArray::EXPR)},
    {"_INPUT_ARRAY_EXPR", static_cast<long>(cv::_InputArray::EXPR)},
    {"_InputArray_FIXED_SIZE", static_cast<long>(cv::_InputArray::FIXED_SIZE)},
    {"_INPUT_ARRAY_FIXED_SIZE", static_cast<long>(cv::_InputArray::FIXED_SIZE)},
    {"_InputArray_FIXED_TYPE", static_cast<long>(cv::_InputArray::FIXED_TYPE)},
    {"_INPUT_ARRAY_FIXED_TYPE", static_cast<long>(cv::_InputArray::FIXED_TYPE)},
    {"_InputArray_KIND_MASK", static_cast<long>(cv::_InputArray::KIND_MASK)},
    {"_INPUT_ARRAY_KIND_MASK", static_cast<long>(cv::_InputArray::KIND_MASK)},
    {"_InputArray_KIND_SHIFT", static_cast<long>(cv::_InputArray::KIND_SHIFT)},
    {"_INPUT_ARRAY_KIND_SHIFT", static_cast<long>(cv::_InputArray::KIND_SHIFT)},
    {"_InputArray_MAT", static_cast<long>(cv::_InputArray::MAT)},
    {"_INPUT_ARRAY_MAT", static_cast<long>(cv::_InputArray::MAT)},
    {"_InputArray_MATX", static_cast<long>(cv::_InputArray::MATX)},
    {"_INPUT_ARRAY_MATX", static_cast<long>(cv::_InputArray::MATX)},
    {"_InputArray_NONE", static_cast<long>(cv::_InputArray::NONE)},
    {"_INPUT_ARRAY_NONE", static_cast<long>(cv::_InputArray::NONE)},
    {"_InputArray_OPENGL_BUFFER", static_cast<long>(cv::_InputArray::OPENGL_BUFFER)},
    {"_INPUT_ARRAY_OPENGL_BUFFER", static_cast<long>(cv::_InputArray::OPENGL_BUFFER)},
    {"_InputArray_STD_ARRAY", static_cast<long>(cv::_InputArray::STD_ARRAY)},
    {"_INPUT_ARRAY_STD_ARRAY", static_cast<long>(cv::_InputArray::STD_ARRAY)},
    {"_InputArray_STD_ARRAY_MAT", static_cast<long>(cv::_InputArray::STD_ARRAY_MAT)},
    {"_INPUT_ARRAY_STD_ARRAY_MAT", static_cast<long>(cv::_InputArray::STD_ARRAY_MAT)},
    {"_InputArray_STD_BOOL_VECTOR", static_cast<long>(cv::_InputArray::STD_BOOL_VECTOR)},
    {"_INPUT_ARRAY_STD_BOOL_VECTOR", static_cast<long>(cv::_InputArray::STD_BOOL_VECTOR)},
    {"_InputArray_STD_VECTOR", static_cast<long>(cv::_InputArray::STD_VECTOR)},
    {"_INPUT_ARRAY_STD_VECTOR", static_cast<long>(cv::_InputArray::STD_VECTOR)},
    {"_InputArray_STD_VECTOR_CUDA_GPU_MAT", static_cast<long>(cv::_InputArray::STD_VECTOR_CUDA_GPU_MAT)},
    {"_INPUT_ARRAY_STD_VECTOR_CUDA_GPU_MAT", static_cast<long>(cv::_InputArray::STD_VECTOR_CUDA_GPU_MAT)},
    {"_InputArray_STD_VECTOR_MAT", static_cast<long>(cv::_InputArray::STD_VECTOR_MAT)},
    {"_INPUT_ARRAY_STD_VECTOR_MAT", static_cast<long>(cv::_InputArray::STD_VECTOR_MAT)},
    {"_InputArray_STD_VECTOR_UMAT", static_cast<long>(cv::_InputArray::STD_VECTOR_UMAT)},
    {"_INPUT_ARRAY_STD_VECTOR_UMAT", static_cast<long>(cv::_InputArray::STD_VECTOR_UMAT)},
    {"_InputArray_STD_VECTOR_VECTOR", static_cast<long>(cv::_InputArray::STD_VECTOR_VECTOR)},
    {"_INPUT_ARRAY_STD_VECTOR_VECTOR", static_cast<long>(cv::_InputArray::STD_VECTOR_VECTOR)},
    {"_InputArray_UMAT", static_cast<long>(cv::_InputArray::UMAT)},
    {"_INPUT_ARRAY_UMAT", static_cast<long>(cv::_InputArray::UMAT)},
    {"_OutputArray_DEPTH_MASK_16F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_16F)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_16F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_16F)},
    {"_OutputArray_DEPTH_MASK_16S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_16S)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_16S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_16S)},
    {"_OutputArray_DEPTH_MASK_16U", static_cast<long>(cv::_OutputArray::DEPTH_MASK_16U)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_16U", static_cast<long>(cv::_OutputArray::DEPTH_MASK_16U)},
    {"_OutputArray_DEPTH_MASK_32F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_32F)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_32F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_32F)},
    {"_OutputArray_DEPTH_MASK_32S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_32S)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_32S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_32S)},
    {"_OutputArray_DEPTH_MASK_64F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_64F)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_64F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_64F)},
    {"_OutputArray_DEPTH_MASK_8S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_8S)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_8S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_8S)},
    {"_OutputArray_DEPTH_MASK_8U", static_cast<long>(cv::_OutputArray::DEPTH_MASK_8U)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_8U", static_cast<long>(cv::_OutputArray::DEPTH_MASK_8U)},
    {"_OutputArray_DEPTH_MASK_ALL", static_cast<long>(cv::_OutputArray::DEPTH_MASK_ALL)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_ALL", static_cast<long>(cv::_OutputArray::DEPTH_MASK_ALL)},
    {"_OutputArray_DEPTH_MASK_ALL_16F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_ALL_16F)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_ALL_16F", static_cast<long>(cv::_OutputArray::DEPTH_MASK_ALL_16F)},
    {"_OutputArray_DEPTH_MASK_ALL_BUT_8S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_ALL_BUT_8S)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_ALL_BUT_8S", static_cast<long>(cv::_OutputArray::DEPTH_MASK_ALL_BUT_8S)},
    {"_OutputArray_DEPTH_MASK_FLT", static_cast<long>(cv::_OutputArray::DEPTH_MASK_FLT)},
    {"_OUTPUT_ARRAY_DEPTH_MASK_FLT", static_cast<long>(cv::_OutputArray::DEPTH_MASK_FLT)},
    {"__UMAT_USAGE_FLAGS_32BIT", static_cast<long>(cv::__UMAT_USAGE_FLAGS_32BIT)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_CV
    PYOPENCV_EXTRA_CONSTANTS_CV
#endif
    {NULL, 0}
};

static PyMethodDef methods_Error[] = {
#ifdef PYOPENCV_EXTRA_METHODS_ERROR
    PYOPENCV_EXTRA_METHODS_ERROR
#endif
    {NULL, NULL}
};

static ConstDef consts_Error[] = {
    {"BadAlign", static_cast<long>(cv::Error::BadAlign)},
    {"BAD_ALIGN", static_cast<long>(cv::Error::BadAlign)},
    {"BadAlphaChannel", static_cast<long>(cv::Error::BadAlphaChannel)},
    {"BAD_ALPHA_CHANNEL", static_cast<long>(cv::Error::BadAlphaChannel)},
    {"BadCOI", static_cast<long>(cv::Error::BadCOI)},
    {"BAD_COI", static_cast<long>(cv::Error::BadCOI)},
    {"BadCallBack", static_cast<long>(cv::Error::BadCallBack)},
    {"BAD_CALL_BACK", static_cast<long>(cv::Error::BadCallBack)},
    {"BadDataPtr", static_cast<long>(cv::Error::BadDataPtr)},
    {"BAD_DATA_PTR", static_cast<long>(cv::Error::BadDataPtr)},
    {"BadDepth", static_cast<long>(cv::Error::BadDepth)},
    {"BAD_DEPTH", static_cast<long>(cv::Error::BadDepth)},
    {"BadImageSize", static_cast<long>(cv::Error::BadImageSize)},
    {"BAD_IMAGE_SIZE", static_cast<long>(cv::Error::BadImageSize)},
    {"BadModelOrChSeq", static_cast<long>(cv::Error::BadModelOrChSeq)},
    {"BAD_MODEL_OR_CH_SEQ", static_cast<long>(cv::Error::BadModelOrChSeq)},
    {"BadNumChannel1U", static_cast<long>(cv::Error::BadNumChannel1U)},
    {"BAD_NUM_CHANNEL1U", static_cast<long>(cv::Error::BadNumChannel1U)},
    {"BadNumChannels", static_cast<long>(cv::Error::BadNumChannels)},
    {"BAD_NUM_CHANNELS", static_cast<long>(cv::Error::BadNumChannels)},
    {"BadOffset", static_cast<long>(cv::Error::BadOffset)},
    {"BAD_OFFSET", static_cast<long>(cv::Error::BadOffset)},
    {"BadOrder", static_cast<long>(cv::Error::BadOrder)},
    {"BAD_ORDER", static_cast<long>(cv::Error::BadOrder)},
    {"BadOrigin", static_cast<long>(cv::Error::BadOrigin)},
    {"BAD_ORIGIN", static_cast<long>(cv::Error::BadOrigin)},
    {"BadROISize", static_cast<long>(cv::Error::BadROISize)},
    {"BAD_ROISIZE", static_cast<long>(cv::Error::BadROISize)},
    {"BadStep", static_cast<long>(cv::Error::BadStep)},
    {"BAD_STEP", static_cast<long>(cv::Error::BadStep)},
    {"BadTileSize", static_cast<long>(cv::Error::BadTileSize)},
    {"BAD_TILE_SIZE", static_cast<long>(cv::Error::BadTileSize)},
    {"GpuApiCallError", static_cast<long>(cv::Error::GpuApiCallError)},
    {"GPU_API_CALL_ERROR", static_cast<long>(cv::Error::GpuApiCallError)},
    {"GpuNotSupported", static_cast<long>(cv::Error::GpuNotSupported)},
    {"GPU_NOT_SUPPORTED", static_cast<long>(cv::Error::GpuNotSupported)},
    {"HeaderIsNull", static_cast<long>(cv::Error::HeaderIsNull)},
    {"HEADER_IS_NULL", static_cast<long>(cv::Error::HeaderIsNull)},
    {"MaskIsTiled", static_cast<long>(cv::Error::MaskIsTiled)},
    {"MASK_IS_TILED", static_cast<long>(cv::Error::MaskIsTiled)},
    {"OpenCLApiCallError", static_cast<long>(cv::Error::OpenCLApiCallError)},
    {"OPEN_CLAPI_CALL_ERROR", static_cast<long>(cv::Error::OpenCLApiCallError)},
    {"OpenCLDoubleNotSupported", static_cast<long>(cv::Error::OpenCLDoubleNotSupported)},
    {"OPEN_CLDOUBLE_NOT_SUPPORTED", static_cast<long>(cv::Error::OpenCLDoubleNotSupported)},
    {"OpenCLInitError", static_cast<long>(cv::Error::OpenCLInitError)},
    {"OPEN_CLINIT_ERROR", static_cast<long>(cv::Error::OpenCLInitError)},
    {"OpenCLNoAMDBlasFft", static_cast<long>(cv::Error::OpenCLNoAMDBlasFft)},
    {"OPEN_CLNO_AMDBLAS_FFT", static_cast<long>(cv::Error::OpenCLNoAMDBlasFft)},
    {"OpenGlApiCallError", static_cast<long>(cv::Error::OpenGlApiCallError)},
    {"OPEN_GL_API_CALL_ERROR", static_cast<long>(cv::Error::OpenGlApiCallError)},
    {"OpenGlNotSupported", static_cast<long>(cv::Error::OpenGlNotSupported)},
    {"OPEN_GL_NOT_SUPPORTED", static_cast<long>(cv::Error::OpenGlNotSupported)},
    {"StsAssert", static_cast<long>(cv::Error::StsAssert)},
    {"STS_ASSERT", static_cast<long>(cv::Error::StsAssert)},
    {"StsAutoTrace", static_cast<long>(cv::Error::StsAutoTrace)},
    {"STS_AUTO_TRACE", static_cast<long>(cv::Error::StsAutoTrace)},
    {"StsBackTrace", static_cast<long>(cv::Error::StsBackTrace)},
    {"STS_BACK_TRACE", static_cast<long>(cv::Error::StsBackTrace)},
    {"StsBadArg", static_cast<long>(cv::Error::StsBadArg)},
    {"STS_BAD_ARG", static_cast<long>(cv::Error::StsBadArg)},
    {"StsBadFlag", static_cast<long>(cv::Error::StsBadFlag)},
    {"STS_BAD_FLAG", static_cast<long>(cv::Error::StsBadFlag)},
    {"StsBadFunc", static_cast<long>(cv::Error::StsBadFunc)},
    {"STS_BAD_FUNC", static_cast<long>(cv::Error::StsBadFunc)},
    {"StsBadMask", static_cast<long>(cv::Error::StsBadMask)},
    {"STS_BAD_MASK", static_cast<long>(cv::Error::StsBadMask)},
    {"StsBadMemBlock", static_cast<long>(cv::Error::StsBadMemBlock)},
    {"STS_BAD_MEM_BLOCK", static_cast<long>(cv::Error::StsBadMemBlock)},
    {"StsBadPoint", static_cast<long>(cv::Error::StsBadPoint)},
    {"STS_BAD_POINT", static_cast<long>(cv::Error::StsBadPoint)},
    {"StsBadSize", static_cast<long>(cv::Error::StsBadSize)},
    {"STS_BAD_SIZE", static_cast<long>(cv::Error::StsBadSize)},
    {"StsDivByZero", static_cast<long>(cv::Error::StsDivByZero)},
    {"STS_DIV_BY_ZERO", static_cast<long>(cv::Error::StsDivByZero)},
    {"StsError", static_cast<long>(cv::Error::StsError)},
    {"STS_ERROR", static_cast<long>(cv::Error::StsError)},
    {"StsFilterOffsetErr", static_cast<long>(cv::Error::StsFilterOffsetErr)},
    {"STS_FILTER_OFFSET_ERR", static_cast<long>(cv::Error::StsFilterOffsetErr)},
    {"StsFilterStructContentErr", static_cast<long>(cv::Error::StsFilterStructContentErr)},
    {"STS_FILTER_STRUCT_CONTENT_ERR", static_cast<long>(cv::Error::StsFilterStructContentErr)},
    {"StsInplaceNotSupported", static_cast<long>(cv::Error::StsInplaceNotSupported)},
    {"STS_INPLACE_NOT_SUPPORTED", static_cast<long>(cv::Error::StsInplaceNotSupported)},
    {"StsInternal", static_cast<long>(cv::Error::StsInternal)},
    {"STS_INTERNAL", static_cast<long>(cv::Error::StsInternal)},
    {"StsKernelStructContentErr", static_cast<long>(cv::Error::StsKernelStructContentErr)},
    {"STS_KERNEL_STRUCT_CONTENT_ERR", static_cast<long>(cv::Error::StsKernelStructContentErr)},
    {"StsNoConv", static_cast<long>(cv::Error::StsNoConv)},
    {"STS_NO_CONV", static_cast<long>(cv::Error::StsNoConv)},
    {"StsNoMem", static_cast<long>(cv::Error::StsNoMem)},
    {"STS_NO_MEM", static_cast<long>(cv::Error::StsNoMem)},
    {"StsNotImplemented", static_cast<long>(cv::Error::StsNotImplemented)},
    {"STS_NOT_IMPLEMENTED", static_cast<long>(cv::Error::StsNotImplemented)},
    {"StsNullPtr", static_cast<long>(cv::Error::StsNullPtr)},
    {"STS_NULL_PTR", static_cast<long>(cv::Error::StsNullPtr)},
    {"StsObjectNotFound", static_cast<long>(cv::Error::StsObjectNotFound)},
    {"STS_OBJECT_NOT_FOUND", static_cast<long>(cv::Error::StsObjectNotFound)},
    {"StsOk", static_cast<long>(cv::Error::StsOk)},
    {"STS_OK", static_cast<long>(cv::Error::StsOk)},
    {"StsOutOfRange", static_cast<long>(cv::Error::StsOutOfRange)},
    {"STS_OUT_OF_RANGE", static_cast<long>(cv::Error::StsOutOfRange)},
    {"StsParseError", static_cast<long>(cv::Error::StsParseError)},
    {"STS_PARSE_ERROR", static_cast<long>(cv::Error::StsParseError)},
    {"StsUnmatchedFormats", static_cast<long>(cv::Error::StsUnmatchedFormats)},
    {"STS_UNMATCHED_FORMATS", static_cast<long>(cv::Error::StsUnmatchedFormats)},
    {"StsUnmatchedSizes", static_cast<long>(cv::Error::StsUnmatchedSizes)},
    {"STS_UNMATCHED_SIZES", static_cast<long>(cv::Error::StsUnmatchedSizes)},
    {"StsUnsupportedFormat", static_cast<long>(cv::Error::StsUnsupportedFormat)},
    {"STS_UNSUPPORTED_FORMAT", static_cast<long>(cv::Error::StsUnsupportedFormat)},
    {"StsVecLengthErr", static_cast<long>(cv::Error::StsVecLengthErr)},
    {"STS_VEC_LENGTH_ERR", static_cast<long>(cv::Error::StsVecLengthErr)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_ERROR
    PYOPENCV_EXTRA_CONSTANTS_ERROR
#endif
    {NULL, 0}
};

static PyMethodDef methods_alphamat[] = {
    {"infoFlow", CV_PY_FN_WITH_KW_(pyopencv_cv_alphamat_infoFlow, 0), "infoFlow(image, tmap[, result]) -> result\n.   * @brief Compute alpha matte of an object in an image\n.    * @param image Input RGB image\n.    * @param tmap Input greyscale trimap image\n.    * @param result Output alpha matte image\n.    *\n.    * The function infoFlow performs alpha matting on a RGB image using a greyscale trimap image, and outputs a greyscale alpha matte image. The output alpha matte can be used to softly extract the foreground object from a background image. Examples can be found in the samples directory.\n.    *"},
#ifdef PYOPENCV_EXTRA_METHODS_ALPHAMAT
    PYOPENCV_EXTRA_METHODS_ALPHAMAT
#endif
    {NULL, NULL}
};

static ConstDef consts_alphamat[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_ALPHAMAT
    PYOPENCV_EXTRA_CONSTANTS_ALPHAMAT
#endif
    {NULL, 0}
};

static PyMethodDef methods_aruco[] = {
    {"Dictionary_getBitsFromByteList", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_Dictionary_getBitsFromByteList, 0), "Dictionary_getBitsFromByteList(byteList, markerSize) -> retval\n.   @brief Transform list of bytes to matrix of bits"},
    {"Dictionary_getByteListFromBits", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_Dictionary_getByteListFromBits, 0), "Dictionary_getByteListFromBits(bits) -> retval\n.   @brief Transform matrix of bits to list of bytes with 4 marker rotations"},
    {"calibrateCameraAruco", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_calibrateCameraAruco, 0), "calibrateCameraAruco(corners, ids, counter, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs\n.   @overload\n.    * @brief It's the same function as #calibrateCameraAruco but without calibration error estimation.\n.    * @deprecated Use Board::matchImagePoints and cv::solvePnP"},
    {"calibrateCameraArucoExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_calibrateCameraArucoExtended, 0), "calibrateCameraArucoExtended(corners, ids, counter, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, stdDeviationsIntrinsics, stdDeviationsExtrinsics, perViewErrors\n.   * @brief Calibrate a camera using aruco markers\n.    *\n.    * @param corners vector of detected marker corners in all frames.\n.    * The corners should have the same format returned by detectMarkers (see #detectMarkers).\n.    * @param ids list of identifiers for each marker in corners\n.    * @param counter number of markers in each frame so that corners and ids can be split\n.    * @param board Marker Board layout\n.    * @param imageSize Size of the image used only to initialize the intrinsic camera matrix.\n.    * @param cameraMatrix Output 3x3 floating-point camera matrix\n.    * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ . If CV\\_CALIB\\_USE\\_INTRINSIC\\_GUESS\n.    * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be\n.    * initialized before calling the function.\n.    * @param distCoeffs Output vector of distortion coefficients\n.    * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.    * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view\n.    * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding\n.    * k-th translation vector (see the next output parameter description) brings the board pattern\n.    * from the model coordinate space (in which object points are specified) to the world coordinate\n.    * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).\n.    * @param tvecs Output vector of translation vectors estimated for each pattern view.\n.    * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.\n.    * Order of deviations values:\n.    * \\f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,\n.    * s_4, \\tau_x, \\tau_y)\\f$ If one of parameters is not estimated, it's deviation is equals to zero.\n.    * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.\n.    * Order of deviations values: \\f$(R_1, T_1, \\dotsc , R_M, T_M)\\f$ where M is number of pattern views,\n.    * \\f$R_i, T_i\\f$ are concatenated 1x3 vectors.\n.    * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.\n.    * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).\n.    * @param criteria Termination criteria for the iterative optimization algorithm.\n.    *\n.    * This function calibrates a camera using an Aruco Board. The function receives a list of\n.    * detected markers from several views of the Board. The process is similar to the chessboard\n.    * calibration in calibrateCamera(). The function returns the final re-projection error.\n.    *\n.    * @deprecated Use Board::matchImagePoints and cv::solvePnP"},
    {"calibrateCameraCharuco", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_calibrateCameraCharuco, 0), "calibrateCameraCharuco(charucoCorners, charucoIds, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs\n.   * @brief It's the same function as #calibrateCameraCharuco but without calibration error estimation.\n.    *\n.    * @deprecated Use CharucoBoard::matchImagePoints and cv::solvePnP"},
    {"calibrateCameraCharucoExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_calibrateCameraCharucoExtended, 0), "calibrateCameraCharucoExtended(charucoCorners, charucoIds, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, stdDeviationsIntrinsics, stdDeviationsExtrinsics, perViewErrors\n.   * @brief Calibrate a camera using Charuco corners\n.    *\n.    * @param charucoCorners vector of detected charuco corners per frame\n.    * @param charucoIds list of identifiers for each corner in charucoCorners per frame\n.    * @param board Marker Board layout\n.    * @param imageSize input image size\n.    * @param cameraMatrix Output 3x3 floating-point camera matrix\n.    * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ . If CV\\_CALIB\\_USE\\_INTRINSIC\\_GUESS\n.    * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be\n.    * initialized before calling the function.\n.    * @param distCoeffs Output vector of distortion coefficients\n.    * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.    * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view\n.    * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding\n.    * k-th translation vector (see the next output parameter description) brings the board pattern\n.    * from the model coordinate space (in which object points are specified) to the world coordinate\n.    * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).\n.    * @param tvecs Output vector of translation vectors estimated for each pattern view.\n.    * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.\n.    * Order of deviations values:\n.    * \\f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,\n.    * s_4, \\tau_x, \\tau_y)\\f$ If one of parameters is not estimated, it's deviation is equals to zero.\n.    * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.\n.    * Order of deviations values: \\f$(R_1, T_1, \\dotsc , R_M, T_M)\\f$ where M is number of pattern views,\n.    * \\f$R_i, T_i\\f$ are concatenated 1x3 vectors.\n.    * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.\n.    * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).\n.    * @param criteria Termination criteria for the iterative optimization algorithm.\n.    *\n.    * This function calibrates a camera using a set of corners of a  Charuco Board. The function\n.    * receives a list of detected corners and its identifiers from several views of the Board.\n.    * The function returns the final re-projection error.\n.    *\n.    * @deprecated Use CharucoBoard::matchImagePoints and cv::solvePnP"},
    {"detectCharucoDiamond", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_detectCharucoDiamond, 0), "detectCharucoDiamond(image, markerCorners, markerIds, squareMarkerLengthRate[, diamondCorners[, diamondIds[, cameraMatrix[, distCoeffs[, dictionary]]]]]) -> diamondCorners, diamondIds\n.   * @brief Detect ChArUco Diamond markers\n.    *\n.    * @param image input image necessary for corner subpixel.\n.    * @param markerCorners list of detected marker corners from detectMarkers function.\n.    * @param markerIds list of marker ids in markerCorners.\n.    * @param squareMarkerLengthRate rate between square and marker length:\n.    * squareMarkerLengthRate = squareLength/markerLength. The real units are not necessary.\n.    * @param diamondCorners output list of detected diamond corners (4 corners per diamond). The order\n.    * is the same than in marker corners: top left, top right, bottom right and bottom left. Similar\n.    * format than the corners returned by detectMarkers (e.g std::vector<std::vector<cv::Point2f> > ).\n.    * @param diamondIds ids of the diamonds in diamondCorners. The id of each diamond is in fact of\n.    * type Vec4i, so each diamond has 4 ids, which are the ids of the aruco markers composing the\n.    * diamond.\n.    * @param cameraMatrix Optional camera calibration matrix.\n.    * @param distCoeffs Optional camera distortion coefficients.\n.    * @param dictionary dictionary of markers indicating the type of markers.\n.    *\n.    * This function detects Diamond markers from the previous detected ArUco markers. The diamonds\n.    * are returned in the diamondCorners and diamondIds parameters. If camera calibration parameters\n.    * are provided, the diamond search is based on reprojection. If not, diamond search is based on\n.    * homography. Homography is faster than reprojection, but less accurate.\n.    *\n.    * @deprecated Use CharucoDetector::detectDiamonds"},
    {"detectMarkers", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_detectMarkers, 0), "detectMarkers(image, dictionary[, corners[, ids[, parameters[, rejectedImgPoints]]]]) -> corners, ids, rejectedImgPoints\n.   @brief detect markers\n.   @deprecated Use class ArucoDetector::detectMarkers"},
    {"drawCharucoDiamond", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_drawCharucoDiamond, 0), "drawCharucoDiamond(dictionary, ids, squareLength, markerLength[, img[, marginSize[, borderBits]]]) -> img\n.   * @brief Draw a ChArUco Diamond marker\n.    *\n.    * @param dictionary dictionary of markers indicating the type of markers.\n.    * @param ids list of 4 ids for each ArUco marker in the ChArUco marker.\n.    * @param squareLength size of the chessboard squares in pixels.\n.    * @param markerLength size of the markers in pixels.\n.    * @param img output image with the marker. The size of this image will be\n.    * 3*squareLength + 2*marginSize,.\n.    * @param marginSize minimum margins (in pixels) of the marker in the output image\n.    * @param borderBits width of the marker borders.\n.    *\n.    * This function return the image of a ChArUco marker, ready to be printed.\n.    *\n.    * @deprecated Use CharucoBoard::generateImage()"},
    {"drawDetectedCornersCharuco", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_drawDetectedCornersCharuco, 0), "drawDetectedCornersCharuco(image, charucoCorners[, charucoIds[, cornerColor]]) -> image\n.   * @brief Draws a set of Charuco corners\n.    * @param image input/output image. It must have 1 or 3 channels. The number of channels is not\n.    * altered.\n.    * @param charucoCorners vector of detected charuco corners\n.    * @param charucoIds list of identifiers for each corner in charucoCorners\n.    * @param cornerColor color of the square surrounding each corner\n.    *\n.    * This function draws a set of detected Charuco corners. If identifiers vector is provided, it also\n.    * draws the id of each corner."},
    {"drawDetectedDiamonds", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_drawDetectedDiamonds, 0), "drawDetectedDiamonds(image, diamondCorners[, diamondIds[, borderColor]]) -> image\n.   * @brief Draw a set of detected ChArUco Diamond markers\n.    *\n.    * @param image input/output image. It must have 1 or 3 channels. The number of channels is not\n.    * altered.\n.    * @param diamondCorners positions of diamond corners in the same format returned by\n.    * detectCharucoDiamond(). (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,\n.    * the dimensions of this array should be Nx4. The order of the corners should be clockwise.\n.    * @param diamondIds vector of identifiers for diamonds in diamondCorners, in the same format\n.    * returned by detectCharucoDiamond() (e.g. std::vector<Vec4i>).\n.    * Optional, if not provided, ids are not painted.\n.    * @param borderColor color of marker borders. Rest of colors (text color and first corner color)\n.    * are calculated based on this one.\n.    *\n.    * Given an array of detected diamonds, this functions draws them in the image. The marker borders\n.    * are painted and the markers identifiers if provided.\n.    * Useful for debugging purposes."},
    {"drawDetectedMarkers", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_drawDetectedMarkers, 0), "drawDetectedMarkers(image, corners[, ids[, borderColor]]) -> image\n.   @brief Draw detected markers in image\n.    *\n.    * @param image input/output image. It must have 1 or 3 channels. The number of channels is not altered.\n.    * @param corners positions of marker corners on input image.\n.    * (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the dimensions of\n.    * this array should be Nx4. The order of the corners should be clockwise.\n.    * @param ids vector of identifiers for markers in markersCorners .\n.    * Optional, if not provided, ids are not painted.\n.    * @param borderColor color of marker borders. Rest of colors (text color and first corner color)\n.    * are calculated based on this one to improve visualization.\n.    *\n.    * Given an array of detected marker corners and its corresponding ids, this functions draws\n.    * the markers in the image. The marker borders are painted and the markers identifiers if provided.\n.    * Useful for debugging purposes."},
    {"drawPlanarBoard", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_drawPlanarBoard, 0), "drawPlanarBoard(board, outSize, marginSize, borderBits[, img]) -> img\n.   @brief draw planar board\n.   @deprecated Use Board::generateImage"},
    {"estimatePoseBoard", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_estimatePoseBoard, 0), "estimatePoseBoard(corners, ids, board, cameraMatrix, distCoeffs, rvec, tvec[, useExtrinsicGuess]) -> retval, rvec, tvec\n.   @deprecated Use Board::matchImagePoints and cv::solvePnP"},
    {"estimatePoseCharucoBoard", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_estimatePoseCharucoBoard, 0), "estimatePoseCharucoBoard(charucoCorners, charucoIds, board, cameraMatrix, distCoeffs, rvec, tvec[, useExtrinsicGuess]) -> retval, rvec, tvec\n.   * @brief Pose estimation for a ChArUco board given some of their corners\n.    * @param charucoCorners vector of detected charuco corners\n.    * @param charucoIds list of identifiers for each corner in charucoCorners\n.    * @param board layout of ChArUco board.\n.    * @param cameraMatrix input 3x3 floating-point camera matrix\n.    * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.    * @param distCoeffs vector of distortion coefficients\n.    * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.    * @param rvec Output vector (e.g. cv::Mat) corresponding to the rotation vector of the board\n.    * (see cv::Rodrigues).\n.    * @param tvec Output vector (e.g. cv::Mat) corresponding to the translation vector of the board.\n.    * @param useExtrinsicGuess defines whether initial guess for \\b rvec and \\b tvec will be used or not.\n.    *\n.    * This function estimates a Charuco board pose from some detected corners.\n.    * The function checks if the input corners are enough and valid to perform pose estimation.\n.    * If pose estimation is valid, returns true, else returns false.\n.    * @deprecated Use CharucoBoard::matchImagePoints and cv::solvePnP\n.    * @sa use cv::drawFrameAxes to get world coordinate system axis for object points"},
    {"estimatePoseSingleMarkers", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_estimatePoseSingleMarkers, 0), "estimatePoseSingleMarkers(corners, markerLength, cameraMatrix, distCoeffs[, rvecs[, tvecs[, objPoints[, estimateParameters]]]]) -> rvecs, tvecs, objPoints\n.   @deprecated Use cv::solvePnP"},
    {"extendDictionary", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_extendDictionary, 0), "extendDictionary(nMarkers, markerSize[, baseDictionary[, randomSeed]]) -> retval\n.   @brief Extend base dictionary by new nMarkers\n.     *\n.     * @param nMarkers number of markers in the dictionary\n.     * @param markerSize number of bits per dimension of each markers\n.     * @param baseDictionary Include the markers in this dictionary at the beginning (optional)\n.     * @param randomSeed a user supplied seed for theRNG()\n.     *\n.     * This function creates a new dictionary composed by nMarkers markers and each markers composed\n.     * by markerSize x markerSize bits. If baseDictionary is provided, its markers are directly\n.     * included and the rest are generated based on them. If the size of baseDictionary is higher\n.     * than nMarkers, only the first nMarkers in baseDictionary are taken and no new marker is added."},
    {"generateImageMarker", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_generateImageMarker, 0), "generateImageMarker(dictionary, id, sidePixels[, img[, borderBits]]) -> img\n.   @brief Generate a canonical marker image\n.    *\n.    * @param dictionary dictionary of markers indicating the type of markers\n.    * @param id identifier of the marker that will be returned. It has to be a valid id in the specified dictionary.\n.    * @param sidePixels size of the image in pixels\n.    * @param img output image with the marker\n.    * @param borderBits width of the marker border.\n.    *\n.    * This function returns a marker image in its canonical form (i.e. ready to be printed)"},
    {"getBoardObjectAndImagePoints", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_getBoardObjectAndImagePoints, 0), "getBoardObjectAndImagePoints(board, detectedCorners, detectedIds[, objPoints[, imgPoints]]) -> objPoints, imgPoints\n.   @brief get board object and image points\n.   @deprecated Use Board::matchImagePoints"},
    {"getPredefinedDictionary", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_getPredefinedDictionary, 0), "getPredefinedDictionary(dict) -> retval\n.   @brief Returns one of the predefined dictionaries referenced by DICT_*."},
    {"interpolateCornersCharuco", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_interpolateCornersCharuco, 0), "interpolateCornersCharuco(markerCorners, markerIds, image, board[, charucoCorners[, charucoIds[, cameraMatrix[, distCoeffs[, minMarkers]]]]]) -> retval, charucoCorners, charucoIds\n.   * @brief Interpolate position of ChArUco board corners\n.    * @param markerCorners vector of already detected markers corners. For each marker, its four\n.    * corners are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the\n.    * dimensions of this array should be Nx4. The order of the corners should be clockwise.\n.    * @param markerIds list of identifiers for each marker in corners\n.    * @param image input image necesary for corner refinement. Note that markers are not detected and\n.    * should be sent in corners and ids parameters.\n.    * @param board layout of ChArUco board.\n.    * @param charucoCorners interpolated chessboard corners\n.    * @param charucoIds interpolated chessboard corners identifiers\n.    * @param cameraMatrix optional 3x3 floating-point camera matrix\n.    * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.    * @param distCoeffs optional vector of distortion coefficients\n.    * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.    * @param minMarkers number of adjacent markers that must be detected to return a charuco corner\n.    *\n.    * This function receives the detected markers and returns the 2D position of the chessboard corners\n.    * from a ChArUco board using the detected Aruco markers. If camera parameters are provided,\n.    * the process is based in an approximated pose estimation, else it is based on local homography.\n.    * Only visible corners are returned. For each corner, its corresponding identifier is\n.    * also returned in charucoIds.\n.    * The function returns the number of interpolated corners.\n.    *\n.    * @deprecated Use CharucoDetector::detectBoard"},
    {"refineDetectedMarkers", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_refineDetectedMarkers, 0), "refineDetectedMarkers(image, board, detectedCorners, detectedIds, rejectedCorners[, cameraMatrix[, distCoeffs[, minRepDistance[, errorCorrectionRate[, checkAllOrders[, recoveredIdxs[, parameters]]]]]]]) -> detectedCorners, detectedIds, rejectedCorners, recoveredIdxs\n.   @brief refine detected markers\n.   @deprecated Use class ArucoDetector::refineDetectedMarkers"},
    {"testCharucoCornersCollinear", CV_PY_FN_WITH_KW_(pyopencv_cv_aruco_testCharucoCornersCollinear, 0), "testCharucoCornersCollinear(board, charucoIds) -> retval\n.   @deprecated Use CharucoBoard::checkCharucoCornersCollinear"},
#ifdef PYOPENCV_EXTRA_METHODS_ARUCO
    PYOPENCV_EXTRA_METHODS_ARUCO
#endif
    {NULL, NULL}
};

static ConstDef consts_aruco[] = {
    {"ARUCO_CCW_CENTER", static_cast<long>(cv::aruco::ARUCO_CCW_CENTER)},
    {"ARUCO_CW_TOP_LEFT_CORNER", static_cast<long>(cv::aruco::ARUCO_CW_TOP_LEFT_CORNER)},
    {"CORNER_REFINE_APRILTAG", static_cast<long>(cv::aruco::CORNER_REFINE_APRILTAG)},
    {"CORNER_REFINE_CONTOUR", static_cast<long>(cv::aruco::CORNER_REFINE_CONTOUR)},
    {"CORNER_REFINE_NONE", static_cast<long>(cv::aruco::CORNER_REFINE_NONE)},
    {"CORNER_REFINE_SUBPIX", static_cast<long>(cv::aruco::CORNER_REFINE_SUBPIX)},
    {"DICT_4X4_100", static_cast<long>(cv::aruco::DICT_4X4_100)},
    {"DICT_4X4_1000", static_cast<long>(cv::aruco::DICT_4X4_1000)},
    {"DICT_4X4_250", static_cast<long>(cv::aruco::DICT_4X4_250)},
    {"DICT_4X4_50", static_cast<long>(cv::aruco::DICT_4X4_50)},
    {"DICT_5X5_100", static_cast<long>(cv::aruco::DICT_5X5_100)},
    {"DICT_5X5_1000", static_cast<long>(cv::aruco::DICT_5X5_1000)},
    {"DICT_5X5_250", static_cast<long>(cv::aruco::DICT_5X5_250)},
    {"DICT_5X5_50", static_cast<long>(cv::aruco::DICT_5X5_50)},
    {"DICT_6X6_100", static_cast<long>(cv::aruco::DICT_6X6_100)},
    {"DICT_6X6_1000", static_cast<long>(cv::aruco::DICT_6X6_1000)},
    {"DICT_6X6_250", static_cast<long>(cv::aruco::DICT_6X6_250)},
    {"DICT_6X6_50", static_cast<long>(cv::aruco::DICT_6X6_50)},
    {"DICT_7X7_100", static_cast<long>(cv::aruco::DICT_7X7_100)},
    {"DICT_7X7_1000", static_cast<long>(cv::aruco::DICT_7X7_1000)},
    {"DICT_7X7_250", static_cast<long>(cv::aruco::DICT_7X7_250)},
    {"DICT_7X7_50", static_cast<long>(cv::aruco::DICT_7X7_50)},
    {"DICT_APRILTAG_16h5", static_cast<long>(cv::aruco::DICT_APRILTAG_16h5)},
    {"DICT_APRILTAG_16H5", static_cast<long>(cv::aruco::DICT_APRILTAG_16h5)},
    {"DICT_APRILTAG_25h9", static_cast<long>(cv::aruco::DICT_APRILTAG_25h9)},
    {"DICT_APRILTAG_25H9", static_cast<long>(cv::aruco::DICT_APRILTAG_25h9)},
    {"DICT_APRILTAG_36h10", static_cast<long>(cv::aruco::DICT_APRILTAG_36h10)},
    {"DICT_APRILTAG_36H10", static_cast<long>(cv::aruco::DICT_APRILTAG_36h10)},
    {"DICT_APRILTAG_36h11", static_cast<long>(cv::aruco::DICT_APRILTAG_36h11)},
    {"DICT_APRILTAG_36H11", static_cast<long>(cv::aruco::DICT_APRILTAG_36h11)},
    {"DICT_ARUCO_MIP_36h12", static_cast<long>(cv::aruco::DICT_ARUCO_MIP_36h12)},
    {"DICT_ARUCO_MIP_36H12", static_cast<long>(cv::aruco::DICT_ARUCO_MIP_36h12)},
    {"DICT_ARUCO_ORIGINAL", static_cast<long>(cv::aruco::DICT_ARUCO_ORIGINAL)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_ARUCO
    PYOPENCV_EXTRA_CONSTANTS_ARUCO
#endif
    {NULL, 0}
};

static PyMethodDef methods_barcode[] = {
#ifdef PYOPENCV_EXTRA_METHODS_BARCODE
    PYOPENCV_EXTRA_METHODS_BARCODE
#endif
    {NULL, NULL}
};

static ConstDef consts_barcode[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_BARCODE
    PYOPENCV_EXTRA_CONSTANTS_BARCODE
#endif
    {NULL, 0}
};

static PyMethodDef methods_bgsegm[] = {
    {"createBackgroundSubtractorCNT", CV_PY_FN_WITH_KW_(pyopencv_cv_bgsegm_createBackgroundSubtractorCNT, 0), "createBackgroundSubtractorCNT([, minPixelStability[, useHistory[, maxPixelStability[, isParallel]]]]) -> retval\n.   @brief Creates a CNT Background Subtractor\n.   \n.   @param minPixelStability number of frames with same pixel color to consider stable\n.   @param useHistory determines if we're giving a pixel credit for being stable for a long time\n.   @param maxPixelStability maximum allowed credit for a pixel in history\n.   @param isParallel determines if we're parallelizing the algorithm"},
    {"createBackgroundSubtractorGMG", CV_PY_FN_WITH_KW_(pyopencv_cv_bgsegm_createBackgroundSubtractorGMG, 0), "createBackgroundSubtractorGMG([, initializationFrames[, decisionThreshold]]) -> retval\n.   @brief Creates a GMG Background Subtractor\n.   \n.   @param initializationFrames number of frames used to initialize the background models.\n.   @param decisionThreshold Threshold value, above which it is marked foreground, else background."},
    {"createBackgroundSubtractorGSOC", CV_PY_FN_WITH_KW_(pyopencv_cv_bgsegm_createBackgroundSubtractorGSOC, 0), "createBackgroundSubtractorGSOC([, mc[, nSamples[, replaceRate[, propagationRate[, hitsThreshold[, alpha[, beta[, blinkingSupressionDecay[, blinkingSupressionMultiplier[, noiseRemovalThresholdFacBG[, noiseRemovalThresholdFacFG]]]]]]]]]]]) -> retval\n.   @brief Creates an instance of BackgroundSubtractorGSOC algorithm.\n.   \n.   Implementation of the different yet better algorithm which is called GSOC, as it was implemented during GSOC and was not originated from any paper.\n.   \n.   @param mc Whether to use camera motion compensation.\n.   @param nSamples Number of samples to maintain at each point of the frame.\n.   @param replaceRate Probability of replacing the old sample - how fast the model will update itself.\n.   @param propagationRate Probability of propagating to neighbors.\n.   @param hitsThreshold How many positives the sample must get before it will be considered as a possible replacement.\n.   @param alpha Scale coefficient for threshold.\n.   @param beta Bias coefficient for threshold.\n.   @param blinkingSupressionDecay Blinking supression decay factor.\n.   @param blinkingSupressionMultiplier Blinking supression multiplier.\n.   @param noiseRemovalThresholdFacBG Strength of the noise removal for background points.\n.   @param noiseRemovalThresholdFacFG Strength of the noise removal for foreground points."},
    {"createBackgroundSubtractorLSBP", CV_PY_FN_WITH_KW_(pyopencv_cv_bgsegm_createBackgroundSubtractorLSBP, 0), "createBackgroundSubtractorLSBP([, mc[, nSamples[, LSBPRadius[, Tlower[, Tupper[, Tinc[, Tdec[, Rscale[, Rincdec[, noiseRemovalThresholdFacBG[, noiseRemovalThresholdFacFG[, LSBPthreshold[, minCount]]]]]]]]]]]]]) -> retval\n.   @brief Creates an instance of BackgroundSubtractorLSBP algorithm.\n.   \n.   Background Subtraction using Local SVD Binary Pattern. More details about the algorithm can be found at @cite LGuo2016\n.   \n.   @param mc Whether to use camera motion compensation.\n.   @param nSamples Number of samples to maintain at each point of the frame.\n.   @param LSBPRadius LSBP descriptor radius.\n.   @param Tlower Lower bound for T-values. See @cite LGuo2016 for details.\n.   @param Tupper Upper bound for T-values. See @cite LGuo2016 for details.\n.   @param Tinc Increase step for T-values. See @cite LGuo2016 for details.\n.   @param Tdec Decrease step for T-values. See @cite LGuo2016 for details.\n.   @param Rscale Scale coefficient for threshold values.\n.   @param Rincdec Increase/Decrease step for threshold values.\n.   @param noiseRemovalThresholdFacBG Strength of the noise removal for background points.\n.   @param noiseRemovalThresholdFacFG Strength of the noise removal for foreground points.\n.   @param LSBPthreshold Threshold for LSBP binary string.\n.   @param minCount Minimal number of matches for sample to be considered as foreground."},
    {"createBackgroundSubtractorMOG", CV_PY_FN_WITH_KW_(pyopencv_cv_bgsegm_createBackgroundSubtractorMOG, 0), "createBackgroundSubtractorMOG([, history[, nmixtures[, backgroundRatio[, noiseSigma]]]]) -> retval\n.   @brief Creates mixture-of-gaussian background subtractor\n.   \n.   @param history Length of the history.\n.   @param nmixtures Number of Gaussian mixtures.\n.   @param backgroundRatio Background ratio.\n.   @param noiseSigma Noise strength (standard deviation of the brightness or each color channel). 0\n.   means some automatic value."},
    {"createSyntheticSequenceGenerator", CV_PY_FN_WITH_KW_(pyopencv_cv_bgsegm_createSyntheticSequenceGenerator, 0), "createSyntheticSequenceGenerator(background, object[, amplitude[, wavelength[, wavespeed[, objspeed]]]]) -> retval\n.   @brief Creates an instance of SyntheticSequenceGenerator.\n.   \n.   @param background Background image for object.\n.   @param object Object image which will move slowly over the background.\n.   @param amplitude Amplitude of wave distortion applied to background.\n.   @param wavelength Length of waves in distortion applied to background.\n.   @param wavespeed How fast waves will move.\n.   @param objspeed How fast object will fly over background."},
#ifdef PYOPENCV_EXTRA_METHODS_BGSEGM
    PYOPENCV_EXTRA_METHODS_BGSEGM
#endif
    {NULL, NULL}
};

static ConstDef consts_bgsegm[] = {
    {"LSBP_CAMERA_MOTION_COMPENSATION_LK", static_cast<long>(cv::bgsegm::LSBP_CAMERA_MOTION_COMPENSATION_LK)},
    {"LSBP_CAMERA_MOTION_COMPENSATION_NONE", static_cast<long>(cv::bgsegm::LSBP_CAMERA_MOTION_COMPENSATION_NONE)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_BGSEGM
    PYOPENCV_EXTRA_CONSTANTS_BGSEGM
#endif
    {NULL, 0}
};

static PyMethodDef methods_bioinspired[] = {
    {"RetinaFastToneMapping_create", CV_PY_FN_WITH_KW_(pyopencv_cv_bioinspired_RetinaFastToneMapping_create, 0), "RetinaFastToneMapping_create(inputSize) -> retval\n."},
    {"Retina_create", CV_PY_FN_WITH_KW_(pyopencv_cv_bioinspired_Retina_create, 0), "Retina_create(inputSize) -> retval\n.   @overload\n\n\n\nRetina_create(inputSize, colorMode[, colorSamplingMethod[, useRetinaLogSampling[, reductionFactor[, samplingStrength]]]]) -> retval\n.   @brief Constructors from standardized interfaces : retreive a smart pointer to a Retina instance\n.   \n.       @param inputSize the input frame size\n.       @param colorMode the chosen processing mode : with or without color processing\n.       @param colorSamplingMethod specifies which kind of color sampling will be used :\n.       -   cv::bioinspired::RETINA_COLOR_RANDOM: each pixel position is either R, G or B in a random choice\n.       -   cv::bioinspired::RETINA_COLOR_DIAGONAL: color sampling is RGBRGBRGB..., line 2 BRGBRGBRG..., line 3, GBRGBRGBR...\n.       -   cv::bioinspired::RETINA_COLOR_BAYER: standard bayer sampling\n.       @param useRetinaLogSampling activate retina log sampling, if true, the 2 following parameters can\n.       be used\n.       @param reductionFactor only usefull if param useRetinaLogSampling=true, specifies the reduction\n.       factor of the output frame (as the center (fovea) is high resolution and corners can be\n.       underscaled, then a reduction of the output is allowed without precision leak\n.       @param samplingStrength only usefull if param useRetinaLogSampling=true, specifies the strength of\n.       the log scale that is applied"},
    {"TransientAreasSegmentationModule_create", CV_PY_FN_WITH_KW_(pyopencv_cv_bioinspired_TransientAreasSegmentationModule_create, 0), "TransientAreasSegmentationModule_create(inputSize) -> retval\n.   @brief allocator\n.       @param inputSize : size of the images input to segment (output will be the same size)"},
#ifdef PYOPENCV_EXTRA_METHODS_BIOINSPIRED
    PYOPENCV_EXTRA_METHODS_BIOINSPIRED
#endif
    {NULL, NULL}
};

static ConstDef consts_bioinspired[] = {
    {"RETINA_COLOR_BAYER", static_cast<long>(cv::bioinspired::RETINA_COLOR_BAYER)},
    {"RETINA_COLOR_DIAGONAL", static_cast<long>(cv::bioinspired::RETINA_COLOR_DIAGONAL)},
    {"RETINA_COLOR_RANDOM", static_cast<long>(cv::bioinspired::RETINA_COLOR_RANDOM)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_BIOINSPIRED
    PYOPENCV_EXTRA_CONSTANTS_BIOINSPIRED
#endif
    {NULL, 0}
};

static PyMethodDef methods_ccm[] = {
#ifdef PYOPENCV_EXTRA_METHODS_CCM
    PYOPENCV_EXTRA_METHODS_CCM
#endif
    {NULL, NULL}
};

static ConstDef consts_ccm[] = {
    {"CCM_3x3", static_cast<long>(cv::ccm::CCM_3x3)},
    {"CCM_3X3", static_cast<long>(cv::ccm::CCM_3x3)},
    {"CCM_4x3", static_cast<long>(cv::ccm::CCM_4x3)},
    {"CCM_4X3", static_cast<long>(cv::ccm::CCM_4x3)},
    {"COLORCHECKER_DigitalSG", static_cast<long>(cv::ccm::COLORCHECKER_DigitalSG)},
    {"COLORCHECKER_DIGITAL_SG", static_cast<long>(cv::ccm::COLORCHECKER_DigitalSG)},
    {"COLORCHECKER_Macbeth", static_cast<long>(cv::ccm::COLORCHECKER_Macbeth)},
    {"COLORCHECKER_MACBETH", static_cast<long>(cv::ccm::COLORCHECKER_Macbeth)},
    {"COLORCHECKER_Vinyl", static_cast<long>(cv::ccm::COLORCHECKER_Vinyl)},
    {"COLORCHECKER_VINYL", static_cast<long>(cv::ccm::COLORCHECKER_Vinyl)},
    {"COLOR_SPACE_AdobeRGB", static_cast<long>(cv::ccm::COLOR_SPACE_AdobeRGB)},
    {"COLOR_SPACE_ADOBE_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_AdobeRGB)},
    {"COLOR_SPACE_AdobeRGBL", static_cast<long>(cv::ccm::COLOR_SPACE_AdobeRGBL)},
    {"COLOR_SPACE_ADOBE_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_AdobeRGBL)},
    {"COLOR_SPACE_AppleRGB", static_cast<long>(cv::ccm::COLOR_SPACE_AppleRGB)},
    {"COLOR_SPACE_APPLE_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_AppleRGB)},
    {"COLOR_SPACE_AppleRGBL", static_cast<long>(cv::ccm::COLOR_SPACE_AppleRGBL)},
    {"COLOR_SPACE_APPLE_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_AppleRGBL)},
    {"COLOR_SPACE_DCI_P3_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_DCI_P3_RGB)},
    {"COLOR_SPACE_DCI_P3_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_DCI_P3_RGBL)},
    {"COLOR_SPACE_Lab_A_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_A_10)},
    {"COLOR_SPACE_LAB_A_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_A_10)},
    {"COLOR_SPACE_Lab_A_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_A_2)},
    {"COLOR_SPACE_LAB_A_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_A_2)},
    {"COLOR_SPACE_Lab_D50_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D50_10)},
    {"COLOR_SPACE_LAB_D50_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D50_10)},
    {"COLOR_SPACE_Lab_D50_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D50_2)},
    {"COLOR_SPACE_LAB_D50_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D50_2)},
    {"COLOR_SPACE_Lab_D55_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D55_10)},
    {"COLOR_SPACE_LAB_D55_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D55_10)},
    {"COLOR_SPACE_Lab_D55_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D55_2)},
    {"COLOR_SPACE_LAB_D55_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D55_2)},
    {"COLOR_SPACE_Lab_D65_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D65_10)},
    {"COLOR_SPACE_LAB_D65_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D65_10)},
    {"COLOR_SPACE_Lab_D65_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D65_2)},
    {"COLOR_SPACE_LAB_D65_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D65_2)},
    {"COLOR_SPACE_Lab_D75_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D75_10)},
    {"COLOR_SPACE_LAB_D75_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D75_10)},
    {"COLOR_SPACE_Lab_D75_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D75_2)},
    {"COLOR_SPACE_LAB_D75_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_D75_2)},
    {"COLOR_SPACE_Lab_E_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_E_10)},
    {"COLOR_SPACE_LAB_E_10", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_E_10)},
    {"COLOR_SPACE_Lab_E_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_E_2)},
    {"COLOR_SPACE_LAB_E_2", static_cast<long>(cv::ccm::COLOR_SPACE_Lab_E_2)},
    {"COLOR_SPACE_ProPhotoRGB", static_cast<long>(cv::ccm::COLOR_SPACE_ProPhotoRGB)},
    {"COLOR_SPACE_PRO_PHOTO_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_ProPhotoRGB)},
    {"COLOR_SPACE_ProPhotoRGBL", static_cast<long>(cv::ccm::COLOR_SPACE_ProPhotoRGBL)},
    {"COLOR_SPACE_PRO_PHOTO_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_ProPhotoRGBL)},
    {"COLOR_SPACE_REC_2020_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_REC_2020_RGB)},
    {"COLOR_SPACE_REC_2020_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_REC_2020_RGBL)},
    {"COLOR_SPACE_REC_709_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_REC_709_RGB)},
    {"COLOR_SPACE_REC_709_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_REC_709_RGBL)},
    {"COLOR_SPACE_WideGamutRGB", static_cast<long>(cv::ccm::COLOR_SPACE_WideGamutRGB)},
    {"COLOR_SPACE_WIDE_GAMUT_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_WideGamutRGB)},
    {"COLOR_SPACE_WideGamutRGBL", static_cast<long>(cv::ccm::COLOR_SPACE_WideGamutRGBL)},
    {"COLOR_SPACE_WIDE_GAMUT_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_WideGamutRGBL)},
    {"COLOR_SPACE_XYZ_A_10", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_A_10)},
    {"COLOR_SPACE_XYZ_A_2", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_A_2)},
    {"COLOR_SPACE_XYZ_D50_10", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D50_10)},
    {"COLOR_SPACE_XYZ_D50_2", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D50_2)},
    {"COLOR_SPACE_XYZ_D55_10", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D55_10)},
    {"COLOR_SPACE_XYZ_D55_2", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D55_2)},
    {"COLOR_SPACE_XYZ_D65_10", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D65_10)},
    {"COLOR_SPACE_XYZ_D65_2", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D65_2)},
    {"COLOR_SPACE_XYZ_D75_10", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D75_10)},
    {"COLOR_SPACE_XYZ_D75_2", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_D75_2)},
    {"COLOR_SPACE_XYZ_E_10", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_E_10)},
    {"COLOR_SPACE_XYZ_E_2", static_cast<long>(cv::ccm::COLOR_SPACE_XYZ_E_2)},
    {"COLOR_SPACE_sRGB", static_cast<long>(cv::ccm::COLOR_SPACE_sRGB)},
    {"COLOR_SPACE_S_RGB", static_cast<long>(cv::ccm::COLOR_SPACE_sRGB)},
    {"COLOR_SPACE_sRGBL", static_cast<long>(cv::ccm::COLOR_SPACE_sRGBL)},
    {"COLOR_SPACE_S_RGBL", static_cast<long>(cv::ccm::COLOR_SPACE_sRGBL)},
    {"DISTANCE_CIE2000", static_cast<long>(cv::ccm::DISTANCE_CIE2000)},
    {"DISTANCE_CIE76", static_cast<long>(cv::ccm::DISTANCE_CIE76)},
    {"DISTANCE_CIE94_GRAPHIC_ARTS", static_cast<long>(cv::ccm::DISTANCE_CIE94_GRAPHIC_ARTS)},
    {"DISTANCE_CIE94_TEXTILES", static_cast<long>(cv::ccm::DISTANCE_CIE94_TEXTILES)},
    {"DISTANCE_CMC_1TO1", static_cast<long>(cv::ccm::DISTANCE_CMC_1TO1)},
    {"DISTANCE_CMC_2TO1", static_cast<long>(cv::ccm::DISTANCE_CMC_2TO1)},
    {"DISTANCE_RGB", static_cast<long>(cv::ccm::DISTANCE_RGB)},
    {"DISTANCE_RGBL", static_cast<long>(cv::ccm::DISTANCE_RGBL)},
    {"INITIAL_METHOD_LEAST_SQUARE", static_cast<long>(cv::ccm::INITIAL_METHOD_LEAST_SQUARE)},
    {"INITIAL_METHOD_WHITE_BALANCE", static_cast<long>(cv::ccm::INITIAL_METHOD_WHITE_BALANCE)},
    {"LINEARIZATION_COLORLOGPOLYFIT", static_cast<long>(cv::ccm::LINEARIZATION_COLORLOGPOLYFIT)},
    {"LINEARIZATION_COLORPOLYFIT", static_cast<long>(cv::ccm::LINEARIZATION_COLORPOLYFIT)},
    {"LINEARIZATION_GAMMA", static_cast<long>(cv::ccm::LINEARIZATION_GAMMA)},
    {"LINEARIZATION_GRAYLOGPOLYFIT", static_cast<long>(cv::ccm::LINEARIZATION_GRAYLOGPOLYFIT)},
    {"LINEARIZATION_GRAYPOLYFIT", static_cast<long>(cv::ccm::LINEARIZATION_GRAYPOLYFIT)},
    {"LINEARIZATION_IDENTITY", static_cast<long>(cv::ccm::LINEARIZATION_IDENTITY)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_CCM
    PYOPENCV_EXTRA_CONSTANTS_CCM
#endif
    {NULL, 0}
};

static PyMethodDef methods_colored_kinfu[] = {
    {"ColoredKinFu_create", CV_PY_FN_WITH_KW_(pyopencv_cv_colored_kinfu_ColoredKinFu_create, 0), "ColoredKinFu_create(_params) -> retval\n."},
    {"Params_coarseParams", CV_PY_FN_WITH_KW_(pyopencv_cv_colored_kinfu_Params_coarseParams, 0), "Params_coarseParams() -> retval\n.   @brief Coarse parameters\n.       A set of parameters which provides better speed, can fail to match frames\n.       in case of rapid sensor motion."},
    {"Params_coloredTSDFParams", CV_PY_FN_WITH_KW_(pyopencv_cv_colored_kinfu_Params_coloredTSDFParams, 0), "Params_coloredTSDFParams(isCoarse) -> retval\n.   @brief ColoredTSDF parameters\n.         A set of parameters suitable for use with HashTSDFVolume"},
    {"Params_defaultParams", CV_PY_FN_WITH_KW_(pyopencv_cv_colored_kinfu_Params_defaultParams, 0), "Params_defaultParams() -> retval\n.   * @brief Default parameters\n.        * A set of parameters which provides better model quality, can be very slow."},
    {"Params_hashTSDFParams", CV_PY_FN_WITH_KW_(pyopencv_cv_colored_kinfu_Params_hashTSDFParams, 0), "Params_hashTSDFParams(isCoarse) -> retval\n.   @brief HashTSDF parameters\n.         A set of parameters suitable for use with HashTSDFVolume"},
#ifdef PYOPENCV_EXTRA_METHODS_COLORED_KINFU
    PYOPENCV_EXTRA_METHODS_COLORED_KINFU
#endif
    {NULL, NULL}
};

static ConstDef consts_colored_kinfu[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_COLORED_KINFU
    PYOPENCV_EXTRA_CONSTANTS_COLORED_KINFU
#endif
    {NULL, 0}
};

static PyMethodDef methods_cuda[] = {
    {"Event_elapsedTime", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_Event_elapsedTime, 0), "Event_elapsedTime(start, end) -> retval\n."},
    {"GpuMat_defaultAllocator", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_GpuMat_defaultAllocator, 0), "GpuMat_defaultAllocator() -> retval\n."},
    {"GpuMat_getStdAllocator", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_GpuMat_getStdAllocator, 0), "GpuMat_getStdAllocator() -> retval\n."},
    {"GpuMat_setDefaultAllocator", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_GpuMat_setDefaultAllocator, 0), "GpuMat_setDefaultAllocator(allocator) -> None\n."},
    {"SURF_CUDA_create", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_SURF_CUDA_create, 0), "SURF_CUDA_create(_hessianThreshold[, _nOctaves[, _nOctaveLayers[, _extended[, _keypointsRatio[, _upright]]]]]) -> retval\n.   @param _hessianThreshold Threshold for hessian keypoint detector used in SURF.\n.       @param _nOctaves Number of pyramid octaves the keypoint detector will use.\n.       @param _nOctaveLayers Number of octave layers within each octave.\n.       @param _extended Extended descriptor flag (true - use extended 128-element descriptors; false - use\n.       64-element descriptors).\n.       @param _keypointsRatio Limits a maximum number of features\n.       @param _upright Up-right or rotated features flag (true - do not compute orientation of features;\n.       false - compute orientation)."},
    {"Stream_Null", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_Stream_Null, 0), "Stream_Null() -> retval\n.   @brief Adds a callback to be called on the host after all currently enqueued items in the stream have\n.       completed.\n.   \n.       @note Callbacks must not make any CUDA API calls. Callbacks must not perform any synchronization\n.       that may depend on outstanding device work or other callbacks that are not mandated to run earlier.\n.       Callbacks without a mandated order (in independent streams) execute in undefined order and may be\n.       serialized."},
    {"TargetArchs_has", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_has, 0), "TargetArchs_has(major, minor) -> retval\n.   @brief There is a set of methods to check whether the module contains intermediate (PTX) or binary CUDA\n.       code for the given architecture(s):\n.   \n.       @param major Major compute capability version.\n.       @param minor Minor compute capability version."},
    {"TargetArchs_hasBin", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_hasBin, 0), "TargetArchs_hasBin(major, minor) -> retval\n."},
    {"TargetArchs_hasEqualOrGreater", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_hasEqualOrGreater, 0), "TargetArchs_hasEqualOrGreater(major, minor) -> retval\n."},
    {"TargetArchs_hasEqualOrGreaterBin", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_hasEqualOrGreaterBin, 0), "TargetArchs_hasEqualOrGreaterBin(major, minor) -> retval\n."},
    {"TargetArchs_hasEqualOrGreaterPtx", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_hasEqualOrGreaterPtx, 0), "TargetArchs_hasEqualOrGreaterPtx(major, minor) -> retval\n."},
    {"TargetArchs_hasEqualOrLessPtx", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_hasEqualOrLessPtx, 0), "TargetArchs_hasEqualOrLessPtx(major, minor) -> retval\n."},
    {"TargetArchs_hasPtx", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_TargetArchs_hasPtx, 0), "TargetArchs_hasPtx(major, minor) -> retval\n."},
    {"createContinuous", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_createContinuous, 0), "createContinuous(rows, cols, type[, arr]) -> arr\n.   @brief Creates a continuous matrix.\n.   \n.   @param rows Row count.\n.   @param cols Column count.\n.   @param type Type of the matrix.\n.   @param arr Destination matrix. This parameter changes only if it has a proper type and area (\n.   \\f$\\texttt{rows} \\times \\texttt{cols}\\f$ ).\n.   \n.   Matrix is called continuous if its elements are stored continuously, that is, without gaps at the\n.   end of each row."},
    {"createGpuMatFromCudaMemory", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_createGpuMatFromCudaMemory, 0), "createGpuMatFromCudaMemory(rows, cols, type, cudaMemoryAddress[, step]) -> retval\n.   @brief Bindings overload to create a GpuMat from existing GPU memory.\n.   @param rows Row count.\n.   @param cols Column count.\n.   @param type Type of the matrix.\n.   @param cudaMemoryAddress Address of the allocated GPU memory on the device. This does not allocate matrix data. Instead, it just initializes the matrix header that points to the specified \\a cudaMemoryAddress, which means that no data is copied. This operation is very efficient and can be used to process external data using OpenCV functions. The external data is not automatically deallocated, so you should take care of it.\n.   @param step Number of bytes each matrix row occupies. The value should include the padding bytes at the end of each row, if any. If the parameter is missing (set to Mat::AUTO_STEP ), no padding is assumed and the actual step is calculated as cols*elemSize(). See GpuMat::elemSize.\n.   @note Overload for generation of bindings only, not exported or intended for use internally from C++.\n\n\n\ncreateGpuMatFromCudaMemory(size, type, cudaMemoryAddress[, step]) -> retval\n.   @overload\n.   @param size 2D array size: Size(cols, rows). In the Size() constructor, the number of rows and the number of columns go in the reverse order.\n.   @param type Type of the matrix.\n.   @param cudaMemoryAddress Address of the allocated GPU memory on the device. This does not allocate matrix data. Instead, it just initializes the matrix header that points to the specified \\a cudaMemoryAddress, which means that no data is copied. This operation is very efficient and can be used to process external data using OpenCV functions. The external data is not automatically deallocated, so you should take care of it.\n.   @param step Number of bytes each matrix row occupies. The value should include the padding bytes at the end of each row, if any. If the parameter is missing (set to Mat::AUTO_STEP ), no padding is assumed and the actual step is calculated as cols*elemSize(). See GpuMat::elemSize.\n.   @note Overload for generation of bindings only, not exported or intended for use internally from C++."},
    {"ensureSizeIsEnough", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_ensureSizeIsEnough, 0), "ensureSizeIsEnough(rows, cols, type[, arr]) -> arr\n.   @brief Ensures that the size of a matrix is big enough and the matrix has a proper type.\n.   \n.   @param rows Minimum desired number of rows.\n.   @param cols Minimum desired number of columns.\n.   @param type Desired matrix type.\n.   @param arr Destination matrix.\n.   \n.   The function does not reallocate memory if the matrix has proper attributes already."},
    {"fastNlMeansDenoising", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_fastNlMeansDenoising, 0), "fastNlMeansDenoising(src, h[, dst[, search_window[, block_size[, stream]]]]) -> dst\n.   @brief Perform image denoising using Non-local Means Denoising algorithm\n.   <http://www.ipol.im/pub/algo/bcm_non_local_means_denoising> with several computational\n.   optimizations. Noise expected to be a gaussian white noise\n.   \n.   @param src Input 8-bit 1-channel, 2-channel or 3-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param h Parameter regulating filter strength. Big h value perfectly removes noise but also\n.   removes image details, smaller h value preserves details but also preserves some noise\n.   @param search_window Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater search_window - greater\n.   denoising time. Recommended value 21 pixels\n.   @param block_size Size in pixels of the template patch that is used to compute weights. Should be\n.   odd. Recommended value 7 pixels\n.   @param stream Stream for the asynchronous invocations.\n.   \n.   This function expected to be applied to grayscale images. For colored images look at\n.   FastNonLocalMeansDenoising::labMethod.\n.   \n.   @sa\n.      fastNlMeansDenoising"},
    {"fastNlMeansDenoisingColored", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_fastNlMeansDenoisingColored, 0), "fastNlMeansDenoisingColored(src, h_luminance, photo_render[, dst[, search_window[, block_size[, stream]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for colored images\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param h_luminance Parameter regulating filter strength. Big h value perfectly removes noise but\n.   also removes image details, smaller h value preserves details but also preserves some noise\n.   @param photo_render float The same as h but for color components. For most images value equals 10 will be\n.   enough to remove colored noise and do not distort colors\n.   @param search_window Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater search_window - greater\n.   denoising time. Recommended value 21 pixels\n.   @param block_size Size in pixels of the template patch that is used to compute weights. Should be\n.   odd. Recommended value 7 pixels\n.   @param stream Stream for the asynchronous invocations.\n.   \n.   The function converts image to CIELAB colorspace and then separately denoise L and AB components\n.   with given h parameters using FastNonLocalMeansDenoising::simpleMethod function.\n.   \n.   @sa\n.      fastNlMeansDenoisingColored"},
    {"getCudaEnabledDeviceCount", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_getCudaEnabledDeviceCount, 0), "getCudaEnabledDeviceCount() -> retval\n.   @brief Returns the number of installed CUDA-enabled devices.\n.   \n.   Use this function before any other CUDA functions calls. If OpenCV is compiled without CUDA support,\n.   this function returns 0. If the CUDA driver is not installed, or is incompatible, this function\n.   returns -1."},
    {"getDevice", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_getDevice, 0), "getDevice() -> retval\n.   @brief Returns the current device index set by cuda::setDevice or initialized by default."},
    {"nonLocalMeans", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_nonLocalMeans, 0), "nonLocalMeans(src, h[, dst[, search_window[, block_size[, borderMode[, stream]]]]]) -> dst\n.   @brief Performs pure non local means denoising without any simplification, and thus it is not fast.\n.   \n.   @param src Source image. Supports only CV_8UC1, CV_8UC2 and CV_8UC3.\n.   @param dst Destination image.\n.   @param h Filter sigma regulating filter strength for color.\n.   @param search_window Size of search window.\n.   @param block_size Size of block used for computing weights.\n.   @param borderMode Border type. See borderInterpolate for details. BORDER_REFLECT101 ,\n.   BORDER_REPLICATE , BORDER_CONSTANT , BORDER_REFLECT and BORDER_WRAP are supported for now.\n.   @param stream Stream for the asynchronous version.\n.   \n.   @sa\n.      fastNlMeansDenoising"},
    {"printCudaDeviceInfo", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_printCudaDeviceInfo, 0), "printCudaDeviceInfo(device) -> None\n."},
    {"printShortCudaDeviceInfo", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_printShortCudaDeviceInfo, 0), "printShortCudaDeviceInfo(device) -> None\n."},
    {"registerPageLocked", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_registerPageLocked, 0), "registerPageLocked(m) -> None\n.   @brief Page-locks the memory of matrix and maps it for the device(s).\n.   \n.   @param m Input matrix."},
    {"resetDevice", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_resetDevice, 0), "resetDevice() -> None\n.   @brief Explicitly destroys and cleans up all resources associated with the current device in the current\n.   process.\n.   \n.   Any subsequent API call to this device will reinitialize the device."},
    {"setBufferPoolConfig", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_setBufferPoolConfig, 0), "setBufferPoolConfig(deviceId, stackSize, stackCount) -> None\n."},
    {"setBufferPoolUsage", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_setBufferPoolUsage, 0), "setBufferPoolUsage(on) -> None\n."},
    {"setDevice", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_setDevice, 0), "setDevice(device) -> None\n.   @brief Sets a device and initializes it for the current thread.\n.   \n.   @param device System index of a CUDA device starting with 0.\n.   \n.   If the call of this function is omitted, a default device is initialized at the fist CUDA usage."},
    {"unregisterPageLocked", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_unregisterPageLocked, 0), "unregisterPageLocked(m) -> None\n.   @brief Unmaps the memory of matrix and makes it pageable again.\n.   \n.   @param m Input matrix."},
    {"wrapStream", CV_PY_FN_WITH_KW_(pyopencv_cv_cuda_wrapStream, 0), "wrapStream(cudaStreamMemoryAddress) -> retval\n.   @brief Bindings overload to create a Stream object from the address stored in an existing CUDA Runtime API stream pointer (cudaStream_t).\n.   @param cudaStreamMemoryAddress Memory address stored in a CUDA Runtime API stream pointer (cudaStream_t). The created Stream object does not perform any allocation or deallocation and simply wraps existing raw CUDA Runtime API stream pointer.\n.   @note Overload for generation of bindings only, not exported or intended for use internally from C++."},
#ifdef PYOPENCV_EXTRA_METHODS_CUDA
    PYOPENCV_EXTRA_METHODS_CUDA
#endif
    {NULL, NULL}
};

static ConstDef consts_cuda[] = {
    {"DYNAMIC_PARALLELISM", static_cast<long>(cv::cuda::DYNAMIC_PARALLELISM)},
    {"DeviceInfo_ComputeModeDefault", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeDefault)},
    {"DEVICE_INFO_COMPUTE_MODE_DEFAULT", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeDefault)},
    {"DeviceInfo_ComputeModeExclusive", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeExclusive)},
    {"DEVICE_INFO_COMPUTE_MODE_EXCLUSIVE", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeExclusive)},
    {"DeviceInfo_ComputeModeExclusiveProcess", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeExclusiveProcess)},
    {"DEVICE_INFO_COMPUTE_MODE_EXCLUSIVE_PROCESS", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeExclusiveProcess)},
    {"DeviceInfo_ComputeModeProhibited", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeProhibited)},
    {"DEVICE_INFO_COMPUTE_MODE_PROHIBITED", static_cast<long>(cv::cuda::DeviceInfo::ComputeModeProhibited)},
    {"Event_BLOCKING_SYNC", static_cast<long>(cv::cuda::Event::BLOCKING_SYNC)},
    {"EVENT_BLOCKING_SYNC", static_cast<long>(cv::cuda::Event::BLOCKING_SYNC)},
    {"Event_DEFAULT", static_cast<long>(cv::cuda::Event::DEFAULT)},
    {"EVENT_DEFAULT", static_cast<long>(cv::cuda::Event::DEFAULT)},
    {"Event_DISABLE_TIMING", static_cast<long>(cv::cuda::Event::DISABLE_TIMING)},
    {"EVENT_DISABLE_TIMING", static_cast<long>(cv::cuda::Event::DISABLE_TIMING)},
    {"Event_INTERPROCESS", static_cast<long>(cv::cuda::Event::INTERPROCESS)},
    {"EVENT_INTERPROCESS", static_cast<long>(cv::cuda::Event::INTERPROCESS)},
    {"FEATURE_SET_COMPUTE_10", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_10)},
    {"FEATURE_SET_COMPUTE_11", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_11)},
    {"FEATURE_SET_COMPUTE_12", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_12)},
    {"FEATURE_SET_COMPUTE_13", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_13)},
    {"FEATURE_SET_COMPUTE_20", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_20)},
    {"FEATURE_SET_COMPUTE_21", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_21)},
    {"FEATURE_SET_COMPUTE_30", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_30)},
    {"FEATURE_SET_COMPUTE_32", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_32)},
    {"FEATURE_SET_COMPUTE_35", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_35)},
    {"FEATURE_SET_COMPUTE_50", static_cast<long>(cv::cuda::FEATURE_SET_COMPUTE_50)},
    {"GLOBAL_ATOMICS", static_cast<long>(cv::cuda::GLOBAL_ATOMICS)},
    {"HostMem_PAGE_LOCKED", static_cast<long>(cv::cuda::HostMem::PAGE_LOCKED)},
    {"HOST_MEM_PAGE_LOCKED", static_cast<long>(cv::cuda::HostMem::PAGE_LOCKED)},
    {"HostMem_SHARED", static_cast<long>(cv::cuda::HostMem::SHARED)},
    {"HOST_MEM_SHARED", static_cast<long>(cv::cuda::HostMem::SHARED)},
    {"HostMem_WRITE_COMBINED", static_cast<long>(cv::cuda::HostMem::WRITE_COMBINED)},
    {"HOST_MEM_WRITE_COMBINED", static_cast<long>(cv::cuda::HostMem::WRITE_COMBINED)},
    {"NATIVE_DOUBLE", static_cast<long>(cv::cuda::NATIVE_DOUBLE)},
    {"SHARED_ATOMICS", static_cast<long>(cv::cuda::SHARED_ATOMICS)},
    {"SURF_CUDA_ANGLE_ROW", static_cast<long>(cv::cuda::SURF_CUDA::ANGLE_ROW)},
    {"SURF_CUDA_HESSIAN_ROW", static_cast<long>(cv::cuda::SURF_CUDA::HESSIAN_ROW)},
    {"SURF_CUDA_LAPLACIAN_ROW", static_cast<long>(cv::cuda::SURF_CUDA::LAPLACIAN_ROW)},
    {"SURF_CUDA_OCTAVE_ROW", static_cast<long>(cv::cuda::SURF_CUDA::OCTAVE_ROW)},
    {"SURF_CUDA_ROWS_COUNT", static_cast<long>(cv::cuda::SURF_CUDA::ROWS_COUNT)},
    {"SURF_CUDA_SIZE_ROW", static_cast<long>(cv::cuda::SURF_CUDA::SIZE_ROW)},
    {"SURF_CUDA_X_ROW", static_cast<long>(cv::cuda::SURF_CUDA::X_ROW)},
    {"SURF_CUDA_Y_ROW", static_cast<long>(cv::cuda::SURF_CUDA::Y_ROW)},
    {"WARP_SHUFFLE_FUNCTIONS", static_cast<long>(cv::cuda::WARP_SHUFFLE_FUNCTIONS)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_CUDA
    PYOPENCV_EXTRA_CONSTANTS_CUDA
#endif
    {NULL, 0}
};

static PyMethodDef methods_datasets[] = {
#ifdef PYOPENCV_EXTRA_METHODS_DATASETS
    PYOPENCV_EXTRA_METHODS_DATASETS
#endif
    {NULL, NULL}
};

static ConstDef consts_datasets[] = {
    {"LADYBUG", static_cast<long>(cv::datasets::LADYBUG)},
    {"LEFT", static_cast<long>(cv::datasets::LEFT)},
    {"NEG", static_cast<long>(cv::datasets::NEG)},
    {"POS", static_cast<long>(cv::datasets::POS)},
    {"RIGHT", static_cast<long>(cv::datasets::RIGHT)},
    {"circle", static_cast<long>(cv::datasets::circle)},
    {"CIRCLE", static_cast<long>(cv::datasets::circle)},
    {"comehere", static_cast<long>(cv::datasets::comehere)},
    {"COMEHERE", static_cast<long>(cv::datasets::comehere)},
    {"cross", static_cast<long>(cv::datasets::cross)},
    {"CROSS", static_cast<long>(cv::datasets::cross)},
    {"dark", static_cast<long>(cv::datasets::dark)},
    {"DARK", static_cast<long>(cv::datasets::dark)},
    {"female", static_cast<long>(cv::datasets::female)},
    {"FEMALE", static_cast<long>(cv::datasets::female)},
    {"fist", static_cast<long>(cv::datasets::fist)},
    {"FIST", static_cast<long>(cv::datasets::fist)},
    {"flat", static_cast<long>(cv::datasets::flat)},
    {"FLAT", static_cast<long>(cv::datasets::flat)},
    {"humaneva_1", static_cast<long>(cv::datasets::humaneva_1)},
    {"HUMANEVA_1", static_cast<long>(cv::datasets::humaneva_1)},
    {"humaneva_2", static_cast<long>(cv::datasets::humaneva_2)},
    {"HUMANEVA_2", static_cast<long>(cv::datasets::humaneva_2)},
    {"index", static_cast<long>(cv::datasets::index)},
    {"INDEX", static_cast<long>(cv::datasets::index)},
    {"light", static_cast<long>(cv::datasets::light)},
    {"LIGHT", static_cast<long>(cv::datasets::light)},
    {"male", static_cast<long>(cv::datasets::male)},
    {"MALE", static_cast<long>(cv::datasets::male)},
    {"none", static_cast<long>(cv::datasets::none)},
    {"NONE", static_cast<long>(cv::datasets::none)},
    {"paperWithCharacters", static_cast<long>(cv::datasets::paperWithCharacters)},
    {"PAPER_WITH_CHARACTERS", static_cast<long>(cv::datasets::paperWithCharacters)},
    {"pat", static_cast<long>(cv::datasets::pat)},
    {"PAT", static_cast<long>(cv::datasets::pat)},
    {"rightleft", static_cast<long>(cv::datasets::rightleft)},
    {"RIGHTLEFT", static_cast<long>(cv::datasets::rightleft)},
    {"triangle", static_cast<long>(cv::datasets::triangle)},
    {"TRIANGLE", static_cast<long>(cv::datasets::triangle)},
    {"turnaround", static_cast<long>(cv::datasets::turnaround)},
    {"TURNAROUND", static_cast<long>(cv::datasets::turnaround)},
    {"updown", static_cast<long>(cv::datasets::updown)},
    {"UPDOWN", static_cast<long>(cv::datasets::updown)},
    {"wave", static_cast<long>(cv::datasets::wave)},
    {"WAVE", static_cast<long>(cv::datasets::wave)},
    {"whitePaper", static_cast<long>(cv::datasets::whitePaper)},
    {"WHITE_PAPER", static_cast<long>(cv::datasets::whitePaper)},
    {"woodenBoard", static_cast<long>(cv::datasets::woodenBoard)},
    {"WOODEN_BOARD", static_cast<long>(cv::datasets::woodenBoard)},
    {"z", static_cast<long>(cv::datasets::z)},
    {"Z", static_cast<long>(cv::datasets::z)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_DATASETS
    PYOPENCV_EXTRA_CONSTANTS_DATASETS
#endif
    {NULL, 0}
};

static PyMethodDef methods_detail[] = {
    {"BestOf2NearestMatcher_create", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_BestOf2NearestMatcher_create, 0), "BestOf2NearestMatcher_create([, try_use_gpu[, match_conf[, num_matches_thresh1[, num_matches_thresh2[, matches_confindece_thresh]]]]]) -> retval\n."},
    {"Blender_createDefault", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_Blender_createDefault, 0), "Blender_createDefault(type[, try_gpu]) -> retval\n."},
    {"ExposureCompensator_createDefault", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_ExposureCompensator_createDefault, 0), "ExposureCompensator_createDefault(type) -> retval\n."},
    {"SeamFinder_createDefault", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_SeamFinder_createDefault, 0), "SeamFinder_createDefault(type) -> retval\n."},
    {"Timelapser_createDefault", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_Timelapser_createDefault, 0), "Timelapser_createDefault(type) -> retval\n."},
    {"calibrateRotatingCamera", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_calibrateRotatingCamera, 0), "calibrateRotatingCamera(Hs[, K]) -> retval, K\n.   @brief Estimates focal lengths for each given camera.\n.   \n.   @param features Features of images.\n.   @param pairwise_matches Matches between all image pairs.\n.   @param focals Estimated focal lengths for each camera."},
    {"computeImageFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_computeImageFeatures, 0), "computeImageFeatures(featuresFinder, images[, masks]) -> features\n.   @brief\n.   \n.   @param featuresFinder\n.   @param images\n.   @param features\n.   @param masks"},
    {"computeImageFeatures2", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_computeImageFeatures2, 0), "computeImageFeatures2(featuresFinder, image[, mask]) -> features\n.   @brief\n.   \n.   @param featuresFinder\n.   @param image\n.   @param features\n.   @param mask"},
    {"createLaplacePyr", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_createLaplacePyr, 0), "createLaplacePyr(img, num_levels, pyr) -> pyr\n."},
    {"createLaplacePyrGpu", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_createLaplacePyrGpu, 0), "createLaplacePyrGpu(img, num_levels, pyr) -> pyr\n."},
    {"createWeightMap", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_createWeightMap, 0), "createWeightMap(mask, sharpness, weight) -> weight\n."},
    {"focalsFromHomography", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_focalsFromHomography, 0), "focalsFromHomography(H, f0, f1, f0_ok, f1_ok) -> None\n.   @brief Tries to estimate focal lengths from the given homography under the assumption that the camera\n.   undergoes rotations around its centre only.\n.   \n.   @param H Homography.\n.   @param f0 Estimated focal length along X axis.\n.   @param f1 Estimated focal length along Y axis.\n.   @param f0_ok True, if f0 was estimated successfully, false otherwise.\n.   @param f1_ok True, if f1 was estimated successfully, false otherwise.\n.   \n.   See \"Construction of Panoramic Image Mosaics with Global and Local Alignment\"\n.   by Heung-Yeung Shum and Richard Szeliski."},
    {"leaveBiggestComponent", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_leaveBiggestComponent, 0), "leaveBiggestComponent(features, pairwise_matches, conf_threshold) -> retval\n."},
    {"matchesGraphAsString", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_matchesGraphAsString, 0), "matchesGraphAsString(paths, pairwise_matches, conf_threshold) -> retval\n."},
    {"normalizeUsingWeightMap", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_normalizeUsingWeightMap, 0), "normalizeUsingWeightMap(weight, src) -> src\n."},
    {"overlapRoi", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_overlapRoi, 0), "overlapRoi(tl1, tl2, sz1, sz2, roi) -> retval\n."},
    {"restoreImageFromLaplacePyr", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_restoreImageFromLaplacePyr, 0), "restoreImageFromLaplacePyr(pyr) -> pyr\n."},
    {"restoreImageFromLaplacePyrGpu", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_restoreImageFromLaplacePyrGpu, 0), "restoreImageFromLaplacePyrGpu(pyr) -> pyr\n."},
    {"resultRoi", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_resultRoi, 0), "resultRoi(corners, images) -> retval\n.   \n\n\n\nresultRoi(corners, sizes) -> retval\n."},
    {"resultRoiIntersection", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_resultRoiIntersection, 0), "resultRoiIntersection(corners, sizes) -> retval\n."},
    {"resultTl", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_resultTl, 0), "resultTl(corners) -> retval\n."},
    {"selectRandomSubset", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_selectRandomSubset, 0), "selectRandomSubset(count, size, subset) -> None\n."},
    {"stitchingLogLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_stitchingLogLevel, 0), "stitchingLogLevel() -> retval\n."},
    {"strip", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_strip, 0), "strip(params) -> retval\n."},
    {"waveCorrect", CV_PY_FN_WITH_KW_(pyopencv_cv_detail_waveCorrect, 0), "waveCorrect(rmats, kind) -> rmats\n.   @brief Tries to make panorama more horizontal (or vertical).\n.   \n.   @param rmats Camera rotation matrices.\n.   @param kind Correction kind, see detail::WaveCorrectKind."},
#ifdef PYOPENCV_EXTRA_METHODS_DETAIL
    PYOPENCV_EXTRA_METHODS_DETAIL
#endif
    {NULL, NULL}
};

static ConstDef consts_detail[] = {
    {"ArgKind_GARRAY", static_cast<long>(cv::detail::ArgKind::GARRAY)},
    {"ARG_KIND_GARRAY", static_cast<long>(cv::detail::ArgKind::GARRAY)},
    {"ArgKind_GFRAME", static_cast<long>(cv::detail::ArgKind::GFRAME)},
    {"ARG_KIND_GFRAME", static_cast<long>(cv::detail::ArgKind::GFRAME)},
    {"ArgKind_GMAT", static_cast<long>(cv::detail::ArgKind::GMAT)},
    {"ARG_KIND_GMAT", static_cast<long>(cv::detail::ArgKind::GMAT)},
    {"ArgKind_GMATP", static_cast<long>(cv::detail::ArgKind::GMATP)},
    {"ARG_KIND_GMATP", static_cast<long>(cv::detail::ArgKind::GMATP)},
    {"ArgKind_GOBJREF", static_cast<long>(cv::detail::ArgKind::GOBJREF)},
    {"ARG_KIND_GOBJREF", static_cast<long>(cv::detail::ArgKind::GOBJREF)},
    {"ArgKind_GOPAQUE", static_cast<long>(cv::detail::ArgKind::GOPAQUE)},
    {"ARG_KIND_GOPAQUE", static_cast<long>(cv::detail::ArgKind::GOPAQUE)},
    {"ArgKind_GSCALAR", static_cast<long>(cv::detail::ArgKind::GSCALAR)},
    {"ARG_KIND_GSCALAR", static_cast<long>(cv::detail::ArgKind::GSCALAR)},
    {"ArgKind_OPAQUE", static_cast<long>(cv::detail::ArgKind::OPAQUE)},
    {"ARG_KIND_OPAQUE", static_cast<long>(cv::detail::ArgKind::OPAQUE)},
    {"ArgKind_OPAQUE_VAL", static_cast<long>(cv::detail::ArgKind::OPAQUE_VAL)},
    {"ARG_KIND_OPAQUE_VAL", static_cast<long>(cv::detail::ArgKind::OPAQUE_VAL)},
    {"Blender_FEATHER", static_cast<long>(cv::detail::Blender::FEATHER)},
    {"BLENDER_FEATHER", static_cast<long>(cv::detail::Blender::FEATHER)},
    {"Blender_MULTI_BAND", static_cast<long>(cv::detail::Blender::MULTI_BAND)},
    {"BLENDER_MULTI_BAND", static_cast<long>(cv::detail::Blender::MULTI_BAND)},
    {"Blender_NO", static_cast<long>(cv::detail::Blender::NO)},
    {"BLENDER_NO", static_cast<long>(cv::detail::Blender::NO)},
    {"CvFeatureParams_HAAR", static_cast<long>(cv::detail::CvFeatureParams::HAAR)},
    {"CV_FEATURE_PARAMS_HAAR", static_cast<long>(cv::detail::CvFeatureParams::HAAR)},
    {"CvFeatureParams_HOG", static_cast<long>(cv::detail::CvFeatureParams::HOG)},
    {"CV_FEATURE_PARAMS_HOG", static_cast<long>(cv::detail::CvFeatureParams::HOG)},
    {"CvFeatureParams_LBP", static_cast<long>(cv::detail::CvFeatureParams::LBP)},
    {"CV_FEATURE_PARAMS_LBP", static_cast<long>(cv::detail::CvFeatureParams::LBP)},
    {"DpSeamFinder_COLOR", static_cast<long>(cv::detail::DpSeamFinder::COLOR)},
    {"DP_SEAM_FINDER_COLOR", static_cast<long>(cv::detail::DpSeamFinder::COLOR)},
    {"DpSeamFinder_COLOR_GRAD", static_cast<long>(cv::detail::DpSeamFinder::COLOR_GRAD)},
    {"DP_SEAM_FINDER_COLOR_GRAD", static_cast<long>(cv::detail::DpSeamFinder::COLOR_GRAD)},
    {"ExposureCompensator_CHANNELS", static_cast<long>(cv::detail::ExposureCompensator::CHANNELS)},
    {"EXPOSURE_COMPENSATOR_CHANNELS", static_cast<long>(cv::detail::ExposureCompensator::CHANNELS)},
    {"ExposureCompensator_CHANNELS_BLOCKS", static_cast<long>(cv::detail::ExposureCompensator::CHANNELS_BLOCKS)},
    {"EXPOSURE_COMPENSATOR_CHANNELS_BLOCKS", static_cast<long>(cv::detail::ExposureCompensator::CHANNELS_BLOCKS)},
    {"ExposureCompensator_GAIN", static_cast<long>(cv::detail::ExposureCompensator::GAIN)},
    {"EXPOSURE_COMPENSATOR_GAIN", static_cast<long>(cv::detail::ExposureCompensator::GAIN)},
    {"ExposureCompensator_GAIN_BLOCKS", static_cast<long>(cv::detail::ExposureCompensator::GAIN_BLOCKS)},
    {"EXPOSURE_COMPENSATOR_GAIN_BLOCKS", static_cast<long>(cv::detail::ExposureCompensator::GAIN_BLOCKS)},
    {"ExposureCompensator_NO", static_cast<long>(cv::detail::ExposureCompensator::NO)},
    {"EXPOSURE_COMPENSATOR_NO", static_cast<long>(cv::detail::ExposureCompensator::NO)},
    {"GraphCutSeamFinderBase_COST_COLOR", static_cast<long>(cv::detail::GraphCutSeamFinderBase::COST_COLOR)},
    {"GRAPH_CUT_SEAM_FINDER_BASE_COST_COLOR", static_cast<long>(cv::detail::GraphCutSeamFinderBase::COST_COLOR)},
    {"GraphCutSeamFinderBase_COST_COLOR_GRAD", static_cast<long>(cv::detail::GraphCutSeamFinderBase::COST_COLOR_GRAD)},
    {"GRAPH_CUT_SEAM_FINDER_BASE_COST_COLOR_GRAD", static_cast<long>(cv::detail::GraphCutSeamFinderBase::COST_COLOR_GRAD)},
    {"OpaqueKind_CV_BOOL", static_cast<long>(cv::detail::OpaqueKind::CV_BOOL)},
    {"OPAQUE_KIND_CV_BOOL", static_cast<long>(cv::detail::OpaqueKind::CV_BOOL)},
    {"OpaqueKind_CV_DOUBLE", static_cast<long>(cv::detail::OpaqueKind::CV_DOUBLE)},
    {"OPAQUE_KIND_CV_DOUBLE", static_cast<long>(cv::detail::OpaqueKind::CV_DOUBLE)},
    {"OpaqueKind_CV_DRAW_PRIM", static_cast<long>(cv::detail::OpaqueKind::CV_DRAW_PRIM)},
    {"OPAQUE_KIND_CV_DRAW_PRIM", static_cast<long>(cv::detail::OpaqueKind::CV_DRAW_PRIM)},
    {"OpaqueKind_CV_FLOAT", static_cast<long>(cv::detail::OpaqueKind::CV_FLOAT)},
    {"OPAQUE_KIND_CV_FLOAT", static_cast<long>(cv::detail::OpaqueKind::CV_FLOAT)},
    {"OpaqueKind_CV_INT", static_cast<long>(cv::detail::OpaqueKind::CV_INT)},
    {"OPAQUE_KIND_CV_INT", static_cast<long>(cv::detail::OpaqueKind::CV_INT)},
    {"OpaqueKind_CV_INT64", static_cast<long>(cv::detail::OpaqueKind::CV_INT64)},
    {"OPAQUE_KIND_CV_INT64", static_cast<long>(cv::detail::OpaqueKind::CV_INT64)},
    {"OpaqueKind_CV_MAT", static_cast<long>(cv::detail::OpaqueKind::CV_MAT)},
    {"OPAQUE_KIND_CV_MAT", static_cast<long>(cv::detail::OpaqueKind::CV_MAT)},
    {"OpaqueKind_CV_POINT", static_cast<long>(cv::detail::OpaqueKind::CV_POINT)},
    {"OPAQUE_KIND_CV_POINT", static_cast<long>(cv::detail::OpaqueKind::CV_POINT)},
    {"OpaqueKind_CV_POINT2F", static_cast<long>(cv::detail::OpaqueKind::CV_POINT2F)},
    {"OPAQUE_KIND_CV_POINT2F", static_cast<long>(cv::detail::OpaqueKind::CV_POINT2F)},
    {"OpaqueKind_CV_POINT3F", static_cast<long>(cv::detail::OpaqueKind::CV_POINT3F)},
    {"OPAQUE_KIND_CV_POINT3F", static_cast<long>(cv::detail::OpaqueKind::CV_POINT3F)},
    {"OpaqueKind_CV_RECT", static_cast<long>(cv::detail::OpaqueKind::CV_RECT)},
    {"OPAQUE_KIND_CV_RECT", static_cast<long>(cv::detail::OpaqueKind::CV_RECT)},
    {"OpaqueKind_CV_SCALAR", static_cast<long>(cv::detail::OpaqueKind::CV_SCALAR)},
    {"OPAQUE_KIND_CV_SCALAR", static_cast<long>(cv::detail::OpaqueKind::CV_SCALAR)},
    {"OpaqueKind_CV_SIZE", static_cast<long>(cv::detail::OpaqueKind::CV_SIZE)},
    {"OPAQUE_KIND_CV_SIZE", static_cast<long>(cv::detail::OpaqueKind::CV_SIZE)},
    {"OpaqueKind_CV_STRING", static_cast<long>(cv::detail::OpaqueKind::CV_STRING)},
    {"OPAQUE_KIND_CV_STRING", static_cast<long>(cv::detail::OpaqueKind::CV_STRING)},
    {"OpaqueKind_CV_UINT64", static_cast<long>(cv::detail::OpaqueKind::CV_UINT64)},
    {"OPAQUE_KIND_CV_UINT64", static_cast<long>(cv::detail::OpaqueKind::CV_UINT64)},
    {"OpaqueKind_CV_UNKNOWN", static_cast<long>(cv::detail::OpaqueKind::CV_UNKNOWN)},
    {"OPAQUE_KIND_CV_UNKNOWN", static_cast<long>(cv::detail::OpaqueKind::CV_UNKNOWN)},
    {"SeamFinder_DP_SEAM", static_cast<long>(cv::detail::SeamFinder::DP_SEAM)},
    {"SEAM_FINDER_DP_SEAM", static_cast<long>(cv::detail::SeamFinder::DP_SEAM)},
    {"SeamFinder_NO", static_cast<long>(cv::detail::SeamFinder::NO)},
    {"SEAM_FINDER_NO", static_cast<long>(cv::detail::SeamFinder::NO)},
    {"SeamFinder_VORONOI_SEAM", static_cast<long>(cv::detail::SeamFinder::VORONOI_SEAM)},
    {"SEAM_FINDER_VORONOI_SEAM", static_cast<long>(cv::detail::SeamFinder::VORONOI_SEAM)},
    {"TEST_CUSTOM", static_cast<long>(cv::detail::TEST_CUSTOM)},
    {"TEST_EQ", static_cast<long>(cv::detail::TEST_EQ)},
    {"TEST_GE", static_cast<long>(cv::detail::TEST_GE)},
    {"TEST_GT", static_cast<long>(cv::detail::TEST_GT)},
    {"TEST_LE", static_cast<long>(cv::detail::TEST_LE)},
    {"TEST_LT", static_cast<long>(cv::detail::TEST_LT)},
    {"TEST_NE", static_cast<long>(cv::detail::TEST_NE)},
    {"Timelapser_AS_IS", static_cast<long>(cv::detail::Timelapser::AS_IS)},
    {"TIMELAPSER_AS_IS", static_cast<long>(cv::detail::Timelapser::AS_IS)},
    {"Timelapser_CROP", static_cast<long>(cv::detail::Timelapser::CROP)},
    {"TIMELAPSER_CROP", static_cast<long>(cv::detail::Timelapser::CROP)},
    {"TrackerContribSamplerCSC_MODE_DETECT", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_DETECT)},
    {"TRACKER_CONTRIB_SAMPLER_CSC_MODE_DETECT", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_DETECT)},
    {"TrackerContribSamplerCSC_MODE_INIT_NEG", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_INIT_NEG)},
    {"TRACKER_CONTRIB_SAMPLER_CSC_MODE_INIT_NEG", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_INIT_NEG)},
    {"TrackerContribSamplerCSC_MODE_INIT_POS", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_INIT_POS)},
    {"TRACKER_CONTRIB_SAMPLER_CSC_MODE_INIT_POS", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_INIT_POS)},
    {"TrackerContribSamplerCSC_MODE_TRACK_NEG", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_TRACK_NEG)},
    {"TRACKER_CONTRIB_SAMPLER_CSC_MODE_TRACK_NEG", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_TRACK_NEG)},
    {"TrackerContribSamplerCSC_MODE_TRACK_POS", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_TRACK_POS)},
    {"TRACKER_CONTRIB_SAMPLER_CSC_MODE_TRACK_POS", static_cast<long>(cv::detail::TrackerContribSamplerCSC::MODE_TRACK_POS)},
    {"TrackerSamplerCSC_MODE_DETECT", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_DETECT)},
    {"TRACKER_SAMPLER_CSC_MODE_DETECT", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_DETECT)},
    {"TrackerSamplerCSC_MODE_INIT_NEG", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_INIT_NEG)},
    {"TRACKER_SAMPLER_CSC_MODE_INIT_NEG", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_INIT_NEG)},
    {"TrackerSamplerCSC_MODE_INIT_POS", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_INIT_POS)},
    {"TRACKER_SAMPLER_CSC_MODE_INIT_POS", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_INIT_POS)},
    {"TrackerSamplerCSC_MODE_TRACK_NEG", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_TRACK_NEG)},
    {"TRACKER_SAMPLER_CSC_MODE_TRACK_NEG", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_TRACK_NEG)},
    {"TrackerSamplerCSC_MODE_TRACK_POS", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_TRACK_POS)},
    {"TRACKER_SAMPLER_CSC_MODE_TRACK_POS", static_cast<long>(cv::detail::TrackerSamplerCSC::MODE_TRACK_POS)},
    {"TrackerSamplerCS_MODE_CLASSIFY", static_cast<long>(cv::detail::TrackerSamplerCS::MODE_CLASSIFY)},
    {"TRACKER_SAMPLER_CS_MODE_CLASSIFY", static_cast<long>(cv::detail::TrackerSamplerCS::MODE_CLASSIFY)},
    {"TrackerSamplerCS_MODE_NEGATIVE", static_cast<long>(cv::detail::TrackerSamplerCS::MODE_NEGATIVE)},
    {"TRACKER_SAMPLER_CS_MODE_NEGATIVE", static_cast<long>(cv::detail::TrackerSamplerCS::MODE_NEGATIVE)},
    {"TrackerSamplerCS_MODE_POSITIVE", static_cast<long>(cv::detail::TrackerSamplerCS::MODE_POSITIVE)},
    {"TRACKER_SAMPLER_CS_MODE_POSITIVE", static_cast<long>(cv::detail::TrackerSamplerCS::MODE_POSITIVE)},
    {"WAVE_CORRECT_AUTO", static_cast<long>(cv::detail::WAVE_CORRECT_AUTO)},
    {"WAVE_CORRECT_HORIZ", static_cast<long>(cv::detail::WAVE_CORRECT_HORIZ)},
    {"WAVE_CORRECT_VERT", static_cast<long>(cv::detail::WAVE_CORRECT_VERT)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_DETAIL
    PYOPENCV_EXTRA_CONSTANTS_DETAIL
#endif
    {NULL, 0}
};

static PyMethodDef methods_dnn[] = {
    {"NMSBoxes", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_NMSBoxes, 0), "NMSBoxes(bboxes, scores, score_threshold, nms_threshold[, eta[, top_k]]) -> indices\n.   @brief Performs non maximum suppression given boxes and corresponding scores.\n.   \n.        * @param bboxes a set of bounding boxes to apply NMS.\n.        * @param scores a set of corresponding confidences.\n.        * @param score_threshold a threshold used to filter boxes by score.\n.        * @param nms_threshold a threshold used in non maximum suppression.\n.        * @param indices the kept indices of bboxes after NMS.\n.        * @param eta a coefficient in adaptive threshold formula: \\f$nms\\_threshold_{i+1}=eta\\cdot nms\\_threshold_i\\f$.\n.        * @param top_k if `>0`, keep at most @p top_k picked indices."},
    {"NMSBoxesBatched", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_NMSBoxesBatched, 0), "NMSBoxesBatched(bboxes, scores, class_ids, score_threshold, nms_threshold[, eta[, top_k]]) -> indices\n.   @brief Performs batched non maximum suppression on given boxes and corresponding scores across different classes.\n.   \n.        * @param bboxes a set of bounding boxes to apply NMS.\n.        * @param scores a set of corresponding confidences.\n.        * @param class_ids a set of corresponding class ids. Ids are integer and usually start from 0.\n.        * @param score_threshold a threshold used to filter boxes by score.\n.        * @param nms_threshold a threshold used in non maximum suppression.\n.        * @param indices the kept indices of bboxes after NMS.\n.        * @param eta a coefficient in adaptive threshold formula: \\f$nms\\_threshold_{i+1}=eta\\cdot nms\\_threshold_i\\f$.\n.        * @param top_k if `>0`, keep at most @p top_k picked indices."},
    {"NMSBoxesRotated", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_NMSBoxesRotated, 0), "NMSBoxesRotated(bboxes, scores, score_threshold, nms_threshold[, eta[, top_k]]) -> indices\n."},
    {"Net_readFromModelOptimizer", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_Net_readFromModelOptimizer, 0), "Net_readFromModelOptimizer(xml, bin) -> retval\n.   @brief Create a network from Intel's Model Optimizer intermediate representation (IR).\n.            *  @param[in] xml XML configuration file with network's topology.\n.            *  @param[in] bin Binary file with trained weights.\n.            *  Networks imported from Intel's Model Optimizer are launched in Intel's Inference Engine\n.            *  backend.\n\n\n\nNet_readFromModelOptimizer(bufferModelConfig, bufferWeights) -> retval\n.   @brief Create a network from Intel's Model Optimizer in-memory buffers with intermediate representation (IR).\n.            *  @param[in] bufferModelConfig buffer with model's configuration.\n.            *  @param[in] bufferWeights buffer with model's trained weights.\n.            *  @returns Net object."},
    {"blobFromImage", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_blobFromImage, 0), "blobFromImage(image[, scalefactor[, size[, mean[, swapRB[, crop[, ddepth]]]]]]) -> retval\n.   @brief Creates 4-dimensional blob from image. Optionally resizes and crops @p image from center,\n.        *  subtract @p mean values, scales values by @p scalefactor, swap Blue and Red channels.\n.        *  @param image input image (with 1-, 3- or 4-channels).\n.        *  @param scalefactor multiplier for @p images values.\n.        *  @param size spatial size for output image\n.        *  @param mean scalar with mean values which are subtracted from channels. Values are intended\n.        *  to be in (mean-R, mean-G, mean-B) order if @p image has BGR ordering and @p swapRB is true.\n.        *  @param swapRB flag which indicates that swap first and last channels\n.        *  in 3-channel image is necessary.\n.        *  @param crop flag which indicates whether image will be cropped after resize or not\n.        *  @param ddepth Depth of output blob. Choose CV_32F or CV_8U.\n.        *  @details if @p crop is true, input image is resized so one side after resize is equal to corresponding\n.        *  dimension in @p size and another one is equal or larger. Then, crop from the center is performed.\n.        *  If @p crop is false, direct resize without cropping and preserving aspect ratio is performed.\n.        *  @returns 4-dimensional Mat with NCHW dimensions order.\n.        *\n.        * @note\n.        * The order and usage of `scalefactor` and `mean` are (input - mean) * scalefactor."},
    {"blobFromImageWithParams", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_blobFromImageWithParams, 0), "blobFromImageWithParams(image[, param]) -> retval\n.   @brief Creates 4-dimensional blob from image with given params.\n.        *\n.        *  @details This function is an extension of @ref blobFromImage to meet more image preprocess needs.\n.        *  Given input image and preprocessing parameters, and function outputs the blob.\n.        *\n.        *  @param image input image (all with 1-, 3- or 4-channels).\n.        *  @param param struct of Image2BlobParams, contains all parameters needed by processing of image to blob.\n.        *  @return 4-dimensional Mat.\n\n\n\nblobFromImageWithParams(image[, blob[, param]]) -> blob\n.   @overload"},
    {"blobFromImages", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_blobFromImages, 0), "blobFromImages(images[, scalefactor[, size[, mean[, swapRB[, crop[, ddepth]]]]]]) -> retval\n.   @brief Creates 4-dimensional blob from series of images. Optionally resizes and\n.        *  crops @p images from center, subtract @p mean values, scales values by @p scalefactor,\n.        *  swap Blue and Red channels.\n.        *  @param images input images (all with 1-, 3- or 4-channels).\n.        *  @param size spatial size for output image\n.        *  @param mean scalar with mean values which are subtracted from channels. Values are intended\n.        *  to be in (mean-R, mean-G, mean-B) order if @p image has BGR ordering and @p swapRB is true.\n.        *  @param scalefactor multiplier for @p images values.\n.        *  @param swapRB flag which indicates that swap first and last channels\n.        *  in 3-channel image is necessary.\n.        *  @param crop flag which indicates whether image will be cropped after resize or not\n.        *  @param ddepth Depth of output blob. Choose CV_32F or CV_8U.\n.        *  @details if @p crop is true, input image is resized so one side after resize is equal to corresponding\n.        *  dimension in @p size and another one is equal or larger. Then, crop from the center is performed.\n.        *  If @p crop is false, direct resize without cropping and preserving aspect ratio is performed.\n.        *  @returns 4-dimensional Mat with NCHW dimensions order.\n.        *\n.        * @note\n.        * The order and usage of `scalefactor` and `mean` are (input - mean) * scalefactor."},
    {"blobFromImagesWithParams", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_blobFromImagesWithParams, 0), "blobFromImagesWithParams(images[, param]) -> retval\n.   @brief Creates 4-dimensional blob from series of images with given params.\n.        *\n.        *  @details This function is an extension of @ref blobFromImages to meet more image preprocess needs.\n.        *  Given input image and preprocessing parameters, and function outputs the blob.\n.        *\n.        *  @param images input image (all with 1-, 3- or 4-channels).\n.        *  @param param struct of Image2BlobParams, contains all parameters needed by processing of image to blob.\n.        *  @returns 4-dimensional Mat.\n\n\n\nblobFromImagesWithParams(images[, blob[, param]]) -> blob\n.   @overload"},
    {"getAvailableTargets", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_getAvailableTargets, 0), "getAvailableTargets(be) -> retval\n."},
    {"imagesFromBlob", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_imagesFromBlob, 0), "imagesFromBlob(blob_[, images_]) -> images_\n.   @brief Parse a 4D blob and output the images it contains as 2D arrays through a simpler data structure\n.        *  (std::vector<cv::Mat>).\n.        *  @param[in] blob_ 4 dimensional array (images, channels, height, width) in floating point precision (CV_32F) from\n.        *  which you would like to extract the images.\n.        *  @param[out] images_ array of 2D Mat containing the images extracted from the blob in floating point precision\n.        *  (CV_32F). They are non normalized neither mean added. The number of returned images equals the first dimension\n.        *  of the blob (batch size). Every image has a number of channels equals to the second dimension of the blob (depth)."},
    {"readNet", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNet, 0), "readNet(model[, config[, framework]]) -> retval\n.   * @brief Read deep learning network represented in one of the supported formats.\n.         * @param[in] model Binary file contains trained weights. The following file\n.         *                  extensions are expected for models from different frameworks:\n.         *                  * `*.caffemodel` (Caffe, http://caffe.berkeleyvision.org/)\n.         *                  * `*.pb` (TensorFlow, https://www.tensorflow.org/)\n.         *                  * `*.t7` | `*.net` (Torch, http://torch.ch/)\n.         *                  * `*.weights` (Darknet, https://pjreddie.com/darknet/)\n.         *                  * `*.bin` | `*.onnx` (OpenVINO, https://software.intel.com/openvino-toolkit)\n.         *                  * `*.onnx` (ONNX, https://onnx.ai/)\n.         * @param[in] config Text file contains network configuration. It could be a\n.         *                   file with the following extensions:\n.         *                  * `*.prototxt` (Caffe, http://caffe.berkeleyvision.org/)\n.         *                  * `*.pbtxt` (TensorFlow, https://www.tensorflow.org/)\n.         *                  * `*.cfg` (Darknet, https://pjreddie.com/darknet/)\n.         *                  * `*.xml` (OpenVINO, https://software.intel.com/openvino-toolkit)\n.         * @param[in] framework Explicit framework name tag to determine a format.\n.         * @returns Net object.\n.         *\n.         * This function automatically detects an origin framework of trained model\n.         * and calls an appropriate function such @ref readNetFromCaffe, @ref readNetFromTensorflow,\n.         * @ref readNetFromTorch or @ref readNetFromDarknet. An order of @p model and @p config\n.         * arguments does not matter.\n\n\n\nreadNet(framework, bufferModel[, bufferConfig]) -> retval\n.   * @brief Read deep learning network represented in one of the supported formats.\n.         * @details This is an overloaded member function, provided for convenience.\n.         *          It differs from the above function only in what argument(s) it accepts.\n.         * @param[in] framework    Name of origin framework.\n.         * @param[in] bufferModel  A buffer with a content of binary file with weights\n.         * @param[in] bufferConfig A buffer with a content of text file contains network configuration.\n.         * @returns Net object."},
    {"readNetFromCaffe", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromCaffe, 0), "readNetFromCaffe(prototxt[, caffeModel]) -> retval\n.   @brief Reads a network model stored in <a href=\"http://caffe.berkeleyvision.org\">Caffe</a> framework's format.\n.         * @param prototxt   path to the .prototxt file with text description of the network architecture.\n.         * @param caffeModel path to the .caffemodel file with learned network.\n.         * @returns Net object.\n\n\n\nreadNetFromCaffe(bufferProto[, bufferModel]) -> retval\n.   @brief Reads a network model stored in Caffe model in memory.\n.         * @param bufferProto buffer containing the content of the .prototxt file\n.         * @param bufferModel buffer containing the content of the .caffemodel file\n.         * @returns Net object."},
    {"readNetFromDarknet", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromDarknet, 0), "readNetFromDarknet(cfgFile[, darknetModel]) -> retval\n.   @brief Reads a network model stored in <a href=\"https://pjreddie.com/darknet/\">Darknet</a> model files.\n.       *  @param cfgFile      path to the .cfg file with text description of the network architecture.\n.       *  @param darknetModel path to the .weights file with learned network.\n.       *  @returns Network object that ready to do forward, throw an exception in failure cases.\n\n\n\nreadNetFromDarknet(bufferCfg[, bufferModel]) -> retval\n.   @brief Reads a network model stored in <a href=\"https://pjreddie.com/darknet/\">Darknet</a> model files.\n.        *  @param bufferCfg   A buffer contains a content of .cfg file with text description of the network architecture.\n.        *  @param bufferModel A buffer contains a content of .weights file with learned network.\n.        *  @returns Net object."},
    {"readNetFromModelOptimizer", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromModelOptimizer, 0), "readNetFromModelOptimizer(xml[, bin]) -> retval\n.   @brief Load a network from Intel's Model Optimizer intermediate representation.\n.        *  @param[in] xml XML configuration file with network's topology.\n.        *  @param[in] bin Binary file with trained weights.\n.        *  @returns Net object.\n.        *  Networks imported from Intel's Model Optimizer are launched in Intel's Inference Engine\n.        *  backend.\n\n\n\nreadNetFromModelOptimizer(bufferModelConfig, bufferWeights) -> retval\n.   @brief Load a network from Intel's Model Optimizer intermediate representation.\n.        *  @param[in] bufferModelConfig Buffer contains XML configuration with network's topology.\n.        *  @param[in] bufferWeights Buffer contains binary data with trained weights.\n.        *  @returns Net object.\n.        *  Networks imported from Intel's Model Optimizer are launched in Intel's Inference Engine\n.        *  backend."},
    {"readNetFromONNX", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromONNX, 0), "readNetFromONNX(onnxFile) -> retval\n.   @brief Reads a network model <a href=\"https://onnx.ai/\">ONNX</a>.\n.        *  @param onnxFile path to the .onnx file with text description of the network architecture.\n.        *  @returns Network object that ready to do forward, throw an exception in failure cases.\n\n\n\nreadNetFromONNX(buffer) -> retval\n.   @brief Reads a network model from <a href=\"https://onnx.ai/\">ONNX</a>\n.        *         in-memory buffer.\n.        *  @param buffer in-memory buffer that stores the ONNX model bytes.\n.        *  @returns Network object that ready to do forward, throw an exception\n.        *        in failure cases."},
    {"readNetFromTFLite", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromTFLite, 0), "readNetFromTFLite(model) -> retval\n.   @brief Reads a network model stored in <a href=\"https://www.tensorflow.org/lite\">TFLite</a> framework's format.\n.         * @param model  path to the .tflite file with binary flatbuffers description of the network architecture\n.         * @returns Net object.\n\n\n\nreadNetFromTFLite(bufferModel) -> retval\n.   @brief Reads a network model stored in <a href=\"https://www.tensorflow.org/lite\">TFLite</a> framework's format.\n.         * @param bufferModel buffer containing the content of the tflite file\n.         * @returns Net object."},
    {"readNetFromTensorflow", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromTensorflow, 0), "readNetFromTensorflow(model[, config]) -> retval\n.   @brief Reads a network model stored in <a href=\"https://www.tensorflow.org/\">TensorFlow</a> framework's format.\n.         * @param model  path to the .pb file with binary protobuf description of the network architecture\n.         * @param config path to the .pbtxt file that contains text graph definition in protobuf format.\n.         *               Resulting Net object is built by text graph using weights from a binary one that\n.         *               let us make it more flexible.\n.         * @returns Net object.\n\n\n\nreadNetFromTensorflow(bufferModel[, bufferConfig]) -> retval\n.   @brief Reads a network model stored in <a href=\"https://www.tensorflow.org/\">TensorFlow</a> framework's format.\n.         * @param bufferModel buffer containing the content of the pb file\n.         * @param bufferConfig buffer containing the content of the pbtxt file\n.         * @returns Net object."},
    {"readNetFromTorch", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readNetFromTorch, 0), "readNetFromTorch(model[, isBinary[, evaluate]]) -> retval\n.   *  @brief Reads a network model stored in <a href=\"http://torch.ch\">Torch7</a> framework's format.\n.        *  @param model    path to the file, dumped from Torch by using torch.save() function.\n.        *  @param isBinary specifies whether the network was serialized in ascii mode or binary.\n.        *  @param evaluate specifies testing phase of network. If true, it's similar to evaluate() method in Torch.\n.        *  @returns Net object.\n.        *\n.        *  @note Ascii mode of Torch serializer is more preferable, because binary mode extensively use `long` type of C language,\n.        *  which has various bit-length on different systems.\n.        *\n.        * The loading file must contain serialized <a href=\"https://github.com/torch/nn/blob/master/doc/module.md\">nn.Module</a> object\n.        * with importing network. Try to eliminate a custom objects from serialazing data to avoid importing errors.\n.        *\n.        * List of supported layers (i.e. object instances derived from Torch nn.Module class):\n.        * - nn.Sequential\n.        * - nn.Parallel\n.        * - nn.Concat\n.        * - nn.Linear\n.        * - nn.SpatialConvolution\n.        * - nn.SpatialMaxPooling, nn.SpatialAveragePooling\n.        * - nn.ReLU, nn.TanH, nn.Sigmoid\n.        * - nn.Reshape\n.        * - nn.SoftMax, nn.LogSoftMax\n.        *\n.        * Also some equivalents of these classes from cunn, cudnn, and fbcunn may be successfully imported."},
    {"readTensorFromONNX", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readTensorFromONNX, 0), "readTensorFromONNX(path) -> retval\n.   @brief Creates blob from .pb file.\n.        *  @param path to the .pb file with input tensor.\n.        *  @returns Mat."},
    {"readTorchBlob", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_readTorchBlob, 0), "readTorchBlob(filename[, isBinary]) -> retval\n.   @brief Loads blob which was serialized as torch.Tensor object of Torch7 framework.\n.        *  @warning This function has the same limitations as readNetFromTorch()."},
    {"shrinkCaffeModel", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_shrinkCaffeModel, 0), "shrinkCaffeModel(src, dst[, layersTypes]) -> None\n.   @brief Convert all weights of Caffe network to half precision floating point.\n.        * @param src Path to origin model from Caffe framework contains single\n.        *            precision floating point weights (usually has `.caffemodel` extension).\n.        * @param dst Path to destination model with updated weights.\n.        * @param layersTypes Set of layers types which parameters will be converted.\n.        *                    By default, converts only Convolutional and Fully-Connected layers'\n.        *                    weights.\n.        *\n.        * @note Shrinked model has no origin float32 weights so it can't be used\n.        *       in origin Caffe framework anymore. However the structure of data\n.        *       is taken from NVidia's Caffe fork: https://github.com/NVIDIA/caffe.\n.        *       So the resulting model may be used there."},
    {"softNMSBoxes", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_softNMSBoxes, 0), "softNMSBoxes(bboxes, scores, score_threshold, nms_threshold[, top_k[, sigma[, method]]]) -> updated_scores, indices\n.   @brief Performs soft non maximum suppression given boxes and corresponding scores.\n.        * Reference: https://arxiv.org/abs/1704.04503\n.        * @param bboxes a set of bounding boxes to apply Soft NMS.\n.        * @param scores a set of corresponding confidences.\n.        * @param updated_scores a set of corresponding updated confidences.\n.        * @param score_threshold a threshold used to filter boxes by score.\n.        * @param nms_threshold a threshold used in non maximum suppression.\n.        * @param indices the kept indices of bboxes after NMS.\n.        * @param top_k keep at most @p top_k picked indices.\n.        * @param sigma parameter of Gaussian weighting.\n.        * @param method Gaussian or linear.\n.        * @see SoftNMSMethod"},
    {"writeTextGraph", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_writeTextGraph, 0), "writeTextGraph(model, output) -> None\n.   @brief Create a text representation for a binary network stored in protocol buffer format.\n.        *  @param[in] model  A path to binary network.\n.        *  @param[in] output A path to output text file to be created.\n.        *\n.        *  @note To reduce output file size, trained weights are not included."},
#ifdef PYOPENCV_EXTRA_METHODS_DNN
    PYOPENCV_EXTRA_METHODS_DNN
#endif
    {NULL, NULL}
};

static ConstDef consts_dnn[] = {
    {"DNN_BACKEND_CANN", static_cast<long>(cv::dnn::DNN_BACKEND_CANN)},
    {"DNN_BACKEND_CUDA", static_cast<long>(cv::dnn::DNN_BACKEND_CUDA)},
    {"DNN_BACKEND_DEFAULT", static_cast<long>(cv::dnn::DNN_BACKEND_DEFAULT)},
    {"DNN_BACKEND_HALIDE", static_cast<long>(cv::dnn::DNN_BACKEND_HALIDE)},
    {"DNN_BACKEND_INFERENCE_ENGINE", static_cast<long>(cv::dnn::DNN_BACKEND_INFERENCE_ENGINE)},
    {"DNN_BACKEND_OPENCV", static_cast<long>(cv::dnn::DNN_BACKEND_OPENCV)},
    {"DNN_BACKEND_TIMVX", static_cast<long>(cv::dnn::DNN_BACKEND_TIMVX)},
    {"DNN_BACKEND_VKCOM", static_cast<long>(cv::dnn::DNN_BACKEND_VKCOM)},
    {"DNN_BACKEND_WEBNN", static_cast<long>(cv::dnn::DNN_BACKEND_WEBNN)},
    {"DNN_LAYOUT_NCDHW", static_cast<long>(cv::dnn::DNN_LAYOUT_NCDHW)},
    {"DNN_LAYOUT_NCHW", static_cast<long>(cv::dnn::DNN_LAYOUT_NCHW)},
    {"DNN_LAYOUT_ND", static_cast<long>(cv::dnn::DNN_LAYOUT_ND)},
    {"DNN_LAYOUT_NDHWC", static_cast<long>(cv::dnn::DNN_LAYOUT_NDHWC)},
    {"DNN_LAYOUT_NHWC", static_cast<long>(cv::dnn::DNN_LAYOUT_NHWC)},
    {"DNN_LAYOUT_PLANAR", static_cast<long>(cv::dnn::DNN_LAYOUT_PLANAR)},
    {"DNN_LAYOUT_UNKNOWN", static_cast<long>(cv::dnn::DNN_LAYOUT_UNKNOWN)},
    {"DNN_PMODE_CROP_CENTER", static_cast<long>(cv::dnn::DNN_PMODE_CROP_CENTER)},
    {"DNN_PMODE_LETTERBOX", static_cast<long>(cv::dnn::DNN_PMODE_LETTERBOX)},
    {"DNN_PMODE_NULL", static_cast<long>(cv::dnn::DNN_PMODE_NULL)},
    {"DNN_TARGET_CPU", static_cast<long>(cv::dnn::DNN_TARGET_CPU)},
    {"DNN_TARGET_CPU_FP16", static_cast<long>(cv::dnn::DNN_TARGET_CPU_FP16)},
    {"DNN_TARGET_CUDA", static_cast<long>(cv::dnn::DNN_TARGET_CUDA)},
    {"DNN_TARGET_CUDA_FP16", static_cast<long>(cv::dnn::DNN_TARGET_CUDA_FP16)},
    {"DNN_TARGET_FPGA", static_cast<long>(cv::dnn::DNN_TARGET_FPGA)},
    {"DNN_TARGET_HDDL", static_cast<long>(cv::dnn::DNN_TARGET_HDDL)},
    {"DNN_TARGET_MYRIAD", static_cast<long>(cv::dnn::DNN_TARGET_MYRIAD)},
    {"DNN_TARGET_NPU", static_cast<long>(cv::dnn::DNN_TARGET_NPU)},
    {"DNN_TARGET_OPENCL", static_cast<long>(cv::dnn::DNN_TARGET_OPENCL)},
    {"DNN_TARGET_OPENCL_FP16", static_cast<long>(cv::dnn::DNN_TARGET_OPENCL_FP16)},
    {"DNN_TARGET_VULKAN", static_cast<long>(cv::dnn::DNN_TARGET_VULKAN)},
    {"SoftNMSMethod_SOFTNMS_GAUSSIAN", static_cast<long>(cv::dnn::SoftNMSMethod::SOFTNMS_GAUSSIAN)},
    {"SOFT_NMSMETHOD_SOFTNMS_GAUSSIAN", static_cast<long>(cv::dnn::SoftNMSMethod::SOFTNMS_GAUSSIAN)},
    {"SoftNMSMethod_SOFTNMS_LINEAR", static_cast<long>(cv::dnn::SoftNMSMethod::SOFTNMS_LINEAR)},
    {"SOFT_NMSMETHOD_SOFTNMS_LINEAR", static_cast<long>(cv::dnn::SoftNMSMethod::SOFTNMS_LINEAR)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_DNN
    PYOPENCV_EXTRA_CONSTANTS_DNN
#endif
    {NULL, 0}
};

static PyMethodDef methods_dnn_superres[] = {
    {"DnnSuperResImpl_create", CV_PY_FN_WITH_KW_(pyopencv_cv_dnn_superres_DnnSuperResImpl_create, 0), "DnnSuperResImpl_create() -> retval\n.   @brief Empty constructor for python"},
#ifdef PYOPENCV_EXTRA_METHODS_DNN_SUPERRES
    PYOPENCV_EXTRA_METHODS_DNN_SUPERRES
#endif
    {NULL, NULL}
};

static ConstDef consts_dnn_superres[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_DNN_SUPERRES
    PYOPENCV_EXTRA_CONSTANTS_DNN_SUPERRES
#endif
    {NULL, 0}
};

static PyMethodDef methods_dpm[] = {
#ifdef PYOPENCV_EXTRA_METHODS_DPM
    PYOPENCV_EXTRA_METHODS_DPM
#endif
    {NULL, NULL}
};

static ConstDef consts_dpm[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_DPM
    PYOPENCV_EXTRA_CONSTANTS_DPM
#endif
    {NULL, 0}
};

static PyMethodDef methods_dynafu[] = {
    {"DynaFu_create", CV_PY_FN_WITH_KW_(pyopencv_cv_dynafu_DynaFu_create, 0), "DynaFu_create(_params) -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_DYNAFU
    PYOPENCV_EXTRA_METHODS_DYNAFU
#endif
    {NULL, NULL}
};

static ConstDef consts_dynafu[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_DYNAFU
    PYOPENCV_EXTRA_CONSTANTS_DYNAFU
#endif
    {NULL, 0}
};

static PyMethodDef methods_face[] = {
    {"BIF_create", CV_PY_FN_WITH_KW_(pyopencv_cv_face_BIF_create, 0), "BIF_create([, num_bands[, num_rotations]]) -> retval\n.   * @param num_bands The number of filter bands (<=8) used for computing BIF.\n.        * @param num_rotations The number of image rotations for computing BIF.\n.        * @returns Object for computing BIF."},
    {"EigenFaceRecognizer_create", CV_PY_FN_WITH_KW_(pyopencv_cv_face_EigenFaceRecognizer_create, 0), "EigenFaceRecognizer_create([, num_components[, threshold]]) -> retval\n.   @param num_components The number of components (read: Eigenfaces) kept for this Principal\n.       Component Analysis. As a hint: There's no rule how many components (read: Eigenfaces) should be\n.       kept for good reconstruction capabilities. It is based on your input data, so experiment with the\n.       number. Keeping 80 components should almost always be sufficient.\n.       @param threshold The threshold applied in the prediction.\n.   \n.       ### Notes:\n.   \n.       -   Training and prediction must be done on grayscale images, use cvtColor to convert between the\n.           color spaces.\n.       -   **THE EIGENFACES METHOD MAKES THE ASSUMPTION, THAT THE TRAINING AND TEST IMAGES ARE OF EQUAL\n.           SIZE.** (caps-lock, because I got so many mails asking for this). You have to make sure your\n.           input data has the correct shape, else a meaningful exception is thrown. Use resize to resize\n.           the images.\n.       -   This model does not support updating.\n.   \n.       ### Model internal data:\n.   \n.       -   num_components see EigenFaceRecognizer::create.\n.       -   threshold see EigenFaceRecognizer::create.\n.       -   eigenvalues The eigenvalues for this Principal Component Analysis (ordered descending).\n.       -   eigenvectors The eigenvectors for this Principal Component Analysis (ordered by their\n.           eigenvalue).\n.       -   mean The sample mean calculated from the training data.\n.       -   projections The projections of the training data.\n.       -   labels The threshold applied in the prediction. If the distance to the nearest neighbor is\n.           larger than the threshold, this method returns -1."},
    {"FisherFaceRecognizer_create", CV_PY_FN_WITH_KW_(pyopencv_cv_face_FisherFaceRecognizer_create, 0), "FisherFaceRecognizer_create([, num_components[, threshold]]) -> retval\n.   @param num_components The number of components (read: Fisherfaces) kept for this Linear\n.       Discriminant Analysis with the Fisherfaces criterion. It's useful to keep all components, that\n.       means the number of your classes c (read: subjects, persons you want to recognize). If you leave\n.       this at the default (0) or set it to a value less-equal 0 or greater (c-1), it will be set to the\n.       correct number (c-1) automatically.\n.       @param threshold The threshold applied in the prediction. If the distance to the nearest neighbor\n.       is larger than the threshold, this method returns -1.\n.   \n.       ### Notes:\n.   \n.       -   Training and prediction must be done on grayscale images, use cvtColor to convert between the\n.           color spaces.\n.       -   **THE FISHERFACES METHOD MAKES THE ASSUMPTION, THAT THE TRAINING AND TEST IMAGES ARE OF EQUAL\n.           SIZE.** (caps-lock, because I got so many mails asking for this). You have to make sure your\n.           input data has the correct shape, else a meaningful exception is thrown. Use resize to resize\n.           the images.\n.       -   This model does not support updating.\n.   \n.       ### Model internal data:\n.   \n.       -   num_components see FisherFaceRecognizer::create.\n.       -   threshold see FisherFaceRecognizer::create.\n.       -   eigenvalues The eigenvalues for this Linear Discriminant Analysis (ordered descending).\n.       -   eigenvectors The eigenvectors for this Linear Discriminant Analysis (ordered by their\n.           eigenvalue).\n.       -   mean The sample mean calculated from the training data.\n.       -   projections The projections of the training data.\n.       -   labels The labels corresponding to the projections."},
    {"LBPHFaceRecognizer_create", CV_PY_FN_WITH_KW_(pyopencv_cv_face_LBPHFaceRecognizer_create, 0), "LBPHFaceRecognizer_create([, radius[, neighbors[, grid_x[, grid_y[, threshold]]]]]) -> retval\n.   @param radius The radius used for building the Circular Local Binary Pattern. The greater the\n.       radius, the smoother the image but more spatial information you can get.\n.       @param neighbors The number of sample points to build a Circular Local Binary Pattern from. An\n.       appropriate value is to use `8` sample points. Keep in mind: the more sample points you include,\n.       the higher the computational cost.\n.       @param grid_x The number of cells in the horizontal direction, 8 is a common value used in\n.       publications. The more cells, the finer the grid, the higher the dimensionality of the resulting\n.       feature vector.\n.       @param grid_y The number of cells in the vertical direction, 8 is a common value used in\n.       publications. The more cells, the finer the grid, the higher the dimensionality of the resulting\n.       feature vector.\n.       @param threshold The threshold applied in the prediction. If the distance to the nearest neighbor\n.       is larger than the threshold, this method returns -1.\n.   \n.       ### Notes:\n.   \n.       -   The Circular Local Binary Patterns (used in training and prediction) expect the data given as\n.           grayscale images, use cvtColor to convert between the color spaces.\n.       -   This model supports updating.\n.   \n.       ### Model internal data:\n.   \n.       -   radius see LBPHFaceRecognizer::create.\n.       -   neighbors see LBPHFaceRecognizer::create.\n.       -   grid_x see LLBPHFaceRecognizer::create.\n.       -   grid_y see LBPHFaceRecognizer::create.\n.       -   threshold see LBPHFaceRecognizer::create.\n.       -   histograms Local Binary Patterns Histograms calculated from the given training data (empty if\n.           none was given).\n.       -   labels Labels corresponding to the calculated Local Binary Patterns Histograms."},
    {"MACE_create", CV_PY_FN_WITH_KW_(pyopencv_cv_face_MACE_create, 0), "MACE_create([, IMGSIZE]) -> retval\n.   @brief constructor\n.       @param IMGSIZE  images will get resized to this (should be an even number)"},
    {"MACE_load", CV_PY_FN_WITH_KW_(pyopencv_cv_face_MACE_load, 0), "MACE_load(filename[, objname]) -> retval\n.   @brief constructor\n.       @param filename  build a new MACE instance from a pre-serialized FileStorage\n.       @param objname (optional) top-level node in the FileStorage"},
    {"StandardCollector_create", CV_PY_FN_WITH_KW_(pyopencv_cv_face_StandardCollector_create, 0), "StandardCollector_create([, threshold]) -> retval\n.   @brief Static constructor\n.       @param threshold set threshold"},
    {"createFacemarkAAM", CV_PY_FN_WITH_KW_(pyopencv_cv_face_createFacemarkAAM, 0), "createFacemarkAAM() -> retval\n."},
    {"createFacemarkKazemi", CV_PY_FN_WITH_KW_(pyopencv_cv_face_createFacemarkKazemi, 0), "createFacemarkKazemi() -> retval\n."},
    {"createFacemarkLBF", CV_PY_FN_WITH_KW_(pyopencv_cv_face_createFacemarkLBF, 0), "createFacemarkLBF() -> retval\n."},
    {"drawFacemarks", CV_PY_FN_WITH_KW_(pyopencv_cv_face_drawFacemarks, 0), "drawFacemarks(image, points[, color]) -> image\n.   @brief Utility to draw the detected facial landmark points\n.   \n.   @param image The input image to be processed.\n.   @param points Contains the data of points which will be drawn.\n.   @param color The color of points in BGR format represented by cv::Scalar.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   std::vector<Rect> faces;\n.   std::vector<std::vector<Point2f> > landmarks;\n.   facemark->getFaces(img, faces);\n.   facemark->fit(img, faces, landmarks);\n.   for(int j=0;j<rects.size();j++){\n.       face::drawFacemarks(frame, landmarks[j], Scalar(0,0,255));\n.   }\n.   @endcode"},
    {"getFacesHAAR", CV_PY_FN_WITH_KW_(pyopencv_cv_face_getFacesHAAR, 0), "getFacesHAAR(image, face_cascade_name[, faces]) -> retval, faces\n.   @brief Default face detector\n.   This function is mainly utilized by the implementation of a Facemark Algorithm.\n.   End users are advised to use function Facemark::getFaces which can be manually defined\n.   and circumvented to the algorithm by Facemark::setFaceDetector.\n.   \n.   @param image The input image to be processed.\n.   @param faces Output of the function which represent region of interest of the detected faces.\n.   Each face is stored in cv::Rect container.\n.   @param params detector parameters\n.   \n.   <B>Example of usage</B>\n.   @code\n.   std::vector<cv::Rect> faces;\n.   CParams params(\"haarcascade_frontalface_alt.xml\");\n.   cv::face::getFaces(frame, faces, &params);\n.   for(int j=0;j<faces.size();j++){\n.       cv::rectangle(frame, faces[j], cv::Scalar(255,0,255));\n.   }\n.   cv::imshow(\"detection\", frame);\n.   @endcode"},
    {"loadDatasetList", CV_PY_FN_WITH_KW_(pyopencv_cv_face_loadDatasetList, 0), "loadDatasetList(imageList, annotationList, images, annotations) -> retval\n.   @brief A utility to load list of paths to training image and annotation file.\n.   @param imageList The specified file contains paths to the training images.\n.   @param annotationList The specified file contains paths to the training annotations.\n.   @param images The loaded paths of training images.\n.   @param annotations The loaded paths of annotation files.\n.   \n.   Example of usage:\n.   @code\n.   String imageFiles = \"images_path.txt\";\n.   String ptsFiles = \"annotations_path.txt\";\n.   std::vector<String> images_train;\n.   std::vector<String> landmarks_train;\n.   loadDatasetList(imageFiles,ptsFiles,images_train,landmarks_train);\n.   @endcode"},
    {"loadFacePoints", CV_PY_FN_WITH_KW_(pyopencv_cv_face_loadFacePoints, 0), "loadFacePoints(filename[, points[, offset]]) -> retval, points\n.   @brief A utility to load facial landmark information from a given file.\n.   \n.   @param filename The filename of file contains the facial landmarks data.\n.   @param points The loaded facial landmark points.\n.   @param offset An offset value to adjust the loaded points.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   std::vector<Point2f> points;\n.   face::loadFacePoints(\"filename.txt\", points, 0.0f);\n.   @endcode\n.   \n.   The annotation file should follow the default format which is\n.   @code\n.   version: 1\n.   n_points:  68\n.   {\n.   212.716603 499.771793\n.   230.232816 566.290071\n.   ...\n.   }\n.   @endcode\n.   where n_points is the number of points considered\n.   and each point is represented as its position in x and y."},
    {"loadTrainingData", CV_PY_FN_WITH_KW_(pyopencv_cv_face_loadTrainingData, 0), "loadTrainingData(filename, images[, facePoints[, delim[, offset]]]) -> retval, facePoints\n.   @brief A utility to load facial landmark dataset from a single file.\n.   \n.   @param filename The filename of a file that contains the dataset information.\n.   Each line contains the filename of an image followed by\n.   pairs of x and y values of facial landmarks points separated by a space.\n.   Example\n.   @code\n.   /home/user/ibug/image_003_1.jpg 336.820955 240.864510 334.238298 260.922709 335.266918 ...\n.   /home/user/ibug/image_005_1.jpg 376.158428 230.845712 376.736984 254.924635 383.265403 ...\n.   @endcode\n.   @param images A vector where each element represent the filename of image in the dataset.\n.   Images are not loaded by default to save the memory.\n.   @param facePoints The loaded landmark points for all training data.\n.   @param delim Delimiter between each element, the default value is a whitespace.\n.   @param offset An offset value to adjust the loaded points.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   cv::String imageFiles = \"../data/images_train.txt\";\n.   cv::String ptsFiles = \"../data/points_train.txt\";\n.   std::vector<String> images;\n.   std::vector<std::vector<Point2f> > facePoints;\n.   loadTrainingData(imageFiles, ptsFiles, images, facePoints, 0.0f);\n.   @endcode\n\n\n\nloadTrainingData(imageList, groundTruth, images[, facePoints[, offset]]) -> retval, facePoints\n.   @brief A utility to load facial landmark information from the dataset.\n.   \n.   @param imageList A file contains the list of image filenames in the training dataset.\n.   @param groundTruth A file contains the list of filenames\n.   where the landmarks points information are stored.\n.   The content in each file should follow the standard format (see face::loadFacePoints).\n.   @param images A vector where each element represent the filename of image in the dataset.\n.   Images are not loaded by default to save the memory.\n.   @param facePoints The loaded landmark points for all training data.\n.   @param offset An offset value to adjust the loaded points.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   cv::String imageFiles = \"../data/images_train.txt\";\n.   cv::String ptsFiles = \"../data/points_train.txt\";\n.   std::vector<String> images;\n.   std::vector<std::vector<Point2f> > facePoints;\n.   loadTrainingData(imageFiles, ptsFiles, images, facePoints, 0.0f);\n.   @endcode\n.   \n.   example of content in the images_train.txt\n.   @code\n.   /home/user/ibug/image_003_1.jpg\n.   /home/user/ibug/image_004_1.jpg\n.   /home/user/ibug/image_005_1.jpg\n.   /home/user/ibug/image_006.jpg\n.   @endcode\n.   \n.   example of content in the points_train.txt\n.   @code\n.   /home/user/ibug/image_003_1.pts\n.   /home/user/ibug/image_004_1.pts\n.   /home/user/ibug/image_005_1.pts\n.   /home/user/ibug/image_006.pts\n.   @endcode\n\n\n\nloadTrainingData(filename, trainlandmarks, trainimages) -> retval\n.   @brief This function extracts the data for training from .txt files which contains the corresponding image name and landmarks.\n.   *The first file in each file should give the path of the image whose\n.   *landmarks are being described in the file. Then in the subsequent\n.   *lines there should be coordinates of the landmarks in the image\n.   *i.e each line should be of the form x,y\n.   *where x represents the x coordinate of the landmark and y represents\n.   *the y coordinate of the landmark.\n.   *\n.   *For reference you can see the files as provided in the\n.   *<a href=\"http://www.ifp.illinois.edu/~vuongle2/helen/\">HELEN dataset</a>\n.   *\n.   * @param filename A vector of type cv::String containing name of the .txt files.\n.   * @param trainlandmarks A vector of type cv::Point2f that would store shape or landmarks of all images.\n.   * @param trainimages A vector of type cv::String which stores the name of images whose landmarks are tracked\n.   * @returns A boolean value. It returns true when it reads the data successfully and false otherwise"},
#ifdef PYOPENCV_EXTRA_METHODS_FACE
    PYOPENCV_EXTRA_METHODS_FACE
#endif
    {NULL, NULL}
};

static ConstDef consts_face[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_FACE
    PYOPENCV_EXTRA_CONSTANTS_FACE
#endif
    {NULL, 0}
};

static PyMethodDef methods_fisheye[] = {
    {"calibrate", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_calibrate, 0), "calibrate(objectPoints, imagePoints, image_size, K, D[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, K, D, rvecs, tvecs\n.   @brief Performs camera calibration\n.   \n.       @param objectPoints vector of vectors of calibration pattern points in the calibration pattern\n.       coordinate space.\n.       @param imagePoints vector of vectors of the projections of calibration pattern points.\n.       imagePoints.size() and objectPoints.size() and imagePoints[i].size() must be equal to\n.       objectPoints[i].size() for each i.\n.       @param image_size Size of the image used only to initialize the camera intrinsic matrix.\n.       @param K Output 3x3 floating-point camera intrinsic matrix\n.       \\f$\\cameramatrix{A}\\f$ . If\n.       @ref fisheye::CALIB_USE_INTRINSIC_GUESS is specified, some or all of fx, fy, cx, cy must be\n.       initialized before calling the function.\n.       @param D Output vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param rvecs Output vector of rotation vectors (see @ref Rodrigues ) estimated for each pattern view.\n.       That is, each k-th rotation vector together with the corresponding k-th translation vector (see\n.       the next output parameter description) brings the calibration pattern from the model coordinate\n.       space (in which object points are specified) to the world coordinate space, that is, a real\n.       position of the calibration pattern in the k-th pattern view (k=0.. *M* -1).\n.       @param tvecs Output vector of translation vectors estimated for each pattern view.\n.       @param flags Different flags that may be zero or a combination of the following values:\n.       -    @ref fisheye::CALIB_USE_INTRINSIC_GUESS  cameraMatrix contains valid initial values of\n.       fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image\n.       center ( imageSize is used), and focal distances are computed in a least-squares fashion.\n.       -    @ref fisheye::CALIB_RECOMPUTE_EXTRINSIC  Extrinsic will be recomputed after each iteration\n.       of intrinsic optimization.\n.       -    @ref fisheye::CALIB_CHECK_COND  The functions will check validity of condition number.\n.       -    @ref fisheye::CALIB_FIX_SKEW  Skew coefficient (alpha) is set to zero and stay zero.\n.       -    @ref fisheye::CALIB_FIX_K1,..., @ref fisheye::CALIB_FIX_K4 Selected distortion coefficients\n.       are set to zeros and stay zero.\n.       -    @ref fisheye::CALIB_FIX_PRINCIPAL_POINT  The principal point is not changed during the global\n.   optimization. It stays at the center or at a different location specified when @ref fisheye::CALIB_USE_INTRINSIC_GUESS is set too.\n.       -    @ref fisheye::CALIB_FIX_FOCAL_LENGTH The focal length is not changed during the global\n.   optimization. It is the \\f$max(width,height)/\\pi\\f$ or the provided \\f$f_x\\f$, \\f$f_y\\f$ when @ref fisheye::CALIB_USE_INTRINSIC_GUESS is set too.\n.       @param criteria Termination criteria for the iterative optimization algorithm."},
    {"distortPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_distortPoints, 0), "distortPoints(undistorted, K, D[, distorted[, alpha]]) -> distorted\n.   @brief Distorts 2D points using fisheye model.\n.   \n.       @param undistorted Array of object points, 1xN/Nx1 2-channel (or vector\\<Point2f\\> ), where N is\n.       the number of points in the view.\n.       @param K Camera intrinsic matrix \\f$\\cameramatrix{K}\\f$.\n.       @param D Input vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param alpha The skew coefficient.\n.       @param distorted Output array of image points, 1xN/Nx1 2-channel, or vector\\<Point2f\\> .\n.   \n.       Note that the function assumes the camera intrinsic matrix of the undistorted points to be identity.\n.       This means if you want to distort image points you have to multiply them with \\f$K^{-1}\\f$ or\n.       use another function overload.\n\n\n\ndistortPoints(undistorted, Kundistorted, K, D[, distorted[, alpha]]) -> distorted\n.   @overload\n.       Overload of distortPoints function to handle cases when undistorted points are obtained with non-identity\n.       camera matrix, e.g. output of #estimateNewCameraMatrixForUndistortRectify.\n.       @param undistorted Array of object points, 1xN/Nx1 2-channel (or vector\\<Point2f\\> ), where N is\n.       the number of points in the view.\n.       @param Kundistorted Camera intrinsic matrix used as new camera matrix for undistortion.\n.       @param K Camera intrinsic matrix \\f$\\cameramatrix{K}\\f$.\n.       @param D Input vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param alpha The skew coefficient.\n.       @param distorted Output array of image points, 1xN/Nx1 2-channel, or vector\\<Point2f\\> .\n.       @sa estimateNewCameraMatrixForUndistortRectify"},
    {"estimateNewCameraMatrixForUndistortRectify", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_estimateNewCameraMatrixForUndistortRectify, 0), "estimateNewCameraMatrixForUndistortRectify(K, D, image_size, R[, P[, balance[, new_size[, fov_scale]]]]) -> P\n.   @brief Estimates new camera intrinsic matrix for undistortion or rectification.\n.   \n.       @param K Camera intrinsic matrix \\f$\\cameramatrix{K}\\f$.\n.       @param image_size Size of the image\n.       @param D Input vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3\n.       1-channel or 1x1 3-channel\n.       @param P New camera intrinsic matrix (3x3) or new projection matrix (3x4)\n.       @param balance Sets the new focal length in range between the min focal length and the max focal\n.       length. Balance is in range of [0, 1].\n.       @param new_size the new size\n.       @param fov_scale Divisor for new focal length."},
    {"initUndistortRectifyMap", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_initUndistortRectifyMap, 0), "initUndistortRectifyMap(K, D, R, P, size, m1type[, map1[, map2]]) -> map1, map2\n.   @brief Computes undistortion and rectification maps for image transform by #remap. If D is empty zero\n.       distortion is used, if R or P is empty identity matrixes are used.\n.   \n.       @param K Camera intrinsic matrix \\f$\\cameramatrix{K}\\f$.\n.       @param D Input vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3\n.       1-channel or 1x1 3-channel\n.       @param P New camera intrinsic matrix (3x3) or new projection matrix (3x4)\n.       @param size Undistorted image size.\n.       @param m1type Type of the first output map that can be CV_32FC1 or CV_16SC2 . See #convertMaps\n.       for details.\n.       @param map1 The first output map.\n.       @param map2 The second output map."},
    {"projectPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_projectPoints, 0), "projectPoints(objectPoints, rvec, tvec, K, D[, imagePoints[, alpha[, jacobian]]]) -> imagePoints, jacobian\n.   @overload"},
    {"solvePnP", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_solvePnP, 0), "solvePnP(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess[, flags[, criteria]]]]]) -> retval, rvec, tvec\n.   @brief Finds an object pose from 3D-2D point correspondences for fisheye camera moodel.\n.   \n.       @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.       1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3d\\> can also be passed here.\n.       @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.       where N is the number of points. vector\\<Point2d\\> can also be passed here.\n.       @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.       @param distCoeffs Input vector of distortion coefficients (4x1/1x4).\n.       @param rvec Output rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.       the model coordinate system to the camera coordinate system.\n.       @param tvec Output translation vector.\n.       @param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses\n.       the provided rvec and tvec values as initial approximations of the rotation and translation\n.       vectors, respectively, and further optimizes them.\n.       @param flags Method for solving a PnP problem: see @ref calib3d_solvePnP_flags\n.       @param criteria Termination criteria for internal undistortPoints call.\n.       The function interally undistorts points with @ref undistortPoints and call @ref cv::solvePnP,\n.       thus the input are very similar. More information about Perspective-n-Points is described in @ref calib3d_solvePnP\n.       for more information."},
    {"solvePnPRansac", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_solvePnPRansac, 0), "solvePnPRansac(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess[, iterationsCount[, reprojectionError[, confidence[, inliers[, flags[, criteria]]]]]]]]]) -> retval, rvec, tvec, inliers\n.   @brief Finds an object pose from 3D-2D point correspondences using the RANSAC scheme for fisheye camera moodel.\n.   \n.       @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.       1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3d\\> can be also passed here.\n.       @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.       where N is the number of points. vector\\<Point2d\\> can be also passed here.\n.       @param cameraMatrix Input camera intrinsic matrix \\f$\\cameramatrix{A}\\f$ .\n.       @param distCoeffs Input vector of distortion coefficients (4x1/1x4).\n.       @param rvec Output rotation vector (see @ref Rodrigues ) that, together with tvec, brings points from\n.       the model coordinate system to the camera coordinate system.\n.       @param tvec Output translation vector.\n.       @param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses\n.       the provided rvec and tvec values as initial approximations of the rotation and translation\n.       vectors, respectively, and further optimizes them.\n.       @param iterationsCount Number of iterations.\n.       @param reprojectionError Inlier threshold value used by the RANSAC procedure. The parameter value\n.       is the maximum allowed distance between the observed and computed point projections to consider it\n.       an inlier.\n.       @param confidence The probability that the algorithm produces a useful result.\n.       @param inliers Output vector that contains indices of inliers in objectPoints and imagePoints .\n.       @param flags Method for solving a PnP problem: see @ref calib3d_solvePnP_flags\n.       This function returns the rotation and the translation vectors that transform a 3D point expressed in the object\n.       coordinate frame to the camera coordinate frame, using different methods:\n.       - P3P methods (@ref SOLVEPNP_P3P, @ref SOLVEPNP_AP3P): need 4 input points to return a unique solution.\n.       - @ref SOLVEPNP_IPPE Input points must be >= 4 and object points must be coplanar.\n.       - @ref SOLVEPNP_IPPE_SQUARE Special case suitable for marker pose estimation.\n.       Number of input points must be 4. Object points must be defined in the following order:\n.       - point 0: [-squareLength / 2,  squareLength / 2, 0]\n.       - point 1: [ squareLength / 2,  squareLength / 2, 0]\n.       - point 2: [ squareLength / 2, -squareLength / 2, 0]\n.       - point 3: [-squareLength / 2, -squareLength / 2, 0]\n.       - for all the other flags, number of input points must be >= 4 and object points can be in any configuration.\n.       @param criteria Termination criteria for internal undistortPoints call.\n.       The function interally undistorts points with @ref undistortPoints and call @ref cv::solvePnP,\n.       thus the input are very similar. More information about Perspective-n-Points is described in @ref calib3d_solvePnP\n.       for more information."},
    {"stereoCalibrate", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_stereoCalibrate, 0), "stereoCalibrate(objectPoints, imagePoints1, imagePoints2, K1, D1, K2, D2, imageSize[, R[, T[, rvecs[, tvecs[, flags[, criteria]]]]]]) -> retval, K1, D1, K2, D2, R, T, rvecs, tvecs\n.   @brief Performs stereo calibration\n.   \n.       @param objectPoints Vector of vectors of the calibration pattern points.\n.       @param imagePoints1 Vector of vectors of the projections of the calibration pattern points,\n.       observed by the first camera.\n.       @param imagePoints2 Vector of vectors of the projections of the calibration pattern points,\n.       observed by the second camera.\n.       @param K1 Input/output first camera intrinsic matrix:\n.       \\f$\\vecthreethree{f_x^{(j)}}{0}{c_x^{(j)}}{0}{f_y^{(j)}}{c_y^{(j)}}{0}{0}{1}\\f$ , \\f$j = 0,\\, 1\\f$ . If\n.       any of @ref fisheye::CALIB_USE_INTRINSIC_GUESS , @ref fisheye::CALIB_FIX_INTRINSIC are specified,\n.       some or all of the matrix components must be initialized.\n.       @param D1 Input/output vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$ of 4 elements.\n.       @param K2 Input/output second camera intrinsic matrix. The parameter is similar to K1 .\n.       @param D2 Input/output lens distortion coefficients for the second camera. The parameter is\n.       similar to D1 .\n.       @param imageSize Size of the image used only to initialize camera intrinsic matrix.\n.       @param R Output rotation matrix between the 1st and the 2nd camera coordinate systems.\n.       @param T Output translation vector between the coordinate systems of the cameras.\n.       @param rvecs Output vector of rotation vectors ( @ref Rodrigues ) estimated for each pattern view in the\n.       coordinate system of the first camera of the stereo pair (e.g. std::vector<cv::Mat>). More in detail, each\n.       i-th rotation vector together with the corresponding i-th translation vector (see the next output parameter\n.       description) brings the calibration pattern from the object coordinate space (in which object points are\n.       specified) to the camera coordinate space of the first camera of the stereo pair. In more technical terms,\n.       the tuple of the i-th rotation and translation vector performs a change of basis from object coordinate space\n.       to camera coordinate space of the first camera of the stereo pair.\n.       @param tvecs Output vector of translation vectors estimated for each pattern view, see parameter description\n.       of previous output parameter ( rvecs ).\n.       @param flags Different flags that may be zero or a combination of the following values:\n.       -    @ref fisheye::CALIB_FIX_INTRINSIC  Fix K1, K2? and D1, D2? so that only R, T matrices\n.       are estimated.\n.       -    @ref fisheye::CALIB_USE_INTRINSIC_GUESS  K1, K2 contains valid initial values of\n.       fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image\n.       center (imageSize is used), and focal distances are computed in a least-squares fashion.\n.       -    @ref fisheye::CALIB_RECOMPUTE_EXTRINSIC  Extrinsic will be recomputed after each iteration\n.       of intrinsic optimization.\n.       -    @ref fisheye::CALIB_CHECK_COND  The functions will check validity of condition number.\n.       -    @ref fisheye::CALIB_FIX_SKEW  Skew coefficient (alpha) is set to zero and stay zero.\n.       -   @ref fisheye::CALIB_FIX_K1,..., @ref fisheye::CALIB_FIX_K4 Selected distortion coefficients are set to zeros and stay\n.       zero.\n.       @param criteria Termination criteria for the iterative optimization algorithm.\n\n\n\nstereoCalibrate(objectPoints, imagePoints1, imagePoints2, K1, D1, K2, D2, imageSize[, R[, T[, flags[, criteria]]]]) -> retval, K1, D1, K2, D2, R, T\n."},
    {"stereoRectify", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_stereoRectify, 0), "stereoRectify(K1, D1, K2, D2, imageSize, R, tvec, flags[, R1[, R2[, P1[, P2[, Q[, newImageSize[, balance[, fov_scale]]]]]]]]) -> R1, R2, P1, P2, Q\n.   @brief Stereo rectification for fisheye camera model\n.   \n.       @param K1 First camera intrinsic matrix.\n.       @param D1 First camera distortion parameters.\n.       @param K2 Second camera intrinsic matrix.\n.       @param D2 Second camera distortion parameters.\n.       @param imageSize Size of the image used for stereo calibration.\n.       @param R Rotation matrix between the coordinate systems of the first and the second\n.       cameras.\n.       @param tvec Translation vector between coordinate systems of the cameras.\n.       @param R1 Output 3x3 rectification transform (rotation matrix) for the first camera.\n.       @param R2 Output 3x3 rectification transform (rotation matrix) for the second camera.\n.       @param P1 Output 3x4 projection matrix in the new (rectified) coordinate systems for the first\n.       camera.\n.       @param P2 Output 3x4 projection matrix in the new (rectified) coordinate systems for the second\n.       camera.\n.       @param Q Output \\f$4 \\times 4\\f$ disparity-to-depth mapping matrix (see #reprojectImageTo3D ).\n.       @param flags Operation flags that may be zero or @ref fisheye::CALIB_ZERO_DISPARITY . If the flag is set,\n.       the function makes the principal points of each camera have the same pixel coordinates in the\n.       rectified views. And if the flag is not set, the function may still shift the images in the\n.       horizontal or vertical direction (depending on the orientation of epipolar lines) to maximize the\n.       useful image area.\n.       @param newImageSize New image resolution after rectification. The same size should be passed to\n.       #initUndistortRectifyMap (see the stereo_calib.cpp sample in OpenCV samples directory). When (0,0)\n.       is passed (default), it is set to the original imageSize . Setting it to larger value can help you\n.       preserve details in the original image, especially when there is a big radial distortion.\n.       @param balance Sets the new focal length in range between the min focal length and the max focal\n.       length. Balance is in range of [0, 1].\n.       @param fov_scale Divisor for new focal length."},
    {"undistortImage", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_undistortImage, 0), "undistortImage(distorted, K, D[, undistorted[, Knew[, new_size]]]) -> undistorted\n.   @brief Transforms an image to compensate for fisheye lens distortion.\n.   \n.       @param distorted image with fisheye lens distortion.\n.       @param undistorted Output image with compensated fisheye lens distortion.\n.       @param K Camera intrinsic matrix \\f$\\cameramatrix{K}\\f$.\n.       @param D Input vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param Knew Camera intrinsic matrix of the distorted image. By default, it is the identity matrix but you\n.       may additionally scale and shift the result by using a different matrix.\n.       @param new_size the new size\n.   \n.       The function transforms an image to compensate radial and tangential lens distortion.\n.   \n.       The function is simply a combination of #fisheye::initUndistortRectifyMap (with unity R ) and #remap\n.       (with bilinear interpolation). See the former function for details of the transformation being\n.       performed.\n.   \n.       See below the results of undistortImage.\n.          -   a\\) result of undistort of perspective camera model (all possible coefficients (k_1, k_2, k_3,\n.               k_4, k_5, k_6) of distortion were optimized under calibration)\n.           -   b\\) result of #fisheye::undistortImage of fisheye camera model (all possible coefficients (k_1, k_2,\n.               k_3, k_4) of fisheye distortion were optimized under calibration)\n.           -   c\\) original image was captured with fisheye lens\n.   \n.       Pictures a) and b) almost the same. But if we consider points of image located far from the center\n.       of image, we can notice that on image a) these points are distorted.\n.   \n.       ![image](pics/fisheye_undistorted.jpg)"},
    {"undistortPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_fisheye_undistortPoints, 0), "undistortPoints(distorted, K, D[, undistorted[, R[, P[, criteria]]]]) -> undistorted\n.   @brief Undistorts 2D points using fisheye model\n.   \n.       @param distorted Array of object points, 1xN/Nx1 2-channel (or vector\\<Point2f\\> ), where N is the\n.       number of points in the view.\n.       @param K Camera intrinsic matrix \\f$\\cameramatrix{K}\\f$.\n.       @param D Input vector of distortion coefficients \\f$\\distcoeffsfisheye\\f$.\n.       @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3\n.       1-channel or 1x1 3-channel\n.       @param P New camera intrinsic matrix (3x3) or new projection matrix (3x4)\n.       @param criteria Termination criteria\n.       @param undistorted Output array of image points, 1xN/Nx1 2-channel, or vector\\<Point2f\\> ."},
#ifdef PYOPENCV_EXTRA_METHODS_FISHEYE
    PYOPENCV_EXTRA_METHODS_FISHEYE
#endif
    {NULL, NULL}
};

static ConstDef consts_fisheye[] = {
    {"CALIB_CHECK_COND", static_cast<long>(cv::fisheye::CALIB_CHECK_COND)},
    {"CALIB_FIX_FOCAL_LENGTH", static_cast<long>(cv::fisheye::CALIB_FIX_FOCAL_LENGTH)},
    {"CALIB_FIX_INTRINSIC", static_cast<long>(cv::fisheye::CALIB_FIX_INTRINSIC)},
    {"CALIB_FIX_K1", static_cast<long>(cv::fisheye::CALIB_FIX_K1)},
    {"CALIB_FIX_K2", static_cast<long>(cv::fisheye::CALIB_FIX_K2)},
    {"CALIB_FIX_K3", static_cast<long>(cv::fisheye::CALIB_FIX_K3)},
    {"CALIB_FIX_K4", static_cast<long>(cv::fisheye::CALIB_FIX_K4)},
    {"CALIB_FIX_PRINCIPAL_POINT", static_cast<long>(cv::fisheye::CALIB_FIX_PRINCIPAL_POINT)},
    {"CALIB_FIX_SKEW", static_cast<long>(cv::fisheye::CALIB_FIX_SKEW)},
    {"CALIB_RECOMPUTE_EXTRINSIC", static_cast<long>(cv::fisheye::CALIB_RECOMPUTE_EXTRINSIC)},
    {"CALIB_USE_INTRINSIC_GUESS", static_cast<long>(cv::fisheye::CALIB_USE_INTRINSIC_GUESS)},
    {"CALIB_ZERO_DISPARITY", static_cast<long>(cv::fisheye::CALIB_ZERO_DISPARITY)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_FISHEYE
    PYOPENCV_EXTRA_CONSTANTS_FISHEYE
#endif
    {NULL, 0}
};

static PyMethodDef methods_flann[] = {
#ifdef PYOPENCV_EXTRA_METHODS_FLANN
    PYOPENCV_EXTRA_METHODS_FLANN
#endif
    {NULL, NULL}
};

static ConstDef consts_flann[] = {
    {"FLANN_INDEX_TYPE_16S", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_16S)},
    {"FLANN_INDEX_TYPE_16U", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_16U)},
    {"FLANN_INDEX_TYPE_32F", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_32F)},
    {"FLANN_INDEX_TYPE_32S", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_32S)},
    {"FLANN_INDEX_TYPE_64F", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_64F)},
    {"FLANN_INDEX_TYPE_8S", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_8S)},
    {"FLANN_INDEX_TYPE_8U", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_8U)},
    {"FLANN_INDEX_TYPE_ALGORITHM", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_ALGORITHM)},
    {"FLANN_INDEX_TYPE_BOOL", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_BOOL)},
    {"FLANN_INDEX_TYPE_STRING", static_cast<long>(cv::flann::FLANN_INDEX_TYPE_STRING)},
    {"LAST_VALUE_FLANN_INDEX_TYPE", static_cast<long>(cv::flann::LAST_VALUE_FLANN_INDEX_TYPE)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_FLANN
    PYOPENCV_EXTRA_CONSTANTS_FLANN
#endif
    {NULL, 0}
};

static PyMethodDef methods_freetype[] = {
    {"createFreeType2", CV_PY_FN_WITH_KW_(pyopencv_cv_freetype_createFreeType2, 0), "createFreeType2() -> retval\n.   @brief Create FreeType2 Instance\n.   \n.   The function createFreeType2 create instance to draw UTF-8 strings."},
#ifdef PYOPENCV_EXTRA_METHODS_FREETYPE
    PYOPENCV_EXTRA_METHODS_FREETYPE
#endif
    {NULL, NULL}
};

static ConstDef consts_freetype[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_FREETYPE
    PYOPENCV_EXTRA_CONSTANTS_FREETYPE
#endif
    {NULL, 0}
};

static PyMethodDef methods_ft[] = {
    {"FT02D_FL_process", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT02D_FL_process, 0), "FT02D_FL_process(matrix, radius[, output]) -> output\n.   @brief Sligtly less accurate version of \\f$F^0\\f$-transfrom computation optimized for higher speed. The methods counts with linear basic function.\n.       @param matrix Input 3 channels matrix.\n.       @param radius Radius of the `ft::LINEAR` basic function.\n.       @param output Output array.\n.   \n.       This function computes F-transfrom and inverse F-transfotm using linear basic function in one step. It is ~10 times faster than `ft::FT02D_process` method."},
    {"FT02D_FL_process_float", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT02D_FL_process_float, 0), "FT02D_FL_process_float(matrix, radius[, output]) -> output\n.   @brief Sligtly less accurate version of \\f$F^0\\f$-transfrom computation optimized for higher speed. The methods counts with linear basic function.\n.       @param matrix Input 3 channels matrix.\n.       @param radius Radius of the `ft::LINEAR` basic function.\n.       @param output Output array.\n.   \n.       This function computes F-transfrom and inverse F-transfotm using linear basic function in one step. It is ~9 times faster then `ft::FT02D_process` method and more accurate than `ft::FT02D_FL_process` method."},
    {"FT02D_components", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT02D_components, 0), "FT02D_components(matrix, kernel[, components[, mask]]) -> components\n.   @brief Computes components of the array using direct \\f$F^0\\f$-transform.\n.       @param matrix Input array.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param components Output 32-bit float array for the components.\n.       @param mask Mask can be used for unwanted area marking.\n.   \n.       The function computes components using predefined kernel and mask."},
    {"FT02D_inverseFT", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT02D_inverseFT, 0), "FT02D_inverseFT(components, kernel, width, height[, output]) -> output\n.   @brief Computes inverse \\f$F^0\\f$-transfrom.\n.       @param components Input 32-bit float single channel array for the components.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param output Output 32-bit float array.\n.       @param width Width of the output array.\n.       @param height Height of the output array.\n.   \n.       Computation of inverse F-transform."},
    {"FT02D_iteration", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT02D_iteration, 0), "FT02D_iteration(matrix, kernel, mask, firstStop[, output[, maskOutput]]) -> retval, output, maskOutput\n.   @brief Computes \\f$F^0\\f$-transfrom and inverse \\f$F^0\\f$-transfrom at once and return state.\n.       @param matrix Input matrix.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param output Output 32-bit float array.\n.       @param mask Mask used for unwanted area marking.\n.       @param maskOutput Mask after one iteration.\n.       @param firstStop If **true** function returns -1 when first problem appears. In case of `false` the process is completed and summation of all problems returned.\n.   \n.       This function computes iteration of F-transfrom and inverse F-transfotm and handle image and mask change. The function is used in `ft::inpaint` function."},
    {"FT02D_process", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT02D_process, 0), "FT02D_process(matrix, kernel[, output[, mask]]) -> output\n.   @brief Computes \\f$F^0\\f$-transfrom and inverse \\f$F^0\\f$-transfrom at once.\n.       @param matrix Input matrix.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param output Output 32-bit float array.\n.       @param mask Mask used for unwanted area marking.\n.   \n.       This function computes F-transfrom and inverse F-transfotm in one step. It is fully sufficient and optimized for `cv::Mat`."},
    {"FT12D_components", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT12D_components, 0), "FT12D_components(matrix, kernel[, components]) -> components\n.   @brief Computes components of the array using direct \\f$F^1\\f$-transform.\n.       @param matrix Input array.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param components Output 32-bit float array for the components.\n.   \n.       The function computes linear components using predefined kernel."},
    {"FT12D_createPolynomMatrixHorizontal", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT12D_createPolynomMatrixHorizontal, 0), "FT12D_createPolynomMatrixHorizontal(radius, chn[, matrix]) -> matrix\n.   @brief Creates horizontal matrix for \\f$F^1\\f$-transform computation.\n.       @param radius Radius of the basic function.\n.       @param matrix The horizontal matrix.\n.       @param chn Number of channels.\n.   \n.       The function creates helper horizontal matrix for \\f$F^1\\f$-transfrom processing. It is used for gradient computation."},
    {"FT12D_createPolynomMatrixVertical", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT12D_createPolynomMatrixVertical, 0), "FT12D_createPolynomMatrixVertical(radius, chn[, matrix]) -> matrix\n.   @brief Creates vertical matrix for \\f$F^1\\f$-transform computation.\n.       @param radius Radius of the basic function.\n.       @param matrix The vertical matrix.\n.       @param chn Number of channels.\n.   \n.       The function creates helper vertical matrix for \\f$F^1\\f$-transfrom processing. It is used for gradient computation."},
    {"FT12D_inverseFT", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT12D_inverseFT, 0), "FT12D_inverseFT(components, kernel, width, height[, output]) -> output\n.   @brief Computes inverse \\f$F^1\\f$-transfrom.\n.       @param components Input 32-bit float single channel array for the components.\n.       @param kernel Kernel used for processing. The same kernel as for components computation must be used.\n.       @param output Output 32-bit float array.\n.       @param width Width of the output array.\n.       @param height Height of the output array.\n.   \n.       Computation of inverse \\f$F^1\\f$-transform."},
    {"FT12D_polynomial", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT12D_polynomial, 0), "FT12D_polynomial(matrix, kernel[, c00[, c10[, c01[, components[, mask]]]]]) -> c00, c10, c01, components\n.   @brief Computes elements of \\f$F^1\\f$-transform components.\n.       @param matrix Input array.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param c00 Elements represent average color.\n.       @param c10 Elements represent average vertical gradient.\n.       @param c01 Elements represent average horizontal gradient.\n.       @param components Output 32-bit float array for the components.\n.       @param mask Mask can be used for unwanted area marking.\n.   \n.       The function computes components and its elements using predefined kernel and mask."},
    {"FT12D_process", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_FT12D_process, 0), "FT12D_process(matrix, kernel[, output[, mask]]) -> output\n.   @brief Computes \\f$F^1\\f$-transfrom and inverse \\f$F^1\\f$-transfrom at once.\n.       @param matrix Input matrix.\n.       @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.       @param output Output 32-bit float array.\n.       @param mask Mask used for unwanted area marking.\n.   \n.       This function computes \\f$F^1\\f$-transfrom and inverse \\f$F^1\\f$-transfotm in one step. It is fully sufficient and optimized for `cv::Mat`.\n.   \n.       @note\n.           F-transform technique of first degreee is described in paper @cite Vlas:FT."},
    {"createKernel", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_createKernel, 0), "createKernel(function, radius, chn[, kernel]) -> kernel\n.   @brief Creates kernel from general functions.\n.       @param function Function type could be one of the following:\n.           -   **LINEAR** Linear basic function.\n.       @param radius Radius of the basic function.\n.       @param kernel Final 32-bit kernel.\n.       @param chn Number of kernel channels.\n.   \n.       The function creates kernel from predefined functions."},
    {"createKernel1", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_createKernel1, 0), "createKernel1(A, B, chn[, kernel]) -> kernel\n.   @brief Creates kernel from basic functions.\n.       @param A Basic function used in axis **x**.\n.       @param B Basic function used in axis **y**.\n.       @param kernel Final 32-bit kernel derived from **A** and **B**.\n.       @param chn Number of kernel channels.\n.   \n.       The function creates kernel usable for latter fuzzy image processing."},
    {"filter", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_filter, 0), "filter(image, kernel[, output]) -> output\n.   @brief Image filtering\n.       @param image Input image.\n.       @param kernel Final 32-bit kernel.\n.       @param output Output 32-bit image.\n.   \n.       Filtering of the input image by means of F-transform."},
    {"inpaint", CV_PY_FN_WITH_KW_(pyopencv_cv_ft_inpaint, 0), "inpaint(image, mask, radius, function, algorithm[, output]) -> output\n.   @brief Image inpainting\n.       @param image Input image.\n.       @param mask Mask used for unwanted area marking.\n.       @param output Output 32-bit image.\n.       @param radius Radius of the basic function.\n.       @param function Function type could be one of the following:\n.           -   `ft::LINEAR` Linear basic function.\n.       @param algorithm Algorithm could be one of the following:\n.           -   `ft::ONE_STEP` One step algorithm.\n.           -   `ft::MULTI_STEP` This algorithm automaticaly increases radius of the basic function.\n.           -   `ft::ITERATIVE` Iterative algorithm running in more steps using partial computations.\n.   \n.       This function provides inpainting technique based on the fuzzy mathematic.\n.   \n.       @note\n.           The algorithms are described in paper @cite Perf:rec."},
#ifdef PYOPENCV_EXTRA_METHODS_FT
    PYOPENCV_EXTRA_METHODS_FT
#endif
    {NULL, NULL}
};

static ConstDef consts_ft[] = {
    {"ITERATIVE", static_cast<long>(cv::ft::ITERATIVE)},
    {"LINEAR", static_cast<long>(cv::ft::LINEAR)},
    {"MULTI_STEP", static_cast<long>(cv::ft::MULTI_STEP)},
    {"ONE_STEP", static_cast<long>(cv::ft::ONE_STEP)},
    {"SINUS", static_cast<long>(cv::ft::SINUS)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_FT
    PYOPENCV_EXTRA_CONSTANTS_FT
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi[] = {
    {"BGR2Gray", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_BGR2Gray, 0), "BGR2Gray(src) -> retval\n.   @brief Converts an image from BGR color space to gray-scaled.\n.   \n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   Resulting gray color value computed as\n.   \\f[\\texttt{dst} (I)= \\texttt{0.114} * \\texttt{src}(I).B + \\texttt{0.587} * \\texttt{src}(I).G  + \\texttt{0.299} * \\texttt{src}(I).R \\f]\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.bgr2gray\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC1.\n.   @sa BGR2LUV"},
    {"BGR2I420", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_BGR2I420, 0), "BGR2I420(src) -> retval\n.   @brief Converts an image from BGR color space to I420 color space.\n.   \n.   The function converts an input image from BGR color space to I420.\n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 1-channel image. @ref CV_8UC1.\n.   Width of I420 output image must be the same as width of input image.\n.   Height of I420 output image must be equal 3/2 from height of input image.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.bgr2i420\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa I4202BGR"},
    {"BGR2LUV", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_BGR2LUV, 0), "BGR2LUV(src) -> retval\n.   @brief Converts an image from BGR color space to LUV color space.\n.   \n.   The function converts an input image from BGR color space to LUV.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.bgr2luv\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa RGB2Lab, RGB2LUV"},
    {"BGR2RGB", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_BGR2RGB, 0), "BGR2RGB(src) -> retval\n.   @brief Converts an image from BGR color space to RGB color space.\n.   \n.   The function converts an input image from BGR color space to RGB.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image is 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.bgr2rgb\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa RGB2BGR"},
    {"BGR2YUV", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_BGR2YUV, 0), "BGR2YUV(src) -> retval\n.   @brief Converts an image from BGR color space to YUV color space.\n.   \n.   The function converts an input image from BGR color space to YUV.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.bgr2yuv\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa YUV2BGR"},
    {"BayerGR2RGB", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_BayerGR2RGB, 0), "BayerGR2RGB(src_gr) -> retval\n.   @brief Converts an image from BayerGR color space to RGB.\n.   The function converts an input image from BayerGR color space to RGB.\n.   The conventional ranges for G, R, and B channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.bayergr2rgb\"\n.   \n.   @param src_gr input image: 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   \n.   @sa YUV2BGR, NV12toRGB"},
    {"Canny", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_Canny, 0), "Canny(image, threshold1, threshold2[, apertureSize[, L2gradient]]) -> retval\n.   @brief Finds edges in an image using the Canny algorithm.\n.   \n.   The function finds edges in the input image and marks them in the output map edges using the\n.   Canny algorithm. The smallest value between threshold1 and threshold2 is used for edge linking. The\n.   largest value is used to find initial segments of strong edges. See\n.   <http://en.wikipedia.org/wiki/Canny_edge_detector>\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.feature.canny\"\n.   \n.   @param image 8-bit input image.\n.   @param threshold1 first threshold for the hysteresis procedure.\n.   @param threshold2 second threshold for the hysteresis procedure.\n.   @param apertureSize aperture size for the Sobel operator.\n.   @param L2gradient a flag, indicating whether a more accurate \\f$L_2\\f$ norm\n.   \\f$=\\sqrt{(dI/dx)^2 + (dI/dy)^2}\\f$ should be used to calculate the image gradient magnitude (\n.   L2gradient=true ), or whether the default \\f$L_1\\f$ norm \\f$=|dI/dx|+|dI/dy|\\f$ is enough (\n.   L2gradient=false )."},
    {"I4202BGR", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_I4202BGR, 0), "I4202BGR(src) -> retval\n.   @brief Converts an image from I420 color space to BGR color space.\n.   \n.   The function converts an input image from I420 color space to BGR.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image. @ref CV_8UC3.\n.   Width of BGR output image must be the same as width of input image.\n.   Height of BGR output image must be equal 2/3 from height of input image.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.i4202bgr\"\n.   \n.   @param src input image: 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   @sa BGR2I420"},
    {"I4202RGB", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_I4202RGB, 0), "I4202RGB(src) -> retval\n.   @brief Converts an image from I420 color space to BGR color space.\n.   \n.   The function converts an input image from I420 color space to BGR.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image. @ref CV_8UC3.\n.   Width of RGB output image must be the same as width of input image.\n.   Height of RGB output image must be equal 2/3 from height of input image.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.i4202rgb\"\n.   \n.   @param src input image: 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   @sa RGB2I420"},
    {"LUT", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_LUT, 0), "LUT(src, lut) -> retval\n.   @brief Performs a look-up table transform of a matrix.\n.   \n.   The function LUT fills the output matrix with values from the look-up table. Indices of the entries\n.   are taken from the input matrix. That is, the function processes each element of src as follows:\n.   \\f[\\texttt{dst} (I)  \\leftarrow \\texttt{lut(src(I))}\\f]\n.   \n.   Supported matrix data types are @ref CV_8UC1.\n.   Output is a matrix of the same size and number of channels as src, and the same depth as lut.\n.   \n.   @note Function textual ID is \"org.opencv.core.transform.LUT\"\n.   \n.   @param src input matrix of 8-bit elements.\n.   @param lut look-up table of 256 elements; in case of multi-channel input array, the table should\n.   either have a single channel (in this case the same table is used for all channels) or the same\n.   number of channels as in the input matrix."},
    {"LUV2BGR", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_LUV2BGR, 0), "LUV2BGR(src) -> retval\n.   @brief Converts an image from LUV color space to BGR color space.\n.   \n.   The function converts an input image from LUV color space to BGR.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.luv2bgr\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa BGR2LUV"},
    {"Laplacian", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_Laplacian, 0), "Laplacian(src, ddepth[, ksize[, scale[, delta[, borderType]]]]) -> retval\n.   @brief Calculates the Laplacian of an image.\n.   \n.   The function calculates the Laplacian of the source image by adding up the second x and y\n.   derivatives calculated using the Sobel operator:\n.   \n.   \\f[\\texttt{dst} =  \\Delta \\texttt{src} =  \\frac{\\partial^2 \\texttt{src}}{\\partial x^2} +  \\frac{\\partial^2 \\texttt{src}}{\\partial y^2}\\f]\n.   \n.   This is done when `ksize > 1`. When `ksize == 1`, the Laplacian is computed by filtering the image\n.   with the following \\f$3 \\times 3\\f$ aperture:\n.   \n.   \\f[\\vecthreethree {0}{1}{0}{1}{-4}{1}{0}{1}{0}\\f]\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.filters.laplacian\"\n.   \n.   @param src Source image.\n.   @param ddepth Desired depth of the destination image.\n.   @param ksize Aperture size used to compute the second-derivative filters. See #getDerivKernels for\n.   details. The size must be positive and odd.\n.   @param scale Optional scale factor for the computed Laplacian values. By default, no scaling is\n.   applied. See #getDerivKernels for details.\n.   @param delta Optional delta value that is added to the results prior to storing them in dst .\n.   @param borderType Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @return Destination image of the same size and the same number of channels as src.\n.   @sa  Sobel, Scharr"},
    {"NV12toBGR", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_NV12toBGR, 0), "NV12toBGR(src_y, src_uv) -> retval\n.   @brief Converts an image from NV12 (YUV420p) color space to BGR.\n.   The function converts an input image from NV12 color space to RGB.\n.   The conventional ranges for Y, U, and V channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.nv12tobgr\"\n.   \n.   @param src_y input image: 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   @param src_uv input image: 8-bit unsigned 2-channel image @ref CV_8UC2.\n.   \n.   @sa YUV2BGR, NV12toRGB"},
    {"NV12toGray", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_NV12toGray, 0), "NV12toGray(src_y, src_uv) -> retval\n.   @brief Converts an image from NV12 (YUV420p) color space to gray-scaled.\n.   The function converts an input image from NV12 color space to gray-scaled.\n.   The conventional ranges for Y, U, and V channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.nv12togray\"\n.   \n.   @param src_y input image: 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   @param src_uv input image: 8-bit unsigned 2-channel image @ref CV_8UC2.\n.   \n.   @sa YUV2RGB, NV12toBGR"},
    {"NV12toRGB", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_NV12toRGB, 0), "NV12toRGB(src_y, src_uv) -> retval\n.   @brief Converts an image from NV12 (YUV420p) color space to RGB.\n.   The function converts an input image from NV12 color space to RGB.\n.   The conventional ranges for Y, U, and V channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.nv12torgb\"\n.   \n.   @param src_y input image: 8-bit unsigned 1-channel image @ref CV_8UC1.\n.   @param src_uv input image: 8-bit unsigned 2-channel image @ref CV_8UC2.\n.   \n.   @sa YUV2RGB, NV12toBGR"},
    {"RGB2Gray", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_RGB2Gray, 0), "RGB2Gray(src) -> retval\n.   @brief Converts an image from RGB color space to gray-scaled.\n.   \n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   Resulting gray color value computed as\n.   \\f[\\texttt{dst} (I)= \\texttt{0.299} * \\texttt{src}(I).R + \\texttt{0.587} * \\texttt{src}(I).G  + \\texttt{0.114} * \\texttt{src}(I).B \\f]\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2gray\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC1.\n.   @sa RGB2YUV\n\n\n\nRGB2Gray(src, rY, gY, bY) -> retval\n.   @overload\n.   Resulting gray color value computed as\n.   \\f[\\texttt{dst} (I)= \\texttt{rY} * \\texttt{src}(I).R + \\texttt{gY} * \\texttt{src}(I).G  + \\texttt{bY} * \\texttt{src}(I).B \\f]\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2graycustom\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC1.\n.   @param rY float multiplier for R channel.\n.   @param gY float multiplier for G channel.\n.   @param bY float multiplier for B channel.\n.   @sa RGB2YUV"},
    {"RGB2HSV", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_RGB2HSV, 0), "RGB2HSV(src) -> retval\n.   @brief Converts an image from RGB color space to HSV.\n.   The function converts an input image from RGB color space to HSV.\n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2hsv\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @sa YUV2BGR, NV12toRGB"},
    {"RGB2I420", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_RGB2I420, 0), "RGB2I420(src) -> retval\n.   @brief Converts an image from RGB color space to I420 color space.\n.   \n.   The function converts an input image from RGB color space to I420.\n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 1-channel image. @ref CV_8UC1.\n.   Width of I420 output image must be the same as width of input image.\n.   Height of I420 output image must be equal 3/2 from height of input image.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2i420\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa I4202RGB"},
    {"RGB2Lab", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_RGB2Lab, 0), "RGB2Lab(src) -> retval\n.   @brief Converts an image from RGB color space to Lab color space.\n.   \n.   The function converts an input image from BGR color space to Lab.\n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC1.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2lab\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC1.\n.   @sa RGB2YUV, RGB2LUV"},
    {"RGB2YUV", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_RGB2YUV, 0), "RGB2YUV(src) -> retval\n.   @brief Converts an image from RGB color space to YUV color space.\n.   \n.   The function converts an input image from RGB color space to YUV.\n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   \n.   In case of linear transformations, the range does not matter. But in case of a non-linear\n.   transformation, an input RGB image should be normalized to the proper value range to get the correct\n.   results, like here, at RGB \\f$\\rightarrow\\f$ Y\\*u\\*v\\* transformation.\n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2yuv\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa YUV2RGB, RGB2Lab"},
    {"RGB2YUV422", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_RGB2YUV422, 0), "RGB2YUV422(src) -> retval\n.   @brief Converts an image from RGB color space to YUV422.\n.   The function converts an input image from RGB color space to YUV422.\n.   The conventional ranges for R, G, and B channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 2-channel image @ref CV_8UC2.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.rgb2yuv422\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @sa YUV2BGR, NV12toRGB"},
    {"Sobel", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_Sobel, 0), "Sobel(src, ddepth, dx, dy[, ksize[, scale[, delta[, borderType[, borderValue]]]]]) -> retval\n.   @brief Calculates the first, second, third, or mixed image derivatives using an extended Sobel operator.\n.   \n.   In all cases except one, the \\f$\\texttt{ksize} \\times \\texttt{ksize}\\f$ separable kernel is used to\n.   calculate the derivative. When \\f$\\texttt{ksize = 1}\\f$, the \\f$3 \\times 1\\f$ or \\f$1 \\times 3\\f$\n.   kernel is used (that is, no Gaussian smoothing is done). `ksize = 1` can only be used for the first\n.   or the second x- or y- derivatives.\n.   \n.   There is also the special value `ksize = FILTER_SCHARR (-1)` that corresponds to the \\f$3\\times3\\f$ Scharr\n.   filter that may give more accurate results than the \\f$3\\times3\\f$ Sobel. The Scharr aperture is\n.   \n.   \\f[\\vecthreethree{-3}{0}{3}{-10}{0}{10}{-3}{0}{3}\\f]\n.   \n.   for the x-derivative, or transposed for the y-derivative.\n.   \n.   The function calculates an image derivative by convolving the image with the appropriate kernel:\n.   \n.   \\f[\\texttt{dst} =  \\frac{\\partial^{xorder+yorder} \\texttt{src}}{\\partial x^{xorder} \\partial y^{yorder}}\\f]\n.   \n.   The Sobel operators combine Gaussian smoothing and differentiation, so the result is more or less\n.   resistant to the noise. Most often, the function is called with ( xorder = 1, yorder = 0, ksize = 3)\n.   or ( xorder = 0, yorder = 1, ksize = 3) to calculate the first x- or y- image derivative. The first\n.   case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{0}{1}{-2}{0}{2}{-1}{0}{1}\\f]\n.   \n.   The second case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{-2}{-1}{0}{0}{0}{1}{2}{1}\\f]\n.   \n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.sobel\"\n.   \n.   @param src input image.\n.   @param ddepth output image depth, see @ref filter_depths \"combinations\"; in the case of\n.       8-bit input images it will result in truncated derivatives.\n.   @param dx order of the derivative x.\n.   @param dy order of the derivative y.\n.   @param ksize size of the extended Sobel kernel; it must be odd.\n.   @param scale optional scale factor for the computed derivative values; by default, no scaling is\n.   applied (see cv::getDerivKernels for details).\n.   @param delta optional delta value that is added to the results prior to storing them in dst.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa filter2D, gaussianBlur, cartToPolar"},
    {"SobelXY", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_SobelXY, 0), "SobelXY(src, ddepth, order[, ksize[, scale[, delta[, borderType[, borderValue]]]]]) -> retval\n.   @brief Calculates the first, second, third, or mixed image derivatives using an extended Sobel operator.\n.   \n.   In all cases except one, the \\f$\\texttt{ksize} \\times \\texttt{ksize}\\f$ separable kernel is used to\n.   calculate the derivative. When \\f$\\texttt{ksize = 1}\\f$, the \\f$3 \\times 1\\f$ or \\f$1 \\times 3\\f$\n.   kernel is used (that is, no Gaussian smoothing is done). `ksize = 1` can only be used for the first\n.   or the second x- or y- derivatives.\n.   \n.   There is also the special value `ksize = FILTER_SCHARR (-1)` that corresponds to the \\f$3\\times3\\f$ Scharr\n.   filter that may give more accurate results than the \\f$3\\times3\\f$ Sobel. The Scharr aperture is\n.   \n.   \\f[\\vecthreethree{-3}{0}{3}{-10}{0}{10}{-3}{0}{3}\\f]\n.   \n.   for the x-derivative, or transposed for the y-derivative.\n.   \n.   The function calculates an image derivative by convolving the image with the appropriate kernel:\n.   \n.   \\f[\\texttt{dst} =  \\frac{\\partial^{xorder+yorder} \\texttt{src}}{\\partial x^{xorder} \\partial y^{yorder}}\\f]\n.   \n.   The Sobel operators combine Gaussian smoothing and differentiation, so the result is more or less\n.   resistant to the noise. Most often, the function is called with ( xorder = 1, yorder = 0, ksize = 3)\n.   or ( xorder = 0, yorder = 1, ksize = 3) to calculate the first x- or y- image derivative. The first\n.   case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{0}{1}{-2}{0}{2}{-1}{0}{1}\\f]\n.   \n.   The second case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{-2}{-1}{0}{0}{0}{1}{2}{1}\\f]\n.   \n.   @note\n.    - First returned matrix correspons to dx derivative while the second one to dy.\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.sobelxy\"\n.   \n.   @param src input image.\n.   @param ddepth output image depth, see @ref filter_depths \"combinations\"; in the case of\n.       8-bit input images it will result in truncated derivatives.\n.   @param order order of the derivatives.\n.   @param ksize size of the extended Sobel kernel; it must be odd.\n.   @param scale optional scale factor for the computed derivative values; by default, no scaling is\n.   applied (see cv::getDerivKernels for details).\n.   @param delta optional delta value that is added to the results prior to storing them in dst.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa filter2D, gaussianBlur, cartToPolar"},
    {"YUV2BGR", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_YUV2BGR, 0), "YUV2BGR(src) -> retval\n.   @brief Converts an image from YUV color space to BGR color space.\n.   \n.   The function converts an input image from YUV color space to BGR.\n.   The conventional ranges for B, G, and R channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.yuv2bgr\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   @sa BGR2YUV"},
    {"YUV2RGB", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_YUV2RGB, 0), "YUV2RGB(src) -> retval\n.   @brief Converts an image from YUV color space to RGB.\n.   The function converts an input image from YUV color space to RGB.\n.   The conventional ranges for Y, U, and V channel values are 0 to 255.\n.   \n.   Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.colorconvert.yuv2rgb\"\n.   \n.   @param src input image: 8-bit unsigned 3-channel image @ref CV_8UC3.\n.   \n.   @sa RGB2Lab, RGB2YUV"},
    {"absDiff", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_absDiff, 0), "absDiff(src1, src2) -> retval\n.   @brief Calculates the per-element absolute difference between two matrices.\n.   \n.   The function absDiff calculates absolute difference between two matrices of the same size and depth:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1}(I) -  \\texttt{src2}(I)|)\\f]\n.       where I is a multi-dimensional index of matrix elements. In case of\n.       multi-channel matrices, each channel is processed independently.\n.   Output matrix must have the same size and depth as input matrices.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.absdiff\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix.\n.   @sa abs"},
    {"absDiffC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_absDiffC, 0), "absDiffC(src, c) -> retval\n.   @brief Calculates absolute value of matrix elements.\n.   \n.   The function abs calculates absolute difference between matrix elements and given scalar value:\n.       \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1}(I) -  \\texttt{matC}(I)|)\\f]\n.       where matC is constructed from given scalar c and has the same sizes and depth as input matrix src.\n.   \n.   Output matrix must be of the same size and depth as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.absdiffC\"\n.   @param src input matrix.\n.   @param c scalar to be subtracted.\n.   @sa min, max"},
    {"add", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_add, 0), "add(src1, src2[, ddepth]) -> retval\n.   @brief Calculates the per-element sum of two matrices.\n.   \n.   The function add calculates sum of two matrices of the same size and the same number of channels:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) +  \\texttt{src2}(I)) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   \n.   The function can be replaced with matrix expressions:\n.       \\f[\\texttt{dst} =  \\texttt{src1} + \\texttt{src2}\\f]\n.   \n.   The input matrices and the output matrix can all have the same or different depths. For example, you\n.   can add a 16-bit unsigned matrix to a 8-bit signed matrix and store the sum as a 32-bit\n.   floating-point matrix. Depth of the output matrix is determined by the ddepth parameter.\n.   If src1.depth() == src2.depth(), ddepth can be set to the default -1. In this case, the output matrix will have\n.   the same depth as the input matrices.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.add\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix.\n.   @param ddepth optional depth of the output matrix.\n.   @sa sub, addWeighted"},
    {"addC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_addC, 0), "addC(src1, c[, ddepth]) -> retval\n.   @brief Calculates the per-element sum of matrix and given scalar.\n.   \n.   The function addC adds a given scalar value to each element of given matrix.\n.   The function can be replaced with matrix expressions:\n.   \n.       \\f[\\texttt{dst} =  \\texttt{src1} + \\texttt{c}\\f]\n.   \n.   Depth of the output matrix is determined by the ddepth parameter.\n.   If ddepth is set to default -1, the depth of output matrix will be the same as the depth of input matrix.\n.   The matrices can be single or multi channel. Output matrix must have the same size and number of channels as the input matrix.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.addC\"\n.   @param src1 first input matrix.\n.   @param c scalar value to be added.\n.   @param ddepth optional depth of the output matrix.\n.   @sa sub, addWeighted\n\n\n\naddC(c, src1[, ddepth]) -> retval\n."},
    {"addWeighted", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_addWeighted, 0), "addWeighted(src1, alpha, src2, beta, gamma[, ddepth]) -> retval\n.   @brief Calculates the weighted sum of two matrices.\n.   \n.   The function addWeighted calculates the weighted sum of two matrices as follows:\n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} ( \\texttt{src1} (I)* \\texttt{alpha} +  \\texttt{src2} (I)* \\texttt{beta} +  \\texttt{gamma} )\\f]\n.   where I is a multi-dimensional index of array elements. In case of multi-channel matrices, each\n.   channel is processed independently.\n.   \n.   The function can be replaced with a matrix expression:\n.       \\f[\\texttt{dst}(I) =  \\texttt{alpha} * \\texttt{src1}(I) - \\texttt{beta} * \\texttt{src2}(I) + \\texttt{gamma} \\f]\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.addweighted\"\n.   @param src1 first input matrix.\n.   @param alpha weight of the first matrix elements.\n.   @param src2 second input matrix of the same size and channel number as src1.\n.   @param beta weight of the second matrix elements.\n.   @param gamma scalar added to each sum.\n.   @param ddepth optional depth of the output matrix.\n.   @sa  add, sub"},
    {"bilateralFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_bilateralFilter, 0), "bilateralFilter(src, d, sigmaColor, sigmaSpace[, borderType]) -> retval\n.   @brief Applies the bilateral filter to an image.\n.   \n.   The function applies bilateral filtering to the input image, as described in\n.   http://www.dai.ed.ac.uk/CVonline/LOCAL_COPIES/MANDUCHI1/Bilateral_Filtering.html\n.   bilateralFilter can reduce unwanted noise very well while keeping edges fairly sharp. However, it is\n.   very slow compared to most filters.\n.   \n.   _Sigma values_: For simplicity, you can set the 2 sigma values to be the same. If they are small (\\<\n.   10), the filter will not have much effect, whereas if they are large (\\> 150), they will have a very\n.   strong effect, making the image look \"cartoonish\".\n.   \n.   _Filter size_: Large filters (d \\> 5) are very slow, so it is recommended to use d=5 for real-time\n.   applications, and perhaps d=9 for offline applications that need heavy noise filtering.\n.   \n.   This filter does not work inplace.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.filters.bilateralfilter\"\n.   \n.   @param src Source 8-bit or floating-point, 1-channel or 3-channel image.\n.   @param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,\n.   it is computed from sigmaSpace.\n.   @param sigmaColor Filter sigma in the color space. A larger value of the parameter means that\n.   farther colors within the pixel neighborhood (see sigmaSpace) will be mixed together, resulting\n.   in larger areas of semi-equal color.\n.   @param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that\n.   farther pixels will influence each other as long as their colors are close enough (see sigmaColor\n.   ). When d\\>0, it specifies the neighborhood size regardless of sigmaSpace. Otherwise, d is\n.   proportional to sigmaSpace.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes\n.   @return Destination image of the same size and type as src."},
    {"bitwise_and", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_bitwise_and, 0), "bitwise_and(src1, src2) -> retval\n.   @brief computes bitwise conjunction of the two matrixes (src1 & src2)\n.   Calculates the per-element bit-wise logical conjunction of two matrices of the same size.\n.   \n.   In case of floating-point matrices, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel matrices, each channel is processed\n.   independently. Output matrix must have the same size and depth as the input\n.   matrices.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.bitwise_and\"\n.   \n.   @param src1 first input matrix.\n.   @param src2 second input matrix."},
    {"bitwise_not", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_bitwise_not, 0), "bitwise_not(src) -> retval\n.   @brief Inverts every bit of an array.\n.   \n.   The function bitwise_not calculates per-element bit-wise inversion of the input\n.   matrix:\n.   \\f[\\texttt{dst} (I) =  \\neg \\texttt{src} (I)\\f]\n.   \n.   In case of floating-point matrices, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel matrices, each channel is processed\n.   independently. Output matrix must have the same size and depth as the input\n.   matrix.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.bitwise_not\"\n.   \n.   @param src input matrix."},
    {"bitwise_or", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_bitwise_or, 0), "bitwise_or(src1, src2) -> retval\n.   @brief computes bitwise disjunction of the two matrixes (src1 | src2)\n.   Calculates the per-element bit-wise logical disjunction of two matrices of the same size.\n.   \n.   In case of floating-point matrices, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel matrices, each channel is processed\n.   independently. Output matrix must have the same size and depth as the input\n.   matrices.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.bitwise_or\"\n.   \n.   @param src1 first input matrix.\n.   @param src2 second input matrix."},
    {"bitwise_xor", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_bitwise_xor, 0), "bitwise_xor(src1, src2) -> retval\n.   @brief computes bitwise logical \"exclusive or\" of the two matrixes (src1 ^ src2)\n.   Calculates the per-element bit-wise logical \"exclusive or\" of two matrices of the same size.\n.   \n.   In case of floating-point matrices, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel matrices, each channel is processed\n.   independently. Output matrix must have the same size and depth as the input\n.   matrices.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.bitwise_xor\"\n.   \n.   @param src1 first input matrix.\n.   @param src2 second input matrix."},
    {"blur", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_blur, 0), "blur(src, ksize[, anchor[, borderType[, borderValue]]]) -> retval\n.   @brief Blurs an image using the normalized box filter.\n.   \n.   The function smooths an image using the kernel:\n.   \n.   \\f[\\texttt{K} =  \\frac{1}{\\texttt{ksize.width*ksize.height}} \\begin{bmatrix} 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\hdotsfor{6} \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\end{bmatrix}\\f]\n.   \n.   The call `blur(src, ksize, anchor, borderType)` is equivalent to `boxFilter(src, src.type(), ksize, anchor,\n.   true, borderType)`.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.blur\"\n.   \n.   @param src Source image.\n.   @param ksize blurring kernel size.\n.   @param anchor anchor point; default value Point(-1,-1) means that the anchor is at the kernel\n.   center.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa  boxFilter, bilateralFilter, GaussianBlur, medianBlur"},
    {"boundingRect", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_boundingRect, 0), "boundingRect(src) -> retval\n.   @brief Calculates the up-right bounding rectangle of a point set or non-zero pixels\n.   of gray-scale image.\n.   \n.   The function calculates and returns the minimal up-right bounding rectangle for the specified\n.   point set or non-zero pixels of gray-scale image.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.imgproc.shape.boundingRectMat\"\n.    - In case of a 2D points' set given, Mat should be 2-dimensional, have a single row or column\n.   if there are 2 channels, or have 2 columns if there is a single channel. Mat should have either\n.   @ref CV_32S or @ref CV_32F depth\n.   \n.   @param src Input gray-scale image @ref CV_8UC1; or input set of @ref CV_32S or @ref CV_32F\n.   2D points stored in Mat."},
    {"boxFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_boxFilter, 0), "boxFilter(src, dtype, ksize[, anchor[, normalize[, borderType[, borderValue]]]]) -> retval\n.   @brief Blurs an image using the box filter.\n.   \n.   The function smooths an image using the kernel:\n.   \n.   \\f[\\texttt{K} =  \\alpha \\begin{bmatrix} 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\hdotsfor{6} \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1 \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[\\alpha = \\begin{cases} \\frac{1}{\\texttt{ksize.width*ksize.height}} & \\texttt{when } \\texttt{normalize=true}  \\\\1 & \\texttt{otherwise} \\end{cases}\\f]\n.   \n.   Unnormalized box filter is useful for computing various integral characteristics over each pixel\n.   neighborhood, such as covariance matrices of image derivatives (used in dense optical flow\n.   algorithms, and so on). If you need to compute pixel sums over variable-size windows, use cv::integral.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.boxfilter\"\n.   \n.   @param src Source image.\n.   @param dtype the output image depth (-1 to set the input image data type).\n.   @param ksize blurring kernel size.\n.   @param anchor Anchor position within the kernel. The default value \\f$(-1,-1)\\f$ means that the anchor\n.   is at the kernel center.\n.   @param normalize flag, specifying whether the kernel is normalized by its area or not.\n.   @param borderType Pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa  sepFilter, gaussianBlur, medianBlur, integral"},
    {"cartToPolar", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cartToPolar, 0), "cartToPolar(x, y[, angleInDegrees]) -> retval\n.   @brief Calculates the magnitude and angle of 2D vectors.\n.   \n.   The function cartToPolar calculates either the magnitude, angle, or both\n.   for every 2D vector (x(I),y(I)):\n.   \\f[\\begin{array}{l} \\texttt{magnitude} (I)= \\sqrt{\\texttt{x}(I)^2+\\texttt{y}(I)^2} , \\\\ \\texttt{angle} (I)= \\texttt{atan2} ( \\texttt{y} (I), \\texttt{x} (I))[ \\cdot180 / \\pi ] \\end{array}\\f]\n.   \n.   The angles are calculated with accuracy about 0.3 degrees. For the point\n.   (0,0), the angle is set to 0.\n.   \n.   First output is a matrix of magnitudes of the same size and depth as input x.\n.   Second output is a matrix of angles that has the same size and depth as\n.   x; the angles are measured in radians (from 0 to 2\\*Pi) or in degrees (0 to 360 degrees).\n.   \n.   @note Function textual ID is \"org.opencv.core.math.cartToPolar\"\n.   \n.   @param x matrix of @ref CV_32FC1 x-coordinates.\n.   @param y array of @ref CV_32FC1 y-coordinates.\n.   @param angleInDegrees a flag, indicating whether the angles are measured\n.   in radians (which is by default), or in degrees.\n.   @sa polarToCart"},
    {"cmpEQ", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cmpEQ, 0), "cmpEQ(src1, src2) -> retval\n.   @brief Performs the per-element comparison of two matrices checking if elements from first matrix are equal to elements in second.\n.   \n.   The function compares elements of two matrices src1 and src2 of the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  ==  \\texttt{src2} (I)\\f]\n.   \n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.       \\f[\\texttt{dst} =   \\texttt{src1} == \\texttt{src2}\\f]\n.   \n.   Output matrix of depth @ref CV_8U must have the same size and the same number of channels as\n.       the input matrices.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.compare.cmpEQ\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix/scalar of the same depth as first input matrix.\n.   @sa min, max, threshold, cmpNE"},
    {"cmpGE", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cmpGE, 0), "cmpGE(src1, src2) -> retval\n.   @brief Performs the per-element comparison of two matrices checking if elements from first matrix are greater or equal compare to elements in second.\n.   \n.   The function compares elements of two matrices src1 and src2 of the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  >= \\texttt{src2} (I)\\f]\n.   \n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.       \\f[\\texttt{dst} =   \\texttt{src1} >= \\texttt{src2}\\f]\n.   \n.   Output matrix of depth @ref CV_8U must have the same size and the same number of channels as\n.       the input matrices.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.compare.cmpGE\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix/scalar of the same depth as first input matrix.\n.   @sa min, max, threshold, cmpLE, cmpGT, cmpLT"},
    {"cmpGT", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cmpGT, 0), "cmpGT(src1, src2) -> retval\n.   @brief Performs the per-element comparison of two matrices checking if elements from first matrix are greater compare to elements in second.\n.   \n.   The function compares elements of two matrices src1 and src2 of the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  > \\texttt{src2} (I)\\f]\n.   \n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.   \\f[\\texttt{dst} =   \\texttt{src1} > \\texttt{src2}\\f]\n.   \n.   Output matrix of depth @ref CV_8U must have the same size and the same number of channels as\n.       the input matrices/matrix.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.compare.cmpGT\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix/scalar of the same depth as first input matrix.\n.   @sa min, max, threshold, cmpLE, cmpGE, cmpLT"},
    {"cmpLE", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cmpLE, 0), "cmpLE(src1, src2) -> retval\n.   @brief Performs the per-element comparison of two matrices checking if elements from first matrix are less or equal compare to elements in second.\n.   \n.   The function compares elements of two matrices src1 and src2 of the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  <=  \\texttt{src2} (I)\\f]\n.   \n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.       \\f[\\texttt{dst} =   \\texttt{src1} <= \\texttt{src2}\\f]\n.   \n.   Output matrix of depth @ref CV_8U must have the same size and the same number of channels as\n.       the input matrices.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.compare.cmpLE\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix/scalar of the same depth as first input matrix.\n.   @sa min, max, threshold, cmpGT, cmpGE, cmpLT"},
    {"cmpLT", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cmpLT, 0), "cmpLT(src1, src2) -> retval\n.   @brief Performs the per-element comparison of two matrices checking if elements from first matrix are less than elements in second.\n.   \n.   The function compares elements of two matrices src1 and src2 of the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  < \\texttt{src2} (I)\\f]\n.   \n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.       \\f[\\texttt{dst} =   \\texttt{src1} < \\texttt{src2}\\f]\n.   \n.   Output matrix of depth @ref CV_8U must have the same size and the same number of channels as\n.       the input matrices/matrix.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.compare.cmpLT\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix/scalar of the same depth as first input matrix.\n.   @sa min, max, threshold, cmpLE, cmpGE, cmpGT"},
    {"cmpNE", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_cmpNE, 0), "cmpNE(src1, src2) -> retval\n.   @brief Performs the per-element comparison of two matrices checking if elements from first matrix are not equal to elements in second.\n.   \n.   The function compares elements of two matrices src1 and src2 of the same size:\n.       \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  !=  \\texttt{src2} (I)\\f]\n.   \n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.       \\f[\\texttt{dst} =   \\texttt{src1} != \\texttt{src2}\\f]\n.   \n.   Output matrix of depth @ref CV_8U must have the same size and the same number of channels as\n.       the input matrices.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.compare.cmpNE\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix/scalar of the same depth as first input matrix.\n.   @sa min, max, threshold, cmpEQ"},
    {"combine", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_combine, 0), "combine(lhs, rhs) -> retval\n.   * Declares a new G-API Operation. See [Kernel API](@ref gapi_kernel_api) for more details.\n.    *\n.    * @deprecated This macro is deprecated in favor of `G_TYPED_KERNEL` that is used for declaring any\n.    * G-API Operation.\n.    *\n.    * @param Class type name for this operation."},
    {"concatHor", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_concatHor, 0), "concatHor(src1, src2) -> retval\n.   @brief Applies horizontal concatenation to given matrices.\n.   \n.   The function horizontally concatenates two GMat matrices (with the same number of rows).\n.   @code{.cpp}\n.       GMat A = { 1, 4,\n.                  2, 5,\n.                  3, 6 };\n.       GMat B = { 7, 10,\n.                  8, 11,\n.                  9, 12 };\n.   \n.       GMat C = gapi::concatHor(A, B);\n.       //C:\n.       //[1, 4, 7, 10;\n.       // 2, 5, 8, 11;\n.       // 3, 6, 9, 12]\n.   @endcode\n.   Output matrix must the same number of rows and depth as the src1 and src2, and the sum of cols of the src1 and src2.\n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.transform.concatHor\"\n.   \n.   @param src1 first input matrix to be considered for horizontal concatenation.\n.   @param src2 second input matrix to be considered for horizontal concatenation.\n.   @sa concatVert\n\n\n\nconcatHor(v) -> retval\n.   @overload\n.   The function horizontally concatenates given number of GMat matrices (with the same number of columns).\n.   Output matrix must the same number of columns and depth as the input matrices, and the sum of rows of input matrices.\n.   \n.   @param v vector of input matrices to be concatenated horizontally."},
    {"concatVert", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_concatVert, 0), "concatVert(src1, src2) -> retval\n.   @brief Applies vertical concatenation to given matrices.\n.   \n.   The function vertically concatenates two GMat matrices (with the same number of cols).\n.    @code{.cpp}\n.       GMat A = { 1, 7,\n.                  2, 8,\n.                  3, 9 };\n.       GMat B = { 4, 10,\n.                  5, 11,\n.                  6, 12 };\n.   \n.       GMat C = gapi::concatVert(A, B);\n.       //C:\n.       //[1, 7;\n.       // 2, 8;\n.       // 3, 9;\n.       // 4, 10;\n.       // 5, 11;\n.       // 6, 12]\n.    @endcode\n.   \n.   Output matrix must the same number of cols and depth as the src1 and src2, and the sum of rows of the src1 and src2.\n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.transform.concatVert\"\n.   \n.   @param src1 first input matrix to be considered for vertical concatenation.\n.   @param src2 second input matrix to be considered for vertical concatenation.\n.   @sa concatHor\n\n\n\nconcatVert(v) -> retval\n.   @overload\n.   The function vertically concatenates given number of GMat matrices (with the same number of columns).\n.   Output matrix must the same number of columns and depth as the input matrices, and the sum of rows of input matrices.\n.   \n.   @param v vector of input matrices to be concatenated vertically."},
    {"convertTo", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_convertTo, 0), "convertTo(src, rdepth[, alpha[, beta]]) -> retval\n.   @brief Converts a matrix to another data depth with optional scaling.\n.   \n.   The method converts source pixel values to the target data depth. saturate_cast\\<\\> is applied at\n.   the end to avoid possible overflows:\n.   \n.   \\f[m(x,y) = saturate \\_ cast<rType>( \\alpha (*this)(x,y) +  \\beta )\\f]\n.   Output matrix must be of the same size as input one.\n.   \n.   @note Function textual ID is \"org.opencv.core.transform.convertTo\"\n.   @param src input matrix to be converted from.\n.   @param rdepth desired output matrix depth or, rather, the depth since the number of channels are the\n.   same as the input has; if rdepth is negative, the output matrix will have the same depth as the input.\n.   @param alpha optional scale factor.\n.   @param beta optional delta added to the scaled values."},
    {"copy", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_copy, 0), "copy(in_) -> retval\n.   @brief Makes a copy of the input image. Note that this copy may be not real\n.   (no actual data copied). Use this function to maintain graph contracts,\n.   e.g when graph's input needs to be passed directly to output, like in Streaming mode.\n.   \n.   @note Function textual ID is \"org.opencv.streaming.copy\"\n.   \n.   @param in Input image\n.   @return Copy of the input"},
    {"countNonZero", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_countNonZero, 0), "countNonZero(src) -> retval\n.   @brief Counts non-zero array elements.\n.   \n.   The function returns the number of non-zero elements in src :\n.   \\f[\\sum _{I: \\; \\texttt{src} (I) \\ne0 } 1\\f]\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.countNonZero\"\n.   @param src input single-channel matrix.\n.   @sa  mean, min, max"},
    {"crop", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_crop, 0), "crop(src, rect) -> retval\n.   @brief Crops a 2D matrix.\n.   \n.   The function crops the matrix by given cv::Rect.\n.   \n.   Output matrix must be of the same depth as input one, size is specified by given rect size.\n.   \n.   @note Function textual ID is \"org.opencv.core.transform.crop\"\n.   \n.   @param src input matrix.\n.   @param rect a rect to crop a matrix to\n.   @sa resize"},
    {"dilate", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_dilate, 0), "dilate(src, kernel[, anchor[, iterations[, borderType[, borderValue]]]]) -> retval\n.   @brief Dilates an image by using a specific structuring element.\n.   \n.   The function dilates the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the maximum is taken:\n.   \\f[\\texttt{dst} (x,y) =  \\max _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   Dilation can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.\n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.dilate\"\n.   \n.   @param src input image.\n.   @param kernel structuring element used for dilation; if elemenat=Mat(), a 3 x 3 rectangular\n.   structuring element is used. Kernel can be created using getStructuringElement\n.   @param anchor position of the anchor within the element; default value (-1, -1) means that the\n.   anchor is at the element center.\n.   @param iterations number of times dilation is applied.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of a constant border\n.   @sa  erode, morphologyEx, getStructuringElement"},
    {"dilate3x3", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_dilate3x3, 0), "dilate3x3(src[, iterations[, borderType[, borderValue]]]) -> retval\n.   @brief Dilates an image by using 3 by 3 rectangular structuring element.\n.   \n.   The function dilates the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the maximum is taken:\n.   \\f[\\texttt{dst} (x,y) =  \\max _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   Dilation can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.\n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.dilate\"\n.   \n.   @param src input image.\n.   @param iterations number of times dilation is applied.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of a constant border\n.   @sa  dilate, erode3x3"},
    {"div", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_div, 0), "div(src1, src2, scale[, ddepth]) -> retval\n.   @brief Performs per-element division of two matrices.\n.   \n.   The function divides one matrix by another:\n.   \\f[\\texttt{dst(I) = saturate(src1(I)*scale/src2(I))}\\f]\n.   \n.   For integer types when src2(I) is zero, dst(I) will also be zero.\n.   Floating point case returns Inf/NaN (according to IEEE).\n.   \n.   Different channels of\n.   multi-channel matrices are processed independently.\n.   The matrices can be single or multi channel. Output matrix must have the same size and depth as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.div\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix of the same size and depth as src1.\n.   @param scale scalar factor.\n.   @param ddepth optional depth of the output matrix; you can only pass -1 when src1.depth() == src2.depth().\n.   @sa  mul, add, sub"},
    {"divC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_divC, 0), "divC(src, divisor, scale[, ddepth]) -> retval\n.   @brief Divides matrix by scalar.\n.   \n.   The function divC divides each element of matrix src by given scalar value:\n.   \n.   \\f[\\texttt{dst(I) = saturate(src(I)*scale/divisor)}\\f]\n.   \n.   When divisor is zero, dst(I) will also be zero. Different channels of\n.   multi-channel matrices are processed independently.\n.   The matrices can be single or multi channel. Output matrix must have the same size and depth as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.divC\"\n.   @param src input matrix.\n.   @param divisor number to be divided by.\n.   @param ddepth optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.\n.   @param scale scale factor.\n.   @sa add, sub, div, addWeighted"},
    {"divRC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_divRC, 0), "divRC(divident, src, scale[, ddepth]) -> retval\n.   @brief Divides scalar by matrix.\n.   \n.   The function divRC divides given scalar by each element of matrix src and keep the division result in new matrix of the same size and type as src:\n.   \n.   \\f[\\texttt{dst(I) = saturate(divident*scale/src(I))}\\f]\n.   \n.   When src(I) is zero, dst(I) will also be zero. Different channels of\n.   multi-channel matrices are processed independently.\n.   The matrices can be single or multi channel. Output matrix must have the same size and depth as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.divRC\"\n.   @param src input matrix.\n.   @param divident number to be divided.\n.   @param ddepth optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.\n.   @param scale scale factor\n.   @sa add, sub, div, addWeighted"},
    {"equalizeHist", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_equalizeHist, 0), "equalizeHist(src) -> retval\n.   @brief Equalizes the histogram of a grayscale image.\n.   \n.   //! @} gapi_feature\n.   \n.   The function equalizes the histogram of the input image using the following algorithm:\n.   \n.   - Calculate the histogram \\f$H\\f$ for src .\n.   - Normalize the histogram so that the sum of histogram bins is 255.\n.   - Compute the integral of the histogram:\n.   \\f[H'_i =  \\sum _{0  \\le j < i} H(j)\\f]\n.   - Transform the image using \\f$H'\\f$ as a look-up table: \\f$\\texttt{dst}(x,y) = H'(\\texttt{src}(x,y))\\f$\n.   \n.   The algorithm normalizes the brightness and increases the contrast of the image.\n.   @note\n.    - The returned image is of the same size and type as input.\n.    - Function textual ID is \"org.opencv.imgproc.equalizeHist\"\n.   \n.   @param src Source 8-bit single channel image."},
    {"erode", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_erode, 0), "erode(src, kernel[, anchor[, iterations[, borderType[, borderValue]]]]) -> retval\n.   @brief Erodes an image by using a specific structuring element.\n.   \n.   The function erodes the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the minimum is taken:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\min _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   Erosion can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.\n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.erode\"\n.   \n.   @param src input image\n.   @param kernel structuring element used for erosion; if `element=Mat()`, a `3 x 3` rectangular\n.   structuring element is used. Kernel can be created using getStructuringElement.\n.   @param anchor position of the anchor within the element; default value (-1, -1) means that the\n.   anchor is at the element center.\n.   @param iterations number of times erosion is applied.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of a constant border\n.   @sa  dilate, morphologyEx"},
    {"erode3x3", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_erode3x3, 0), "erode3x3(src[, iterations[, borderType[, borderValue]]]) -> retval\n.   @brief Erodes an image by using 3 by 3 rectangular structuring element.\n.   \n.   The function erodes the source image using the rectangular structuring element with rectangle center as an anchor.\n.   Erosion can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.\n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.erode\"\n.   \n.   @param src input image\n.   @param iterations number of times erosion is applied.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of a constant border\n.   @sa  erode, dilate3x3"},
    {"filter2D", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_filter2D, 0), "filter2D(src, ddepth, kernel[, anchor[, delta[, borderType[, borderValue]]]]) -> retval\n.   @brief Convolves an image with the kernel.\n.   \n.   The function applies an arbitrary linear filter to an image. When\n.   the aperture is partially outside the image, the function interpolates outlier pixel values\n.   according to the specified border mode.\n.   \n.   The function does actually compute correlation, not the convolution:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\sum _{ \\substack{0\\leq x' < \\texttt{kernel.cols}\\\\{0\\leq y' < \\texttt{kernel.rows}}}}  \\texttt{kernel} (x',y')* \\texttt{src} (x+x'- \\texttt{anchor.x} ,y+y'- \\texttt{anchor.y} )\\f]\n.   \n.   That is, the kernel is not mirrored around the anchor point. If you need a real convolution, flip\n.   the kernel using flip and set the new anchor to `(kernel.cols - anchor.x - 1, kernel.rows -\n.   anchor.y - 1)`.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   Output image must have the same size and number of channels an input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.filter2D\"\n.   \n.   @param src input image.\n.   @param ddepth desired depth of the destination image\n.   @param kernel convolution kernel (or rather a correlation kernel), a single-channel floating point\n.   matrix; if you want to apply different kernels to different channels, split the image into\n.   separate color planes using split and process them individually.\n.   @param anchor anchor of the kernel that indicates the relative position of a filtered point within\n.   the kernel; the anchor should lie within the kernel; default value (-1,-1) means that the anchor\n.   is at the kernel center.\n.   @param delta optional value added to the filtered pixels before storing them in dst.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa  sepFilter"},
    {"flip", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_flip, 0), "flip(src, flipCode) -> retval\n.   @brief Flips a 2D matrix around vertical, horizontal, or both axes.\n.   \n.   The function flips the matrix in one of three different ways (row\n.   and column indices are 0-based):\n.   \\f[\\texttt{dst} _{ij} =\n.   \\left\\{\n.   \\begin{array}{l l}\n.   \\texttt{src} _{\\texttt{src.rows}-i-1,j} & if\\;  \\texttt{flipCode} = 0 \\\\\n.   \\texttt{src} _{i, \\texttt{src.cols} -j-1} & if\\;  \\texttt{flipCode} > 0 \\\\\n.   \\texttt{src} _{ \\texttt{src.rows} -i-1, \\texttt{src.cols} -j-1} & if\\; \\texttt{flipCode} < 0 \\\\\n.   \\end{array}\n.   \\right.\\f]\n.   The example scenarios of using the function are the following:\n.   *   Vertical flipping of the image (flipCode == 0) to switch between\n.       top-left and bottom-left image origin. This is a typical operation\n.       in video processing on Microsoft Windows\\* OS.\n.   *   Horizontal flipping of the image with the subsequent horizontal\n.       shift and absolute difference calculation to check for a\n.       vertical-axis symmetry (flipCode \\> 0).\n.   *   Simultaneous horizontal and vertical flipping of the image with\n.       the subsequent shift and absolute difference calculation to check\n.       for a central symmetry (flipCode \\< 0).\n.   *   Reversing the order of point arrays (flipCode \\> 0 or\n.       flipCode == 0).\n.   Output image must be of the same depth as input one, size should be correct for given flipCode.\n.   \n.   @note Function textual ID is \"org.opencv.core.transform.flip\"\n.   \n.   @param src input matrix.\n.   @param flipCode a flag to specify how to flip the array; 0 means\n.   flipping around the x-axis and positive value (for example, 1) means\n.   flipping around y-axis. Negative value (for example, -1) means flipping\n.   around both axes.\n.   @sa remap"},
    {"gaussianBlur", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_gaussianBlur, 0), "gaussianBlur(src, ksize, sigmaX[, sigmaY[, borderType[, borderValue]]]) -> retval\n.   @brief Blurs an image using a Gaussian filter.\n.   \n.   The function filter2Ds the source image with the specified Gaussian kernel.\n.   Output image must have the same type and number of channels an input image.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.    - Function textual ID is \"org.opencv.imgproc.filters.gaussianBlur\"\n.   \n.   @param src input image;\n.   @param ksize Gaussian kernel size. ksize.width and ksize.height can differ but they both must be\n.   positive and odd. Or, they can be zero's and then they are computed from sigma.\n.   @param sigmaX Gaussian kernel standard deviation in X direction.\n.   @param sigmaY Gaussian kernel standard deviation in Y direction; if sigmaY is zero, it is set to be\n.   equal to sigmaX, if both sigmas are zeros, they are computed from ksize.width and ksize.height,\n.   respectively (see cv::getGaussianKernel for details); to fully control the result regardless of\n.   possible future modifications of all this semantics, it is recommended to specify all of ksize,\n.   sigmaX, and sigmaY.\n.   @param borderType pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa  sepFilter, boxFilter, medianBlur"},
    {"goodFeaturesToTrack", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_goodFeaturesToTrack, 0), "goodFeaturesToTrack(image, maxCorners, qualityLevel, minDistance[, mask[, blockSize[, useHarrisDetector[, k]]]]) -> retval\n.   @brief Determines strong corners on an image.\n.   \n.   The function finds the most prominent corners in the image or in the specified image region, as\n.   described in @cite Shi94\n.   \n.   -   Function calculates the corner quality measure at every source image pixel using the\n.       #cornerMinEigenVal or #cornerHarris .\n.   -   Function performs a non-maximum suppression (the local maximums in *3 x 3* neighborhood are\n.       retained).\n.   -   The corners with the minimal eigenvalue less than\n.       \\f$\\texttt{qualityLevel} \\cdot \\max_{x,y} qualityMeasureMap(x,y)\\f$ are rejected.\n.   -   The remaining corners are sorted by the quality measure in the descending order.\n.   -   Function throws away each corner for which there is a stronger corner at a distance less than\n.       maxDistance.\n.   \n.   The function can be used to initialize a point-based tracker of an object.\n.   \n.   @note\n.    - If the function is called with different values A and B of the parameter qualityLevel , and\n.   A \\> B, the vector of returned corners with qualityLevel=A will be the prefix of the output vector\n.   with qualityLevel=B .\n.    - Function textual ID is \"org.opencv.imgproc.feature.goodFeaturesToTrack\"\n.   \n.   @param image Input 8-bit or floating-point 32-bit, single-channel image.\n.   @param maxCorners Maximum number of corners to return. If there are more corners than are found,\n.   the strongest of them is returned. `maxCorners <= 0` implies that no limit on the maximum is set\n.   and all detected corners are returned.\n.   @param qualityLevel Parameter characterizing the minimal accepted quality of image corners. The\n.   parameter value is multiplied by the best corner quality measure, which is the minimal eigenvalue\n.   (see #cornerMinEigenVal ) or the Harris function response (see #cornerHarris ). The corners with the\n.   quality measure less than the product are rejected. For example, if the best corner has the\n.   quality measure = 1500, and the qualityLevel=0.01 , then all the corners with the quality measure\n.   less than 15 are rejected.\n.   @param minDistance Minimum possible Euclidean distance between the returned corners.\n.   @param mask Optional region of interest. If the image is not empty (it needs to have the type\n.   CV_8UC1 and the same size as image ), it specifies the region in which the corners are detected.\n.   @param blockSize Size of an average block for computing a derivative covariation matrix over each\n.   pixel neighborhood. See cornerEigenValsAndVecs .\n.   @param useHarrisDetector Parameter indicating whether to use a Harris detector (see #cornerHarris)\n.   or #cornerMinEigenVal.\n.   @param k Free parameter of the Harris detector.\n.   \n.   @return vector of detected corners."},
    {"inRange", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_inRange, 0), "inRange(src, threshLow, threshUp) -> retval\n.   @brief Applies a range-level threshold to each matrix element.\n.   \n.   The function applies range-level thresholding to a single- or multiple-channel matrix.\n.   It sets output pixel value to OxFF if the corresponding pixel value of input matrix is in specified range,or 0 otherwise.\n.   \n.   Input and output matrices must be CV_8UC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.inRange\"\n.   \n.   @param src input matrix (CV_8UC1).\n.   @param threshLow lower boundary value.\n.   @param threshUp upper boundary value.\n.   \n.   @sa threshold"},
    {"infer", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_infer, 0), "infer(name, inputs) -> retval\n.   \n\n\n\ninfer(name, roi, inputs) -> retval\n.   \n\n\n\ninfer(name, rois, inputs) -> retval\n."},
    {"infer2", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_infer2, 0), "infer2(name, in_, inputs) -> retval\n."},
    {"integral", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_integral, 0), "integral(src[, sdepth[, sqdepth]]) -> retval\n.   @brief Calculates the integral of an image.\n.   \n.   The function calculates one or more integral images for the source image as follows:\n.   \n.   \\f[\\texttt{sum} (X,Y) =  \\sum _{x<X,y<Y}  \\texttt{image} (x,y)\\f]\n.   \n.   \\f[\\texttt{sqsum} (X,Y) =  \\sum _{x<X,y<Y}  \\texttt{image} (x,y)^2\\f]\n.   \n.   The function return integral image as \\f$(W+1)\\times (H+1)\\f$ , 32-bit integer or floating-point (32f or 64f) and\n.    integral image for squared pixel values; it is \\f$(W+1)\\times (H+)\\f$, double-precision floating-point (64f) array.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.integral\"\n.   \n.   @param src input image.\n.   @param sdepth desired depth of the integral and the tilted integral images, CV_32S, CV_32F, or\n.   CV_64F.\n.   @param sqdepth desired depth of the integral image of squared pixel values, CV_32F or CV_64F."},
    {"kmeans", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_kmeans, 0), "kmeans(data, K, bestLabels, criteria, attempts, flags) -> retval\n.   @brief Finds centers of clusters and groups input samples around the clusters.\n.   \n.   The function kmeans implements a k-means algorithm that finds the centers of K clusters\n.   and groups the input samples around the clusters. As an output, \\f$\\texttt{bestLabels}_i\\f$\n.   contains a 0-based cluster index for the \\f$i^{th}\\f$ sample.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.kmeansND\"\n.    - In case of an N-dimentional points' set given, input GMat can have the following traits:\n.   2 dimensions, a single row or column if there are N channels,\n.   or N columns if there is a single channel. Mat should have @ref CV_32F depth.\n.    - Although, if GMat with height != 1, width != 1, channels != 1 given as data, n-dimensional\n.   samples are considered given in amount of A, where A = height, n = width * channels.\n.    - In case of GMat given as data:\n.        - the output labels are returned as 1-channel GMat with sizes\n.   width = 1, height = A, where A is samples amount, or width = bestLabels.width,\n.   height = bestLabels.height if bestLabels given;\n.        - the cluster centers are returned as 1-channel GMat with sizes\n.   width = n, height = K, where n is samples' dimentionality and K is clusters' amount.\n.    - As one of possible usages, if you want to control the initial labels for each attempt\n.   by yourself, you can utilize just the core of the function. To do that, set the number\n.   of attempts to 1, initialize labels each time using a custom algorithm, pass them with the\n.   ( flags = #KMEANS_USE_INITIAL_LABELS ) flag, and then choose the best (most-compact) clustering.\n.   \n.   @param data Data for clustering. An array of N-Dimensional points with float coordinates is needed.\n.   Function can take GArray<Point2f>, GArray<Point3f> for 2D and 3D cases or GMat for any\n.   dimentionality and channels.\n.   @param K Number of clusters to split the set by.\n.   @param bestLabels Optional input integer array that can store the supposed initial cluster indices\n.   for every sample. Used when ( flags = #KMEANS_USE_INITIAL_LABELS ) flag is set.\n.   @param criteria The algorithm termination criteria, that is, the maximum number of iterations\n.   and/or the desired accuracy. The accuracy is specified as criteria.epsilon. As soon as each of\n.   the cluster centers moves by less than criteria.epsilon on some iteration, the algorithm stops.\n.   @param attempts Flag to specify the number of times the algorithm is executed using different\n.   initial labellings. The algorithm returns the labels that yield the best compactness (see the first\n.   function return value).\n.   @param flags Flag that can take values of cv::KmeansFlags .\n.   \n.   @return\n.    - Compactness measure that is computed as\n.   \\f[\\sum _i  \\| \\texttt{samples} _i -  \\texttt{centers} _{ \\texttt{labels} _i} \\| ^2\\f]\n.   after every attempt. The best (minimum) value is chosen and the corresponding labels and the\n.   compactness value are returned by the function.\n.    - Integer array that stores the cluster indices for every sample.\n.    - Array of the cluster centers.\n\n\n\nkmeans(data, K, criteria, attempts, flags) -> retval\n.   @overload\n.   @note\n.    - Function textual ID is \"org.opencv.core.kmeansNDNoInit\"\n.    - #KMEANS_USE_INITIAL_LABELS flag must not be set while using this overload."},
    {"mask", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_mask, 0), "mask(src, mask) -> retval\n.   @brief Applies a mask to a matrix.\n.   \n.   The function mask set value from given matrix if the corresponding pixel value in mask matrix set to true,\n.   and set the matrix value to 0 otherwise.\n.   \n.   Supported src matrix data types are @ref CV_8UC1, @ref CV_16SC1, @ref CV_16UC1. Supported mask data type is @ref CV_8UC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.mask\"\n.   @param src input matrix.\n.   @param mask input mask matrix."},
    {"max", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_max, 0), "max(src1, src2) -> retval\n.   @brief Calculates per-element maximum of two matrices.\n.   \n.   The function max calculates the per-element maximum of two matrices of the same size, number of channels and depth:\n.   \\f[\\texttt{dst} (I)= \\max ( \\texttt{src1} (I), \\texttt{src2} (I))\\f]\n.       where I is a multi-dimensional index of matrix elements. In case of\n.       multi-channel matrices, each channel is processed independently.\n.   Output matrix must be of the same size and depth as src1.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.max\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix of the same size and depth as src1.\n.   @sa min, compare, cmpEQ, cmpGT, cmpGE"},
    {"mean", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_mean, 0), "mean(src) -> retval\n.   @brief Calculates an average (mean) of matrix elements.\n.   \n.   The function mean calculates the mean value M of matrix elements,\n.   independently for each channel, and return it.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.mean\"\n.   @param src input matrix.\n.   @sa  countNonZero, min, max"},
    {"medianBlur", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_medianBlur, 0), "medianBlur(src, ksize) -> retval\n.   @brief Blurs an image using the median filter.\n.   \n.   The function smoothes an image using the median filter with the \\f$\\texttt{ksize} \\times\n.   \\texttt{ksize}\\f$ aperture. Each channel of a multi-channel image is processed independently.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.\n.   The median filter uses cv::BORDER_REPLICATE internally to cope with border pixels, see cv::BorderTypes\n.    - Function textual ID is \"org.opencv.imgproc.filters.medianBlur\"\n.   \n.   @param src input matrix (image)\n.   @param ksize aperture linear size; it must be odd and greater than 1, for example: 3, 5, 7 ...\n.   @sa  boxFilter, gaussianBlur"},
    {"merge3", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_merge3, 0), "merge3(src1, src2, src3) -> retval\n.   @brief Creates one 3-channel matrix out of 3 single-channel ones.\n.   \n.   The function merges several matrices to make a single multi-channel matrix. That is, each\n.   element of the output matrix will be a concatenation of the elements of the input matrices, where\n.   elements of i-th input matrix are treated as mv[i].channels()-element vectors.\n.   Output matrix must be of @ref CV_8UC3 type.\n.   \n.   The function split3 does the reverse operation.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.transform.merge3\"\n.   \n.   @param src1 first input @ref CV_8UC1 matrix to be merged.\n.   @param src2 second input @ref CV_8UC1 matrix to be merged.\n.   @param src3 third input @ref CV_8UC1 matrix to be merged.\n.   @sa merge4, split4, split3"},
    {"merge4", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_merge4, 0), "merge4(src1, src2, src3, src4) -> retval\n.   @brief Creates one 4-channel matrix out of 4 single-channel ones.\n.   \n.   The function merges several matrices to make a single multi-channel matrix. That is, each\n.   element of the output matrix will be a concatenation of the elements of the input matrices, where\n.   elements of i-th input matrix are treated as mv[i].channels()-element vectors.\n.   Output matrix must be of @ref CV_8UC4 type.\n.   \n.   The function split4 does the reverse operation.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.transform.merge4\"\n.   \n.   @param src1 first input @ref CV_8UC1 matrix to be merged.\n.   @param src2 second input @ref CV_8UC1 matrix to be merged.\n.   @param src3 third input @ref CV_8UC1 matrix to be merged.\n.   @param src4 fourth input @ref CV_8UC1 matrix to be merged.\n.   @sa merge3, split4, split3"},
    {"min", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_min, 0), "min(src1, src2) -> retval\n.   @brief Calculates per-element minimum of two matrices.\n.   \n.   The function min calculates the per-element minimum of two matrices of the same size, number of channels and depth:\n.   \\f[\\texttt{dst} (I)= \\min ( \\texttt{src1} (I), \\texttt{src2} (I))\\f]\n.       where I is a multi-dimensional index of matrix elements. In case of\n.       multi-channel matrices, each channel is processed independently.\n.   Output matrix must be of the same size and depth as src1.\n.   \n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.min\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix of the same size and depth as src1.\n.   @sa max, cmpEQ, cmpLT, cmpLE"},
    {"morphologyEx", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_morphologyEx, 0), "morphologyEx(src, op, kernel[, anchor[, iterations[, borderType[, borderValue]]]]) -> retval\n.   @brief Performs advanced morphological transformations.\n.   \n.   The function can perform advanced morphological transformations using an erosion and dilation as\n.   basic operations.\n.   \n.   Any of the operations can be done in-place. In case of multi-channel images, each channel is\n.   processed independently.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.imgproc.filters.morphologyEx\"\n.    - The number of iterations is the number of times erosion or dilatation operation will be\n.   applied. For instance, an opening operation (#MORPH_OPEN) with two iterations is equivalent to\n.   apply successively: erode -> erode -> dilate -> dilate\n.   (and not erode -> dilate -> erode -> dilate).\n.   \n.   @param src Input image.\n.   @param op Type of a morphological operation, see #MorphTypes\n.   @param kernel Structuring element. It can be created using #getStructuringElement.\n.   @param anchor Anchor position within the element. Both negative values mean that the anchor is at\n.   the kernel center.\n.   @param iterations Number of times erosion and dilation are applied.\n.   @param borderType Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.\n.   @param borderValue Border value in case of a constant border. The default value has a special\n.   meaning.\n.   @sa  dilate, erode, getStructuringElement"},
    {"mul", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_mul, 0), "mul(src1, src2[, scale[, ddepth]]) -> retval\n.   @brief Calculates the per-element scaled product of two matrices.\n.   \n.   The function mul calculates the per-element product of two matrices:\n.   \n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} ( \\texttt{scale} \\cdot \\texttt{src1} (I)  \\cdot \\texttt{src2} (I))\\f]\n.   \n.   If src1.depth() == src2.depth(), ddepth can be set to the default -1. In this case, the output matrix will have\n.   the same depth as the input matrices. The matrices can be single or multi channel.\n.   Output matrix must have the same size as input matrices.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.mul\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix of the same size and the same depth as src1.\n.   @param scale optional scale factor.\n.   @param ddepth optional depth of the output matrix.\n.   @sa add, sub, div, addWeighted"},
    {"mulC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_mulC, 0), "mulC(src, multiplier[, ddepth]) -> retval\n.   @brief Multiplies matrix by scalar.\n.   \n.   The function mulC multiplies each element of matrix src by given scalar value:\n.   \n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} (  \\texttt{src1} (I)  \\cdot \\texttt{multiplier} )\\f]\n.   \n.   The matrices can be single or multi channel. Output matrix must have the same size as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.mulC\"\n.   @param src input matrix.\n.   @param multiplier factor to be multiplied.\n.   @param ddepth optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.\n.   @sa add, sub, div, addWeighted\n\n\n\nmulC(multiplier, src[, ddepth]) -> retval\n."},
    {"normInf", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_normInf, 0), "normInf(src) -> retval\n.   @brief Calculates the absolute infinite norm of a matrix.\n.   \n.   This version of normInf calculates the absolute infinite norm of src.\n.   \n.   As example for one array consider the function \\f$r(x)= \\begin{pmatrix} x \\\\ 1-x \\end{pmatrix}, x \\in [-1;1]\\f$.\n.   The \\f$ L_{\\infty} \\f$ norm for the sample value \\f$r(-1) = \\begin{pmatrix} -1 \\\\ 2 \\end{pmatrix}\\f$\n.   is calculated as follows\n.   \\f{align*}\n.       \\| r(-1) \\|_{L_\\infty} &= \\max(|-1|,|2|) = 2\n.   \\f}\n.   and for \\f$r(0.5) = \\begin{pmatrix} 0.5 \\\\ 0.5 \\end{pmatrix}\\f$ the calculation is\n.   \\f{align*}\n.       \\| r(0.5) \\|_{L_\\infty} &= \\max(|0.5|,|0.5|) = 0.5.\n.   \\f}\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.norminf\"\n.   @param src input matrix.\n.   @sa normL1, normL2"},
    {"normL1", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_normL1, 0), "normL1(src) -> retval\n.   @brief Calculates the  absolute L1 norm of a matrix.\n.   \n.   This version of normL1 calculates the absolute L1 norm of src.\n.   \n.   As example for one array consider the function \\f$r(x)= \\begin{pmatrix} x \\\\ 1-x \\end{pmatrix}, x \\in [-1;1]\\f$.\n.   The \\f$ L_{1} \\f$ norm for the sample value \\f$r(-1) = \\begin{pmatrix} -1 \\\\ 2 \\end{pmatrix}\\f$\n.   is calculated as follows\n.   \\f{align*}\n.       \\| r(-1) \\|_{L_1} &= |-1| + |2| = 3 \\\\\n.   \\f}\n.   and for \\f$r(0.5) = \\begin{pmatrix} 0.5 \\\\ 0.5 \\end{pmatrix}\\f$ the calculation is\n.   \\f{align*}\n.       \\| r(0.5) \\|_{L_1} &= |0.5| + |0.5| = 1 \\\\\n.   \\f}\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.norml1\"\n.   @param src input matrix.\n.   @sa normL2, normInf"},
    {"normL2", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_normL2, 0), "normL2(src) -> retval\n.   @brief Calculates the absolute L2 norm of a matrix.\n.   \n.   This version of normL2 calculates the absolute L2 norm of src.\n.   \n.   As example for one array consider the function \\f$r(x)= \\begin{pmatrix} x \\\\ 1-x \\end{pmatrix}, x \\in [-1;1]\\f$.\n.   The \\f$ L_{2} \\f$  norm for the sample value \\f$r(-1) = \\begin{pmatrix} -1 \\\\ 2 \\end{pmatrix}\\f$\n.   is calculated as follows\n.   \\f{align*}\n.       \\| r(-1) \\|_{L_2} &= \\sqrt{(-1)^{2} + (2)^{2}} = \\sqrt{5} \\\\\n.   \\f}\n.   and for \\f$r(0.5) = \\begin{pmatrix} 0.5 \\\\ 0.5 \\end{pmatrix}\\f$ the calculation is\n.   \\f{align*}\n.       \\| r(0.5) \\|_{L_2} &= \\sqrt{(0.5)^{2} + (0.5)^{2}} = \\sqrt{0.5} \\\\\n.   \\f}\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   @note Function textual ID is \"org.opencv.core.matrixop.norml2\"\n.   @param src input matrix.\n.   @sa normL1, normInf"},
    {"normalize", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_normalize, 0), "normalize(src, alpha, beta, norm_type[, ddepth]) -> retval\n.   @brief Normalizes the norm or value range of an array.\n.   \n.   The function normalizes scale and shift the input array elements so that\n.   \\f[\\| \\texttt{dst} \\| _{L_p}= \\texttt{alpha}\\f]\n.   (where p=Inf, 1 or 2) when normType=NORM_INF, NORM_L1, or NORM_L2, respectively; or so that\n.   \\f[\\min _I  \\texttt{dst} (I)= \\texttt{alpha} , \\, \\, \\max _I  \\texttt{dst} (I)= \\texttt{beta}\\f]\n.   when normType=NORM_MINMAX (for dense arrays only).\n.   \n.   @note Function textual ID is \"org.opencv.core.normalize\"\n.   \n.   @param src input array.\n.   @param alpha norm value to normalize to or the lower range boundary in case of the range\n.   normalization.\n.   @param beta upper range boundary in case of the range normalization; it is not used for the norm\n.   normalization.\n.   @param norm_type normalization type (see cv::NormTypes).\n.   @param ddepth when negative, the output array has the same type as src; otherwise, it has the same\n.   number of channels as src and the depth =ddepth.\n.   @sa norm, Mat::convertTo"},
    {"parseSSD", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_parseSSD, 0), "parseSSD(in_, inSz[, confidenceThreshold[, filterLabel]]) -> retval\n.   @brief Parses output of SSD network.\n.   \n.   Extracts detection information (box, confidence, label) from SSD output and\n.   filters it by given confidence and label.\n.   \n.   @note Function textual ID is \"org.opencv.nn.parsers.parseSSD_BL\"\n.   \n.   @param in Input CV_32F tensor with {1,1,N,7} dimensions.\n.   @param inSz Size to project detected boxes to (size of the input image).\n.   @param confidenceThreshold If confidence of the\n.   detection is smaller than confidence threshold, detection is rejected.\n.   @param filterLabel If provided (!= -1), only detections with\n.   given label will get to the output.\n.   @return a tuple with a vector of detected boxes and a vector of appropriate labels.\n\n\n\nparseSSD(in_, inSz, confidenceThreshold, alignmentToSquare, filterOutOfBounds) -> retval\n.   @brief Parses output of SSD network.\n.   \n.   Extracts detection information (box, confidence) from SSD output and\n.   filters it by given confidence and by going out of bounds.\n.   \n.   @note Function textual ID is \"org.opencv.nn.parsers.parseSSD\"\n.   \n.   @param in Input CV_32F tensor with {1,1,N,7} dimensions.\n.   @param inSz Size to project detected boxes to (size of the input image).\n.   @param confidenceThreshold If confidence of the\n.   detection is smaller than confidence threshold, detection is rejected.\n.   @param alignmentToSquare If provided true, bounding boxes are extended to squares.\n.   The center of the rectangle remains unchanged, the side of the square is\n.   the larger side of the rectangle.\n.   @param filterOutOfBounds If provided true, out-of-frame boxes are filtered.\n.   @return a vector of detected bounding boxes."},
    {"parseYolo", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_parseYolo, 0), "parseYolo(in_, inSz[, confidenceThreshold[, nmsThreshold[, anchors]]]) -> retval\n.   @brief Parses output of Yolo network.\n.   \n.   Extracts detection information (box, confidence, label) from Yolo output,\n.   filters it by given confidence and performs non-maximum suppression for overlapping boxes.\n.   \n.   @note Function textual ID is \"org.opencv.nn.parsers.parseYolo\"\n.   \n.   @param in Input CV_32F tensor with {1,13,13,N} dimensions, N should satisfy:\n.   \\f[\\texttt{N} = (\\texttt{num_classes} + \\texttt{5}) * \\texttt{5},\\f]\n.   where num_classes - a number of classes Yolo network was trained with.\n.   @param inSz Size to project detected boxes to (size of the input image).\n.   @param confidenceThreshold If confidence of the\n.   detection is smaller than confidence threshold, detection is rejected.\n.   @param nmsThreshold Non-maximum suppression threshold which controls minimum\n.   relative box intersection area required for rejecting the box with a smaller confidence.\n.   If 1.f, nms is not performed and no boxes are rejected.\n.   @param anchors Anchors Yolo network was trained with.\n.   @note The default anchor values are specified for YOLO v2 Tiny as described in Intel Open Model Zoo\n.   <a href=\"https://github.com/openvinotoolkit/open_model_zoo/blob/master/models/public/yolo-v2-tiny-tf/yolo-v2-tiny-tf.md\">documentation</a>.\n.   @return a tuple with a vector of detected boxes and a vector of appropriate labels."},
    {"phase", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_phase, 0), "phase(x, y[, angleInDegrees]) -> retval\n.   @brief Calculates the rotation angle of 2D vectors.\n.   \n.   The function cv::phase calculates the rotation angle of each 2D vector that\n.   is formed from the corresponding elements of x and y :\n.   \\f[\\texttt{angle} (I) =  \\texttt{atan2} ( \\texttt{y} (I), \\texttt{x} (I))\\f]\n.   \n.   The angle estimation accuracy is about 0.3 degrees. When x(I)=y(I)=0 ,\n.   the corresponding angle(I) is set to 0.\n.   @param x input floating-point array of x-coordinates of 2D vectors.\n.   @param y input array of y-coordinates of 2D vectors; it must have the\n.   same size and the same type as x.\n.   @param angleInDegrees when true, the function calculates the angle in\n.   degrees, otherwise, they are measured in radians.\n.   @return array of vector angles; it has the same size and same type as x."},
    {"polarToCart", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_polarToCart, 0), "polarToCart(magnitude, angle[, angleInDegrees]) -> retval\n.   @brief Calculates x and y coordinates of 2D vectors from their magnitude and angle.\n.   \n.   The function polarToCart calculates the Cartesian coordinates of each 2D\n.   vector represented by the corresponding elements of magnitude and angle:\n.   \\f[\\begin{array}{l} \\texttt{x} (I) =  \\texttt{magnitude} (I) \\cos ( \\texttt{angle} (I)) \\\\ \\texttt{y} (I) =  \\texttt{magnitude} (I) \\sin ( \\texttt{angle} (I)) \\\\ \\end{array}\\f]\n.   \n.   The relative accuracy of the estimated coordinates is about 1e-6.\n.   \n.   First output is a matrix of x-coordinates of 2D vectors.\n.   Second output is a matrix of y-coordinates of 2D vectors.\n.   Both output must have the same size and depth as input matrices.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.polarToCart\"\n.   \n.   @param magnitude input floating-point @ref CV_32FC1 matrix (1xN) of magnitudes of 2D vectors;\n.   @param angle input floating-point @ref CV_32FC1 matrix (1xN) of angles of 2D vectors.\n.   @param angleInDegrees when true, the input angles are measured in\n.   degrees, otherwise, they are measured in radians.\n.   @sa cartToPolar, exp, log, pow, sqrt"},
    {"remap", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_remap, 0), "remap(src, map1, map2, interpolation[, borderMode[, borderValue]]) -> retval\n.   @brief Applies a generic geometrical transformation to an image.\n.   \n.   The function remap transforms the source image using the specified map:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} (map_x(x,y),map_y(x,y))\\f]\n.   \n.   where values of pixels with non-integer coordinates are computed using one of available\n.   interpolation methods. \\f$map_x\\f$ and \\f$map_y\\f$ can be encoded as separate floating-point maps\n.   in \\f$map_1\\f$ and \\f$map_2\\f$ respectively, or interleaved floating-point maps of \\f$(x,y)\\f$ in\n.   \\f$map_1\\f$, or fixed-point maps created by using convertMaps. The reason you might want to\n.   convert from floating to fixed-point representations of a map is that they can yield much faster\n.   (\\~2x) remapping operations. In the converted case, \\f$map_1\\f$ contains pairs (cvFloor(x),\n.   cvFloor(y)) and \\f$map_2\\f$ contains indices in a table of interpolation coefficients.\n.   Output image must be of the same size and depth as input one.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.transform.remap\"\n.    - Due to current implementation limitations the size of an input and output images should be less than 32767x32767.\n.   \n.   @param src Source image.\n.   @param map1 The first map of either (x,y) points or just x values having the type CV_16SC2,\n.   CV_32FC1, or CV_32FC2.\n.   @param map2 The second map of y values having the type CV_16UC1, CV_32FC1, or none (empty map\n.   if map1 is (x,y) points), respectively.\n.   @param interpolation Interpolation method (see cv::InterpolationFlags). The methods #INTER_AREA\n.   and #INTER_LINEAR_EXACT are not supported by this function.\n.   @param borderMode Pixel extrapolation method (see cv::BorderTypes). When\n.   borderMode=BORDER_TRANSPARENT, it means that the pixels in the destination image that\n.   corresponds to the \"outliers\" in the source image are not modified by the function.\n.   @param borderValue Value used in case of a constant border. By default, it is 0."},
    {"resize", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_resize, 0), "resize(src, dsize[, fx[, fy[, interpolation]]]) -> retval\n.   @brief Resizes an image.\n.   \n.   The function resizes the image src down to or up to the specified size.\n.   \n.   Output image size will have the size dsize (when dsize is non-zero) or the size computed from\n.   src.size(), fx, and fy; the depth of output is the same as of src.\n.   \n.   If you want to resize src so that it fits the pre-created dst,\n.   you may call the function as follows:\n.   @code\n.       // explicitly specify dsize=dst.size(); fx and fy will be computed from that.\n.       resize(src, dst, dst.size(), 0, 0, interpolation);\n.   @endcode\n.   If you want to decimate the image by factor of 2 in each direction, you can call the function this\n.   way:\n.   @code\n.       // specify fx and fy and let the function compute the destination image size.\n.       resize(src, dst, Size(), 0.5, 0.5, interpolation);\n.   @endcode\n.   To shrink an image, it will generally look best with cv::INTER_AREA interpolation, whereas to\n.   enlarge an image, it will generally look best with cv::INTER_CUBIC (slow) or cv::INTER_LINEAR\n.   (faster but still looks OK).\n.   \n.   @note Function textual ID is \"org.opencv.imgproc.transform.resize\"\n.   \n.   @param src input image.\n.   @param dsize output image size; if it equals zero, it is computed as:\n.    \\f[\\texttt{dsize = Size(round(fx*src.cols), round(fy*src.rows))}\\f]\n.    Either dsize or both fx and fy must be non-zero.\n.   @param fx scale factor along the horizontal axis; when it equals 0, it is computed as\n.   \\f[\\texttt{(double)dsize.width/src.cols}\\f]\n.   @param fy scale factor along the vertical axis; when it equals 0, it is computed as\n.   \\f[\\texttt{(double)dsize.height/src.rows}\\f]\n.   @param interpolation interpolation method, see cv::InterpolationFlags\n.   \n.   @sa  warpAffine, warpPerspective, remap, resizeP"},
    {"select", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_select, 0), "select(src1, src2, mask) -> retval\n.   @brief Select values from either first or second of input matrices by given mask.\n.   The function set to the output matrix either the value from the first input matrix if corresponding value of mask matrix is 255,\n.    or value from the second input matrix (if value of mask matrix set to 0).\n.   \n.   Input mask matrix must be of @ref CV_8UC1 type, two other inout matrices and output matrix should be of the same type. The size should\n.   be the same for all input and output matrices.\n.   Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.pixelwise.select\"\n.   \n.   @param src1 first input matrix.\n.   @param src2 second input matrix.\n.   @param mask mask input matrix."},
    {"sepFilter", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_sepFilter, 0), "sepFilter(src, ddepth, kernelX, kernelY, anchor, delta[, borderType[, borderValue]]) -> retval\n.   @brief Applies a separable linear filter to a matrix(image).\n.   \n.   The function applies a separable linear filter to the matrix. That is, first, every row of src is\n.   filtered with the 1D kernel kernelX. Then, every column of the result is filtered with the 1D\n.   kernel kernelY. The final result is returned.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   Output image must have the same type, size, and number of channels as the input image.\n.   @note\n.    - In case of floating-point computation, rounding to nearest even is procedeed\n.   if hardware supports it (if not - to nearest value).\n.    - Function textual ID is \"org.opencv.imgproc.filters.sepfilter\"\n.   @param src Source image.\n.   @param ddepth desired depth of the destination image (the following combinations of src.depth() and ddepth are supported:\n.   \n.           src.depth() = CV_8U, ddepth = -1/CV_16S/CV_32F/CV_64F\n.           src.depth() = CV_16U/CV_16S, ddepth = -1/CV_32F/CV_64F\n.           src.depth() = CV_32F, ddepth = -1/CV_32F/CV_64F\n.           src.depth() = CV_64F, ddepth = -1/CV_64F\n.   \n.   when ddepth=-1, the output image will have the same depth as the source)\n.   @param kernelX Coefficients for filtering each row.\n.   @param kernelY Coefficients for filtering each column.\n.   @param anchor Anchor position within the kernel. The default value \\f$(-1,-1)\\f$ means that the anchor\n.   is at the kernel center.\n.   @param delta Value added to the filtered results before storing them.\n.   @param borderType Pixel extrapolation method, see cv::BorderTypes\n.   @param borderValue border value in case of constant border type\n.   @sa  boxFilter, gaussianBlur, medianBlur"},
    {"split3", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_split3, 0), "split3(src) -> retval\n.   @brief Divides a 3-channel matrix into 3 single-channel matrices.\n.   \n.   The function splits a 3-channel matrix into 3 single-channel matrices:\n.   \\f[\\texttt{mv} [c](I) =  \\texttt{src} (I)_c\\f]\n.   \n.   All output matrices must be of @ref CV_8UC1 type.\n.   \n.   The function merge3 does the reverse operation.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.transform.split3\"\n.   \n.   @param src input @ref CV_8UC3 matrix.\n.   @sa split4, merge3, merge4"},
    {"split4", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_split4, 0), "split4(src) -> retval\n.   @brief Divides a 4-channel matrix into 4 single-channel matrices.\n.   \n.   The function splits a 4-channel matrix into 4 single-channel matrices:\n.   \\f[\\texttt{mv} [c](I) =  \\texttt{src} (I)_c\\f]\n.   \n.   All output matrices must be of @ref CV_8UC1 type.\n.   \n.   The function merge4 does the reverse operation.\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.transform.split4\"\n.   \n.   @param src input @ref CV_8UC4 matrix.\n.   @sa split3, merge3, merge4"},
    {"sqrt", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_sqrt, 0), "sqrt(src) -> retval\n.   @brief Calculates a square root of array elements.\n.   \n.   The function cv::gapi::sqrt calculates a square root of each input array element.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. The accuracy is approximately the same as of the built-in\n.   std::sqrt .\n.   @param src input floating-point array.\n.   @return output array of the same size and type as src."},
    {"sub", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_sub, 0), "sub(src1, src2[, ddepth]) -> retval\n.   @brief Calculates the per-element difference between two matrices.\n.   \n.   The function sub calculates difference between two matrices, when both matrices have the same size and the same number of\n.   channels:\n.       \\f[\\texttt{dst}(I) =   \\texttt{src1}(I) -  \\texttt{src2}(I)\\f]\n.   \n.   The function can be replaced with matrix expressions:\n.   \\f[\\texttt{dst} =   \\texttt{src1} -  \\texttt{src2}\\f]\n.   \n.   The input matrices and the output matrix can all have the same or different depths. For example, you\n.   can subtract two 8-bit unsigned matrices store the result as a 16-bit signed matrix.\n.   Depth of the output matrix is determined by the ddepth parameter.\n.   If src1.depth() == src2.depth(), ddepth can be set to the default -1. In this case, the output matrix will have\n.   the same depth as the input matrices. The matrices can be single or multi channel.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.sub\"\n.   @param src1 first input matrix.\n.   @param src2 second input matrix.\n.   @param ddepth optional depth of the output matrix.\n.   @sa  add, addC"},
    {"subC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_subC, 0), "subC(src, c[, ddepth]) -> retval\n.   @brief Calculates the per-element difference between matrix and given scalar.\n.   \n.   The function can be replaced with matrix expressions:\n.       \\f[\\texttt{dst} =  \\texttt{src} - \\texttt{c}\\f]\n.   \n.   Depth of the output matrix is determined by the ddepth parameter.\n.   If ddepth is set to default -1, the depth of output matrix will be the same as the depth of input matrix.\n.   The matrices can be single or multi channel. Output matrix must have the same size as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.subC\"\n.   @param src first input matrix.\n.   @param c scalar value to subtracted.\n.   @param ddepth optional depth of the output matrix.\n.   @sa  add, addC, subRC"},
    {"subRC", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_subRC, 0), "subRC(c, src[, ddepth]) -> retval\n.   @brief Calculates the per-element difference between given scalar and the matrix.\n.   \n.   The function can be replaced with matrix expressions:\n.       \\f[\\texttt{dst} =  \\texttt{c} - \\texttt{src}\\f]\n.   \n.   Depth of the output matrix is determined by the ddepth parameter.\n.   If ddepth is set to default -1, the depth of output matrix will be the same as the depth of input matrix.\n.   The matrices can be single or multi channel. Output matrix must have the same size as src.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.math.subRC\"\n.   @param c scalar value to subtract from.\n.   @param src input matrix to be subtracted.\n.   @param ddepth optional depth of the output matrix.\n.   @sa  add, addC, subC"},
    {"sum", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_sum, 0), "sum(src) -> retval\n.   @brief Calculates sum of all matrix elements.\n.   \n.   The function sum calculates sum of all matrix elements, independently for each channel.\n.   \n.   Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.sum\"\n.   @param src input matrix.\n.   @sa countNonZero, mean, min, max"},
    {"threshold", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_threshold, 0), "threshold(src, thresh, maxval, type) -> retval\n.   @brief Applies a fixed-level threshold to each matrix element.\n.   \n.   The function applies fixed-level thresholding to a single- or multiple-channel matrix.\n.   The function is typically used to get a bi-level (binary) image out of a grayscale image ( cmp functions could be also used for\n.   this purpose) or for removing a noise, that is, filtering out pixels with too small or too large\n.   values. There are several types of thresholding supported by the function. They are determined by\n.   type parameter.\n.   \n.   Also, the special values cv::THRESH_OTSU or cv::THRESH_TRIANGLE may be combined with one of the\n.   above values. In these cases, the function determines the optimal threshold value using the Otsu's\n.   or Triangle algorithm and uses it instead of the specified thresh . The function returns the\n.   computed threshold value in addititon to thresholded matrix.\n.   The Otsu's and Triangle methods are implemented only for 8-bit matrices.\n.   \n.   Input image should be single channel only in case of cv::THRESH_OTSU or cv::THRESH_TRIANGLE flags.\n.   Output matrix must be of the same size and depth as src.\n.   \n.   @note Function textual ID is \"org.opencv.core.matrixop.threshold\"\n.   \n.   @param src input matrix (@ref CV_8UC1, @ref CV_8UC3, or @ref CV_32FC1).\n.   @param thresh threshold value.\n.   @param maxval maximum value to use with the cv::THRESH_BINARY and cv::THRESH_BINARY_INV thresholding\n.   types.\n.   @param type thresholding type (see the cv::ThresholdTypes).\n.   \n.   @sa min, max, cmpGT, cmpLE, cmpGE, cmpLT\n\n\n\nthreshold(src, maxval, type) -> retval\n.   @overload\n.   This function applicable for all threshold types except cv::THRESH_OTSU and cv::THRESH_TRIANGLE\n.   @note Function textual ID is \"org.opencv.core.matrixop.thresholdOT\""},
    {"transpose", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_transpose, 0), "transpose(src) -> retval\n.   @brief Transposes a matrix.\n.   \n.   The function transposes the matrix:\n.   \\f[\\texttt{dst} (i,j) =  \\texttt{src} (j,i)\\f]\n.   \n.   @note\n.    - Function textual ID is \"org.opencv.core.transpose\"\n.    - No complex conjugation is done in case of a complex matrix. It should be done separately if needed.\n.   \n.   @param src input array."},
    {"warpAffine", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_warpAffine, 0), "warpAffine(src, M, dsize[, flags[, borderMode[, borderValue]]]) -> retval\n.   @brief Applies an affine transformation to an image.\n.   \n.   The function warpAffine transforms the source image using the specified matrix:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} ( \\texttt{M} _{11} x +  \\texttt{M} _{12} y +  \\texttt{M} _{13}, \\texttt{M} _{21} x +  \\texttt{M} _{22} y +  \\texttt{M} _{23})\\f]\n.   \n.   when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted\n.   with #invertAffineTransform and then put in the formula above instead of M. The function cannot\n.   operate in-place.\n.   \n.   @param src input image.\n.   @param M \\f$2\\times 3\\f$ transformation matrix.\n.   @param dsize size of the output image.\n.   @param flags combination of interpolation methods (see #InterpolationFlags) and the optional\n.   flag #WARP_INVERSE_MAP that means that M is the inverse transformation (\n.   \\f$\\texttt{dst}\\rightarrow\\texttt{src}\\f$ ).\n.   @param borderMode pixel extrapolation method (see #BorderTypes);\n.   borderMode=#BORDER_TRANSPARENT isn't supported\n.   @param borderValue value used in case of a constant border; by default, it is 0.\n.   \n.   @sa  warpPerspective, resize, remap, getRectSubPix, transform"},
    {"warpPerspective", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_warpPerspective, 0), "warpPerspective(src, M, dsize[, flags[, borderMode[, borderValue]]]) -> retval\n.   @brief Applies a perspective transformation to an image.\n.   \n.   The function warpPerspective transforms the source image using the specified matrix:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} \\left ( \\frac{M_{11} x + M_{12} y + M_{13}}{M_{31} x + M_{32} y + M_{33}} ,\n.        \\frac{M_{21} x + M_{22} y + M_{23}}{M_{31} x + M_{32} y + M_{33}} \\right )\\f]\n.   \n.   when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted with invert\n.   and then put in the formula above instead of M. The function cannot operate in-place.\n.   \n.   @param src input image.\n.   @param M \\f$3\\times 3\\f$ transformation matrix.\n.   @param dsize size of the output image.\n.   @param flags combination of interpolation methods (#INTER_LINEAR or #INTER_NEAREST) and the\n.   optional flag #WARP_INVERSE_MAP, that sets M as the inverse transformation (\n.   \\f$\\texttt{dst}\\rightarrow\\texttt{src}\\f$ ).\n.   @param borderMode pixel extrapolation method (#BORDER_CONSTANT or #BORDER_REPLICATE).\n.   @param borderValue value used in case of a constant border; by default, it equals 0.\n.   \n.   @sa  warpAffine, resize, remap, getRectSubPix, perspectiveTransform"},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI
    PYOPENCV_EXTRA_METHODS_GAPI
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi[] = {
    {"CV_ANY", static_cast<long>(cv::gapi::CV_ANY)},
    {"CV_BOOL", static_cast<long>(cv::gapi::CV_BOOL)},
    {"CV_DOUBLE", static_cast<long>(cv::gapi::CV_DOUBLE)},
    {"CV_DRAW_PRIM", static_cast<long>(cv::gapi::CV_DRAW_PRIM)},
    {"CV_FLOAT", static_cast<long>(cv::gapi::CV_FLOAT)},
    {"CV_GMAT", static_cast<long>(cv::gapi::CV_GMAT)},
    {"CV_INT", static_cast<long>(cv::gapi::CV_INT)},
    {"CV_INT64", static_cast<long>(cv::gapi::CV_INT64)},
    {"CV_MAT", static_cast<long>(cv::gapi::CV_MAT)},
    {"CV_POINT", static_cast<long>(cv::gapi::CV_POINT)},
    {"CV_POINT2F", static_cast<long>(cv::gapi::CV_POINT2F)},
    {"CV_POINT3F", static_cast<long>(cv::gapi::CV_POINT3F)},
    {"CV_RECT", static_cast<long>(cv::gapi::CV_RECT)},
    {"CV_SCALAR", static_cast<long>(cv::gapi::CV_SCALAR)},
    {"CV_SIZE", static_cast<long>(cv::gapi::CV_SIZE)},
    {"CV_STRING", static_cast<long>(cv::gapi::CV_STRING)},
    {"CV_UINT64", static_cast<long>(cv::gapi::CV_UINT64)},
    {"StereoOutputFormat_DEPTH_16F", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_16F)},
    {"STEREO_OUTPUT_FORMAT_DEPTH_16F", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_16F)},
    {"StereoOutputFormat_DEPTH_32F", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_32F)},
    {"STEREO_OUTPUT_FORMAT_DEPTH_32F", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_32F)},
    {"StereoOutputFormat_DEPTH_FLOAT16", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_FLOAT16)},
    {"STEREO_OUTPUT_FORMAT_DEPTH_FLOAT16", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_FLOAT16)},
    {"StereoOutputFormat_DEPTH_FLOAT32", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_FLOAT32)},
    {"STEREO_OUTPUT_FORMAT_DEPTH_FLOAT32", static_cast<long>(cv::gapi::StereoOutputFormat::DEPTH_FLOAT32)},
    {"StereoOutputFormat_DISPARITY_16Q_10_5", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_16Q_10_5)},
    {"STEREO_OUTPUT_FORMAT_DISPARITY_16Q_10_5", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_16Q_10_5)},
    {"StereoOutputFormat_DISPARITY_16Q_11_4", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_16Q_11_4)},
    {"STEREO_OUTPUT_FORMAT_DISPARITY_16Q_11_4", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_16Q_11_4)},
    {"StereoOutputFormat_DISPARITY_FIXED16_11_5", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_FIXED16_11_5)},
    {"STEREO_OUTPUT_FORMAT_DISPARITY_FIXED16_11_5", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_FIXED16_11_5)},
    {"StereoOutputFormat_DISPARITY_FIXED16_12_4", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_FIXED16_12_4)},
    {"STEREO_OUTPUT_FORMAT_DISPARITY_FIXED16_12_4", static_cast<long>(cv::gapi::StereoOutputFormat::DISPARITY_FIXED16_12_4)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI
    PYOPENCV_EXTRA_CONSTANTS_GAPI
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_core_cpu[] = {
    {"kernels", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_core_cpu_kernels, 0), "kernels() -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_CORE_CPU
    PYOPENCV_EXTRA_METHODS_GAPI_CORE_CPU
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_core_cpu[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_CORE_CPU
    PYOPENCV_EXTRA_CONSTANTS_GAPI_CORE_CPU
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_core_fluid[] = {
    {"kernels", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_core_fluid_kernels, 0), "kernels() -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_CORE_FLUID
    PYOPENCV_EXTRA_METHODS_GAPI_CORE_FLUID
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_core_fluid[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_CORE_FLUID
    PYOPENCV_EXTRA_CONSTANTS_GAPI_CORE_FLUID
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_core_ocl[] = {
    {"kernels", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_core_ocl_kernels, 0), "kernels() -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_CORE_OCL
    PYOPENCV_EXTRA_METHODS_GAPI_CORE_OCL
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_core_ocl[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_CORE_OCL
    PYOPENCV_EXTRA_CONSTANTS_GAPI_CORE_OCL
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_ie[] = {
    {"params", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_ie_params, 0), "params(tag, model, weights, device) -> retval\n.   \n\n\n\nparams(tag, model, device) -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_IE
    PYOPENCV_EXTRA_METHODS_GAPI_IE
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_ie[] = {
    {"Async", static_cast<long>(cv::gapi::ie::Async)},
    {"ASYNC", static_cast<long>(cv::gapi::ie::Async)},
    {"Sync", static_cast<long>(cv::gapi::ie::Sync)},
    {"SYNC", static_cast<long>(cv::gapi::ie::Sync)},
    {"TraitAs_IMAGE", static_cast<long>(cv::gapi::ie::TraitAs::IMAGE)},
    {"TRAIT_AS_IMAGE", static_cast<long>(cv::gapi::ie::TraitAs::IMAGE)},
    {"TraitAs_TENSOR", static_cast<long>(cv::gapi::ie::TraitAs::TENSOR)},
    {"TRAIT_AS_TENSOR", static_cast<long>(cv::gapi::ie::TraitAs::TENSOR)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_IE
    PYOPENCV_EXTRA_CONSTANTS_GAPI_IE
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_ie_detail[] = {
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_IE_DETAIL
    PYOPENCV_EXTRA_METHODS_GAPI_IE_DETAIL
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_ie_detail[] = {
    {"ParamDesc_Kind_Import", static_cast<long>(cv::gapi::ie::detail::ParamDesc::Kind::Import)},
    {"PARAM_DESC_KIND_IMPORT", static_cast<long>(cv::gapi::ie::detail::ParamDesc::Kind::Import)},
    {"ParamDesc_Kind_Load", static_cast<long>(cv::gapi::ie::detail::ParamDesc::Kind::Load)},
    {"PARAM_DESC_KIND_LOAD", static_cast<long>(cv::gapi::ie::detail::ParamDesc::Kind::Load)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_IE_DETAIL
    PYOPENCV_EXTRA_CONSTANTS_GAPI_IE_DETAIL
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_imgproc_fluid[] = {
    {"kernels", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_imgproc_fluid_kernels, 0), "kernels() -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_IMGPROC_FLUID
    PYOPENCV_EXTRA_METHODS_GAPI_IMGPROC_FLUID
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_imgproc_fluid[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_IMGPROC_FLUID
    PYOPENCV_EXTRA_CONSTANTS_GAPI_IMGPROC_FLUID
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_oak[] = {
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_OAK
    PYOPENCV_EXTRA_METHODS_GAPI_OAK
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_oak[] = {
    {"ColorCameraParams_BoardSocket_BGR", static_cast<long>(cv::gapi::oak::ColorCameraParams::BoardSocket::BGR)},
    {"COLOR_CAMERA_PARAMS_BOARD_SOCKET_BGR", static_cast<long>(cv::gapi::oak::ColorCameraParams::BoardSocket::BGR)},
    {"ColorCameraParams_BoardSocket_RGB", static_cast<long>(cv::gapi::oak::ColorCameraParams::BoardSocket::RGB)},
    {"COLOR_CAMERA_PARAMS_BOARD_SOCKET_RGB", static_cast<long>(cv::gapi::oak::ColorCameraParams::BoardSocket::RGB)},
    {"ColorCameraParams_Resolution_THE_1080_P", static_cast<long>(cv::gapi::oak::ColorCameraParams::Resolution::THE_1080_P)},
    {"COLOR_CAMERA_PARAMS_RESOLUTION_THE_1080_P", static_cast<long>(cv::gapi::oak::ColorCameraParams::Resolution::THE_1080_P)},
    {"EncoderConfig_Profile_H264_BASELINE", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H264_BASELINE)},
    {"ENCODER_CONFIG_PROFILE_H264_BASELINE", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H264_BASELINE)},
    {"EncoderConfig_Profile_H264_HIGH", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H264_HIGH)},
    {"ENCODER_CONFIG_PROFILE_H264_HIGH", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H264_HIGH)},
    {"EncoderConfig_Profile_H264_MAIN", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H264_MAIN)},
    {"ENCODER_CONFIG_PROFILE_H264_MAIN", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H264_MAIN)},
    {"EncoderConfig_Profile_H265_MAIN", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H265_MAIN)},
    {"ENCODER_CONFIG_PROFILE_H265_MAIN", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::H265_MAIN)},
    {"EncoderConfig_Profile_MJPEG", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::MJPEG)},
    {"ENCODER_CONFIG_PROFILE_MJPEG", static_cast<long>(cv::gapi::oak::EncoderConfig::Profile::MJPEG)},
    {"EncoderConfig_RateControlMode_CBR", static_cast<long>(cv::gapi::oak::EncoderConfig::RateControlMode::CBR)},
    {"ENCODER_CONFIG_RATE_CONTROL_MODE_CBR", static_cast<long>(cv::gapi::oak::EncoderConfig::RateControlMode::CBR)},
    {"EncoderConfig_RateControlMode_VBR", static_cast<long>(cv::gapi::oak::EncoderConfig::RateControlMode::VBR)},
    {"ENCODER_CONFIG_RATE_CONTROL_MODE_VBR", static_cast<long>(cv::gapi::oak::EncoderConfig::RateControlMode::VBR)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_OAK
    PYOPENCV_EXTRA_CONSTANTS_GAPI_OAK
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_onnx[] = {
    {"params", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_onnx_params, 0), "params(tag, model_path) -> retval\n."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_ONNX
    PYOPENCV_EXTRA_METHODS_GAPI_ONNX
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_onnx[] = {
    {"TraitAs_IMAGE", static_cast<long>(cv::gapi::onnx::TraitAs::IMAGE)},
    {"TRAIT_AS_IMAGE", static_cast<long>(cv::gapi::onnx::TraitAs::IMAGE)},
    {"TraitAs_TENSOR", static_cast<long>(cv::gapi::onnx::TraitAs::TENSOR)},
    {"TRAIT_AS_TENSOR", static_cast<long>(cv::gapi::onnx::TraitAs::TENSOR)},
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_ONNX
    PYOPENCV_EXTRA_CONSTANTS_GAPI_ONNX
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_onnx_ep[] = {
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_ONNX_EP
    PYOPENCV_EXTRA_METHODS_GAPI_ONNX_EP
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_onnx_ep[] = {
#ifdef PYOPENCV_EXTRA_CONSTANTS_GAPI_ONNX_EP
    PYOPENCV_EXTRA_CONSTANTS_GAPI_ONNX_EP
#endif
    {NULL, 0}
};

static PyMethodDef methods_gapi_ot[] = {
    {"track", CV_PY_FN_WITH_KW_(pyopencv_cv_gapi_ot_track, 0), "track(mat, detected_rects, detected_class_labels, delta) -> retval\n.   * @brief   Tracks objects with video frames.\n.    *          If a detected object is overlapped enough with one of tracked object, the tracked object's\n.    *          informationis updated with the input detected object.\n.    *          On the other hand, if a detected object is overlapped with none of tracked objects,\n.    *          the detected object is newly added and ObjectTracker starts to track the object.\n.    *          In zero term tracking type, ObjectTracker clears tracked objects in case that empty\n.    *          list of detected objects is passed in.\n.    *\n.    * @param mat                       Input frame.\n.    * @param detected_rects            Detected objects rectangles in the input frame.\n.    * @param detected_class_labels     Detected objects class labels in the input frame.\n.    * @param delta                     Frame_delta_t Delta time between two consecutive tracking in seconds.\n.    *                                  The valid range is [0.005 ~ 0.5].\n.    * @return                          Tracking results of target objects.\n.    *                                  cv::GArray<cv::Rect>  Array of rectangles for tracked objects.\n.    *                                  cv::GArray<int32_t>   Array of detected objects labels.\n.    *                                  cv::GArray<uint64_t>  Array of tracking IDs for objects.\n.    *                                                        Numbering sequence starts from 1.\n.    *                                                        The value 0 means the tracking ID of this object has\n.    *                                                        not been assigned.\n.    *                                  cv::GArray<int>       Array of tracking statuses for objects.\n\n\n\ntrack(frame, detected_rects, detected_class_labels, delta) -> retval\n.   @overload\n.    * @brief   Tracks objects with video frames. Overload of track(...) for frame as GFrame.\n.    *\n.    * @param frame                     Input frame.\n.    * @param detected_rects            Detected objects rectangles in the input frame.\n.    * @param detected_class_labels     Detected objects class labels in the input frame.\n.    * @param delta                     Frame_delta_t Delta time between two consecutive tracking in seconds.\n.    *                                  The valid range is [0.005 ~ 0.5].\n.    * @return                          Tracking results of target objects.\n.    * @return                          Tracking results of target objects.\n.    *                                  cv::GArray<cv::Rect>          Array of rectangles for tracked objects.\n.    *                                  cv::GArray<int32_t>           Array of detected objects labels.\n.    *                                  cv::GArray<uint64_t>          Array of tracking IDs for objects.\n.    *                                                                Numbering sequence starts from 1.\n.    *                                                                The value 0 means the tracking ID of this object has\n.    *                                                                not been assigned.\n.    *                                  cv::GArray<int>    Array of tracking statuses for objects."},
#ifdef PYOPENCV_EXTRA_METHODS_GAPI_OT
    PYOPENCV_EXTRA_METHODS_GAPI_OT
#endif
    {NULL, NULL}
};

static ConstDef consts_gapi_ot[] = {
    {"LOST", static_cast<long>(cv::gapi::ot::LOST)},
    {"NEW", static_cast<long>(cv::gapi::ot::NEW)},
    {"TRACKED", static_cast