// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#pragma once

#include "core/providers/rocm/rocm_kernel.h"
#include "contrib_ops/cpu/crop.h"

namespace onnxruntime {
namespace contrib {
namespace rocm {

using namespace onnxruntime::rocm;

template <typename T>
class Crop final : public contrib::CropBase, public RocmKernel {
 public:
  Crop(const OpKernelInfo& info) : contrib::CropBase(info), RocmKernel(info) {
  }

  Status ComputeInternal(OpKernelContext* context) const override;
};

}  // namespace rocm
}  // namespace contrib
}  // namespace onnxruntime
