// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: alertmanager.proto

package alertmanagerpb

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	httpgrpc "github.com/grafana/dskit/httpgrpc"
	clusterpb "github.com/prometheus/alertmanager/cluster/clusterpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type UpdateStateStatus int32

const (
	OK             UpdateStateStatus = 0
	MERGE_ERROR    UpdateStateStatus = 2
	USER_NOT_FOUND UpdateStateStatus = 3
)

var UpdateStateStatus_name = map[int32]string{
	0: "OK",
	2: "MERGE_ERROR",
	3: "USER_NOT_FOUND",
}

var UpdateStateStatus_value = map[string]int32{
	"OK":             0,
	"MERGE_ERROR":    2,
	"USER_NOT_FOUND": 3,
}

func (UpdateStateStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e60437b6e0c74c9a, []int{0}
}

type ReadStateStatus int32

const (
	READ_UNSPECIFIED    ReadStateStatus = 0
	READ_OK             ReadStateStatus = 1
	READ_ERROR          ReadStateStatus = 2
	READ_USER_NOT_FOUND ReadStateStatus = 3
)

var ReadStateStatus_name = map[int32]string{
	0: "READ_UNSPECIFIED",
	1: "READ_OK",
	2: "READ_ERROR",
	3: "READ_USER_NOT_FOUND",
}

var ReadStateStatus_value = map[string]int32{
	"READ_UNSPECIFIED":    0,
	"READ_OK":             1,
	"READ_ERROR":          2,
	"READ_USER_NOT_FOUND": 3,
}

func (ReadStateStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e60437b6e0c74c9a, []int{1}
}

type UpdateStateResponse struct {
	Status UpdateStateStatus `protobuf:"varint,1,opt,name=status,proto3,enum=alertmanagerpb.UpdateStateStatus" json:"status,omitempty"`
	Error  string            `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (m *UpdateStateResponse) Reset()      { *m = UpdateStateResponse{} }
func (*UpdateStateResponse) ProtoMessage() {}
func (*UpdateStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e60437b6e0c74c9a, []int{0}
}
func (m *UpdateStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateStateResponse.Merge(m, src)
}
func (m *UpdateStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateStateResponse proto.InternalMessageInfo

func (m *UpdateStateResponse) GetStatus() UpdateStateStatus {
	if m != nil {
		return m.Status
	}
	return OK
}

func (m *UpdateStateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type ReadStateRequest struct {
}

func (m *ReadStateRequest) Reset()      { *m = ReadStateRequest{} }
func (*ReadStateRequest) ProtoMessage() {}
func (*ReadStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e60437b6e0c74c9a, []int{1}
}
func (m *ReadStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadStateRequest.Merge(m, src)
}
func (m *ReadStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReadStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadStateRequest proto.InternalMessageInfo

type ReadStateResponse struct {
	Status ReadStateStatus      `protobuf:"varint,1,opt,name=status,proto3,enum=alertmanagerpb.ReadStateStatus" json:"status,omitempty"`
	Error  string               `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	State  *clusterpb.FullState `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
}

func (m *ReadStateResponse) Reset()      { *m = ReadStateResponse{} }
func (*ReadStateResponse) ProtoMessage() {}
func (*ReadStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e60437b6e0c74c9a, []int{2}
}
func (m *ReadStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadStateResponse.Merge(m, src)
}
func (m *ReadStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReadStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadStateResponse proto.InternalMessageInfo

func (m *ReadStateResponse) GetStatus() ReadStateStatus {
	if m != nil {
		return m.Status
	}
	return READ_UNSPECIFIED
}

func (m *ReadStateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *ReadStateResponse) GetState() *clusterpb.FullState {
	if m != nil {
		return m.State
	}
	return nil
}

func init() {
	proto.RegisterEnum("alertmanagerpb.UpdateStateStatus", UpdateStateStatus_name, UpdateStateStatus_value)
	proto.RegisterEnum("alertmanagerpb.ReadStateStatus", ReadStateStatus_name, ReadStateStatus_value)
	proto.RegisterType((*UpdateStateResponse)(nil), "alertmanagerpb.UpdateStateResponse")
	proto.RegisterType((*ReadStateRequest)(nil), "alertmanagerpb.ReadStateRequest")
	proto.RegisterType((*ReadStateResponse)(nil), "alertmanagerpb.ReadStateResponse")
}

func init() { proto.RegisterFile("alertmanager.proto", fileDescriptor_e60437b6e0c74c9a) }

var fileDescriptor_e60437b6e0c74c9a = []byte{
	// 504 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x4f, 0x6f, 0x12, 0x41,
	0x1c, 0x9d, 0x69, 0x2d, 0xa6, 0x3f, 0x14, 0xb6, 0x53, 0x54, 0xc2, 0x61, 0x4a, 0xf1, 0x42, 0x38,
	0xec, 0x1a, 0x3c, 0x18, 0x3d, 0xb5, 0x95, 0xc5, 0x36, 0x8d, 0x40, 0x06, 0xb8, 0x98, 0x18, 0x32,
	0xc0, 0x74, 0x69, 0x04, 0x76, 0x9d, 0x9d, 0xbd, 0xfb, 0x11, 0x3c, 0xf8, 0x01, 0x3c, 0xfa, 0x51,
	0x3c, 0x72, 0xec, 0x51, 0x96, 0x4b, 0x13, 0x2f, 0xfd, 0x08, 0xa6, 0xfb, 0xcf, 0x75, 0x8d, 0x8d,
	0xa7, 0xfd, 0xcd, 0xdb, 0xdf, 0x7b, 0x6f, 0x7e, 0x6f, 0x66, 0x80, 0xf0, 0xb9, 0x90, 0x6a, 0xc1,
	0x97, 0xdc, 0x12, 0x52, 0x77, 0xa4, 0xad, 0x6c, 0x52, 0x48, 0x63, 0xce, 0xb8, 0xf2, 0xcc, 0xba,
	0x54, 0x33, 0x6f, 0xac, 0x4f, 0xec, 0x85, 0x61, 0x49, 0x7e, 0xc1, 0x97, 0xdc, 0x98, 0xba, 0x1f,
	0x2e, 0x95, 0x31, 0x53, 0xca, 0xb1, 0xa4, 0x33, 0x49, 0x8a, 0x50, 0xa1, 0x72, 0x92, 0x62, 0x38,
	0xd2, 0x5e, 0x08, 0x35, 0x13, 0x9e, 0x6b, 0xa4, 0x75, 0x8d, 0xc9, 0xdc, 0x73, 0xd5, 0xef, 0xaf,
	0x33, 0x8e, 0xab, 0x48, 0xa3, 0x64, 0xd9, 0x96, 0x1d, 0x94, 0xc6, 0x6d, 0x15, 0xa2, 0xb5, 0x0b,
	0xd8, 0x1f, 0x3a, 0x53, 0xae, 0x44, 0x5f, 0x71, 0x25, 0x98, 0x70, 0x1d, 0x7b, 0xe9, 0x0a, 0xf2,
	0x12, 0x72, 0xae, 0xe2, 0xca, 0x73, 0xcb, 0xb8, 0x8a, 0xeb, 0x85, 0xe6, 0xa1, 0xfe, 0xe7, 0x0c,
	0x7a, 0x8a, 0xd4, 0x0f, 0x1a, 0x59, 0x44, 0x20, 0x25, 0xd8, 0x11, 0x52, 0xda, 0xb2, 0xbc, 0x55,
	0xc5, 0xf5, 0x5d, 0x16, 0x2e, 0x6a, 0x04, 0x34, 0x26, 0xf8, 0x34, 0x72, 0xf9, 0xe8, 0x09, 0x57,
	0xd5, 0xbe, 0x60, 0xd8, 0x4b, 0x81, 0x91, 0xf5, 0x8b, 0x8c, 0xf5, 0x41, 0xd6, 0x3a, 0xa1, 0xfc,
	0x8f, 0x31, 0x69, 0xc0, 0xce, 0xed, 0x7f, 0x51, 0xde, 0xae, 0xe2, 0x7a, 0xbe, 0x59, 0xd2, 0x93,
	0x7c, 0xf4, 0xb6, 0x37, 0x9f, 0x87, 0xde, 0x61, 0xcb, 0xab, 0x7b, 0xd7, 0x5f, 0x0f, 0x50, 0xe3,
	0x08, 0xf6, 0xfe, 0x9a, 0x8e, 0xe4, 0x60, 0xab, 0x7b, 0xae, 0x21, 0x52, 0x84, 0xfc, 0x5b, 0x93,
	0xbd, 0x31, 0x47, 0x26, 0x63, 0x5d, 0xa6, 0x6d, 0x11, 0x02, 0x85, 0x61, 0xdf, 0x64, 0xa3, 0x4e,
	0x77, 0x30, 0x6a, 0x77, 0x87, 0x9d, 0x96, 0xb6, 0xdd, 0x78, 0x0f, 0xc5, 0xcc, 0x26, 0x49, 0x09,
	0x34, 0x66, 0x1e, 0xb7, 0x46, 0xc3, 0x4e, 0xbf, 0x67, 0xbe, 0x3e, 0x6b, 0x9f, 0x99, 0x2d, 0x0d,
	0x91, 0x3c, 0xdc, 0x0f, 0xd0, 0xee, 0xb9, 0x86, 0x49, 0x01, 0x20, 0x58, 0xc4, 0xca, 0x4f, 0x60,
	0x3f, 0xa4, 0x64, 0xe4, 0x9b, 0x3f, 0x31, 0x3c, 0x38, 0x4e, 0x65, 0x42, 0x8e, 0xe0, 0xe1, 0x29,
	0x5f, 0x4e, 0xe7, 0x71, 0xb2, 0xe4, 0x91, 0x9e, 0x5c, 0xa0, 0xd3, 0xc1, 0xa0, 0x17, 0xc1, 0x95,
	0xc7, 0x59, 0x38, 0x8c, 0xbc, 0x86, 0x88, 0x09, 0xf9, 0xd4, 0xcc, 0xa4, 0x98, 0x4a, 0xa9, 0xc7,
	0xa5, 0xaa, 0x3c, 0xbd, 0xe3, 0xfc, 0x53, 0x32, 0x0c, 0x76, 0x93, 0xc1, 0x49, 0xf5, 0x9f, 0x07,
	0x17, 0xef, 0xe7, 0xf0, 0x8e, 0x8e, 0x58, 0xf3, 0xa4, 0xb5, 0x5a, 0x53, 0x74, 0xb5, 0xa6, 0xe8,
	0x66, 0x4d, 0xf1, 0x27, 0x9f, 0xe2, 0x6f, 0x3e, 0xc5, 0xdf, 0x7d, 0x8a, 0x57, 0x3e, 0xc5, 0x3f,
	0x7c, 0x8a, 0xaf, 0x7d, 0x8a, 0x6e, 0x7c, 0x8a, 0x3f, 0x6f, 0x28, 0x5a, 0x6d, 0x28, 0xba, 0xda,
	0x50, 0xf4, 0x2e, 0xf3, 0xe6, 0xc6, 0xb9, 0xe0, 0xba, 0x3f, 0xff, 0x15, 0x00, 0x00, 0xff, 0xff,
	0xdd, 0xcf, 0x08, 0xd5, 0xa0, 0x03, 0x00, 0x00,
}

func (x UpdateStateStatus) String() string {
	s, ok := UpdateStateStatus_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ReadStateStatus) String() string {
	s, ok := ReadStateStatus_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *UpdateStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpdateStateResponse)
	if !ok {
		that2, ok := that.(UpdateStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Error != that1.Error {
		return false
	}
	return true
}
func (this *ReadStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReadStateRequest)
	if !ok {
		that2, ok := that.(ReadStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *UpdateStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&alertmanagerpb.UpdateStateResponse{")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReadStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&alertmanagerpb.ReadStateRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReadStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&alertmanagerpb.ReadStateResponse{")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	if this.State != nil {
		s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringAlertmanager(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AlertmanagerClient is the client API for Alertmanager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AlertmanagerClient interface {
	HandleRequest(ctx context.Context, in *httpgrpc.HTTPRequest, opts ...grpc.CallOption) (*httpgrpc.HTTPResponse, error)
	UpdateState(ctx context.Context, in *clusterpb.Part, opts ...grpc.CallOption) (*UpdateStateResponse, error)
	ReadState(ctx context.Context, in *ReadStateRequest, opts ...grpc.CallOption) (*ReadStateResponse, error)
}

type alertmanagerClient struct {
	cc *grpc.ClientConn
}

func NewAlertmanagerClient(cc *grpc.ClientConn) AlertmanagerClient {
	return &alertmanagerClient{cc}
}

func (c *alertmanagerClient) HandleRequest(ctx context.Context, in *httpgrpc.HTTPRequest, opts ...grpc.CallOption) (*httpgrpc.HTTPResponse, error) {
	out := new(httpgrpc.HTTPResponse)
	err := c.cc.Invoke(ctx, "/alertmanagerpb.Alertmanager/HandleRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertmanagerClient) UpdateState(ctx context.Context, in *clusterpb.Part, opts ...grpc.CallOption) (*UpdateStateResponse, error) {
	out := new(UpdateStateResponse)
	err := c.cc.Invoke(ctx, "/alertmanagerpb.Alertmanager/UpdateState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertmanagerClient) ReadState(ctx context.Context, in *ReadStateRequest, opts ...grpc.CallOption) (*ReadStateResponse, error) {
	out := new(ReadStateResponse)
	err := c.cc.Invoke(ctx, "/alertmanagerpb.Alertmanager/ReadState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AlertmanagerServer is the server API for Alertmanager service.
type AlertmanagerServer interface {
	HandleRequest(context.Context, *httpgrpc.HTTPRequest) (*httpgrpc.HTTPResponse, error)
	UpdateState(context.Context, *clusterpb.Part) (*UpdateStateResponse, error)
	ReadState(context.Context, *ReadStateRequest) (*ReadStateResponse, error)
}

// UnimplementedAlertmanagerServer can be embedded to have forward compatible implementations.
type UnimplementedAlertmanagerServer struct {
}

func (*UnimplementedAlertmanagerServer) HandleRequest(ctx context.Context, req *httpgrpc.HTTPRequest) (*httpgrpc.HTTPResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleRequest not implemented")
}
func (*UnimplementedAlertmanagerServer) UpdateState(ctx context.Context, req *clusterpb.Part) (*UpdateStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateState not implemented")
}
func (*UnimplementedAlertmanagerServer) ReadState(ctx context.Context, req *ReadStateRequest) (*ReadStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadState not implemented")
}

func RegisterAlertmanagerServer(s *grpc.Server, srv AlertmanagerServer) {
	s.RegisterService(&_Alertmanager_serviceDesc, srv)
}

func _Alertmanager_HandleRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(httpgrpc.HTTPRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertmanagerServer).HandleRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/alertmanagerpb.Alertmanager/HandleRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertmanagerServer).HandleRequest(ctx, req.(*httpgrpc.HTTPRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Alertmanager_UpdateState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(clusterpb.Part)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertmanagerServer).UpdateState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/alertmanagerpb.Alertmanager/UpdateState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertmanagerServer).UpdateState(ctx, req.(*clusterpb.Part))
	}
	return interceptor(ctx, in, info, handler)
}

func _Alertmanager_ReadState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertmanagerServer).ReadState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/alertmanagerpb.Alertmanager/ReadState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertmanagerServer).ReadState(ctx, req.(*ReadStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Alertmanager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "alertmanagerpb.Alertmanager",
	HandlerType: (*AlertmanagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleRequest",
			Handler:    _Alertmanager_HandleRequest_Handler,
		},
		{
			MethodName: "UpdateState",
			Handler:    _Alertmanager_UpdateState_Handler,
		},
		{
			MethodName: "ReadState",
			Handler:    _Alertmanager_ReadState_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "alertmanager.proto",
}

func (m *UpdateStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintAlertmanager(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.Status != 0 {
		i = encodeVarintAlertmanager(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReadStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ReadStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.State != nil {
		{
			size, err := m.State.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlertmanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintAlertmanager(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.Status != 0 {
		i = encodeVarintAlertmanager(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintAlertmanager(dAtA []byte, offset int, v uint64) int {
	offset -= sovAlertmanager(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *UpdateStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovAlertmanager(uint64(m.Status))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovAlertmanager(uint64(l))
	}
	return n
}

func (m *ReadStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ReadStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovAlertmanager(uint64(m.Status))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovAlertmanager(uint64(l))
	}
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovAlertmanager(uint64(l))
	}
	return n
}

func sovAlertmanager(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAlertmanager(x uint64) (n int) {
	return sovAlertmanager(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *UpdateStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateStateResponse{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`Error:` + fmt.Sprintf("%v", this.Error) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReadStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReadStateRequest{`,
		`}`,
	}, "")
	return s
}
func (this *ReadStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReadStateResponse{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`Error:` + fmt.Sprintf("%v", this.Error) + `,`,
		`State:` + strings.Replace(fmt.Sprintf("%v", this.State), "FullState", "clusterpb.FullState", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAlertmanager(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *UpdateStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlertmanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= UpdateStateStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlertmanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlertmanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlertmanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlertmanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlertmanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAlertmanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlertmanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlertmanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= ReadStateStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlertmanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlertmanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlertmanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlertmanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.State == nil {
				m.State = &clusterpb.FullState{}
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlertmanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlertmanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAlertmanager(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAlertmanager
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAlertmanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAlertmanager
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAlertmanager
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAlertmanager
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAlertmanager        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAlertmanager          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAlertmanager = fmt.Errorf("proto: unexpected end of group")
)
