/* parsed class NVC96F */

#include "nvtypes.h"
#include "clc96f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc96f_MEM_OP_A {
    uint32_t tlb_invalidate_invalidation_size;
    uint32_t tlb_invalidate_inval_scope;
    uint32_t tlb_invalidate_sysmembar;
    uint32_t tlb_invalidate_target_addr_lo;
};

static inline void
__NVC96F_MEM_OP_A(uint32_t *val_out, struct nv_nvc96f_MEM_OP_A st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_invalidation_size < (1ULL << 6));
    val |= st.tlb_invalidate_invalidation_size << 0;
    
    assert(st.tlb_invalidate_inval_scope < (1ULL << 2));
    val |= st.tlb_invalidate_inval_scope << 6;
    
    assert(st.tlb_invalidate_sysmembar < (1ULL << 1));
    val |= st.tlb_invalidate_sysmembar << 11;
    
    assert(st.tlb_invalidate_target_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_target_addr_lo << 12;
    *val_out = val;
}

#define V_NVC96F_MEM_OP_A(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS = NVC96F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_EN = NVC96F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_DIS = NVC96F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS; \
    struct nv_nvc96f_MEM_OP_A __data = args; \
    __NVC96F_MEM_OP_A(&val, __data); \
}

#define VA_NVC96F_MEM_OP_A V_NVC96F_MEM_OP_A

#define P_NVC96F_MEM_OP_A(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS = NVC96F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_EN = NVC96F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_DIS = NVC96F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS; \
    uint32_t nvk_p_ret; \
    V_NVC96F_MEM_OP_A(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_MEM_OP_A, nvk_p_ret); \
} while(0)

struct nv_nvc96f_MEM_OP_B {
    uint32_t tlb_invalidate_target_addr_hi;
};

static inline void
__NVC96F_MEM_OP_B(uint32_t *val_out, struct nv_nvc96f_MEM_OP_B st)
{
    uint32_t val = 0;
    
    val |= st.tlb_invalidate_target_addr_hi;
    *val_out = val;
}

#define V_NVC96F_MEM_OP_B(val, args...) { \
    struct nv_nvc96f_MEM_OP_B __data = { .tlb_invalidate_target_addr_hi = (args) }; \
    __NVC96F_MEM_OP_B(&val, __data); \
}

#define VA_NVC96F_MEM_OP_B V_NVC96F_MEM_OP_B

#define P_NVC96F_MEM_OP_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC96F_MEM_OP_B(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_MEM_OP_B, nvk_p_ret); \
} while(0)

struct nv_nvc96f_MEM_OP_C {
    uint32_t tlb_invalidate_pdb;
    uint32_t tlb_invalidate_gpc;
    uint32_t tlb_invalidate_replay;
    uint32_t tlb_invalidate_ack_type;
    uint32_t tlb_invalidate_page_table_level;
    uint32_t tlb_invalidate_pdb_aperture;
    uint32_t tlb_invalidate_pdb_addr_lo;
};

static inline void
__NVC96F_MEM_OP_C(uint32_t *val_out, struct nv_nvc96f_MEM_OP_C st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_pdb < (1ULL << 1));
    val |= st.tlb_invalidate_pdb << 0;
    
    assert(st.tlb_invalidate_gpc < (1ULL << 1));
    val |= st.tlb_invalidate_gpc << 1;
    
    assert(st.tlb_invalidate_replay < (1ULL << 3));
    val |= st.tlb_invalidate_replay << 2;
    
    assert(st.tlb_invalidate_ack_type < (1ULL << 2));
    val |= st.tlb_invalidate_ack_type << 5;
    
    assert(st.tlb_invalidate_page_table_level < (1ULL << 3));
    val |= st.tlb_invalidate_page_table_level << 7;
    
    assert(st.tlb_invalidate_pdb_aperture < (1ULL << 2));
    val |= st.tlb_invalidate_pdb_aperture << 10;
    
    assert(st.tlb_invalidate_pdb_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_pdb_addr_lo << 12;
    *val_out = val;
}

#define V_NVC96F_MEM_OP_C(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVC96F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVC96F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_NONE = NVC96F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_NONE = NVC96F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_GLOBALLY = NVC96F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_VID_MEM = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT; \
    struct nv_nvc96f_MEM_OP_C __data = args; \
    __NVC96F_MEM_OP_C(&val, __data); \
}

#define VA_NVC96F_MEM_OP_C V_NVC96F_MEM_OP_C

#define P_NVC96F_MEM_OP_C(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVC96F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVC96F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_NONE = NVC96F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_NONE = NVC96F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_GLOBALLY = NVC96F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = NVC96F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_VID_MEM = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = NVC96F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT; \
    uint32_t nvk_p_ret; \
    V_NVC96F_MEM_OP_C(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_MEM_OP_C, nvk_p_ret); \
} while(0)

struct nv_nvc96f_MEM_OP_D {
    uint32_t tlb_invalidate_pdb_addr_hi;
    uint32_t operation;
};

static inline void
__NVC96F_MEM_OP_D(uint32_t *val_out, struct nv_nvc96f_MEM_OP_D st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_pdb_addr_hi < (1ULL << 27));
    val |= st.tlb_invalidate_pdb_addr_hi << 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 27;
    *val_out = val;
}

#define V_NVC96F_MEM_OP_D(val, args...) { \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVC96F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE_TARGETED = NVC96F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVC96F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_NCOH_INVALIDATE = NVC96F_MEM_OP_D_OPERATION_L2_SYSMEM_NCOH_INVALIDATE; \
    struct nv_nvc96f_MEM_OP_D __data = args; \
    __NVC96F_MEM_OP_D(&val, __data); \
}

#define VA_NVC96F_MEM_OP_D V_NVC96F_MEM_OP_D

#define P_NVC96F_MEM_OP_D(push, args...) do { \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVC96F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE_TARGETED = NVC96F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVC96F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_NCOH_INVALIDATE = NVC96F_MEM_OP_D_OPERATION_L2_SYSMEM_NCOH_INVALIDATE; \
    uint32_t nvk_p_ret; \
    V_NVC96F_MEM_OP_D(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_MEM_OP_D, nvk_p_ret); \
} while(0)

struct nv_nvc96f_SEM_ADDR_LO {
    uint32_t offset;
};

static inline void
__NVC96F_SEM_ADDR_LO(uint32_t *val_out, struct nv_nvc96f_SEM_ADDR_LO st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 30));
    val |= st.offset << 2;
    *val_out = val;
}

#define V_NVC96F_SEM_ADDR_LO(val, args...) { \
    struct nv_nvc96f_SEM_ADDR_LO __data = { .offset = (args) }; \
    __NVC96F_SEM_ADDR_LO(&val, __data); \
}

#define VA_NVC96F_SEM_ADDR_LO V_NVC96F_SEM_ADDR_LO

#define P_NVC96F_SEM_ADDR_LO(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC96F_SEM_ADDR_LO(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_SEM_ADDR_LO, nvk_p_ret); \
} while(0)

struct nv_nvc96f_SEM_ADDR_HI {
    uint32_t offset;
};

static inline void
__NVC96F_SEM_ADDR_HI(uint32_t *val_out, struct nv_nvc96f_SEM_ADDR_HI st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 25));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVC96F_SEM_ADDR_HI(val, args...) { \
    struct nv_nvc96f_SEM_ADDR_HI __data = { .offset = (args) }; \
    __NVC96F_SEM_ADDR_HI(&val, __data); \
}

#define VA_NVC96F_SEM_ADDR_HI V_NVC96F_SEM_ADDR_HI

#define P_NVC96F_SEM_ADDR_HI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC96F_SEM_ADDR_HI(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_SEM_ADDR_HI, nvk_p_ret); \
} while(0)

struct nv_nvc96f_SEM_EXECUTE {
    uint32_t operation;
    uint32_t release_wfi;
    uint32_t payload_size;
};

static inline void
__NVC96F_SEM_EXECUTE(uint32_t *val_out, struct nv_nvc96f_SEM_EXECUTE st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 3));
    val |= st.operation << 0;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.payload_size < (1ULL << 1));
    val |= st.payload_size << 24;
    *val_out = val;
}

#define V_NVC96F_SEM_EXECUTE(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC96F_SEM_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC96F_SEM_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC96F_SEM_EXECUTE_RELEASE_WFI_DIS; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVC96F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT; \
    struct nv_nvc96f_SEM_EXECUTE __data = args; \
    __NVC96F_SEM_EXECUTE(&val, __data); \
}

#define VA_NVC96F_SEM_EXECUTE V_NVC96F_SEM_EXECUTE

#define P_NVC96F_SEM_EXECUTE(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC96F_SEM_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC96F_SEM_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC96F_SEM_EXECUTE_RELEASE_WFI_DIS; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVC96F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT; \
    uint32_t nvk_p_ret; \
    V_NVC96F_SEM_EXECUTE(nvk_p_ret, args); \
    nv_push_val(push, NVC96F_SEM_EXECUTE, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC96F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC96F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
