// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"net/http"

	v1 "istio.io/client-go/pkg/apis/networking/v1"
	"istio.io/client-go/pkg/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type NetworkingV1Interface interface {
	RESTClient() rest.Interface
	DestinationRulesGetter
	GatewaysGetter
	ServiceEntriesGetter
	SidecarsGetter
	VirtualServicesGetter
	WorkloadEntriesGetter
	WorkloadGroupsGetter
}

// NetworkingV1Client is used to interact with features provided by the networking.istio.io group.
type NetworkingV1Client struct {
	restClient rest.Interface
}

func (c *NetworkingV1Client) DestinationRules(namespace string) DestinationRuleInterface {
	return newDestinationRules(c, namespace)
}

func (c *NetworkingV1Client) Gateways(namespace string) GatewayInterface {
	return newGateways(c, namespace)
}

func (c *NetworkingV1Client) ServiceEntries(namespace string) ServiceEntryInterface {
	return newServiceEntries(c, namespace)
}

func (c *NetworkingV1Client) Sidecars(namespace string) SidecarInterface {
	return newSidecars(c, namespace)
}

func (c *NetworkingV1Client) VirtualServices(namespace string) VirtualServiceInterface {
	return newVirtualServices(c, namespace)
}

func (c *NetworkingV1Client) WorkloadEntries(namespace string) WorkloadEntryInterface {
	return newWorkloadEntries(c, namespace)
}

func (c *NetworkingV1Client) WorkloadGroups(namespace string) WorkloadGroupInterface {
	return newWorkloadGroups(c, namespace)
}

// NewForConfig creates a new NetworkingV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*NetworkingV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new NetworkingV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*NetworkingV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &NetworkingV1Client{client}, nil
}

// NewForConfigOrDie creates a new NetworkingV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *NetworkingV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new NetworkingV1Client for the given RESTClient.
func New(c rest.Interface) *NetworkingV1Client {
	return &NetworkingV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *NetworkingV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
