{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The ATK interface which provides access to streamable content.
-- 
-- An interface whereby an object allows its backing content to be
-- streamed to clients.  Typical implementors would be images or
-- icons, HTML content, or multimedia display\/rendering widgets.
-- 
-- Negotiation of content type is allowed. Clients may examine the
-- backing data and transform, convert, or parse the content in order
-- to present it in an alternate form to end-users.
-- 
-- The AtkStreamableContent interface is particularly useful for
-- saving, printing, or post-processing entire documents, or for
-- persisting alternate views of a document. If document content
-- itself is being serialized, stored, or converted, then use of the
-- AtkStreamableContent interface can help address performance
-- issues. Unlike most ATK interfaces, this interface is not strongly
-- tied to the current user-agent view of the a particular document,
-- but may in some cases give access to the underlying model data.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.StreamableContent
    ( 

-- * Exported types
    StreamableContent(..)                   ,
    IsStreamableContent                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getMimeType]("GI.Atk.Interfaces.StreamableContent#g:method:getMimeType"), [getNMimeTypes]("GI.Atk.Interfaces.StreamableContent#g:method:getNMimeTypes"), [getStream]("GI.Atk.Interfaces.StreamableContent#g:method:getStream"), [getUri]("GI.Atk.Interfaces.StreamableContent#g:method:getUri").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveStreamableContentMethod          ,
#endif

-- ** getMimeType #method:getMimeType#

#if defined(ENABLE_OVERLOADING)
    StreamableContentGetMimeTypeMethodInfo  ,
#endif
    streamableContentGetMimeType            ,


-- ** getNMimeTypes #method:getNMimeTypes#

#if defined(ENABLE_OVERLOADING)
    StreamableContentGetNMimeTypesMethodInfo,
#endif
    streamableContentGetNMimeTypes          ,


-- ** getStream #method:getStream#

#if defined(ENABLE_OVERLOADING)
    StreamableContentGetStreamMethodInfo    ,
#endif
    streamableContentGetStream              ,


-- ** getUri #method:getUri#

#if defined(ENABLE_OVERLOADING)
    StreamableContentGetUriMethodInfo       ,
#endif
    streamableContentGetUri                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.IOChannel as GLib.IOChannel

#else
import qualified GI.GLib.Structs.IOChannel as GLib.IOChannel

#endif

-- interface StreamableContent 
-- | Memory-managed wrapper type.
newtype StreamableContent = StreamableContent (SP.ManagedPtr StreamableContent)
    deriving (Eq)

instance SP.ManagedPtrNewtype StreamableContent where
    toManagedPtr (StreamableContent p) = p

-- | Type class for types which implement t'StreamableContent'.
class (ManagedPtrNewtype o, O.IsDescendantOf StreamableContent o) => IsStreamableContent o
instance (ManagedPtrNewtype o, O.IsDescendantOf StreamableContent o) => IsStreamableContent o
-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr StreamableContent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
type family ResolveStreamableContentMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStreamableContentMethod "getMimeType" o = StreamableContentGetMimeTypeMethodInfo
    ResolveStreamableContentMethod "getNMimeTypes" o = StreamableContentGetNMimeTypesMethodInfo
    ResolveStreamableContentMethod "getStream" o = StreamableContentGetStreamMethodInfo
    ResolveStreamableContentMethod "getUri" o = StreamableContentGetUriMethodInfo
    ResolveStreamableContentMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStreamableContentMethod t StreamableContent, O.OverloadedMethod info StreamableContent p) => OL.IsLabel t (StreamableContent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStreamableContentMethod t StreamableContent, O.OverloadedMethod info StreamableContent p, R.HasField t StreamableContent p) => R.HasField t StreamableContent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStreamableContentMethod t StreamableContent, O.OverloadedMethodInfo info StreamableContent) => OL.IsLabel t (O.MethodProxy info StreamableContent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method StreamableContent::get_mime_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "streamable"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "StreamableContent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkStreamableContent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a gint representing the position of the mime type starting from 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_streamable_content_get_mime_type" atk_streamable_content_get_mime_type :: 
    Ptr StreamableContent ->                -- streamable : TInterface (Name {namespace = "Atk", name = "StreamableContent"})
    Int32 ->                                -- i : TBasicType TInt
    IO CString

-- | Gets the character string of the specified mime type. The first mime
-- type is at position 0, the second at position 1, and so on.
streamableContentGetMimeType ::
    (B.CallStack.HasCallStack, MonadIO m, IsStreamableContent a) =>
    a
    -- ^ /@streamable@/: a GObject instance that implements AtkStreamableContent
    -> Int32
    -- ^ /@i@/: a gint representing the position of the mime type starting from 0
    -> m T.Text
    -- ^ __Returns:__ a gchar* representing the specified mime type; the caller
    -- should not free the character string.
streamableContentGetMimeType streamable i = liftIO $ do
    streamable' <- unsafeManagedPtrCastPtr streamable
    result <- atk_streamable_content_get_mime_type streamable' i
    checkUnexpectedReturnNULL "streamableContentGetMimeType" result
    result' <- cstringToText result
    touchManagedPtr streamable
    return result'

#if defined(ENABLE_OVERLOADING)
data StreamableContentGetMimeTypeMethodInfo
instance (signature ~ (Int32 -> m T.Text), MonadIO m, IsStreamableContent a) => O.OverloadedMethod StreamableContentGetMimeTypeMethodInfo a signature where
    overloadedMethod = streamableContentGetMimeType

instance O.OverloadedMethodInfo StreamableContentGetMimeTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.StreamableContent.streamableContentGetMimeType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-StreamableContent.html#v:streamableContentGetMimeType"
        })


#endif

-- method StreamableContent::get_n_mime_types
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "streamable"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "StreamableContent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkStreamableContentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_streamable_content_get_n_mime_types" atk_streamable_content_get_n_mime_types :: 
    Ptr StreamableContent ->                -- streamable : TInterface (Name {namespace = "Atk", name = "StreamableContent"})
    IO Int32

-- | Gets the number of mime types supported by this object.
streamableContentGetNMimeTypes ::
    (B.CallStack.HasCallStack, MonadIO m, IsStreamableContent a) =>
    a
    -- ^ /@streamable@/: a GObject instance that implements AtkStreamableContentIface
    -> m Int32
    -- ^ __Returns:__ a gint which is the number of mime types supported by the object.
streamableContentGetNMimeTypes streamable = liftIO $ do
    streamable' <- unsafeManagedPtrCastPtr streamable
    result <- atk_streamable_content_get_n_mime_types streamable'
    touchManagedPtr streamable
    return result

#if defined(ENABLE_OVERLOADING)
data StreamableContentGetNMimeTypesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsStreamableContent a) => O.OverloadedMethod StreamableContentGetNMimeTypesMethodInfo a signature where
    overloadedMethod = streamableContentGetNMimeTypes

instance O.OverloadedMethodInfo StreamableContentGetNMimeTypesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.StreamableContent.streamableContentGetNMimeTypes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-StreamableContent.html#v:streamableContentGetNMimeTypes"
        })


#endif

-- method StreamableContent::get_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "streamable"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "StreamableContent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkStreamableContentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a gchar* representing the mime type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOChannel" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_streamable_content_get_stream" atk_streamable_content_get_stream :: 
    Ptr StreamableContent ->                -- streamable : TInterface (Name {namespace = "Atk", name = "StreamableContent"})
    CString ->                              -- mime_type : TBasicType TUTF8
    IO (Ptr GLib.IOChannel.IOChannel)

-- | Gets the content in the specified mime type.
streamableContentGetStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsStreamableContent a) =>
    a
    -- ^ /@streamable@/: a GObject instance that implements AtkStreamableContentIface
    -> T.Text
    -- ^ /@mimeType@/: a gchar* representing the mime type
    -> m GLib.IOChannel.IOChannel
    -- ^ __Returns:__ A t'GI.GLib.Structs.IOChannel.IOChannel' which contains the content in the
    -- specified mime type.
streamableContentGetStream streamable mimeType = liftIO $ do
    streamable' <- unsafeManagedPtrCastPtr streamable
    mimeType' <- textToCString mimeType
    result <- atk_streamable_content_get_stream streamable' mimeType'
    checkUnexpectedReturnNULL "streamableContentGetStream" result
    result' <- (wrapBoxed GLib.IOChannel.IOChannel) result
    touchManagedPtr streamable
    freeMem mimeType'
    return result'

#if defined(ENABLE_OVERLOADING)
data StreamableContentGetStreamMethodInfo
instance (signature ~ (T.Text -> m GLib.IOChannel.IOChannel), MonadIO m, IsStreamableContent a) => O.OverloadedMethod StreamableContentGetStreamMethodInfo a signature where
    overloadedMethod = streamableContentGetStream

instance O.OverloadedMethodInfo StreamableContentGetStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.StreamableContent.streamableContentGetStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-StreamableContent.html#v:streamableContentGetStream"
        })


#endif

-- method StreamableContent::get_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "streamable"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "StreamableContent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkStreamableContentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a gchar* representing the mime type, or NULL to request a URI\nfor the default mime type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_streamable_content_get_uri" atk_streamable_content_get_uri :: 
    Ptr StreamableContent ->                -- streamable : TInterface (Name {namespace = "Atk", name = "StreamableContent"})
    CString ->                              -- mime_type : TBasicType TUTF8
    IO CString

-- | Get a string representing a URI in IETF standard format
-- (see http:\/\/www.ietf.org\/rfc\/rfc2396.txt) from which the object\'s content
-- may be streamed in the specified mime-type, if one is available.
-- If mime_type is NULL, the URI for the default (and possibly only) mime-type is
-- returned.
-- 
-- Note that it is possible for get_uri to return NULL but for
-- get_stream to work nonetheless, since not all GIOChannels connect to URIs.
-- 
-- /Since: 1.12/
streamableContentGetUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsStreamableContent a) =>
    a
    -- ^ /@streamable@/: a GObject instance that implements AtkStreamableContentIface
    -> T.Text
    -- ^ /@mimeType@/: a gchar* representing the mime type, or NULL to request a URI
    -- for the default mime type.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ Returns a string representing a URI, or 'P.Nothing'
    -- if no corresponding URI can be constructed.
streamableContentGetUri streamable mimeType = liftIO $ do
    streamable' <- unsafeManagedPtrCastPtr streamable
    mimeType' <- textToCString mimeType
    result <- atk_streamable_content_get_uri streamable' mimeType'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr streamable
    freeMem mimeType'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StreamableContentGetUriMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m, IsStreamableContent a) => O.OverloadedMethod StreamableContentGetUriMethodInfo a signature where
    overloadedMethod = streamableContentGetUri

instance O.OverloadedMethodInfo StreamableContentGetUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.StreamableContent.streamableContentGetUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-StreamableContent.html#v:streamableContentGetUri"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StreamableContent = StreamableContentSignalList
type StreamableContentSignalList = ('[ ] :: [(Symbol, DK.Type)])

#endif


