/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_stream_to_vector = R"doc(convert a stream of items into a stream of gnuradio/blocks containing nitems_per_block

Constructor Specific Documentation:

Make a stream-to-vector block.

Args:
    itemsize : the item size of the stream
    nitems_per_block : number of items to put into each vector (vector size))doc";


static const char* __doc_gr_blocks_stream_to_vector_stream_to_vector = R"doc()doc";


static const char* __doc_gr_blocks_stream_to_vector_make = R"doc(convert a stream of items into a stream of gnuradio/blocks containing nitems_per_block

Constructor Specific Documentation:

Make a stream-to-vector block.

Args:
    itemsize : the item size of the stream
    nitems_per_block : number of items to put into each vector (vector size))doc";
