/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_usrp_sink = R"doc(USRP Sink  Radio Transmitter


The USRP sink block reads a stream and transmits the samples. The sink block also provides API calls for transmitter settings. See also gr::uhd::usrp_block for more public API calls.



TX Stream taggingThe following tag keys will be consumed by the work function:



Any other tag will be ignored.




Bursty TransmissionThere are multiple ways to do bursty transmission without triggering underruns:



The sob and eob (start and end of burst) tag values are pmt booleans. When present, burst tags should be set to true (pmt::PMT_T).


If  is not an empty string, all \"tx_sob\" and \"tx_eob\" tags will be ignored, and the input is assumed to a tagged stream.


If sob/eob tags or length tags are used, this block understands that the data is bursty, and will configure the USRP to make sure there's no underruns after transmitting the final sample of a burst.




TimestampsThe timestamp tag value is a PMT tuple of the following: (uint64 seconds, double fractional seconds).


The tx_freq tag has to be a double or a pair of form (channel, frequency), with frequency being a double and channel being an integer. This tag will trigger a tune command to the USRP to the given frequency, if possible. Note that oscillators need some time to stabilize after this! Don't expect clean data to be sent immediately after this command. If channel is omitted, and only a double is given, it will set this frequency to all channels.


The command tag can carry a PMT command. See the following section.




Command interfaceThere are two ways of passing commands to this block:



In both cases, the payload of the command is a PMT command, as described in Section Command Syntax.


For a more general description of the gr-uhd components, see UHD Interface.

Constructor Specific Documentation:



Args:
    device_addr : the address to identify the hardware
    stream_args : the IO format and channel specification
    tsb_tag_name : the name of the tag identifying tagged stream length)doc";


static const char* __doc_gr_uhd_usrp_sink_usrp_sink_0 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_sink_usrp_sink_1 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_sink_make = R"doc(USRP Sink  Radio Transmitter


The USRP sink block reads a stream and transmits the samples. The sink block also provides API calls for transmitter settings. See also gr::uhd::usrp_block for more public API calls.



TX Stream taggingThe following tag keys will be consumed by the work function:



Any other tag will be ignored.




Bursty TransmissionThere are multiple ways to do bursty transmission without triggering underruns:



The sob and eob (start and end of burst) tag values are pmt booleans. When present, burst tags should be set to true (pmt::PMT_T).


If  is not an empty string, all \"tx_sob\" and \"tx_eob\" tags will be ignored, and the input is assumed to a tagged stream.


If sob/eob tags or length tags are used, this block understands that the data is bursty, and will configure the USRP to make sure there's no underruns after transmitting the final sample of a burst.




TimestampsThe timestamp tag value is a PMT tuple of the following: (uint64 seconds, double fractional seconds).


The tx_freq tag has to be a double or a pair of form (channel, frequency), with frequency being a double and channel being an integer. This tag will trigger a tune command to the USRP to the given frequency, if possible. Note that oscillators need some time to stabilize after this! Don't expect clean data to be sent immediately after this command. If channel is omitted, and only a double is given, it will set this frequency to all channels.


The command tag can carry a PMT command. See the following section.




Command interfaceThere are two ways of passing commands to this block:



In both cases, the payload of the command is a PMT command, as described in Section Command Syntax.


For a more general description of the gr-uhd components, see UHD Interface.

Constructor Specific Documentation:



Args:
    device_addr : the address to identify the hardware
    stream_args : the IO format and channel specification
    tsb_tag_name : the name of the tag identifying tagged stream length)doc";


static const char* __doc_gr_uhd_usrp_sink_set_start_time = R"doc(Set the start time for outgoing samples. To control when samples are transmitted, set this value before starting the flow graph. The value is cleared after each run. When not specified, the start time will be:)doc";


static const char* __doc_gr_uhd_usrp_sink_get_lo_names = R"doc(Get a list of possible LO stage names)doc";


static const char* __doc_gr_uhd_usrp_sink_set_lo_source = R"doc(Set the LO source for the usrp device. For usrps that support selectable LOs, this function allows switching between them. Typical options for source: internal, external.)doc";


static const char* __doc_gr_uhd_usrp_sink_get_lo_source = R"doc(Get the currently set LO source.)doc";


static const char* __doc_gr_uhd_usrp_sink_get_lo_sources = R"doc(Get a list of possible LO sources.)doc";


static const char* __doc_gr_uhd_usrp_sink_set_lo_export_enabled = R"doc(Set whether the LO used by the usrp device is exported For usrps that support exportable LOs, this function configures if the LO used by chan is exported or not.)doc";


static const char* __doc_gr_uhd_usrp_sink_get_lo_export_enabled = R"doc(Returns true if the currently selected LO is being exported.)doc";


static const char* __doc_gr_uhd_usrp_sink_set_lo_freq = R"doc(Set the RX LO frequency (Advanced).)doc";


static const char* __doc_gr_uhd_usrp_sink_get_lo_freq = R"doc(Get the current RX LO frequency (Advanced).)doc";


static const char* __doc_gr_uhd_usrp_sink_get_lo_freq_range = R"doc(Get the LO frequency range of the RX LO.)doc";


static const char* __doc_gr_uhd_usrp_sink_set_dc_offset = R"doc(Set a constant DC offset value. The value is complex to control both I and Q.)doc";


static const char* __doc_gr_uhd_usrp_sink_set_iq_balance = R"doc(Set the RX frontend IQ imbalance correction. Use this to adjust the magnitude and phase of I and Q.)doc";
