/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_agc2_cc = R"doc(high performance Automatic Gain Control class with attack and decay rates.

For Power the absolute value of the complex number is used.

Constructor Specific Documentation:

Build a complex value AGC loop block with attack and decay rates.

Args:
    attack_rate : the update rate of the loop when in attack mode.
    decay_rate : the update rate of the loop when in decay mode.
    reference : reference value to adjust signal power to.
    gain : initial gain value.
    max_gain : maximum gain value (0 for unlimited).)doc";


static const char* __doc_gr_analog_agc2_cc_agc2_cc_0 = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_agc2_cc_1 = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_make = R"doc(high performance Automatic Gain Control class with attack and decay rates.

For Power the absolute value of the complex number is used.

Constructor Specific Documentation:

Build a complex value AGC loop block with attack and decay rates.

Args:
    attack_rate : the update rate of the loop when in attack mode.
    decay_rate : the update rate of the loop when in decay mode.
    reference : reference value to adjust signal power to.
    gain : initial gain value.
    max_gain : maximum gain value (0 for unlimited).)doc";


static const char* __doc_gr_analog_agc2_cc_attack_rate = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_decay_rate = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_reference = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_gain = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_max_gain = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_set_attack_rate = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_set_decay_rate = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_set_reference = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_set_gain = R"doc()doc";


static const char* __doc_gr_analog_agc2_cc_set_max_gain = R"doc()doc";
