/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.gnome.RemoteDesktop.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_credentials,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        GVariant *arg_Certificate,
        GVariant *arg_PrivateKey,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringStringFunc)
       (void *data1,
        const gchar *arg_routing_token,
        const gchar *arg_username,
        const gchar *arg_password,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_string (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_username,
        const gchar *arg_password,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.RemoteDesktop
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsdRemoteDesktop
 * @title: GsdRemoteDesktop
 * @short_description: Generated C code for the org.gnome.RemoteDesktop D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.RemoteDesktop ---- */

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_property_info_runtime_mode =
{
  {
    -1,
    (gchar *) "RuntimeMode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "runtime-mode",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gsd_remote_desktop_property_info_pointers[] =
{
  &_gsd_remote_desktop_property_info_runtime_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gsd_remote_desktop_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.RemoteDesktop",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_gsd_remote_desktop_property_info_pointers,
    NULL
  },
  "remote-desktop",
};


/**
 * gsd_remote_desktop_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gsd_remote_desktop_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gsd_remote_desktop_interface_info.parent_struct;
}

/**
 * gsd_remote_desktop_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsdRemoteDesktop interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gsd_remote_desktop_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "runtime-mode");
  return property_id_begin - 1;
}



/**
 * GsdRemoteDesktop:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link>.
 */

/**
 * GsdRemoteDesktopIface:
 * @parent_iface: The parent interface.
 * @get_runtime_mode: Getter for the #GsdRemoteDesktop:runtime-mode property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link>.
 */

typedef GsdRemoteDesktopIface GsdRemoteDesktopInterface;
G_DEFINE_INTERFACE (GsdRemoteDesktop, gsd_remote_desktop, G_TYPE_OBJECT)

static void
gsd_remote_desktop_default_init (GsdRemoteDesktopIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * GsdRemoteDesktop:runtime-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop.RuntimeMode">"RuntimeMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("runtime-mode", "RuntimeMode", "RuntimeMode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gsd_remote_desktop_get_runtime_mode: (skip)
 * @object: A #GsdRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop.RuntimeMode">"RuntimeMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_dup_runtime_mode() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_get_runtime_mode (GsdRemoteDesktop *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP (object), NULL);

  return GSD_REMOTE_DESKTOP_GET_IFACE (object)->get_runtime_mode (object);
}

/**
 * gsd_remote_desktop_dup_runtime_mode: (skip)
 * @object: A #GsdRemoteDesktop.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop.RuntimeMode">"RuntimeMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_dup_runtime_mode (GsdRemoteDesktop *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "runtime-mode", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_set_runtime_mode: (skip)
 * @object: A #GsdRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop.RuntimeMode">"RuntimeMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_set_runtime_mode (GsdRemoteDesktop *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "runtime-mode", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopProxy:
 *
 * The #GsdRemoteDesktopProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopProxy.
 */

struct _GsdRemoteDesktopProxyPrivate
{
  GData *qdata;
};

static void gsd_remote_desktop_proxy_iface_init (GsdRemoteDesktopIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopProxy, gsd_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsdRemoteDesktopProxy)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP, gsd_remote_desktop_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopProxy, gsd_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP, gsd_remote_desktop_proxy_iface_init))

#endif
static void
gsd_remote_desktop_proxy_finalize (GObject *object)
{
  GsdRemoteDesktopProxy *proxy = GSD_REMOTE_DESKTOP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gsd_remote_desktop_proxy_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gsd_remote_desktop_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.RemoteDesktop: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gsd_remote_desktop_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.RemoteDesktop", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gsd_remote_desktop_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gsd_remote_desktop_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gsd_remote_desktop_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GSD_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gsd_remote_desktop_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsdRemoteDesktopProxy *proxy = GSD_REMOTE_DESKTOP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
gsd_remote_desktop_proxy_get_runtime_mode (GsdRemoteDesktop *object)
{
  GsdRemoteDesktopProxy *proxy = GSD_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RuntimeMode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
gsd_remote_desktop_proxy_init (GsdRemoteDesktopProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gsd_remote_desktop_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GSD_TYPE_REMOTE_DESKTOP_PROXY, GsdRemoteDesktopProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gsd_remote_desktop_interface_info ());
}

static void
gsd_remote_desktop_proxy_class_init (GsdRemoteDesktopProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gsd_remote_desktop_proxy_finalize;
  gobject_class->get_property = gsd_remote_desktop_proxy_get_property;
  gobject_class->set_property = gsd_remote_desktop_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gsd_remote_desktop_proxy_g_signal;
  proxy_class->g_properties_changed = gsd_remote_desktop_proxy_g_properties_changed;

  gsd_remote_desktop_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopProxyPrivate));
#endif
}

static void
gsd_remote_desktop_proxy_iface_init (GsdRemoteDesktopIface *iface)
{
  iface->get_runtime_mode = gsd_remote_desktop_proxy_get_runtime_mode;
}

/**
 * gsd_remote_desktop_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_proxy_new_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop", NULL);
}

/**
 * gsd_remote_desktop_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_proxy_new().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktop *
gsd_remote_desktop_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktop *
gsd_remote_desktop_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/**
 * gsd_remote_desktop_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gsd_remote_desktop_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop", NULL);
}

/**
 * gsd_remote_desktop_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktop *
gsd_remote_desktop_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gsd_remote_desktop_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktop *
gsd_remote_desktop_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopSkeleton:
 *
 * The #GsdRemoteDesktopSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopSkeleton.
 */

struct _GsdRemoteDesktopSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gsd_remote_desktop_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GSD_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gsd_remote_desktop_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gsd_remote_desktop_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gsd_remote_desktop_skeleton_vtable =
{
  _gsd_remote_desktop_skeleton_handle_method_call,
  _gsd_remote_desktop_skeleton_handle_get_property,
  _gsd_remote_desktop_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gsd_remote_desktop_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gsd_remote_desktop_interface_info ();
}

static GDBusInterfaceVTable *
gsd_remote_desktop_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gsd_remote_desktop_skeleton_vtable;
}

static GVariant *
gsd_remote_desktop_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gsd_remote_desktop_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gsd_remote_desktop_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gsd_remote_desktop_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gsd_remote_desktop_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gsd_remote_desktop_emit_changed (gpointer user_data);

static void
gsd_remote_desktop_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gsd_remote_desktop_emit_changed (skeleton);
}

static void gsd_remote_desktop_skeleton_iface_init (GsdRemoteDesktopIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopSkeleton, gsd_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsdRemoteDesktopSkeleton)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP, gsd_remote_desktop_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopSkeleton, gsd_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP, gsd_remote_desktop_skeleton_iface_init))

#endif
static void
gsd_remote_desktop_skeleton_finalize (GObject *object)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gsd_remote_desktop_skeleton_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gsd_remote_desktop_emit_changed (gpointer user_data)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.RemoteDesktop",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gsd_remote_desktop_schedule_emit_changed (GsdRemoteDesktopSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gsd_remote_desktop_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gsd_remote_desktop_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gsd_remote_desktop_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gsd_remote_desktop_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gsd_remote_desktop_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gsd_remote_desktop_skeleton_init (GsdRemoteDesktopSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gsd_remote_desktop_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GSD_TYPE_REMOTE_DESKTOP_SKELETON, GsdRemoteDesktopSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
}

static const gchar *
gsd_remote_desktop_skeleton_get_runtime_mode (GsdRemoteDesktop *object)
{
  GsdRemoteDesktopSkeleton *skeleton = GSD_REMOTE_DESKTOP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gsd_remote_desktop_skeleton_class_init (GsdRemoteDesktopSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gsd_remote_desktop_skeleton_finalize;
  gobject_class->get_property = gsd_remote_desktop_skeleton_get_property;
  gobject_class->set_property = gsd_remote_desktop_skeleton_set_property;
  gobject_class->notify       = gsd_remote_desktop_skeleton_notify;


  gsd_remote_desktop_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gsd_remote_desktop_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gsd_remote_desktop_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gsd_remote_desktop_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gsd_remote_desktop_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopSkeletonPrivate));
#endif
}

static void
gsd_remote_desktop_skeleton_iface_init (GsdRemoteDesktopIface *iface)
{
  iface->get_runtime_mode = gsd_remote_desktop_skeleton_get_runtime_mode;
}

/**
 * gsd_remote_desktop_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop.top_of_page">org.gnome.RemoteDesktop</link>.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopSkeleton): The skeleton object.
 */
GsdRemoteDesktop *
gsd_remote_desktop_skeleton_new (void)
{
  return GSD_REMOTE_DESKTOP (g_object_new (GSD_TYPE_REMOTE_DESKTOP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.RemoteDesktop.Rdp.Server
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsdRemoteDesktopRdpServer
 * @title: GsdRemoteDesktopRdpServer
 * @short_description: Generated C code for the org.gnome.RemoteDesktop.Rdp.Server D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link> D-Bus interface in C.
 */

enum
{
  GSD__REMOTE_DESKTOP_RDP_SERVER_BINDING,
};

static unsigned GSD__REMOTE_DESKTOP_RDP_SERVER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.RemoteDesktop.Rdp.Server ---- */

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_server_signal_info_binding_ARG_port =
{
  {
    -1,
    (gchar *) "port",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_server_signal_info_binding_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_server_signal_info_binding_ARG_port.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gsd_remote_desktop_rdp_server_signal_info_binding =
{
  {
    -1,
    (gchar *) "Binding",
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_server_signal_info_binding_ARG_pointers,
    NULL
  },
  "binding"
};

static const GDBusSignalInfo * const _gsd_remote_desktop_rdp_server_signal_info_pointers[] =
{
  &_gsd_remote_desktop_rdp_server_signal_info_binding.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_enabled =
{
  {
    -1,
    (gchar *) "Enabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_port =
{
  {
    -1,
    (gchar *) "Port",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_negotiate_port =
{
  {
    -1,
    (gchar *) "NegotiatePort",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "negotiate-port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_tls_cert =
{
  {
    -1,
    (gchar *) "TlsCert",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tls-cert",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_tls_fingerprint =
{
  {
    -1,
    (gchar *) "TlsFingerprint",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tls-fingerprint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_tls_key =
{
  {
    -1,
    (gchar *) "TlsKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tls-key",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_rdp_server_property_info_view_only =
{
  {
    -1,
    (gchar *) "ViewOnly",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "view-only",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gsd_remote_desktop_rdp_server_property_info_pointers[] =
{
  &_gsd_remote_desktop_rdp_server_property_info_enabled.parent_struct,
  &_gsd_remote_desktop_rdp_server_property_info_port.parent_struct,
  &_gsd_remote_desktop_rdp_server_property_info_negotiate_port.parent_struct,
  &_gsd_remote_desktop_rdp_server_property_info_tls_cert.parent_struct,
  &_gsd_remote_desktop_rdp_server_property_info_tls_fingerprint.parent_struct,
  &_gsd_remote_desktop_rdp_server_property_info_tls_key.parent_struct,
  &_gsd_remote_desktop_rdp_server_property_info_view_only.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gsd_remote_desktop_rdp_server_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.RemoteDesktop.Rdp.Server",
    NULL,
    (GDBusSignalInfo **) &_gsd_remote_desktop_rdp_server_signal_info_pointers,
    (GDBusPropertyInfo **) &_gsd_remote_desktop_rdp_server_property_info_pointers,
    NULL
  },
  "remote-desktop-rdp-server",
};


/**
 * gsd_remote_desktop_rdp_server_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gsd_remote_desktop_rdp_server_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_server_interface_info.parent_struct;
}

/**
 * gsd_remote_desktop_rdp_server_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsdRemoteDesktopRdpServer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gsd_remote_desktop_rdp_server_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "enabled");
  g_object_class_override_property (klass, property_id_begin++, "port");
  g_object_class_override_property (klass, property_id_begin++, "negotiate-port");
  g_object_class_override_property (klass, property_id_begin++, "tls-cert");
  g_object_class_override_property (klass, property_id_begin++, "tls-fingerprint");
  g_object_class_override_property (klass, property_id_begin++, "tls-key");
  g_object_class_override_property (klass, property_id_begin++, "view-only");
  return property_id_begin - 1;
}


inline static void
gsd_remote_desktop_rdp_server_signal_marshal_binding (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GsdRemoteDesktopRdpServer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link>.
 */

/**
 * GsdRemoteDesktopRdpServerIface:
 * @parent_iface: The parent interface.
 * @get_enabled: Getter for the #GsdRemoteDesktopRdpServer:enabled property.
 * @get_negotiate_port: Getter for the #GsdRemoteDesktopRdpServer:negotiate-port property.
 * @get_port: Getter for the #GsdRemoteDesktopRdpServer:port property.
 * @get_tls_cert: Getter for the #GsdRemoteDesktopRdpServer:tls-cert property.
 * @get_tls_fingerprint: Getter for the #GsdRemoteDesktopRdpServer:tls-fingerprint property.
 * @get_tls_key: Getter for the #GsdRemoteDesktopRdpServer:tls-key property.
 * @get_view_only: Getter for the #GsdRemoteDesktopRdpServer:view-only property.
 * @binding: Handler for the #GsdRemoteDesktopRdpServer::binding signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link>.
 */

typedef GsdRemoteDesktopRdpServerIface GsdRemoteDesktopRdpServerInterface;
G_DEFINE_INTERFACE (GsdRemoteDesktopRdpServer, gsd_remote_desktop_rdp_server, G_TYPE_OBJECT)

static void
gsd_remote_desktop_rdp_server_default_init (GsdRemoteDesktopRdpServerIface *iface)
{
  /* GObject signals for received D-Bus signals: */
  /**
   * GsdRemoteDesktopRdpServer::binding:
   * @object: A #GsdRemoteDesktopRdpServer.
   * @arg_port: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-RemoteDesktop-Rdp-Server.Binding">"Binding"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GSD__REMOTE_DESKTOP_RDP_SERVER_SIGNALS[GSD__REMOTE_DESKTOP_RDP_SERVER_BINDING] =
    g_signal_new ("binding",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GsdRemoteDesktopRdpServerIface, binding),
      NULL,
      NULL,
      gsd_remote_desktop_rdp_server_signal_marshal_binding,
      G_TYPE_NONE,
      1, G_TYPE_INT);

  /* GObject properties for D-Bus properties: */
  /**
   * GsdRemoteDesktopRdpServer:enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.Enabled">"Enabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("enabled", "Enabled", "Enabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopRdpServer:port:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.Port">"Port"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("port", "Port", "Port", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopRdpServer:negotiate-port:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.NegotiatePort">"NegotiatePort"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("negotiate-port", "NegotiatePort", "NegotiatePort", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopRdpServer:tls-cert:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsCert">"TlsCert"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tls-cert", "TlsCert", "TlsCert", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopRdpServer:tls-fingerprint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tls-fingerprint", "TlsFingerprint", "TlsFingerprint", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopRdpServer:tls-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsKey">"TlsKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tls-key", "TlsKey", "TlsKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopRdpServer:view-only:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.ViewOnly">"ViewOnly"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("view-only", "ViewOnly", "ViewOnly", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gsd_remote_desktop_rdp_server_get_enabled: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.Enabled">"Enabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_rdp_server_get_enabled (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_enabled (object);
}

/**
 * gsd_remote_desktop_rdp_server_set_enabled: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.Enabled">"Enabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_enabled (GsdRemoteDesktopRdpServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "enabled", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_get_port: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.Port">"Port"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
gsd_remote_desktop_rdp_server_get_port (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), 0);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_port (object);
}

/**
 * gsd_remote_desktop_rdp_server_set_port: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.Port">"Port"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_port (GsdRemoteDesktopRdpServer *object, gint value)
{
  g_object_set (G_OBJECT (object), "port", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_get_negotiate_port: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.NegotiatePort">"NegotiatePort"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_rdp_server_get_negotiate_port (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_negotiate_port (object);
}

/**
 * gsd_remote_desktop_rdp_server_set_negotiate_port: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.NegotiatePort">"NegotiatePort"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_negotiate_port (GsdRemoteDesktopRdpServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "negotiate-port", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_get_tls_cert: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsCert">"TlsCert"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_rdp_server_dup_tls_cert() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_rdp_server_get_tls_cert (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_tls_cert (object);
}

/**
 * gsd_remote_desktop_rdp_server_dup_tls_cert: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsCert">"TlsCert"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_rdp_server_dup_tls_cert (GsdRemoteDesktopRdpServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tls-cert", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_rdp_server_set_tls_cert: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsCert">"TlsCert"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_tls_cert (GsdRemoteDesktopRdpServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tls-cert", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_get_tls_fingerprint: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_rdp_server_dup_tls_fingerprint() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_rdp_server_get_tls_fingerprint (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_tls_fingerprint (object);
}

/**
 * gsd_remote_desktop_rdp_server_dup_tls_fingerprint: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_rdp_server_dup_tls_fingerprint (GsdRemoteDesktopRdpServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tls-fingerprint", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_rdp_server_set_tls_fingerprint: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_tls_fingerprint (GsdRemoteDesktopRdpServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tls-fingerprint", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_get_tls_key: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsKey">"TlsKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_rdp_server_dup_tls_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_rdp_server_get_tls_key (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_tls_key (object);
}

/**
 * gsd_remote_desktop_rdp_server_dup_tls_key: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsKey">"TlsKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_rdp_server_dup_tls_key (GsdRemoteDesktopRdpServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tls-key", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_rdp_server_set_tls_key: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.TlsKey">"TlsKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_tls_key (GsdRemoteDesktopRdpServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tls-key", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_get_view_only: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.ViewOnly">"ViewOnly"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_rdp_server_get_view_only (GsdRemoteDesktopRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_RDP_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_RDP_SERVER_GET_IFACE (object)->get_view_only (object);
}

/**
 * gsd_remote_desktop_rdp_server_set_view_only: (skip)
 * @object: A #GsdRemoteDesktopRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Rdp-Server.ViewOnly">"ViewOnly"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_rdp_server_set_view_only (GsdRemoteDesktopRdpServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "view-only", value, NULL);
}

/**
 * gsd_remote_desktop_rdp_server_emit_binding:
 * @object: A #GsdRemoteDesktopRdpServer.
 * @arg_port: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-RemoteDesktop-Rdp-Server.Binding">"Binding"</link> D-Bus signal.
 */
void
gsd_remote_desktop_rdp_server_emit_binding (
    GsdRemoteDesktopRdpServer *object,
    gint arg_port)
{
  g_signal_emit (object, GSD__REMOTE_DESKTOP_RDP_SERVER_SIGNALS[GSD__REMOTE_DESKTOP_RDP_SERVER_BINDING], 0, arg_port);
}

/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopRdpServerProxy:
 *
 * The #GsdRemoteDesktopRdpServerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopRdpServerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopRdpServerProxy.
 */

struct _GsdRemoteDesktopRdpServerProxyPrivate
{
  GData *qdata;
};

static void gsd_remote_desktop_rdp_server_proxy_iface_init (GsdRemoteDesktopRdpServerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpServerProxy, gsd_remote_desktop_rdp_server_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsdRemoteDesktopRdpServerProxy)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER, gsd_remote_desktop_rdp_server_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpServerProxy, gsd_remote_desktop_rdp_server_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER, gsd_remote_desktop_rdp_server_proxy_iface_init))

#endif
static void
gsd_remote_desktop_rdp_server_proxy_finalize (GObject *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gsd_remote_desktop_rdp_server_proxy_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_rdp_server_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_rdp_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gsd_remote_desktop_rdp_server_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.RemoteDesktop.Rdp.Server: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gsd_remote_desktop_rdp_server_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_rdp_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.RemoteDesktop.Rdp.Server", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gsd_remote_desktop_rdp_server_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gsd_remote_desktop_rdp_server_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_server_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gsd_remote_desktop_rdp_server_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_server_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_server_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
gsd_remote_desktop_rdp_server_proxy_get_enabled (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Enabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
gsd_remote_desktop_rdp_server_proxy_get_port (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Port");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gsd_remote_desktop_rdp_server_proxy_get_negotiate_port (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NegotiatePort");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_rdp_server_proxy_get_tls_cert (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TlsCert");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_rdp_server_proxy_get_tls_fingerprint (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TlsFingerprint");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_rdp_server_proxy_get_tls_key (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TlsKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gsd_remote_desktop_rdp_server_proxy_get_view_only (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_RDP_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ViewOnly");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gsd_remote_desktop_rdp_server_proxy_init (GsdRemoteDesktopRdpServerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gsd_remote_desktop_rdp_server_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_PROXY, GsdRemoteDesktopRdpServerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gsd_remote_desktop_rdp_server_interface_info ());
}

static void
gsd_remote_desktop_rdp_server_proxy_class_init (GsdRemoteDesktopRdpServerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gsd_remote_desktop_rdp_server_proxy_finalize;
  gobject_class->get_property = gsd_remote_desktop_rdp_server_proxy_get_property;
  gobject_class->set_property = gsd_remote_desktop_rdp_server_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gsd_remote_desktop_rdp_server_proxy_g_signal;
  proxy_class->g_properties_changed = gsd_remote_desktop_rdp_server_proxy_g_properties_changed;

  gsd_remote_desktop_rdp_server_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopRdpServerProxyPrivate));
#endif
}

static void
gsd_remote_desktop_rdp_server_proxy_iface_init (GsdRemoteDesktopRdpServerIface *iface)
{
  iface->get_enabled = gsd_remote_desktop_rdp_server_proxy_get_enabled;
  iface->get_port = gsd_remote_desktop_rdp_server_proxy_get_port;
  iface->get_negotiate_port = gsd_remote_desktop_rdp_server_proxy_get_negotiate_port;
  iface->get_tls_cert = gsd_remote_desktop_rdp_server_proxy_get_tls_cert;
  iface->get_tls_fingerprint = gsd_remote_desktop_rdp_server_proxy_get_tls_fingerprint;
  iface->get_tls_key = gsd_remote_desktop_rdp_server_proxy_get_tls_key;
  iface->get_view_only = gsd_remote_desktop_rdp_server_proxy_get_view_only;
}

/**
 * gsd_remote_desktop_rdp_server_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_server_proxy_new_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_server_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_rdp_server_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Server", NULL);
}

/**
 * gsd_remote_desktop_rdp_server_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_server_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_server_proxy_new().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpServer *
gsd_remote_desktop_rdp_server_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_SERVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_rdp_server_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_server_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpServer *
gsd_remote_desktop_rdp_server_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Server", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_SERVER (ret);
  else
    return NULL;
}


/**
 * gsd_remote_desktop_rdp_server_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gsd_remote_desktop_rdp_server_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_server_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_server_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_rdp_server_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Server", NULL);
}

/**
 * gsd_remote_desktop_rdp_server_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_server_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_server_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpServer *
gsd_remote_desktop_rdp_server_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_SERVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_rdp_server_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gsd_remote_desktop_rdp_server_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_server_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpServer *
gsd_remote_desktop_rdp_server_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Server", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_SERVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopRdpServerSkeleton:
 *
 * The #GsdRemoteDesktopRdpServerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopRdpServerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopRdpServerSkeleton.
 */

struct _GsdRemoteDesktopRdpServerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gsd_remote_desktop_rdp_server_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gsd_remote_desktop_rdp_server_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gsd_remote_desktop_rdp_server_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gsd_remote_desktop_rdp_server_skeleton_vtable =
{
  _gsd_remote_desktop_rdp_server_skeleton_handle_method_call,
  _gsd_remote_desktop_rdp_server_skeleton_handle_get_property,
  _gsd_remote_desktop_rdp_server_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gsd_remote_desktop_rdp_server_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gsd_remote_desktop_rdp_server_interface_info ();
}

static GDBusInterfaceVTable *
gsd_remote_desktop_rdp_server_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gsd_remote_desktop_rdp_server_skeleton_vtable;
}

static GVariant *
gsd_remote_desktop_rdp_server_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gsd_remote_desktop_rdp_server_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gsd_remote_desktop_rdp_server_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gsd_remote_desktop_rdp_server_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gsd_remote_desktop_rdp_server_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Rdp.Server", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gsd_remote_desktop_rdp_server_emit_changed (gpointer user_data);

static void
gsd_remote_desktop_rdp_server_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gsd_remote_desktop_rdp_server_emit_changed (skeleton);
}

static void
_gsd_remote_desktop_rdp_server_on_signal_binding (
    GsdRemoteDesktopRdpServer *object,
    gint arg_port)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_port));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Rdp.Server", "Binding",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gsd_remote_desktop_rdp_server_skeleton_iface_init (GsdRemoteDesktopRdpServerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpServerSkeleton, gsd_remote_desktop_rdp_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsdRemoteDesktopRdpServerSkeleton)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER, gsd_remote_desktop_rdp_server_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpServerSkeleton, gsd_remote_desktop_rdp_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER, gsd_remote_desktop_rdp_server_skeleton_iface_init))

#endif
static void
gsd_remote_desktop_rdp_server_skeleton_finalize (GObject *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gsd_remote_desktop_rdp_server_skeleton_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_rdp_server_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gsd_remote_desktop_rdp_server_emit_changed (gpointer user_data)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.RemoteDesktop.Rdp.Server",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gsd_remote_desktop_rdp_server_schedule_emit_changed (GsdRemoteDesktopRdpServerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gsd_remote_desktop_rdp_server_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gsd_remote_desktop_rdp_server_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gsd_remote_desktop_rdp_server_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gsd_remote_desktop_rdp_server_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_rdp_server_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gsd_remote_desktop_rdp_server_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gsd_remote_desktop_rdp_server_skeleton_init (GsdRemoteDesktopRdpServerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gsd_remote_desktop_rdp_server_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_SKELETON, GsdRemoteDesktopRdpServerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
}

static gboolean 
gsd_remote_desktop_rdp_server_skeleton_get_enabled (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
gsd_remote_desktop_rdp_server_skeleton_get_port (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gsd_remote_desktop_rdp_server_skeleton_get_negotiate_port (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_rdp_server_skeleton_get_tls_cert (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_rdp_server_skeleton_get_tls_fingerprint (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_rdp_server_skeleton_get_tls_key (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gsd_remote_desktop_rdp_server_skeleton_get_view_only (GsdRemoteDesktopRdpServer *object)
{
  GsdRemoteDesktopRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gsd_remote_desktop_rdp_server_skeleton_class_init (GsdRemoteDesktopRdpServerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gsd_remote_desktop_rdp_server_skeleton_finalize;
  gobject_class->get_property = gsd_remote_desktop_rdp_server_skeleton_get_property;
  gobject_class->set_property = gsd_remote_desktop_rdp_server_skeleton_set_property;
  gobject_class->notify       = gsd_remote_desktop_rdp_server_skeleton_notify;


  gsd_remote_desktop_rdp_server_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gsd_remote_desktop_rdp_server_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gsd_remote_desktop_rdp_server_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gsd_remote_desktop_rdp_server_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gsd_remote_desktop_rdp_server_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopRdpServerSkeletonPrivate));
#endif
}

static void
gsd_remote_desktop_rdp_server_skeleton_iface_init (GsdRemoteDesktopRdpServerIface *iface)
{
  iface->binding = _gsd_remote_desktop_rdp_server_on_signal_binding;
  iface->get_enabled = gsd_remote_desktop_rdp_server_skeleton_get_enabled;
  iface->get_port = gsd_remote_desktop_rdp_server_skeleton_get_port;
  iface->get_negotiate_port = gsd_remote_desktop_rdp_server_skeleton_get_negotiate_port;
  iface->get_tls_cert = gsd_remote_desktop_rdp_server_skeleton_get_tls_cert;
  iface->get_tls_fingerprint = gsd_remote_desktop_rdp_server_skeleton_get_tls_fingerprint;
  iface->get_tls_key = gsd_remote_desktop_rdp_server_skeleton_get_tls_key;
  iface->get_view_only = gsd_remote_desktop_rdp_server_skeleton_get_view_only;
}

/**
 * gsd_remote_desktop_rdp_server_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Rdp.Server</link>.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpServerSkeleton): The skeleton object.
 */
GsdRemoteDesktopRdpServer *
gsd_remote_desktop_rdp_server_skeleton_new (void)
{
  return GSD_REMOTE_DESKTOP_RDP_SERVER (g_object_new (GSD_TYPE_REMOTE_DESKTOP_RDP_SERVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.RemoteDesktop.Configuration.Rdp.Server
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsdRemoteDesktopConfigurationRdpServer
 * @title: GsdRemoteDesktopConfigurationRdpServer
 * @short_description: Generated C code for the org.gnome.RemoteDesktop.Configuration.Rdp.Server D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.RemoteDesktop.Configuration.Rdp.Server ---- */

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_configuration_rdp_server_method_info_enable =
{
  {
    -1,
    (gchar *) "Enable",
    NULL,
    NULL,
    NULL
  },
  "handle-enable",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_configuration_rdp_server_method_info_disable =
{
  {
    -1,
    (gchar *) "Disable",
    NULL,
    NULL,
    NULL
  },
  "handle-disable",
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_configuration_rdp_server_method_info_get_credentials_OUT_ARG_credentials =
{
  {
    -1,
    (gchar *) "credentials",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_configuration_rdp_server_method_info_get_credentials_OUT_ARG_pointers[] =
{
  &_gsd_remote_desktop_configuration_rdp_server_method_info_get_credentials_OUT_ARG_credentials.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_configuration_rdp_server_method_info_get_credentials =
{
  {
    -1,
    (gchar *) "GetCredentials",
    NULL,
    (GDBusArgInfo **) &_gsd_remote_desktop_configuration_rdp_server_method_info_get_credentials_OUT_ARG_pointers,
    NULL
  },
  "handle-get-credentials",
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_configuration_rdp_server_method_info_set_credentials_IN_ARG_credentials =
{
  {
    -1,
    (gchar *) "credentials",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_configuration_rdp_server_method_info_set_credentials_IN_ARG_pointers[] =
{
  &_gsd_remote_desktop_configuration_rdp_server_method_info_set_credentials_IN_ARG_credentials.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_configuration_rdp_server_method_info_set_credentials =
{
  {
    -1,
    (gchar *) "SetCredentials",
    (GDBusArgInfo **) &_gsd_remote_desktop_configuration_rdp_server_method_info_set_credentials_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-credentials",
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate_IN_ARG_Certificate =
{
  {
    -1,
    (gchar *) "Certificate",
    (gchar *) "(sh)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate_IN_ARG_PrivateKey =
{
  {
    -1,
    (gchar *) "PrivateKey",
    (gchar *) "(sh)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate_IN_ARG_pointers[] =
{
  &_gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate_IN_ARG_Certificate.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate_IN_ARG_PrivateKey.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate =
{
  {
    -1,
    (gchar *) "ImportCertificate",
    (GDBusArgInfo **) &_gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-import-certificate",
  TRUE
};

static const GDBusMethodInfo * const _gsd_remote_desktop_configuration_rdp_server_method_info_pointers[] =
{
  &_gsd_remote_desktop_configuration_rdp_server_method_info_enable.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_method_info_disable.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_method_info_get_credentials.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_method_info_set_credentials.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_method_info_import_certificate.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_configuration_rdp_server_property_info_enabled =
{
  {
    -1,
    (gchar *) "Enabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_configuration_rdp_server_property_info_port =
{
  {
    -1,
    (gchar *) "Port",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_configuration_rdp_server_property_info_tls_cert =
{
  {
    -1,
    (gchar *) "TlsCert",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tls-cert",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_configuration_rdp_server_property_info_tls_fingerprint =
{
  {
    -1,
    (gchar *) "TlsFingerprint",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tls-fingerprint",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_configuration_rdp_server_property_info_tls_key =
{
  {
    -1,
    (gchar *) "TlsKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tls-key",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gsd_remote_desktop_configuration_rdp_server_property_info_pointers[] =
{
  &_gsd_remote_desktop_configuration_rdp_server_property_info_enabled.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_property_info_port.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_property_info_tls_cert.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_property_info_tls_fingerprint.parent_struct,
  &_gsd_remote_desktop_configuration_rdp_server_property_info_tls_key.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gsd_remote_desktop_configuration_rdp_server_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.RemoteDesktop.Configuration.Rdp.Server",
    (GDBusMethodInfo **) &_gsd_remote_desktop_configuration_rdp_server_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_gsd_remote_desktop_configuration_rdp_server_property_info_pointers,
    NULL
  },
  "remote-desktop-configuration-rdp-server",
};


/**
 * gsd_remote_desktop_configuration_rdp_server_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gsd_remote_desktop_configuration_rdp_server_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsdRemoteDesktopConfigurationRdpServer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gsd_remote_desktop_configuration_rdp_server_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "enabled");
  g_object_class_override_property (klass, property_id_begin++, "port");
  g_object_class_override_property (klass, property_id_begin++, "tls-cert");
  g_object_class_override_property (klass, property_id_begin++, "tls-fingerprint");
  g_object_class_override_property (klass, property_id_begin++, "tls-key");
  return property_id_begin - 1;
}


inline static void
gsd_remote_desktop_configuration_rdp_server_method_marshal_enable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_configuration_rdp_server_method_marshal_disable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_configuration_rdp_server_method_marshal_get_credentials (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_configuration_rdp_server_method_marshal_set_credentials (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_configuration_rdp_server_method_marshal_import_certificate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GsdRemoteDesktopConfigurationRdpServer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link>.
 */

/**
 * GsdRemoteDesktopConfigurationRdpServerIface:
 * @parent_iface: The parent interface.
 * @handle_disable: Handler for the #GsdRemoteDesktopConfigurationRdpServer::handle-disable signal.
 * @handle_enable: Handler for the #GsdRemoteDesktopConfigurationRdpServer::handle-enable signal.
 * @handle_get_credentials: Handler for the #GsdRemoteDesktopConfigurationRdpServer::handle-get-credentials signal.
 * @handle_import_certificate: Handler for the #GsdRemoteDesktopConfigurationRdpServer::handle-import-certificate signal.
 * @handle_set_credentials: Handler for the #GsdRemoteDesktopConfigurationRdpServer::handle-set-credentials signal.
 * @get_enabled: Getter for the #GsdRemoteDesktopConfigurationRdpServer:enabled property.
 * @get_port: Getter for the #GsdRemoteDesktopConfigurationRdpServer:port property.
 * @get_tls_cert: Getter for the #GsdRemoteDesktopConfigurationRdpServer:tls-cert property.
 * @get_tls_fingerprint: Getter for the #GsdRemoteDesktopConfigurationRdpServer:tls-fingerprint property.
 * @get_tls_key: Getter for the #GsdRemoteDesktopConfigurationRdpServer:tls-key property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link>.
 */

typedef GsdRemoteDesktopConfigurationRdpServerIface GsdRemoteDesktopConfigurationRdpServerInterface;
G_DEFINE_INTERFACE (GsdRemoteDesktopConfigurationRdpServer, gsd_remote_desktop_configuration_rdp_server, G_TYPE_OBJECT)

static void
gsd_remote_desktop_configuration_rdp_server_default_init (GsdRemoteDesktopConfigurationRdpServerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GsdRemoteDesktopConfigurationRdpServer::handle-enable:
   * @object: A #GsdRemoteDesktopConfigurationRdpServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enable">Enable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_configuration_rdp_server_complete_enable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopConfigurationRdpServerIface, handle_enable),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_configuration_rdp_server_method_marshal_enable,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GsdRemoteDesktopConfigurationRdpServer::handle-disable:
   * @object: A #GsdRemoteDesktopConfigurationRdpServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Disable">Disable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_configuration_rdp_server_complete_disable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopConfigurationRdpServerIface, handle_disable),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_configuration_rdp_server_method_marshal_disable,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GsdRemoteDesktopConfigurationRdpServer::handle-get-credentials:
   * @object: A #GsdRemoteDesktopConfigurationRdpServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.GetCredentials">GetCredentials()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_configuration_rdp_server_complete_get_credentials() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-credentials",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopConfigurationRdpServerIface, handle_get_credentials),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_configuration_rdp_server_method_marshal_get_credentials,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GsdRemoteDesktopConfigurationRdpServer::handle-set-credentials:
   * @object: A #GsdRemoteDesktopConfigurationRdpServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_credentials: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.SetCredentials">SetCredentials()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_configuration_rdp_server_complete_set_credentials() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-credentials",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopConfigurationRdpServerIface, handle_set_credentials),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_configuration_rdp_server_method_marshal_set_credentials,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GsdRemoteDesktopConfigurationRdpServer::handle-import-certificate:
   * @object: A #GsdRemoteDesktopConfigurationRdpServer.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_Certificate: Argument passed by remote caller.
   * @arg_PrivateKey: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.ImportCertificate">ImportCertificate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_configuration_rdp_server_complete_import_certificate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-import-certificate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopConfigurationRdpServerIface, handle_import_certificate),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_configuration_rdp_server_method_marshal_import_certificate,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * GsdRemoteDesktopConfigurationRdpServer:enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enabled">"Enabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("enabled", "Enabled", "Enabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopConfigurationRdpServer:port:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Port">"Port"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("port", "Port", "Port", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopConfigurationRdpServer:tls-cert:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsCert">"TlsCert"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tls-cert", "TlsCert", "TlsCert", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopConfigurationRdpServer:tls-fingerprint:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tls-fingerprint", "TlsFingerprint", "TlsFingerprint", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopConfigurationRdpServer:tls-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsKey">"TlsKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tls-key", "TlsKey", "TlsKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gsd_remote_desktop_configuration_rdp_server_get_enabled: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enabled">"Enabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_configuration_rdp_server_get_enabled (GsdRemoteDesktopConfigurationRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_GET_IFACE (object)->get_enabled (object);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_set_enabled: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enabled">"Enabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_configuration_rdp_server_set_enabled (GsdRemoteDesktopConfigurationRdpServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "enabled", value, NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_get_port: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Port">"Port"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
gsd_remote_desktop_configuration_rdp_server_get_port (GsdRemoteDesktopConfigurationRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (object), 0);

  return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_GET_IFACE (object)->get_port (object);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_set_port: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Port">"Port"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_configuration_rdp_server_set_port (GsdRemoteDesktopConfigurationRdpServer *object, gint value)
{
  g_object_set (G_OBJECT (object), "port", value, NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_get_tls_cert: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsCert">"TlsCert"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_configuration_rdp_server_dup_tls_cert() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_configuration_rdp_server_get_tls_cert (GsdRemoteDesktopConfigurationRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_GET_IFACE (object)->get_tls_cert (object);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_dup_tls_cert: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsCert">"TlsCert"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_configuration_rdp_server_dup_tls_cert (GsdRemoteDesktopConfigurationRdpServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tls-cert", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_set_tls_cert: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsCert">"TlsCert"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_configuration_rdp_server_set_tls_cert (GsdRemoteDesktopConfigurationRdpServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tls-cert", value, NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_get_tls_fingerprint: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_configuration_rdp_server_dup_tls_fingerprint() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_configuration_rdp_server_get_tls_fingerprint (GsdRemoteDesktopConfigurationRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_GET_IFACE (object)->get_tls_fingerprint (object);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_dup_tls_fingerprint: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_configuration_rdp_server_dup_tls_fingerprint (GsdRemoteDesktopConfigurationRdpServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tls-fingerprint", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_set_tls_fingerprint: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsFingerprint">"TlsFingerprint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_configuration_rdp_server_set_tls_fingerprint (GsdRemoteDesktopConfigurationRdpServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tls-fingerprint", value, NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_get_tls_key: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsKey">"TlsKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_configuration_rdp_server_dup_tls_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_configuration_rdp_server_get_tls_key (GsdRemoteDesktopConfigurationRdpServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_GET_IFACE (object)->get_tls_key (object);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_dup_tls_key: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsKey">"TlsKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_configuration_rdp_server_dup_tls_key (GsdRemoteDesktopConfigurationRdpServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tls-key", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_set_tls_key: (skip)
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Configuration-Rdp-Server.TlsKey">"TlsKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_configuration_rdp_server_set_tls_key (GsdRemoteDesktopConfigurationRdpServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tls-key", value, NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_enable:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enable">Enable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_call_enable_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_enable_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_configuration_rdp_server_call_enable (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_enable_finish:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_call_enable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_call_enable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_enable_finish (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_enable_sync:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enable">Enable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_enable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_enable_sync (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_disable:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Disable">Disable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_call_disable_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_disable_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_configuration_rdp_server_call_disable (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_disable_finish:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_call_disable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_call_disable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_disable_finish (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_disable_sync:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Disable">Disable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_disable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_disable_sync (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_get_credentials:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.GetCredentials">GetCredentials()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_call_get_credentials_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_get_credentials_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_configuration_rdp_server_call_get_credentials (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCredentials",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_get_credentials_finish:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @out_credentials: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_call_get_credentials().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_call_get_credentials().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_get_credentials_finish (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GVariant **out_credentials,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_credentials);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_get_credentials_sync:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @out_credentials: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.GetCredentials">GetCredentials()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_get_credentials() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_get_credentials_sync (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GVariant **out_credentials,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCredentials",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_credentials);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_set_credentials:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.SetCredentials">SetCredentials()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_call_set_credentials_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_set_credentials_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_configuration_rdp_server_call_set_credentials (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GVariant *arg_credentials,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCredentials",
    g_variant_new ("(@a{sv})",
                   arg_credentials),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_set_credentials_finish:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_call_set_credentials().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_call_set_credentials().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_set_credentials_finish (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_set_credentials_sync:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.SetCredentials">SetCredentials()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_set_credentials() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_set_credentials_sync (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GVariant *arg_credentials,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCredentials",
    g_variant_new ("(@a{sv})",
                   arg_credentials),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_import_certificate:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @arg_Certificate: Argument to pass with the method invocation.
 * @arg_PrivateKey: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.ImportCertificate">ImportCertificate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_call_import_certificate_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_import_certificate_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_configuration_rdp_server_call_import_certificate (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GVariant *arg_Certificate,
    GVariant *arg_PrivateKey,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "ImportCertificate",
    g_variant_new ("(@(sh)@(sh))",
                   arg_Certificate,
                   arg_PrivateKey),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_import_certificate_finish:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_call_import_certificate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_call_import_certificate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_import_certificate_finish (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_call_import_certificate_sync:
 * @proxy: A #GsdRemoteDesktopConfigurationRdpServerProxy.
 * @arg_Certificate: Argument to pass with the method invocation.
 * @arg_PrivateKey: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.ImportCertificate">ImportCertificate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_call_import_certificate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_configuration_rdp_server_call_import_certificate_sync (
    GsdRemoteDesktopConfigurationRdpServer *proxy,
    GVariant *arg_Certificate,
    GVariant *arg_PrivateKey,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "ImportCertificate",
    g_variant_new ("(@(sh)@(sh))",
                   arg_Certificate,
                   arg_PrivateKey),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_complete_enable:
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Enable">Enable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_configuration_rdp_server_complete_enable (
    GsdRemoteDesktopConfigurationRdpServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gsd_remote_desktop_configuration_rdp_server_complete_disable:
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.Disable">Disable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_configuration_rdp_server_complete_disable (
    GsdRemoteDesktopConfigurationRdpServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gsd_remote_desktop_configuration_rdp_server_complete_get_credentials:
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @credentials: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.GetCredentials">GetCredentials()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_configuration_rdp_server_complete_get_credentials (
    GsdRemoteDesktopConfigurationRdpServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *credentials)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   credentials));
}

/**
 * gsd_remote_desktop_configuration_rdp_server_complete_set_credentials:
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.SetCredentials">SetCredentials()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_configuration_rdp_server_complete_set_credentials (
    GsdRemoteDesktopConfigurationRdpServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gsd_remote_desktop_configuration_rdp_server_complete_import_certificate:
 * @object: A #GsdRemoteDesktopConfigurationRdpServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Configuration-Rdp-Server.ImportCertificate">ImportCertificate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_configuration_rdp_server_complete_import_certificate (
    GsdRemoteDesktopConfigurationRdpServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopConfigurationRdpServerProxy:
 *
 * The #GsdRemoteDesktopConfigurationRdpServerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopConfigurationRdpServerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopConfigurationRdpServerProxy.
 */

struct _GsdRemoteDesktopConfigurationRdpServerProxyPrivate
{
  GData *qdata;
};

static void gsd_remote_desktop_configuration_rdp_server_proxy_iface_init (GsdRemoteDesktopConfigurationRdpServerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopConfigurationRdpServerProxy, gsd_remote_desktop_configuration_rdp_server_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsdRemoteDesktopConfigurationRdpServerProxy)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER, gsd_remote_desktop_configuration_rdp_server_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopConfigurationRdpServerProxy, gsd_remote_desktop_configuration_rdp_server_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER, gsd_remote_desktop_configuration_rdp_server_proxy_iface_init))

#endif
static void
gsd_remote_desktop_configuration_rdp_server_proxy_finalize (GObject *object)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gsd_remote_desktop_configuration_rdp_server_proxy_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_configuration_rdp_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.RemoteDesktop.Configuration.Rdp.Server: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_configuration_rdp_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.RemoteDesktop.Configuration.Rdp.Server", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gsd_remote_desktop_configuration_rdp_server_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
gsd_remote_desktop_configuration_rdp_server_proxy_get_enabled (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Enabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
gsd_remote_desktop_configuration_rdp_server_proxy_get_port (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Port");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_configuration_rdp_server_proxy_get_tls_cert (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TlsCert");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_configuration_rdp_server_proxy_get_tls_fingerprint (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TlsFingerprint");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_configuration_rdp_server_proxy_get_tls_key (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerProxy *proxy = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TlsKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_init (GsdRemoteDesktopConfigurationRdpServerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gsd_remote_desktop_configuration_rdp_server_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY, GsdRemoteDesktopConfigurationRdpServerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gsd_remote_desktop_configuration_rdp_server_interface_info ());
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_class_init (GsdRemoteDesktopConfigurationRdpServerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gsd_remote_desktop_configuration_rdp_server_proxy_finalize;
  gobject_class->get_property = gsd_remote_desktop_configuration_rdp_server_proxy_get_property;
  gobject_class->set_property = gsd_remote_desktop_configuration_rdp_server_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gsd_remote_desktop_configuration_rdp_server_proxy_g_signal;
  proxy_class->g_properties_changed = gsd_remote_desktop_configuration_rdp_server_proxy_g_properties_changed;

  gsd_remote_desktop_configuration_rdp_server_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopConfigurationRdpServerProxyPrivate));
#endif
}

static void
gsd_remote_desktop_configuration_rdp_server_proxy_iface_init (GsdRemoteDesktopConfigurationRdpServerIface *iface)
{
  iface->get_enabled = gsd_remote_desktop_configuration_rdp_server_proxy_get_enabled;
  iface->get_port = gsd_remote_desktop_configuration_rdp_server_proxy_get_port;
  iface->get_tls_cert = gsd_remote_desktop_configuration_rdp_server_proxy_get_tls_cert;
  iface->get_tls_fingerprint = gsd_remote_desktop_configuration_rdp_server_proxy_get_tls_fingerprint;
  iface->get_tls_key = gsd_remote_desktop_configuration_rdp_server_proxy_get_tls_key;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_proxy_new_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_configuration_rdp_server_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Configuration.Rdp.Server", NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_proxy_new().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopConfigurationRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopConfigurationRdpServer *
gsd_remote_desktop_configuration_rdp_server_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopConfigurationRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopConfigurationRdpServer *
gsd_remote_desktop_configuration_rdp_server_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Configuration.Rdp.Server", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (ret);
  else
    return NULL;
}


/**
 * gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gsd_remote_desktop_configuration_rdp_server_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Configuration.Rdp.Server", NULL);
}

/**
 * gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopConfigurationRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopConfigurationRdpServer *
gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gsd_remote_desktop_configuration_rdp_server_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopConfigurationRdpServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopConfigurationRdpServer *
gsd_remote_desktop_configuration_rdp_server_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Configuration.Rdp.Server", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopConfigurationRdpServerSkeleton:
 *
 * The #GsdRemoteDesktopConfigurationRdpServerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopConfigurationRdpServerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopConfigurationRdpServerSkeleton.
 */

struct _GsdRemoteDesktopConfigurationRdpServerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gsd_remote_desktop_configuration_rdp_server_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gsd_remote_desktop_configuration_rdp_server_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gsd_remote_desktop_configuration_rdp_server_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gsd_remote_desktop_configuration_rdp_server_skeleton_vtable =
{
  _gsd_remote_desktop_configuration_rdp_server_skeleton_handle_method_call,
  _gsd_remote_desktop_configuration_rdp_server_skeleton_handle_get_property,
  _gsd_remote_desktop_configuration_rdp_server_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gsd_remote_desktop_configuration_rdp_server_interface_info ();
}

static GDBusInterfaceVTable *
gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gsd_remote_desktop_configuration_rdp_server_skeleton_vtable;
}

static GVariant *
gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gsd_remote_desktop_configuration_rdp_server_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gsd_remote_desktop_configuration_rdp_server_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Configuration.Rdp.Server", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gsd_remote_desktop_configuration_rdp_server_emit_changed (gpointer user_data);

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gsd_remote_desktop_configuration_rdp_server_emit_changed (skeleton);
}

static void gsd_remote_desktop_configuration_rdp_server_skeleton_iface_init (GsdRemoteDesktopConfigurationRdpServerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopConfigurationRdpServerSkeleton, gsd_remote_desktop_configuration_rdp_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsdRemoteDesktopConfigurationRdpServerSkeleton)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER, gsd_remote_desktop_configuration_rdp_server_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopConfigurationRdpServerSkeleton, gsd_remote_desktop_configuration_rdp_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER, gsd_remote_desktop_configuration_rdp_server_skeleton_iface_init))

#endif
static void
gsd_remote_desktop_configuration_rdp_server_skeleton_finalize (GObject *object)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gsd_remote_desktop_configuration_rdp_server_skeleton_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gsd_remote_desktop_configuration_rdp_server_emit_changed (gpointer user_data)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.RemoteDesktop.Configuration.Rdp.Server",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gsd_remote_desktop_configuration_rdp_server_schedule_emit_changed (GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gsd_remote_desktop_configuration_rdp_server_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gsd_remote_desktop_configuration_rdp_server_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_configuration_rdp_server_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gsd_remote_desktop_configuration_rdp_server_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_init (GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gsd_remote_desktop_configuration_rdp_server_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON, GsdRemoteDesktopConfigurationRdpServerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
}

static gboolean 
gsd_remote_desktop_configuration_rdp_server_skeleton_get_enabled (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
gsd_remote_desktop_configuration_rdp_server_skeleton_get_port (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_configuration_rdp_server_skeleton_get_tls_cert (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_configuration_rdp_server_skeleton_get_tls_fingerprint (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_configuration_rdp_server_skeleton_get_tls_key (GsdRemoteDesktopConfigurationRdpServer *object)
{
  GsdRemoteDesktopConfigurationRdpServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_class_init (GsdRemoteDesktopConfigurationRdpServerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gsd_remote_desktop_configuration_rdp_server_skeleton_finalize;
  gobject_class->get_property = gsd_remote_desktop_configuration_rdp_server_skeleton_get_property;
  gobject_class->set_property = gsd_remote_desktop_configuration_rdp_server_skeleton_set_property;
  gobject_class->notify       = gsd_remote_desktop_configuration_rdp_server_skeleton_notify;


  gsd_remote_desktop_configuration_rdp_server_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gsd_remote_desktop_configuration_rdp_server_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopConfigurationRdpServerSkeletonPrivate));
#endif
}

static void
gsd_remote_desktop_configuration_rdp_server_skeleton_iface_init (GsdRemoteDesktopConfigurationRdpServerIface *iface)
{
  iface->get_enabled = gsd_remote_desktop_configuration_rdp_server_skeleton_get_enabled;
  iface->get_port = gsd_remote_desktop_configuration_rdp_server_skeleton_get_port;
  iface->get_tls_cert = gsd_remote_desktop_configuration_rdp_server_skeleton_get_tls_cert;
  iface->get_tls_fingerprint = gsd_remote_desktop_configuration_rdp_server_skeleton_get_tls_fingerprint;
  iface->get_tls_key = gsd_remote_desktop_configuration_rdp_server_skeleton_get_tls_key;
}

/**
 * gsd_remote_desktop_configuration_rdp_server_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Configuration-Rdp-Server.top_of_page">org.gnome.RemoteDesktop.Configuration.Rdp.Server</link>.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopConfigurationRdpServerSkeleton): The skeleton object.
 */
GsdRemoteDesktopConfigurationRdpServer *
gsd_remote_desktop_configuration_rdp_server_skeleton_new (void)
{
  return GSD_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER (g_object_new (GSD_TYPE_REMOTE_DESKTOP_CONFIGURATION_RDP_SERVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.RemoteDesktop.Vnc.Server
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsdRemoteDesktopVncServer
 * @title: GsdRemoteDesktopVncServer
 * @short_description: Generated C code for the org.gnome.RemoteDesktop.Vnc.Server D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.RemoteDesktop.Vnc.Server ---- */

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_vnc_server_property_info_enabled =
{
  {
    -1,
    (gchar *) "Enabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_vnc_server_property_info_port =
{
  {
    -1,
    (gchar *) "Port",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_vnc_server_property_info_negotiate_port =
{
  {
    -1,
    (gchar *) "NegotiatePort",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "negotiate-port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_vnc_server_property_info_auth_method =
{
  {
    -1,
    (gchar *) "AuthMethod",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "auth-method",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gsd_remote_desktop_vnc_server_property_info_view_only =
{
  {
    -1,
    (gchar *) "ViewOnly",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "view-only",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gsd_remote_desktop_vnc_server_property_info_pointers[] =
{
  &_gsd_remote_desktop_vnc_server_property_info_enabled.parent_struct,
  &_gsd_remote_desktop_vnc_server_property_info_port.parent_struct,
  &_gsd_remote_desktop_vnc_server_property_info_negotiate_port.parent_struct,
  &_gsd_remote_desktop_vnc_server_property_info_auth_method.parent_struct,
  &_gsd_remote_desktop_vnc_server_property_info_view_only.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gsd_remote_desktop_vnc_server_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.RemoteDesktop.Vnc.Server",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_gsd_remote_desktop_vnc_server_property_info_pointers,
    NULL
  },
  "remote-desktop-vnc-server",
};


/**
 * gsd_remote_desktop_vnc_server_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gsd_remote_desktop_vnc_server_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gsd_remote_desktop_vnc_server_interface_info.parent_struct;
}

/**
 * gsd_remote_desktop_vnc_server_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsdRemoteDesktopVncServer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gsd_remote_desktop_vnc_server_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "enabled");
  g_object_class_override_property (klass, property_id_begin++, "port");
  g_object_class_override_property (klass, property_id_begin++, "negotiate-port");
  g_object_class_override_property (klass, property_id_begin++, "auth-method");
  g_object_class_override_property (klass, property_id_begin++, "view-only");
  return property_id_begin - 1;
}



/**
 * GsdRemoteDesktopVncServer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link>.
 */

/**
 * GsdRemoteDesktopVncServerIface:
 * @parent_iface: The parent interface.
 * @get_auth_method: Getter for the #GsdRemoteDesktopVncServer:auth-method property.
 * @get_enabled: Getter for the #GsdRemoteDesktopVncServer:enabled property.
 * @get_negotiate_port: Getter for the #GsdRemoteDesktopVncServer:negotiate-port property.
 * @get_port: Getter for the #GsdRemoteDesktopVncServer:port property.
 * @get_view_only: Getter for the #GsdRemoteDesktopVncServer:view-only property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link>.
 */

typedef GsdRemoteDesktopVncServerIface GsdRemoteDesktopVncServerInterface;
G_DEFINE_INTERFACE (GsdRemoteDesktopVncServer, gsd_remote_desktop_vnc_server, G_TYPE_OBJECT)

static void
gsd_remote_desktop_vnc_server_default_init (GsdRemoteDesktopVncServerIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * GsdRemoteDesktopVncServer:enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.Enabled">"Enabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("enabled", "Enabled", "Enabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopVncServer:port:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.Port">"Port"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("port", "Port", "Port", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopVncServer:negotiate-port:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.NegotiatePort">"NegotiatePort"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("negotiate-port", "NegotiatePort", "NegotiatePort", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopVncServer:auth-method:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.AuthMethod">"AuthMethod"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("auth-method", "AuthMethod", "AuthMethod", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GsdRemoteDesktopVncServer:view-only:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.ViewOnly">"ViewOnly"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("view-only", "ViewOnly", "ViewOnly", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gsd_remote_desktop_vnc_server_get_enabled: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.Enabled">"Enabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_vnc_server_get_enabled (GsdRemoteDesktopVncServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_VNC_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_VNC_SERVER_GET_IFACE (object)->get_enabled (object);
}

/**
 * gsd_remote_desktop_vnc_server_set_enabled: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.Enabled">"Enabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_vnc_server_set_enabled (GsdRemoteDesktopVncServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "enabled", value, NULL);
}

/**
 * gsd_remote_desktop_vnc_server_get_port: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.Port">"Port"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
gsd_remote_desktop_vnc_server_get_port (GsdRemoteDesktopVncServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_VNC_SERVER (object), 0);

  return GSD_REMOTE_DESKTOP_VNC_SERVER_GET_IFACE (object)->get_port (object);
}

/**
 * gsd_remote_desktop_vnc_server_set_port: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.Port">"Port"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_vnc_server_set_port (GsdRemoteDesktopVncServer *object, gint value)
{
  g_object_set (G_OBJECT (object), "port", value, NULL);
}

/**
 * gsd_remote_desktop_vnc_server_get_negotiate_port: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.NegotiatePort">"NegotiatePort"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_vnc_server_get_negotiate_port (GsdRemoteDesktopVncServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_VNC_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_VNC_SERVER_GET_IFACE (object)->get_negotiate_port (object);
}

/**
 * gsd_remote_desktop_vnc_server_set_negotiate_port: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.NegotiatePort">"NegotiatePort"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_vnc_server_set_negotiate_port (GsdRemoteDesktopVncServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "negotiate-port", value, NULL);
}

/**
 * gsd_remote_desktop_vnc_server_get_auth_method: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.AuthMethod">"AuthMethod"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gsd_remote_desktop_vnc_server_dup_auth_method() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gsd_remote_desktop_vnc_server_get_auth_method (GsdRemoteDesktopVncServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_VNC_SERVER (object), NULL);

  return GSD_REMOTE_DESKTOP_VNC_SERVER_GET_IFACE (object)->get_auth_method (object);
}

/**
 * gsd_remote_desktop_vnc_server_dup_auth_method: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.AuthMethod">"AuthMethod"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gsd_remote_desktop_vnc_server_dup_auth_method (GsdRemoteDesktopVncServer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "auth-method", &value, NULL);
  return value;
}

/**
 * gsd_remote_desktop_vnc_server_set_auth_method: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.AuthMethod">"AuthMethod"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_vnc_server_set_auth_method (GsdRemoteDesktopVncServer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "auth-method", value, NULL);
}

/**
 * gsd_remote_desktop_vnc_server_get_view_only: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.ViewOnly">"ViewOnly"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gsd_remote_desktop_vnc_server_get_view_only (GsdRemoteDesktopVncServer *object)
{
  g_return_val_if_fail (GSD_IS_REMOTE_DESKTOP_VNC_SERVER (object), FALSE);

  return GSD_REMOTE_DESKTOP_VNC_SERVER_GET_IFACE (object)->get_view_only (object);
}

/**
 * gsd_remote_desktop_vnc_server_set_view_only: (skip)
 * @object: A #GsdRemoteDesktopVncServer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-RemoteDesktop-Vnc-Server.ViewOnly">"ViewOnly"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gsd_remote_desktop_vnc_server_set_view_only (GsdRemoteDesktopVncServer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "view-only", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopVncServerProxy:
 *
 * The #GsdRemoteDesktopVncServerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopVncServerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopVncServerProxy.
 */

struct _GsdRemoteDesktopVncServerProxyPrivate
{
  GData *qdata;
};

static void gsd_remote_desktop_vnc_server_proxy_iface_init (GsdRemoteDesktopVncServerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopVncServerProxy, gsd_remote_desktop_vnc_server_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsdRemoteDesktopVncServerProxy)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER, gsd_remote_desktop_vnc_server_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopVncServerProxy, gsd_remote_desktop_vnc_server_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER, gsd_remote_desktop_vnc_server_proxy_iface_init))

#endif
static void
gsd_remote_desktop_vnc_server_proxy_finalize (GObject *object)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gsd_remote_desktop_vnc_server_proxy_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_vnc_server_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_vnc_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gsd_remote_desktop_vnc_server_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.RemoteDesktop.Vnc.Server: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gsd_remote_desktop_vnc_server_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_vnc_server_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.RemoteDesktop.Vnc.Server", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gsd_remote_desktop_vnc_server_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gsd_remote_desktop_vnc_server_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gsd_remote_desktop_vnc_server_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gsd_remote_desktop_vnc_server_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_vnc_server_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_vnc_server_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
gsd_remote_desktop_vnc_server_proxy_get_enabled (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Enabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
gsd_remote_desktop_vnc_server_proxy_get_port (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Port");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gsd_remote_desktop_vnc_server_proxy_get_negotiate_port (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NegotiatePort");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gsd_remote_desktop_vnc_server_proxy_get_auth_method (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AuthMethod");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gsd_remote_desktop_vnc_server_proxy_get_view_only (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerProxy *proxy = GSD_REMOTE_DESKTOP_VNC_SERVER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ViewOnly");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gsd_remote_desktop_vnc_server_proxy_init (GsdRemoteDesktopVncServerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gsd_remote_desktop_vnc_server_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_PROXY, GsdRemoteDesktopVncServerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gsd_remote_desktop_vnc_server_interface_info ());
}

static void
gsd_remote_desktop_vnc_server_proxy_class_init (GsdRemoteDesktopVncServerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gsd_remote_desktop_vnc_server_proxy_finalize;
  gobject_class->get_property = gsd_remote_desktop_vnc_server_proxy_get_property;
  gobject_class->set_property = gsd_remote_desktop_vnc_server_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gsd_remote_desktop_vnc_server_proxy_g_signal;
  proxy_class->g_properties_changed = gsd_remote_desktop_vnc_server_proxy_g_properties_changed;

  gsd_remote_desktop_vnc_server_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopVncServerProxyPrivate));
#endif
}

static void
gsd_remote_desktop_vnc_server_proxy_iface_init (GsdRemoteDesktopVncServerIface *iface)
{
  iface->get_enabled = gsd_remote_desktop_vnc_server_proxy_get_enabled;
  iface->get_port = gsd_remote_desktop_vnc_server_proxy_get_port;
  iface->get_negotiate_port = gsd_remote_desktop_vnc_server_proxy_get_negotiate_port;
  iface->get_auth_method = gsd_remote_desktop_vnc_server_proxy_get_auth_method;
  iface->get_view_only = gsd_remote_desktop_vnc_server_proxy_get_view_only;
}

/**
 * gsd_remote_desktop_vnc_server_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_vnc_server_proxy_new_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_vnc_server_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_vnc_server_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Vnc.Server", NULL);
}

/**
 * gsd_remote_desktop_vnc_server_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_vnc_server_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_vnc_server_proxy_new().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopVncServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopVncServer *
gsd_remote_desktop_vnc_server_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_VNC_SERVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_vnc_server_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_vnc_server_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopVncServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopVncServer *
gsd_remote_desktop_vnc_server_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Vnc.Server", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_VNC_SERVER (ret);
  else
    return NULL;
}


/**
 * gsd_remote_desktop_vnc_server_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gsd_remote_desktop_vnc_server_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_vnc_server_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_vnc_server_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_vnc_server_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Vnc.Server", NULL);
}

/**
 * gsd_remote_desktop_vnc_server_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_vnc_server_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_vnc_server_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopVncServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopVncServer *
gsd_remote_desktop_vnc_server_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_VNC_SERVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_vnc_server_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gsd_remote_desktop_vnc_server_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_vnc_server_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopVncServerProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopVncServer *
gsd_remote_desktop_vnc_server_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Vnc.Server", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_VNC_SERVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopVncServerSkeleton:
 *
 * The #GsdRemoteDesktopVncServerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopVncServerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopVncServerSkeleton.
 */

struct _GsdRemoteDesktopVncServerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gsd_remote_desktop_vnc_server_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gsd_remote_desktop_vnc_server_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_vnc_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gsd_remote_desktop_vnc_server_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_vnc_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gsd_remote_desktop_vnc_server_skeleton_vtable =
{
  _gsd_remote_desktop_vnc_server_skeleton_handle_method_call,
  _gsd_remote_desktop_vnc_server_skeleton_handle_get_property,
  _gsd_remote_desktop_vnc_server_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gsd_remote_desktop_vnc_server_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gsd_remote_desktop_vnc_server_interface_info ();
}

static GDBusInterfaceVTable *
gsd_remote_desktop_vnc_server_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gsd_remote_desktop_vnc_server_skeleton_vtable;
}

static GVariant *
gsd_remote_desktop_vnc_server_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gsd_remote_desktop_vnc_server_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gsd_remote_desktop_vnc_server_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gsd_remote_desktop_vnc_server_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gsd_remote_desktop_vnc_server_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Vnc.Server", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gsd_remote_desktop_vnc_server_emit_changed (gpointer user_data);

static void
gsd_remote_desktop_vnc_server_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gsd_remote_desktop_vnc_server_emit_changed (skeleton);
}

static void gsd_remote_desktop_vnc_server_skeleton_iface_init (GsdRemoteDesktopVncServerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopVncServerSkeleton, gsd_remote_desktop_vnc_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsdRemoteDesktopVncServerSkeleton)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER, gsd_remote_desktop_vnc_server_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopVncServerSkeleton, gsd_remote_desktop_vnc_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER, gsd_remote_desktop_vnc_server_skeleton_iface_init))

#endif
static void
gsd_remote_desktop_vnc_server_skeleton_finalize (GObject *object)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gsd_remote_desktop_vnc_server_skeleton_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_vnc_server_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gsd_remote_desktop_vnc_server_emit_changed (gpointer user_data)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.RemoteDesktop.Vnc.Server",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gsd_remote_desktop_vnc_server_schedule_emit_changed (GsdRemoteDesktopVncServerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gsd_remote_desktop_vnc_server_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gsd_remote_desktop_vnc_server_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gsd_remote_desktop_vnc_server_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gsd_remote_desktop_vnc_server_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _gsd_remote_desktop_vnc_server_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gsd_remote_desktop_vnc_server_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gsd_remote_desktop_vnc_server_skeleton_init (GsdRemoteDesktopVncServerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gsd_remote_desktop_vnc_server_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_SKELETON, GsdRemoteDesktopVncServerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
}

static gboolean 
gsd_remote_desktop_vnc_server_skeleton_get_enabled (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
gsd_remote_desktop_vnc_server_skeleton_get_port (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gsd_remote_desktop_vnc_server_skeleton_get_negotiate_port (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gsd_remote_desktop_vnc_server_skeleton_get_auth_method (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gsd_remote_desktop_vnc_server_skeleton_get_view_only (GsdRemoteDesktopVncServer *object)
{
  GsdRemoteDesktopVncServerSkeleton *skeleton = GSD_REMOTE_DESKTOP_VNC_SERVER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gsd_remote_desktop_vnc_server_skeleton_class_init (GsdRemoteDesktopVncServerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gsd_remote_desktop_vnc_server_skeleton_finalize;
  gobject_class->get_property = gsd_remote_desktop_vnc_server_skeleton_get_property;
  gobject_class->set_property = gsd_remote_desktop_vnc_server_skeleton_set_property;
  gobject_class->notify       = gsd_remote_desktop_vnc_server_skeleton_notify;


  gsd_remote_desktop_vnc_server_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gsd_remote_desktop_vnc_server_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gsd_remote_desktop_vnc_server_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gsd_remote_desktop_vnc_server_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gsd_remote_desktop_vnc_server_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopVncServerSkeletonPrivate));
#endif
}

static void
gsd_remote_desktop_vnc_server_skeleton_iface_init (GsdRemoteDesktopVncServerIface *iface)
{
  iface->get_enabled = gsd_remote_desktop_vnc_server_skeleton_get_enabled;
  iface->get_port = gsd_remote_desktop_vnc_server_skeleton_get_port;
  iface->get_negotiate_port = gsd_remote_desktop_vnc_server_skeleton_get_negotiate_port;
  iface->get_auth_method = gsd_remote_desktop_vnc_server_skeleton_get_auth_method;
  iface->get_view_only = gsd_remote_desktop_vnc_server_skeleton_get_view_only;
}

/**
 * gsd_remote_desktop_vnc_server_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Vnc-Server.top_of_page">org.gnome.RemoteDesktop.Vnc.Server</link>.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopVncServerSkeleton): The skeleton object.
 */
GsdRemoteDesktopVncServer *
gsd_remote_desktop_vnc_server_skeleton_new (void)
{
  return GSD_REMOTE_DESKTOP_VNC_SERVER (g_object_new (GSD_TYPE_REMOTE_DESKTOP_VNC_SERVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.RemoteDesktop.Rdp.Dispatcher
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsdRemoteDesktopRdpDispatcher
 * @title: GsdRemoteDesktopRdpDispatcher
 * @short_description: Generated C code for the org.gnome.RemoteDesktop.Rdp.Dispatcher D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.RemoteDesktop.Rdp.Dispatcher ---- */

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_dispatcher_method_info_request_handover_OUT_ARG_handover =
{
  {
    -1,
    (gchar *) "handover",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_dispatcher_method_info_request_handover_OUT_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_dispatcher_method_info_request_handover_OUT_ARG_handover.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_rdp_dispatcher_method_info_request_handover =
{
  {
    -1,
    (gchar *) "RequestHandover",
    NULL,
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_dispatcher_method_info_request_handover_OUT_ARG_pointers,
    NULL
  },
  "handle-request-handover",
  FALSE
};

static const GDBusMethodInfo * const _gsd_remote_desktop_rdp_dispatcher_method_info_pointers[] =
{
  &_gsd_remote_desktop_rdp_dispatcher_method_info_request_handover.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gsd_remote_desktop_rdp_dispatcher_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.RemoteDesktop.Rdp.Dispatcher",
    (GDBusMethodInfo **) &_gsd_remote_desktop_rdp_dispatcher_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "remote-desktop-rdp-dispatcher",
};


/**
 * gsd_remote_desktop_rdp_dispatcher_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gsd_remote_desktop_rdp_dispatcher_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct;
}

/**
 * gsd_remote_desktop_rdp_dispatcher_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsdRemoteDesktopRdpDispatcher interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gsd_remote_desktop_rdp_dispatcher_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gsd_remote_desktop_rdp_dispatcher_method_marshal_request_handover (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GsdRemoteDesktopRdpDispatcher:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link>.
 */

/**
 * GsdRemoteDesktopRdpDispatcherIface:
 * @parent_iface: The parent interface.
 * @handle_request_handover: Handler for the #GsdRemoteDesktopRdpDispatcher::handle-request-handover signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link>.
 */

typedef GsdRemoteDesktopRdpDispatcherIface GsdRemoteDesktopRdpDispatcherInterface;
G_DEFINE_INTERFACE (GsdRemoteDesktopRdpDispatcher, gsd_remote_desktop_rdp_dispatcher, G_TYPE_OBJECT)

static void
gsd_remote_desktop_rdp_dispatcher_default_init (GsdRemoteDesktopRdpDispatcherIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GsdRemoteDesktopRdpDispatcher::handle-request-handover:
   * @object: A #GsdRemoteDesktopRdpDispatcher.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Dispatcher.RequestHandover">RequestHandover()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_rdp_dispatcher_complete_request_handover() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-handover",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopRdpDispatcherIface, handle_request_handover),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_rdp_dispatcher_method_marshal_request_handover,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * gsd_remote_desktop_rdp_dispatcher_call_request_handover:
 * @proxy: A #GsdRemoteDesktopRdpDispatcherProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Dispatcher.RequestHandover">RequestHandover()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_dispatcher_call_request_handover_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_dispatcher_call_request_handover_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_rdp_dispatcher_call_request_handover (
    GsdRemoteDesktopRdpDispatcher *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestHandover",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_rdp_dispatcher_call_request_handover_finish:
 * @proxy: A #GsdRemoteDesktopRdpDispatcherProxy.
 * @out_handover: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_dispatcher_call_request_handover().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_dispatcher_call_request_handover().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_dispatcher_call_request_handover_finish (
    GsdRemoteDesktopRdpDispatcher *proxy,
    gchar **out_handover,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handover);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_dispatcher_call_request_handover_sync:
 * @proxy: A #GsdRemoteDesktopRdpDispatcherProxy.
 * @out_handover: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Dispatcher.RequestHandover">RequestHandover()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_dispatcher_call_request_handover() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_dispatcher_call_request_handover_sync (
    GsdRemoteDesktopRdpDispatcher *proxy,
    gchar **out_handover,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestHandover",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handover);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_dispatcher_complete_request_handover:
 * @object: A #GsdRemoteDesktopRdpDispatcher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handover: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Dispatcher.RequestHandover">RequestHandover()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_rdp_dispatcher_complete_request_handover (
    GsdRemoteDesktopRdpDispatcher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handover)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handover));
}

/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopRdpDispatcherProxy:
 *
 * The #GsdRemoteDesktopRdpDispatcherProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopRdpDispatcherProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopRdpDispatcherProxy.
 */

struct _GsdRemoteDesktopRdpDispatcherProxyPrivate
{
  GData *qdata;
};

static void gsd_remote_desktop_rdp_dispatcher_proxy_iface_init (GsdRemoteDesktopRdpDispatcherIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpDispatcherProxy, gsd_remote_desktop_rdp_dispatcher_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsdRemoteDesktopRdpDispatcherProxy)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER, gsd_remote_desktop_rdp_dispatcher_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpDispatcherProxy, gsd_remote_desktop_rdp_dispatcher_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER, gsd_remote_desktop_rdp_dispatcher_proxy_iface_init))

#endif
static void
gsd_remote_desktop_rdp_dispatcher_proxy_finalize (GObject *object)
{
  GsdRemoteDesktopRdpDispatcherProxy *proxy = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gsd_remote_desktop_rdp_dispatcher_proxy_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsdRemoteDesktopRdpDispatcherProxy *proxy = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_init (GsdRemoteDesktopRdpDispatcherProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gsd_remote_desktop_rdp_dispatcher_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY, GsdRemoteDesktopRdpDispatcherProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gsd_remote_desktop_rdp_dispatcher_interface_info ());
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_class_init (GsdRemoteDesktopRdpDispatcherProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gsd_remote_desktop_rdp_dispatcher_proxy_finalize;
  gobject_class->get_property = gsd_remote_desktop_rdp_dispatcher_proxy_get_property;
  gobject_class->set_property = gsd_remote_desktop_rdp_dispatcher_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gsd_remote_desktop_rdp_dispatcher_proxy_g_signal;
  proxy_class->g_properties_changed = gsd_remote_desktop_rdp_dispatcher_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopRdpDispatcherProxyPrivate));
#endif
}

static void
gsd_remote_desktop_rdp_dispatcher_proxy_iface_init (GsdRemoteDesktopRdpDispatcherIface *iface G_GNUC_UNUSED)
{
}

/**
 * gsd_remote_desktop_rdp_dispatcher_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_dispatcher_proxy_new_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_dispatcher_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_rdp_dispatcher_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Dispatcher", NULL);
}

/**
 * gsd_remote_desktop_rdp_dispatcher_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_dispatcher_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_dispatcher_proxy_new().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpDispatcherProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpDispatcher *
gsd_remote_desktop_rdp_dispatcher_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_DISPATCHER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_rdp_dispatcher_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_dispatcher_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpDispatcherProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpDispatcher *
gsd_remote_desktop_rdp_dispatcher_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Dispatcher", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_DISPATCHER (ret);
  else
    return NULL;
}


/**
 * gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gsd_remote_desktop_rdp_dispatcher_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Dispatcher", NULL);
}

/**
 * gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpDispatcherProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpDispatcher *
gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_DISPATCHER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gsd_remote_desktop_rdp_dispatcher_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpDispatcherProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpDispatcher *
gsd_remote_desktop_rdp_dispatcher_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Dispatcher", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_DISPATCHER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopRdpDispatcherSkeleton:
 *
 * The #GsdRemoteDesktopRdpDispatcherSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopRdpDispatcherSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopRdpDispatcherSkeleton.
 */

struct _GsdRemoteDesktopRdpDispatcherSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gsd_remote_desktop_rdp_dispatcher_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsdRemoteDesktopRdpDispatcherSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gsd_remote_desktop_rdp_dispatcher_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopRdpDispatcherSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gsd_remote_desktop_rdp_dispatcher_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopRdpDispatcherSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gsd_remote_desktop_rdp_dispatcher_skeleton_vtable =
{
  _gsd_remote_desktop_rdp_dispatcher_skeleton_handle_method_call,
  _gsd_remote_desktop_rdp_dispatcher_skeleton_handle_get_property,
  _gsd_remote_desktop_rdp_dispatcher_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gsd_remote_desktop_rdp_dispatcher_interface_info ();
}

static GDBusInterfaceVTable *
gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gsd_remote_desktop_rdp_dispatcher_skeleton_vtable;
}

static GVariant *
gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopRdpDispatcherSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gsd_remote_desktop_rdp_dispatcher_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gsd_remote_desktop_rdp_dispatcher_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Rdp.Dispatcher", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void gsd_remote_desktop_rdp_dispatcher_skeleton_iface_init (GsdRemoteDesktopRdpDispatcherIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpDispatcherSkeleton, gsd_remote_desktop_rdp_dispatcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsdRemoteDesktopRdpDispatcherSkeleton)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER, gsd_remote_desktop_rdp_dispatcher_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpDispatcherSkeleton, gsd_remote_desktop_rdp_dispatcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER, gsd_remote_desktop_rdp_dispatcher_skeleton_iface_init))

#endif
static void
gsd_remote_desktop_rdp_dispatcher_skeleton_finalize (GObject *object)
{
  GsdRemoteDesktopRdpDispatcherSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gsd_remote_desktop_rdp_dispatcher_skeleton_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_rdp_dispatcher_skeleton_init (GsdRemoteDesktopRdpDispatcherSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gsd_remote_desktop_rdp_dispatcher_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON, GsdRemoteDesktopRdpDispatcherSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gsd_remote_desktop_rdp_dispatcher_skeleton_class_init (GsdRemoteDesktopRdpDispatcherSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gsd_remote_desktop_rdp_dispatcher_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gsd_remote_desktop_rdp_dispatcher_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopRdpDispatcherSkeletonPrivate));
#endif
}

static void
gsd_remote_desktop_rdp_dispatcher_skeleton_iface_init (GsdRemoteDesktopRdpDispatcherIface *iface G_GNUC_UNUSED)
{
}

/**
 * gsd_remote_desktop_rdp_dispatcher_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Dispatcher.top_of_page">org.gnome.RemoteDesktop.Rdp.Dispatcher</link>.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpDispatcherSkeleton): The skeleton object.
 */
GsdRemoteDesktopRdpDispatcher *
gsd_remote_desktop_rdp_dispatcher_skeleton_new (void)
{
  return GSD_REMOTE_DESKTOP_RDP_DISPATCHER (g_object_new (GSD_TYPE_REMOTE_DESKTOP_RDP_DISPATCHER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.RemoteDesktop.Rdp.Handover
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsdRemoteDesktopRdpHandover
 * @title: GsdRemoteDesktopRdpHandover
 * @short_description: Generated C code for the org.gnome.RemoteDesktop.Rdp.Handover D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link> D-Bus interface in C.
 */

enum
{
  GSD__REMOTE_DESKTOP_RDP_HANDOVER_REDIRECT_CLIENT,
  GSD__REMOTE_DESKTOP_RDP_HANDOVER_TAKE_CLIENT_READY,
};

static unsigned GSD__REMOTE_DESKTOP_RDP_HANDOVER_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.gnome.RemoteDesktop.Rdp.Handover ---- */

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_start_handover_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_start_handover_IN_ARG_password =
{
  {
    -1,
    (gchar *) "password",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_handover_method_info_start_handover_IN_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_method_info_start_handover_IN_ARG_username.parent_struct,
  &_gsd_remote_desktop_rdp_handover_method_info_start_handover_IN_ARG_password.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_start_handover_OUT_ARG_certificate =
{
  {
    -1,
    (gchar *) "certificate",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_start_handover_OUT_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_handover_method_info_start_handover_OUT_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_method_info_start_handover_OUT_ARG_certificate.parent_struct,
  &_gsd_remote_desktop_rdp_handover_method_info_start_handover_OUT_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_rdp_handover_method_info_start_handover =
{
  {
    -1,
    (gchar *) "StartHandover",
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_handover_method_info_start_handover_IN_ARG_pointers,
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_handover_method_info_start_handover_OUT_ARG_pointers,
    NULL
  },
  "handle-start-handover",
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_take_client_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_handover_method_info_take_client_OUT_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_method_info_take_client_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_rdp_handover_method_info_take_client =
{
  {
    -1,
    (gchar *) "TakeClient",
    NULL,
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_handover_method_info_take_client_OUT_ARG_pointers,
    NULL
  },
  "handle-take-client",
  TRUE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_get_system_credentials_OUT_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_method_info_get_system_credentials_OUT_ARG_password =
{
  {
    -1,
    (gchar *) "password",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_handover_method_info_get_system_credentials_OUT_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_method_info_get_system_credentials_OUT_ARG_username.parent_struct,
  &_gsd_remote_desktop_rdp_handover_method_info_get_system_credentials_OUT_ARG_password.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gsd_remote_desktop_rdp_handover_method_info_get_system_credentials =
{
  {
    -1,
    (gchar *) "GetSystemCredentials",
    NULL,
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_handover_method_info_get_system_credentials_OUT_ARG_pointers,
    NULL
  },
  "handle-get-system-credentials",
  FALSE
};

static const GDBusMethodInfo * const _gsd_remote_desktop_rdp_handover_method_info_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_method_info_start_handover.parent_struct,
  &_gsd_remote_desktop_rdp_handover_method_info_take_client.parent_struct,
  &_gsd_remote_desktop_rdp_handover_method_info_get_system_credentials.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_routing_token =
{
  {
    -1,
    (gchar *) "routing_token",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_password =
{
  {
    -1,
    (gchar *) "password",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_routing_token.parent_struct,
  &_gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_username.parent_struct,
  &_gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_password.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gsd_remote_desktop_rdp_handover_signal_info_redirect_client =
{
  {
    -1,
    (gchar *) "RedirectClient",
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_handover_signal_info_redirect_client_ARG_pointers,
    NULL
  },
  "redirect-client"
};

static const _ExtendedGDBusArgInfo _gsd_remote_desktop_rdp_handover_signal_info_take_client_ready_ARG_use_system_credentials =
{
  {
    -1,
    (gchar *) "use_system_credentials",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gsd_remote_desktop_rdp_handover_signal_info_take_client_ready_ARG_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_signal_info_take_client_ready_ARG_use_system_credentials.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gsd_remote_desktop_rdp_handover_signal_info_take_client_ready =
{
  {
    -1,
    (gchar *) "TakeClientReady",
    (GDBusArgInfo **) &_gsd_remote_desktop_rdp_handover_signal_info_take_client_ready_ARG_pointers,
    NULL
  },
  "take-client-ready"
};

static const GDBusSignalInfo * const _gsd_remote_desktop_rdp_handover_signal_info_pointers[] =
{
  &_gsd_remote_desktop_rdp_handover_signal_info_redirect_client.parent_struct,
  &_gsd_remote_desktop_rdp_handover_signal_info_take_client_ready.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gsd_remote_desktop_rdp_handover_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.RemoteDesktop.Rdp.Handover",
    (GDBusMethodInfo **) &_gsd_remote_desktop_rdp_handover_method_info_pointers,
    (GDBusSignalInfo **) &_gsd_remote_desktop_rdp_handover_signal_info_pointers,
    NULL,
    NULL
  },
  "remote-desktop-rdp-handover",
};


/**
 * gsd_remote_desktop_rdp_handover_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gsd_remote_desktop_rdp_handover_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_handover_interface_info.parent_struct;
}

/**
 * gsd_remote_desktop_rdp_handover_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsdRemoteDesktopRdpHandover interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gsd_remote_desktop_rdp_handover_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gsd_remote_desktop_rdp_handover_signal_marshal_redirect_client (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_rdp_handover_signal_marshal_take_client_ready (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_rdp_handover_method_marshal_start_handover (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_rdp_handover_method_marshal_take_client (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gsd_remote_desktop_rdp_handover_method_marshal_get_system_credentials (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GsdRemoteDesktopRdpHandover:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link>.
 */

/**
 * GsdRemoteDesktopRdpHandoverIface:
 * @parent_iface: The parent interface.
 * @handle_get_system_credentials: Handler for the #GsdRemoteDesktopRdpHandover::handle-get-system-credentials signal.
 * @handle_start_handover: Handler for the #GsdRemoteDesktopRdpHandover::handle-start-handover signal.
 * @handle_take_client: Handler for the #GsdRemoteDesktopRdpHandover::handle-take-client signal.
 * @redirect_client: Handler for the #GsdRemoteDesktopRdpHandover::redirect-client signal.
 * @take_client_ready: Handler for the #GsdRemoteDesktopRdpHandover::take-client-ready signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link>.
 */

typedef GsdRemoteDesktopRdpHandoverIface GsdRemoteDesktopRdpHandoverInterface;
G_DEFINE_INTERFACE (GsdRemoteDesktopRdpHandover, gsd_remote_desktop_rdp_handover, G_TYPE_OBJECT)

static void
gsd_remote_desktop_rdp_handover_default_init (GsdRemoteDesktopRdpHandoverIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GsdRemoteDesktopRdpHandover::handle-start-handover:
   * @object: A #GsdRemoteDesktopRdpHandover.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   * @arg_password: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.StartHandover">StartHandover()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_rdp_handover_complete_start_handover() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-handover",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopRdpHandoverIface, handle_start_handover),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_rdp_handover_method_marshal_start_handover,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GsdRemoteDesktopRdpHandover::handle-take-client:
   * @object: A #GsdRemoteDesktopRdpHandover.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.TakeClient">TakeClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_rdp_handover_complete_take_client() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopRdpHandoverIface, handle_take_client),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_rdp_handover_method_marshal_take_client,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST);

  /**
   * GsdRemoteDesktopRdpHandover::handle-get-system-credentials:
   * @object: A #GsdRemoteDesktopRdpHandover.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.GetSystemCredentials">GetSystemCredentials()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gsd_remote_desktop_rdp_handover_complete_get_system_credentials() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-system-credentials",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsdRemoteDesktopRdpHandoverIface, handle_get_system_credentials),
    g_signal_accumulator_true_handled,
    NULL,
      gsd_remote_desktop_rdp_handover_method_marshal_get_system_credentials,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GsdRemoteDesktopRdpHandover::redirect-client:
   * @object: A #GsdRemoteDesktopRdpHandover.
   * @arg_routing_token: Argument.
   * @arg_username: Argument.
   * @arg_password: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-RemoteDesktop-Rdp-Handover.RedirectClient">"RedirectClient"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GSD__REMOTE_DESKTOP_RDP_HANDOVER_SIGNALS[GSD__REMOTE_DESKTOP_RDP_HANDOVER_REDIRECT_CLIENT] =
    g_signal_new ("redirect-client",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GsdRemoteDesktopRdpHandoverIface, redirect_client),
      NULL,
      NULL,
      gsd_remote_desktop_rdp_handover_signal_marshal_redirect_client,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GsdRemoteDesktopRdpHandover::take-client-ready:
   * @object: A #GsdRemoteDesktopRdpHandover.
   * @arg_use_system_credentials: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-RemoteDesktop-Rdp-Handover.TakeClientReady">"TakeClientReady"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GSD__REMOTE_DESKTOP_RDP_HANDOVER_SIGNALS[GSD__REMOTE_DESKTOP_RDP_HANDOVER_TAKE_CLIENT_READY] =
    g_signal_new ("take-client-ready",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GsdRemoteDesktopRdpHandoverIface, take_client_ready),
      NULL,
      NULL,
      gsd_remote_desktop_rdp_handover_signal_marshal_take_client_ready,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

}

/**
 * gsd_remote_desktop_rdp_handover_emit_redirect_client:
 * @object: A #GsdRemoteDesktopRdpHandover.
 * @arg_routing_token: Argument to pass with the signal.
 * @arg_username: Argument to pass with the signal.
 * @arg_password: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-RemoteDesktop-Rdp-Handover.RedirectClient">"RedirectClient"</link> D-Bus signal.
 */
void
gsd_remote_desktop_rdp_handover_emit_redirect_client (
    GsdRemoteDesktopRdpHandover *object,
    const gchar *arg_routing_token,
    const gchar *arg_username,
    const gchar *arg_password)
{
  g_signal_emit (object, GSD__REMOTE_DESKTOP_RDP_HANDOVER_SIGNALS[GSD__REMOTE_DESKTOP_RDP_HANDOVER_REDIRECT_CLIENT], 0, arg_routing_token, arg_username, arg_password);
}

/**
 * gsd_remote_desktop_rdp_handover_emit_take_client_ready:
 * @object: A #GsdRemoteDesktopRdpHandover.
 * @arg_use_system_credentials: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-RemoteDesktop-Rdp-Handover.TakeClientReady">"TakeClientReady"</link> D-Bus signal.
 */
void
gsd_remote_desktop_rdp_handover_emit_take_client_ready (
    GsdRemoteDesktopRdpHandover *object,
    gboolean arg_use_system_credentials)
{
  g_signal_emit (object, GSD__REMOTE_DESKTOP_RDP_HANDOVER_SIGNALS[GSD__REMOTE_DESKTOP_RDP_HANDOVER_TAKE_CLIENT_READY], 0, arg_use_system_credentials);
}

/**
 * gsd_remote_desktop_rdp_handover_call_start_handover:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @arg_password: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.StartHandover">StartHandover()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_handover_call_start_handover_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_handover_call_start_handover_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_rdp_handover_call_start_handover (
    GsdRemoteDesktopRdpHandover *proxy,
    const gchar *arg_username,
    const gchar *arg_password,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartHandover",
    g_variant_new ("(ss)",
                   arg_username,
                   arg_password),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_rdp_handover_call_start_handover_finish:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @out_certificate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_key: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_handover_call_start_handover().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_handover_call_start_handover().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_handover_call_start_handover_finish (
    GsdRemoteDesktopRdpHandover *proxy,
    gchar **out_certificate,
    gchar **out_key,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_certificate,
                 out_key);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_call_start_handover_sync:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @arg_password: Argument to pass with the method invocation.
 * @out_certificate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_key: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.StartHandover">StartHandover()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_handover_call_start_handover() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_handover_call_start_handover_sync (
    GsdRemoteDesktopRdpHandover *proxy,
    const gchar *arg_username,
    const gchar *arg_password,
    gchar **out_certificate,
    gchar **out_key,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartHandover",
    g_variant_new ("(ss)",
                   arg_username,
                   arg_password),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_certificate,
                 out_key);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_call_take_client:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.TakeClient">TakeClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_handover_call_take_client_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_handover_call_take_client_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_rdp_handover_call_take_client (
    GsdRemoteDesktopRdpHandover *proxy,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "TakeClient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_rdp_handover_call_take_client_finish:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_handover_call_take_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_handover_call_take_client().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_handover_call_take_client_finish (
    GsdRemoteDesktopRdpHandover *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_call_take_client_sync:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.TakeClient">TakeClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_handover_call_take_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_handover_call_take_client_sync (
    GsdRemoteDesktopRdpHandover *proxy,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "TakeClient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_call_get_system_credentials:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.GetSystemCredentials">GetSystemCredentials()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_handover_call_get_system_credentials_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_handover_call_get_system_credentials_sync() for the synchronous, blocking version of this method.
 */
void
gsd_remote_desktop_rdp_handover_call_get_system_credentials (
    GsdRemoteDesktopRdpHandover *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSystemCredentials",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gsd_remote_desktop_rdp_handover_call_get_system_credentials_finish:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @out_username: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_password: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_handover_call_get_system_credentials().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_handover_call_get_system_credentials().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_handover_call_get_system_credentials_finish (
    GsdRemoteDesktopRdpHandover *proxy,
    gchar **out_username,
    gchar **out_password,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_username,
                 out_password);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_call_get_system_credentials_sync:
 * @proxy: A #GsdRemoteDesktopRdpHandoverProxy.
 * @out_username: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_password: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.GetSystemCredentials">GetSystemCredentials()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_handover_call_get_system_credentials() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gsd_remote_desktop_rdp_handover_call_get_system_credentials_sync (
    GsdRemoteDesktopRdpHandover *proxy,
    gchar **out_username,
    gchar **out_password,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSystemCredentials",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_username,
                 out_password);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_complete_start_handover:
 * @object: A #GsdRemoteDesktopRdpHandover.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @certificate: Parameter to return.
 * @key: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.StartHandover">StartHandover()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_rdp_handover_complete_start_handover (
    GsdRemoteDesktopRdpHandover *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *certificate,
    const gchar *key)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   certificate,
                   key));
}

/**
 * gsd_remote_desktop_rdp_handover_complete_take_client:
 * @object: A #GsdRemoteDesktopRdpHandover.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.TakeClient">TakeClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_rdp_handover_complete_take_client (
    GsdRemoteDesktopRdpHandover *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * gsd_remote_desktop_rdp_handover_complete_get_system_credentials:
 * @object: A #GsdRemoteDesktopRdpHandover.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @username: Parameter to return.
 * @password: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-RemoteDesktop-Rdp-Handover.GetSystemCredentials">GetSystemCredentials()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gsd_remote_desktop_rdp_handover_complete_get_system_credentials (
    GsdRemoteDesktopRdpHandover *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *username,
    const gchar *password)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   username,
                   password));
}

/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopRdpHandoverProxy:
 *
 * The #GsdRemoteDesktopRdpHandoverProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopRdpHandoverProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopRdpHandoverProxy.
 */

struct _GsdRemoteDesktopRdpHandoverProxyPrivate
{
  GData *qdata;
};

static void gsd_remote_desktop_rdp_handover_proxy_iface_init (GsdRemoteDesktopRdpHandoverIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpHandoverProxy, gsd_remote_desktop_rdp_handover_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsdRemoteDesktopRdpHandoverProxy)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER, gsd_remote_desktop_rdp_handover_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpHandoverProxy, gsd_remote_desktop_rdp_handover_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER, gsd_remote_desktop_rdp_handover_proxy_iface_init))

#endif
static void
gsd_remote_desktop_rdp_handover_proxy_finalize (GObject *object)
{
  GsdRemoteDesktopRdpHandoverProxy *proxy = GSD_REMOTE_DESKTOP_RDP_HANDOVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gsd_remote_desktop_rdp_handover_proxy_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_rdp_handover_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gsd_remote_desktop_rdp_handover_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gsd_remote_desktop_rdp_handover_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_handover_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gsd_remote_desktop_rdp_handover_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsdRemoteDesktopRdpHandoverProxy *proxy = GSD_REMOTE_DESKTOP_RDP_HANDOVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_handover_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_handover_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gsd_remote_desktop_rdp_handover_proxy_init (GsdRemoteDesktopRdpHandoverProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gsd_remote_desktop_rdp_handover_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_PROXY, GsdRemoteDesktopRdpHandoverProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gsd_remote_desktop_rdp_handover_interface_info ());
}

static void
gsd_remote_desktop_rdp_handover_proxy_class_init (GsdRemoteDesktopRdpHandoverProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gsd_remote_desktop_rdp_handover_proxy_finalize;
  gobject_class->get_property = gsd_remote_desktop_rdp_handover_proxy_get_property;
  gobject_class->set_property = gsd_remote_desktop_rdp_handover_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gsd_remote_desktop_rdp_handover_proxy_g_signal;
  proxy_class->g_properties_changed = gsd_remote_desktop_rdp_handover_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopRdpHandoverProxyPrivate));
#endif
}

static void
gsd_remote_desktop_rdp_handover_proxy_iface_init (GsdRemoteDesktopRdpHandoverIface *iface G_GNUC_UNUSED)
{
}

/**
 * gsd_remote_desktop_rdp_handover_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_handover_proxy_new_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_handover_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_rdp_handover_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Handover", NULL);
}

/**
 * gsd_remote_desktop_rdp_handover_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_handover_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_handover_proxy_new().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpHandoverProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpHandover *
gsd_remote_desktop_rdp_handover_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_HANDOVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_handover_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpHandoverProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpHandover *
gsd_remote_desktop_rdp_handover_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Handover", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_HANDOVER (ret);
  else
    return NULL;
}


/**
 * gsd_remote_desktop_rdp_handover_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gsd_remote_desktop_rdp_handover_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gsd_remote_desktop_rdp_handover_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gsd_remote_desktop_rdp_handover_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gsd_remote_desktop_rdp_handover_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Handover", NULL);
}

/**
 * gsd_remote_desktop_rdp_handover_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gsd_remote_desktop_rdp_handover_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gsd_remote_desktop_rdp_handover_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpHandoverProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpHandover *
gsd_remote_desktop_rdp_handover_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_HANDOVER (ret);
  else
    return NULL;
}

/**
 * gsd_remote_desktop_rdp_handover_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gsd_remote_desktop_rdp_handover_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gsd_remote_desktop_rdp_handover_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpHandoverProxy): The constructed proxy object or %NULL if @error is set.
 */
GsdRemoteDesktopRdpHandover *
gsd_remote_desktop_rdp_handover_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.RemoteDesktop.Rdp.Handover", NULL);
  if (ret != NULL)
    return GSD_REMOTE_DESKTOP_RDP_HANDOVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsdRemoteDesktopRdpHandoverSkeleton:
 *
 * The #GsdRemoteDesktopRdpHandoverSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsdRemoteDesktopRdpHandoverSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsdRemoteDesktopRdpHandoverSkeleton.
 */

struct _GsdRemoteDesktopRdpHandoverSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gsd_remote_desktop_rdp_handover_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gsd_remote_desktop_rdp_handover_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_handover_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gsd_remote_desktop_rdp_handover_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gsd_remote_desktop_rdp_handover_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gsd_remote_desktop_rdp_handover_skeleton_vtable =
{
  _gsd_remote_desktop_rdp_handover_skeleton_handle_method_call,
  _gsd_remote_desktop_rdp_handover_skeleton_handle_get_property,
  _gsd_remote_desktop_rdp_handover_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gsd_remote_desktop_rdp_handover_interface_info ();
}

static GDBusInterfaceVTable *
gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gsd_remote_desktop_rdp_handover_skeleton_vtable;
}

static GVariant *
gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gsd_remote_desktop_rdp_handover_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gsd_remote_desktop_rdp_handover_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gsd_remote_desktop_rdp_handover_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gsd_remote_desktop_rdp_handover_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Rdp.Handover", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gsd_remote_desktop_rdp_handover_on_signal_redirect_client (
    GsdRemoteDesktopRdpHandover *object,
    const gchar *arg_routing_token,
    const gchar *arg_username,
    const gchar *arg_password)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sss)",
                   arg_routing_token,
                   arg_username,
                   arg_password));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Rdp.Handover", "RedirectClient",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gsd_remote_desktop_rdp_handover_on_signal_take_client_ready (
    GsdRemoteDesktopRdpHandover *object,
    gboolean arg_use_system_credentials)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_use_system_credentials));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.RemoteDesktop.Rdp.Handover", "TakeClientReady",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gsd_remote_desktop_rdp_handover_skeleton_iface_init (GsdRemoteDesktopRdpHandoverIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpHandoverSkeleton, gsd_remote_desktop_rdp_handover_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsdRemoteDesktopRdpHandoverSkeleton)
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER, gsd_remote_desktop_rdp_handover_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsdRemoteDesktopRdpHandoverSkeleton, gsd_remote_desktop_rdp_handover_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER, gsd_remote_desktop_rdp_handover_skeleton_iface_init))

#endif
static void
gsd_remote_desktop_rdp_handover_skeleton_finalize (GObject *object)
{
  GsdRemoteDesktopRdpHandoverSkeleton *skeleton = GSD_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gsd_remote_desktop_rdp_handover_skeleton_parent_class)->finalize (object);
}

static void
gsd_remote_desktop_rdp_handover_skeleton_init (GsdRemoteDesktopRdpHandoverSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gsd_remote_desktop_rdp_handover_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON, GsdRemoteDesktopRdpHandoverSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gsd_remote_desktop_rdp_handover_skeleton_class_init (GsdRemoteDesktopRdpHandoverSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gsd_remote_desktop_rdp_handover_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gsd_remote_desktop_rdp_handover_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsdRemoteDesktopRdpHandoverSkeletonPrivate));
#endif
}

static void
gsd_remote_desktop_rdp_handover_skeleton_iface_init (GsdRemoteDesktopRdpHandoverIface *iface)
{
  iface->redirect_client = _gsd_remote_desktop_rdp_handover_on_signal_redirect_client;
  iface->take_client_ready = _gsd_remote_desktop_rdp_handover_on_signal_take_client_ready;
}

/**
 * gsd_remote_desktop_rdp_handover_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-RemoteDesktop-Rdp-Handover.top_of_page">org.gnome.RemoteDesktop.Rdp.Handover</link>.
 *
 * Returns: (transfer full) (type GsdRemoteDesktopRdpHandoverSkeleton): The skeleton object.
 */
GsdRemoteDesktopRdpHandover *
gsd_remote_desktop_rdp_handover_skeleton_new (void)
{
  return GSD_REMOTE_DESKTOP_RDP_HANDOVER (g_object_new (GSD_TYPE_REMOTE_DESKTOP_RDP_HANDOVER_SKELETON, NULL));
}

