/*
 * File automatically generated by
 * gengen 1.4.3 by Lorenzo Bettini 
 * http://www.gnu.org/software/gengen
 */

#ifndef LUA_HEADER_GEN_CLASS_H
#define LUA_HEADER_GEN_CLASS_H

#include <string>
#include <iostream>

using std::string;
using std::ostream;

class lua_header_gen_class
{
 protected:
  string author;
  string externfunctions;
  string fields;
  string funbody;
  string genconv;
  string genstring;
  string othercomments;
  string package;
  string structname;
  string version;

 public:
  lua_header_gen_class()
  {
  }
  
  lua_header_gen_class(const string &_author, const string &_externfunctions, const string &_fields, const string &_funbody, const string &_genconv, const string &_genstring, const string &_othercomments, const string &_package, const string &_structname, const string &_version) :
    author (_author), externfunctions (_externfunctions), fields (_fields), funbody (_funbody), genconv (_genconv), genstring (_genstring), othercomments (_othercomments), package (_package), structname (_structname), version (_version)
  {
  }

  virtual ~lua_header_gen_class()
  {
  }

  static void
  generate_string(const string &s, ostream &stream, unsigned int indent)
  {
    if (!indent || s.find('\n') == string::npos)
      {
        stream << s;
        return;
      }

    string::size_type pos;
    string::size_type start = 0;
    string ind (indent, ' ');
    while ( (pos=s.find('\n', start)) != string::npos)
      {
        stream << s.substr (start, (pos+1)-start);
        start = pos+1;
        if (start+1 <= s.size ())
          stream << ind;
      }
    if (start+1 <= s.size ())
      stream << s.substr (start);
  }

  void set_author(const string &_author)
  {
    author = _author;
  }

  virtual void generate_externfunctions(ostream &stream, unsigned int indent) = 0;

  void set_externfunctions(const string &_externfunctions)
  {
    externfunctions = _externfunctions;
  }

  virtual void generate_fields(ostream &stream, unsigned int indent) = 0;

  void set_fields(const string &_fields)
  {
    fields = _fields;
  }

  virtual void generate_funbody(ostream &stream, unsigned int indent) = 0;

  void set_funbody(const string &_funbody)
  {
    funbody = _funbody;
  }

  virtual void generate_genconv(ostream &stream, unsigned int indent) = 0;

  void set_genconv(const string &_genconv)
  {
    genconv = _genconv;
  }

  virtual void generate_genstring(ostream &stream, unsigned int indent) = 0;

  void set_genstring(const string &_genstring)
  {
    genstring = _genstring;
  }

  void set_othercomments(const string &_othercomments)
  {
    othercomments = _othercomments;
  }

  void set_package(const string &_package)
  {
    package = _package;
  }

  void set_structname(const string &_structname)
  {
    structname = _structname;
  }

  void set_version(const string &_version)
  {
    version = _version;
  }

  void generate_lua_header(ostream &stream, unsigned int indent = 0)
  {
    string indent_str (indent, ' ');
    indent = 0;
  
    stream << "\n";
    stream << indent_str;
    stream << "--[[";
    stream << "\n";
    stream << indent_str;
    stream << "    File automatically generated by";
    stream << "\n";
    stream << indent_str;
    indent = 4;
    stream << "    ";
    stream << package;
    stream << " ";
    stream << version;
    stream << " ";
    stream << author;
    indent = 0;
    stream << "\n";
    stream << indent_str;
    indent = 4;
    stream << "    ";
    stream << othercomments;
    indent = 0;
    stream << "\n";
    stream << indent_str;
    stream << "--]]";
    stream << "\n";
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
    stream << "-- Field table";
    stream << "\n";
    stream << indent_str;
    stream << structname;
    stream << " = {";
    stream << "\n";
    stream << indent_str;
    indent = 2;
    if (fields.size () > 0)
      generate_string (fields, stream, indent + indent_str.length ());
    else
      generate_fields (stream, indent + indent_str.length ());
    indent = 0;
    stream << indent_str;
    stream << "}";
    stream << "\n";
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
    if (externfunctions.size () > 0)
      generate_string (externfunctions, stream, indent + indent_str.length ());
    else
      generate_externfunctions (stream, indent + indent_str.length ());
    stream << indent_str;
    if (genstring.size () > 0)
      generate_string (genstring, stream, indent + indent_str.length ());
    else
      generate_genstring (stream, indent + indent_str.length ());
    stream << indent_str;
    if (genconv.size () > 0)
      generate_string (genconv, stream, indent + indent_str.length ());
    else
      generate_genconv (stream, indent + indent_str.length ());
    stream << indent_str;
    if (funbody.size () > 0)
      generate_string (funbody, stream, indent + indent_str.length ());
    else
      generate_funbody (stream, indent + indent_str.length ());
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
  }
};

#endif // LUA_HEADER_GEN_CLASS_H
