/* mime-data-format.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from mime-data-format.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static gboolean _vala_char_array_contains (gchar * stack,
                                    gssize stack_length,
                                    const gchar needle);

const gchar GEARY_MIME_DATA_FORMAT_CONTENT_TYPE_TOKEN_SPECIALS[15] = {'(', ')', '<', '>', '@', ',', ';', ':', '\\', '"', '/', '[', ']', '?', '='};

 G_GNUC_NO_INLINE static GType
geary_mime_data_format_encoding_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_REQUIRED, "GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_REQUIRED", "quoting-required"}, {GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_OPTIONAL, "GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_OPTIONAL", "quoting-optional"}, {GEARY_MIME_DATA_FORMAT_ENCODING_UNALLOWED, "GEARY_MIME_DATA_FORMAT_ENCODING_UNALLOWED", "unallowed"}, {0, NULL, NULL}};
	GType geary_mime_data_format_encoding_type_id;
	geary_mime_data_format_encoding_type_id = g_enum_register_static ("GearyMimeDataFormatEncoding", values);
	return geary_mime_data_format_encoding_type_id;
}

GType
geary_mime_data_format_encoding_get_type (void)
{
	static gsize geary_mime_data_format_encoding_type_id__once = 0;
	if (g_once_init_enter (&geary_mime_data_format_encoding_type_id__once)) {
		GType geary_mime_data_format_encoding_type_id;
		geary_mime_data_format_encoding_type_id = geary_mime_data_format_encoding_get_type_once ();
		g_once_init_leave (&geary_mime_data_format_encoding_type_id__once, geary_mime_data_format_encoding_type_id);
	}
	return geary_mime_data_format_encoding_type_id__once;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
_vala_char_array_contains (gchar * stack,
                           gssize stack_length,
                           const gchar needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

GearyMimeDataFormatEncoding
geary_mime_data_format_get_encoding_requirement (const gchar* str)
{
	GearyMimeDataFormatEncoding encoding = 0;
	gint index = 0;
	GearyMimeDataFormatEncoding result;
	g_return_val_if_fail (str != NULL, 0);
	if (geary_string_is_empty (str)) {
		result = GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_REQUIRED;
		return result;
	}
	encoding = GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_OPTIONAL;
	index = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar ch = '\0';
			gint _tmp1_;
			gboolean _tmp2_ = FALSE;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = index;
			index = _tmp1_ + 1;
			ch = string_get (str, (glong) _tmp1_);
			if (ch == GEARY_STRING_EOS) {
				break;
			}
			if (g_ascii_iscntrl (ch)) {
				result = GEARY_MIME_DATA_FORMAT_ENCODING_UNALLOWED;
				return result;
			}
			if (g_ascii_isspace (ch)) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = _vala_char_array_contains (GEARY_MIME_DATA_FORMAT_CONTENT_TYPE_TOKEN_SPECIALS, G_N_ELEMENTS (GEARY_MIME_DATA_FORMAT_CONTENT_TYPE_TOKEN_SPECIALS), ch);
			}
			if (_tmp2_) {
				encoding = GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_REQUIRED;
			}
		}
	}
	result = encoding;
	return result;
}

