/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_RESHADE_SERVER_PROTOCOL_H
#define GAMESCOPE_RESHADE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_gamescope_reshade The gamescope_reshade protocol
 * gamescope-specific reshade integration
 *
 * @section page_desc_gamescope_reshade Description
 *
 * This protocol allows applications to load and interact with a reshade FX shader in gamescope.
 *
 * @section page_ifaces_gamescope_reshade Interfaces
 * - @subpage page_iface_gamescope_reshade - 
 * @section page_copyright_gamescope_reshade Copyright
 * <pre>
 *
 * Copyright © 2024 Wayne Heaney
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_reshade;

#ifndef GAMESCOPE_RESHADE_INTERFACE
#define GAMESCOPE_RESHADE_INTERFACE
/**
 * @page page_iface_gamescope_reshade gamescope_reshade
 * @section page_iface_gamescope_reshade_api API
 * See @ref iface_gamescope_reshade.
 */
/**
 * @defgroup iface_gamescope_reshade The gamescope_reshade interface
 */
extern const struct wl_interface gamescope_reshade_interface;
#endif

/**
 * @ingroup iface_gamescope_reshade
 * @struct gamescope_reshade_interface
 */
struct gamescope_reshade_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set the path to the reshade FX file
	 *
	 * The effect will be disabled to allow an opportunity to set
	 * uniform variables before enabling it.
	 * @param path Path to the FX file
	 */
	void (*set_effect)(struct wl_client *client,
			   struct wl_resource *resource,
			   const char *path);
	/**
	 * turn on the effect
	 *
	 * Enables the effect that was previously loaded by set_effect.
	 */
	void (*enable_effect)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * set a uniform variable for the currently loaded effect
	 *
	 * Set the value of a uniform variable. Can be called before or
	 * after enabling the effect.
	 * @param key Name of the uniform variable
	 * @param value Value of the uniform variable
	 */
	void (*set_uniform_variable)(struct wl_client *client,
				     struct wl_resource *resource,
				     const char *key,
				     struct wl_array *value);
	/**
	 * turn off the effect
	 *
	 * Disables the effect that was previously enabled by
	 * enable_effect.
	 */
	void (*disable_effect)(struct wl_client *client,
			       struct wl_resource *resource);
};

#define GAMESCOPE_RESHADE_EFFECT_READY 0

/**
 * @ingroup iface_gamescope_reshade
 */
#define GAMESCOPE_RESHADE_EFFECT_READY_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_reshade
 */
#define GAMESCOPE_RESHADE_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_reshade
 */
#define GAMESCOPE_RESHADE_SET_EFFECT_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_reshade
 */
#define GAMESCOPE_RESHADE_ENABLE_EFFECT_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_reshade
 */
#define GAMESCOPE_RESHADE_SET_UNIFORM_VARIABLE_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_reshade
 */
#define GAMESCOPE_RESHADE_DISABLE_EFFECT_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_reshade
 * Sends an effect_ready event to the client owning the resource.
 * @param resource_ The client's resource
 * @param effect_path Path to the FX file
 */
static inline void
gamescope_reshade_send_effect_ready(struct wl_resource *resource_, const char *effect_path)
{
	wl_resource_post_event(resource_, GAMESCOPE_RESHADE_EFFECT_READY, effect_path);
}

#ifdef  __cplusplus
}
#endif

#endif
