/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_CONTROL_CLIENT_PROTOCOL_H
#define GAMESCOPE_CONTROL_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_gamescope_control The gamescope_control protocol
 * gamescope-specific protocol
 *
 * @section page_desc_gamescope_control Description
 *
 * This is a private Gamescope protocol. Regular Wayland clients must not use
 * it.
 *
 * @section page_ifaces_gamescope_control Interfaces
 * - @subpage page_iface_gamescope_control - 
 * @section page_copyright_gamescope_control Copyright
 * <pre>
 *
 * Copyright © 2023 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_control;

#ifndef GAMESCOPE_CONTROL_INTERFACE
#define GAMESCOPE_CONTROL_INTERFACE
/**
 * @page page_iface_gamescope_control gamescope_control
 * @section page_iface_gamescope_control_api API
 * See @ref iface_gamescope_control.
 */
/**
 * @defgroup iface_gamescope_control The gamescope_control interface
 */
extern const struct wl_interface gamescope_control_interface;
#endif

#ifndef GAMESCOPE_CONTROL_FEATURE_ENUM
#define GAMESCOPE_CONTROL_FEATURE_ENUM
/**
 * @ingroup iface_gamescope_control
 * gamescope feature types
 *
 * Enum of the features supported by Gamescope.
 */
enum gamescope_control_feature {
	/**
	 * sent at the end of the feature list
	 */
	GAMESCOPE_CONTROL_FEATURE_DONE = 0,
	GAMESCOPE_CONTROL_FEATURE_RESHADE_SHADERS = 1,
	GAMESCOPE_CONTROL_FEATURE_DISPLAY_INFO = 2,
	GAMESCOPE_CONTROL_FEATURE_PIXEL_FILTER = 3,
	GAMESCOPE_CONTROL_FEATURE_REFRESH_CYCLE_ONLY_CHANGE_REFRESH_RATE = 4,
	GAMESCOPE_CONTROL_FEATURE_MURA_CORRECTION = 5,
	GAMESCOPE_CONTROL_FEATURE_LOOK = 6,
	GAMESCOPE_CONTROL_FEATURE_PERF_QUERY = 7,
};
#endif /* GAMESCOPE_CONTROL_FEATURE_ENUM */

#ifndef GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM
#define GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM
enum gamescope_control_display_flag {
	GAMESCOPE_CONTROL_DISPLAY_FLAG_INTERNAL_DISPLAY = 0x1,
	GAMESCOPE_CONTROL_DISPLAY_FLAG_SUPPORTS_HDR = 0x2,
	GAMESCOPE_CONTROL_DISPLAY_FLAG_SUPPORTS_VRR = 0x4,
};
#endif /* GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM */

#ifndef GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM
#define GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM
enum gamescope_control_target_refresh_cycle_flag {
	/**
	 * Whether we should change the target refresh cycle under external/internal display
	 */
	GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_INTERNAL_DISPLAY = 0x1,
	/**
	 * Whether or not to allow refresh rate switching
	 */
	GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ALLOW_REFRESH_SWITCHING = 0x2,
	/**
	 * Only change refresh rate but don't apply frame limiter fps cap
	 */
	GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ONLY_CHANGE_REFRESH_RATE = 0x4,
};
#endif /* GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM */

#ifndef GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM
#define GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM
enum gamescope_control_screenshot_type {
	/**
	 * Just the game w/ no display color mgmt
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_BASE_PLANE_ONLY = 1,
	/**
	 * Just the game + overlays w/ no display color mgmt
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ALL_REAL_LAYERS = 2,
	/**
	 * Every layer w/ no display color mgmt and no mura
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_FULL_COMPOSITION = 3,
	/**
	 * The buffer displayed on-screen - 1:1
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_SCREEN_BUFFER = 4,
};
#endif /* GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM */

#ifndef GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM
#define GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM
enum gamescope_control_screenshot_flags {
	GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_DUMMY = 0x1,
};
#endif /* GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM
#define GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM
enum gamescope_control_display_type_flags {
	/**
	 * The internal display of the device
	 */
	GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_INTERNAL_DISPLAY = 0x1,
	/**
	 * The external display attached to the device
	 */
	GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_EXTERNAL_DISPLAY = 0x2,
};
#endif /* GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM
#define GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM
enum gamescope_control_display_sleep_flags {
	/**
	 * Go to sleep... zzz... (Conflicts with wake)
	 */
	GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_SLEEP = 0x1,
	/**
	 * Wake up! (Conflicts with sleep)
	 */
	GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_WAKE = 0x2,
};
#endif /* GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM
#define GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM
enum gamescope_control_look_flags {
	GAMESCOPE_CONTROL_LOOK_FLAGS_DUMMY = 0x1,
};
#endif /* GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM */

/**
 * @ingroup iface_gamescope_control
 * @struct gamescope_control_listener
 */
struct gamescope_control_listener {
	/**
	 * feature supported
	 *
	 * Says whether a feature is supported and the version.
	 * @param feature one of the enum features
	 * @param version feature version
	 * @param flags feature flags
	 */
	void (*feature_support)(void *data,
				struct gamescope_control *gamescope_control,
				uint32_t feature,
				uint32_t version,
				uint32_t flags);
	/**
	 * @param display_flags combination of 'display_flag' values
	 * @param valid_refresh_rates valid refresh rates for the display for the purposes of combined fps limiting + refresh. empty if fixed at a mode. 32-bit unsigned integers.
	 * @since 2
	 */
	void (*active_display_info)(void *data,
				    struct gamescope_control *gamescope_control,
				    const char *connector_name,
				    const char *display_make,
				    const char *display_model,
				    uint32_t display_flags,
				    struct wl_array *valid_refresh_rates);
	/**
	 * @param path Path to written screenshot
	 * @since 3
	 */
	void (*screenshot_taken)(void *data,
				 struct gamescope_control *gamescope_control,
				 const char *path);
	/**
	 * @param app_id Appid for this request
	 * @param frametime_ns_lo Time delta between the two most recent frames
	 * @param frametime_ns_hi frametime_ns high bits
	 * @since 6
	 */
	void (*app_performance_stats)(void *data,
				      struct gamescope_control *gamescope_control,
				      uint32_t app_id,
				      uint32_t frametime_ns_lo,
				      uint32_t frametime_ns_hi);
};

/**
 * @ingroup iface_gamescope_control
 */
static inline int
gamescope_control_add_listener(struct gamescope_control *gamescope_control,
			       const struct gamescope_control_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gamescope_control,
				     (void (**)(void)) listener, data);
}

#define GAMESCOPE_CONTROL_DESTROY 0
#define GAMESCOPE_CONTROL_SET_APP_TARGET_REFRESH_CYCLE 1
#define GAMESCOPE_CONTROL_TAKE_SCREENSHOT 2
#define GAMESCOPE_CONTROL_DISPLAY_SLEEP 3
#define GAMESCOPE_CONTROL_SET_LOOK 4
#define GAMESCOPE_CONTROL_UNSET_LOOK 5
#define GAMESCOPE_CONTROL_REQUEST_APP_PERFORMANCE_STATS 6

/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_FEATURE_SUPPORT_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_ACTIVE_DISPLAY_INFO_SINCE_VERSION 2
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_SCREENSHOT_TAKEN_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_APP_PERFORMANCE_STATS_SINCE_VERSION 6

/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_SET_APP_TARGET_REFRESH_CYCLE_SINCE_VERSION 2
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_TAKE_SCREENSHOT_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_DISPLAY_SLEEP_SINCE_VERSION 4
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_SET_LOOK_SINCE_VERSION 5
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_UNSET_LOOK_SINCE_VERSION 5
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_REQUEST_APP_PERFORMANCE_STATS_SINCE_VERSION 6

/** @ingroup iface_gamescope_control */
static inline void
gamescope_control_set_user_data(struct gamescope_control *gamescope_control, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gamescope_control, user_data);
}

/** @ingroup iface_gamescope_control */
static inline void *
gamescope_control_get_user_data(struct gamescope_control *gamescope_control)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gamescope_control);
}

static inline uint32_t
gamescope_control_get_version(struct gamescope_control *gamescope_control)
{
	return wl_proxy_get_version((struct wl_proxy *) gamescope_control);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_destroy(struct gamescope_control *gamescope_control)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_set_app_target_refresh_cycle(struct gamescope_control *gamescope_control, uint32_t fps, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_SET_APP_TARGET_REFRESH_CYCLE, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), 0, fps, flags);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_take_screenshot(struct gamescope_control *gamescope_control, const char *path, uint32_t type, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_TAKE_SCREENSHOT, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), 0, path, type, flags);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_display_sleep(struct gamescope_control *gamescope_control, uint32_t display_type, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_DISPLAY_SLEEP, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), 0, display_type, flags);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_set_look(struct gamescope_control *gamescope_control, int32_t lut3d_g22, int32_t lut3d_pq, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_SET_LOOK, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), 0, lut3d_g22, lut3d_pq, flags);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_unset_look(struct gamescope_control *gamescope_control)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_UNSET_LOOK, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), 0);
}

/**
 * @ingroup iface_gamescope_control
 */
static inline void
gamescope_control_request_app_performance_stats(struct gamescope_control *gamescope_control, uint32_t app_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_control,
			 GAMESCOPE_CONTROL_REQUEST_APP_PERFORMANCE_STATS, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_control), 0, app_id);
}

#ifdef  __cplusplus
}
#endif

#endif
