/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "foundry-ipc.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING_BOXED_BOXED_VARIANT_VARIANT_VARIANT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectStringBoxedBoxedVariantVariantVariantStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        const gchar *arg_directory,
        const gchar *const *arg_environment,
        const gchar *const *arg_argv,
        GVariant *arg_stdin_handle,
        GVariant *arg_stdout_handle,
        GVariant *arg_stderr_handle,
        const gchar *arg_object_path,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectStringBoxedBoxedVariantVariantVariantStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 10);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectStringBoxedBoxedVariantVariantVariantStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              g_marshal_value_peek_boxed (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              g_marshal_value_peek_variant (param_values + 7),
              g_marshal_value_peek_variant (param_values + 8),
              g_marshal_value_peek_string (param_values + 9),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        gint arg_fdnum,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface app.devsuite.foundry.CommandLineService
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FoundryIpcCommandLineService
 * @title: FoundryIpcCommandLineService
 * @short_description: Generated C code for the app.devsuite.foundry.CommandLineService D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link> D-Bus interface in C.
 */

/* ---- Introspection data for app.devsuite.foundry.CommandLineService ---- */

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_directory =
{
  {
    -1,
    (gchar *) "directory",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_environment =
{
  {
    -1,
    (gchar *) "environment",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_argv =
{
  {
    -1,
    (gchar *) "argv",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_stdin_handle =
{
  {
    -1,
    (gchar *) "stdin_handle",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_stdout_handle =
{
  {
    -1,
    (gchar *) "stdout_handle",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_stderr_handle =
{
  {
    -1,
    (gchar *) "stderr_handle",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_IN_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _foundry_ipc_command_line_service_method_info_run_IN_ARG_pointers[] =
{
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_directory.parent_struct,
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_environment.parent_struct,
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_argv.parent_struct,
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_stdin_handle.parent_struct,
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_stdout_handle.parent_struct,
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_stderr_handle.parent_struct,
  &_foundry_ipc_command_line_service_method_info_run_IN_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_service_method_info_run_OUT_ARG_exit_code =
{
  {
    -1,
    (gchar *) "exit_code",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _foundry_ipc_command_line_service_method_info_run_OUT_ARG_pointers[] =
{
  &_foundry_ipc_command_line_service_method_info_run_OUT_ARG_exit_code.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _foundry_ipc_command_line_service_method_info_run =
{
  {
    -1,
    (gchar *) "Run",
    (GDBusArgInfo **) &_foundry_ipc_command_line_service_method_info_run_IN_ARG_pointers,
    (GDBusArgInfo **) &_foundry_ipc_command_line_service_method_info_run_OUT_ARG_pointers,
    NULL
  },
  "handle-run",
  TRUE
};

static const GDBusMethodInfo * const _foundry_ipc_command_line_service_method_info_pointers[] =
{
  &_foundry_ipc_command_line_service_method_info_run.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _foundry_ipc_command_line_service_interface_info =
{
  {
    -1,
    (gchar *) "app.devsuite.foundry.CommandLineService",
    (GDBusMethodInfo **) &_foundry_ipc_command_line_service_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "command-line-service",
};


/**
 * foundry_ipc_command_line_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
foundry_ipc_command_line_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_foundry_ipc_command_line_service_interface_info.parent_struct;
}

/**
 * foundry_ipc_command_line_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FoundryIpcCommandLineService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
foundry_ipc_command_line_service_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
foundry_ipc_command_line_service_method_marshal_run (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING_BOXED_BOXED_VARIANT_VARIANT_VARIANT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * FoundryIpcCommandLineService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link>.
 */

/**
 * FoundryIpcCommandLineServiceIface:
 * @parent_iface: The parent interface.
 * @handle_run: Handler for the #FoundryIpcCommandLineService::handle-run signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link>.
 */

typedef FoundryIpcCommandLineServiceIface FoundryIpcCommandLineServiceInterface;
G_DEFINE_INTERFACE (FoundryIpcCommandLineService, foundry_ipc_command_line_service, G_TYPE_OBJECT)

static void
foundry_ipc_command_line_service_default_init (FoundryIpcCommandLineServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FoundryIpcCommandLineService::handle-run:
   * @object: A #FoundryIpcCommandLineService.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_directory: Argument passed by remote caller.
   * @arg_environment: Argument passed by remote caller.
   * @arg_argv: Argument passed by remote caller.
   * @arg_stdin_handle: Argument passed by remote caller.
   * @arg_stdout_handle: Argument passed by remote caller.
   * @arg_stderr_handle: Argument passed by remote caller.
   * @arg_object_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-app-devsuite-foundry-CommandLineService.Run">Run()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call foundry_ipc_command_line_service_complete_run() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-run",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FoundryIpcCommandLineServiceIface, handle_run),
    g_signal_accumulator_true_handled,
    NULL,
      foundry_ipc_command_line_service_method_marshal_run,
    G_TYPE_BOOLEAN,
    9,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRV, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_STRING);

}

/**
 * foundry_ipc_command_line_service_call_run:
 * @proxy: A #FoundryIpcCommandLineServiceProxy.
 * @arg_directory: Argument to pass with the method invocation.
 * @arg_environment: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_stdin_handle: Argument to pass with the method invocation.
 * @arg_stdout_handle: Argument to pass with the method invocation.
 * @arg_stderr_handle: Argument to pass with the method invocation.
 * @arg_object_path: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-app-devsuite-foundry-CommandLineService.Run">Run()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call foundry_ipc_command_line_service_call_run_finish() to get the result of the operation.
 *
 * See foundry_ipc_command_line_service_call_run_sync() for the synchronous, blocking version of this method.
 */
void
foundry_ipc_command_line_service_call_run (
    FoundryIpcCommandLineService *proxy,
    const gchar *arg_directory,
    const gchar *const *arg_environment,
    const gchar *const *arg_argv,
    GVariant *arg_stdin_handle,
    GVariant *arg_stdout_handle,
    GVariant *arg_stderr_handle,
    const gchar *arg_object_path,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Run",
    g_variant_new ("(^ay^as^as@h@h@ho)",
                   arg_directory,
                   arg_environment,
                   arg_argv,
                   arg_stdin_handle,
                   arg_stdout_handle,
                   arg_stderr_handle,
                   arg_object_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * foundry_ipc_command_line_service_call_run_finish:
 * @proxy: A #FoundryIpcCommandLineServiceProxy.
 * @out_exit_code: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to foundry_ipc_command_line_service_call_run().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with foundry_ipc_command_line_service_call_run().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
foundry_ipc_command_line_service_call_run_finish (
    FoundryIpcCommandLineService *proxy,
    gint *out_exit_code,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_exit_code);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * foundry_ipc_command_line_service_call_run_sync:
 * @proxy: A #FoundryIpcCommandLineServiceProxy.
 * @arg_directory: Argument to pass with the method invocation.
 * @arg_environment: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_stdin_handle: Argument to pass with the method invocation.
 * @arg_stdout_handle: Argument to pass with the method invocation.
 * @arg_stderr_handle: Argument to pass with the method invocation.
 * @arg_object_path: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_exit_code: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-app-devsuite-foundry-CommandLineService.Run">Run()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See foundry_ipc_command_line_service_call_run() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
foundry_ipc_command_line_service_call_run_sync (
    FoundryIpcCommandLineService *proxy,
    const gchar *arg_directory,
    const gchar *const *arg_environment,
    const gchar *const *arg_argv,
    GVariant *arg_stdin_handle,
    GVariant *arg_stdout_handle,
    GVariant *arg_stderr_handle,
    const gchar *arg_object_path,
    GUnixFDList  *fd_list,
    gint *out_exit_code,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Run",
    g_variant_new ("(^ay^as^as@h@h@ho)",
                   arg_directory,
                   arg_environment,
                   arg_argv,
                   arg_stdin_handle,
                   arg_stdout_handle,
                   arg_stderr_handle,
                   arg_object_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_exit_code);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * foundry_ipc_command_line_service_complete_run:
 * @object: A #FoundryIpcCommandLineService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @exit_code: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-app-devsuite-foundry-CommandLineService.Run">Run()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
foundry_ipc_command_line_service_complete_run (
    FoundryIpcCommandLineService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    gint exit_code)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(i)",
                   exit_code),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * FoundryIpcCommandLineServiceProxy:
 *
 * The #FoundryIpcCommandLineServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FoundryIpcCommandLineServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FoundryIpcCommandLineServiceProxy.
 */

struct _FoundryIpcCommandLineServiceProxyPrivate
{
  GData *qdata;
};

static void foundry_ipc_command_line_service_proxy_iface_init (FoundryIpcCommandLineServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineServiceProxy, foundry_ipc_command_line_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FoundryIpcCommandLineServiceProxy)
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE, foundry_ipc_command_line_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineServiceProxy, foundry_ipc_command_line_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE, foundry_ipc_command_line_service_proxy_iface_init))

#endif
static void
foundry_ipc_command_line_service_proxy_finalize (GObject *object)
{
  FoundryIpcCommandLineServiceProxy *proxy = FOUNDRY_IPC_COMMAND_LINE_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (foundry_ipc_command_line_service_proxy_parent_class)->finalize (object);
}

static void
foundry_ipc_command_line_service_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
foundry_ipc_command_line_service_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
foundry_ipc_command_line_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
foundry_ipc_command_line_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FoundryIpcCommandLineServiceProxy *proxy = FOUNDRY_IPC_COMMAND_LINE_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
foundry_ipc_command_line_service_proxy_init (FoundryIpcCommandLineServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = foundry_ipc_command_line_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_PROXY, FoundryIpcCommandLineServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), foundry_ipc_command_line_service_interface_info ());
}

static void
foundry_ipc_command_line_service_proxy_class_init (FoundryIpcCommandLineServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = foundry_ipc_command_line_service_proxy_finalize;
  gobject_class->get_property = foundry_ipc_command_line_service_proxy_get_property;
  gobject_class->set_property = foundry_ipc_command_line_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = foundry_ipc_command_line_service_proxy_g_signal;
  proxy_class->g_properties_changed = foundry_ipc_command_line_service_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FoundryIpcCommandLineServiceProxyPrivate));
#endif
}

static void
foundry_ipc_command_line_service_proxy_iface_init (FoundryIpcCommandLineServiceIface *iface G_GNUC_UNUSED)
{
}

/**
 * foundry_ipc_command_line_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call foundry_ipc_command_line_service_proxy_new_finish() to get the result of the operation.
 *
 * See foundry_ipc_command_line_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
foundry_ipc_command_line_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLineService", NULL);
}

/**
 * foundry_ipc_command_line_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to foundry_ipc_command_line_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with foundry_ipc_command_line_service_proxy_new().
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLineService *
foundry_ipc_command_line_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE_SERVICE (ret);
  else
    return NULL;
}

/**
 * foundry_ipc_command_line_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See foundry_ipc_command_line_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLineService *
foundry_ipc_command_line_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLineService", NULL);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE_SERVICE (ret);
  else
    return NULL;
}


/**
 * foundry_ipc_command_line_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like foundry_ipc_command_line_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call foundry_ipc_command_line_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See foundry_ipc_command_line_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
foundry_ipc_command_line_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLineService", NULL);
}

/**
 * foundry_ipc_command_line_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to foundry_ipc_command_line_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with foundry_ipc_command_line_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLineService *
foundry_ipc_command_line_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE_SERVICE (ret);
  else
    return NULL;
}

/**
 * foundry_ipc_command_line_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like foundry_ipc_command_line_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See foundry_ipc_command_line_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLineService *
foundry_ipc_command_line_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLineService", NULL);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FoundryIpcCommandLineServiceSkeleton:
 *
 * The #FoundryIpcCommandLineServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FoundryIpcCommandLineServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FoundryIpcCommandLineServiceSkeleton.
 */

struct _FoundryIpcCommandLineServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_foundry_ipc_command_line_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FoundryIpcCommandLineServiceSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_foundry_ipc_command_line_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FoundryIpcCommandLineServiceSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_foundry_ipc_command_line_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FoundryIpcCommandLineServiceSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _foundry_ipc_command_line_service_skeleton_vtable =
{
  _foundry_ipc_command_line_service_skeleton_handle_method_call,
  _foundry_ipc_command_line_service_skeleton_handle_get_property,
  _foundry_ipc_command_line_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
foundry_ipc_command_line_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return foundry_ipc_command_line_service_interface_info ();
}

static GDBusInterfaceVTable *
foundry_ipc_command_line_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_foundry_ipc_command_line_service_skeleton_vtable;
}

static GVariant *
foundry_ipc_command_line_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FoundryIpcCommandLineServiceSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_foundry_ipc_command_line_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _foundry_ipc_command_line_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _foundry_ipc_command_line_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _foundry_ipc_command_line_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "app.devsuite.foundry.CommandLineService", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
foundry_ipc_command_line_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void foundry_ipc_command_line_service_skeleton_iface_init (FoundryIpcCommandLineServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineServiceSkeleton, foundry_ipc_command_line_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FoundryIpcCommandLineServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE, foundry_ipc_command_line_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineServiceSkeleton, foundry_ipc_command_line_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE, foundry_ipc_command_line_service_skeleton_iface_init))

#endif
static void
foundry_ipc_command_line_service_skeleton_finalize (GObject *object)
{
  FoundryIpcCommandLineServiceSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SERVICE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (foundry_ipc_command_line_service_skeleton_parent_class)->finalize (object);
}

static void
foundry_ipc_command_line_service_skeleton_init (FoundryIpcCommandLineServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = foundry_ipc_command_line_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_SKELETON, FoundryIpcCommandLineServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
foundry_ipc_command_line_service_skeleton_class_init (FoundryIpcCommandLineServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = foundry_ipc_command_line_service_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = foundry_ipc_command_line_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = foundry_ipc_command_line_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = foundry_ipc_command_line_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = foundry_ipc_command_line_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FoundryIpcCommandLineServiceSkeletonPrivate));
#endif
}

static void
foundry_ipc_command_line_service_skeleton_iface_init (FoundryIpcCommandLineServiceIface *iface G_GNUC_UNUSED)
{
}

/**
 * foundry_ipc_command_line_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLineService.top_of_page">app.devsuite.foundry.CommandLineService</link>.
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineServiceSkeleton): The skeleton object.
 */
FoundryIpcCommandLineService *
foundry_ipc_command_line_service_skeleton_new (void)
{
  return FOUNDRY_IPC_COMMAND_LINE_SERVICE (g_object_new (FOUNDRY_IPC_TYPE_COMMAND_LINE_SERVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface app.devsuite.foundry.CommandLine
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FoundryIpcCommandLine
 * @title: FoundryIpcCommandLine
 * @short_description: Generated C code for the app.devsuite.foundry.CommandLine D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link> D-Bus interface in C.
 */

/* ---- Introspection data for app.devsuite.foundry.CommandLine ---- */

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_method_info_open_IN_ARG_fdnum =
{
  {
    -1,
    (gchar *) "fdnum",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _foundry_ipc_command_line_method_info_open_IN_ARG_pointers[] =
{
  &_foundry_ipc_command_line_method_info_open_IN_ARG_fdnum.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _foundry_ipc_command_line_method_info_open_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _foundry_ipc_command_line_method_info_open_OUT_ARG_pointers[] =
{
  &_foundry_ipc_command_line_method_info_open_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _foundry_ipc_command_line_method_info_open =
{
  {
    -1,
    (gchar *) "Open",
    (GDBusArgInfo **) &_foundry_ipc_command_line_method_info_open_IN_ARG_pointers,
    (GDBusArgInfo **) &_foundry_ipc_command_line_method_info_open_OUT_ARG_pointers,
    NULL
  },
  "handle-open",
  TRUE
};

static const GDBusMethodInfo * const _foundry_ipc_command_line_method_info_pointers[] =
{
  &_foundry_ipc_command_line_method_info_open.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _foundry_ipc_command_line_interface_info =
{
  {
    -1,
    (gchar *) "app.devsuite.foundry.CommandLine",
    (GDBusMethodInfo **) &_foundry_ipc_command_line_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "command-line",
};


/**
 * foundry_ipc_command_line_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
foundry_ipc_command_line_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_foundry_ipc_command_line_interface_info.parent_struct;
}

/**
 * foundry_ipc_command_line_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FoundryIpcCommandLine interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
foundry_ipc_command_line_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
foundry_ipc_command_line_method_marshal_open (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * FoundryIpcCommandLine:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link>.
 */

/**
 * FoundryIpcCommandLineIface:
 * @parent_iface: The parent interface.
 * @handle_open: Handler for the #FoundryIpcCommandLine::handle-open signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link>.
 */

typedef FoundryIpcCommandLineIface FoundryIpcCommandLineInterface;
G_DEFINE_INTERFACE (FoundryIpcCommandLine, foundry_ipc_command_line, G_TYPE_OBJECT)

static void
foundry_ipc_command_line_default_init (FoundryIpcCommandLineIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FoundryIpcCommandLine::handle-open:
   * @object: A #FoundryIpcCommandLine.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_fdnum: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-app-devsuite-foundry-CommandLine.Open">Open()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call foundry_ipc_command_line_complete_open() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FoundryIpcCommandLineIface, handle_open),
    g_signal_accumulator_true_handled,
    NULL,
      foundry_ipc_command_line_method_marshal_open,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_INT);

}

/**
 * foundry_ipc_command_line_call_open:
 * @proxy: A #FoundryIpcCommandLineProxy.
 * @arg_fdnum: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-app-devsuite-foundry-CommandLine.Open">Open()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call foundry_ipc_command_line_call_open_finish() to get the result of the operation.
 *
 * See foundry_ipc_command_line_call_open_sync() for the synchronous, blocking version of this method.
 */
void
foundry_ipc_command_line_call_open (
    FoundryIpcCommandLine *proxy,
    gint arg_fdnum,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("(i)",
                   arg_fdnum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * foundry_ipc_command_line_call_open_finish:
 * @proxy: A #FoundryIpcCommandLineProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to foundry_ipc_command_line_call_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with foundry_ipc_command_line_call_open().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
foundry_ipc_command_line_call_open_finish (
    FoundryIpcCommandLine *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * foundry_ipc_command_line_call_open_sync:
 * @proxy: A #FoundryIpcCommandLineProxy.
 * @arg_fdnum: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-app-devsuite-foundry-CommandLine.Open">Open()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See foundry_ipc_command_line_call_open() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
foundry_ipc_command_line_call_open_sync (
    FoundryIpcCommandLine *proxy,
    gint arg_fdnum,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Open",
    g_variant_new ("(i)",
                   arg_fdnum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * foundry_ipc_command_line_complete_open:
 * @object: A #FoundryIpcCommandLine.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-app-devsuite-foundry-CommandLine.Open">Open()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
foundry_ipc_command_line_complete_open (
    FoundryIpcCommandLine *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * FoundryIpcCommandLineProxy:
 *
 * The #FoundryIpcCommandLineProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FoundryIpcCommandLineProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FoundryIpcCommandLineProxy.
 */

struct _FoundryIpcCommandLineProxyPrivate
{
  GData *qdata;
};

static void foundry_ipc_command_line_proxy_iface_init (FoundryIpcCommandLineIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineProxy, foundry_ipc_command_line_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FoundryIpcCommandLineProxy)
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE, foundry_ipc_command_line_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineProxy, foundry_ipc_command_line_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE, foundry_ipc_command_line_proxy_iface_init))

#endif
static void
foundry_ipc_command_line_proxy_finalize (GObject *object)
{
  FoundryIpcCommandLineProxy *proxy = FOUNDRY_IPC_COMMAND_LINE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (foundry_ipc_command_line_proxy_parent_class)->finalize (object);
}

static void
foundry_ipc_command_line_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
foundry_ipc_command_line_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
foundry_ipc_command_line_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FOUNDRY_IPC_TYPE_COMMAND_LINE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FOUNDRY_IPC_TYPE_COMMAND_LINE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
foundry_ipc_command_line_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FoundryIpcCommandLineProxy *proxy = FOUNDRY_IPC_COMMAND_LINE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
foundry_ipc_command_line_proxy_init (FoundryIpcCommandLineProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = foundry_ipc_command_line_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FOUNDRY_IPC_TYPE_COMMAND_LINE_PROXY, FoundryIpcCommandLineProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), foundry_ipc_command_line_interface_info ());
}

static void
foundry_ipc_command_line_proxy_class_init (FoundryIpcCommandLineProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = foundry_ipc_command_line_proxy_finalize;
  gobject_class->get_property = foundry_ipc_command_line_proxy_get_property;
  gobject_class->set_property = foundry_ipc_command_line_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = foundry_ipc_command_line_proxy_g_signal;
  proxy_class->g_properties_changed = foundry_ipc_command_line_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FoundryIpcCommandLineProxyPrivate));
#endif
}

static void
foundry_ipc_command_line_proxy_iface_init (FoundryIpcCommandLineIface *iface G_GNUC_UNUSED)
{
}

/**
 * foundry_ipc_command_line_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call foundry_ipc_command_line_proxy_new_finish() to get the result of the operation.
 *
 * See foundry_ipc_command_line_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
foundry_ipc_command_line_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FOUNDRY_IPC_TYPE_COMMAND_LINE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLine", NULL);
}

/**
 * foundry_ipc_command_line_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to foundry_ipc_command_line_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with foundry_ipc_command_line_proxy_new().
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLine *
foundry_ipc_command_line_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE (ret);
  else
    return NULL;
}

/**
 * foundry_ipc_command_line_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See foundry_ipc_command_line_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLine *
foundry_ipc_command_line_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FOUNDRY_IPC_TYPE_COMMAND_LINE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLine", NULL);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE (ret);
  else
    return NULL;
}


/**
 * foundry_ipc_command_line_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like foundry_ipc_command_line_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call foundry_ipc_command_line_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See foundry_ipc_command_line_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
foundry_ipc_command_line_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FOUNDRY_IPC_TYPE_COMMAND_LINE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLine", NULL);
}

/**
 * foundry_ipc_command_line_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to foundry_ipc_command_line_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with foundry_ipc_command_line_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLine *
foundry_ipc_command_line_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE (ret);
  else
    return NULL;
}

/**
 * foundry_ipc_command_line_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like foundry_ipc_command_line_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See foundry_ipc_command_line_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineProxy): The constructed proxy object or %NULL if @error is set.
 */
FoundryIpcCommandLine *
foundry_ipc_command_line_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FOUNDRY_IPC_TYPE_COMMAND_LINE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "app.devsuite.foundry.CommandLine", NULL);
  if (ret != NULL)
    return FOUNDRY_IPC_COMMAND_LINE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FoundryIpcCommandLineSkeleton:
 *
 * The #FoundryIpcCommandLineSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FoundryIpcCommandLineSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FoundryIpcCommandLineSkeleton.
 */

struct _FoundryIpcCommandLineSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_foundry_ipc_command_line_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FoundryIpcCommandLineSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FOUNDRY_IPC_TYPE_COMMAND_LINE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FOUNDRY_IPC_TYPE_COMMAND_LINE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_foundry_ipc_command_line_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FoundryIpcCommandLineSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_foundry_ipc_command_line_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FoundryIpcCommandLineSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_foundry_ipc_command_line_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _foundry_ipc_command_line_skeleton_vtable =
{
  _foundry_ipc_command_line_skeleton_handle_method_call,
  _foundry_ipc_command_line_skeleton_handle_get_property,
  _foundry_ipc_command_line_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
foundry_ipc_command_line_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return foundry_ipc_command_line_interface_info ();
}

static GDBusInterfaceVTable *
foundry_ipc_command_line_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_foundry_ipc_command_line_skeleton_vtable;
}

static GVariant *
foundry_ipc_command_line_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FoundryIpcCommandLineSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_foundry_ipc_command_line_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _foundry_ipc_command_line_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _foundry_ipc_command_line_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _foundry_ipc_command_line_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "app.devsuite.foundry.CommandLine", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
foundry_ipc_command_line_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void foundry_ipc_command_line_skeleton_iface_init (FoundryIpcCommandLineIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineSkeleton, foundry_ipc_command_line_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FoundryIpcCommandLineSkeleton)
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE, foundry_ipc_command_line_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FoundryIpcCommandLineSkeleton, foundry_ipc_command_line_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FOUNDRY_IPC_TYPE_COMMAND_LINE, foundry_ipc_command_line_skeleton_iface_init))

#endif
static void
foundry_ipc_command_line_skeleton_finalize (GObject *object)
{
  FoundryIpcCommandLineSkeleton *skeleton = FOUNDRY_IPC_COMMAND_LINE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (foundry_ipc_command_line_skeleton_parent_class)->finalize (object);
}

static void
foundry_ipc_command_line_skeleton_init (FoundryIpcCommandLineSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = foundry_ipc_command_line_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FOUNDRY_IPC_TYPE_COMMAND_LINE_SKELETON, FoundryIpcCommandLineSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
foundry_ipc_command_line_skeleton_class_init (FoundryIpcCommandLineSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = foundry_ipc_command_line_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = foundry_ipc_command_line_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = foundry_ipc_command_line_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = foundry_ipc_command_line_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = foundry_ipc_command_line_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FoundryIpcCommandLineSkeletonPrivate));
#endif
}

static void
foundry_ipc_command_line_skeleton_iface_init (FoundryIpcCommandLineIface *iface G_GNUC_UNUSED)
{
}

/**
 * foundry_ipc_command_line_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-app-devsuite-foundry-CommandLine.top_of_page">app.devsuite.foundry.CommandLine</link>.
 *
 * Returns: (transfer full) (type FoundryIpcCommandLineSkeleton): The skeleton object.
 */
FoundryIpcCommandLine *
foundry_ipc_command_line_skeleton_new (void)
{
  return FOUNDRY_IPC_COMMAND_LINE (g_object_new (FOUNDRY_IPC_TYPE_COMMAND_LINE_SKELETON, NULL));
}

