//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PFileSystemManager_h
#define PFileSystemManager_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/dom/FileSystemTypes.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SideVariant.h"
#include "mozilla/dom/IPCBlob.h"
#include "mozilla/ipc/RandomAccessStreamParams.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemEntryMetadata|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemEntryMetadata final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;
    typedef ::mozilla::dom::fs::Name Name;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemEntryMetadata() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemEntryMetadata(
            const EntryId& _entryId,
            const Name& _entryName,
            const bool& _directory) :
        entryId_(_entryId),
        entryName_(_entryName),
        directory_(_directory)
    {
    }

    MOZ_IMPLICIT FileSystemEntryMetadata(
            EntryId&& _entryId,
            Name&& _entryName,
            bool&& _directory) :
        entryId_(std::move(_entryId)),
        entryName_(std::move(_entryName)),
        directory_(std::move(_directory))
    {
    }

    EntryId&
    entryId()
    {
        return entryId_;
    }
    const EntryId&
    entryId() const
    {
        return entryId_;
    }

    Name&
    entryName()
    {
        return entryName_;
    }
    const Name&
    entryName() const
    {
        return entryName_;
    }

    bool&
    directory()
    {
        return directory_;
    }
    const bool&
    directory() const
    {
        return directory_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> entryId_;
    ::mozilla::ipc::IPDLStructMember<Name> entryName_;
    ::mozilla::ipc::IPDLStructMember<bool> directory_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemEntryMetadata>
{
    typedef ::mozilla::dom::fs::FileSystemEntryMetadata paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemChildMetadata|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemChildMetadata final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;
    typedef ::mozilla::dom::fs::Name Name;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemChildMetadata() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemChildMetadata(
            const EntryId& _parentId,
            const Name& _childName) :
        parentId_(_parentId),
        childName_(_childName)
    {
    }

    MOZ_IMPLICIT FileSystemChildMetadata(
            EntryId&& _parentId,
            Name&& _childName) :
        parentId_(std::move(_parentId)),
        childName_(std::move(_childName))
    {
    }

    EntryId&
    parentId()
    {
        return parentId_;
    }
    const EntryId&
    parentId() const
    {
        return parentId_;
    }

    Name&
    childName()
    {
        return childName_;
    }
    const Name&
    childName() const
    {
        return childName_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> parentId_;
    ::mozilla::ipc::IPDLStructMember<Name> childName_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemChildMetadata>
{
    typedef ::mozilla::dom::fs::FileSystemChildMetadata paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemGetHandleRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetHandleRequest final
{
private:
    typedef ::mozilla::dom::fs::FileSystemChildMetadata FileSystemChildMetadata;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemGetHandleRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemGetHandleRequest(
            const FileSystemChildMetadata& _handle,
            const bool& _create) :
        handle_(_handle),
        create_(_create)
    {
    }

    MOZ_IMPLICIT FileSystemGetHandleRequest(
            FileSystemChildMetadata&& _handle,
            bool&& _create) :
        handle_(std::move(_handle)),
        create_(std::move(_create))
    {
    }

    FileSystemChildMetadata&
    handle()
    {
        return handle_;
    }
    const FileSystemChildMetadata&
    handle() const
    {
        return handle_;
    }

    bool&
    create()
    {
        return create_;
    }
    const bool&
    create() const
    {
        return create_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FileSystemChildMetadata> handle_;
    ::mozilla::ipc::IPDLStructMember<bool> create_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetHandleRequest>
{
    typedef ::mozilla::dom::fs::FileSystemGetHandleRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemGetHandleResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetHandleResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TEntryId,
        T__Last = TEntryId
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::EntryId EntryId;
    typedef nsresult nsresult__tdef;
    typedef EntryId EntryId__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    EntryId*
    ptr_EntryId()
    {
        return (&(mVEntryId));
    }
    const EntryId*
    constptr_EntryId() const
    {
        return (&(mVEntryId));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemGetHandleResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemGetHandleResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemGetHandleResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemGetHandleResponse(const EntryId& aOther);

    MOZ_IMPLICIT FileSystemGetHandleResponse(EntryId&& aOther);

    MOZ_IMPLICIT FileSystemGetHandleResponse(const FileSystemGetHandleResponse& aOther);

    MOZ_IMPLICIT FileSystemGetHandleResponse(FileSystemGetHandleResponse&& aOther);

    ~FileSystemGetHandleResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemGetHandleResponse&
    operator=(const nsresult& aRhs);

    FileSystemGetHandleResponse&
    operator=(nsresult&& aRhs);

    FileSystemGetHandleResponse&
    operator=(const EntryId& aRhs);

    FileSystemGetHandleResponse&
    operator=(EntryId&& aRhs);

    FileSystemGetHandleResponse&
    operator=(const FileSystemGetHandleResponse& aRhs);

    FileSystemGetHandleResponse&
    operator=(FileSystemGetHandleResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    EntryId&
    get_EntryId()
    {
        AssertSanity(TEntryId);
        return (*(ptr_EntryId()));
    }
    const EntryId&
    get_EntryId() const
    {
        AssertSanity(TEntryId);
        return (*(constptr_EntryId()));
    }
    operator EntryId&()
    {
        return get_EntryId();
    }
    operator const EntryId&() const
    {
        return get_EntryId();
    }

private:
    union {
        nsresult mVnsresult;
        EntryId mVEntryId;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetHandleResponse>
{
    typedef ::mozilla::dom::fs::FileSystemGetHandleResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemGetEntriesRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetEntriesRequest final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;
    typedef ::mozilla::dom::fs::PageNumber PageNumber;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemGetEntriesRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemGetEntriesRequest(
            const EntryId& _parentId,
            const PageNumber& _page) :
        parentId_(_parentId),
        page_(_page)
    {
    }

    MOZ_IMPLICIT FileSystemGetEntriesRequest(
            EntryId&& _parentId,
            PageNumber&& _page) :
        parentId_(std::move(_parentId)),
        page_(std::move(_page))
    {
    }

    EntryId&
    parentId()
    {
        return parentId_;
    }
    const EntryId&
    parentId() const
    {
        return parentId_;
    }

    PageNumber&
    page()
    {
        return page_;
    }
    const PageNumber&
    page() const
    {
        return page_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> parentId_;
    ::mozilla::ipc::IPDLStructMember<PageNumber> page_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetEntriesRequest>
{
    typedef ::mozilla::dom::fs::FileSystemGetEntriesRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemDirectoryListing|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemDirectoryListing final
{
private:
    typedef ::mozilla::dom::fs::FileSystemEntryMetadata FileSystemEntryMetadata;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemDirectoryListing() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemDirectoryListing(
            const nsTArray<FileSystemEntryMetadata>& _directories,
            const nsTArray<FileSystemEntryMetadata>& _files) :
        directories_(_directories),
        files_(_files)
    {
    }

    MOZ_IMPLICIT FileSystemDirectoryListing(
            nsTArray<FileSystemEntryMetadata>&& _directories,
            nsTArray<FileSystemEntryMetadata>&& _files) :
        directories_(std::move(_directories)),
        files_(std::move(_files))
    {
    }

    nsTArray<FileSystemEntryMetadata>&
    directories()
    {
        return directories_;
    }
    const nsTArray<FileSystemEntryMetadata>&
    directories() const
    {
        return directories_;
    }

    nsTArray<FileSystemEntryMetadata>&
    files()
    {
        return files_;
    }
    const nsTArray<FileSystemEntryMetadata>&
    files() const
    {
        return files_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FileSystemEntryMetadata>> directories_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FileSystemEntryMetadata>> files_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemDirectoryListing>
{
    typedef ::mozilla::dom::fs::FileSystemDirectoryListing paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemGetEntriesResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetEntriesResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TFileSystemDirectoryListing,
        T__Last = TFileSystemDirectoryListing
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::FileSystemDirectoryListing FileSystemDirectoryListing;
    typedef nsresult nsresult__tdef;
    typedef FileSystemDirectoryListing FileSystemDirectoryListing__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    FileSystemDirectoryListing*
    ptr_FileSystemDirectoryListing()
    {
        return (&(mVFileSystemDirectoryListing));
    }
    const FileSystemDirectoryListing*
    constptr_FileSystemDirectoryListing() const
    {
        return (&(mVFileSystemDirectoryListing));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemGetEntriesResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemGetEntriesResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemGetEntriesResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemGetEntriesResponse(const FileSystemDirectoryListing& aOther);

    MOZ_IMPLICIT FileSystemGetEntriesResponse(FileSystemDirectoryListing&& aOther);

    MOZ_IMPLICIT FileSystemGetEntriesResponse(const FileSystemGetEntriesResponse& aOther);

    MOZ_IMPLICIT FileSystemGetEntriesResponse(FileSystemGetEntriesResponse&& aOther);

    ~FileSystemGetEntriesResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemGetEntriesResponse&
    operator=(const nsresult& aRhs);

    FileSystemGetEntriesResponse&
    operator=(nsresult&& aRhs);

    FileSystemGetEntriesResponse&
    operator=(const FileSystemDirectoryListing& aRhs);

    FileSystemGetEntriesResponse&
    operator=(FileSystemDirectoryListing&& aRhs);

    FileSystemGetEntriesResponse&
    operator=(const FileSystemGetEntriesResponse& aRhs);

    FileSystemGetEntriesResponse&
    operator=(FileSystemGetEntriesResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    FileSystemDirectoryListing&
    get_FileSystemDirectoryListing()
    {
        AssertSanity(TFileSystemDirectoryListing);
        return (*(ptr_FileSystemDirectoryListing()));
    }
    const FileSystemDirectoryListing&
    get_FileSystemDirectoryListing() const
    {
        AssertSanity(TFileSystemDirectoryListing);
        return (*(constptr_FileSystemDirectoryListing()));
    }
    operator FileSystemDirectoryListing&()
    {
        return get_FileSystemDirectoryListing();
    }
    operator const FileSystemDirectoryListing&() const
    {
        return get_FileSystemDirectoryListing();
    }

private:
    union {
        nsresult mVnsresult;
        FileSystemDirectoryListing mVFileSystemDirectoryListing;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetEntriesResponse>
{
    typedef ::mozilla::dom::fs::FileSystemGetEntriesResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemGetFileRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetFileRequest final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemGetFileRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemGetFileRequest(const EntryId& _entryId) :
        entryId_(_entryId)
    {
    }

    MOZ_IMPLICIT FileSystemGetFileRequest(EntryId&& _entryId) :
        entryId_(std::move(_entryId))
    {
    }

    EntryId&
    entryId()
    {
        return entryId_;
    }
    const EntryId&
    entryId() const
    {
        return entryId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> entryId_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetFileRequest>
{
    typedef ::mozilla::dom::fs::FileSystemGetFileRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemFileProperties|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemFileProperties final
{
private:
    typedef ::mozilla::dom::fs::TimeStamp TimeStamp;
    typedef ::mozilla::dom::IPCBlob IPCBlob;
    typedef ::mozilla::dom::fs::ContentType ContentType;
    typedef ::mozilla::dom::fs::Name Name;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemFileProperties() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemFileProperties(
            const TimeStamp& _last_modified_ms,
            const IPCBlob& _file,
            const ContentType& _type,
            const nsTArray<Name>& _path) :
        last_modified_ms_(_last_modified_ms),
        file_(_file),
        type_(_type),
        path_(_path)
    {
    }

    MOZ_IMPLICIT FileSystemFileProperties(
            TimeStamp&& _last_modified_ms,
            IPCBlob&& _file,
            ContentType&& _type,
            nsTArray<Name>&& _path) :
        last_modified_ms_(std::move(_last_modified_ms)),
        file_(std::move(_file)),
        type_(std::move(_type)),
        path_(std::move(_path))
    {
    }

    TimeStamp&
    last_modified_ms()
    {
        return last_modified_ms_;
    }
    const TimeStamp&
    last_modified_ms() const
    {
        return last_modified_ms_;
    }

    IPCBlob&
    file()
    {
        return file_;
    }
    const IPCBlob&
    file() const
    {
        return file_;
    }

    ContentType&
    type()
    {
        return type_;
    }
    const ContentType&
    type() const
    {
        return type_;
    }

    nsTArray<Name>&
    path()
    {
        return path_;
    }
    const nsTArray<Name>&
    path() const
    {
        return path_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<TimeStamp> last_modified_ms_;
    ::mozilla::ipc::IPDLStructMember<IPCBlob> file_;
    ::mozilla::ipc::IPDLStructMember<ContentType> type_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<Name>> path_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemFileProperties>
{
    typedef ::mozilla::dom::fs::FileSystemFileProperties paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemGetFileResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetFileResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TFileSystemFileProperties,
        T__Last = TFileSystemFileProperties
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::FileSystemFileProperties FileSystemFileProperties;
    typedef nsresult nsresult__tdef;
    typedef FileSystemFileProperties FileSystemFileProperties__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    FileSystemFileProperties*
    ptr_FileSystemFileProperties()
    {
        return (&(mVFileSystemFileProperties));
    }
    const FileSystemFileProperties*
    constptr_FileSystemFileProperties() const
    {
        return (&(mVFileSystemFileProperties));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemGetFileResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemGetFileResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemGetFileResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemGetFileResponse(const FileSystemFileProperties& aOther);

    MOZ_IMPLICIT FileSystemGetFileResponse(FileSystemFileProperties&& aOther);

    MOZ_IMPLICIT FileSystemGetFileResponse(const FileSystemGetFileResponse& aOther);

    MOZ_IMPLICIT FileSystemGetFileResponse(FileSystemGetFileResponse&& aOther);

    ~FileSystemGetFileResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemGetFileResponse&
    operator=(const nsresult& aRhs);

    FileSystemGetFileResponse&
    operator=(nsresult&& aRhs);

    FileSystemGetFileResponse&
    operator=(const FileSystemFileProperties& aRhs);

    FileSystemGetFileResponse&
    operator=(FileSystemFileProperties&& aRhs);

    FileSystemGetFileResponse&
    operator=(const FileSystemGetFileResponse& aRhs);

    FileSystemGetFileResponse&
    operator=(FileSystemGetFileResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    FileSystemFileProperties&
    get_FileSystemFileProperties()
    {
        AssertSanity(TFileSystemFileProperties);
        return (*(ptr_FileSystemFileProperties()));
    }
    const FileSystemFileProperties&
    get_FileSystemFileProperties() const
    {
        AssertSanity(TFileSystemFileProperties);
        return (*(constptr_FileSystemFileProperties()));
    }
    operator FileSystemFileProperties&()
    {
        return get_FileSystemFileProperties();
    }
    operator const FileSystemFileProperties&() const
    {
        return get_FileSystemFileProperties();
    }

private:
    union {
        nsresult mVnsresult;
        FileSystemFileProperties mVFileSystemFileProperties;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetFileResponse>
{
    typedef ::mozilla::dom::fs::FileSystemGetFileResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemGetAccessHandleRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetAccessHandleRequest final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemGetAccessHandleRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemGetAccessHandleRequest(const EntryId& _entryId) :
        entryId_(_entryId)
    {
    }

    MOZ_IMPLICIT FileSystemGetAccessHandleRequest(EntryId&& _entryId) :
        entryId_(std::move(_entryId))
    {
    }

    EntryId&
    entryId()
    {
        return entryId_;
    }
    const EntryId&
    entryId() const
    {
        return entryId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> entryId_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetAccessHandleRequest>
{
    typedef ::mozilla::dom::fs::FileSystemGetAccessHandleRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PFileSystemAccessHandleParent;
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class PFileSystemAccessHandleChild;
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class PFileSystemAccessHandleControlParent;
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class PFileSystemAccessHandleControlChild;
} // namespace dom
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemAccessHandleProperties|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemAccessHandleProperties final
{
private:
    typedef ::mozilla::ipc::RandomAccessStreamParams RandomAccessStreamParams;
    template<class FooSide> using ManagedEndpoint = ::mozilla::ipc::ManagedEndpoint<FooSide>;
    typedef ::mozilla::dom::PFileSystemAccessHandleParent PFileSystemAccessHandleParent;
    typedef ::mozilla::dom::PFileSystemAccessHandleChild PFileSystemAccessHandleChild;
    template<class FooSide> using Endpoint = ::mozilla::ipc::Endpoint<FooSide>;
    typedef ::mozilla::dom::PFileSystemAccessHandleControlParent PFileSystemAccessHandleControlParent;
    typedef ::mozilla::dom::PFileSystemAccessHandleControlChild PFileSystemAccessHandleControlChild;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemAccessHandleProperties() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemAccessHandleProperties(
            RandomAccessStreamParams&& _streamParams,
            ManagedEndpoint<::mozilla::dom::PFileSystemAccessHandleChild>&& _accessHandleChildEndpoint,
            Endpoint<::mozilla::dom::PFileSystemAccessHandleControlChild>&& _accessHandleControlChildEndpoint) :
        streamParams_(std::move(_streamParams)),
        accessHandleChildEndpoint_(std::move(_accessHandleChildEndpoint)),
        accessHandleControlChildEndpoint_(std::move(_accessHandleControlChildEndpoint))
    {
    }

    RandomAccessStreamParams&
    streamParams()
    {
        return streamParams_;
    }
    const RandomAccessStreamParams&
    streamParams() const
    {
        return streamParams_;
    }

    ManagedEndpoint<::mozilla::dom::PFileSystemAccessHandleChild>&
    accessHandleChildEndpoint()
    {
        return accessHandleChildEndpoint_;
    }
    const ManagedEndpoint<::mozilla::dom::PFileSystemAccessHandleChild>&
    accessHandleChildEndpoint() const
    {
        return accessHandleChildEndpoint_;
    }

    Endpoint<::mozilla::dom::PFileSystemAccessHandleControlChild>&
    accessHandleControlChildEndpoint()
    {
        return accessHandleControlChildEndpoint_;
    }
    const Endpoint<::mozilla::dom::PFileSystemAccessHandleControlChild>&
    accessHandleControlChildEndpoint() const
    {
        return accessHandleControlChildEndpoint_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<RandomAccessStreamParams> streamParams_;
    ::mozilla::ipc::IPDLStructMember<ManagedEndpoint<::mozilla::dom::PFileSystemAccessHandleChild>> accessHandleChildEndpoint_;
    ::mozilla::ipc::IPDLStructMember<Endpoint<::mozilla::dom::PFileSystemAccessHandleControlChild>> accessHandleControlChildEndpoint_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemAccessHandleProperties>
{
    typedef ::mozilla::dom::fs::FileSystemAccessHandleProperties paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemGetAccessHandleResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetAccessHandleResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TFileSystemAccessHandleProperties,
        T__Last = TFileSystemAccessHandleProperties
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::FileSystemAccessHandleProperties FileSystemAccessHandleProperties;
    typedef nsresult nsresult__tdef;
    typedef FileSystemAccessHandleProperties FileSystemAccessHandleProperties__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    FileSystemAccessHandleProperties*
    ptr_FileSystemAccessHandleProperties()
    {
        return (&(mVFileSystemAccessHandleProperties));
    }
    const FileSystemAccessHandleProperties*
    constptr_FileSystemAccessHandleProperties() const
    {
        return (&(mVFileSystemAccessHandleProperties));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemGetAccessHandleResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemGetAccessHandleResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemGetAccessHandleResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemGetAccessHandleResponse(FileSystemAccessHandleProperties&& aOther);

    MOZ_IMPLICIT FileSystemGetAccessHandleResponse(FileSystemGetAccessHandleResponse&& aOther);

    ~FileSystemGetAccessHandleResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemGetAccessHandleResponse&
    operator=(const nsresult& aRhs);

    FileSystemGetAccessHandleResponse&
    operator=(nsresult&& aRhs);

    FileSystemGetAccessHandleResponse&
    operator=(FileSystemAccessHandleProperties&& aRhs);

    FileSystemGetAccessHandleResponse&
    operator=(FileSystemGetAccessHandleResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    FileSystemAccessHandleProperties&
    get_FileSystemAccessHandleProperties()
    {
        AssertSanity(TFileSystemAccessHandleProperties);
        return (*(ptr_FileSystemAccessHandleProperties()));
    }
    const FileSystemAccessHandleProperties&
    get_FileSystemAccessHandleProperties() const
    {
        AssertSanity(TFileSystemAccessHandleProperties);
        return (*(constptr_FileSystemAccessHandleProperties()));
    }
    operator FileSystemAccessHandleProperties&()
    {
        return get_FileSystemAccessHandleProperties();
    }
    operator const FileSystemAccessHandleProperties&() const
    {
        return get_FileSystemAccessHandleProperties();
    }

private:
    union {
        nsresult mVnsresult;
        FileSystemAccessHandleProperties mVFileSystemAccessHandleProperties;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetAccessHandleResponse>
{
    typedef ::mozilla::dom::fs::FileSystemGetAccessHandleResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemGetWritableRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetWritableRequest final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemGetWritableRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemGetWritableRequest(
            const EntryId& _entryId,
            const bool& _keepData) :
        entryId_(_entryId),
        keepData_(_keepData)
    {
    }

    MOZ_IMPLICIT FileSystemGetWritableRequest(
            EntryId&& _entryId,
            bool&& _keepData) :
        entryId_(std::move(_entryId)),
        keepData_(std::move(_keepData))
    {
    }

    EntryId&
    entryId()
    {
        return entryId_;
    }
    const EntryId&
    entryId() const
    {
        return entryId_;
    }

    bool&
    keepData()
    {
        return keepData_;
    }
    const bool&
    keepData() const
    {
        return keepData_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> entryId_;
    ::mozilla::ipc::IPDLStructMember<bool> keepData_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetWritableRequest>
{
    typedef ::mozilla::dom::fs::FileSystemGetWritableRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PFileSystemWritableFileStreamParent;
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class PFileSystemWritableFileStreamChild;
} // namespace dom
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemWritableFileStreamProperties|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemWritableFileStreamProperties final
{
private:
    typedef ::mozilla::ipc::RandomAccessStreamParams RandomAccessStreamParams;
    typedef ::mozilla::dom::PFileSystemWritableFileStreamParent PFileSystemWritableFileStreamParent;
    typedef ::mozilla::dom::PFileSystemWritableFileStreamChild PFileSystemWritableFileStreamChild;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemWritableFileStreamProperties() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemWritableFileStreamProperties(
            RandomAccessStreamParams&& _streamParams,
            const mozilla::NotNull<::mozilla::ipc::SideVariant<PFileSystemWritableFileStreamParent*, PFileSystemWritableFileStreamChild*>>& _writableFileStream) :
        streamParams_(std::move(_streamParams)),
        writableFileStream_(_writableFileStream)
    {
    }

    MOZ_IMPLICIT FileSystemWritableFileStreamProperties(
            RandomAccessStreamParams&& _streamParams,
            mozilla::NotNull<::mozilla::ipc::SideVariant<PFileSystemWritableFileStreamParent*, PFileSystemWritableFileStreamChild*>>&& _writableFileStream) :
        streamParams_(std::move(_streamParams)),
        writableFileStream_(std::move(_writableFileStream))
    {
    }

    RandomAccessStreamParams&
    streamParams()
    {
        return streamParams_;
    }
    const RandomAccessStreamParams&
    streamParams() const
    {
        return streamParams_;
    }

    mozilla::NotNull<::mozilla::ipc::SideVariant<PFileSystemWritableFileStreamParent*, PFileSystemWritableFileStreamChild*>>&
    writableFileStream()
    {
        return writableFileStream_;
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PFileSystemWritableFileStreamParent*, PFileSystemWritableFileStreamChild*>>&
    writableFileStream() const
    {
        return writableFileStream_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<RandomAccessStreamParams> streamParams_;
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<::mozilla::ipc::SideVariant<PFileSystemWritableFileStreamParent*, PFileSystemWritableFileStreamChild*>>> writableFileStream_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemWritableFileStreamProperties>
{
    typedef ::mozilla::dom::fs::FileSystemWritableFileStreamProperties paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemGetWritableFileStreamResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemGetWritableFileStreamResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TFileSystemWritableFileStreamProperties,
        T__Last = TFileSystemWritableFileStreamProperties
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::FileSystemWritableFileStreamProperties FileSystemWritableFileStreamProperties;
    typedef nsresult nsresult__tdef;
    typedef FileSystemWritableFileStreamProperties FileSystemWritableFileStreamProperties__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    FileSystemWritableFileStreamProperties*
    ptr_FileSystemWritableFileStreamProperties()
    {
        return (&(mVFileSystemWritableFileStreamProperties));
    }
    const FileSystemWritableFileStreamProperties*
    constptr_FileSystemWritableFileStreamProperties() const
    {
        return (&(mVFileSystemWritableFileStreamProperties));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemGetWritableFileStreamResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemGetWritableFileStreamResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemGetWritableFileStreamResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemGetWritableFileStreamResponse(FileSystemWritableFileStreamProperties&& aOther);

    MOZ_IMPLICIT FileSystemGetWritableFileStreamResponse(FileSystemGetWritableFileStreamResponse&& aOther);

    ~FileSystemGetWritableFileStreamResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemGetWritableFileStreamResponse&
    operator=(const nsresult& aRhs);

    FileSystemGetWritableFileStreamResponse&
    operator=(nsresult&& aRhs);

    FileSystemGetWritableFileStreamResponse&
    operator=(FileSystemWritableFileStreamProperties&& aRhs);

    FileSystemGetWritableFileStreamResponse&
    operator=(FileSystemGetWritableFileStreamResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    FileSystemWritableFileStreamProperties&
    get_FileSystemWritableFileStreamProperties()
    {
        AssertSanity(TFileSystemWritableFileStreamProperties);
        return (*(ptr_FileSystemWritableFileStreamProperties()));
    }
    const FileSystemWritableFileStreamProperties&
    get_FileSystemWritableFileStreamProperties() const
    {
        AssertSanity(TFileSystemWritableFileStreamProperties);
        return (*(constptr_FileSystemWritableFileStreamProperties()));
    }
    operator FileSystemWritableFileStreamProperties&()
    {
        return get_FileSystemWritableFileStreamProperties();
    }
    operator const FileSystemWritableFileStreamProperties&() const
    {
        return get_FileSystemWritableFileStreamProperties();
    }

private:
    union {
        nsresult mVnsresult;
        FileSystemWritableFileStreamProperties mVFileSystemWritableFileStreamProperties;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemGetWritableFileStreamResponse>
{
    typedef ::mozilla::dom::fs::FileSystemGetWritableFileStreamResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemEntryPair|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemEntryPair final
{
private:
    typedef ::mozilla::dom::fs::EntryId EntryId;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemEntryPair() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemEntryPair(
            const EntryId& _parentId,
            const EntryId& _childId) :
        parentId_(_parentId),
        childId_(_childId)
    {
    }

    MOZ_IMPLICIT FileSystemEntryPair(
            EntryId&& _parentId,
            EntryId&& _childId) :
        parentId_(std::move(_parentId)),
        childId_(std::move(_childId))
    {
    }

    EntryId&
    parentId()
    {
        return parentId_;
    }
    const EntryId&
    parentId() const
    {
        return parentId_;
    }

    EntryId&
    childId()
    {
        return childId_;
    }
    const EntryId&
    childId() const
    {
        return childId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EntryId> parentId_;
    ::mozilla::ipc::IPDLStructMember<EntryId> childId_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemEntryPair>
{
    typedef ::mozilla::dom::fs::FileSystemEntryPair paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemResolveRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemResolveRequest final
{
private:
    typedef ::mozilla::dom::fs::FileSystemEntryPair FileSystemEntryPair;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemResolveRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemResolveRequest(const FileSystemEntryPair& _endpoints) :
        endpoints_(_endpoints)
    {
    }

    MOZ_IMPLICIT FileSystemResolveRequest(FileSystemEntryPair&& _endpoints) :
        endpoints_(std::move(_endpoints))
    {
    }

    FileSystemEntryPair&
    endpoints()
    {
        return endpoints_;
    }
    const FileSystemEntryPair&
    endpoints() const
    {
        return endpoints_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FileSystemEntryPair> endpoints_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemResolveRequest>
{
    typedef ::mozilla::dom::fs::FileSystemResolveRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemPath|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemPath final
{
private:
    typedef ::mozilla::dom::fs::Name Name;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemPath() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemPath(const nsTArray<Name>& _path) :
        path_(_path)
    {
    }

    MOZ_IMPLICIT FileSystemPath(nsTArray<Name>&& _path) :
        path_(std::move(_path))
    {
    }

    nsTArray<Name>&
    path()
    {
        return path_;
    }
    const nsTArray<Name>&
    path() const
    {
        return path_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<Name>> path_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemPath>
{
    typedef ::mozilla::dom::fs::FileSystemPath paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemResolveResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemResolveResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TMaybeFileSystemPath,
        T__Last = TMaybeFileSystemPath
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::FileSystemPath FileSystemPath;
    typedef nsresult nsresult__tdef;
    typedef mozilla::Maybe<FileSystemPath> MaybeFileSystemPath__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    mozilla::Maybe<FileSystemPath>*
    ptr_MaybeFileSystemPath()
    {
        return (&(mVMaybeFileSystemPath));
    }
    const mozilla::Maybe<FileSystemPath>*
    constptr_MaybeFileSystemPath() const
    {
        return (&(mVMaybeFileSystemPath));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemResolveResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemResolveResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemResolveResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemResolveResponse(const mozilla::Maybe<FileSystemPath>& aOther);

    MOZ_IMPLICIT FileSystemResolveResponse(mozilla::Maybe<FileSystemPath>&& aOther);

    MOZ_IMPLICIT FileSystemResolveResponse(const FileSystemResolveResponse& aOther);

    MOZ_IMPLICIT FileSystemResolveResponse(FileSystemResolveResponse&& aOther);

    ~FileSystemResolveResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemResolveResponse&
    operator=(const nsresult& aRhs);

    FileSystemResolveResponse&
    operator=(nsresult&& aRhs);

    FileSystemResolveResponse&
    operator=(const mozilla::Maybe<FileSystemPath>& aRhs);

    FileSystemResolveResponse&
    operator=(mozilla::Maybe<FileSystemPath>&& aRhs);

    FileSystemResolveResponse&
    operator=(const FileSystemResolveResponse& aRhs);

    FileSystemResolveResponse&
    operator=(FileSystemResolveResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    mozilla::Maybe<FileSystemPath>&
    get_MaybeFileSystemPath()
    {
        AssertSanity(TMaybeFileSystemPath);
        return (*(ptr_MaybeFileSystemPath()));
    }
    const mozilla::Maybe<FileSystemPath>&
    get_MaybeFileSystemPath() const
    {
        AssertSanity(TMaybeFileSystemPath);
        return (*(constptr_MaybeFileSystemPath()));
    }
    operator mozilla::Maybe<FileSystemPath>&()
    {
        return get_MaybeFileSystemPath();
    }
    operator const mozilla::Maybe<FileSystemPath>&() const
    {
        return get_MaybeFileSystemPath();
    }

private:
    union {
        nsresult mVnsresult;
        mozilla::Maybe<FileSystemPath> mVMaybeFileSystemPath;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemResolveResponse>
{
    typedef ::mozilla::dom::fs::FileSystemResolveResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemRemoveEntryRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemRemoveEntryRequest final
{
private:
    typedef ::mozilla::dom::fs::FileSystemChildMetadata FileSystemChildMetadata;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemRemoveEntryRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemRemoveEntryRequest(
            const FileSystemChildMetadata& _handle,
            const bool& _recursive) :
        handle_(_handle),
        recursive_(_recursive)
    {
    }

    MOZ_IMPLICIT FileSystemRemoveEntryRequest(
            FileSystemChildMetadata&& _handle,
            bool&& _recursive) :
        handle_(std::move(_handle)),
        recursive_(std::move(_recursive))
    {
    }

    FileSystemChildMetadata&
    handle()
    {
        return handle_;
    }
    const FileSystemChildMetadata&
    handle() const
    {
        return handle_;
    }

    bool&
    recursive()
    {
        return recursive_;
    }
    const bool&
    recursive() const
    {
        return recursive_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FileSystemChildMetadata> handle_;
    ::mozilla::ipc::IPDLStructMember<bool> recursive_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemRemoveEntryRequest>
{
    typedef ::mozilla::dom::fs::FileSystemRemoveEntryRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemRemoveEntryResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemRemoveEntryResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        Tvoid_t,
        T__Last = Tvoid_t
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::void_t void_t;
    typedef nsresult nsresult__tdef;
    typedef void_t void_t__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemRemoveEntryResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemRemoveEntryResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemRemoveEntryResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemRemoveEntryResponse(const void_t& aOther);

    MOZ_IMPLICIT FileSystemRemoveEntryResponse(void_t&& aOther);

    MOZ_IMPLICIT FileSystemRemoveEntryResponse(const FileSystemRemoveEntryResponse& aOther);

    MOZ_IMPLICIT FileSystemRemoveEntryResponse(FileSystemRemoveEntryResponse&& aOther);

    ~FileSystemRemoveEntryResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemRemoveEntryResponse&
    operator=(const nsresult& aRhs);

    FileSystemRemoveEntryResponse&
    operator=(nsresult&& aRhs);

    FileSystemRemoveEntryResponse&
    operator=(const void_t& aRhs);

    FileSystemRemoveEntryResponse&
    operator=(void_t&& aRhs);

    FileSystemRemoveEntryResponse&
    operator=(const FileSystemRemoveEntryResponse& aRhs);

    FileSystemRemoveEntryResponse&
    operator=(FileSystemRemoveEntryResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

private:
    union {
        nsresult mVnsresult;
        void_t mVvoid_t;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemRemoveEntryResponse>
{
    typedef ::mozilla::dom::fs::FileSystemRemoveEntryResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemMoveEntryRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemMoveEntryRequest final
{
private:
    typedef ::mozilla::dom::fs::FileSystemEntryMetadata FileSystemEntryMetadata;
    typedef ::mozilla::dom::fs::FileSystemChildMetadata FileSystemChildMetadata;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemMoveEntryRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemMoveEntryRequest(
            const FileSystemEntryMetadata& _handle,
            const FileSystemChildMetadata& _destHandle) :
        handle_(_handle),
        destHandle_(_destHandle)
    {
    }

    MOZ_IMPLICIT FileSystemMoveEntryRequest(
            FileSystemEntryMetadata&& _handle,
            FileSystemChildMetadata&& _destHandle) :
        handle_(std::move(_handle)),
        destHandle_(std::move(_destHandle))
    {
    }

    FileSystemEntryMetadata&
    handle()
    {
        return handle_;
    }
    const FileSystemEntryMetadata&
    handle() const
    {
        return handle_;
    }

    FileSystemChildMetadata&
    destHandle()
    {
        return destHandle_;
    }
    const FileSystemChildMetadata&
    destHandle() const
    {
        return destHandle_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FileSystemEntryMetadata> handle_;
    ::mozilla::ipc::IPDLStructMember<FileSystemChildMetadata> destHandle_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemMoveEntryRequest>
{
    typedef ::mozilla::dom::fs::FileSystemMoveEntryRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemRenameEntryRequest|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemRenameEntryRequest final
{
private:
    typedef ::mozilla::dom::fs::FileSystemEntryMetadata FileSystemEntryMetadata;
    typedef ::mozilla::dom::fs::Name Name;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemRenameEntryRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemRenameEntryRequest(
            const FileSystemEntryMetadata& _handle,
            const Name& _name) :
        handle_(_handle),
        name_(_name)
    {
    }

    MOZ_IMPLICIT FileSystemRenameEntryRequest(
            FileSystemEntryMetadata&& _handle,
            Name&& _name) :
        handle_(std::move(_handle)),
        name_(std::move(_name))
    {
    }

    FileSystemEntryMetadata&
    handle()
    {
        return handle_;
    }
    const FileSystemEntryMetadata&
    handle() const
    {
        return handle_;
    }

    Name&
    name()
    {
        return name_;
    }
    const Name&
    name() const
    {
        return name_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FileSystemEntryMetadata> handle_;
    ::mozilla::ipc::IPDLStructMember<Name> name_;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemRenameEntryRequest>
{
    typedef ::mozilla::dom::fs::FileSystemRenameEntryRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemMoveEntryResponse|
//
namespace mozilla {
namespace dom {
namespace fs {
class FileSystemMoveEntryResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TEntryId,
        T__Last = TEntryId
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::fs::EntryId EntryId;
    typedef nsresult nsresult__tdef;
    typedef EntryId EntryId__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    EntryId*
    ptr_EntryId()
    {
        return (&(mVEntryId));
    }
    const EntryId*
    constptr_EntryId() const
    {
        return (&(mVEntryId));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemMoveEntryResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemMoveEntryResponse(const nsresult& aOther);

    MOZ_IMPLICIT FileSystemMoveEntryResponse(nsresult&& aOther);

    MOZ_IMPLICIT FileSystemMoveEntryResponse(const EntryId& aOther);

    MOZ_IMPLICIT FileSystemMoveEntryResponse(EntryId&& aOther);

    MOZ_IMPLICIT FileSystemMoveEntryResponse(const FileSystemMoveEntryResponse& aOther);

    MOZ_IMPLICIT FileSystemMoveEntryResponse(FileSystemMoveEntryResponse&& aOther);

    ~FileSystemMoveEntryResponse();

    Type
    type() const
    {
        return mType;
    }

    FileSystemMoveEntryResponse&
    operator=(const nsresult& aRhs);

    FileSystemMoveEntryResponse&
    operator=(nsresult&& aRhs);

    FileSystemMoveEntryResponse&
    operator=(const EntryId& aRhs);

    FileSystemMoveEntryResponse&
    operator=(EntryId&& aRhs);

    FileSystemMoveEntryResponse&
    operator=(const FileSystemMoveEntryResponse& aRhs);

    FileSystemMoveEntryResponse&
    operator=(FileSystemMoveEntryResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    EntryId&
    get_EntryId()
    {
        AssertSanity(TEntryId);
        return (*(ptr_EntryId()));
    }
    const EntryId&
    get_EntryId() const
    {
        AssertSanity(TEntryId);
        return (*(constptr_EntryId()));
    }
    operator EntryId&()
    {
        return get_EntryId();
    }
    operator const EntryId&() const
    {
        return get_EntryId();
    }

private:
    union {
        nsresult mVnsresult;
        EntryId mVEntryId;
    };
    Type mType;
};
} // namespace fs
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::fs::FileSystemMoveEntryResponse>
{
    typedef ::mozilla::dom::fs::FileSystemMoveEntryResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PFileSystemManagerParent;
} // namespace dom
} // namespace mozilla
namespace mozilla {
namespace dom {
class PFileSystemManagerChild;
} // namespace dom
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PFileSystemManagerChild and PFileSystemManagerParent
//
namespace mozilla {
namespace dom {
namespace PFileSystemManager {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::dom::PFileSystemManagerParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::PFileSystemManagerChild>* aChild);

nsresult
CreateEndpoints(
        mozilla::ipc::Endpoint<::mozilla::dom::PFileSystemManagerParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::PFileSystemManagerChild>* aChild);

enum MessageType {
    PFileSystemManagerStart = PFileSystemManagerMsgStart << 16,
    Msg_GetRootHandle__ID,
    Reply_GetRootHandle__ID,
    Msg_GetDirectoryHandle__ID,
    Reply_GetDirectoryHandle__ID,
    Msg_GetFileHandle__ID,
    Reply_GetFileHandle__ID,
    Msg_GetFile__ID,
    Reply_GetFile__ID,
    Msg_GetAccessHandle__ID,
    Reply_GetAccessHandle__ID,
    Msg_GetWritable__ID,
    Reply_GetWritable__ID,
    Msg_Resolve__ID,
    Reply_Resolve__ID,
    Msg_GetEntries__ID,
    Reply_GetEntries__ID,
    Msg_RemoveEntry__ID,
    Reply_RemoveEntry__ID,
    Msg_MoveEntry__ID,
    Reply_MoveEntry__ID,
    Msg_RenameEntry__ID,
    Reply_RenameEntry__ID,
    Msg_PFileSystemWritableFileStreamConstructor__ID,
    Reply_PFileSystemWritableFileStreamConstructor__ID,
    Msg_CloseAll__ID,
    Reply_CloseAll__ID,
    PFileSystemManagerEnd
};

mozilla::UniquePtr<IPC::Message>
Msg_GetRootHandle(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetRootHandle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetDirectoryHandle(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetDirectoryHandle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetFileHandle(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetFileHandle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetFile(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetFile(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetAccessHandle(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetAccessHandle(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetWritable(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetWritable(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_Resolve(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_Resolve(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetEntries(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetEntries(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RemoveEntry(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_RemoveEntry(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_MoveEntry(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_MoveEntry(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_RenameEntry(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_RenameEntry(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_PFileSystemWritableFileStreamConstructor(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_PFileSystemWritableFileStreamConstructor(IPC::Message::routeid_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_CloseAll(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_CloseAll(IPC::Message::routeid_t routingId);



} // namespace PFileSystemManager
} // namespace dom
} // namespace mozilla

#endif // ifndef PFileSystemManager_h
