/* THIS FILE IS AUTOGENERATED FROM MediaTrackSettings.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "MediaTrackSettingsBinding.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



MediaTrackSettings::MediaTrackSettings()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
MediaTrackSettings::InitIds(JSContext* cx, MediaTrackSettingsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->width_id.init(cx, "width") ||
      !atomsCache->viewportWidth_id.init(cx, "viewportWidth") ||
      !atomsCache->viewportOffsetY_id.init(cx, "viewportOffsetY") ||
      !atomsCache->viewportOffsetX_id.init(cx, "viewportOffsetX") ||
      !atomsCache->viewportHeight_id.init(cx, "viewportHeight") ||
      !atomsCache->scrollWithPage_id.init(cx, "scrollWithPage") ||
      !atomsCache->resizeMode_id.init(cx, "resizeMode") ||
      !atomsCache->noiseSuppression_id.init(cx, "noiseSuppression") ||
      !atomsCache->mediaSource_id.init(cx, "mediaSource") ||
      !atomsCache->height_id.init(cx, "height") ||
      !atomsCache->groupId_id.init(cx, "groupId") ||
      !atomsCache->frameRate_id.init(cx, "frameRate") ||
      !atomsCache->facingMode_id.init(cx, "facingMode") ||
      !atomsCache->echoCancellation_id.init(cx, "echoCancellation") ||
      !atomsCache->deviceId_id.init(cx, "deviceId") ||
      !atomsCache->channelCount_id.init(cx, "channelCount") ||
      !atomsCache->browserWindow_id.init(cx, "browserWindow") ||
      !atomsCache->autoGainControl_id.init(cx, "autoGainControl")) {
    return false;
  }
  return true;
}

bool
MediaTrackSettings::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
MediaTrackSettings::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  MediaTrackSettingsAtoms* atomsCache = GetAtomCache<MediaTrackSettingsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mAutoGainControl.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mAutoGainControl.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->autoGainControl_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mBrowserWindow.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int64_t const & currentValue = mBrowserWindow.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->browserWindow_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mChannelCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mChannelCount.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->channelCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDeviceId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mDeviceId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->deviceId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mEchoCancellation.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mEchoCancellation.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->echoCancellation_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFacingMode.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mFacingMode.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->facingMode_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFrameRate.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mFrameRate.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frameRate_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mGroupId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mGroupId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->groupId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHeight.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mHeight.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->height_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMediaSource.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mMediaSource.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->mediaSource_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mNoiseSuppression.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mNoiseSuppression.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->noiseSuppression_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mResizeMode.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mResizeMode.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->resizeMode_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mScrollWithPage.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mScrollWithPage.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->scrollWithPage_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mViewportHeight.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mViewportHeight.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->viewportHeight_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mViewportOffsetX.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mViewportOffsetX.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->viewportOffsetX_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mViewportOffsetY.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mViewportOffsetY.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->viewportOffsetY_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mViewportWidth.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mViewportWidth.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->viewportWidth_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mWidth.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mWidth.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->width_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
MediaTrackSettings::TraceDictionary(JSTracer* trc)
{
}

MediaTrackSettings&
MediaTrackSettings::operator=(const MediaTrackSettings& aOther)
{
  DictionaryBase::operator=(aOther);
  mAutoGainControl.Reset();
  if (aOther.mAutoGainControl.WasPassed()) {
    mAutoGainControl.Construct(aOther.mAutoGainControl.Value());
  }
  mBrowserWindow.Reset();
  if (aOther.mBrowserWindow.WasPassed()) {
    mBrowserWindow.Construct(aOther.mBrowserWindow.Value());
  }
  mChannelCount.Reset();
  if (aOther.mChannelCount.WasPassed()) {
    mChannelCount.Construct(aOther.mChannelCount.Value());
  }
  mDeviceId.Reset();
  if (aOther.mDeviceId.WasPassed()) {
    mDeviceId.Construct(aOther.mDeviceId.Value());
  }
  mEchoCancellation.Reset();
  if (aOther.mEchoCancellation.WasPassed()) {
    mEchoCancellation.Construct(aOther.mEchoCancellation.Value());
  }
  mFacingMode.Reset();
  if (aOther.mFacingMode.WasPassed()) {
    mFacingMode.Construct(aOther.mFacingMode.Value());
  }
  mFrameRate.Reset();
  if (aOther.mFrameRate.WasPassed()) {
    mFrameRate.Construct(aOther.mFrameRate.Value());
  }
  mGroupId.Reset();
  if (aOther.mGroupId.WasPassed()) {
    mGroupId.Construct(aOther.mGroupId.Value());
  }
  mHeight.Reset();
  if (aOther.mHeight.WasPassed()) {
    mHeight.Construct(aOther.mHeight.Value());
  }
  mMediaSource.Reset();
  if (aOther.mMediaSource.WasPassed()) {
    mMediaSource.Construct(aOther.mMediaSource.Value());
  }
  mNoiseSuppression.Reset();
  if (aOther.mNoiseSuppression.WasPassed()) {
    mNoiseSuppression.Construct(aOther.mNoiseSuppression.Value());
  }
  mResizeMode.Reset();
  if (aOther.mResizeMode.WasPassed()) {
    mResizeMode.Construct(aOther.mResizeMode.Value());
  }
  mScrollWithPage.Reset();
  if (aOther.mScrollWithPage.WasPassed()) {
    mScrollWithPage.Construct(aOther.mScrollWithPage.Value());
  }
  mViewportHeight.Reset();
  if (aOther.mViewportHeight.WasPassed()) {
    mViewportHeight.Construct(aOther.mViewportHeight.Value());
  }
  mViewportOffsetX.Reset();
  if (aOther.mViewportOffsetX.WasPassed()) {
    mViewportOffsetX.Construct(aOther.mViewportOffsetX.Value());
  }
  mViewportOffsetY.Reset();
  if (aOther.mViewportOffsetY.WasPassed()) {
    mViewportOffsetY.Construct(aOther.mViewportOffsetY.Value());
  }
  mViewportWidth.Reset();
  if (aOther.mViewportWidth.WasPassed()) {
    mViewportWidth.Construct(aOther.mViewportWidth.Value());
  }
  mWidth.Reset();
  if (aOther.mWidth.WasPassed()) {
    mWidth.Construct(aOther.mWidth.Value());
  }
  return *this;
}


} // namespace mozilla::dom
