#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_XIM_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_XIM_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-xim", _Xim_)

static void*
__fcitx_Xim_function_ConsumeQueue(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXimFrontend*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxXimFrontend* self = __self;
    FCITX_UNUSED(self);
    XimConsumeQueue(self);
    return NULL;
}

static void
FcitxXimAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_Xim_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_Xim_addon_functions_table[] = {
        __fcitx_Xim_function_ConsumeQueue,
    };
    for (i = 0;i < 1;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_Xim_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
