// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-security.xml

#ifndef QT_WAYLAND_SERVER_DDE_SECURITY
#define QT_WAYLAND_SERVER_DDE_SECURITY

#include "wayland-server-core.h"
#include "wayland-dde-security-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  dde_security
    {
    public:
        dde_security(struct ::wl_client *client, int id, int version);
        dde_security(struct ::wl_display *display, int version);
        dde_security(struct ::wl_resource *resource);
        dde_security();

        virtual ~dde_security();

        class Resource
        {
        public:
            Resource() : dde_security_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_security *dde_security_object;
            dde_security *object() { return dde_security_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum types {
            types_sec_clipboard_copy = 1 << 0,
        };

        enum permissions {
            permissions_permission_allow = 1 << 0,
            permissions_permission_deny = 1 << 1,
        };

        void send_ace_clients(uint32_t count, const QByteArray &clients);
        void send_ace_clients(struct ::wl_resource *resource, uint32_t count, const QByteArray &clients);

    protected:
        virtual Resource *dde_security_allocate();

        virtual void dde_security_destroy_global();

        virtual void dde_security_bind_resource(Resource *resource);
        virtual void dde_security_destroy_resource(Resource *resource);

        virtual void dde_security_get_session(Resource *resource, uint32_t id, uint32_t types);
        virtual void dde_security_get_ace_clients(Resource *resource, uint32_t pid);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_security_interface m_dde_security_interface;

        static void handle_get_session(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            uint32_t types);
        static void handle_get_ace_clients(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t pid);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_security *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  security_session
    {
    public:
        security_session(struct ::wl_client *client, int id, int version);
        security_session(struct ::wl_display *display, int version);
        security_session(struct ::wl_resource *resource);
        security_session();

        virtual ~security_session();

        class Resource
        {
        public:
            Resource() : security_session_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            security_session *security_session_object;
            security_session *object() { return security_session_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_verify_security(uint32_t types, uint32_t client, uint32_t target, uint32_t serial);
        void send_verify_security(struct ::wl_resource *resource, uint32_t types, uint32_t client, uint32_t target, uint32_t serial);

    protected:
        virtual Resource *security_session_allocate();

        virtual void security_session_destroy_global();

        virtual void security_session_bind_resource(Resource *resource);
        virtual void security_session_destroy_resource(Resource *resource);

        virtual void security_session_destroy(Resource *resource);
        virtual void security_session_report_security(Resource *resource, uint32_t types, uint32_t permission, uint32_t serial);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::security_session_interface m_security_session_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_report_security(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t types,
            uint32_t permission,
            uint32_t serial);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            security_session *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
