
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_animviz.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_AnimViz_rna_properties;
extern PropertyRNA &rna_AnimViz_rna_type;
extern PropertyRNA &rna_AnimViz_motion_path;


extern PropertyRNA &rna_AnimVizMotionPaths_rna_properties;
extern PropertyRNA &rna_AnimVizMotionPaths_rna_type;
extern PropertyRNA &rna_AnimVizMotionPaths_type;
extern PropertyRNA &rna_AnimVizMotionPaths_range;
extern PropertyRNA &rna_AnimVizMotionPaths_bake_location;
extern PropertyRNA &rna_AnimVizMotionPaths_show_frame_numbers;
extern PropertyRNA &rna_AnimVizMotionPaths_show_keyframe_highlight;
extern PropertyRNA &rna_AnimVizMotionPaths_show_keyframe_numbers;
extern PropertyRNA &rna_AnimVizMotionPaths_show_keyframe_action_all;
extern PropertyRNA &rna_AnimVizMotionPaths_frame_step;
extern PropertyRNA &rna_AnimVizMotionPaths_frame_start;
extern PropertyRNA &rna_AnimVizMotionPaths_frame_end;
extern PropertyRNA &rna_AnimVizMotionPaths_frame_before;
extern PropertyRNA &rna_AnimVizMotionPaths_frame_after;
extern PropertyRNA &rna_AnimVizMotionPaths_has_motion_paths;
extern PropertyRNA &rna_AnimVizMotionPaths_use_camera_space_bake;


extern PropertyRNA &rna_MotionPath_rna_properties;
extern PropertyRNA &rna_MotionPath_rna_type;
extern PropertyRNA &rna_MotionPath_points;
extern PropertyRNA &rna_MotionPath_frame_start;
extern PropertyRNA &rna_MotionPath_frame_end;
extern PropertyRNA &rna_MotionPath_length;
extern PropertyRNA &rna_MotionPath_color;
extern PropertyRNA &rna_MotionPath_color_post;
extern PropertyRNA &rna_MotionPath_line_thickness;
extern PropertyRNA &rna_MotionPath_use_bone_head;
extern PropertyRNA &rna_MotionPath_is_modified;
extern PropertyRNA &rna_MotionPath_use_custom_color;
extern PropertyRNA &rna_MotionPath_lines;


extern PropertyRNA &rna_MotionPathVert_rna_properties;
extern PropertyRNA &rna_MotionPathVert_rna_type;
extern PropertyRNA &rna_MotionPathVert_co;
extern PropertyRNA &rna_MotionPathVert_select;

static PointerRNA AnimViz_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AnimViz_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AnimViz_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AnimViz_rna_properties_get(iter);
    }
}

extern void AnimViz_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AnimViz_rna_properties_get(iter);
    }
}

extern void AnimViz_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AnimViz_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AnimViz_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern PointerRNA AnimViz_motion_path_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_AnimViz_motion_paths_get;
    return fn(ptr);
}

static PointerRNA AnimVizMotionPaths_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AnimVizMotionPaths_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AnimVizMotionPaths_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AnimVizMotionPaths_rna_properties_get(iter);
    }
}

extern void AnimVizMotionPaths_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AnimVizMotionPaths_rna_properties_get(iter);
    }
}

extern void AnimVizMotionPaths_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AnimVizMotionPaths_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AnimVizMotionPaths_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int AnimVizMotionPaths_type_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_type);
}

extern void AnimVizMotionPaths_type_set(PointerRNA *ptr, int value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
#ifdef __cplusplus
    data->path_type = (std::remove_reference_t<decltype(data->path_type)>)value;
#else
    data->path_type = value;
#endif
}

extern int AnimVizMotionPaths_range_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_range);
}

extern void AnimVizMotionPaths_range_set(PointerRNA *ptr, int value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
#ifdef __cplusplus
    data->path_range = (std::remove_reference_t<decltype(data->path_range)>)value;
#else
    data->path_range = value;
#endif
}

extern int AnimVizMotionPaths_bake_location_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return ((data->path_bakeflag) & 2);
}

extern void AnimVizMotionPaths_bake_location_set(PointerRNA *ptr, int value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    data->path_bakeflag &= ~2;
    data->path_bakeflag |= value;
}

extern bool AnimVizMotionPaths_show_frame_numbers_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (((data->path_viewflag) & 1) != 0);
}

extern void AnimVizMotionPaths_show_frame_numbers_set(PointerRNA *ptr, bool value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    if (value) { data->path_viewflag |= 1; }
    else { data->path_viewflag &= ~1; }
}

extern bool AnimVizMotionPaths_show_keyframe_highlight_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (((data->path_viewflag) & 2) != 0);
}

extern void AnimVizMotionPaths_show_keyframe_highlight_set(PointerRNA *ptr, bool value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    if (value) { data->path_viewflag |= 2; }
    else { data->path_viewflag &= ~2; }
}

extern bool AnimVizMotionPaths_show_keyframe_numbers_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (((data->path_viewflag) & 4) != 0);
}

extern void AnimVizMotionPaths_show_keyframe_numbers_set(PointerRNA *ptr, bool value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    if (value) { data->path_viewflag |= 4; }
    else { data->path_viewflag &= ~4; }
}

extern bool AnimVizMotionPaths_show_keyframe_action_all_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (((data->path_viewflag) & 8) != 0);
}

extern void AnimVizMotionPaths_show_keyframe_action_all_set(PointerRNA *ptr, bool value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    if (value) { data->path_viewflag |= 8; }
    else { data->path_viewflag &= ~8; }
}

extern int AnimVizMotionPaths_frame_step_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_step);
}

extern void AnimVizMotionPaths_frame_step_set(PointerRNA *ptr, int value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
#ifdef __cplusplus
    data->path_step = (std::remove_reference_t<decltype(data->path_step)>)std::clamp(value, 1, 100);
#else
    data->path_step = std::clamp(value, 1, 100);
#endif
}

extern int AnimVizMotionPaths_frame_start_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_sf);
}

extern void AnimVizMotionPaths_frame_start_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_AnimViz_path_start_frame_set;
    fn(ptr, value);
}

extern int AnimVizMotionPaths_frame_end_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_ef);
}

extern void AnimVizMotionPaths_frame_end_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_AnimViz_path_end_frame_set;
    fn(ptr, value);
}

extern int AnimVizMotionPaths_frame_before_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_bc);
}

extern void AnimVizMotionPaths_frame_before_set(PointerRNA *ptr, int value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
#ifdef __cplusplus
    data->path_bc = (std::remove_reference_t<decltype(data->path_bc)>)std::clamp(value, 1, 524287);
#else
    data->path_bc = std::clamp(value, 1, 524287);
#endif
}

extern int AnimVizMotionPaths_frame_after_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (int)(data->path_ac);
}

extern void AnimVizMotionPaths_frame_after_set(PointerRNA *ptr, int value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
#ifdef __cplusplus
    data->path_ac = (std::remove_reference_t<decltype(data->path_ac)>)std::clamp(value, 1, 524287);
#else
    data->path_ac = std::clamp(value, 1, 524287);
#endif
}

extern bool AnimVizMotionPaths_has_motion_paths_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (((data->path_bakeflag) & 4) != 0);
}

extern bool AnimVizMotionPaths_use_camera_space_bake_get(PointerRNA *ptr)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    return (((data->path_bakeflag) & 8) != 0);
}

extern void AnimVizMotionPaths_use_camera_space_bake_set(PointerRNA *ptr, bool value)
{
    bAnimVizSettings *data = (bAnimVizSettings *)(ptr->data);
    if (value) { data->path_bakeflag |= 8; }
    else { data->path_bakeflag &= ~8; }
}

static PointerRNA MotionPath_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MotionPath_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MotionPath_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MotionPath_rna_properties_get(iter);
    }
}

extern void MotionPath_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MotionPath_rna_properties_get(iter);
    }
}

extern void MotionPath_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MotionPath_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MotionPath_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int MotionPath_points_length(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (data->points == nullptr) ? 0 : data->length;
}

static PointerRNA MotionPath_points_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_MotionPathVert, rna_iterator_array_get(iter));
}

extern void MotionPath_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MotionPath_points;

    rna_iterator_array_begin(iter, ptr, data->points, sizeof(data->points[0]), data->length, 0, nullptr);

    if (iter->valid) {
        iter->ptr = MotionPath_points_get(iter);
    }
}

extern void MotionPath_points_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_array_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MotionPath_points_get(iter);
    }
}

extern void MotionPath_points_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_array_end;
    fn(iter);
}

extern bool MotionPath_points_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    MotionPath_points_begin(&iter, ptr);

    if (iter.valid) {
        ArrayIterator *internal = &iter.internal.array;
        if (index < 0 || index >= internal->length) {
#ifdef __GNUC__
            printf("Array iterator out of range: %s (index %d)\n", __func__, index);
#else
            printf("Array iterator out of range: (index %d)\n", index);
#endif
        }
        else if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_array_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            internal->ptr += internal->itemsize * index;
            found = 1;
        }
        if (found) { *r_ptr = MotionPath_points_get(&iter); }
    }

    MotionPath_points_end(&iter);

    return found;
}

extern int MotionPath_frame_start_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (int)(data->start_frame);
}

extern int MotionPath_frame_end_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (int)(data->end_frame);
}

extern int MotionPath_length_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (int)(data->length);
}

extern void MotionPath_color_get(PointerRNA *ptr, float values[3])
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->color)[i]);
    }
}

extern void MotionPath_color_set(PointerRNA *ptr, const float values[3])
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->color)[i] = std::clamp(values[i], 0.0f, FLT_MAX);
    }
}

extern void MotionPath_color_post_get(PointerRNA *ptr, float values[3])
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->color_post)[i]);
    }
}

extern void MotionPath_color_post_set(PointerRNA *ptr, const float values[3])
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->color_post)[i] = std::clamp(values[i], 0.0f, FLT_MAX);
    }
}

extern int MotionPath_line_thickness_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (int)(data->line_thickness);
}

extern void MotionPath_line_thickness_set(PointerRNA *ptr, int value)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
#ifdef __cplusplus
    data->line_thickness = (std::remove_reference_t<decltype(data->line_thickness)>)std::clamp(value, 1, 6);
#else
    data->line_thickness = std::clamp(value, 1, 6);
#endif
}

extern bool MotionPath_use_bone_head_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern bool MotionPath_is_modified_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void MotionPath_is_modified_set(PointerRNA *ptr, bool value)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    if (value) { data->flag |= 2; }
    else { data->flag &= ~2; }
}

extern bool MotionPath_use_custom_color_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (((data->flag) & 4) != 0);
}

extern void MotionPath_use_custom_color_set(PointerRNA *ptr, bool value)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    if (value) { data->flag |= 4; }
    else { data->flag &= ~4; }
}

extern bool MotionPath_lines_get(PointerRNA *ptr)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    return (((data->flag) & 8) != 0);
}

extern void MotionPath_lines_set(PointerRNA *ptr, bool value)
{
    bMotionPath *data = (bMotionPath *)(ptr->data);
    if (value) { data->flag |= 8; }
    else { data->flag &= ~8; }
}

static PointerRNA MotionPathVert_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MotionPathVert_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MotionPathVert_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MotionPathVert_rna_properties_get(iter);
    }
}

extern void MotionPathVert_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MotionPathVert_rna_properties_get(iter);
    }
}

extern void MotionPathVert_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MotionPathVert_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MotionPathVert_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void MotionPathVert_co_get(PointerRNA *ptr, float values[3])
{
    bMotionPathVert *data = (bMotionPathVert *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->co)[i]);
    }
}

extern void MotionPathVert_co_set(PointerRNA *ptr, const float values[3])
{
    bMotionPathVert *data = (bMotionPathVert *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->co)[i] = values[i];
    }
}

extern bool MotionPathVert_select_get(PointerRNA *ptr)
{
    bMotionPathVert *data = (bMotionPathVert *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern void MotionPathVert_select_set(PointerRNA *ptr, bool value)
{
    bMotionPathVert *data = (bMotionPathVert *)(ptr->data);
    if (value) { data->flag |= 1; }
    else { data->flag &= ~1; }
}





/* Animation Visualization */
static CollectionPropertyRNA rna_AnimViz_rna_properties_ = {
	{&rna_AnimViz_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimViz_rna_properties_begin, AnimViz_rna_properties_next, AnimViz_rna_properties_end, AnimViz_rna_properties_get, nullptr, nullptr, AnimViz_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AnimViz_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AnimViz_rna_properties_);

static PointerPropertyRNA rna_AnimViz_rna_type_ = {
	{&rna_AnimViz_motion_path, &rna_AnimViz_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimViz_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AnimViz_rna_type = reinterpret_cast<PropertyRNA &>(rna_AnimViz_rna_type_);

static PointerPropertyRNA rna_AnimViz_motion_path_ = {
	{nullptr, &rna_AnimViz_rna_type,
	-1, "motion_path", 8650752, 1, 0, 0, 0, PropertyPathTemplateType(0), "Motion Paths",
	"Motion Path settings for visualization",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimViz_motion_path_get, nullptr, nullptr, nullptr,&RNA_AnimVizMotionPaths
};
PropertyRNA &rna_AnimViz_motion_path = reinterpret_cast<PropertyRNA &>(rna_AnimViz_motion_path_);

StructRNA RNA_AnimViz = {
	{(ContainerRNA *)&RNA_AnimVizMotionPaths, (ContainerRNA *)&RNA_KeyingSetInfo,
	nullptr,
	{&rna_AnimViz_rna_properties, &rna_AnimViz_motion_path}},
	"AnimViz", nullptr, nullptr, 516, nullptr, "Animation Visualization",
	"Settings for the visualization of motion",
	"*", 63,
	nullptr, &rna_AnimViz_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Motion Path Settings */
static CollectionPropertyRNA rna_AnimVizMotionPaths_rna_properties_ = {
	{&rna_AnimVizMotionPaths_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_rna_properties_begin, AnimVizMotionPaths_rna_properties_next, AnimVizMotionPaths_rna_properties_end, AnimVizMotionPaths_rna_properties_get, nullptr, nullptr, AnimVizMotionPaths_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AnimVizMotionPaths_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_rna_properties_);

static PointerPropertyRNA rna_AnimVizMotionPaths_rna_type_ = {
	{&rna_AnimVizMotionPaths_type, &rna_AnimVizMotionPaths_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AnimVizMotionPaths_rna_type = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_rna_type_);

static EnumPropertyRNA rna_AnimVizMotionPaths_type_ = {
	{&rna_AnimVizMotionPaths_range, &rna_AnimVizMotionPaths_rna_type,
	-1, "type", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Paths Type",
	"Type of range to show for Motion Paths",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bAnimVizSettings, path_type), RawPropertyType(1), nullptr},
	AnimVizMotionPaths_type_get, AnimVizMotionPaths_type_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_motionpath_display_type_items, 2, 0
};
PropertyRNA &rna_AnimVizMotionPaths_type = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_type_);

static EnumPropertyRNA rna_AnimVizMotionPaths_range_ = {
	{&rna_AnimVizMotionPaths_bake_location, &rna_AnimVizMotionPaths_type,
	-1, "range", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Paths Range",
	"Type of range to calculate for Motion Paths",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bAnimVizSettings, path_range), RawPropertyType(1), nullptr},
	AnimVizMotionPaths_range_get, AnimVizMotionPaths_range_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_motionpath_range_items, 4, 0
};
PropertyRNA &rna_AnimVizMotionPaths_range = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_range_);

static EnumPropertyRNA rna_AnimVizMotionPaths_bake_location_ = {
	{&rna_AnimVizMotionPaths_show_frame_numbers, &rna_AnimVizMotionPaths_range,
	-1, "bake_location", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Bake Location",
	"When calculating Bone Paths, use Head or Tips",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bAnimVizSettings, path_bakeflag), RawPropertyType(1), nullptr},
	AnimVizMotionPaths_bake_location_get, AnimVizMotionPaths_bake_location_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_motionpath_bake_location_items, 2, 0
};
PropertyRNA &rna_AnimVizMotionPaths_bake_location = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_bake_location_);

static BoolPropertyRNA rna_AnimVizMotionPaths_show_frame_numbers_ = {
	{&rna_AnimVizMotionPaths_show_keyframe_highlight, &rna_AnimVizMotionPaths_bake_location,
	-1, "show_frame_numbers", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "Show Frame Numbers",
	"Show frame numbers on Motion Paths",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_show_frame_numbers_get, AnimVizMotionPaths_show_frame_numbers_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_show_frame_numbers = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_show_frame_numbers_);

static BoolPropertyRNA rna_AnimVizMotionPaths_show_keyframe_highlight_ = {
	{&rna_AnimVizMotionPaths_show_keyframe_numbers, &rna_AnimVizMotionPaths_show_frame_numbers,
	-1, "show_keyframe_highlight", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "Highlight Keyframes",
	"Emphasize position of keyframes on Motion Paths",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_show_keyframe_highlight_get, AnimVizMotionPaths_show_keyframe_highlight_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_show_keyframe_highlight = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_show_keyframe_highlight_);

static BoolPropertyRNA rna_AnimVizMotionPaths_show_keyframe_numbers_ = {
	{&rna_AnimVizMotionPaths_show_keyframe_action_all, &rna_AnimVizMotionPaths_show_keyframe_highlight,
	-1, "show_keyframe_numbers", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "Show Keyframe Numbers",
	"Show frame numbers of Keyframes on Motion Paths",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_show_keyframe_numbers_get, AnimVizMotionPaths_show_keyframe_numbers_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_show_keyframe_numbers = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_show_keyframe_numbers_);

static BoolPropertyRNA rna_AnimVizMotionPaths_show_keyframe_action_all_ = {
	{&rna_AnimVizMotionPaths_frame_step, &rna_AnimVizMotionPaths_show_keyframe_numbers,
	-1, "show_keyframe_action_all", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "All Action Keyframes",
	"For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_show_keyframe_action_all_get, AnimVizMotionPaths_show_keyframe_action_all_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_show_keyframe_action_all = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_show_keyframe_action_all_);

static IntPropertyRNA rna_AnimVizMotionPaths_frame_step_ = {
	{&rna_AnimVizMotionPaths_frame_start, &rna_AnimVizMotionPaths_show_keyframe_action_all,
	-1, "frame_step", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Frame Step",
	"Number of frames between paths shown (not for \'On Keyframes\' Onion-skinning method)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bAnimVizSettings, path_step), RawPropertyType(1), nullptr},
	AnimVizMotionPaths_frame_step_get, AnimVizMotionPaths_frame_step_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 100, 1, 100, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_frame_step = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_frame_step_);

static IntPropertyRNA rna_AnimVizMotionPaths_frame_start_ = {
	{&rna_AnimVizMotionPaths_frame_end, &rna_AnimVizMotionPaths_frame_step,
	-1, "frame_start", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "Start Frame",
	"Starting frame of range of paths to display/calculate (not for \'Around Frame\' Onion-skinning method)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_frame_start_get, AnimVizMotionPaths_frame_start_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_frame_start = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_frame_start_);

static IntPropertyRNA rna_AnimVizMotionPaths_frame_end_ = {
	{&rna_AnimVizMotionPaths_frame_before, &rna_AnimVizMotionPaths_frame_start,
	-1, "frame_end", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "End Frame",
	"End frame of range of paths to display/calculate (not for \'Around Frame\' Onion-skinning method)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_frame_end_get, AnimVizMotionPaths_frame_end_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_frame_end = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_frame_end_);

static IntPropertyRNA rna_AnimVizMotionPaths_frame_before_ = {
	{&rna_AnimVizMotionPaths_frame_after, &rna_AnimVizMotionPaths_frame_end,
	-1, "frame_before", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Before Current",
	"Number of frames to show before the current frame (only for \'Around Frame\' Onion-skinning method)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bAnimVizSettings, path_bc), RawPropertyType(0), nullptr},
	AnimVizMotionPaths_frame_before_get, AnimVizMotionPaths_frame_before_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 524287, 1, 524287, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_frame_before = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_frame_before_);

static IntPropertyRNA rna_AnimVizMotionPaths_frame_after_ = {
	{&rna_AnimVizMotionPaths_has_motion_paths, &rna_AnimVizMotionPaths_frame_before,
	-1, "frame_after", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "After Current",
	"Number of frames to show after the current frame (only for \'Around Frame\' Onion-skinning method)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bAnimVizSettings, path_ac), RawPropertyType(0), nullptr},
	AnimVizMotionPaths_frame_after_get, AnimVizMotionPaths_frame_after_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 524287, 1, 524287, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_frame_after = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_frame_after_);

static BoolPropertyRNA rna_AnimVizMotionPaths_has_motion_paths_ = {
	{&rna_AnimVizMotionPaths_use_camera_space_bake, &rna_AnimVizMotionPaths_frame_after,
	-1, "has_motion_paths", 2, 1, 0, 0, 0, PropertyPathTemplateType(0), "Has Motion Paths",
	"Are there any bone paths that will need updating (read-only)",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_has_motion_paths_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_has_motion_paths = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_has_motion_paths_);

static BoolPropertyRNA rna_AnimVizMotionPaths_use_camera_space_bake_ = {
	{nullptr, &rna_AnimVizMotionPaths_has_motion_paths,
	-1, "use_camera_space_bake", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "Bake to active Camera",
	"Motion path points will be baked into the camera space of the active camera. This means they will only look right when looking through that camera. Switching cameras using markers is not supported.",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AnimVizMotionPaths_use_camera_space_bake_get, AnimVizMotionPaths_use_camera_space_bake_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AnimVizMotionPaths_use_camera_space_bake = reinterpret_cast<PropertyRNA &>(rna_AnimVizMotionPaths_use_camera_space_bake_);

StructRNA RNA_AnimVizMotionPaths = {
	{(ContainerRNA *)&RNA_MotionPath, (ContainerRNA *)&RNA_AnimViz,
	nullptr,
	{&rna_AnimVizMotionPaths_rna_properties, &rna_AnimVizMotionPaths_use_camera_space_bake}},
	"AnimVizMotionPaths", nullptr, nullptr, 516, nullptr, "Motion Path Settings",
	"Motion Path settings for animation visualization",
	"*", 63,
	nullptr, &rna_AnimVizMotionPaths_rna_properties,
	nullptr,
	&RNA_AnimViz,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Motion Path */
static CollectionPropertyRNA rna_MotionPath_rna_properties_ = {
	{&rna_MotionPath_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_rna_properties_begin, MotionPath_rna_properties_next, MotionPath_rna_properties_end, MotionPath_rna_properties_get, nullptr, nullptr, MotionPath_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MotionPath_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MotionPath_rna_properties_);

static PointerPropertyRNA rna_MotionPath_rna_type_ = {
	{&rna_MotionPath_points, &rna_MotionPath_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MotionPath_rna_type = reinterpret_cast<PropertyRNA &>(rna_MotionPath_rna_type_);

static CollectionPropertyRNA rna_MotionPath_points_ = {
	{&rna_MotionPath_frame_start, &rna_MotionPath_rna_type,
	-1, "points", 0, 0, 0, 8, 0, PropertyPathTemplateType(0), "Motion Path Points",
	"Cached positions per frame",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_points_begin, MotionPath_points_next, MotionPath_points_end, MotionPath_points_get, MotionPath_points_length, MotionPath_points_lookup_int, nullptr, nullptr, &RNA_MotionPathVert
};
PropertyRNA &rna_MotionPath_points = reinterpret_cast<PropertyRNA &>(rna_MotionPath_points_);

static IntPropertyRNA rna_MotionPath_frame_start_ = {
	{&rna_MotionPath_frame_end, &rna_MotionPath_points,
	-1, "frame_start", 2, 0, 0, 4, 0, PropertyPathTemplateType(0), "Start Frame",
	"Starting frame of the stored range",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPath, start_frame), RawPropertyType(0), nullptr},
	MotionPath_frame_start_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_frame_start = reinterpret_cast<PropertyRNA &>(rna_MotionPath_frame_start_);

static IntPropertyRNA rna_MotionPath_frame_end_ = {
	{&rna_MotionPath_length, &rna_MotionPath_frame_start,
	-1, "frame_end", 2, 0, 0, 4, 0, PropertyPathTemplateType(0), "End Frame",
	"End frame of the stored range",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPath, end_frame), RawPropertyType(0), nullptr},
	MotionPath_frame_end_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_frame_end = reinterpret_cast<PropertyRNA &>(rna_MotionPath_frame_end_);

static IntPropertyRNA rna_MotionPath_length_ = {
	{&rna_MotionPath_color, &rna_MotionPath_frame_end,
	-1, "length", 2, 0, 0, 4, 0, PropertyPathTemplateType(0), "Length",
	"Number of frames cached",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPath, length), RawPropertyType(0), nullptr},
	MotionPath_length_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_length = reinterpret_cast<PropertyRNA &>(rna_MotionPath_length_);

static float rna_MotionPath_color_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_MotionPath_color_ = {
	{&rna_MotionPath_color_post, &rna_MotionPath_length,
	-1, "color", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Color Pre",
	"Custom color for motion path before the current frame",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_COLOR_GAMMA) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPath, color), RawPropertyType(5), nullptr},
	nullptr, nullptr, MotionPath_color_get, MotionPath_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_MotionPath_color_default
};
PropertyRNA &rna_MotionPath_color = reinterpret_cast<PropertyRNA &>(rna_MotionPath_color_);

static float rna_MotionPath_color_post_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_MotionPath_color_post_ = {
	{&rna_MotionPath_line_thickness, &rna_MotionPath_color,
	-1, "color_post", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Color Post",
	"Custom color for motion path after the current frame",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_COLOR_GAMMA) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPath, color_post), RawPropertyType(5), nullptr},
	nullptr, nullptr, MotionPath_color_post_get, MotionPath_color_post_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_MotionPath_color_post_default
};
PropertyRNA &rna_MotionPath_color_post = reinterpret_cast<PropertyRNA &>(rna_MotionPath_color_post_);

static IntPropertyRNA rna_MotionPath_line_thickness_ = {
	{&rna_MotionPath_use_bone_head, &rna_MotionPath_color_post,
	-1, "line_thickness", 3, 1, 0, 4, 0, PropertyPathTemplateType(0), "Line Thickness",
	"Line thickness for motion path",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPath, line_thickness), RawPropertyType(0), nullptr},
	MotionPath_line_thickness_get, MotionPath_line_thickness_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 6, 1, 6, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_line_thickness = reinterpret_cast<PropertyRNA &>(rna_MotionPath_line_thickness_);

static BoolPropertyRNA rna_MotionPath_use_bone_head_ = {
	{&rna_MotionPath_is_modified, &rna_MotionPath_line_thickness,
	-1, "use_bone_head", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Use Bone Heads",
	"For PoseBone paths, use the bone head location when calculating this path",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_use_bone_head_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_use_bone_head = reinterpret_cast<PropertyRNA &>(rna_MotionPath_use_bone_head_);

static BoolPropertyRNA rna_MotionPath_is_modified_ = {
	{&rna_MotionPath_use_custom_color, &rna_MotionPath_use_bone_head,
	-1, "is_modified", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Edit Path",
	"Path is being edited",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_is_modified_get, MotionPath_is_modified_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_is_modified = reinterpret_cast<PropertyRNA &>(rna_MotionPath_is_modified_);

static BoolPropertyRNA rna_MotionPath_use_custom_color_ = {
	{&rna_MotionPath_lines, &rna_MotionPath_is_modified,
	-1, "use_custom_color", 3, 1, 0, 0, 0, PropertyPathTemplateType(0), "Custom Colors",
	"Use custom color for this motion path",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_use_custom_color_get, MotionPath_use_custom_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_use_custom_color = reinterpret_cast<PropertyRNA &>(rna_MotionPath_use_custom_color_);

static BoolPropertyRNA rna_MotionPath_lines_ = {
	{nullptr, &rna_MotionPath_use_custom_color,
	-1, "lines", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Lines",
	"Use straight lines between keyframe points",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 102825984, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPath_lines_get, MotionPath_lines_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPath_lines = reinterpret_cast<PropertyRNA &>(rna_MotionPath_lines_);

StructRNA RNA_MotionPath = {
	{(ContainerRNA *)&RNA_MotionPathVert, (ContainerRNA *)&RNA_AnimVizMotionPaths,
	nullptr,
	{&rna_MotionPath_rna_properties, &rna_MotionPath_lines}},
	"MotionPath", nullptr, nullptr, 516, nullptr, "Motion Path",
	"Cache of the world-space positions of an element over a frame range",
	"*", 63,
	nullptr, &rna_MotionPath_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Motion Path Cache Point */
static CollectionPropertyRNA rna_MotionPathVert_rna_properties_ = {
	{&rna_MotionPathVert_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPathVert_rna_properties_begin, MotionPathVert_rna_properties_next, MotionPathVert_rna_properties_end, MotionPathVert_rna_properties_get, nullptr, nullptr, MotionPathVert_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MotionPathVert_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MotionPathVert_rna_properties_);

static PointerPropertyRNA rna_MotionPathVert_rna_type_ = {
	{&rna_MotionPathVert_co, &rna_MotionPathVert_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPathVert_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MotionPathVert_rna_type = reinterpret_cast<PropertyRNA &>(rna_MotionPathVert_rna_type_);

static float rna_MotionPathVert_co_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_MotionPathVert_co_ = {
	{&rna_MotionPathVert_select, &rna_MotionPathVert_rna_type,
	-1, "co", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Coordinates",
	"",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_XYZ) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bMotionPathVert, co), RawPropertyType(5), nullptr},
	nullptr, nullptr, MotionPathVert_co_get, MotionPathVert_co_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_MotionPathVert_co_default
};
PropertyRNA &rna_MotionPathVert_co = reinterpret_cast<PropertyRNA &>(rna_MotionPathVert_co_);

static BoolPropertyRNA rna_MotionPathVert_select_ = {
	{nullptr, &rna_MotionPathVert_co,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select",
	"Path point is selected for editing",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MotionPathVert_select_get, MotionPathVert_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MotionPathVert_select = reinterpret_cast<PropertyRNA &>(rna_MotionPathVert_select_);

StructRNA RNA_MotionPathVert = {
	{(ContainerRNA *)&RNA_BoneColor, (ContainerRNA *)&RNA_MotionPath,
	nullptr,
	{&rna_MotionPathVert_rna_properties, &rna_MotionPathVert_select}},
	"MotionPathVert", nullptr, nullptr, 516, nullptr, "Motion Path Cache Point",
	"Cached location on path",
	"*", 63,
	nullptr, &rna_MotionPathVert_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

