/* baobab-scanner.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-scanner.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#define BAOBAB_SCANNER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_UNIX_NLINK "," G_FILE_ATTRIBUTE_UNIX_INODE "," G_FILE_ATTRIBUTE_UNIX_DEVICE
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _BaobabScannerHardLink BaobabScannerHardLink;
typedef struct _BaobabScannerResultsArray BaobabScannerResultsArray;
enum  {
	BAOBAB_SCANNER_0_PROPERTY,
	BAOBAB_SCANNER_ROOT_PROPERTY,
	BAOBAB_SCANNER_DIRECTORY_PROPERTY,
	BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY,
	BAOBAB_SCANNER_SHOW_ALLOCATED_SIZE_PROPERTY,
	BAOBAB_SCANNER_TOTAL_SIZE_PROPERTY,
	BAOBAB_SCANNER_TOTAL_ELEMENTS_PROPERTY,
	BAOBAB_SCANNER_MAX_DEPTH_PROPERTY,
	BAOBAB_SCANNER_NUM_PROPERTIES
};
static GParamSpec* baobab_scanner_properties[BAOBAB_SCANNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _baobab_scanner_hard_link_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_hard_link_free (var), NULL)))
#define _baobab_scanner_results_array_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL)))
enum  {
	BAOBAB_SCANNER_RESULTS_0_PROPERTY,
	BAOBAB_SCANNER_RESULTS_PARENT_PROPERTY,
	BAOBAB_SCANNER_RESULTS_NAME_PROPERTY,
	BAOBAB_SCANNER_RESULTS_DISPLAY_NAME_PROPERTY,
	BAOBAB_SCANNER_RESULTS_SIZE_PROPERTY,
	BAOBAB_SCANNER_RESULTS_TIME_MODIFIED_PROPERTY,
	BAOBAB_SCANNER_RESULTS_ELEMENTS_PROPERTY,
	BAOBAB_SCANNER_RESULTS_CHILDREN_LIST_STORE_PROPERTY,
	BAOBAB_SCANNER_RESULTS_STATE_PROPERTY,
	BAOBAB_SCANNER_RESULTS_PERCENT_PROPERTY,
	BAOBAB_SCANNER_RESULTS_FRACTION_PROPERTY,
	BAOBAB_SCANNER_RESULTS_IS_EMPTY_PROPERTY,
	BAOBAB_SCANNER_RESULTS_NUM_PROPERTIES
};
static GParamSpec* baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_NUM_PROPERTIES];
enum  {
	BAOBAB_SCANNER_COMPLETED_SIGNAL,
	BAOBAB_SCANNER_NUM_SIGNALS
};
static guint baobab_scanner_signals[BAOBAB_SCANNER_NUM_SIGNALS] = {0};

struct _BaobabScannerPrivate {
	BaobabScannerResults* _root;
	GFile* _directory;
	BaobabScanFlags _scan_flags;
	gboolean _show_allocated_size;
	guint64 _total_size;
	gint _total_elements;
	gint _max_depth;
	GThread* thread;
	guint process_result_idle;
	GHashTable* hardlinks;
	GHashTable* excluded_locations;
	guint32 unix_device;
	gboolean successful;
	GAsyncQueue* results_queue;
	BaobabScanner* self;
	GCancellable* cancellable;
	GError* scan_error;
};

struct _BaobabScannerResultsArray {
	BaobabScannerResults** results;
	gint results_length1;
	gint _results_size_;
};

struct _BaobabScannerHardLink {
	guint64 inode;
	guint32 device;
};

struct _BaobabScannerResultsPrivate {
	BaobabScannerResults* _parent;
	gchar* _name;
	gchar* _display_name;
	guint64 _size;
	guint64 _time_modified;
	gint _elements;
	GListStore* _children_list_store;
	BaobabScannerState _state;
	gdouble _percent;
};

static gint BaobabScanner_private_offset;
static gpointer baobab_scanner_parent_class = NULL;
static gint BaobabScannerResults_private_offset;
static gpointer baobab_scanner_results_parent_class = NULL;

static void baobab_scanner_hard_link_free (BaobabScannerHardLink * self);
static void baobab_scanner_results_array_free (BaobabScannerResultsArray * self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void baobab_scanner_add_children (BaobabScanner* self,
                                  GFile* directory,
                                  BaobabScannerResults* results,
                                  BaobabScannerResultsArray* results_array,
                                  GError** error);
static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self,
                                                    GFile* directory,
                                                    GFileInfo* info,
                                                    BaobabScannerResults* parent);
static void _vala_array_add3 (BaobabScannerResults** * array,
                       gint* length,
                       gint* size,
                       BaobabScannerResults* value);
static BaobabScannerHardLink* baobab_scanner_hard_link_new (GFileInfo* info);
static void baobab_scanner_set_total_size (BaobabScanner* self,
                                    guint64 value);
static void baobab_scanner_set_total_elements (BaobabScanner* self,
                                        gint value);
static void _vala_array_add4 (BaobabScannerResults** * array,
                       gint* length,
                       gint* size,
                       BaobabScannerResults* value);
static BaobabScannerResultsArray* baobab_scanner_results_array_new (void);
VALA_EXTERN void baobab_scanner_results_set_percent (BaobabScannerResults* self,
                                         gdouble value);
static void* baobab_scanner_scan_in_thread (BaobabScanner* self);
static void baobab_scanner_set_show_allocated_size (BaobabScanner* self,
                                             gboolean value);
static void _vala_array_add5 (BaobabScannerResults** * array,
                       gint* length,
                       gint* size,
                       BaobabScannerResults* value);
static gboolean baobab_scanner_process_results (BaobabScanner* self);
VALA_EXTERN void baobab_scanner_results_set_state (BaobabScannerResults* self,
                                       BaobabScannerState value);
static void baobab_scanner_cancel_and_reset (BaobabScanner* self);
static guint baobab_scanner_hard_link_hash (BaobabScannerHardLink* self);
static guint _baobab_scanner_hard_link_hash_ghash_func (gconstpointer key);
static gboolean baobab_scanner_hard_link_equal (BaobabScannerHardLink* self,
                                         BaobabScannerHardLink* other);
static gboolean _baobab_scanner_hard_link_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b);
static void _baobab_scanner_hard_link_free0_ (gpointer var);
static gpointer _baobab_scanner_scan_in_thread_gthread_func (gpointer self);
static gboolean ___lambda5_ (BaobabScanner* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void baobab_scanner_set_directory (BaobabScanner* self,
                                   GFile* value);
static void baobab_scanner_set_scan_flags (BaobabScanner* self,
                                    BaobabScanFlags value);
static void _baobab_scanner_results_array_free0_ (gpointer var);
static void baobab_scanner_hard_link_instance_init (BaobabScannerHardLink * self);
static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self);
VALA_EXTERN void baobab_scanner_results_set_parent (BaobabScannerResults* self,
                                        BaobabScannerResults* value);
VALA_EXTERN void baobab_scanner_results_set_name (BaobabScannerResults* self,
                                      const gchar* value);
VALA_EXTERN void baobab_scanner_results_set_display_name (BaobabScannerResults* self,
                                              const gchar* value);
VALA_EXTERN void baobab_scanner_results_set_size (BaobabScannerResults* self,
                                      guint64 value);
VALA_EXTERN void baobab_scanner_results_set_time_modified (BaobabScannerResults* self,
                                               guint64 value);
VALA_EXTERN void baobab_scanner_results_set_elements (BaobabScannerResults* self,
                                          gint value);
static GListModel* __lambda4_ (BaobabScannerResults* self,
                        GObject* item);
static GListModel* ___lambda4__gtk_tree_list_model_create_model_func (GObject* item,
                                                               gpointer self);
static GObject * baobab_scanner_results_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void baobab_scanner_results_finalize (GObject * obj);
static GType baobab_scanner_results_get_type_once (void);
static void _vala_baobab_scanner_results_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_baobab_scanner_results_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void baobab_scanner_finalize (GObject * obj);
static GType baobab_scanner_get_type_once (void);
static void _vala_baobab_scanner_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_baobab_scanner_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GType
baobab_scan_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{BAOBAB_SCAN_FLAGS_NONE, "BAOBAB_SCAN_FLAGS_NONE", "none"}, {BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS, "BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS", "exclude-mounts"}, {0, NULL, NULL}};
	GType baobab_scan_flags_type_id;
	baobab_scan_flags_type_id = g_flags_register_static ("BaobabScanFlags", values);
	return baobab_scan_flags_type_id;
}

GType
baobab_scan_flags_get_type (void)
{
	static volatile gsize baobab_scan_flags_type_id__once = 0;
	if (g_once_init_enter (&baobab_scan_flags_type_id__once)) {
		GType baobab_scan_flags_type_id;
		baobab_scan_flags_type_id = baobab_scan_flags_get_type_once ();
		g_once_init_leave (&baobab_scan_flags_type_id__once, baobab_scan_flags_type_id);
	}
	return baobab_scan_flags_type_id__once;
}

static inline gpointer
baobab_scanner_get_instance_private (BaobabScanner* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabScanner_private_offset);
}

static GType
baobab_scanner_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BAOBAB_SCANNER_STATE_SCANNING, "BAOBAB_SCANNER_STATE_SCANNING", "scanning"}, {BAOBAB_SCANNER_STATE_ERROR, "BAOBAB_SCANNER_STATE_ERROR", "error"}, {BAOBAB_SCANNER_STATE_CHILD_ERROR, "BAOBAB_SCANNER_STATE_CHILD_ERROR", "child-error"}, {BAOBAB_SCANNER_STATE_DONE, "BAOBAB_SCANNER_STATE_DONE", "done"}, {0, NULL, NULL}};
	GType baobab_scanner_state_type_id;
	baobab_scanner_state_type_id = g_enum_register_static ("BaobabScannerState", values);
	return baobab_scanner_state_type_id;
}

GType
baobab_scanner_state_get_type (void)
{
	static volatile gsize baobab_scanner_state_type_id__once = 0;
	if (g_once_init_enter (&baobab_scanner_state_type_id__once)) {
		GType baobab_scanner_state_type_id;
		baobab_scanner_state_type_id = baobab_scanner_state_get_type_once ();
		g_once_init_leave (&baobab_scanner_state_type_id__once, baobab_scanner_state_type_id);
	}
	return baobab_scanner_state_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

GFile*
baobab_scanner_get_file (BaobabScanner* self,
                         BaobabScannerResults* results)
{
	GList* names = NULL;
	GFile* file = NULL;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GList* _tmp13_;
	GList* _tmp14_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (results != NULL, NULL);
	names = NULL;
	{
		BaobabScannerResults* child = NULL;
		BaobabScannerResults* _tmp0_;
		_tmp0_ = _g_object_ref0 (results);
		child = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				BaobabScannerResults* _tmp6_;
				BaobabScannerResults* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				if (!_tmp1_) {
					BaobabScannerResults* _tmp2_;
					BaobabScannerResults* _tmp3_;
					BaobabScannerResults* _tmp4_;
					BaobabScannerResults* _tmp5_;
					_tmp2_ = child;
					_tmp3_ = baobab_scanner_results_get_parent (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = _g_object_ref0 (_tmp4_);
					_g_object_unref0 (child);
					child = _tmp5_;
				}
				_tmp1_ = FALSE;
				_tmp6_ = child;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = child;
				_tmp8_ = baobab_scanner_results_get_name (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				names = g_list_prepend (names, _tmp10_);
			}
		}
		_g_object_unref0 (child);
	}
	_tmp11_ = self->priv->_directory;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	file = _tmp12_;
	_tmp13_ = names;
	_tmp14_ = _tmp13_->next;
	{
		GList* name_collection = NULL;
		GList* name_it = NULL;
		name_collection = _tmp14_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp15_;
			gchar* name = NULL;
			_tmp15_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp15_;
			{
				GFile* _tmp16_;
				const gchar* _tmp17_;
				GFile* _tmp18_;
				_tmp16_ = file;
				_tmp17_ = name;
				_tmp18_ = g_file_get_child (_tmp16_, _tmp17_);
				_g_object_unref0 (file);
				file = _tmp18_;
				_g_free0 (name);
			}
		}
	}
	result = file;
	(names == NULL) ? NULL : (names = (_g_list_free__g_free0_ (names), NULL));
	return result;
}

static void
_vala_array_add3 (BaobabScannerResults** * array,
                  gint* length,
                  gint* size,
                  BaobabScannerResults* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (BaobabScannerResults** * array,
                  gint* length,
                  gint* size,
                  BaobabScannerResults* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
baobab_scanner_add_children (BaobabScanner* self,
                             GFile* directory,
                             BaobabScannerResults* results,
                             BaobabScannerResultsArray* results_array,
                             GError** error)
{
	GFileEnumerator* children = NULL;
	GCancellable* _tmp0_;
	GFileEnumerator* _tmp1_;
	GFileInfo* child_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (results_array != NULL);
	_tmp0_ = self->priv->cancellable;
	_tmp1_ = g_file_enumerate_children (directory, BAOBAB_SCANNER_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp0_, &_inner_error0_);
	children = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp2_ = NULL;
		GFileEnumerator* _tmp3_;
		GCancellable* _tmp4_;
		GFileInfo* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		_tmp3_ = children;
		_tmp4_ = self->priv->cancellable;
		_tmp5_ = g_file_enumerator_next_file (_tmp3_, _tmp4_, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (child_info);
			_g_object_unref0 (children);
			return;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (child_info);
		child_info = _tmp6_;
		_tmp7_ = child_info;
		if (!(_tmp7_ != NULL)) {
			_g_object_unref0 (_tmp2_);
			break;
		}
		_tmp8_ = child_info;
		switch (g_file_info_get_file_type (_tmp8_)) {
			case G_FILE_TYPE_DIRECTORY:
			{
				GFile* child = NULL;
				GFileInfo* _tmp9_;
				const gchar* _tmp10_;
				GFile* _tmp11_;
				BaobabScannerResults* child_results = NULL;
				GFile* _tmp12_;
				GFileInfo* _tmp13_;
				BaobabScannerResults* _tmp14_;
				BaobabScannerResults* _tmp15_;
				_tmp9_ = child_info;
				_tmp10_ = g_file_info_get_name (_tmp9_);
				_tmp11_ = g_file_get_child (directory, _tmp10_);
				child = _tmp11_;
				_tmp12_ = child;
				_tmp13_ = child_info;
				_tmp14_ = baobab_scanner_add_directory (self, _tmp12_, _tmp13_, results);
				child_results = _tmp14_;
				_tmp15_ = child_results;
				if (_tmp15_ != NULL) {
					BaobabScannerResults* _tmp16_;
					BaobabScannerResults* _tmp17_;
					_tmp16_ = child_results;
					baobab_scanner_results_update_with_child (results, _tmp16_);
					_tmp17_ = child_results;
					child_results = NULL;
					_vala_array_add3 (&results_array->results, &results_array->results_length1, &results_array->_results_size_, _tmp17_);
				}
				_g_object_unref0 (child_results);
				_g_object_unref0 (child);
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				GFileInfo* _tmp18_;
				BaobabScannerResults* child_results = NULL;
				GFileInfo* _tmp26_;
				BaobabScannerResults* _tmp27_;
				guint64 _tmp28_;
				BaobabScannerResults* _tmp29_;
				guint64 _tmp30_;
				guint64 _tmp31_;
				gint _tmp32_;
				BaobabScannerResults* _tmp33_;
				BaobabScannerResults* _tmp34_;
				_tmp18_ = child_info;
				if (g_file_info_has_attribute (_tmp18_, G_FILE_ATTRIBUTE_UNIX_NLINK)) {
					GFileInfo* _tmp19_;
					_tmp19_ = child_info;
					if (g_file_info_get_attribute_uint32 (_tmp19_, G_FILE_ATTRIBUTE_UNIX_NLINK) > ((guint32) 1)) {
						BaobabScannerHardLink* hl = NULL;
						GFileInfo* _tmp20_;
						BaobabScannerHardLink* _tmp21_;
						GHashTable* _tmp22_;
						BaobabScannerHardLink* _tmp23_;
						GHashTable* _tmp24_;
						BaobabScannerHardLink* _tmp25_;
						_tmp20_ = child_info;
						_tmp21_ = baobab_scanner_hard_link_new (_tmp20_);
						hl = _tmp21_;
						_tmp22_ = self->priv->hardlinks;
						_tmp23_ = hl;
						if (g_hash_table_contains (_tmp22_, _tmp23_)) {
							_baobab_scanner_hard_link_free0 (hl);
							_g_object_unref0 (_tmp2_);
							continue;
						}
						_tmp24_ = self->priv->hardlinks;
						_tmp25_ = hl;
						hl = NULL;
						g_hash_table_add (_tmp24_, _tmp25_);
						_baobab_scanner_hard_link_free0 (hl);
					}
				}
				_tmp26_ = child_info;
				_tmp27_ = baobab_scanner_results_new (_tmp26_, results);
				child_results = _tmp27_;
				_tmp28_ = self->priv->_total_size;
				_tmp29_ = child_results;
				_tmp30_ = baobab_scanner_results_get_size (_tmp29_);
				_tmp31_ = _tmp30_;
				baobab_scanner_set_total_size (self, _tmp28_ + _tmp31_);
				_tmp32_ = self->priv->_total_elements;
				baobab_scanner_set_total_elements (self, _tmp32_ + 1);
				_tmp33_ = child_results;
				baobab_scanner_results_update_with_child (results, _tmp33_);
				_tmp34_ = child_results;
				child_results = NULL;
				_vala_array_add4 (&results_array->results, &results_array->results_length1, &results_array->_results_size_, _tmp34_);
				_g_object_unref0 (child_results);
				break;
			}
			default:
			{
				break;
			}
		}
		_g_object_unref0 (_tmp2_);
	}
	_g_object_unref0 (child_info);
	_g_object_unref0 (children);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static BaobabScannerResults*
baobab_scanner_add_directory (BaobabScanner* self,
                              GFile* directory,
                              GFileInfo* info,
                              BaobabScannerResults* parent)
{
	BaobabScannerResultsArray* results_array = NULL;
	BaobabScannerResultsArray* _tmp0_;
	guint32 current_unix_device = 0U;
	gboolean _tmp1_ = FALSE;
	BaobabScanFlags _tmp2_;
	BaobabScannerResults* results = NULL;
	BaobabScannerResults* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	guint64 _tmp10_;
	BaobabScannerResults* _tmp11_;
	guint64 _tmp12_;
	guint64 _tmp13_;
	gint _tmp14_;
	BaobabScannerResultsArray* _tmp20_;
	BaobabScannerResults** _tmp21_;
	gint _tmp21__length1;
	GAsyncQueue* _tmp33_;
	BaobabScannerResultsArray* _tmp34_;
	GError* _inner_error0_ = NULL;
	BaobabScannerResults* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = baobab_scanner_results_array_new ();
	results_array = _tmp0_;
	current_unix_device = g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_UNIX_DEVICE);
	_tmp2_ = self->priv->_scan_flags;
	if ((_tmp2_ & BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) == BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) {
		_tmp1_ = current_unix_device != self->priv->unix_device;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = NULL;
		_baobab_scanner_results_array_free0 (results_array);
		return result;
	}
	_tmp3_ = baobab_scanner_results_new (info, parent);
	results = _tmp3_;
	_tmp4_ = self->priv->excluded_locations;
	_tmp5_ = g_file_get_uri (directory);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_hash_table_contains (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		BaobabScannerResults* _tmp8_;
		GError* _tmp9_;
		_tmp8_ = results;
		_tmp9_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Location is excluded");
		_g_error_free0 (_tmp8_->error);
		_tmp8_->error = _tmp9_;
		result = results;
		_baobab_scanner_results_array_free0 (results_array);
		return result;
	}
	_tmp10_ = self->priv->_total_size;
	_tmp11_ = results;
	_tmp12_ = baobab_scanner_results_get_size (_tmp11_);
	_tmp13_ = _tmp12_;
	baobab_scanner_set_total_size (self, _tmp10_ + _tmp13_);
	_tmp14_ = self->priv->_total_elements;
	baobab_scanner_set_total_elements (self, _tmp14_ + 1);
	{
		BaobabScannerResults* _tmp15_;
		BaobabScannerResultsArray* _tmp16_;
		_tmp15_ = results;
		_tmp16_ = results_array;
		baobab_scanner_add_children (self, directory, _tmp15_, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		BaobabScannerResults* _tmp17_;
		GError* _tmp18_;
		GError* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = results;
		_tmp18_ = e;
		_tmp19_ = _g_error_copy0 (_tmp18_);
		_g_error_free0 (_tmp17_->error);
		_tmp17_->error = _tmp19_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (results);
		_baobab_scanner_results_array_free0 (results_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = results_array;
	_tmp21_ = _tmp20_->results;
	_tmp21__length1 = _tmp20_->results_length1;
	{
		BaobabScannerResults** child_results_collection = NULL;
		gint child_results_collection_length1 = 0;
		gint _child_results_collection_size_ = 0;
		gint child_results_it = 0;
		child_results_collection = _tmp21_;
		child_results_collection_length1 = _tmp21__length1;
		for (child_results_it = 0; child_results_it < child_results_collection_length1; child_results_it = child_results_it + 1) {
			BaobabScannerResults* child_results = NULL;
			child_results = child_results_collection[child_results_it];
			{
				BaobabScannerResults* _tmp22_;
				guint64 _tmp23_;
				guint64 _tmp24_;
				_tmp22_ = results;
				_tmp23_ = baobab_scanner_results_get_size (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ > ((guint64) 0)) {
					BaobabScannerResults* _tmp25_;
					BaobabScannerResults* _tmp26_;
					guint64 _tmp27_;
					guint64 _tmp28_;
					BaobabScannerResults* _tmp29_;
					guint64 _tmp30_;
					guint64 _tmp31_;
					_tmp25_ = child_results;
					_tmp26_ = child_results;
					_tmp27_ = baobab_scanner_results_get_size (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = results;
					_tmp30_ = baobab_scanner_results_get_size (_tmp29_);
					_tmp31_ = _tmp30_;
					baobab_scanner_results_set_percent (_tmp25_, (100 * ((gdouble) _tmp28_)) / ((gdouble) _tmp31_));
				} else {
					BaobabScannerResults* _tmp32_;
					_tmp32_ = child_results;
					baobab_scanner_results_set_percent (_tmp32_, (gdouble) 0);
				}
			}
		}
	}
	_tmp33_ = self->priv->results_queue;
	_tmp34_ = results_array;
	results_array = NULL;
	g_async_queue_push (_tmp33_, _tmp34_);
	result = results;
	_baobab_scanner_results_array_free0 (results_array);
	return result;
}

static void
_vala_array_add5 (BaobabScannerResults** * array,
                  gint* length,
                  gint* size,
                  BaobabScannerResults* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void*
baobab_scanner_scan_in_thread (BaobabScanner* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		BaobabScannerResultsArray* array = NULL;
		BaobabScannerResultsArray* _tmp0_;
		GFileInfo* info = NULL;
		GFile* _tmp1_;
		GCancellable* _tmp2_;
		GFileInfo* _tmp3_;
		BaobabScannerResults* results = NULL;
		GFile* _tmp4_;
		BaobabScannerResults* _tmp5_;
		BaobabScannerResults* _tmp6_;
		BaobabScannerResultsArray* _tmp7_;
		BaobabScannerResultsArray* _tmp8_;
		BaobabScannerResults* _tmp9_;
		GAsyncQueue* _tmp10_;
		BaobabScannerResultsArray* _tmp11_;
		_tmp0_ = baobab_scanner_results_array_new ();
		array = _tmp0_;
		_tmp1_ = self->priv->_directory;
		_tmp2_ = self->priv->cancellable;
		_tmp3_ = g_file_query_info (_tmp1_, BAOBAB_SCANNER_ATTRIBUTES, 0, _tmp2_, &_inner_error0_);
		info = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_baobab_scanner_results_array_free0 (array);
			goto __catch0_g_error;
		}
		baobab_scanner_set_show_allocated_size (self, g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE) > ((guint64) 0));
		self->priv->unix_device = g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_UNIX_DEVICE);
		_tmp4_ = self->priv->_directory;
		_tmp5_ = baobab_scanner_add_directory (self, _tmp4_, info, NULL);
		results = _tmp5_;
		_tmp6_ = results;
		baobab_scanner_results_set_percent (_tmp6_, 100.0);
		_tmp7_ = array;
		_tmp8_ = array;
		_tmp9_ = results;
		results = NULL;
		_vala_array_add5 (&_tmp7_->results, &_tmp7_->results_length1, &_tmp7_->_results_size_, _tmp9_);
		_tmp10_ = self->priv->results_queue;
		_tmp11_ = array;
		array = NULL;
		g_async_queue_push (_tmp10_, _tmp11_);
		_g_object_unref0 (results);
		_g_object_unref0 (info);
		_baobab_scanner_results_array_free0 (array);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_object_unref0 (self->priv->self);
	self->priv->self = NULL;
	result = NULL;
	return result;
}

static gboolean
baobab_scanner_process_results (BaobabScanner* self)
{
	BaobabScanner* _tmp30_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		BaobabScannerResultsArray* results_array = NULL;
		GAsyncQueue* _tmp0_;
		gpointer _tmp1_;
		BaobabScannerResultsArray* _tmp2_;
		BaobabScannerResultsArray* _tmp3_;
		BaobabScannerResults** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = self->priv->results_queue;
		_tmp1_ = g_async_queue_try_pop (_tmp0_);
		results_array = (BaobabScannerResultsArray*) _tmp1_;
		_tmp2_ = results_array;
		if (_tmp2_ == NULL) {
			_baobab_scanner_results_array_free0 (results_array);
			break;
		}
		_tmp3_ = results_array;
		_tmp4_ = _tmp3_->results;
		_tmp4__length1 = _tmp3_->results_length1;
		{
			BaobabScannerResults** results_collection = NULL;
			gint results_collection_length1 = 0;
			gint _results_collection_size_ = 0;
			gint results_it = 0;
			results_collection = _tmp4_;
			results_collection_length1 = _tmp4__length1;
			for (results_it = 0; results_it < results_collection_length1; results_it = results_it + 1) {
				BaobabScannerResults* results = NULL;
				results = results_collection[results_it];
				{
					BaobabScannerResults* _tmp5_;
					BaobabScannerResults* _tmp6_;
					BaobabScannerResults* _tmp7_;
					BaobabScannerState state = 0;
					BaobabScannerResults* _tmp14_;
					BaobabScannerResults* _tmp20_;
					gint _tmp21_;
					BaobabScannerResults* _tmp23_;
					BaobabScannerResults* _tmp24_;
					BaobabScannerResults* _tmp25_;
					_tmp5_ = results;
					_tmp6_ = baobab_scanner_results_get_parent (_tmp5_);
					_tmp7_ = _tmp6_;
					if (_tmp7_ != NULL) {
						BaobabScannerResults* _tmp8_;
						BaobabScannerResults* _tmp9_;
						BaobabScannerResults* _tmp10_;
						GListStore* _tmp11_;
						GListStore* _tmp12_;
						BaobabScannerResults* _tmp13_;
						_tmp8_ = results;
						_tmp9_ = baobab_scanner_results_get_parent (_tmp8_);
						_tmp10_ = _tmp9_;
						_tmp11_ = baobab_scanner_results_get_children_list_store (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = results;
						g_list_store_insert (_tmp12_, (guint) 0, (GObject*) _tmp13_);
					}
					_tmp14_ = results;
					if (_tmp14_->child_error) {
						BaobabScannerResults* _tmp15_;
						_tmp15_ = results;
						baobab_scanner_results_set_state (_tmp15_, BAOBAB_SCANNER_STATE_CHILD_ERROR);
					} else {
						BaobabScannerResults* _tmp16_;
						GError* _tmp17_;
						_tmp16_ = results;
						_tmp17_ = _tmp16_->error;
						if (_tmp17_ != NULL) {
							BaobabScannerResults* _tmp18_;
							_tmp18_ = results;
							baobab_scanner_results_set_state (_tmp18_, BAOBAB_SCANNER_STATE_ERROR);
						} else {
							BaobabScannerResults* _tmp19_;
							_tmp19_ = results;
							baobab_scanner_results_set_state (_tmp19_, BAOBAB_SCANNER_STATE_DONE);
						}
					}
					_tmp20_ = results;
					_tmp21_ = self->priv->_max_depth;
					if (_tmp20_->max_depth > _tmp21_) {
						BaobabScannerResults* _tmp22_;
						_tmp22_ = results;
						baobab_scanner_set_max_depth (self, _tmp22_->max_depth);
					}
					_tmp23_ = results;
					_tmp24_ = baobab_scanner_results_get_parent (_tmp23_);
					_tmp25_ = _tmp24_;
					if (_tmp25_ == NULL) {
						BaobabScannerResults* _tmp26_;
						BaobabScannerResults* _tmp27_;
						GError* _tmp28_;
						GError* _tmp29_;
						_tmp26_ = results;
						baobab_scanner_set_root (self, _tmp26_);
						_tmp27_ = results;
						_tmp28_ = _tmp27_->error;
						_tmp29_ = _g_error_copy0 (_tmp28_);
						_g_error_free0 (self->priv->scan_error);
						self->priv->scan_error = _tmp29_;
						self->priv->successful = TRUE;
						g_signal_emit (self, baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL], 0);
						result = FALSE;
						_baobab_scanner_results_array_free0 (results_array);
						return result;
					}
				}
			}
		}
		_baobab_scanner_results_array_free0 (results_array);
	}
	_tmp30_ = self->priv->self;
	result = _tmp30_ != NULL;
	return result;
}

static guint
_baobab_scanner_hard_link_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = baobab_scanner_hard_link_hash (key);
	return result;
}

static gboolean
_baobab_scanner_hard_link_equal_gequal_func (gconstpointer a,
                                             gconstpointer b)
{
	gboolean result;
	result = baobab_scanner_hard_link_equal (a, (BaobabScannerHardLink*) b);
	return result;
}

static void
_baobab_scanner_hard_link_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (baobab_scanner_hard_link_free (var), NULL));
}

static void
baobab_scanner_cancel_and_reset (BaobabScanner* self)
{
	GCancellable* _tmp0_;
	GThread* _tmp1_;
	BaobabScannerResultsArray* tmp = NULL;
	GAsyncQueue* _tmp3_;
	gpointer _tmp4_;
	GHashTable* _tmp8_;
	GCancellable* _tmp9_;
	BaobabApplication* _tmp10_;
	BaobabApplication* _tmp11_;
	GHashTable* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->thread;
	if (_tmp1_ != NULL) {
		GThread* _tmp2_;
		_tmp2_ = self->priv->thread;
		self->priv->thread = NULL;
		g_thread_join (_tmp2_);
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = NULL;
	}
	if (self->priv->process_result_idle != ((guint) 0)) {
		g_source_remove (self->priv->process_result_idle);
		self->priv->process_result_idle = (guint) 0;
	}
	_tmp3_ = self->priv->results_queue;
	_tmp4_ = g_async_queue_try_pop (_tmp3_);
	tmp = (BaobabScannerResultsArray*) _tmp4_;
	while (TRUE) {
		BaobabScannerResultsArray* _tmp5_;
		GAsyncQueue* _tmp6_;
		gpointer _tmp7_;
		_tmp5_ = tmp;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = self->priv->results_queue;
		_tmp7_ = g_async_queue_try_pop (_tmp6_);
		_baobab_scanner_results_array_free0 (tmp);
		tmp = (BaobabScannerResultsArray*) _tmp7_;
	}
	_tmp8_ = g_hash_table_new_full (_baobab_scanner_hard_link_hash_ghash_func, _baobab_scanner_hard_link_equal_gequal_func, NULL, _baobab_scanner_hard_link_free0_);
	_g_hash_table_unref0 (self->priv->hardlinks);
	self->priv->hardlinks = _tmp8_;
	_tmp9_ = self->priv->cancellable;
	g_cancellable_reset (_tmp9_);
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	baobab_scanner_set_total_size (self, (guint64) 0);
	baobab_scanner_set_total_elements (self, 0);
	_tmp10_ = baobab_application_get_default ();
	_tmp11_ = _tmp10_;
	_tmp12_ = baobab_application_get_excluded_locations (_tmp11_);
	_g_hash_table_unref0 (self->priv->excluded_locations);
	self->priv->excluded_locations = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_baobab_scanner_results_array_free0 (tmp);
}

static gpointer
_baobab_scanner_scan_in_thread_gthread_func (gpointer self)
{
	gpointer result;
	result = baobab_scanner_scan_in_thread ((BaobabScanner*) self);
	g_object_unref (self);
	return result;
}

static gboolean
___lambda5_ (BaobabScanner* self)
{
	gboolean res = FALSE;
	gboolean result;
	res = baobab_scanner_process_results (self);
	if (!res) {
		self->priv->process_result_idle = (guint) 0;
	}
	result = res;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((BaobabScanner*) self);
	return result;
}

void
baobab_scanner_scan (BaobabScanner* self,
                     gboolean force)
{
	g_return_if_fail (self != NULL);
	if (force) {
		self->priv->successful = FALSE;
	}
	if (!self->priv->successful) {
		BaobabScanner* _tmp0_;
		GThread* _tmp1_;
		baobab_scanner_cancel_and_reset (self);
		_tmp0_ = _g_object_ref0 (self);
		_g_object_unref0 (self->priv->self);
		self->priv->self = _tmp0_;
		_tmp1_ = g_thread_new ("scanner", _baobab_scanner_scan_in_thread_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp1_;
		self->priv->process_result_idle = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		g_signal_emit (self, baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL], 0);
	}
}

void
baobab_scanner_cancel (BaobabScanner* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->successful) {
		GError* _tmp0_;
		baobab_scanner_cancel_and_reset (self);
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Scan was cancelled");
		_g_error_free0 (self->priv->scan_error);
		self->priv->scan_error = _tmp0_;
	}
	g_signal_emit (self, baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL], 0);
}

void
baobab_scanner_finish (BaobabScanner* self,
                       GError** error)
{
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_error;
	if (_tmp0_ != NULL) {
		GError* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = self->priv->scan_error;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_baobab_scanner_results_array_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL));
}

BaobabScanner*
baobab_scanner_construct (GType object_type,
                          GFile* directory,
                          BaobabScanFlags flags)
{
	BaobabScanner * self = NULL;
	GCancellable* _tmp0_;
	GAsyncQueue* _tmp1_;
	BaobabScannerResults* _tmp2_;
	BaobabScannerResults* _tmp3_;
	g_return_val_if_fail (directory != NULL, NULL);
	self = (BaobabScanner*) g_object_new (object_type, NULL);
	baobab_scanner_set_directory (self, directory);
	baobab_scanner_set_scan_flags (self, flags);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	_tmp1_ = g_async_queue_new_full (_baobab_scanner_results_array_free0_);
	_g_async_queue_unref0 (self->priv->results_queue);
	self->priv->results_queue = _tmp1_;
	_tmp2_ = baobab_scanner_results_new_empty ();
	_tmp3_ = _tmp2_;
	baobab_scanner_set_root (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

BaobabScanner*
baobab_scanner_new (GFile* directory,
                    BaobabScanFlags flags)
{
	return baobab_scanner_construct (BAOBAB_TYPE_SCANNER, directory, flags);
}

BaobabScannerResults*
baobab_scanner_get_root (BaobabScanner* self)
{
	BaobabScannerResults* result;
	BaobabScannerResults* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root;
	result = _tmp0_;
	return result;
}

void
baobab_scanner_set_root (BaobabScanner* self,
                         BaobabScannerResults* value)
{
	BaobabScannerResults* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_root (self);
	if (old_value != value) {
		BaobabScannerResults* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_root);
		self->priv->_root = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_ROOT_PROPERTY]);
	}
}

GFile*
baobab_scanner_get_directory (BaobabScanner* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}

static void
baobab_scanner_set_directory (BaobabScanner* self,
                              GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_directory (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_directory);
		self->priv->_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_DIRECTORY_PROPERTY]);
	}
}

BaobabScanFlags
baobab_scanner_get_scan_flags (BaobabScanner* self)
{
	BaobabScanFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_scan_flags;
	return result;
}

static void
baobab_scanner_set_scan_flags (BaobabScanner* self,
                               BaobabScanFlags value)
{
	BaobabScanFlags old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_scan_flags (self);
	if (old_value != value) {
		self->priv->_scan_flags = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY]);
	}
}

gboolean
baobab_scanner_get_show_allocated_size (BaobabScanner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_allocated_size;
	return result;
}

static void
baobab_scanner_set_show_allocated_size (BaobabScanner* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_show_allocated_size (self);
	if (old_value != value) {
		self->priv->_show_allocated_size = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_SHOW_ALLOCATED_SIZE_PROPERTY]);
	}
}

guint64
baobab_scanner_get_total_size (BaobabScanner* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_total_size;
	return result;
}

static void
baobab_scanner_set_total_size (BaobabScanner* self,
                               guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_total_size (self);
	if (old_value != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_TOTAL_SIZE_PROPERTY]);
	}
}

gint
baobab_scanner_get_total_elements (BaobabScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_total_elements;
	return result;
}

static void
baobab_scanner_set_total_elements (BaobabScanner* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_total_elements (self);
	if (old_value != value) {
		self->priv->_total_elements = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_TOTAL_ELEMENTS_PROPERTY]);
	}
}

gint
baobab_scanner_get_max_depth (BaobabScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_depth;
	return result;
}

void
baobab_scanner_set_max_depth (BaobabScanner* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_get_max_depth (self);
	if (old_value != value) {
		self->priv->_max_depth = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_MAX_DEPTH_PROPERTY]);
	}
}

static BaobabScannerHardLink*
baobab_scanner_hard_link_new (GFileInfo* info)
{
	BaobabScannerHardLink* self;
	g_return_val_if_fail (info != NULL, NULL);
	self = g_slice_new0 (BaobabScannerHardLink);
	baobab_scanner_hard_link_instance_init (self);
	self->inode = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_UNIX_INODE);
	self->device = g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_UNIX_DEVICE);
	return self;
}

static guint
baobab_scanner_hard_link_hash (BaobabScannerHardLink* self)
{
	GHashFunc _tmp0_;
	GHashFunc _tmp1_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_hash;
	result = _tmp0_ ((void*) self->inode) ^ _tmp1_ ((void*) self->device);
	return result;
}

static gboolean
baobab_scanner_hard_link_equal (BaobabScannerHardLink* self,
                                BaobabScannerHardLink* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	if (self->inode == other->inode) {
		_tmp0_ = self->device == other->device;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
baobab_scanner_hard_link_instance_init (BaobabScannerHardLink * self)
{
}

static void
baobab_scanner_hard_link_free (BaobabScannerHardLink * self)
{
	g_slice_free (BaobabScannerHardLink, self);
}

static BaobabScannerResultsArray*
baobab_scanner_results_array_new (void)
{
	BaobabScannerResultsArray* self;
	self = g_slice_new0 (BaobabScannerResultsArray);
	baobab_scanner_results_array_instance_init (self);
	return self;
}

static void
baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self)
{
}

static void
baobab_scanner_results_array_free (BaobabScannerResultsArray * self)
{
	self->results = (_vala_array_free (self->results, self->results_length1, (GDestroyNotify) g_object_unref), NULL);
	g_slice_free (BaobabScannerResultsArray, self);
}

static inline gpointer
baobab_scanner_results_get_instance_private (BaobabScannerResults* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabScannerResults_private_offset);
}

BaobabScannerResults*
baobab_scanner_results_construct (GType object_type,
                                  GFileInfo* info,
                                  BaobabScannerResults* parent_results)
{
	BaobabScannerResults * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	guint64 _tmp9_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (BaobabScannerResults*) g_object_new (object_type, NULL);
	baobab_scanner_results_set_parent (self, parent_results);
	_tmp0_ = g_file_info_get_name (info);
	baobab_scanner_results_set_name (self, _tmp0_);
	_tmp1_ = g_file_info_get_display_name (info);
	baobab_scanner_results_set_display_name (self, _tmp1_);
	_tmp3_ = self->priv->_display_name;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_name;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->_name;
		_tmp6_ = g_filename_display_name (_tmp5_);
		_tmp7_ = _tmp6_;
		baobab_scanner_results_set_display_name (self, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = self->priv->_display_name;
	if (_tmp8_ == NULL) {
		baobab_scanner_results_set_display_name (self, "");
	}
	self->file_type = g_file_info_get_file_type (info);
	baobab_scanner_results_set_size (self, g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE));
	_tmp9_ = self->priv->_size;
	if (_tmp9_ == ((guint64) 0)) {
		baobab_scanner_results_set_size (self, (guint64) g_file_info_get_size (info));
	}
	baobab_scanner_results_set_time_modified (self, g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_TIME_MODIFIED));
	baobab_scanner_results_set_elements (self, 1);
	_g_error_free0 (self->error);
	self->error = NULL;
	self->child_error = FALSE;
	return self;
}

BaobabScannerResults*
baobab_scanner_results_new (GFileInfo* info,
                            BaobabScannerResults* parent_results)
{
	return baobab_scanner_results_construct (BAOBAB_SCANNER_TYPE_RESULTS, info, parent_results);
}

BaobabScannerResults*
baobab_scanner_results_construct_empty (GType object_type)
{
	BaobabScannerResults * self = NULL;
	self = (BaobabScannerResults*) g_object_new (object_type, NULL);
	return self;
}

BaobabScannerResults*
baobab_scanner_results_new_empty (void)
{
	return baobab_scanner_results_construct_empty (BAOBAB_SCANNER_TYPE_RESULTS);
}

void
baobab_scanner_results_update_with_child (BaobabScannerResults* self,
                                          BaobabScannerResults* child)
{
	guint64 _tmp0_;
	guint64 _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	guint64 _tmp6_;
	guint64 _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->_size;
	_tmp1_ = child->priv->_size;
	baobab_scanner_results_set_size (self, _tmp0_ + _tmp1_);
	_tmp2_ = self->priv->_elements;
	_tmp3_ = child->priv->_elements;
	baobab_scanner_results_set_elements (self, _tmp2_ + _tmp3_);
	self->max_depth = MAX (self->max_depth, child->max_depth + 1);
	if (child->child_error) {
		_tmp4_ = TRUE;
	} else {
		GError* _tmp5_;
		_tmp5_ = child->error;
		_tmp4_ = _tmp5_ != NULL;
	}
	self->child_error = self->child_error | _tmp4_;
	_tmp6_ = self->priv->_time_modified;
	_tmp7_ = child->priv->_time_modified;
	baobab_scanner_results_set_time_modified (self, MAX (_tmp6_, _tmp7_));
}

gint
baobab_scanner_results_get_depth (BaobabScannerResults* self)
{
	gint depth = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	depth = 1;
	{
		BaobabScannerResults* ancestor = NULL;
		BaobabScannerResults* _tmp0_;
		BaobabScannerResults* _tmp1_;
		_tmp0_ = self->priv->_parent;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		ancestor = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				BaobabScannerResults* _tmp6_;
				gint _tmp7_;
				if (!_tmp2_) {
					BaobabScannerResults* _tmp3_;
					BaobabScannerResults* _tmp4_;
					BaobabScannerResults* _tmp5_;
					_tmp3_ = ancestor;
					_tmp4_ = _tmp3_->priv->_parent;
					_tmp5_ = _g_object_ref0 (_tmp4_);
					_g_object_unref0 (ancestor);
					ancestor = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = ancestor;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = depth;
				depth = _tmp7_ + 1;
			}
		}
		_g_object_unref0 (ancestor);
	}
	result = depth;
	return result;
}

gboolean
baobab_scanner_results_is_ancestor (BaobabScannerResults* self,
                                    BaobabScannerResults* descendant)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				BaobabScannerResults* _tmp1_;
				_tmp1_ = descendant->priv->_parent;
				descendant = _tmp1_;
			}
			_tmp0_ = FALSE;
			if (!(descendant != NULL)) {
				break;
			}
			if (descendant == self) {
				result = TRUE;
				return result;
			}
		}
	}
	result = descendant == self;
	return result;
}

static GListModel*
__lambda4_ (BaobabScannerResults* self,
            GObject* item)
{
	BaobabScannerResults* results = NULL;
	BaobabScannerResults* _tmp0_;
	GListStore* _tmp1_ = NULL;
	BaobabScannerResults* _tmp2_;
	GListModel* _tmp5_;
	GListModel* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 (BAOBAB_SCANNER_IS_RESULTS (item) ? ((BaobabScannerResults*) item) : NULL);
	results = _tmp0_;
	_tmp2_ = results;
	if (_tmp2_ == NULL) {
		_tmp1_ = NULL;
	} else {
		BaobabScannerResults* _tmp3_;
		GListStore* _tmp4_;
		_tmp3_ = results;
		_tmp4_ = _tmp3_->priv->_children_list_store;
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 ((GListModel*) _tmp1_);
	result = _tmp5_;
	_g_object_unref0 (results);
	return result;
}

static GListModel*
___lambda4__gtk_tree_list_model_create_model_func (GObject* item,
                                                   gpointer self)
{
	GListModel* result;
	result = __lambda4_ ((BaobabScannerResults*) self, item);
	return result;
}

GtkTreeListModel*
baobab_scanner_results_create_tree_model (BaobabScannerResults* self)
{
	GListStore* _tmp0_;
	GListModel* _tmp1_;
	GtkTreeListModel* _tmp2_;
	GtkTreeListModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_children_list_store;
	_tmp1_ = _g_object_ref0 ((GListModel*) _tmp0_);
	_tmp2_ = gtk_tree_list_model_new (_tmp1_, FALSE, FALSE, ___lambda4__gtk_tree_list_model_create_model_func, g_object_ref (self), g_object_unref);
	result = _tmp2_;
	return result;
}

BaobabScannerResults*
baobab_scanner_results_get_parent (BaobabScannerResults* self)
{
	BaobabScannerResults* result;
	BaobabScannerResults* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

void
baobab_scanner_results_set_parent (BaobabScannerResults* self,
                                   BaobabScannerResults* value)
{
	BaobabScannerResults* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_parent (self);
	if (old_value != value) {
		self->priv->_parent = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_PARENT_PROPERTY]);
	}
}

const gchar*
baobab_scanner_results_get_name (BaobabScannerResults* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
baobab_scanner_results_set_name (BaobabScannerResults* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_NAME_PROPERTY]);
	}
}

const gchar*
baobab_scanner_results_get_display_name (BaobabScannerResults* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
baobab_scanner_results_set_display_name (BaobabScannerResults* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_DISPLAY_NAME_PROPERTY]);
	}
}

guint64
baobab_scanner_results_get_size (BaobabScannerResults* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_size;
	return result;
}

void
baobab_scanner_results_set_size (BaobabScannerResults* self,
                                 guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_size (self);
	if (old_value != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_SIZE_PROPERTY]);
	}
}

guint64
baobab_scanner_results_get_time_modified (BaobabScannerResults* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_time_modified;
	return result;
}

void
baobab_scanner_results_set_time_modified (BaobabScannerResults* self,
                                          guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_time_modified (self);
	if (old_value != value) {
		self->priv->_time_modified = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_TIME_MODIFIED_PROPERTY]);
	}
}

gint
baobab_scanner_results_get_elements (BaobabScannerResults* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_elements;
	return result;
}

void
baobab_scanner_results_set_elements (BaobabScannerResults* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_elements (self);
	if (old_value != value) {
		self->priv->_elements = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_ELEMENTS_PROPERTY]);
	}
}

GListStore*
baobab_scanner_results_get_children_list_store (BaobabScannerResults* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_children_list_store;
	result = _tmp0_;
	return result;
}

void
baobab_scanner_results_set_children_list_store (BaobabScannerResults* self,
                                                GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_children_list_store (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_children_list_store);
		self->priv->_children_list_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_CHILDREN_LIST_STORE_PROPERTY]);
	}
}

BaobabScannerState
baobab_scanner_results_get_state (BaobabScannerResults* self)
{
	BaobabScannerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
baobab_scanner_results_set_state (BaobabScannerResults* self,
                                  BaobabScannerState value)
{
	BaobabScannerState old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_scanner_results_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_STATE_PROPERTY]);
	}
}

gdouble
baobab_scanner_results_get_percent (BaobabScannerResults* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_percent;
	return result;
}

void
baobab_scanner_results_set_percent (BaobabScannerResults* self,
                                    gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_percent = value;
	g_object_notify ((GObject*) self, "fraction");
	g_object_notify_by_pspec ((GObject *) self, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_PERCENT_PROPERTY]);
}

gdouble
baobab_scanner_results_get_fraction (BaobabScannerResults* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_percent / 100.0;
	return result;
}

gboolean
baobab_scanner_results_get_is_empty (BaobabScannerResults* self)
{
	gboolean result;
	GListStore* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_children_list_store;
	g_object_get (_tmp0_, "n-items", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == ((guint) 0);
	return result;
}

static GObject *
baobab_scanner_results_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaobabScannerResults * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	parent_class = G_OBJECT_CLASS (baobab_scanner_results_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_SCANNER_TYPE_RESULTS, BaobabScannerResults);
	_tmp0_ = g_list_store_new (BAOBAB_SCANNER_TYPE_RESULTS);
	_tmp1_ = _tmp0_;
	baobab_scanner_results_set_children_list_store (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
baobab_scanner_results_class_init (BaobabScannerResultsClass * klass,
                                   gpointer klass_data)
{
	baobab_scanner_results_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabScannerResults_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_scanner_results_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_scanner_results_set_property;
	G_OBJECT_CLASS (klass)->constructor = baobab_scanner_results_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_scanner_results_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_PARENT_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", BAOBAB_SCANNER_TYPE_RESULTS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_NAME_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_DISPLAY_NAME_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_SIZE_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_SIZE_PROPERTY] = g_param_spec_uint64 ("size", "size", "size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_TIME_MODIFIED_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_TIME_MODIFIED_PROPERTY] = g_param_spec_uint64 ("time-modified", "time-modified", "time-modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_ELEMENTS_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_ELEMENTS_PROPERTY] = g_param_spec_int ("elements", "elements", "elements", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_CHILDREN_LIST_STORE_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_CHILDREN_LIST_STORE_PROPERTY] = g_param_spec_object ("children-list-store", "children-list-store", "children-list-store", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_STATE_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_PERCENT_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_PERCENT_PROPERTY] = g_param_spec_double ("percent", "percent", "percent", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_FRACTION_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_FRACTION_PROPERTY] = g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_RESULTS_IS_EMPTY_PROPERTY, baobab_scanner_results_properties[BAOBAB_SCANNER_RESULTS_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
baobab_scanner_results_instance_init (BaobabScannerResults * self,
                                      gpointer klass)
{
	self->priv = baobab_scanner_results_get_instance_private (self);
}

static void
baobab_scanner_results_finalize (GObject * obj)
{
	BaobabScannerResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_SCANNER_TYPE_RESULTS, BaobabScannerResults);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_error_free0 (self->error);
	_g_object_unref0 (self->priv->_children_list_store);
	G_OBJECT_CLASS (baobab_scanner_results_parent_class)->finalize (obj);
}

static GType
baobab_scanner_results_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabScannerResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_scanner_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabScannerResults), 0, (GInstanceInitFunc) baobab_scanner_results_instance_init, NULL };
	GType baobab_scanner_results_type_id;
	baobab_scanner_results_type_id = g_type_register_static (G_TYPE_OBJECT, "BaobabScannerResults", &g_define_type_info, 0);
	BaobabScannerResults_private_offset = g_type_add_instance_private (baobab_scanner_results_type_id, sizeof (BaobabScannerResultsPrivate));
	return baobab_scanner_results_type_id;
}

GType
baobab_scanner_results_get_type (void)
{
	static volatile gsize baobab_scanner_results_type_id__once = 0;
	if (g_once_init_enter (&baobab_scanner_results_type_id__once)) {
		GType baobab_scanner_results_type_id;
		baobab_scanner_results_type_id = baobab_scanner_results_get_type_once ();
		g_once_init_leave (&baobab_scanner_results_type_id__once, baobab_scanner_results_type_id);
	}
	return baobab_scanner_results_type_id__once;
}

static void
_vala_baobab_scanner_results_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	BaobabScannerResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_SCANNER_TYPE_RESULTS, BaobabScannerResults);
	switch (property_id) {
		case BAOBAB_SCANNER_RESULTS_PARENT_PROPERTY:
		g_value_set_object (value, baobab_scanner_results_get_parent (self));
		break;
		case BAOBAB_SCANNER_RESULTS_NAME_PROPERTY:
		g_value_set_string (value, baobab_scanner_results_get_name (self));
		break;
		case BAOBAB_SCANNER_RESULTS_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, baobab_scanner_results_get_display_name (self));
		break;
		case BAOBAB_SCANNER_RESULTS_SIZE_PROPERTY:
		g_value_set_uint64 (value, baobab_scanner_results_get_size (self));
		break;
		case BAOBAB_SCANNER_RESULTS_TIME_MODIFIED_PROPERTY:
		g_value_set_uint64 (value, baobab_scanner_results_get_time_modified (self));
		break;
		case BAOBAB_SCANNER_RESULTS_ELEMENTS_PROPERTY:
		g_value_set_int (value, baobab_scanner_results_get_elements (self));
		break;
		case BAOBAB_SCANNER_RESULTS_CHILDREN_LIST_STORE_PROPERTY:
		g_value_set_object (value, baobab_scanner_results_get_children_list_store (self));
		break;
		case BAOBAB_SCANNER_RESULTS_STATE_PROPERTY:
		g_value_set_enum (value, baobab_scanner_results_get_state (self));
		break;
		case BAOBAB_SCANNER_RESULTS_PERCENT_PROPERTY:
		g_value_set_double (value, baobab_scanner_results_get_percent (self));
		break;
		case BAOBAB_SCANNER_RESULTS_FRACTION_PROPERTY:
		g_value_set_double (value, baobab_scanner_results_get_fraction (self));
		break;
		case BAOBAB_SCANNER_RESULTS_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, baobab_scanner_results_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_scanner_results_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	BaobabScannerResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_SCANNER_TYPE_RESULTS, BaobabScannerResults);
	switch (property_id) {
		case BAOBAB_SCANNER_RESULTS_PARENT_PROPERTY:
		baobab_scanner_results_set_parent (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_RESULTS_NAME_PROPERTY:
		baobab_scanner_results_set_name (self, g_value_get_string (value));
		break;
		case BAOBAB_SCANNER_RESULTS_DISPLAY_NAME_PROPERTY:
		baobab_scanner_results_set_display_name (self, g_value_get_string (value));
		break;
		case BAOBAB_SCANNER_RESULTS_SIZE_PROPERTY:
		baobab_scanner_results_set_size (self, g_value_get_uint64 (value));
		break;
		case BAOBAB_SCANNER_RESULTS_TIME_MODIFIED_PROPERTY:
		baobab_scanner_results_set_time_modified (self, g_value_get_uint64 (value));
		break;
		case BAOBAB_SCANNER_RESULTS_ELEMENTS_PROPERTY:
		baobab_scanner_results_set_elements (self, g_value_get_int (value));
		break;
		case BAOBAB_SCANNER_RESULTS_CHILDREN_LIST_STORE_PROPERTY:
		baobab_scanner_results_set_children_list_store (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_RESULTS_STATE_PROPERTY:
		baobab_scanner_results_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_SCANNER_RESULTS_PERCENT_PROPERTY:
		baobab_scanner_results_set_percent (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
baobab_scanner_class_init (BaobabScannerClass * klass,
                           gpointer klass_data)
{
	baobab_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabScanner_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_scanner_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_ROOT_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", BAOBAB_SCANNER_TYPE_RESULTS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_DIRECTORY_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_DIRECTORY_PROPERTY] = g_param_spec_object ("directory", "directory", "directory", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY] = g_param_spec_flags ("scan-flags", "scan-flags", "scan-flags", BAOBAB_TYPE_SCAN_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_SHOW_ALLOCATED_SIZE_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_SHOW_ALLOCATED_SIZE_PROPERTY] = g_param_spec_boolean ("show-allocated-size", "show-allocated-size", "show-allocated-size", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_TOTAL_SIZE_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_TOTAL_SIZE_PROPERTY] = g_param_spec_uint64 ("total-size", "total-size", "total-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_TOTAL_ELEMENTS_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_TOTAL_ELEMENTS_PROPERTY] = g_param_spec_int ("total-elements", "total-elements", "total-elements", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_MAX_DEPTH_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_MAX_DEPTH_PROPERTY] = g_param_spec_int ("max-depth", "max-depth", "max-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL] = g_signal_new ("completed", BAOBAB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
baobab_scanner_instance_init (BaobabScanner * self,
                              gpointer klass)
{
	self->priv = baobab_scanner_get_instance_private (self);
	self->priv->thread = NULL;
	self->priv->process_result_idle = (guint) 0;
	self->priv->unix_device = (guint32) 0;
	self->priv->successful = FALSE;
}

static void
baobab_scanner_finalize (GObject * obj)
{
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_SCANNER, BaobabScanner);
	_g_object_unref0 (self->priv->_root);
	_g_object_unref0 (self->priv->_directory);
	_g_thread_unref0 (self->priv->thread);
	_g_hash_table_unref0 (self->priv->hardlinks);
	_g_hash_table_unref0 (self->priv->excluded_locations);
	_g_async_queue_unref0 (self->priv->results_queue);
	_g_object_unref0 (self->priv->self);
	_g_object_unref0 (self->priv->cancellable);
	_g_error_free0 (self->priv->scan_error);
	G_OBJECT_CLASS (baobab_scanner_parent_class)->finalize (obj);
}

static GType
baobab_scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabScanner), 0, (GInstanceInitFunc) baobab_scanner_instance_init, NULL };
	GType baobab_scanner_type_id;
	baobab_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "BaobabScanner", &g_define_type_info, 0);
	BaobabScanner_private_offset = g_type_add_instance_private (baobab_scanner_type_id, sizeof (BaobabScannerPrivate));
	return baobab_scanner_type_id;
}

GType
baobab_scanner_get_type (void)
{
	static volatile gsize baobab_scanner_type_id__once = 0;
	if (g_once_init_enter (&baobab_scanner_type_id__once)) {
		GType baobab_scanner_type_id;
		baobab_scanner_type_id = baobab_scanner_get_type_once ();
		g_once_init_leave (&baobab_scanner_type_id__once, baobab_scanner_type_id);
	}
	return baobab_scanner_type_id__once;
}

static void
_vala_baobab_scanner_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_ROOT_PROPERTY:
		g_value_set_object (value, baobab_scanner_get_root (self));
		break;
		case BAOBAB_SCANNER_DIRECTORY_PROPERTY:
		g_value_set_object (value, baobab_scanner_get_directory (self));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY:
		g_value_set_flags (value, baobab_scanner_get_scan_flags (self));
		break;
		case BAOBAB_SCANNER_SHOW_ALLOCATED_SIZE_PROPERTY:
		g_value_set_boolean (value, baobab_scanner_get_show_allocated_size (self));
		break;
		case BAOBAB_SCANNER_TOTAL_SIZE_PROPERTY:
		g_value_set_uint64 (value, baobab_scanner_get_total_size (self));
		break;
		case BAOBAB_SCANNER_TOTAL_ELEMENTS_PROPERTY:
		g_value_set_int (value, baobab_scanner_get_total_elements (self));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH_PROPERTY:
		g_value_set_int (value, baobab_scanner_get_max_depth (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_scanner_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_ROOT_PROPERTY:
		baobab_scanner_set_root (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_DIRECTORY_PROPERTY:
		baobab_scanner_set_directory (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY:
		baobab_scanner_set_scan_flags (self, g_value_get_flags (value));
		break;
		case BAOBAB_SCANNER_SHOW_ALLOCATED_SIZE_PROPERTY:
		baobab_scanner_set_show_allocated_size (self, g_value_get_boolean (value));
		break;
		case BAOBAB_SCANNER_TOTAL_SIZE_PROPERTY:
		baobab_scanner_set_total_size (self, g_value_get_uint64 (value));
		break;
		case BAOBAB_SCANNER_TOTAL_ELEMENTS_PROPERTY:
		baobab_scanner_set_total_elements (self, g_value_get_int (value));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH_PROPERTY:
		baobab_scanner_set_max_depth (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

