﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/amp/model/ListAnomalyDetectorsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::PrometheusService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAnomalyDetectorsResult::ListAnomalyDetectorsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAnomalyDetectorsResult& ListAnomalyDetectorsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("anomalyDetectors")) {
    Aws::Utils::Array<JsonView> anomalyDetectorsJsonList = jsonValue.GetArray("anomalyDetectors");
    for (unsigned anomalyDetectorsIndex = 0; anomalyDetectorsIndex < anomalyDetectorsJsonList.GetLength(); ++anomalyDetectorsIndex) {
      m_anomalyDetectors.push_back(anomalyDetectorsJsonList[anomalyDetectorsIndex].AsObject());
    }
    m_anomalyDetectorsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
