/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "qoaiobject.h"

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIObjectPrivate
{
public:
    QJsonObject m_jsonObj;
};

QOAIObject::QOAIObject()
    : d(new QOAIObjectPrivate)
{
}

QOAIObject::QOAIObject(const QOAIObject &other)
    : d(std::make_unique<QOAIObjectPrivate>(*other.d))
{
}

QOAIObject &QOAIObject::operator=(const QOAIObject &other)
{
    if(this != &other)
        d = std::make_unique<QOAIObjectPrivate>(*other.d);
    return *this;
}

QOAIObject::QOAIObject(QOAIObject &&) noexcept = default;
QOAIObject &QOAIObject::operator=(QOAIObject &&) noexcept = default;
QOAIObject::~QOAIObject() = default;

QJsonObject QOAIObject::asJsonObject() const
{
    return d->m_jsonObj;
}

QString QOAIObject::asJson() const
{
    const QJsonDocument doc(d->m_jsonObj);
    const QByteArray bytes = doc.toJson(QJsonDocument::Compact);
    return QString::fromUtf8(bytes);
}

void QOAIObject::fromJson(const QString &jsonString)
{
    const QJsonDocument doc = QJsonDocument::fromJson(jsonString.toUtf8());
    d->m_jsonObj = doc.object();
}

void QOAIObject::fromJsonObject(const QJsonObject &json)
{
    d->m_jsonObj = json;
}

bool QOAIObject::isSet() const
{
    return d->m_jsonObj.empty();
}

bool QOAIObject::isValid() const
{
    return true;
}

} // namespace QtOpenApiCommon

QT_END_NAMESPACE
