/* This file is autogenerated. DO NOT CHANGE. All changes will be lost */


#include "google/protobuf/duration.qpb.h"

#include <QtProtobuf/qprotobufregistration.h>

#include <QtProtobufWellKnownTypes/private/qprotobufwellknowntypesjsonserializers_p.h>

#include <cmath>

namespace google::protobuf {
constexpr qint64 SecondsRange = 315'576'000'000LL;
constexpr qint32 NanosRange = 999'999'999;
static constexpr bool checkDurationRange(qint64 seconds, qint32 nanos) noexcept
{
    if (seconds > SecondsRange || seconds < -SecondsRange) {
        qWarning("Invalid Duration: seconds=%lld out of range [-%lld, +%lld]",
                 seconds, SecondsRange, -SecondsRange);
        return false;
    }
    if (nanos > NanosRange || nanos < -NanosRange) {
        qWarning("Invalid Duration: nanos=%d out of range [-%d, +%d]",
                 nanos, NanosRange, -NanosRange);
        return false;
    }
    return true;
}
static constexpr bool checkSignMatch(qint64 seconds, qint32 nanos) noexcept
{
    const bool isSignMatch = !(seconds != 0 && nanos != 0 
        && (seconds ^ qint64(nanos)) < 0);
    if (!isSignMatch) {
        qWarning("Invalid sign between seconds = %lld and nanos = %d",
                 seconds, nanos);
    }
    return isSignMatch;
}


class Duration_QtProtobufData : public QSharedData
{
public:
    Duration_QtProtobufData()
        : QSharedData(),
          m_seconds(0),
          m_nanos(0)
    {
    }

    Duration_QtProtobufData(const Duration_QtProtobufData &other)
        : QSharedData(other),
          m_seconds(other.m_seconds),
          m_nanos(other.m_nanos)
    {
    }

    QtProtobuf::int64 m_seconds;
    QtProtobuf::int32 m_nanos;
};

Duration::~Duration() = default;

static constexpr struct {
    QtProtobufPrivate::QProtobufPropertyOrdering::Data data;
    const std::array<uint, 9> qt_protobuf_Duration_uint_data;
    const char qt_protobuf_Duration_char_data[40];
} qt_protobuf_Duration_metadata {
    // data
    {
        0, /* = version */
        2, /* = num fields */
        3, /* = field number offset */
        5, /* = property index offset */
        7, /* = field flags offset */
        24, /* = message full name length */
    },
    // uint_data
    {
        // JSON name offsets:
        25, /* = seconds */
        33, /* = nanos */
        39, /* = end-of-string-marker */
        // Field numbers:
        1, /* = seconds */
        2, /* = nanos */
        // Property indices:
        0, /* = seconds */
        1, /* = nanos */
        // Field flags:
        uint(QtProtobufPrivate::FieldFlag::NoFlags), /* = seconds */
        uint(QtProtobufPrivate::FieldFlag::NoFlags), /* = nanos */
    },
    // char_data
    /* metadata char_data: */
    "google.protobuf.Duration\0" /* = full message name */
    /* field char_data: */
    "seconds\0nanos\0"
};

const QtProtobufPrivate::QProtobufPropertyOrdering Duration::staticPropertyOrdering = {
    &qt_protobuf_Duration_metadata.data
};

void Duration::registerTypes()
{
    qRegisterMetaType<Duration>();
    qRegisterMetaType<QList<Duration>>();
    QT_PREPEND_NAMESPACE(QtProtobufWellKnownTypesPrivate)::registerDurationCustomJsonHandler();
}

Duration::Duration()
    : QProtobufMessage(&Duration::staticMetaObject, &Duration::staticPropertyOrdering),
      dptr(new Duration_QtProtobufData)
{
}

Duration::Duration(const Duration &other)
    = default;
Duration &Duration::operator =(const Duration &other)
{
    Duration temp(other);
    swap(temp);
    return *this;
}
Duration::Duration(Duration &&other) noexcept
    = default;
Duration::operator QVariant() const
{
    return QVariant::fromValue(*this);
}
bool comparesEqual(const Duration &lhs, const Duration &rhs) noexcept
{
    return operator ==(static_cast<const QProtobufMessage&>(lhs),
                       static_cast<const QProtobufMessage&>(rhs))
        && lhs.dptr->m_seconds == rhs.dptr->m_seconds
        && lhs.dptr->m_nanos == rhs.dptr->m_nanos;
}

QtProtobuf::int64 Duration::seconds() const
{
    return dptr->m_seconds;
}

QtProtobuf::int32 Duration::nanos() const
{
    return dptr->m_nanos;
}

void Duration::setSeconds(QtProtobuf::int64 seconds)
{
    if (dptr->m_seconds != seconds) {
        dptr.detach();
        dptr->m_seconds = seconds;
    }
}

void Duration::setNanos(QtProtobuf::int32 nanos)
{
    if (dptr->m_nanos != nanos) {
        dptr.detach();
        dptr->m_nanos = nanos;
    }
}

bool Duration::isValid(QtProtobuf::int64 seconds, QtProtobuf::int32 nanos)
{
    return checkDurationRange(seconds, nanos) && checkSignMatch(seconds, nanos);
}

} // namespace google::protobuf

#include "moc_duration.qpb.cpp"
