/* math-buttons.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <adwaita.h>
#include "calculator.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD,
	BUTTON_MODE_CONVERSION
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
enum  {
	MATH_BUTTONS_0_PROPERTY,
	MATH_BUTTONS_EQUATION_PROPERTY,
	MATH_BUTTONS_CONVERTER_PROPERTY,
	MATH_BUTTONS_MODE_PROPERTY,
	MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY,
	MATH_BUTTONS_INVERSE_PROPERTY,
	MATH_BUTTONS_NUM_PROPERTIES
};
static GParamSpec* math_buttons_properties[MATH_BUTTONS_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BASIC_BUTTON_PANEL (basic_button_panel_get_type ())
#define BASIC_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_BUTTON_PANEL, BasicButtonPanel))
#define BASIC_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_BUTTON_PANEL, BasicButtonPanelClass))
#define IS_BASIC_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_BUTTON_PANEL))
#define IS_BASIC_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_BUTTON_PANEL))
#define BASIC_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_BUTTON_PANEL, BasicButtonPanelClass))

typedef struct _BasicButtonPanel BasicButtonPanel;
typedef struct _BasicButtonPanelClass BasicButtonPanelClass;

#define TYPE_ADVANCED_BUTTON_PANEL (advanced_button_panel_get_type ())
#define ADVANCED_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADVANCED_BUTTON_PANEL, AdvancedButtonPanel))
#define ADVANCED_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADVANCED_BUTTON_PANEL, AdvancedButtonPanelClass))
#define IS_ADVANCED_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADVANCED_BUTTON_PANEL))
#define IS_ADVANCED_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADVANCED_BUTTON_PANEL))
#define ADVANCED_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADVANCED_BUTTON_PANEL, AdvancedButtonPanelClass))

typedef struct _AdvancedButtonPanel AdvancedButtonPanel;
typedef struct _AdvancedButtonPanelClass AdvancedButtonPanelClass;

#define TYPE_FINANCIAL_BUTTON_PANEL (financial_button_panel_get_type ())
#define FINANCIAL_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FINANCIAL_BUTTON_PANEL, FinancialButtonPanel))
#define FINANCIAL_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FINANCIAL_BUTTON_PANEL, FinancialButtonPanelClass))
#define IS_FINANCIAL_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FINANCIAL_BUTTON_PANEL))
#define IS_FINANCIAL_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FINANCIAL_BUTTON_PANEL))
#define FINANCIAL_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FINANCIAL_BUTTON_PANEL, FinancialButtonPanelClass))

typedef struct _FinancialButtonPanel FinancialButtonPanel;
typedef struct _FinancialButtonPanelClass FinancialButtonPanelClass;

#define TYPE_PROGRAMMING_BUTTON_PANEL (programming_button_panel_get_type ())
#define PROGRAMMING_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanel))
#define PROGRAMMING_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanelClass))
#define IS_PROGRAMMING_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRAMMING_BUTTON_PANEL))
#define IS_PROGRAMMING_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRAMMING_BUTTON_PANEL))
#define PROGRAMMING_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanelClass))

typedef struct _ProgrammingButtonPanel ProgrammingButtonPanel;
typedef struct _ProgrammingButtonPanelClass ProgrammingButtonPanelClass;

#define TYPE_CONVERSION_BUTTON_PANEL (conversion_button_panel_get_type ())
#define CONVERSION_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanel))
#define CONVERSION_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanelClass))
#define IS_CONVERSION_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERSION_BUTTON_PANEL))
#define IS_CONVERSION_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERSION_BUTTON_PANEL))
#define CONVERSION_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERSION_BUTTON_PANEL, ConversionButtonPanelClass))

typedef struct _ConversionButtonPanel ConversionButtonPanel;
typedef struct _ConversionButtonPanelClass ConversionButtonPanelClass;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
enum  {
	MATH_BUTTONS_CURRENCY_CONVERSION_SIGNAL,
	MATH_BUTTONS_NUM_SIGNALS
};
static guint math_buttons_signals[MATH_BUTTONS_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MathButtons {
	AdwBin parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	AdwBinClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* _equation;
	MathConverter* _converter;
	ButtonMode _mode;
	gint _programming_base;
	gboolean _inverse;
	GtkStack* panel_stack;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* conv_panel;
	gboolean solved_using_button;
	GSimpleActionGroup* action_group;
};

static gint MathButtons_private_offset;
static gpointer math_buttons_parent_class = NULL;

VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
static void math_buttons_on_insert (MathButtons* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_buttons_on_insert_digit (MathButtons* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void math_buttons_on_insert_brackets (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_insert_brackets_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_insert_alpha (MathButtons* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _math_buttons_on_insert_alpha_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void math_buttons_on_insert_function (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_insert_function_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_insert_symbol_before (MathButtons* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _math_buttons_on_insert_symbol_before_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void math_buttons_on_insert_symbol_after (MathButtons* self,
                                          GSimpleAction* action,
                                          GVariant* param);
static void _math_buttons_on_insert_symbol_after_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void math_buttons_on_insert_exponent (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_insert_numeric_point (MathButtons* self);
static void _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void math_buttons_on_subtract (MathButtons* self);
static void _math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void math_buttons_on_square (MathButtons* self);
static void _math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_buttons_on_nth_root (MathButtons* self);
static void _math_buttons_on_nth_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void math_buttons_on_logarithm (MathButtons* self);
static void _math_buttons_on_logarithm_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void math_buttons_on_undo (MathButtons* self);
static void _math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void math_buttons_on_clear (MathButtons* self);
static void _math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void math_buttons_on_solve (MathButtons* self);
static void _math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void math_buttons_on_set_number_mode (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
VALA_EXTERN MathButtons* math_buttons_new (MathEquation* equation,
                               MathConverter* converter);
VALA_EXTERN MathButtons* math_buttons_construct (GType object_type,
                                     MathEquation* equation,
                                     MathConverter* converter);
static void math_buttons_construct_finish (MathButtons* self);
VALA_EXTERN MathEquation* math_buttons_get_equation (MathButtons* self);
VALA_EXTERN MathConverter* math_buttons_get_converter (MathButtons* self);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void _math_buttons_number_mode_changed_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void math_buttons_equation_display_changed_cb (MathButtons* self);
static void _math_buttons_equation_display_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void math_buttons_update_buttons (MathButtons* self);
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self,
                                   ButtonMode mode);
VALA_EXTERN BasicButtonPanel* basic_button_panel_new (MathButtons* buttons);
VALA_EXTERN BasicButtonPanel* basic_button_panel_construct (GType object_type,
                                                MathButtons* buttons);
VALA_EXTERN GType basic_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BasicButtonPanel, g_object_unref)
VALA_EXTERN AdvancedButtonPanel* advanced_button_panel_new (MathButtons* buttons);
VALA_EXTERN AdvancedButtonPanel* advanced_button_panel_construct (GType object_type,
                                                      MathButtons* buttons);
VALA_EXTERN GType advanced_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdvancedButtonPanel, g_object_unref)
VALA_EXTERN FinancialButtonPanel* financial_button_panel_new (MathButtons* buttons);
VALA_EXTERN FinancialButtonPanel* financial_button_panel_construct (GType object_type,
                                                        MathButtons* buttons);
VALA_EXTERN GType financial_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FinancialButtonPanel, g_object_unref)
VALA_EXTERN ProgrammingButtonPanel* programming_button_panel_new (MathButtons* buttons);
VALA_EXTERN ProgrammingButtonPanel* programming_button_panel_construct (GType object_type,
                                                            MathButtons* buttons);
VALA_EXTERN GType programming_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ProgrammingButtonPanel, g_object_unref)
VALA_EXTERN ConversionButtonPanel* conversion_button_panel_new (MathButtons* buttons);
VALA_EXTERN ConversionButtonPanel* conversion_button_panel_construct (GType object_type,
                                                          MathButtons* buttons);
VALA_EXTERN GType conversion_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConversionButtonPanel, g_object_unref)
VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
VALA_EXTERN GType math_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathDisplay, g_object_unref)
VALA_EXTERN MathDisplay* math_window_get_display (MathWindow* self);
VALA_EXTERN void math_display_set_enable_autocompletion (MathDisplay* self,
                                             gboolean enable_autocompletion);
static GVariant* _variant_new9 (const gchar* value);
static GVariant* _variant_new10 (const gchar* value);
static GVariant* _variant_new11 (const gchar* value);
VALA_EXTERN void math_buttons_set_equation (MathButtons* self,
                                MathEquation* value);
VALA_EXTERN void math_buttons_set_converter (MathButtons* self,
                                 MathConverter* value);
VALA_EXTERN void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
VALA_EXTERN gint math_buttons_get_programming_base (MathButtons* self);
VALA_EXTERN void math_buttons_set_programming_base (MathButtons* self,
                                        gint value);
VALA_EXTERN gboolean math_buttons_get_inverse (MathButtons* self);
VALA_EXTERN void math_buttons_set_inverse (MathButtons* self,
                               gboolean value);
static GObject * math_buttons_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _math_buttons_construct_finish_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void math_buttons_finalize (GObject * obj);
static GType math_buttons_get_type_once (void);
static void _vala_math_buttons_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static const GActionEntry MATH_BUTTONS_action_entries[17] = {{"insert-general", _math_buttons_on_insert_gsimple_action_activate_callback, "s"}, {"insert-digit", _math_buttons_on_insert_digit_gsimple_action_activate_callback, "i"}, {"insert-brackets", _math_buttons_on_insert_brackets_gsimple_action_activate_callback, "(ss)"}, {"insert-alpha", _math_buttons_on_insert_alpha_gsimple_action_activate_callback, "s"}, {"insert-function", _math_buttons_on_insert_function_gsimple_action_activate_callback, "s"}, {"insert-symbol-before", _math_buttons_on_insert_symbol_before_gsimple_action_activate_callback, "s"}, {"insert-symbol-after", _math_buttons_on_insert_symbol_after_gsimple_action_activate_callback, "s"}, {"insert-exponent", _math_buttons_on_insert_exponent_gsimple_action_activate_callback, "s"}, {"insert-numeric-point", _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback}, {"subtract", _math_buttons_on_subtract_gsimple_action_activate_callback}, {"square", _math_buttons_on_square_gsimple_action_activate_callback}, {"nth-root", _math_buttons_on_nth_root_gsimple_action_activate_callback}, {"logarithm", _math_buttons_on_logarithm_gsimple_action_activate_callback}, {"undo", _math_buttons_on_undo_gsimple_action_activate_callback}, {"clear", _math_buttons_on_clear_gsimple_action_activate_callback}, {"solve", _math_buttons_on_solve_gsimple_action_activate_callback}, {"set-number-mode", _math_buttons_on_set_number_mode_gsimple_action_activate_callback, "s", "'normal'"}};

 G_GNUC_NO_INLINE static GType
button_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {BUTTON_MODE_KEYBOARD, "BUTTON_MODE_KEYBOARD", "keyboard"}, {BUTTON_MODE_CONVERSION, "BUTTON_MODE_CONVERSION", "conversion"}, {0, NULL, NULL}};
	GType button_mode_type_id;
	button_mode_type_id = g_enum_register_static ("ButtonMode", values);
	return button_mode_type_id;
}

GType
button_mode_get_type (void)
{
	static gsize button_mode_type_id__once = 0;
	if (g_once_init_enter (&button_mode_type_id__once)) {
		GType button_mode_type_id;
		button_mode_type_id = button_mode_get_type_once ();
		g_once_init_leave (&button_mode_type_id__once, button_mode_type_id);
	}
	return button_mode_type_id__once;
}

static inline gpointer
math_buttons_get_instance_private (MathButtons* self)
{
	return G_STRUCT_MEMBER_P (self, MathButtons_private_offset);
}

static void
_math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_buttons_on_insert ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	math_buttons_on_insert_digit ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_brackets_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_insert_brackets ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_alpha_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	math_buttons_on_insert_alpha ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_function_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_insert_function ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_symbol_before_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	math_buttons_on_insert_symbol_before ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_symbol_after_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	math_buttons_on_insert_symbol_after ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_insert_exponent ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	math_buttons_on_insert_numeric_point ((MathButtons*) self);
}

static void
_math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	math_buttons_on_subtract ((MathButtons*) self);
}

static void
_math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_buttons_on_square ((MathButtons*) self);
}

static void
_math_buttons_on_nth_root_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	math_buttons_on_nth_root ((MathButtons*) self);
}

static void
_math_buttons_on_logarithm_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	math_buttons_on_logarithm ((MathButtons*) self);
}

static void
_math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_buttons_on_undo ((MathButtons*) self);
}

static void
_math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	math_buttons_on_clear ((MathButtons*) self);
}

static void
_math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	math_buttons_on_solve ((MathButtons*) self);
}

static void
_math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_set_number_mode ((MathButtons*) self, action, parameter);
}

MathButtons*
math_buttons_construct (GType object_type,
                        MathEquation* equation,
                        MathConverter* converter)
{
	MathButtons * self = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (converter != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "equation", equation, "converter", converter, NULL);
	return self;
}

MathButtons*
math_buttons_new (MathEquation* equation,
                  MathConverter* converter)
{
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation, converter);
}

static void
_math_buttons_number_mode_changed_cb_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	math_buttons_number_mode_changed_cb ((MathButtons*) self);
}

static void
_math_buttons_equation_display_changed_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	math_buttons_equation_display_changed_cb ((MathButtons*) self);
}

static void
math_buttons_construct_finish (MathButtons* self)
{
	gboolean _tmp0_ = FALSE;
	MathEquation* _tmp1_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	GtkStack* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GSimpleActionGroup* _tmp7_;
	MathEquation* _tmp8_;
	MathEquation* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_equation;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		MathConverter* _tmp2_;
		_tmp2_ = self->priv->_converter;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	gtk_widget_set_vexpand_set ((GtkWidget*) self, TRUE);
	_tmp3_ = self->priv->panel_stack;
	gtk_stack_set_hhomogeneous (_tmp3_, FALSE);
	_tmp4_ = self->priv->panel_stack;
	gtk_stack_set_vhomogeneous (_tmp4_, FALSE);
	_tmp5_ = self->priv->panel_stack;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp6_, MATH_BUTTONS_action_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_action_entries), self);
	_tmp7_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "cal", (GActionGroup*) _tmp7_);
	_tmp8_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::number-mode", (GCallback) _math_buttons_number_mode_changed_cb_g_object_notify, self, 0);
	_tmp9_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::display", (GCallback) _math_buttons_equation_display_changed_cb_g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
}

static void
math_buttons_update_buttons (MathButtons* self)
{
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	ButtonMode _tmp4_;
	ButtonMode _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp2_;
		_tmp2_ = self->priv->_equation;
		math_equation_set_number_base (_tmp2_, self->priv->_programming_base);
	} else {
		MathEquation* _tmp3_;
		_tmp3_ = self->priv->_equation;
		math_equation_set_number_base (_tmp3_, 10);
	}
	_tmp4_ = math_buttons_get_mode (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != BUTTON_MODE_KEYBOARD) {
		GtkStack* _tmp6_;
		ButtonMode _tmp7_;
		ButtonMode _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp6_ = self->priv->panel_stack;
		_tmp7_ = math_buttons_get_mode (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = math_buttons_load_mode (self, _tmp8_);
		_tmp10_ = _tmp9_;
		gtk_stack_set_visible_child (_tmp6_, _tmp10_);
		_g_object_unref0 (_tmp10_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
math_buttons_load_mode (MathButtons* self,
                        ButtonMode mode)
{
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp0_;
			GtkWidget* _tmp4_;
			GtkWidget* _tmp5_;
			_tmp0_ = self->priv->bas_panel;
			if (_tmp0_ == NULL) {
				BasicButtonPanel* _tmp1_;
				GtkStack* _tmp2_;
				GtkWidget* _tmp3_;
				_tmp1_ = basic_button_panel_new (self);
				g_object_ref_sink (_tmp1_);
				_g_object_unref0 (self->priv->bas_panel);
				self->priv->bas_panel = (GtkWidget*) _tmp1_;
				_tmp2_ = self->priv->panel_stack;
				_tmp3_ = self->priv->bas_panel;
				gtk_stack_add_child (_tmp2_, _tmp3_);
			}
			_tmp4_ = self->priv->bas_panel;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp6_;
			GtkWidget* _tmp10_;
			GtkWidget* _tmp11_;
			_tmp6_ = self->priv->adv_panel;
			if (_tmp6_ == NULL) {
				AdvancedButtonPanel* _tmp7_;
				GtkStack* _tmp8_;
				GtkWidget* _tmp9_;
				_tmp7_ = advanced_button_panel_new (self);
				g_object_ref_sink (_tmp7_);
				_g_object_unref0 (self->priv->adv_panel);
				self->priv->adv_panel = (GtkWidget*) _tmp7_;
				_tmp8_ = self->priv->panel_stack;
				_tmp9_ = self->priv->adv_panel;
				gtk_stack_add_child (_tmp8_, _tmp9_);
			}
			_tmp10_ = self->priv->adv_panel;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp12_;
			GtkWidget* _tmp16_;
			GtkWidget* _tmp17_;
			_tmp12_ = self->priv->fin_panel;
			if (_tmp12_ == NULL) {
				FinancialButtonPanel* _tmp13_;
				GtkStack* _tmp14_;
				GtkWidget* _tmp15_;
				_tmp13_ = financial_button_panel_new (self);
				g_object_ref_sink (_tmp13_);
				_g_object_unref0 (self->priv->fin_panel);
				self->priv->fin_panel = (GtkWidget*) _tmp13_;
				_tmp14_ = self->priv->panel_stack;
				_tmp15_ = self->priv->fin_panel;
				gtk_stack_add_child (_tmp14_, _tmp15_);
			}
			_tmp16_ = self->priv->fin_panel;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			result = _tmp17_;
			return result;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp18_;
			GtkWidget* _tmp22_;
			GtkWidget* _tmp23_;
			_tmp18_ = self->priv->prog_panel;
			if (_tmp18_ == NULL) {
				ProgrammingButtonPanel* _tmp19_;
				GtkStack* _tmp20_;
				GtkWidget* _tmp21_;
				_tmp19_ = programming_button_panel_new (self);
				g_object_ref_sink (_tmp19_);
				_g_object_unref0 (self->priv->prog_panel);
				self->priv->prog_panel = (GtkWidget*) _tmp19_;
				_tmp20_ = self->priv->panel_stack;
				_tmp21_ = self->priv->prog_panel;
				gtk_stack_add_child (_tmp20_, _tmp21_);
			}
			_tmp22_ = self->priv->prog_panel;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			result = _tmp23_;
			return result;
		}
		case BUTTON_MODE_CONVERSION:
		{
			GtkWidget* _tmp24_;
			GtkWidget* _tmp28_;
			GtkWidget* _tmp29_;
			_tmp24_ = self->priv->conv_panel;
			if (_tmp24_ == NULL) {
				ConversionButtonPanel* _tmp25_;
				GtkStack* _tmp26_;
				GtkWidget* _tmp27_;
				_tmp25_ = conversion_button_panel_new (self);
				g_object_ref_sink (_tmp25_);
				_g_object_unref0 (self->priv->conv_panel);
				self->priv->conv_panel = (GtkWidget*) _tmp25_;
				_tmp26_ = self->priv->panel_stack;
				_tmp27_ = self->priv->conv_panel;
				gtk_stack_add_child (_tmp26_, _tmp27_);
			}
			_tmp28_ = self->priv->conv_panel;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			result = _tmp29_;
			return result;
		}
	}
}

static void
math_buttons_on_insert (MathButtons* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_insert (_tmp0_, _tmp1_);
}

static void
math_buttons_on_insert_digit (MathButtons* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	MathWindow* window = NULL;
	GtkRoot* _tmp0_;
	GtkRoot* _tmp1_;
	MathWindow* _tmp2_;
	MathDisplay* _tmp3_;
	MathDisplay* _tmp4_;
	MathEquation* _tmp5_;
	MathDisplay* _tmp6_;
	MathDisplay* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (IS_MATH_WINDOW (_tmp1_) ? ((MathWindow*) _tmp1_) : NULL);
	window = _tmp2_;
	_tmp3_ = math_window_get_display (window);
	_tmp4_ = _tmp3_;
	math_display_set_enable_autocompletion (_tmp4_, FALSE);
	_tmp5_ = self->priv->_equation;
	math_equation_insert_digit (_tmp5_, (guint) g_variant_get_int32 (param));
	_tmp6_ = math_window_get_display (window);
	_tmp7_ = _tmp6_;
	math_display_set_enable_autocompletion (_tmp7_, TRUE);
	_g_object_unref0 (window);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
math_buttons_on_insert_brackets (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	GVariantIter* param_iter = NULL;
	GVariantIter* _tmp0_;
	gchar* opening = NULL;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* closing = NULL;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	MathEquation* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_iter_new (param);
	param_iter = _tmp0_;
	_tmp1_ = g_variant_iter_next_value (param_iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_string (_tmp2_, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp2_);
	opening = _tmp5_;
	_tmp6_ = g_variant_iter_next_value (param_iter);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_string (_tmp7_, NULL);
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp7_);
	closing = _tmp10_;
	_vala_assert (g_utf8_strlen (opening, (gssize) -1) == 1, "opening.char_count () == 1");
	_vala_assert (g_utf8_strlen (closing, (gssize) -1) == 1, "closing.char_count () == 1");
	_tmp11_ = self->priv->_equation;
	math_equation_insert_brackets (_tmp11_, string_get_char (opening, (glong) 0), string_get_char (closing, (glong) 0));
	_g_free0 (closing);
	_g_free0 (opening);
	_g_variant_iter_free0 (param_iter);
}

static void
math_buttons_on_insert_alpha (MathButtons* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	MathWindow* window = NULL;
	GtkRoot* _tmp0_;
	GtkRoot* _tmp1_;
	MathWindow* _tmp2_;
	MathDisplay* _tmp3_;
	MathDisplay* _tmp4_;
	MathEquation* _tmp5_;
	const gchar* _tmp6_;
	MathDisplay* _tmp7_;
	MathDisplay* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (IS_MATH_WINDOW (_tmp1_) ? ((MathWindow*) _tmp1_) : NULL);
	window = _tmp2_;
	_tmp3_ = math_window_get_display (window);
	_tmp4_ = _tmp3_;
	math_display_set_enable_autocompletion (_tmp4_, FALSE);
	_tmp5_ = self->priv->_equation;
	_tmp6_ = g_variant_get_string (param, NULL);
	math_equation_insert_alpha (_tmp5_, _tmp6_);
	_tmp7_ = math_window_get_display (window);
	_tmp8_ = _tmp7_;
	math_display_set_enable_autocompletion (_tmp8_, TRUE);
	_g_object_unref0 (window);
}

static void
math_buttons_on_insert_function (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_insert_function (_tmp0_, _tmp1_, FALSE);
}

static void
math_buttons_on_insert_symbol_before (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_insert_symbol (_tmp0_, _tmp1_, FALSE);
}

static void
math_buttons_on_insert_symbol_after (MathButtons* self,
                                     GSimpleAction* action,
                                     GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_insert_symbol (_tmp0_, _tmp1_, TRUE);
}

static void
math_buttons_on_insert_exponent (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	MathWindow* window = NULL;
	GtkRoot* _tmp0_;
	GtkRoot* _tmp1_;
	MathWindow* _tmp2_;
	MathDisplay* _tmp3_;
	MathDisplay* _tmp4_;
	MathEquation* _tmp5_;
	const gchar* _tmp6_;
	MathDisplay* _tmp7_;
	MathDisplay* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (IS_MATH_WINDOW (_tmp1_) ? ((MathWindow*) _tmp1_) : NULL);
	window = _tmp2_;
	_tmp3_ = math_window_get_display (window);
	_tmp4_ = _tmp3_;
	math_display_set_enable_autocompletion (_tmp4_, FALSE);
	_tmp5_ = self->priv->_equation;
	_tmp6_ = g_variant_get_string (param, NULL);
	math_equation_insert_exponent (_tmp5_, _tmp6_);
	_tmp7_ = math_window_get_display (window);
	_tmp8_ = _tmp7_;
	math_display_set_enable_autocompletion (_tmp8_, TRUE);
	_g_object_unref0 (window);
}

static void
math_buttons_on_insert_numeric_point (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_numeric_point (_tmp0_);
}

static void
math_buttons_on_subtract (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_subtract (_tmp0_);
}

static void
math_buttons_on_square (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_square (_tmp0_);
}

static void
math_buttons_on_nth_root (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_nth_root (_tmp0_);
}

static void
math_buttons_on_logarithm (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_logarithm (_tmp0_);
}

static void
math_buttons_on_undo (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_undo (_tmp0_);
}

static void
math_buttons_on_clear (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_clear (_tmp0_);
}

static void
math_buttons_on_solve (MathButtons* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_solve (_tmp0_);
	self->priv->solved_using_button = TRUE;
}

static void
math_buttons_on_set_number_mode (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_action_get_state ((GAction*) action);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_string (_tmp3_, NULL);
	_tmp5_ = g_strcmp0 (_tmp0_, _tmp4_) == 0;
	_g_variant_unref0 (_tmp3_);
	if (_tmp5_) {
		MathEquation* _tmp6_;
		_tmp6_ = self->priv->_equation;
		math_equation_set_number_mode (_tmp6_, NUMBER_MODE_NORMAL);
	} else {
		const gchar* _tmp7_;
		_tmp7_ = g_variant_get_string (param, NULL);
		if (g_strcmp0 (_tmp7_, "superscript") == 0) {
			MathEquation* _tmp8_;
			MathEquation* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = self->priv->_equation;
			math_equation_set_number_mode (_tmp8_, NUMBER_MODE_SUPERSCRIPT);
			_tmp9_ = self->priv->_equation;
			_tmp10_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				MathEquation* _tmp12_;
				_tmp12_ = self->priv->_equation;
				math_equation_remove_trailing_spaces (_tmp12_);
			}
		} else {
			const gchar* _tmp13_;
			_tmp13_ = g_variant_get_string (param, NULL);
			if (g_strcmp0 (_tmp13_, "subscript") == 0) {
				MathEquation* _tmp14_;
				MathEquation* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp14_ = self->priv->_equation;
				math_equation_set_number_mode (_tmp14_, NUMBER_MODE_SUBSCRIPT);
				_tmp15_ = self->priv->_equation;
				_tmp16_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					MathEquation* _tmp18_;
					_tmp18_ = self->priv->_equation;
					math_equation_remove_trailing_spaces (_tmp18_);
				}
			}
		}
	}
}

static GVariant*
_variant_new9 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new10 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new11 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
math_buttons_number_mode_changed_cb (MathButtons* self)
{
	MathEquation* _tmp0_;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		GSimpleActionGroup* _tmp3_;
		GVariant* _tmp4_;
		_tmp3_ = self->priv->action_group;
		_tmp4_ = _variant_new9 ("superscript");
		g_action_group_change_action_state ((GActionGroup*) _tmp3_, "set-number-mode", _tmp4_);
		_g_variant_unref0 (_tmp4_);
	} else {
		MathEquation* _tmp5_;
		NumberMode _tmp6_;
		NumberMode _tmp7_;
		_tmp5_ = self->priv->_equation;
		_tmp6_ = math_equation_get_number_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NUMBER_MODE_SUBSCRIPT) {
			GSimpleActionGroup* _tmp8_;
			GVariant* _tmp9_;
			_tmp8_ = self->priv->action_group;
			_tmp9_ = _variant_new10 ("subscript");
			g_action_group_change_action_state ((GActionGroup*) _tmp8_, "set-number-mode", _tmp9_);
			_g_variant_unref0 (_tmp9_);
		} else {
			GSimpleActionGroup* _tmp10_;
			GVariant* _tmp11_;
			_tmp10_ = self->priv->action_group;
			_tmp11_ = _variant_new11 ("normal");
			g_action_group_change_action_state ((GActionGroup*) _tmp10_, "set-number-mode", _tmp11_);
			_g_variant_unref0 (_tmp11_);
		}
	}
}

static void
math_buttons_equation_display_changed_cb (MathButtons* self)
{
	gboolean _tmp0_ = FALSE;
	MathEquation* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_display (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = self->priv->solved_using_button;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MathEquation* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->_equation;
		_tmp7_ = math_equation_get_display (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		gtk_accessible_announce ((GtkAccessible*) self, _tmp9_, GTK_ACCESSIBLE_ANNOUNCEMENT_PRIORITY_MEDIUM);
		_g_free0 (_tmp9_);
		self->priv->solved_using_button = FALSE;
	}
}

MathEquation*
math_buttons_get_equation (MathButtons* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

void
math_buttons_set_equation (MathButtons* self,
                           MathEquation* value)
{
	MathEquation* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_buttons_get_equation (self);
	if (old_value != value) {
		MathEquation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation);
		self->priv->_equation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_EQUATION_PROPERTY]);
	}
}

MathConverter*
math_buttons_get_converter (MathButtons* self)
{
	MathConverter* result;
	MathConverter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_converter;
	result = _tmp0_;
	return result;
}

void
math_buttons_set_converter (MathButtons* self,
                            MathConverter* value)
{
	MathConverter* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_buttons_get_converter (self);
	if (old_value != value) {
		MathConverter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_converter);
		self->priv->_converter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_CONVERTER_PROPERTY]);
	}
}

ButtonMode
math_buttons_get_mode (MathButtons* self)
{
	ButtonMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
math_buttons_set_mode (MathButtons* self,
                       ButtonMode value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_mode == value) {
		return;
	}
	self->priv->_mode = value;
	math_buttons_update_buttons (self);
	g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_MODE_PROPERTY]);
}

gint
math_buttons_get_programming_base (MathButtons* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_programming_base;
	return result;
}

void
math_buttons_set_programming_base (MathButtons* self,
                                   gint value)
{
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->_programming_base == value) {
		return;
	}
	self->priv->_programming_base = value;
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp2_;
		_tmp2_ = self->priv->_equation;
		math_equation_set_number_base (_tmp2_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY]);
}

gboolean
math_buttons_get_inverse (MathButtons* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inverse;
	return result;
}

void
math_buttons_set_inverse (MathButtons* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_buttons_get_inverse (self);
	if (old_value != value) {
		self->priv->_inverse = value;
		g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_INVERSE_PROPERTY]);
	}
}

static void
_math_buttons_construct_finish_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	math_buttons_construct_finish ((MathButtons*) self);
}

static GObject *
math_buttons_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathButtons * self;
	parent_class = G_OBJECT_CLASS (math_buttons_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	g_signal_connect_object ((GObject*) self, "notify::equation", (GCallback) _math_buttons_construct_finish_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::converter", (GCallback) _math_buttons_construct_finish_g_object_notify, self, 0);
	return obj;
}

static void
math_buttons_class_init (MathButtonsClass * klass,
                         gpointer klass_data)
{
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathButtons_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_buttons_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_EQUATION_PROPERTY, math_buttons_properties[MATH_BUTTONS_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_CONVERTER_PROPERTY, math_buttons_properties[MATH_BUTTONS_CONVERTER_PROPERTY] = g_param_spec_object ("converter", "converter", "converter", TYPE_MATH_CONVERTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE_PROPERTY, math_buttons_properties[MATH_BUTTONS_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY, math_buttons_properties[MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY] = g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_INVERSE_PROPERTY, math_buttons_properties[MATH_BUTTONS_INVERSE_PROPERTY] = g_param_spec_boolean ("inverse", "inverse", "inverse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	math_buttons_signals[MATH_BUTTONS_CURRENCY_CONVERSION_SIGNAL] = g_signal_new ("currency-conversion", TYPE_MATH_BUTTONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
math_buttons_instance_init (MathButtons * self,
                            gpointer klass)
{
	GtkStack* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	self->priv = math_buttons_get_instance_private (self);
	self->priv->_mode = -1;
	self->priv->_programming_base = 10;
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->panel_stack = _tmp0_;
	_tmp1_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp1_;
}

static void
math_buttons_finalize (GObject * obj)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->_converter);
	_g_object_unref0 (self->priv->panel_stack);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->conv_panel);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
math_buttons_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
	GType math_buttons_type_id;
	math_buttons_type_id = g_type_register_static (adw_bin_get_type (), "MathButtons", &g_define_type_info, 0);
	MathButtons_private_offset = g_type_add_instance_private (math_buttons_type_id, sizeof (MathButtonsPrivate));
	return math_buttons_type_id;
}

GType
math_buttons_get_type (void)
{
	static gsize math_buttons_type_id__once = 0;
	if (g_once_init_enter (&math_buttons_type_id__once)) {
		GType math_buttons_type_id;
		math_buttons_type_id = math_buttons_get_type_once ();
		g_once_init_leave (&math_buttons_type_id__once, math_buttons_type_id);
	}
	return math_buttons_type_id__once;
}

static void
_vala_math_buttons_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_EQUATION_PROPERTY:
		g_value_set_object (value, math_buttons_get_equation (self));
		break;
		case MATH_BUTTONS_CONVERTER_PROPERTY:
		g_value_set_object (value, math_buttons_get_converter (self));
		break;
		case MATH_BUTTONS_MODE_PROPERTY:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		case MATH_BUTTONS_INVERSE_PROPERTY:
		g_value_set_boolean (value, math_buttons_get_inverse (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_buttons_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_EQUATION_PROPERTY:
		math_buttons_set_equation (self, g_value_get_object (value));
		break;
		case MATH_BUTTONS_CONVERTER_PROPERTY:
		math_buttons_set_converter (self, g_value_get_object (value));
		break;
		case MATH_BUTTONS_MODE_PROPERTY:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		case MATH_BUTTONS_INVERSE_PROPERTY:
		math_buttons_set_inverse (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

