/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.common;

import com.dickimawbooks.bibgls.common.BibGlsConverter;
import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.generic.UndefinedActiveChar;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.UnknownSty;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class BibGlsConverterListener
extends LaTeXParserListener
implements Writeable {
    protected boolean preambleOnly;
    protected BibGlsConverter texApp;

    public BibGlsConverterListener(BibGlsConverter bibGlsConverter, boolean bl) {
        super(null);
        this.texApp = bibGlsConverter;
        this.preambleOnly = bl;
        this.setWriteable(this);
    }

    public TeXApp getTeXApp() {
        return this.texApp;
    }

    public void substituting(String string, String string2) {
        this.texApp.substituting(this.getParser(), string, string2);
    }

    protected void addPredefined() {
        super.addPredefined();
        this.texApp.addPredefinedCommands(this.getParser());
    }

    public void newcommand(boolean bl, Overwrite overwrite, String string, String string2, boolean bl2, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        if (this.texApp.newcommandOverride(bl, overwrite, string, string2, bl2, n, teXObject, teXObject2)) {
            return;
        }
        super.newcommand(bl, overwrite, string, string2, bl2, n, teXObject, teXObject2);
    }

    protected boolean isIgnoredPackage(String string) {
        return false;
    }

    protected LaTeXSty getLaTeXSty(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        if (this.texApp.isIgnoredPackage(string)) {
            return new UnknownSty(keyValList, string, (LaTeXParserListener)this, bl);
        }
        return super.getLaTeXSty(keyValList, string, bl, teXObjectList);
    }

    public LaTeXSty usepackage(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        if (this.texApp.isSpecialUsePackage(keyValList, string, bl, teXObjectList)) {
            return null;
        }
        return super.usepackage(keyValList, string, bl, teXObjectList);
    }

    public ControlSequence createUndefinedCs(String string) {
        return new Undefined(string, this.texApp.isSilent() ? UndefAction.IGNORE : UndefAction.WARN);
    }

    public ActiveChar getUndefinedActiveChar(int n) {
        return new UndefinedActiveChar(n, this.texApp.isSilent() ? UndefAction.IGNORE : UndefAction.WARN);
    }

    public void beginDocument(TeXObjectList teXObjectList) throws IOException {
        super.beginDocument(teXObjectList);
        if (this.preambleOnly) {
            this.endDocument(teXObjectList);
        }
    }

    public void write(String string) throws IOException {
    }

    public void writeln(String string) throws IOException {
    }

    public void writeliteralln(String string) throws IOException {
    }

    public void writeliteral(String string) throws IOException {
    }

    public void write(char c) throws IOException {
    }

    public void writeCodePoint(int n) throws IOException {
    }

    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        this.texApp.debug("Ignoring \\overwithdelims");
    }

    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        this.texApp.debug("Ignoring \\abovewithdelims");
    }

    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    public void href(String string, TeXObject teXObject) throws IOException {
        this.texApp.debug("Ignoring \\href");
    }

    public void subscript(TeXObject teXObject) throws IOException {
        this.texApp.debug("Ignoring _");
    }

    public void superscript(TeXObject teXObject) throws IOException {
        this.texApp.debug("Ignoring ^");
    }

    public void includegraphics(TeXObjectList teXObjectList, KeyValList keyValList, String string) throws IOException {
        this.texApp.debug("Ignoring \\includegraphics");
    }

    public void endParse(File file) throws IOException {
    }

    public void beginParse(File file, Charset charset) throws IOException {
        this.texApp.message(this.texApp.getMessage("message.reading", file));
        if (charset == null) {
            this.texApp.message(this.texApp.getMessage("message.default.charset", this.texApp.getDefaultCharset()));
        } else {
            this.texApp.message(this.texApp.getMessage("message.tex.charset", charset));
        }
    }

    public float emToPt(float f) {
        this.texApp.warning(this.getParser(), "Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    public float exToPt(float f) {
        this.texApp.warning(this.getParser(), "Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }

    public Charset getCharSet() {
        return this.texApp.getCharSet();
    }
}

