/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.HashMultiset;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.interpreter.Source;
import org.apache.calcite.rel.core.SetOp;

public class SetOpNode
implements Node {
    private final Source leftSource;
    private final Source rightSource;
    private final Sink sink;
    private final SetOp setOp;

    public SetOpNode(Compiler compiler, SetOp setOp) {
        this.leftSource = compiler.source(setOp, 0);
        this.rightSource = compiler.source(setOp, 1);
        this.sink = compiler.sink(setOp);
        this.setOp = setOp;
    }

    @Override
    public void close() {
        this.leftSource.close();
        this.rightSource.close();
    }

    @Override
    public void run() throws InterruptedException {
        Row row;
        Object rightRows;
        Object leftRows;
        if (this.setOp.all) {
            leftRows = HashMultiset.create();
            rightRows = HashMultiset.create();
        } else {
            leftRows = new HashSet();
            rightRows = new HashSet();
        }
        while ((row = this.leftSource.receive()) != null) {
            leftRows.add(row);
        }
        while ((row = this.rightSource.receive()) != null) {
            rightRows.add(row);
        }
        switch (this.setOp.kind) {
            case INTERSECT: {
                Iterator iterator = leftRows.iterator();
                while (iterator.hasNext()) {
                    Row leftRow = (Row)iterator.next();
                    if (!rightRows.remove(leftRow)) continue;
                    this.sink.send(leftRow);
                }
                break;
            }
            case EXCEPT: {
                Iterator iterator = leftRows.iterator();
                while (iterator.hasNext()) {
                    Row leftRow = (Row)iterator.next();
                    if (rightRows.remove(leftRow)) continue;
                    this.sink.send(leftRow);
                }
                break;
            }
            case UNION: {
                leftRows.addAll(rightRows);
                Iterator iterator = leftRows.iterator();
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    this.sink.send(r);
                }
                break;
            }
        }
    }
}

