/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkInvertIntensityImageFilter_h
#define sitkInvertIntensityImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class InvertIntensityImageFilter
\brief Invert the intensity of an image.

InvertIntensityImageFilter inverts intensity of pixels by subtracting pixel value to a maximum value. The maximum value can be set with SetMaximum and defaults the maximum of input pixel type. This filter can be used to invert, for example, a binary image, a distance map, etc.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


\see IntensityWindowingImageFilter ShiftScaleImageFilter
\sa itk::simple::InvertIntensity for the procedural interface
\sa itk::InvertIntensityImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT InvertIntensityImageFilter : public ImageFilter {
    public:
      using Self = InvertIntensityImageFilter;

      /** Destructor */
      virtual ~InvertIntensityImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      InvertIntensityImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/Get the maximum intensity value for the inversion.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximum ( double Maximum ) { this->m_Maximum = Maximum; return *this; }

      /**
       * Set/Get the maximum intensity value for the inversion.
       */
      double GetMaximum() const { return this->m_Maximum; }

      /** Name of this class */
      std::string GetName() const { return std::string ("InvertIntensityImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInternal on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Maximum output */
      double  m_Maximum{255};


      bool m_InPlace{false};
    };

    /**\
     * \brief Invert the intensity of an image.
     *
     * This function directly calls the execute method of InvertIntensityImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::InvertIntensityImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image InvertIntensity ( Image&& image1, double maximum = 255 );
#endif
     SITKBasicFilters_EXPORT Image InvertIntensity ( const Image& image1, double maximum = 255 );

     /** @} */
}
#endif
