/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.SuggestedVcsComparator;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;

public final class StartUseVcsDialog
extends DialogWrapper {
    private final ComboBox<AbstractVcs> myVcsCombo;
    @NotNull
    private final String myTargetDirectory;

    public StartUseVcsDialog(@NotNull Project project, @NotNull String targetDirectory) {
        if (project == null) {
            StartUseVcsDialog.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            StartUseVcsDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myTargetDirectory = targetDirectory;
        Object[] vcses = ProjectLevelVcsManager.getInstance((Project)project).getAllSupportedVcss();
        ContainerUtil.sort((Object[])vcses, SuggestedVcsComparator.create(project));
        this.myVcsCombo = new ComboBox(vcses);
        this.myVcsCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", AbstractVcs::getDisplayName));
        this.setTitle(VcsBundle.message((String)"dialog.enable.version.control.integration.title", (Object[])new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVcsCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.select.vcs.label.text", (Object[])new Object[]{PathUtil.getFileName((String)this.myTargetDirectory)}));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.insets((int)5), 0, 0);
        mainPanel2.add((Component)selectText, gb);
        ++gb.gridx;
        mainPanel2.add((Component)this.myVcsCombo, gb);
        String path = SystemInfo.isMac ? VcsBundle.message((String)"vcs.settings.path.mac", (Object[])new Object[0]) : VcsBundle.message((String)"vcs.settings.path", (Object[])new Object[0]);
        JLabel helpText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.hint.text", (Object[])new Object[0]) + path);
        helpText.setUI((LabelUI)new MultiLineLabelUI());
        helpText.setForeground(NamedColorUtil.getInactiveTextColor());
        gb.anchor = 18;
        gb.gridx = 0;
        ++gb.gridy;
        gb.gridwidth = 2;
        mainPanel2.add((Component)helpText, gb);
        JPanel wrapper2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0);
        wrapper2.add((Component)mainPanel2, gbc);
        return wrapper2;
    }

    protected String getHelpId() {
        return "reference.version.control.enable.version.control.integration";
    }

    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs abstractVcs = (AbstractVcs)this.myVcsCombo.getItem();
        if (abstractVcs == null) {
            StartUseVcsDialog.$$$reportNull$$$0(2);
        }
        return abstractVcs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/StartUseVcsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/StartUseVcsDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

