/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import org.jetbrains.annotations.NotNull;

class BlinkingTextTracker {
    private final BlinkTracker slowBlinkTracker = new BlinkTracker();
    private final BlinkTracker rapidBlinkTracker = new BlinkTracker();

    BlinkingTextTracker() {
    }

    void updateState(@NotNull SettingsProvider settingsProvider, @NotNull TerminalPanel panel) {
        if (settingsProvider.enableTextBlinking()) {
            long currentTime = System.currentTimeMillis();
            boolean slowBlinkStateChanged = this.slowBlinkTracker.update(currentTime, settingsProvider.slowTextBlinkMs());
            boolean rapidBlinkStateChanged = this.rapidBlinkTracker.update(currentTime, settingsProvider.rapidTextBlinkMs());
            if (slowBlinkStateChanged || rapidBlinkStateChanged) {
                panel.repaint();
            }
        }
    }

    boolean shouldBlinkNow(@NotNull TextStyle style) {
        return style.hasOption(TextStyle.Option.SLOW_BLINK) && this.slowBlinkTracker.inverse || style.hasOption(TextStyle.Option.RAPID_BLINK) && this.rapidBlinkTracker.inverse;
    }

    private static class BlinkTracker {
        private final long lastBlinkMillis = System.currentTimeMillis();
        private boolean inverse = false;

        private BlinkTracker() {
        }

        private boolean update(long currentTime, int period) {
            if (period <= 0) {
                return false;
            }
            boolean prevInverse = this.inverse;
            int blinks = (int)(currentTime - this.lastBlinkMillis) / period;
            this.inverse = blinks % 2 == 1;
            return prevInverse != this.inverse;
        }
    }
}

