/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.fips.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.fips.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.fips.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.fips.Ed25519Signer;
import org.bouncycastle.crypto.fips.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.fips.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.fips.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.fips.Ed448Signer;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsOutputSigner;
import org.bouncycastle.crypto.fips.FipsOutputValidator;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSignatureOperatorFactory;
import org.bouncycastle.crypto.fips.HashEd25519Signer;
import org.bouncycastle.crypto.fips.HashEd448Signer;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.SignerOutputStream;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class FipsEdEC {
    public static final byte[] ZERO_CONTEXT = new byte[0];
    private static final Ed448PrivateKeyParameters ed448KatPriv = new Ed448PrivateKeyParameters(Hex.decode("833fe62409237b9d62ec77587520911e9a759cec1d19755b7da901b96dca3d42ef7822e0d5104127dc05d6dbefde69e3ab2cec7c867c6e2c49"));
    private static final Ed448PublicKeyParameters ed448KatPub = new Ed448PublicKeyParameters(Hex.decode("259b71c19f83ef77a7abd26524cbdb3161b590a48f7d17de3ee0ba9c52beb743c09428a131d6b1b57303d90d8132c276d5ed3d5d01c0f53880"));
    private static final Ed25519PrivateKeyParameters ed25519KatPriv = new Ed25519PrivateKeyParameters(Hex.decode("ab9c2853ce297ddab85c993b3ae14bcad39b2c682beabc27d6d4eb20711d6560"));
    private static final Ed25519PublicKeyParameters ed25519KatPub = new Ed25519PublicKeyParameters(Hex.decode("0f1d1274943b91415889152e893d80e93275a1fc0b65fd71b4b0dda10ad7d772"));
    private static final byte[] data = Hex.decode("f726936d19c800494e3fdaff20b276a8");
    private static final byte[] katEd25519 = Hex.decode("daca536d5370fdada0b14cfbe1f25c1199f67b18999ce05a50cc66a83c79984421fcc8d8dfde4cd57e00d96f1d7151f279c34801b17ec40c461c0bc800557106");
    private static final byte[] katEd448 = Hex.decode("f45d7a3e96ea099edffc99d0980242f64a33ea7b0ef09fa0c621c65103f464ebe17a716a0246b2325cd20b577f6c2f25d3a509f23dca1f9f80d5fb4167cd27ab461b344d82e0f93dc844718763b36b0dd9a3561e7e2f3983cfb7bbe0c83cdfc93060a3bca04a9f2dfabfab069065f5ed0e00");
    private static final byte[] katEd25519ph = Hex.decode("80ccf9c08ce4e6db71491cf99b8b3445d79a231e8f8383f3a70db733bdea03eb2c29ccb8b20bd9a65265393e21970d5798354d1a9569c9df29d641b7b9d52802");
    private static final byte[] katEd448ph = Hex.decode("fe4a12d88f6878ee10028444ae0185d73c8d3e385a600d39a081b5953f952f8a538ceacb353b88aac79e39caaf41eb4f8b51ac4790e3e8258048f58bdf9179da473bfc227c41bf866f3a0944974f1ac723132d2156b0a66703553cd09e5512a807c469803e50c6d5607c2772864cd34a0f00");
    public static final Parameters EdDSA = new Parameters(Algorithm.access$000());
    public static final Parameters EdDSAph = new Parameters(Algorithm.access$100());
    public static final Parameters Ed448 = new Parameters(Algorithm.Ed448);
    public static final Parameters Ed448ph = new Parameters(Algorithm.Ed448ph);
    public static final Parameters Ed25519 = new Parameters(Algorithm.Ed25519);
    public static final Parameters Ed25519ph = new Parameters(Algorithm.Ed25519ph);
    public static final int Ed448_PUBLIC_KEY_SIZE = 57;
    public static final int Ed25519_PUBLIC_KEY_SIZE = 32;
    public static final int Ed448_PRIVATE_KEY_SIZE = 57;
    public static final int Ed25519_PRIVATE_KEY_SIZE = 32;
    private static final EdDSAProvider edDsaProvider = new EdDSAProvider();
    private static final EdDSAphProvider edDsaPhProvider = new EdDSAphProvider();

    private FipsEdEC() {
    }

    private static FipsAlgorithm getSignatureAlgorithm(FipsAlgorithm fipsAlgorithm, Parameters parameters) {
        if (parameters.getAlgorithm().equals(Algorithm.Pure)) {
            return fipsAlgorithm.basicVariation() == Variations.Ed448 ? Algorithm.Ed448 : Algorithm.Ed25519;
        }
        if (parameters.getAlgorithm().equals(Algorithm.Hash)) {
            return fipsAlgorithm.basicVariation() == Variations.Ed448 ? Algorithm.Ed448ph : Algorithm.Ed25519ph;
        }
        return parameters.getAlgorithm();
    }

    public static byte[] computePublicData(org.bouncycastle.crypto.Algorithm algorithm, byte[] byArray) {
        byte[] byArray2;
        if (algorithm.equals(Algorithm.Ed448) || algorithm.equals(Algorithm.Ed448ph)) {
            Ed448 ed448 = new Ed448(){

                @Override
                protected Xof createXof() {
                    return (Xof)FipsSHS.createDigest(FipsSHS.Algorithm.SHAKE256);
                }
            };
            byArray2 = new byte[57];
            ed448.generatePublicKey(byArray, 0, byArray2, 0);
        } else {
            Ed25519 ed25519 = new Ed25519(){

                @Override
                protected Digest createDigest() {
                    return FipsSHS.createDigest(FipsSHS.Algorithm.SHA512);
                }
            };
            byArray2 = new byte[32];
            ed25519.generatePublicKey(byArray, 0, byArray2, 0);
        }
        return byArray2;
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                if (asymmetricEdDSAPrivateKey.getAlgorithm().equals(Algorithm.Ed448) || asymmetricEdDSAPrivateKey.getAlgorithm().equals(Algorithm.Ed448ph)) {
                    return new Ed448PrivateKeyParameters(asymmetricEdDSAPrivateKey.getSecret());
                }
                return new Ed25519PrivateKeyParameters(asymmetricEdDSAPrivateKey.getSecret());
            }
        });
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                if (asymmetricEdDSAPublicKey.getAlgorithm().equals(Algorithm.Ed448) || asymmetricEdDSAPublicKey.getAlgorithm().equals(Algorithm.Ed448ph)) {
                    return new Ed448PublicKeyParameters(asymmetricEdDSAPublicKey.getPublicData());
                }
                return new Ed25519PublicKeyParameters(asymmetricEdDSAPublicKey.getPublicData());
            }
        });
    }

    private static void validateSigningKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        if (asymmetricCipherKeyPair.getPublic() instanceof Ed448PublicKeyParameters) {
            SelfTestExecutor.validate(Algorithm.Ed448, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                @Override
                public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                    return FipsEdEC.isOkaySigning(new Ed448Signer(ZERO_CONTEXT), asymmetricCipherKeyPair);
                }
            });
        } else {
            SelfTestExecutor.validate(Algorithm.Ed25519, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                @Override
                public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                    return FipsEdEC.isOkaySigning(new Ed25519Signer(), asymmetricCipherKeyPair);
                }
            });
        }
    }

    private static boolean isOkaySigning(Signer signer, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        try {
            signer.init(true, asymmetricCipherKeyPair.getPrivate());
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            signer.init(false, asymmetricCipherKeyPair.getPublic());
            signer.update(data, 0, data.length);
            return signer.verifySignature(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static AsymmetricCipherKeyPair getKATKeys(Variations variations) {
        if (variations == Variations.Ed448 || variations == Variations.Ed448ph) {
            return new AsymmetricCipherKeyPair(ed448KatPub, ed448KatPriv);
        }
        return new AsymmetricCipherKeyPair(ed25519KatPub, ed25519KatPriv);
    }

    static {
        edDsaProvider.createEngine(Variations.Ed25519, ZERO_CONTEXT);
        edDsaProvider.createEngine(Variations.Ed448, ZERO_CONTEXT);
        edDsaPhProvider.createEngine(Variations.Ed25519ph, ZERO_CONTEXT);
        edDsaPhProvider.createEngine(Variations.Ed448ph, ZERO_CONTEXT);
    }

    public static final class Algorithm {
        private static final FipsAlgorithm Pure = new FipsAlgorithm("EdDSA");
        private static final FipsAlgorithm Hash = new FipsAlgorithm("EdDSAph");
        public static final FipsAlgorithm Ed448 = new FipsAlgorithm("Ed448", (Enum)Variations.Ed448);
        public static final FipsAlgorithm Ed448ph = new FipsAlgorithm("Ed448ph", (Enum)Variations.Ed448ph);
        public static final FipsAlgorithm Ed25519 = new FipsAlgorithm("Ed25519", (Enum)Variations.Ed25519);
        public static final FipsAlgorithm Ed25519ph = new FipsAlgorithm("Ed25519ph", (Enum)Variations.Ed25519ph);

        private Algorithm() {
        }
    }

    public static final class EdDSAKeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<Parameters, AsymmetricEdDSAPublicKey, AsymmetricEdDSAPrivateKey> {
        private final Variations variation;
        private final AsymmetricCipherKeyPairGenerator kpGen;

        public EdDSAKeyPairGenerator(Parameters parameters, SecureRandom secureRandom) {
            super(parameters);
            int n;
            if (parameters.getAlgorithm().basicVariation() == null) {
                throw new IllegalArgumentException("key generation parameters must specify Ed25519 or Ed448");
            }
            switch ((Variations)parameters.getAlgorithm().basicVariation()) {
                case Ed448: 
                case Ed448ph: {
                    this.variation = Variations.Ed448;
                    this.kpGen = new Ed448KeyPairGenerator();
                    n = 224;
                    break;
                }
                case Ed25519: 
                case Ed25519ph: {
                    this.variation = Variations.Ed25519;
                    this.kpGen = new Ed25519KeyPairGenerator();
                    n = 128;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyPairGenRandom(secureRandom, n, parameters.getAlgorithm());
            }
            this.kpGen.init(new KeyGenerationParameters(secureRandom, 0));
        }

        @Override
        public AsymmetricKeyPair generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpGen.generateKeyPair();
            FipsEdEC.validateSigningKeyPair(asymmetricCipherKeyPair);
            switch (this.variation) {
                case Ed448: {
                    return new AsymmetricKeyPair<AsymmetricEdDSAPublicKey, AsymmetricEdDSAPrivateKey>(new AsymmetricEdDSAPublicKey(Ed448.getAlgorithm(), ((Ed448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()), new AsymmetricEdDSAPrivateKey(Ed448.getAlgorithm(), ((Ed448PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getEncoded(), ((Ed448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()));
                }
                case Ed25519: {
                    return new AsymmetricKeyPair<AsymmetricEdDSAPublicKey, AsymmetricEdDSAPrivateKey>(new AsymmetricEdDSAPublicKey(Ed25519.getAlgorithm(), ((Ed25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()), new AsymmetricEdDSAPrivateKey(Ed25519.getAlgorithm(), ((Ed25519PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getEncoded(), ((Ed25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()));
                }
            }
            throw new IllegalArgumentException("unknown algorithm");
        }
    }

    public static final class EdDSAOperatorFactory
    extends FipsSignatureOperatorFactory<Parameters> {
        @Override
        public FipsOutputSigner<Parameters> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, final Parameters parameters) {
            final Signer signer = this.createEngine((FipsAlgorithm)asymmetricPrivateKey.getAlgorithm(), parameters);
            final FipsAlgorithm fipsAlgorithm = FipsEdEC.getSignatureAlgorithm((FipsAlgorithm)asymmetricPrivateKey.getAlgorithm(), parameters);
            signer.init(true, FipsEdEC.getLwKey((AsymmetricEdDSAPrivateKey)asymmetricPrivateKey));
            return new FipsOutputSigner<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getSigningStream() {
                    return new SignerOutputStream(fipsAlgorithm.getName(), signer);
                }

                @Override
                public byte[] getSignature() throws PlainInputProcessingException {
                    try {
                        return signer.generateSignature();
                    }
                    catch (Exception exception) {
                        throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
                    }
                }

                @Override
                public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
                    byte[] byArray2 = this.getSignature();
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    return byArray2.length;
                }
            };
        }

        @Override
        public FipsOutputVerifier<Parameters> createVerifier(AsymmetricPublicKey asymmetricPublicKey, final Parameters parameters) {
            final FipsAlgorithm fipsAlgorithm = FipsEdEC.getSignatureAlgorithm((FipsAlgorithm)asymmetricPublicKey.getAlgorithm(), parameters);
            final Signer signer = this.getVerifySigner((AsymmetricEdDSAPublicKey)asymmetricPublicKey, fipsAlgorithm, parameters);
            return new FipsOutputVerifier<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(fipsAlgorithm.getName(), signer);
                }

                @Override
                public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
                    return signer.verifySignature(byArray);
                }
            };
        }

        @Override
        public FipsOutputValidator<Parameters> createValidator(AsymmetricPublicKey asymmetricPublicKey, final Parameters parameters, final byte[] byArray) {
            final FipsAlgorithm fipsAlgorithm = FipsEdEC.getSignatureAlgorithm((FipsAlgorithm)asymmetricPublicKey.getAlgorithm(), parameters);
            final Signer signer = this.getVerifySigner((AsymmetricEdDSAPublicKey)asymmetricPublicKey, fipsAlgorithm, parameters);
            return new FipsOutputValidator<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getValidatingStream() {
                    return new SignerOutputStream(fipsAlgorithm.getName(), signer);
                }

                @Override
                public boolean isValidated() {
                    try {
                        return signer.verifySignature(byArray);
                    }
                    catch (InvalidSignatureException invalidSignatureException) {
                        return false;
                    }
                }
            };
        }

        private Signer getVerifySigner(AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey, FipsAlgorithm fipsAlgorithm, Parameters parameters) {
            Signer signer = this.createEngine((FipsAlgorithm)asymmetricEdDSAPublicKey.getAlgorithm(), parameters);
            signer.init(false, FipsEdEC.getLwKey(asymmetricEdDSAPublicKey));
            return signer;
        }

        private Signer createEngine(FipsAlgorithm fipsAlgorithm, Parameters parameters) {
            Signer signer;
            FipsAlgorithm fipsAlgorithm2 = FipsEdEC.getSignatureAlgorithm(fipsAlgorithm, parameters);
            switch ((Variations)fipsAlgorithm2.basicVariation()) {
                case Ed448: {
                    signer = parameters instanceof ParametersWithContext ? edDsaProvider.createEngine(Variations.Ed448, ((ParametersWithContext)parameters).context) : edDsaProvider.createEngine(Variations.Ed448, ZERO_CONTEXT);
                    break;
                }
                case Ed448ph: {
                    signer = parameters instanceof ParametersWithContext ? edDsaPhProvider.createEngine(Variations.Ed448ph, ((ParametersWithContext)parameters).context) : edDsaPhProvider.createEngine(Variations.Ed448ph, ZERO_CONTEXT);
                    break;
                }
                case Ed25519: {
                    signer = edDsaProvider.createEngine(Variations.Ed25519, ZERO_CONTEXT);
                    break;
                }
                case Ed25519ph: {
                    signer = parameters instanceof ParametersWithContext ? edDsaPhProvider.createEngine(Variations.Ed25519ph, ((ParametersWithContext)parameters).context) : edDsaPhProvider.createEngine(Variations.Ed25519ph, ZERO_CONTEXT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            return signer;
        }
    }

    private static class EdDSAProvider {
        private EdDSAProvider() {
        }

        Signer createEngine(final Variations variations, final byte[] byArray) {
            return SelfTestExecutor.validate(EdDSA.getAlgorithm(), variations == Variations.Ed448 ? new Ed448Signer(byArray) : new Ed25519Signer(), new VariantKatTest<Signer>(){

                @Override
                void evaluate(Signer signer) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEdEC.getKATKeys(variations);
                    signer.init(true, asymmetricCipherKeyPair.getPrivate());
                    signer.update(data, 0, data.length);
                    byte[] byArray4 = signer.generateSignature();
                    if (byArray.length == 0) {
                        byte[] byArray2;
                        byte[] byArray3 = byArray2 = variations == Variations.Ed448 ? katEd448 : katEd25519;
                        if (!Arrays.areEqual(byArray2, byArray4)) {
                            this.fail("EdDSAph KAT failed to generate expected signature");
                        }
                    }
                    signer.init(false, asymmetricCipherKeyPair.getPublic());
                    signer.update(data, 0, data.length);
                    if (!signer.verifySignature(byArray4)) {
                        this.fail("EdDSA KAT failed to verify");
                    }
                }
            });
        }
    }

    private static class EdDSAphProvider {
        private EdDSAphProvider() {
        }

        Signer createEngine(final Variations variations, final byte[] byArray) {
            return SelfTestExecutor.validate(EdDSAph.getAlgorithm(), variations == Variations.Ed448ph ? new HashEd448Signer(byArray) : new HashEd25519Signer(byArray), new VariantKatTest<Signer>(){

                @Override
                void evaluate(Signer signer) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEdEC.getKATKeys(variations);
                    signer.init(true, asymmetricCipherKeyPair.getPrivate());
                    signer.update(data, 0, data.length);
                    byte[] byArray4 = signer.generateSignature();
                    if (byArray.length == 0) {
                        byte[] byArray2;
                        byte[] byArray3 = byArray2 = variations == Variations.Ed448ph ? katEd448ph : katEd25519ph;
                        if (!Arrays.areEqual(byArray2, byArray4)) {
                            this.fail("EdDSAph KAT failed to generate expected signature");
                        }
                    }
                    signer.init(false, asymmetricCipherKeyPair.getPublic());
                    signer.update(data, 0, data.length);
                    if (!signer.verifySignature(byArray4)) {
                        this.fail("EdDSAph KAT failed to verify");
                    }
                }
            });
        }
    }

    public static class Parameters
    extends FipsParameters {
        Parameters(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }
    }

    public static class ParametersWithContext
    extends Parameters {
        private final byte[] context;

        public ParametersWithContext(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            super(fipsAlgorithm);
            if (fipsAlgorithm.equals(Algorithm.Ed25519)) {
                throw new IllegalArgumentException("context cannot be used with Ed25519");
            }
            if (byArray == null) {
                throw new IllegalArgumentException("context cannot be null");
            }
            if (byArray.length > 255) {
                throw new IllegalArgumentException("context > 255");
            }
            this.context = Arrays.clone(byArray);
        }

        public byte[] getContext() {
            return Arrays.clone(this.context);
        }
    }

    private static enum Variations {
        Ed448,
        Ed448ph,
        Ed25519,
        Ed25519ph;

    }
}

