/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.serializer.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public final class ChainedPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(ChainedPollingStrategy.class);
    private final List<PollingStrategy<T, U>> pollingStrategies;
    private PollingStrategy<T, U> pollableStrategy = null;

    public ChainedPollingStrategy(List<PollingStrategy<T, U>> strategies) {
        Objects.requireNonNull(strategies, "'strategies' cannot be null.");
        if (strategies.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'strategies' cannot be empty."));
        }
        this.pollingStrategies = Collections.unmodifiableList(strategies);
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        return Flux.fromIterable(this.pollingStrategies).concatMap(strategy -> strategy.canPoll(initialResponse).map(canPoll -> Tuples.of((Object)strategy, (Object)canPoll))).takeUntil(Tuple2::getT2).last().map(tuple2 -> {
            this.pollableStrategy = (PollingStrategy)tuple2.getT1();
            return true;
        }).defaultIfEmpty((Object)false);
    }

    @Override
    public Mono<U> getResult(PollingContext<T> context, TypeReference<U> resultType) {
        return this.pollableStrategy.getResult(context, resultType);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return this.pollableStrategy.onInitialResponse(response, pollingContext, pollResponseType);
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> context, TypeReference<T> pollResponseType) {
        return this.pollableStrategy.poll(context, pollResponseType);
    }

    @Override
    public Mono<T> cancel(PollingContext<T> pollingContext, PollResponse<T> initialResponse) {
        return this.pollableStrategy.cancel(pollingContext, initialResponse);
    }
}

