/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.CgroupStats;
import org.opensearch.client.opensearch.nodes.stats.ExtendedMemoryStats;
import org.opensearch.client.opensearch.nodes.stats.MemoryStats;
import org.opensearch.client.opensearch.nodes.stats.OperatingSystemCpuStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class OperatingSystem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, OperatingSystem> {
    @Nullable
    private final CgroupStats cgroup;
    @Nullable
    private final OperatingSystemCpuStats cpu;
    @Nullable
    private final ExtendedMemoryStats mem;
    @Nullable
    private final MemoryStats swap;
    @Nullable
    private final Long timestamp;
    public static final JsonpDeserializer<OperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystem::setupOperatingSystemDeserializer);

    private OperatingSystem(Builder builder) {
        this.cgroup = builder.cgroup;
        this.cpu = builder.cpu;
        this.mem = builder.mem;
        this.swap = builder.swap;
        this.timestamp = builder.timestamp;
    }

    public static OperatingSystem of(Function<Builder, ObjectBuilder<OperatingSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CgroupStats cgroup() {
        return this.cgroup;
    }

    @Nullable
    public final OperatingSystemCpuStats cpu() {
        return this.cpu;
    }

    @Nullable
    public final ExtendedMemoryStats mem() {
        return this.mem;
    }

    @Nullable
    public final MemoryStats swap() {
        return this.swap;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cgroup != null) {
            generator.writeKey("cgroup");
            this.cgroup.serialize(generator, mapper);
        }
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.swap != null) {
            generator.writeKey("swap");
            this.swap.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupOperatingSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cgroup, CgroupStats._DESERIALIZER, "cgroup");
        op.add(Builder::cpu, OperatingSystemCpuStats._DESERIALIZER, "cpu");
        op.add(Builder::mem, ExtendedMemoryStats._DESERIALIZER, "mem");
        op.add(Builder::swap, MemoryStats._DESERIALIZER, "swap");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.cgroup);
        result = 31 * result + Objects.hashCode(this.cpu);
        result = 31 * result + Objects.hashCode(this.mem);
        result = 31 * result + Objects.hashCode(this.swap);
        result = 31 * result + Objects.hashCode(this.timestamp);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)o;
        return Objects.equals(this.cgroup, other.cgroup) && Objects.equals(this.cpu, other.cpu) && Objects.equals(this.mem, other.mem) && Objects.equals(this.swap, other.swap) && Objects.equals(this.timestamp, other.timestamp);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, OperatingSystem> {
        @Nullable
        private CgroupStats cgroup;
        @Nullable
        private OperatingSystemCpuStats cpu;
        @Nullable
        private ExtendedMemoryStats mem;
        @Nullable
        private MemoryStats swap;
        @Nullable
        private Long timestamp;

        public Builder() {
        }

        private Builder(OperatingSystem o) {
            this.cgroup = o.cgroup;
            this.cpu = o.cpu;
            this.mem = o.mem;
            this.swap = o.swap;
            this.timestamp = o.timestamp;
        }

        private Builder(Builder o) {
            this.cgroup = o.cgroup;
            this.cpu = o.cpu;
            this.mem = o.mem;
            this.swap = o.swap;
            this.timestamp = o.timestamp;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cgroup(@Nullable CgroupStats value) {
            this.cgroup = value;
            return this;
        }

        @Nonnull
        public final Builder cgroup(Function<CgroupStats.Builder, ObjectBuilder<CgroupStats>> fn) {
            return this.cgroup(fn.apply(new CgroupStats.Builder()).build());
        }

        @Nonnull
        public final Builder cpu(@Nullable OperatingSystemCpuStats value) {
            this.cpu = value;
            return this;
        }

        @Nonnull
        public final Builder cpu(Function<OperatingSystemCpuStats.Builder, ObjectBuilder<OperatingSystemCpuStats>> fn) {
            return this.cpu(fn.apply(new OperatingSystemCpuStats.Builder()).build());
        }

        @Nonnull
        public final Builder mem(@Nullable ExtendedMemoryStats value) {
            this.mem = value;
            return this;
        }

        @Nonnull
        public final Builder mem(Function<ExtendedMemoryStats.Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
            return this.mem(fn.apply(new ExtendedMemoryStats.Builder()).build());
        }

        @Nonnull
        public final Builder swap(@Nullable MemoryStats value) {
            this.swap = value;
            return this;
        }

        @Nonnull
        public final Builder swap(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.swap(fn.apply(new MemoryStats.Builder()).build());
        }

        @Nonnull
        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        @Nonnull
        public OperatingSystem build() {
            this._checkSingleUse();
            return new OperatingSystem(this);
        }
    }
}

