/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoBounds;
import org.opensearch.client.opensearch._types.GeoHashPrecision;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoHashGridAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, GeoHashGridAggregation> {
    @Nullable
    private final GeoBounds bounds;
    @Nullable
    private final String field;
    @Nullable
    private final GeoHashPrecision precision;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GeoHashGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoHashGridAggregation::setupGeoHashGridAggregationDeserializer);

    private GeoHashGridAggregation(Builder builder) {
        super(builder);
        this.bounds = builder.bounds;
        this.field = builder.field;
        this.precision = builder.precision;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
    }

    public static GeoHashGridAggregation of(Function<Builder, ObjectBuilder<GeoHashGridAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeohashGrid;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final GeoHashPrecision precision() {
        return this.precision;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            this.precision.serialize(generator, mapper);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoHashGridAggregationDeserializer(ObjectDeserializer<Builder> op) {
        GeoHashGridAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::precision, GeoHashPrecision._DESERIALIZER, "precision");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.bounds);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.precision);
        result = 31 * result + Objects.hashCode(this.shardSize);
        result = 31 * result + Objects.hashCode(this.size);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoHashGridAggregation other = (GeoHashGridAggregation)o;
        return Objects.equals(this.bounds, other.bounds) && Objects.equals(this.field, other.field) && Objects.equals(this.precision, other.precision) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.size, other.size);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoHashGridAggregation> {
        @Nullable
        private GeoBounds bounds;
        @Nullable
        private String field;
        @Nullable
        private GeoHashPrecision precision;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;

        public Builder() {
        }

        private Builder(GeoHashGridAggregation o) {
            super(o);
            this.bounds = o.bounds;
            this.field = o.field;
            this.precision = o.precision;
            this.shardSize = o.shardSize;
            this.size = o.size;
        }

        private Builder(Builder o) {
            super(o);
            this.bounds = o.bounds;
            this.field = o.field;
            this.precision = o.precision;
            this.shardSize = o.shardSize;
            this.size = o.size;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        @Nonnull
        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder precision(@Nullable GeoHashPrecision value) {
            this.precision = value;
            return this;
        }

        @Nonnull
        public final Builder precision(Function<GeoHashPrecision.Builder, ObjectBuilder<GeoHashPrecision>> fn) {
            return this.precision(fn.apply(new GeoHashPrecision.Builder()).build());
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoHashGridAggregation build() {
            this._checkSingleUse();
            return new GeoHashGridAggregation(this);
        }
    }
}

