/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input;

import java.util.Locale;
import java.util.Map;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.input.parameter.clustering.KMeansParams;
import org.opensearch.ml.common.input.parameter.rcf.BatchRCFParams;
import org.opensearch.ml.common.input.parameter.rcf.FitRCFParams;

public class InputHelper {
    public static String getAction(Map<String, Object> arguments) {
        return (String)arguments.get("action");
    }

    public static FunctionName getFunctionName(Map<String, Object> arguments) {
        String algo = (String)arguments.get("algorithm");
        if (algo == null) {
            throw new IllegalArgumentException("The parameter algorithm is required.");
        }
        switch (algo.toLowerCase(Locale.ROOT)) {
            case "kmeans": {
                return FunctionName.KMEANS;
            }
            case "rcf": {
                return arguments.get("timeField") == null ? FunctionName.BATCH_RCF : FunctionName.FIT_RCF;
            }
        }
        throw new IllegalArgumentException(String.format("unsupported algorithm: %s.", algo));
    }

    public static MLAlgoParams convertArgumentToMLParameter(Map<String, Object> arguments, FunctionName func) {
        switch (func) {
            case KMEANS: {
                return InputHelper.buildKMeansParameters(arguments);
            }
            case BATCH_RCF: {
                return InputHelper.buildBatchRCFParameters(arguments);
            }
            case FIT_RCF: {
                return InputHelper.buildFitRCFParameters(arguments);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported algorithm: %s.", new Object[]{func}));
    }

    private static MLAlgoParams buildKMeansParameters(Map<String, Object> arguments) {
        return KMeansParams.builder().centroids((Integer)arguments.get("centroid")).iterations((Integer)arguments.get("iteration")).distanceType(arguments.containsKey("distType") ? KMeansParams.DistanceType.valueOf(((String)arguments.get("distType")).toUpperCase(Locale.ROOT)) : null).build();
    }

    private static MLAlgoParams buildBatchRCFParameters(Map<String, Object> arguments) {
        return BatchRCFParams.builder().numberOfTrees((Integer)arguments.get("numberTrees")).sampleSize((Integer)arguments.get("sampleSize")).outputAfter((Integer)arguments.get("outputAfter")).trainingDataSize((Integer)arguments.get("trainingDataSize")).anomalyScoreThreshold((Double)arguments.get("anomalyScoreThreshold")).build();
    }

    private static MLAlgoParams buildFitRCFParameters(Map<String, Object> arguments) {
        return FitRCFParams.builder().numberOfTrees((Integer)arguments.get("numberTrees")).shingleSize((Integer)arguments.get("shingleSize")).sampleSize((Integer)arguments.get("sampleSize")).outputAfter((Integer)arguments.get("outputAfter")).timeDecay((Double)arguments.get("timeDecay")).anomalyRate((Double)arguments.get("anomalyRate")).timeField((String)arguments.get("timeField")).dateFormat(arguments.containsKey("dateFormat") ? (String)arguments.get("dateFormat") : "yyyy-MM-dd HH:mm:ss").timeZone((String)arguments.get("timeZone")).build();
    }
}

