"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiCheckableCard", {
  enumerable: true,
  get: function get() {
    return _checkable_card.EuiCheckableCard;
  }
});
exports.OuiCheckableCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form = require("../../form");
var _panel = require("../../panel");
var _checkable_card = require("../../../eui_components/card/checkable_card/checkable_card");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// if `checkableType` is left out or set to 'radio', use OuiRadioProps

// if `checkableType` is set to 'checkbox', use OuiCheckboxProps

var OuiCheckableCard = function OuiCheckableCard(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$checkableType = _ref.checkableType,
    checkableType = _ref$checkableType === void 0 ? 'radio' : _ref$checkableType,
    label = _ref.label,
    checked = _ref.checked,
    disabled = _ref.disabled,
    hasShadow = _ref.hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? true : _ref$hasBorder,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "checkableType", "label", "checked", "disabled", "hasShadow", "hasBorder"]);
  var id = rest.id;
  var labelEl = (0, _react.useRef)(null);
  var classes = (0, _classnames.default)('ouiCheckableCard', {
    'ouiCheckableCard-isChecked': checked,
    'ouiCheckableCard-isDisabled': disabled
  }, className);
  var checkableElement;
  if (checkableType === 'radio') {
    checkableElement = /*#__PURE__*/_react.default.createElement(_form.OuiRadio, (0, _extends2.default)({
      checked: checked,
      disabled: disabled
    }, rest));
  } else {
    checkableElement = /*#__PURE__*/_react.default.createElement(_form.OuiCheckbox, (0, _extends2.default)({
      checked: checked,
      disabled: disabled
    }, rest));
  }
  var labelClasses = (0, _classnames.default)('ouiCheckableCard__label', {
    'ouiCheckableCard__label-isDisabled': disabled
  });
  var onChangeAffordance = function onChangeAffordance() {
    if (labelEl.current) {
      labelEl.current.click();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_panel.OuiSplitPanel.Outer, {
    responsive: false,
    hasShadow: hasShadow,
    hasBorder: hasBorder,
    direction: "row",
    className: classes
  }, /*#__PURE__*/_react.default.createElement(_panel.OuiSplitPanel.Inner, {
    // Bubbles up the change event when clicking on the whole div for extra affordance
    onClick: disabled ? undefined : onChangeAffordance,
    color: checked ? 'primary' : 'subdued',
    grow: false
  }, checkableElement), /*#__PURE__*/_react.default.createElement(_panel.OuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement("label", {
    ref: labelEl,
    className: labelClasses,
    htmlFor: id,
    "aria-describedby": children ? "".concat(id, "-details") : undefined
  }, label), children && /*#__PURE__*/_react.default.createElement("div", {
    id: "".concat(id, "-details"),
    className: "ouiCheckableCard__children"
  }, children)));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiCheckableCard = OuiCheckableCard;
OuiCheckableCard.propTypes = {
  id: _propTypes.default.string.isRequired,
  label: _propTypes.default.node.isRequired,
  hasShadow: _propTypes.default.any,
  hasBorder: _propTypes.default.any
};
/* OUI -> EUI Aliases: Build-Time */