/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.IOException;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.http.MVHttpClient;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FileSize {
    public static final int ONE_MiB = 1000000;
    public static final byte INVALID_SIZE = -1;
    private static final Logger logger = LogManager.getLogger();

    @NotNull
    public static String getFileLengthFromUrl(@NotNull String url) {
        String groesseStr = "";
        HttpUrl okUrl = HttpUrl.parse((String)url);
        if (okUrl != null) {
            long l = FileSize.getFileSizeFromUrl(okUrl);
            groesseStr = FileSize.convertSize(l);
        }
        return groesseStr;
    }

    @NotNull
    public static String convertSize(long byteLength) {
        String ret = "";
        if (byteLength > 1000000L) {
            ret = String.valueOf(byteLength / 1000000L);
        } else if (byteLength > 0L) {
            ret = "1";
        }
        return ret;
    }

    public static long getContentLength(@NotNull Response response) {
        String sizeStr = response.headers().get("Content-Length");
        long respLength = -1L;
        if (sizeStr != null) {
            try {
                respLength = Long.parseLong(sizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return respLength;
    }

    public static long getFileSizeFromUrl(@NotNull HttpUrl url) {
        if (!url.scheme().startsWith("http") || url.encodedPath().endsWith(".m3u8")) {
            return -1L;
        }
        Request request = new Request.Builder().url(url).head().build();
        long respLength = -1L;
        boolean fetchSize = ApplicationConfiguration.getConfiguration().getBoolean("download.fetch_file_size", true);
        if (fetchSize) {
            logger.info("Requesting file size for: {}", (Object)url);
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();){
                if (response.isSuccessful()) {
                    respLength = FileSize.getContentLength(response);
                }
            }
            catch (IOException iOException) {}
        } else {
            logger.info("Skipping file size request due to user setting");
        }
        if (respLength < 1000000L) {
            respLength = -1L;
        }
        return respLength;
    }
}

