/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.SecurityActions;
import org.jboss.logmanager.handlers.SuffixRotator;

public class PeriodicRotatingFileHandler
extends FileHandler {
    private final AccessControlContext acc = AccessController.getContext();
    private DateTimeFormatter format;
    private String nextSuffix;
    private Period period = Period.NEVER;
    private Instant nextRollover = Instant.MAX;
    private TimeZone timeZone = TimeZone.getDefault();
    private SuffixRotator suffixRotator = SuffixRotator.EMPTY;

    public PeriodicRotatingFileHandler() {
    }

    public PeriodicRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public PeriodicRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public PeriodicRotatingFileHandler(File file, String suffix) throws FileNotFoundException {
        super(file);
        this.setSuffix(suffix);
    }

    public PeriodicRotatingFileHandler(File file, String suffix, boolean append) throws FileNotFoundException {
        super(file, append);
        this.setSuffix(suffix);
    }

    @Override
    public void setFile(File file) throws FileNotFoundException {
        this.lock.lock();
        try {
            super.setFile(file);
            if (this.format != null && file != null && file.lastModified() > 0L) {
                this.calcNextRollover(Instant.ofEpochMilli(file.lastModified()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void preWrite(ExtLogRecord record) {
        Instant recordInstant = record.getInstant();
        if (!recordInstant.isBefore(this.nextRollover)) {
            this.rollOver();
            this.calcNextRollover(recordInstant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuffix(String suffix) throws IllegalArgumentException {
        SuffixRotator suffixRotator = SuffixRotator.parse(this.acc, suffix);
        String dateSuffix = suffixRotator.getDatePattern();
        DateTimeFormatter format = DateTimeFormatter.ofPattern(dateSuffix).withZone(this.timeZone.toZoneId());
        int len = dateSuffix.length();
        Period period = Period.NEVER;
        block14: for (int i = 0; i < len; ++i) {
            switch (dateSuffix.charAt(i)) {
                case 'y': {
                    period = PeriodicRotatingFileHandler.min(period, Period.YEAR);
                    continue block14;
                }
                case 'M': {
                    period = PeriodicRotatingFileHandler.min(period, Period.MONTH);
                    continue block14;
                }
                case 'W': 
                case 'w': {
                    period = PeriodicRotatingFileHandler.min(period, Period.WEEK);
                    continue block14;
                }
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': {
                    period = PeriodicRotatingFileHandler.min(period, Period.DAY);
                    continue block14;
                }
                case 'a': {
                    period = PeriodicRotatingFileHandler.min(period, Period.HALF_DAY);
                    continue block14;
                }
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    period = PeriodicRotatingFileHandler.min(period, Period.HOUR);
                    continue block14;
                }
                case 'm': {
                    period = PeriodicRotatingFileHandler.min(period, Period.MINUTE);
                    continue block14;
                }
                case '\'': {
                    while (dateSuffix.charAt(++i) != '\'') {
                    }
                    continue block14;
                }
                case 'S': 
                case 's': {
                    throw new IllegalArgumentException("Rotating by second or millisecond is not supported");
                }
            }
        }
        this.lock.lock();
        try {
            this.format = format;
            this.period = period;
            this.suffixRotator = suffixRotator;
            File file = this.getFile();
            Instant now = file != null && file.lastModified() > 0L ? Instant.ofEpochMilli(file.lastModified()) : Instant.now();
            this.calcNextRollover(now);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final String getNextSuffix() {
        return this.nextSuffix;
    }

    SuffixRotator getSuffixRotator() {
        return this.suffixRotator;
    }

    private void rollOver() {
        try {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            this.setFileInternal(null);
            this.suffixRotator.rotate(SecurityActions.getErrorManager(this.acc, this), file.toPath(), this.nextSuffix);
            this.setFileInternal(file);
        }
        catch (IOException e) {
            this.reportError("Unable to rotate log file", e, 4);
        }
    }

    private void calcNextRollover(Instant fromTime) {
        if (this.period == Period.NEVER) {
            this.nextRollover = Instant.MAX;
            return;
        }
        ZonedDateTime zdt = ZonedDateTime.ofInstant(fromTime, this.timeZone.toZoneId());
        this.nextSuffix = zdt.format(this.format);
        Period period = this.period;
        switch (period.ordinal()) {
            default: {
                zdt = zdt.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS).plusYears(1L);
                break;
            }
            case 5: {
                zdt = zdt.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).plusMonths(1L);
                break;
            }
            case 4: {
                zdt = zdt.with(ChronoField.DAY_OF_WEEK, 1L).truncatedTo(ChronoUnit.DAYS).plusWeeks(1L);
                break;
            }
            case 3: {
                zdt = zdt.truncatedTo(ChronoUnit.DAYS).plusDays(1L);
                break;
            }
            case 2: {
                zdt = zdt.truncatedTo(ChronoUnit.HALF_DAYS).plusHours(12L);
                break;
            }
            case 1: {
                zdt = zdt.truncatedTo(ChronoUnit.HOURS).plusHours(1L);
                break;
            }
            case 0: {
                zdt = zdt.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L);
            }
        }
        this.nextRollover = zdt.toInstant();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone is null");
        }
        this.timeZone = timeZone;
    }

    private void setFileInternal(File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            super.setFile(file);
        } else {
            AccessController.doPrivileged(() -> {
                try {
                    super.setFile(file);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
                return null;
            }, this.acc);
        }
    }

    private static <T extends Comparable<? super T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static enum Period {
        MINUTE,
        HOUR,
        HALF_DAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NEVER;

    }
}

