/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.raft.KafkaMetadataLog;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaMetadataLog$
implements Logging {
    public static final KafkaMetadataLog$ MODULE$ = new KafkaMetadataLog$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config, int nodeId) {
        Properties props = new Properties();
        props.setProperty("max.message.bytes", Integer.toString(config.internalMaxBatchSizeInBytes()));
        if (config.internalSegmentBytes() != null) {
            props.setProperty("internal.segment.bytes", config.internalSegmentBytes().toString());
        } else {
            props.setProperty("segment.bytes", Integer.toString(config.logSegmentBytes()));
        }
        props.setProperty("segment.ms", Long.toString(config.logSegmentMillis()));
        props.setProperty("file.delete.delay.ms", Long.toString(60000L));
        props.setProperty("retention.ms", "-1");
        props.setProperty("retention.bytes", "-1");
        LogConfig.validate((Properties)props);
        LogConfig defaultLogConfig = new LogConfig((Map)props);
        if (defaultLogConfig.retentionMs >= 0L) {
            throw new InvalidConfigurationException("Cannot set retention.ms above -1: " + defaultLogConfig.retentionMs + ".");
        }
        if (defaultLogConfig.retentionSize >= 0L) {
            throw new InvalidConfigurationException("Cannot set retention.bytes above -1: " + defaultLogConfig.retentionSize + ".");
        }
        UnifiedLog log = UnifiedLog.create((File)dataDir, (LogConfig)defaultLogConfig, (long)0L, (long)0L, (Scheduler)scheduler, (BrokerTopicStats)new BrokerTopicStats(), (Time)time, (int)Integer.MAX_VALUE, (ProducerStateManagerConfig)new ProducerStateManagerConfig(Integer.MAX_VALUE, false), (int)Integer.MAX_VALUE, (LogDirFailureChannel)new LogDirFailureChannel(5), (boolean)false, Optional.of(topicId));
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log), topicPartition, config, nodeId);
        if (defaultLogConfig.segmentSize() < config.logSegmentBytes() && metadataLog.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = "Overriding internal.metadata.log.segment.bytes is only supported for testing. Setting this value too low may lead to an inability to write batches of metadata records.";
            Object var12_12 = null;
            metadataLog.logger().underlying().error(Logging.msgWithLogIdent$(metadataLog, msgWithLogIdent_msg));
        }
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> recoverSnapshots(UnifiedLog log) {
        TreeMap snapshotsToRetain = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Buffer snapshotsToDelete = (Buffer)Buffer$.MODULE$.empty();
        try (DirectoryStream<Path> filesInDir = Files.newDirectoryStream(log.dir().toPath());){
            Option latestSnapshotId;
            filesInDir.forEach(path -> Snapshots.parse((Path)path).ifPresent(snapshotPath -> {
                if (snapshotPath.partial() || snapshotPath.deleted() || snapshotPath.snapshotId().offset() < log.logStartOffset()) {
                    snapshotsToDelete.append(snapshotPath);
                    return;
                }
                snapshotsToRetain.put((Object)snapshotPath.snapshotId(), (Object)None$.MODULE$);
            }));
            if (log.logStartOffset() > 0L && !(latestSnapshotId = snapshotsToRetain.lastOption().map((Function1 & Serializable)x$4 -> (OffsetAndEpoch)x$4._1())).exists((Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$recoverSnapshots$4(log, snapshotId)))) {
                throw new IllegalStateException("Inconsistent snapshot state: there must be a snapshot at an offset larger then the current log start offset " + log.logStartOffset() + ", but the latest snapshot is " + latestSnapshotId);
            }
            snapshotsToDelete.foreach((Function1 & Serializable)snapshotPath -> {
                KafkaMetadataLog$.$anonfun$recoverSnapshots$5(snapshotPath);
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$recoverSnapshots$7(snapshotsToRetain, log);
            Object var7_7 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return snapshotsToRetain;
    }

    public void kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(Path logDir, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$1(logDir, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$apply$1() {
        return "Overriding internal.metadata.log.segment.bytes is only supported for testing. Setting this value too low may lead to an inability to write batches of metadata records.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverSnapshots$4(UnifiedLog log$1, OffsetAndEpoch snapshotId) {
        return snapshotId.offset() >= log$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$6(SnapshotPath snapshotPath$1) {
        return "Deleted unneeded snapshot file with path " + snapshotPath$1;
    }

    public static final /* synthetic */ void $anonfun$recoverSnapshots$5(SnapshotPath snapshotPath) {
        Files.deleteIfExists(snapshotPath.path());
        KafkaMetadataLog$ info_this = MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$recoverSnapshots$6(snapshotPath);
            Object var2_2 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$7(TreeMap snapshotsToRetain$1, UnifiedLog log$1) {
        return "Initialized snapshots with IDs " + snapshotsToRetain$1.keys() + " from " + log$1.dir();
    }

    public static final /* synthetic */ void $anonfun$deleteSnapshotFiles$2(FileRawSnapshotReader reader) {
        Utils.closeQuietly((AutoCloseable)reader, (String)"FileRawSnapshotReader");
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$1(Path logDir$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
            ((Option)x0$1._2()).foreach((Function1 & Serializable)reader -> {
                KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$2(reader);
                return BoxedUnit.UNIT;
            });
            return Snapshots.deleteIfExists((Path)logDir$1, (OffsetAndEpoch)snapshotId);
        }
        throw new MatchError(null);
    }

    private KafkaMetadataLog$() {
    }
}

